"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TransitSecretBackendKey = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key vault_transit_secret_backend_key}
*/
class TransitSecretBackendKey extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_backend_key vault_transit_secret_backend_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TransitSecretBackendKeyConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'vault_transit_secret_backend_key',
            terraformGeneratorMetadata: {
                providerName: 'vault',
                providerVersion: '3.10.0',
                providerVersionConstraint: '~> 3.7'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle,
            provisioners: config.provisioners,
            connection: config.connection,
            forEach: config.forEach
        });
        // keys - computed: true, optional: false, required: false
        this._keys = new cdktf.StringMapList(this, "keys", false);
        this._allowPlaintextBackup = config.allowPlaintextBackup;
        this._autoRotateInterval = config.autoRotateInterval;
        this._autoRotatePeriod = config.autoRotatePeriod;
        this._backend = config.backend;
        this._convergentEncryption = config.convergentEncryption;
        this._deletionAllowed = config.deletionAllowed;
        this._derived = config.derived;
        this._exportable = config.exportable;
        this._id = config.id;
        this._minDecryptionVersion = config.minDecryptionVersion;
        this._minEncryptionVersion = config.minEncryptionVersion;
        this._name = config.name;
        this._namespace = config.namespace;
        this._type = config.type;
    }
    get allowPlaintextBackup() {
        return this.getBooleanAttribute('allow_plaintext_backup');
    }
    set allowPlaintextBackup(value) {
        this._allowPlaintextBackup = value;
    }
    resetAllowPlaintextBackup() {
        this._allowPlaintextBackup = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowPlaintextBackupInput() {
        return this._allowPlaintextBackup;
    }
    get autoRotateInterval() {
        return this.getNumberAttribute('auto_rotate_interval');
    }
    set autoRotateInterval(value) {
        this._autoRotateInterval = value;
    }
    resetAutoRotateInterval() {
        this._autoRotateInterval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoRotateIntervalInput() {
        return this._autoRotateInterval;
    }
    get autoRotatePeriod() {
        return this.getNumberAttribute('auto_rotate_period');
    }
    set autoRotatePeriod(value) {
        this._autoRotatePeriod = value;
    }
    resetAutoRotatePeriod() {
        this._autoRotatePeriod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get autoRotatePeriodInput() {
        return this._autoRotatePeriod;
    }
    get backend() {
        return this.getStringAttribute('backend');
    }
    set backend(value) {
        this._backend = value;
    }
    // Temporarily expose input value. Use with caution.
    get backendInput() {
        return this._backend;
    }
    get convergentEncryption() {
        return this.getBooleanAttribute('convergent_encryption');
    }
    set convergentEncryption(value) {
        this._convergentEncryption = value;
    }
    resetConvergentEncryption() {
        this._convergentEncryption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get convergentEncryptionInput() {
        return this._convergentEncryption;
    }
    get deletionAllowed() {
        return this.getBooleanAttribute('deletion_allowed');
    }
    set deletionAllowed(value) {
        this._deletionAllowed = value;
    }
    resetDeletionAllowed() {
        this._deletionAllowed = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deletionAllowedInput() {
        return this._deletionAllowed;
    }
    get derived() {
        return this.getBooleanAttribute('derived');
    }
    set derived(value) {
        this._derived = value;
    }
    resetDerived() {
        this._derived = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get derivedInput() {
        return this._derived;
    }
    get exportable() {
        return this.getBooleanAttribute('exportable');
    }
    set exportable(value) {
        this._exportable = value;
    }
    resetExportable() {
        this._exportable = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get exportableInput() {
        return this._exportable;
    }
    get id() {
        return this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    resetId() {
        this._id = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get idInput() {
        return this._id;
    }
    get keys() {
        return this._keys;
    }
    // latest_version - computed: true, optional: false, required: false
    get latestVersion() {
        return this.getNumberAttribute('latest_version');
    }
    // min_available_version - computed: true, optional: false, required: false
    get minAvailableVersion() {
        return this.getNumberAttribute('min_available_version');
    }
    get minDecryptionVersion() {
        return this.getNumberAttribute('min_decryption_version');
    }
    set minDecryptionVersion(value) {
        this._minDecryptionVersion = value;
    }
    resetMinDecryptionVersion() {
        this._minDecryptionVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minDecryptionVersionInput() {
        return this._minDecryptionVersion;
    }
    get minEncryptionVersion() {
        return this.getNumberAttribute('min_encryption_version');
    }
    set minEncryptionVersion(value) {
        this._minEncryptionVersion = value;
    }
    resetMinEncryptionVersion() {
        this._minEncryptionVersion = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get minEncryptionVersionInput() {
        return this._minEncryptionVersion;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get namespace() {
        return this.getStringAttribute('namespace');
    }
    set namespace(value) {
        this._namespace = value;
    }
    resetNamespace() {
        this._namespace = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get namespaceInput() {
        return this._namespace;
    }
    // supports_decryption - computed: true, optional: false, required: false
    get supportsDecryption() {
        return this.getBooleanAttribute('supports_decryption');
    }
    // supports_derivation - computed: true, optional: false, required: false
    get supportsDerivation() {
        return this.getBooleanAttribute('supports_derivation');
    }
    // supports_encryption - computed: true, optional: false, required: false
    get supportsEncryption() {
        return this.getBooleanAttribute('supports_encryption');
    }
    // supports_signing - computed: true, optional: false, required: false
    get supportsSigning() {
        return this.getBooleanAttribute('supports_signing');
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            allow_plaintext_backup: cdktf.booleanToTerraform(this._allowPlaintextBackup),
            auto_rotate_interval: cdktf.numberToTerraform(this._autoRotateInterval),
            auto_rotate_period: cdktf.numberToTerraform(this._autoRotatePeriod),
            backend: cdktf.stringToTerraform(this._backend),
            convergent_encryption: cdktf.booleanToTerraform(this._convergentEncryption),
            deletion_allowed: cdktf.booleanToTerraform(this._deletionAllowed),
            derived: cdktf.booleanToTerraform(this._derived),
            exportable: cdktf.booleanToTerraform(this._exportable),
            id: cdktf.stringToTerraform(this._id),
            min_decryption_version: cdktf.numberToTerraform(this._minDecryptionVersion),
            min_encryption_version: cdktf.numberToTerraform(this._minEncryptionVersion),
            name: cdktf.stringToTerraform(this._name),
            namespace: cdktf.stringToTerraform(this._namespace),
            type: cdktf.stringToTerraform(this._type),
        };
    }
}
exports.TransitSecretBackendKey = TransitSecretBackendKey;
_a = JSII_RTTI_SYMBOL_1;
TransitSecretBackendKey[_a] = { fqn: "@cdktf/provider-vault.transitSecretBackendKey.TransitSecretBackendKey", version: "3.0.14" };
// =================
// STATIC PROPERTIES
// =================
TransitSecretBackendKey.tfResourceType = "vault_transit_secret_backend_key";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvdHJhbnNpdC1zZWNyZXQtYmFja2VuZC1rZXkvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFJQSwrQkFBK0I7QUE0Ri9COztFQUVFO0FBQ0YsTUFBYSx1QkFBd0IsU0FBUSxLQUFLLENBQUMsaUJBQWlCO0lBT2xFLGNBQWM7SUFDZCxjQUFjO0lBQ2QsY0FBYztJQUVkOzs7Ozs7TUFNRTtJQUNGLFlBQW1CLEtBQWdCLEVBQUUsRUFBVSxFQUFFLE1BQXFDO1FBQ3BGLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YscUJBQXFCLEVBQUUsa0NBQWtDO1lBQ3pELDBCQUEwQixFQUFFO2dCQUMxQixZQUFZLEVBQUUsT0FBTztnQkFDckIsZUFBZSxFQUFFLFFBQVE7Z0JBQ3pCLHlCQUF5QixFQUFFLFFBQVE7YUFDcEM7WUFDRCxRQUFRLEVBQUUsTUFBTSxDQUFDLFFBQVE7WUFDekIsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLEtBQUssRUFBRSxNQUFNLENBQUMsS0FBSztZQUNuQixTQUFTLEVBQUUsTUFBTSxDQUFDLFNBQVM7WUFDM0IsWUFBWSxFQUFFLE1BQU0sQ0FBQyxZQUFZO1lBQ2pDLFVBQVUsRUFBRSxNQUFNLENBQUMsVUFBVTtZQUM3QixPQUFPLEVBQUUsTUFBTSxDQUFDLE9BQU87U0FDeEIsQ0FBQyxDQUFDO1FBa0tMLDBEQUEwRDtRQUNsRCxVQUFLLEdBQUcsSUFBSSxLQUFLLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFsSzNELElBQUksQ0FBQyxxQkFBcUIsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7UUFDekQsSUFBSSxDQUFDLG1CQUFtQixHQUFHLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQztRQUNyRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsTUFBTSxDQUFDLGdCQUFnQixDQUFDO1FBQ2pELElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMscUJBQXFCLEdBQUcsTUFBTSxDQUFDLG9CQUFvQixDQUFDO1FBQ3pELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxNQUFNLENBQUMsZUFBZSxDQUFDO1FBQy9DLElBQUksQ0FBQyxRQUFRLEdBQUcsTUFBTSxDQUFDLE9BQU8sQ0FBQztRQUMvQixJQUFJLENBQUMsV0FBVyxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUM7UUFDckMsSUFBSSxDQUFDLEdBQUcsR0FBRyxNQUFNLENBQUMsRUFBRSxDQUFDO1FBQ3JCLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxNQUFNLENBQUMsb0JBQW9CLENBQUM7UUFDekQsSUFBSSxDQUFDLHFCQUFxQixHQUFHLE1BQU0sQ0FBQyxvQkFBb0IsQ0FBQztRQUN6RCxJQUFJLENBQUMsS0FBSyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUM7UUFDekIsSUFBSSxDQUFDLFVBQVUsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDO1FBQ25DLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxDQUFDLElBQUksQ0FBQztJQUMzQixDQUFDO0lBUUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUM1RCxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUFrQztRQUNoRSxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO0lBQ3JDLENBQUM7SUFDTSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztJQUN6QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxzQkFBc0IsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFDRCxJQUFXLGtCQUFrQixDQUFDLEtBQWE7UUFDekMsSUFBSSxDQUFDLG1CQUFtQixHQUFHLEtBQUssQ0FBQztJQUNuQyxDQUFDO0lBQ00sdUJBQXVCO1FBQzVCLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxTQUFTLENBQUM7SUFDdkMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHVCQUF1QjtRQUNoQyxPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQztJQUNsQyxDQUFDO0lBSUQsSUFBVyxnQkFBZ0I7UUFDekIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsb0JBQW9CLENBQUMsQ0FBQztJQUN2RCxDQUFDO0lBQ0QsSUFBVyxnQkFBZ0IsQ0FBQyxLQUFhO1FBQ3ZDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUM7SUFDakMsQ0FBQztJQUNNLHFCQUFxQjtRQUMxQixJQUFJLENBQUMsaUJBQWlCLEdBQUcsU0FBUyxDQUFDO0lBQ3JDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxxQkFBcUI7UUFDOUIsT0FBTyxJQUFJLENBQUMsaUJBQWlCLENBQUM7SUFDaEMsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM1QyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBYTtRQUM5QixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQztJQUN4QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsWUFBWTtRQUNyQixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUM7SUFDdkIsQ0FBQztJQUlELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHVCQUF1QixDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUNELElBQVcsb0JBQW9CLENBQUMsS0FBa0M7UUFDaEUsSUFBSSxDQUFDLHFCQUFxQixHQUFHLEtBQUssQ0FBQztJQUNyQyxDQUFDO0lBQ00seUJBQXlCO1FBQzlCLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxTQUFTLENBQUM7SUFDekMsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLHlCQUF5QjtRQUNsQyxPQUFPLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztJQUNwQyxDQUFDO0lBSUQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLGtCQUFrQixDQUFDLENBQUM7SUFDdEQsQ0FBQztJQUNELElBQVcsZUFBZSxDQUFDLEtBQWtDO1FBQzNELElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxLQUFLLENBQUM7SUFDaEMsQ0FBQztJQUNNLG9CQUFvQjtRQUN6QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsU0FBUyxDQUFDO0lBQ3BDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsZ0JBQWdCLENBQUM7SUFDL0IsQ0FBQztJQUlELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBQ0QsSUFBVyxPQUFPLENBQUMsS0FBa0M7UUFDbkQsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7SUFDeEIsQ0FBQztJQUNNLFlBQVk7UUFDakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxTQUFTLENBQUM7SUFDNUIsQ0FBQztJQUNELG9EQUFvRDtJQUNwRCxJQUFXLFlBQVk7UUFDckIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFJRCxJQUFXLFVBQVU7UUFDbkIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsWUFBWSxDQUFDLENBQUM7SUFDaEQsQ0FBQztJQUNELElBQVcsVUFBVSxDQUFDLEtBQWtDO1FBQ3RELElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO0lBQzNCLENBQUM7SUFDTSxlQUFlO1FBQ3BCLElBQUksQ0FBQyxXQUFXLEdBQUcsU0FBUyxDQUFDO0lBQy9CLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyxlQUFlO1FBQ3hCLE9BQU8sSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUMxQixDQUFDO0lBSUQsSUFBVyxFQUFFO1FBQ1gsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkMsQ0FBQztJQUNELElBQVcsRUFBRSxDQUFDLEtBQWE7UUFDekIsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUM7SUFDbkIsQ0FBQztJQUNNLE9BQU87UUFDWixJQUFJLENBQUMsR0FBRyxHQUFHLFNBQVMsQ0FBQztJQUN2QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsT0FBTztRQUNoQixPQUFPLElBQUksQ0FBQyxHQUFHLENBQUM7SUFDbEIsQ0FBQztJQUlELElBQVcsSUFBSTtRQUNiLE9BQU8sSUFBSSxDQUFDLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBRUQsb0VBQW9FO0lBQ3BFLElBQVcsYUFBYTtRQUN0QixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBQ25ELENBQUM7SUFFRCwyRUFBMkU7SUFDM0UsSUFBVyxtQkFBbUI7UUFDNUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUMxRCxDQUFDO0lBSUQsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsd0JBQXdCLENBQUMsQ0FBQztJQUMzRCxDQUFDO0lBQ0QsSUFBVyxvQkFBb0IsQ0FBQyxLQUFhO1FBQzNDLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxLQUFLLENBQUM7SUFDckMsQ0FBQztJQUNNLHlCQUF5QjtRQUM5QixJQUFJLENBQUMscUJBQXFCLEdBQUcsU0FBUyxDQUFDO0lBQ3pDLENBQUM7SUFDRCxvREFBb0Q7SUFDcEQsSUFBVyx5QkFBeUI7UUFDbEMsT0FBTyxJQUFJLENBQUMscUJBQXFCLENBQUM7SUFDcEMsQ0FBQztJQUlELElBQVcsb0JBQW9CO1FBQzdCLE9BQU8sSUFBSSxDQUFDLGtCQUFrQixDQUFDLHdCQUF3QixDQUFDLENBQUM7SUFDM0QsQ0FBQztJQUNELElBQVcsb0JBQW9CLENBQUMsS0FBYTtRQUMzQyxJQUFJLENBQUMscUJBQXFCLEdBQUcsS0FBSyxDQUFDO0lBQ3JDLENBQUM7SUFDTSx5QkFBeUI7UUFDOUIsSUFBSSxDQUFDLHFCQUFxQixHQUFHLFNBQVMsQ0FBQztJQUN6QyxDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcseUJBQXlCO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLHFCQUFxQixDQUFDO0lBQ3BDLENBQUM7SUFJRCxJQUFXLElBQUk7UUFDYixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN6QyxDQUFDO0lBQ0QsSUFBVyxJQUFJLENBQUMsS0FBYTtRQUMzQixJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztJQUNyQixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUlELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxXQUFXLENBQUMsQ0FBQztJQUM5QyxDQUFDO0lBQ0QsSUFBVyxTQUFTLENBQUMsS0FBYTtRQUNoQyxJQUFJLENBQUMsVUFBVSxHQUFHLEtBQUssQ0FBQztJQUMxQixDQUFDO0lBQ00sY0FBYztRQUNuQixJQUFJLENBQUMsVUFBVSxHQUFHLFNBQVMsQ0FBQztJQUM5QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsY0FBYztRQUN2QixPQUFPLElBQUksQ0FBQyxVQUFVLENBQUM7SUFDekIsQ0FBQztJQUVELHlFQUF5RTtJQUN6RSxJQUFXLGtCQUFrQjtRQUMzQixPQUFPLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxxQkFBcUIsQ0FBQyxDQUFDO0lBQ3pELENBQUM7SUFFRCx5RUFBeUU7SUFDekUsSUFBVyxrQkFBa0I7UUFDM0IsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMscUJBQXFCLENBQUMsQ0FBQztJQUN6RCxDQUFDO0lBRUQseUVBQXlFO0lBQ3pFLElBQVcsa0JBQWtCO1FBQzNCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFDekQsQ0FBQztJQUVELHNFQUFzRTtJQUN0RSxJQUFXLGVBQWU7UUFDeEIsT0FBTyxJQUFJLENBQUMsbUJBQW1CLENBQUMsa0JBQWtCLENBQUMsQ0FBQztJQUN0RCxDQUFDO0lBSUQsSUFBVyxJQUFJO1FBQ2IsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUMsTUFBTSxDQUFDLENBQUM7SUFDekMsQ0FBQztJQUNELElBQVcsSUFBSSxDQUFDLEtBQWE7UUFDM0IsSUFBSSxDQUFDLEtBQUssR0FBRyxLQUFLLENBQUM7SUFDckIsQ0FBQztJQUNNLFNBQVM7UUFDZCxJQUFJLENBQUMsS0FBSyxHQUFHLFNBQVMsQ0FBQztJQUN6QixDQUFDO0lBQ0Qsb0RBQW9EO0lBQ3BELElBQVcsU0FBUztRQUNsQixPQUFPLElBQUksQ0FBQyxLQUFLLENBQUM7SUFDcEIsQ0FBQztJQUVELFlBQVk7SUFDWixZQUFZO0lBQ1osWUFBWTtJQUVGLG9CQUFvQjtRQUM1QixPQUFPO1lBQ0wsc0JBQXNCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztZQUM1RSxvQkFBb0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLG1CQUFtQixDQUFDO1lBQ3ZFLGtCQUFrQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7WUFDbkUsT0FBTyxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDO1lBQy9DLHFCQUFxQixFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUM7WUFDM0UsZ0JBQWdCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQztZQUNqRSxPQUFPLEVBQUUsS0FBSyxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7WUFDaEQsVUFBVSxFQUFFLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDO1lBQ3RELEVBQUUsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQztZQUNyQyxzQkFBc0IsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDO1lBQzNFLHNCQUFzQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUM7WUFDM0UsSUFBSSxFQUFFLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDO1lBQ3pDLFNBQVMsRUFBRSxLQUFLLENBQUMsaUJBQWlCLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQztZQUNuRCxJQUFJLEVBQUUsS0FBSyxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFLLENBQUM7U0FDMUMsQ0FBQztJQUNKLENBQUM7O0FBelVILDBEQTBVQzs7O0FBeFVDLG9CQUFvQjtBQUNwQixvQkFBb0I7QUFDcEIsb0JBQW9CO0FBQ0csc0NBQWMsR0FBRyxrQ0FBa0MsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL3RyYW5zaXRfc2VjcmV0X2JhY2tlbmRfa2V5XG4vLyBnZW5lcmF0ZWQgZnJvbSB0ZXJyYWZvcm0gcmVzb3VyY2Ugc2NoZW1hXG5cbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0ICogYXMgY2RrdGYgZnJvbSAnY2RrdGYnO1xuXG4vLyBDb25maWd1cmF0aW9uXG5cbmV4cG9ydCBpbnRlcmZhY2UgVHJhbnNpdFNlY3JldEJhY2tlbmRLZXlDb25maWcgZXh0ZW5kcyBjZGt0Zi5UZXJyYWZvcm1NZXRhQXJndW1lbnRzIHtcbiAgLyoqXG4gICogSWYgc2V0LCBlbmFibGVzIHRha2luZyBiYWNrdXAgb2YgbmFtZWQga2V5IGluIHRoZSBwbGFpbnRleHQgZm9ybWF0LiBPbmNlIHNldCwgdGhpcyBjYW5ub3QgYmUgZGlzYWJsZWQuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci90cmFuc2l0X3NlY3JldF9iYWNrZW5kX2tleSNhbGxvd19wbGFpbnRleHRfYmFja3VwIFRyYW5zaXRTZWNyZXRCYWNrZW5kS2V5I2FsbG93X3BsYWludGV4dF9iYWNrdXB9XG4gICovXG4gIHJlYWRvbmx5IGFsbG93UGxhaW50ZXh0QmFja3VwPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBBbW91bnQgb2YgdGltZSB0aGUga2V5IHNob3VsZCBsaXZlIGJlZm9yZSBiZWluZyBhdXRvbWF0aWNhbGx5IHJvdGF0ZWQuIEEgdmFsdWUgb2YgMCBkaXNhYmxlcyBhdXRvbWF0aWMgcm90YXRpb24gZm9yIHRoZSBrZXkuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci90cmFuc2l0X3NlY3JldF9iYWNrZW5kX2tleSNhdXRvX3JvdGF0ZV9pbnRlcnZhbCBUcmFuc2l0U2VjcmV0QmFja2VuZEtleSNhdXRvX3JvdGF0ZV9pbnRlcnZhbH1cbiAgKi9cbiAgcmVhZG9ubHkgYXV0b1JvdGF0ZUludGVydmFsPzogbnVtYmVyO1xuICAvKipcbiAgKiBBbW91bnQgb2YgdGltZSB0aGUga2V5IHNob3VsZCBsaXZlIGJlZm9yZSBiZWluZyBhdXRvbWF0aWNhbGx5IHJvdGF0ZWQuIEEgdmFsdWUgb2YgMCBkaXNhYmxlcyBhdXRvbWF0aWMgcm90YXRpb24gZm9yIHRoZSBrZXkuXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci90cmFuc2l0X3NlY3JldF9iYWNrZW5kX2tleSNhdXRvX3JvdGF0ZV9wZXJpb2QgVHJhbnNpdFNlY3JldEJhY2tlbmRLZXkjYXV0b19yb3RhdGVfcGVyaW9kfVxuICAqL1xuICByZWFkb25seSBhdXRvUm90YXRlUGVyaW9kPzogbnVtYmVyO1xuICAvKipcbiAgKiBUaGUgVHJhbnNpdCBzZWNyZXQgYmFja2VuZCB0aGUgcmVzb3VyY2UgYmVsb25ncyB0by5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL3RyYW5zaXRfc2VjcmV0X2JhY2tlbmRfa2V5I2JhY2tlbmQgVHJhbnNpdFNlY3JldEJhY2tlbmRLZXkjYmFja2VuZH1cbiAgKi9cbiAgcmVhZG9ubHkgYmFja2VuZDogc3RyaW5nO1xuICAvKipcbiAgKiBXaGV0aGVyIG9yIG5vdCB0byBzdXBwb3J0IGNvbnZlcmdlbnQgZW5jcnlwdGlvbiwgd2hlcmUgdGhlIHNhbWUgcGxhaW50ZXh0IGNyZWF0ZXMgdGhlIHNhbWUgY2lwaGVydGV4dC4gVGhpcyByZXF1aXJlcyBkZXJpdmVkIHRvIGJlIHNldCB0byB0cnVlLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvdHJhbnNpdF9zZWNyZXRfYmFja2VuZF9rZXkjY29udmVyZ2VudF9lbmNyeXB0aW9uIFRyYW5zaXRTZWNyZXRCYWNrZW5kS2V5I2NvbnZlcmdlbnRfZW5jcnlwdGlvbn1cbiAgKi9cbiAgcmVhZG9ubHkgY29udmVyZ2VudEVuY3J5cHRpb24/OiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGU7XG4gIC8qKlxuICAqIFNwZWNpZmllcyBpZiB0aGUga2V5IGlzIGFsbG93ZWQgdG8gYmUgZGVsZXRlZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL3RyYW5zaXRfc2VjcmV0X2JhY2tlbmRfa2V5I2RlbGV0aW9uX2FsbG93ZWQgVHJhbnNpdFNlY3JldEJhY2tlbmRLZXkjZGVsZXRpb25fYWxsb3dlZH1cbiAgKi9cbiAgcmVhZG9ubHkgZGVsZXRpb25BbGxvd2VkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgaWYga2V5IGRlcml2YXRpb24gaXMgdG8gYmUgdXNlZC4gSWYgZW5hYmxlZCwgYWxsIGVuY3J5cHQvZGVjcnlwdCByZXF1ZXN0cyB0byB0aGlzIGtleSBtdXN0IHByb3ZpZGUgYSBjb250ZXh0IHdoaWNoIGlzIHVzZWQgZm9yIGtleSBkZXJpdmF0aW9uLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvdHJhbnNpdF9zZWNyZXRfYmFja2VuZF9rZXkjZGVyaXZlZCBUcmFuc2l0U2VjcmV0QmFja2VuZEtleSNkZXJpdmVkfVxuICAqL1xuICByZWFkb25seSBkZXJpdmVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlO1xuICAvKipcbiAgKiBFbmFibGVzIGtleXMgdG8gYmUgZXhwb3J0YWJsZS4gVGhpcyBhbGxvd3MgZm9yIGFsbCB0aGUgdmFsaWQga2V5cyBpbiB0aGUga2V5IHJpbmcgdG8gYmUgZXhwb3J0ZWQuIE9uY2Ugc2V0LCB0aGlzIGNhbm5vdCBiZSBkaXNhYmxlZC5cbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL3RyYW5zaXRfc2VjcmV0X2JhY2tlbmRfa2V5I2V4cG9ydGFibGUgVHJhbnNpdFNlY3JldEJhY2tlbmRLZXkjZXhwb3J0YWJsZX1cbiAgKi9cbiAgcmVhZG9ubHkgZXhwb3J0YWJsZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTtcbiAgLyoqXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci90cmFuc2l0X3NlY3JldF9iYWNrZW5kX2tleSNpZCBUcmFuc2l0U2VjcmV0QmFja2VuZEtleSNpZH1cbiAgKlxuICAqIFBsZWFzZSBiZSBhd2FyZSB0aGF0IHRoZSBpZCBmaWVsZCBpcyBhdXRvbWF0aWNhbGx5IGFkZGVkIHRvIGFsbCByZXNvdXJjZXMgaW4gVGVycmFmb3JtIHByb3ZpZGVycyB1c2luZyBhIFRlcnJhZm9ybSBwcm92aWRlciBTREsgdmVyc2lvbiBiZWxvdyAyLlxuICAqIElmIHlvdSBleHBlcmllbmNlIHByb2JsZW1zIHNldHRpbmcgdGhpcyB2YWx1ZSBpdCBtaWdodCBub3QgYmUgc2V0dGFibGUuIFBsZWFzZSB0YWtlIGEgbG9vayBhdCB0aGUgcHJvdmlkZXIgZG9jdW1lbnRhdGlvbiB0byBlbnN1cmUgaXQgc2hvdWxkIGJlIHNldHRhYmxlLlxuICAqL1xuICByZWFkb25seSBpZD86IHN0cmluZztcbiAgLyoqXG4gICogTWluaW11bSBrZXkgdmVyc2lvbiB0byB1c2UgZm9yIGRlY3J5cHRpb24uXG4gICogXG4gICogRG9jcyBhdCBUZXJyYWZvcm0gUmVnaXN0cnk6IHtAbGluayBodHRwczovL3d3dy50ZXJyYWZvcm0uaW8vZG9jcy9wcm92aWRlcnMvdmF1bHQvci90cmFuc2l0X3NlY3JldF9iYWNrZW5kX2tleSNtaW5fZGVjcnlwdGlvbl92ZXJzaW9uIFRyYW5zaXRTZWNyZXRCYWNrZW5kS2V5I21pbl9kZWNyeXB0aW9uX3ZlcnNpb259XG4gICovXG4gIHJlYWRvbmx5IG1pbkRlY3J5cHRpb25WZXJzaW9uPzogbnVtYmVyO1xuICAvKipcbiAgKiBNaW5pbXVtIGtleSB2ZXJzaW9uIHRvIHVzZSBmb3IgZW5jcnlwdGlvblxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvdHJhbnNpdF9zZWNyZXRfYmFja2VuZF9rZXkjbWluX2VuY3J5cHRpb25fdmVyc2lvbiBUcmFuc2l0U2VjcmV0QmFja2VuZEtleSNtaW5fZW5jcnlwdGlvbl92ZXJzaW9ufVxuICAqL1xuICByZWFkb25seSBtaW5FbmNyeXB0aW9uVmVyc2lvbj86IG51bWJlcjtcbiAgLyoqXG4gICogTmFtZSBvZiB0aGUgZW5jcnlwdGlvbiBrZXkgdG8gY3JlYXRlLlxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvdHJhbnNpdF9zZWNyZXRfYmFja2VuZF9rZXkjbmFtZSBUcmFuc2l0U2VjcmV0QmFja2VuZEtleSNuYW1lfVxuICAqL1xuICByZWFkb25seSBuYW1lOiBzdHJpbmc7XG4gIC8qKlxuICAqIFRhcmdldCBuYW1lc3BhY2UuIChyZXF1aXJlcyBFbnRlcnByaXNlKVxuICAqIFxuICAqIERvY3MgYXQgVGVycmFmb3JtIFJlZ2lzdHJ5OiB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvdHJhbnNpdF9zZWNyZXRfYmFja2VuZF9rZXkjbmFtZXNwYWNlIFRyYW5zaXRTZWNyZXRCYWNrZW5kS2V5I25hbWVzcGFjZX1cbiAgKi9cbiAgcmVhZG9ubHkgbmFtZXNwYWNlPzogc3RyaW5nO1xuICAvKipcbiAgKiBTcGVjaWZpZXMgdGhlIHR5cGUgb2Yga2V5IHRvIGNyZWF0ZS4gVGhlIGN1cnJlbnRseS1zdXBwb3J0ZWQgdHlwZXMgYXJlOiBhZXMxMjgtZ2NtOTYsIGFlczI1Ni1nY205NiwgY2hhY2hhMjAtcG9seTEzMDUsIGVkMjU1MTksIGVjZHNhLXAyNTYsIGVjZHNhLXAzODQsIGVjZHNhLXA1MjEsIHJzYS0yMDQ4LCByc2EtMzA3MiwgcnNhLTQwOTZcbiAgKiBcbiAgKiBEb2NzIGF0IFRlcnJhZm9ybSBSZWdpc3RyeToge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL3RyYW5zaXRfc2VjcmV0X2JhY2tlbmRfa2V5I3R5cGUgVHJhbnNpdFNlY3JldEJhY2tlbmRLZXkjdHlwZX1cbiAgKi9cbiAgcmVhZG9ubHkgdHlwZT86IHN0cmluZztcbn1cblxuLyoqXG4qIFJlcHJlc2VudHMgYSB7QGxpbmsgaHR0cHM6Ly93d3cudGVycmFmb3JtLmlvL2RvY3MvcHJvdmlkZXJzL3ZhdWx0L3IvdHJhbnNpdF9zZWNyZXRfYmFja2VuZF9rZXkgdmF1bHRfdHJhbnNpdF9zZWNyZXRfYmFja2VuZF9rZXl9XG4qL1xuZXhwb3J0IGNsYXNzIFRyYW5zaXRTZWNyZXRCYWNrZW5kS2V5IGV4dGVuZHMgY2RrdGYuVGVycmFmb3JtUmVzb3VyY2Uge1xuXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIC8vIFNUQVRJQyBQUk9QRVJUSUVTXG4gIC8vID09PT09PT09PT09PT09PT09XG4gIHB1YmxpYyBzdGF0aWMgcmVhZG9ubHkgdGZSZXNvdXJjZVR5cGUgPSBcInZhdWx0X3RyYW5zaXRfc2VjcmV0X2JhY2tlbmRfa2V5XCI7XG5cbiAgLy8gPT09PT09PT09PT1cbiAgLy8gSU5JVElBTElaRVJcbiAgLy8gPT09PT09PT09PT1cblxuICAvKipcbiAgKiBDcmVhdGUgYSBuZXcge0BsaW5rIGh0dHBzOi8vd3d3LnRlcnJhZm9ybS5pby9kb2NzL3Byb3ZpZGVycy92YXVsdC9yL3RyYW5zaXRfc2VjcmV0X2JhY2tlbmRfa2V5IHZhdWx0X3RyYW5zaXRfc2VjcmV0X2JhY2tlbmRfa2V5fSBSZXNvdXJjZVxuICAqXG4gICogQHBhcmFtIHNjb3BlIFRoZSBzY29wZSBpbiB3aGljaCB0byBkZWZpbmUgdGhpcyBjb25zdHJ1Y3RcbiAgKiBAcGFyYW0gaWQgVGhlIHNjb3BlZCBjb25zdHJ1Y3QgSUQuIE11c3QgYmUgdW5pcXVlIGFtb25nc3Qgc2libGluZ3MgaW4gdGhlIHNhbWUgc2NvcGVcbiAgKiBAcGFyYW0gb3B0aW9ucyBUcmFuc2l0U2VjcmV0QmFja2VuZEtleUNvbmZpZ1xuICAqL1xuICBwdWJsaWMgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgY29uZmlnOiBUcmFuc2l0U2VjcmV0QmFja2VuZEtleUNvbmZpZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgdGVycmFmb3JtUmVzb3VyY2VUeXBlOiAndmF1bHRfdHJhbnNpdF9zZWNyZXRfYmFja2VuZF9rZXknLFxuICAgICAgdGVycmFmb3JtR2VuZXJhdG9yTWV0YWRhdGE6IHtcbiAgICAgICAgcHJvdmlkZXJOYW1lOiAndmF1bHQnLFxuICAgICAgICBwcm92aWRlclZlcnNpb246ICczLjEwLjAnLFxuICAgICAgICBwcm92aWRlclZlcnNpb25Db25zdHJhaW50OiAnfj4gMy43J1xuICAgICAgfSxcbiAgICAgIHByb3ZpZGVyOiBjb25maWcucHJvdmlkZXIsXG4gICAgICBkZXBlbmRzT246IGNvbmZpZy5kZXBlbmRzT24sXG4gICAgICBjb3VudDogY29uZmlnLmNvdW50LFxuICAgICAgbGlmZWN5Y2xlOiBjb25maWcubGlmZWN5Y2xlLFxuICAgICAgcHJvdmlzaW9uZXJzOiBjb25maWcucHJvdmlzaW9uZXJzLFxuICAgICAgY29ubmVjdGlvbjogY29uZmlnLmNvbm5lY3Rpb24sXG4gICAgICBmb3JFYWNoOiBjb25maWcuZm9yRWFjaFxuICAgIH0pO1xuICAgIHRoaXMuX2FsbG93UGxhaW50ZXh0QmFja3VwID0gY29uZmlnLmFsbG93UGxhaW50ZXh0QmFja3VwO1xuICAgIHRoaXMuX2F1dG9Sb3RhdGVJbnRlcnZhbCA9IGNvbmZpZy5hdXRvUm90YXRlSW50ZXJ2YWw7XG4gICAgdGhpcy5fYXV0b1JvdGF0ZVBlcmlvZCA9IGNvbmZpZy5hdXRvUm90YXRlUGVyaW9kO1xuICAgIHRoaXMuX2JhY2tlbmQgPSBjb25maWcuYmFja2VuZDtcbiAgICB0aGlzLl9jb252ZXJnZW50RW5jcnlwdGlvbiA9IGNvbmZpZy5jb252ZXJnZW50RW5jcnlwdGlvbjtcbiAgICB0aGlzLl9kZWxldGlvbkFsbG93ZWQgPSBjb25maWcuZGVsZXRpb25BbGxvd2VkO1xuICAgIHRoaXMuX2Rlcml2ZWQgPSBjb25maWcuZGVyaXZlZDtcbiAgICB0aGlzLl9leHBvcnRhYmxlID0gY29uZmlnLmV4cG9ydGFibGU7XG4gICAgdGhpcy5faWQgPSBjb25maWcuaWQ7XG4gICAgdGhpcy5fbWluRGVjcnlwdGlvblZlcnNpb24gPSBjb25maWcubWluRGVjcnlwdGlvblZlcnNpb247XG4gICAgdGhpcy5fbWluRW5jcnlwdGlvblZlcnNpb24gPSBjb25maWcubWluRW5jcnlwdGlvblZlcnNpb247XG4gICAgdGhpcy5fbmFtZSA9IGNvbmZpZy5uYW1lO1xuICAgIHRoaXMuX25hbWVzcGFjZSA9IGNvbmZpZy5uYW1lc3BhY2U7XG4gICAgdGhpcy5fdHlwZSA9IGNvbmZpZy50eXBlO1xuICB9XG5cbiAgLy8gPT09PT09PT09PVxuICAvLyBBVFRSSUJVVEVTXG4gIC8vID09PT09PT09PT1cblxuICAvLyBhbGxvd19wbGFpbnRleHRfYmFja3VwIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2FsbG93UGxhaW50ZXh0QmFja3VwPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBhbGxvd1BsYWludGV4dEJhY2t1cCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdhbGxvd19wbGFpbnRleHRfYmFja3VwJyk7XG4gIH1cbiAgcHVibGljIHNldCBhbGxvd1BsYWludGV4dEJhY2t1cCh2YWx1ZTogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlKSB7XG4gICAgdGhpcy5fYWxsb3dQbGFpbnRleHRCYWNrdXAgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBbGxvd1BsYWludGV4dEJhY2t1cCgpIHtcbiAgICB0aGlzLl9hbGxvd1BsYWludGV4dEJhY2t1cCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYWxsb3dQbGFpbnRleHRCYWNrdXBJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWxsb3dQbGFpbnRleHRCYWNrdXA7XG4gIH1cblxuICAvLyBhdXRvX3JvdGF0ZV9pbnRlcnZhbCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2F1dG9Sb3RhdGVJbnRlcnZhbD86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgYXV0b1JvdGF0ZUludGVydmFsKCkge1xuICAgIHJldHVybiB0aGlzLmdldE51bWJlckF0dHJpYnV0ZSgnYXV0b19yb3RhdGVfaW50ZXJ2YWwnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGF1dG9Sb3RhdGVJbnRlcnZhbCh2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fYXV0b1JvdGF0ZUludGVydmFsID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0QXV0b1JvdGF0ZUludGVydmFsKCkge1xuICAgIHRoaXMuX2F1dG9Sb3RhdGVJbnRlcnZhbCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYXV0b1JvdGF0ZUludGVydmFsSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2F1dG9Sb3RhdGVJbnRlcnZhbDtcbiAgfVxuXG4gIC8vIGF1dG9fcm90YXRlX3BlcmlvZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2F1dG9Sb3RhdGVQZXJpb2Q/OiBudW1iZXI7IFxuICBwdWJsaWMgZ2V0IGF1dG9Sb3RhdGVQZXJpb2QoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdhdXRvX3JvdGF0ZV9wZXJpb2QnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGF1dG9Sb3RhdGVQZXJpb2QodmFsdWU6IG51bWJlcikge1xuICAgIHRoaXMuX2F1dG9Sb3RhdGVQZXJpb2QgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRBdXRvUm90YXRlUGVyaW9kKCkge1xuICAgIHRoaXMuX2F1dG9Sb3RhdGVQZXJpb2QgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGF1dG9Sb3RhdGVQZXJpb2RJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYXV0b1JvdGF0ZVBlcmlvZDtcbiAgfVxuXG4gIC8vIGJhY2tlbmQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfYmFja2VuZD86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgYmFja2VuZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2JhY2tlbmQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGJhY2tlbmQodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX2JhY2tlbmQgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgYmFja2VuZElucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9iYWNrZW5kO1xuICB9XG5cbiAgLy8gY29udmVyZ2VudF9lbmNyeXB0aW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2NvbnZlcmdlbnRFbmNyeXB0aW9uPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBjb252ZXJnZW50RW5jcnlwdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdjb252ZXJnZW50X2VuY3J5cHRpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IGNvbnZlcmdlbnRFbmNyeXB0aW9uKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9jb252ZXJnZW50RW5jcnlwdGlvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldENvbnZlcmdlbnRFbmNyeXB0aW9uKCkge1xuICAgIHRoaXMuX2NvbnZlcmdlbnRFbmNyeXB0aW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBjb252ZXJnZW50RW5jcnlwdGlvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9jb252ZXJnZW50RW5jcnlwdGlvbjtcbiAgfVxuXG4gIC8vIGRlbGV0aW9uX2FsbG93ZWQgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZGVsZXRpb25BbGxvd2VkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBkZWxldGlvbkFsbG93ZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnZGVsZXRpb25fYWxsb3dlZCcpO1xuICB9XG4gIHB1YmxpYyBzZXQgZGVsZXRpb25BbGxvd2VkKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9kZWxldGlvbkFsbG93ZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZWxldGlvbkFsbG93ZWQoKSB7XG4gICAgdGhpcy5fZGVsZXRpb25BbGxvd2VkID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBkZWxldGlvbkFsbG93ZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVsZXRpb25BbGxvd2VkO1xuICB9XG5cbiAgLy8gZGVyaXZlZCAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9kZXJpdmVkPzogYm9vbGVhbiB8IGNka3RmLklSZXNvbHZhYmxlOyBcbiAgcHVibGljIGdldCBkZXJpdmVkKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ2Rlcml2ZWQnKTtcbiAgfVxuICBwdWJsaWMgc2V0IGRlcml2ZWQodmFsdWU6IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZSkge1xuICAgIHRoaXMuX2Rlcml2ZWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXREZXJpdmVkKCkge1xuICAgIHRoaXMuX2Rlcml2ZWQgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IGRlcml2ZWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fZGVyaXZlZDtcbiAgfVxuXG4gIC8vIGV4cG9ydGFibGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfZXhwb3J0YWJsZT86IGJvb2xlYW4gfCBjZGt0Zi5JUmVzb2x2YWJsZTsgXG4gIHB1YmxpYyBnZXQgZXhwb3J0YWJsZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdleHBvcnRhYmxlJyk7XG4gIH1cbiAgcHVibGljIHNldCBleHBvcnRhYmxlKHZhbHVlOiBib29sZWFuIHwgY2RrdGYuSVJlc29sdmFibGUpIHtcbiAgICB0aGlzLl9leHBvcnRhYmxlID0gdmFsdWU7XG4gIH1cbiAgcHVibGljIHJlc2V0RXhwb3J0YWJsZSgpIHtcbiAgICB0aGlzLl9leHBvcnRhYmxlID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBleHBvcnRhYmxlSW5wdXQoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2V4cG9ydGFibGU7XG4gIH1cblxuICAvLyBpZCAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2lkPzogc3RyaW5nOyBcbiAgcHVibGljIGdldCBpZCgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ2lkJyk7XG4gIH1cbiAgcHVibGljIHNldCBpZCh2YWx1ZTogc3RyaW5nKSB7XG4gICAgdGhpcy5faWQgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRJZCgpIHtcbiAgICB0aGlzLl9pZCA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgaWRJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5faWQ7XG4gIH1cblxuICAvLyBrZXlzIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX2tleXMgPSBuZXcgY2RrdGYuU3RyaW5nTWFwTGlzdCh0aGlzLCBcImtleXNcIiwgZmFsc2UpO1xuICBwdWJsaWMgZ2V0IGtleXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuX2tleXM7XG4gIH1cblxuICAvLyBsYXRlc3RfdmVyc2lvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IGxhdGVzdFZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdsYXRlc3RfdmVyc2lvbicpO1xuICB9XG5cbiAgLy8gbWluX2F2YWlsYWJsZV92ZXJzaW9uIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgbWluQXZhaWxhYmxlVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ21pbl9hdmFpbGFibGVfdmVyc2lvbicpO1xuICB9XG5cbiAgLy8gbWluX2RlY3J5cHRpb25fdmVyc2lvbiAtIGNvbXB1dGVkOiBmYWxzZSwgb3B0aW9uYWw6IHRydWUsIHJlcXVpcmVkOiBmYWxzZVxuICBwcml2YXRlIF9taW5EZWNyeXB0aW9uVmVyc2lvbj86IG51bWJlcjsgXG4gIHB1YmxpYyBnZXQgbWluRGVjcnlwdGlvblZlcnNpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0TnVtYmVyQXR0cmlidXRlKCdtaW5fZGVjcnlwdGlvbl92ZXJzaW9uJyk7XG4gIH1cbiAgcHVibGljIHNldCBtaW5EZWNyeXB0aW9uVmVyc2lvbih2YWx1ZTogbnVtYmVyKSB7XG4gICAgdGhpcy5fbWluRGVjcnlwdGlvblZlcnNpb24gPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRNaW5EZWNyeXB0aW9uVmVyc2lvbigpIHtcbiAgICB0aGlzLl9taW5EZWNyeXB0aW9uVmVyc2lvbiA9IHVuZGVmaW5lZDtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbWluRGVjcnlwdGlvblZlcnNpb25JbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fbWluRGVjcnlwdGlvblZlcnNpb247XG4gIH1cblxuICAvLyBtaW5fZW5jcnlwdGlvbl92ZXJzaW9uIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX21pbkVuY3J5cHRpb25WZXJzaW9uPzogbnVtYmVyOyBcbiAgcHVibGljIGdldCBtaW5FbmNyeXB0aW9uVmVyc2lvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXROdW1iZXJBdHRyaWJ1dGUoJ21pbl9lbmNyeXB0aW9uX3ZlcnNpb24nKTtcbiAgfVxuICBwdWJsaWMgc2V0IG1pbkVuY3J5cHRpb25WZXJzaW9uKHZhbHVlOiBudW1iZXIpIHtcbiAgICB0aGlzLl9taW5FbmNyeXB0aW9uVmVyc2lvbiA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE1pbkVuY3J5cHRpb25WZXJzaW9uKCkge1xuICAgIHRoaXMuX21pbkVuY3J5cHRpb25WZXJzaW9uID0gdW5kZWZpbmVkO1xuICB9XG4gIC8vIFRlbXBvcmFyaWx5IGV4cG9zZSBpbnB1dCB2YWx1ZS4gVXNlIHdpdGggY2F1dGlvbi5cbiAgcHVibGljIGdldCBtaW5FbmNyeXB0aW9uVmVyc2lvbklucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9taW5FbmNyeXB0aW9uVmVyc2lvbjtcbiAgfVxuXG4gIC8vIG5hbWUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IHRydWVcbiAgcHJpdmF0ZSBfbmFtZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbmFtZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ25hbWUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IG5hbWUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX25hbWUgPSB2YWx1ZTtcbiAgfVxuICAvLyBUZW1wb3JhcmlseSBleHBvc2UgaW5wdXQgdmFsdWUuIFVzZSB3aXRoIGNhdXRpb24uXG4gIHB1YmxpYyBnZXQgbmFtZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9uYW1lO1xuICB9XG5cbiAgLy8gbmFtZXNwYWNlIC0gY29tcHV0ZWQ6IGZhbHNlLCBvcHRpb25hbDogdHJ1ZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHByaXZhdGUgX25hbWVzcGFjZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgbmFtZXNwYWNlKCkge1xuICAgIHJldHVybiB0aGlzLmdldFN0cmluZ0F0dHJpYnV0ZSgnbmFtZXNwYWNlJyk7XG4gIH1cbiAgcHVibGljIHNldCBuYW1lc3BhY2UodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX25hbWVzcGFjZSA9IHZhbHVlO1xuICB9XG4gIHB1YmxpYyByZXNldE5hbWVzcGFjZSgpIHtcbiAgICB0aGlzLl9uYW1lc3BhY2UgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IG5hbWVzcGFjZUlucHV0KCkge1xuICAgIHJldHVybiB0aGlzLl9uYW1lc3BhY2U7XG4gIH1cblxuICAvLyBzdXBwb3J0c19kZWNyeXB0aW9uIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgc3VwcG9ydHNEZWNyeXB0aW9uKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3N1cHBvcnRzX2RlY3J5cHRpb24nKTtcbiAgfVxuXG4gIC8vIHN1cHBvcnRzX2Rlcml2YXRpb24gLSBjb21wdXRlZDogdHJ1ZSwgb3B0aW9uYWw6IGZhbHNlLCByZXF1aXJlZDogZmFsc2VcbiAgcHVibGljIGdldCBzdXBwb3J0c0Rlcml2YXRpb24oKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0Qm9vbGVhbkF0dHJpYnV0ZSgnc3VwcG9ydHNfZGVyaXZhdGlvbicpO1xuICB9XG5cbiAgLy8gc3VwcG9ydHNfZW5jcnlwdGlvbiAtIGNvbXB1dGVkOiB0cnVlLCBvcHRpb25hbDogZmFsc2UsIHJlcXVpcmVkOiBmYWxzZVxuICBwdWJsaWMgZ2V0IHN1cHBvcnRzRW5jcnlwdGlvbigpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRCb29sZWFuQXR0cmlidXRlKCdzdXBwb3J0c19lbmNyeXB0aW9uJyk7XG4gIH1cblxuICAvLyBzdXBwb3J0c19zaWduaW5nIC0gY29tcHV0ZWQ6IHRydWUsIG9wdGlvbmFsOiBmYWxzZSwgcmVxdWlyZWQ6IGZhbHNlXG4gIHB1YmxpYyBnZXQgc3VwcG9ydHNTaWduaW5nKCkge1xuICAgIHJldHVybiB0aGlzLmdldEJvb2xlYW5BdHRyaWJ1dGUoJ3N1cHBvcnRzX3NpZ25pbmcnKTtcbiAgfVxuXG4gIC8vIHR5cGUgLSBjb21wdXRlZDogZmFsc2UsIG9wdGlvbmFsOiB0cnVlLCByZXF1aXJlZDogZmFsc2VcbiAgcHJpdmF0ZSBfdHlwZT86IHN0cmluZzsgXG4gIHB1YmxpYyBnZXQgdHlwZSgpIHtcbiAgICByZXR1cm4gdGhpcy5nZXRTdHJpbmdBdHRyaWJ1dGUoJ3R5cGUnKTtcbiAgfVxuICBwdWJsaWMgc2V0IHR5cGUodmFsdWU6IHN0cmluZykge1xuICAgIHRoaXMuX3R5cGUgPSB2YWx1ZTtcbiAgfVxuICBwdWJsaWMgcmVzZXRUeXBlKCkge1xuICAgIHRoaXMuX3R5cGUgPSB1bmRlZmluZWQ7XG4gIH1cbiAgLy8gVGVtcG9yYXJpbHkgZXhwb3NlIGlucHV0IHZhbHVlLiBVc2Ugd2l0aCBjYXV0aW9uLlxuICBwdWJsaWMgZ2V0IHR5cGVJbnB1dCgpIHtcbiAgICByZXR1cm4gdGhpcy5fdHlwZTtcbiAgfVxuXG4gIC8vID09PT09PT09PVxuICAvLyBTWU5USEVTSVNcbiAgLy8gPT09PT09PT09XG5cbiAgcHJvdGVjdGVkIHN5bnRoZXNpemVBdHRyaWJ1dGVzKCk6IHsgW25hbWU6IHN0cmluZ106IGFueSB9IHtcbiAgICByZXR1cm4ge1xuICAgICAgYWxsb3dfcGxhaW50ZXh0X2JhY2t1cDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2FsbG93UGxhaW50ZXh0QmFja3VwKSxcbiAgICAgIGF1dG9fcm90YXRlX2ludGVydmFsOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9hdXRvUm90YXRlSW50ZXJ2YWwpLFxuICAgICAgYXV0b19yb3RhdGVfcGVyaW9kOiBjZGt0Zi5udW1iZXJUb1RlcnJhZm9ybSh0aGlzLl9hdXRvUm90YXRlUGVyaW9kKSxcbiAgICAgIGJhY2tlbmQ6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX2JhY2tlbmQpLFxuICAgICAgY29udmVyZ2VudF9lbmNyeXB0aW9uOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fY29udmVyZ2VudEVuY3J5cHRpb24pLFxuICAgICAgZGVsZXRpb25fYWxsb3dlZDogY2RrdGYuYm9vbGVhblRvVGVycmFmb3JtKHRoaXMuX2RlbGV0aW9uQWxsb3dlZCksXG4gICAgICBkZXJpdmVkOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fZGVyaXZlZCksXG4gICAgICBleHBvcnRhYmxlOiBjZGt0Zi5ib29sZWFuVG9UZXJyYWZvcm0odGhpcy5fZXhwb3J0YWJsZSksXG4gICAgICBpZDogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5faWQpLFxuICAgICAgbWluX2RlY3J5cHRpb25fdmVyc2lvbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fbWluRGVjcnlwdGlvblZlcnNpb24pLFxuICAgICAgbWluX2VuY3J5cHRpb25fdmVyc2lvbjogY2RrdGYubnVtYmVyVG9UZXJyYWZvcm0odGhpcy5fbWluRW5jcnlwdGlvblZlcnNpb24pLFxuICAgICAgbmFtZTogY2RrdGYuc3RyaW5nVG9UZXJyYWZvcm0odGhpcy5fbmFtZSksXG4gICAgICBuYW1lc3BhY2U6IGNka3RmLnN0cmluZ1RvVGVycmFmb3JtKHRoaXMuX25hbWVzcGFjZSksXG4gICAgICB0eXBlOiBjZGt0Zi5zdHJpbmdUb1RlcnJhZm9ybSh0aGlzLl90eXBlKSxcbiAgICB9O1xuICB9XG59XG4iXX0=