import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TransitSecretCacheConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Transit secret backend the resource belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_cache_config#backend TransitSecretCacheConfig#backend}
    */
    readonly backend: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_cache_config#id TransitSecretCacheConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Target namespace. (requires Enterprise)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_cache_config#namespace TransitSecretCacheConfig#namespace}
    */
    readonly namespace?: string;
    /**
    * Number of cache entries. A size of 0 mean unlimited.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_cache_config#size TransitSecretCacheConfig#size}
    */
    readonly size: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_cache_config vault_transit_secret_cache_config}
*/
export declare class TransitSecretCacheConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "vault_transit_secret_cache_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/vault/r/transit_secret_cache_config vault_transit_secret_cache_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TransitSecretCacheConfigConfig
    */
    constructor(scope: Construct, id: string, config: TransitSecretCacheConfigConfig);
    private _backend?;
    get backend(): string;
    set backend(value: string);
    get backendInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _namespace?;
    get namespace(): string;
    set namespace(value: string);
    resetNamespace(): void;
    get namespaceInput(): string | undefined;
    private _size?;
    get size(): number;
    set size(value: number);
    get sizeInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
