"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
// CDK parameters
const STACK_NAME = 'aws-cdk-dynamodb';
// DynamoDB table parameters
const TABLE = 'Table';
const TABLE_WITH_GLOBAL_AND_LOCAL_SECONDARY_INDEX = 'TableWithGlobalAndLocalSecondaryIndex';
const TABLE_WITH_GLOBAL_SECONDARY_INDEX = 'TableWithGlobalSecondaryIndex';
const TABLE_WITH_LOCAL_SECONDARY_INDEX = 'TableWithLocalSecondaryIndex';
const TABLE_PARTITION_KEY = { name: 'hashKey', type: lib_1.AttributeType.STRING };
const TABLE_SORT_KEY = { name: 'sortKey', type: lib_1.AttributeType.NUMBER };
// DynamoDB global secondary index parameters
const GSI_TEST_CASE_1 = 'GSI-PartitionKeyOnly';
const GSI_TEST_CASE_2 = 'GSI-PartitionAndSortKeyWithReadAndWriteCapacity';
const GSI_TEST_CASE_3 = 'GSI-ProjectionTypeKeysOnly';
const GSI_TEST_CASE_4 = 'GSI-ProjectionTypeInclude';
const GSI_TEST_CASE_5 = 'GSI-InverseTableKeySchema';
const GSI_PARTITION_KEY = { name: 'gsiHashKey', type: lib_1.AttributeType.STRING };
const GSI_SORT_KEY = { name: 'gsiSortKey', type: lib_1.AttributeType.NUMBER };
const GSI_NON_KEY = [];
for (let i = 0; i < 10; i++) { // 'A' to 'J'
    GSI_NON_KEY.push(String.fromCharCode(65 + i));
}
// DynamoDB local secondary index parameters
const LSI_TEST_CASE_1 = 'LSI-PartitionAndSortKey';
const LSI_TEST_CASE_2 = 'LSI-PartitionAndTableSortKey';
const LSI_TEST_CASE_3 = 'LSI-ProjectionTypeKeysOnly';
const LSI_TEST_CASE_4 = 'LSI-ProjectionTypeInclude';
const LSI_SORT_KEY = { name: 'lsiSortKey', type: lib_1.AttributeType.NUMBER };
const LSI_NON_KEY = [];
for (let i = 0; i < 10; i++) { // 'K' to 'T'
    LSI_NON_KEY.push(String.fromCharCode(75 + i));
}
const app = new core_1.App();
const stack = new core_1.Stack(app, STACK_NAME);
// Provisioned tables
new lib_1.Table(stack, TABLE, {
    billingMode: lib_1.BillingMode.PAY_PER_REQUEST,
    partitionKey: TABLE_PARTITION_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
const tableWithGlobalAndLocalSecondaryIndex = new lib_1.Table(stack, TABLE_WITH_GLOBAL_AND_LOCAL_SECONDARY_INDEX, {
    pointInTimeRecovery: true,
    serverSideEncryption: true,
    stream: lib_1.StreamViewType.KEYS_ONLY,
    billingMode: lib_1.BillingMode.PAY_PER_REQUEST,
    timeToLiveAttribute: 'timeToLive',
    partitionKey: TABLE_PARTITION_KEY,
    sortKey: TABLE_SORT_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
tableWithGlobalAndLocalSecondaryIndex.node.applyAspect(new core_1.Tag('Environment', 'Production'));
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_1,
    partitionKey: GSI_PARTITION_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_2,
    partitionKey: GSI_PARTITION_KEY,
    sortKey: GSI_SORT_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_3,
    partitionKey: GSI_PARTITION_KEY,
    sortKey: GSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.KEYS_ONLY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_4,
    partitionKey: GSI_PARTITION_KEY,
    sortKey: GSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.INCLUDE,
    nonKeyAttributes: GSI_NON_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_5,
    partitionKey: TABLE_SORT_KEY,
    sortKey: TABLE_PARTITION_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_2,
    sortKey: LSI_SORT_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_1,
    sortKey: TABLE_SORT_KEY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_3,
    sortKey: LSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.KEYS_ONLY,
});
tableWithGlobalAndLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_4,
    sortKey: LSI_SORT_KEY,
    projectionType: lib_1.ProjectionType.INCLUDE,
    nonKeyAttributes: LSI_NON_KEY,
});
const tableWithGlobalSecondaryIndex = new lib_1.Table(stack, TABLE_WITH_GLOBAL_SECONDARY_INDEX, {
    billingMode: lib_1.BillingMode.PAY_PER_REQUEST,
    partitionKey: TABLE_PARTITION_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
tableWithGlobalSecondaryIndex.addGlobalSecondaryIndex({
    indexName: GSI_TEST_CASE_1,
    partitionKey: GSI_PARTITION_KEY,
});
const tableWithLocalSecondaryIndex = new lib_1.Table(stack, TABLE_WITH_LOCAL_SECONDARY_INDEX, {
    billingMode: lib_1.BillingMode.PAY_PER_REQUEST,
    partitionKey: TABLE_PARTITION_KEY,
    sortKey: TABLE_SORT_KEY,
    removalPolicy: core_1.RemovalPolicy.DESTROY,
});
tableWithLocalSecondaryIndex.addLocalSecondaryIndex({
    indexName: LSI_TEST_CASE_1,
    sortKey: LSI_SORT_KEY,
});
app.synth();
//# sourceMappingURL=data:application/json;base64,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