# Generated by Django 3.1.4 on 2021-03-14 19:54

import secrets
import uuid

import django.contrib.postgres.fields
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Client',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('token', models.CharField(default=secrets.token_urlsafe, max_length=255, unique=True)),
                ('channel', models.CharField(max_length=255)),
                ('created', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Publication',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True)),
                ('model_module', models.CharField(max_length=255)),
                ('model_class', models.CharField(max_length=255)),
                ('template_module', models.CharField(max_length=255)),
                ('template_class', models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('subscriber_id', models.CharField(max_length=255)),
                ('subscriber_module', models.CharField(max_length=255)),
                ('subscriber_class', models.CharField(max_length=255)),
                ('queryset', django.contrib.postgres.fields.ArrayField(base_field=models.IntegerField(), default=list, size=None)),
                ('options', models.JSONField(blank=True, null=True)),
                ('client', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='ryzom_django_channels.client')),
                ('publication', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ryzom_django_channels.publication')),
            ],
        ),
        migrations.CreateModel(
            name='Registration',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('subscriber_id', models.CharField(max_length=255)),
                ('subscriber_parent', models.CharField(max_length=255)),
                ('client', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='ryzom_django_channels.client')),
            ],
            options={
                'unique_together': {('name', 'client')},
            },
        ),
    ]
