export declare const Esbuild: {
    name: string;
    version: string | undefined;
    spec: string;
};
export declare class EsbuildSource {
    private static dynamicPackage;
    private static _default?;
    /**
     * Set the default mechanism to find the module
     */
    static set default(path: string | undefined);
    /**
     * The current default to find the module
     */
    static get default(): string | undefined;
    /**
     * `EsbuildSource.nodeJs` for NodeJs, `EsbuildSource.auto` for all other languages
     */
    static get platformDefault(): string;
    /**
     * Try to find the module in most common paths.
     */
    static get anywhere(): string | undefined;
    /**
     * Try to find the module in common global installation paths.
     */
    static get globalPaths(): string | undefined;
    /**
     * Require module by name, do not attempt to find it anywhere else.
     */
    static get nodeJs(): string;
    /**
     * Install the module to a temporary location.
     */
    static get install(): string;
    /**
     * First try to find to module, then install it to a temporary location.
     */
    static get auto(): string;
}
