"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeScriptSource = exports.JavaScriptSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const asset_1 = require("./asset");
;
;
class Source {
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=browser`
     *
     * @stability stable
     */
    props) {
        const defaultOptions = {
            platform: 'browser',
        };
        this.props = {
            entryPoints,
            ...props,
            buildOptions: {
                ...defaultOptions,
                ...props.buildOptions,
            },
        };
    }
    bind(scope, context) {
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new this.assetClass(scope, this.constructor.name, this.props);
        }
        else if (aws_cdk_lib_1.Stack.of(this.asset) !== aws_cdk_lib_1.Stack.of(scope)) {
            throw new Error(`Asset is already associated with another stack '${aws_cdk_lib_1.Stack.of(this.asset).stackName}'. ` + 'Create a new Asset instance for every stack.');
        }
        if (!context) {
            throw new Error(`To use a ${this.constructor.name}, context must be provided`);
        }
        // we give permissions on all files in the bucket since we don't want to
        // accidentally revoke permission on old versions when deploying a new
        // version (for example, when using Lambda traffic shifting).
        this.asset.bucket.grantRead(context.handlerRole);
        return {
            bucket: this.asset.bucket,
            zipObjectKey: this.asset.s3ObjectKey,
        };
    }
}
class JavaScriptSource extends Source {
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints, 
    /**
      * Props to change the behavior of the bundler.
      *
      * Default values for `props.buildOptions`:
      * - `bundle=true`
      * - `platform=browser`
      *
      * @stability stable
      */
    props = {}) {
        super(entryPoints, props);
        this.assetClass = asset_1.JavaScriptAsset;
    }
}
exports.JavaScriptSource = JavaScriptSource;
_a = JSII_RTTI_SYMBOL_1;
JavaScriptSource[_a] = { fqn: "@mrgrain/cdk-esbuild.JavaScriptSource", version: "3.14.1" };
class TypeScriptSource extends Source {
    constructor(
    /**
     * A path or list or map of paths to the entry points of your code.
     *
     * Relative paths are by default resolved from the current working directory.
     * To change the working directory, see `buildOptions.absWorkingDir`.
     *
     * Absolute paths can be used if files are part of the working directory.
     *
     * Examples:
     *  - `'src/index.ts'`
     *  - `require.resolve('./lambda')`
     *  - `['src/index.ts', 'src/util.ts']`
     *  - `{one: 'src/two.ts', two: 'src/one.ts'}`
     *
     * @stability stable
     */
    entryPoints, 
    /**
     * Props to change the behavior of the bundler.
     *
     * Default values for `props.buildOptions`:
     * - `bundle=true`
     * - `platform=browser`
     *
     * @stability stable
     */
    props = {}) {
        super(entryPoints, props);
        this.assetClass = asset_1.TypeScriptAsset;
    }
}
exports.TypeScriptSource = TypeScriptSource;
_b = JSII_RTTI_SYMBOL_1;
TypeScriptSource[_b] = { fqn: "@mrgrain/cdk-esbuild.TypeScriptSource", version: "3.14.1" };
//# sourceMappingURL=data:application/json;base64,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