import pandas as pd


def trials_from_csv(path):
    """
    :param path: the path to a csv file in wide format
    :return: a list were every item is a full trial
    """
    df = pd.read_csv(path)
    dictionary = df.to_dict('list')
    return _long(dictionary)


def trials_from_sweetpea(sequence):
    """
    :param sequence: a trial sequence generated by sweetpea (one experiment out of experiments!)
    :return: a list were every item is a full trial
    """
    return _long(sequence)


def _long(sequence):
    """
    :param sequence: a trial list dictionary in wide format
    :return: a list were every item is a full trial
    """
    keys = []
    for key in sequence.keys():
        keys.append(key)
    long = []
    for i in range(len(sequence[keys[0]])):
        t = {}
        for key in keys:
            t[key] = sequence[key][i]
        long.append(t)
    return long


