# mypy-boto3-workmail<a id="mypy-boto3-workmail"></a>

[![PyPI - mypy-boto3-workmail](https://img.shields.io/pypi/v/mypy-boto3-workmail.svg?color=blue)](https://pypi.org/project/mypy-boto3-workmail)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workmail.svg?color=blue)](https://pypi.org/project/mypy-boto3-workmail)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-workmail?color=blue)](https://pypistats.org/packages/mypy-boto3-workmail)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.WorkMail 1.17.81](https://boto3.amazonaws.com/v1/documentation/api/1.17.81/reference/services/workmail.html#WorkMail)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.14.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-workmail docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workmail/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-workmail](#mypy-boto3-workmail)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `WorkMail` service.

```bash
python -m pip install boto3-stubs[workmail]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[workmail]` in your environment:
  `python -m pip install 'boto3-stubs[workmail]'`

Both type checking and auto-complete should work for `WorkMail` service. No
explicit type annotations required, write your `boto3` code as usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[workmail]` in your environment:
  `python -m pip install 'boto3-stubs[workmail]'`

Both type checking and auto-complete should work for `WorkMail` service. No
explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed
`boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[workmail]` in your environment:
  `python -m pip install 'boto3-stubs[workmail]'`
- Run `mypy` as usual

Type checking should work for `WorkMail` service. No explicit type annotations
required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[workmail]` in your environment:
  `python -m pip install 'boto3-stubs[workmail]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `WorkMail` service. No explicit type annotations
required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`WorkMailClient` provides annotations for `boto3.client("workmail")`.

```python
import boto3

from mypy_boto3_workmail import WorkMailClient

client: WorkMailClient = boto3.client("workmail")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WorkMailClient = session.client("workmail")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_workmail.paginator` module contains type annotations for all
paginators.

```python
from mypy_boto3_workmail import WorkMailClient
from mypy_boto3_workmail.paginator import (
    ListAliasesPaginator,
    ListGroupMembersPaginator,
    ListGroupsPaginator,
    ListMailboxPermissionsPaginator,
    ListOrganizationsPaginator,
    ListResourceDelegatesPaginator,
    ListResourcesPaginator,
    ListUsersPaginator,
)

client: WorkMailClient = boto3.client("workmail")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_aliases_paginator: ListAliasesPaginator = client.get_paginator("list_aliases")
list_group_members_paginator: ListGroupMembersPaginator = client.get_paginator("list_group_members")
list_groups_paginator: ListGroupsPaginator = client.get_paginator("list_groups")
list_mailbox_permissions_paginator: ListMailboxPermissionsPaginator = client.get_paginator("list_mailbox_permissions")
list_organizations_paginator: ListOrganizationsPaginator = client.get_paginator("list_organizations")
list_resource_delegates_paginator: ListResourceDelegatesPaginator = client.get_paginator("list_resource_delegates")
list_resources_paginator: ListResourcesPaginator = client.get_paginator("list_resources")
list_users_paginator: ListUsersPaginator = client.get_paginator("list_users")
```

### Literals<a id="literals"></a>

`mypy_boto3_workmail.literals` module contains literals extracted from shapes
that can be used in user code for type checking.

```python
from mypy_boto3_workmail.literals import (
    AccessControlRuleEffectType,
    EntityStateType,
    FolderNameType,
    ListAliasesPaginatorName,
    ListGroupMembersPaginatorName,
    ListGroupsPaginatorName,
    ListMailboxPermissionsPaginatorName,
    ListOrganizationsPaginatorName,
    ListResourceDelegatesPaginatorName,
    ListResourcesPaginatorName,
    ListUsersPaginatorName,
    MailboxExportJobStateType,
    MemberTypeType,
    MobileDeviceAccessRuleEffectType,
    PermissionTypeType,
    ResourceTypeType,
    RetentionActionType,
    UserRoleType,
)

def check_value(value: AccessControlRuleEffectType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_workmail.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_workmail.type_defs import (
    AccessControlRuleTypeDef,
    BookingOptionsTypeDef,
    CreateGroupResponseTypeDef,
    CreateMobileDeviceAccessRuleResponseTypeDef,
    CreateOrganizationResponseTypeDef,
    CreateResourceResponseTypeDef,
    CreateUserResponseTypeDef,
    DelegateTypeDef,
    DeleteOrganizationResponseTypeDef,
    DescribeGroupResponseTypeDef,
    DescribeMailboxExportJobResponseTypeDef,
    DescribeOrganizationResponseTypeDef,
    DescribeResourceResponseTypeDef,
    DescribeUserResponseTypeDef,
    DomainTypeDef,
    FolderConfigurationTypeDef,
    GetAccessControlEffectResponseTypeDef,
    GetDefaultRetentionPolicyResponseTypeDef,
    GetMailboxDetailsResponseTypeDef,
    GetMobileDeviceAccessEffectResponseTypeDef,
    GroupTypeDef,
    ListAccessControlRulesResponseTypeDef,
    ListAliasesResponseTypeDef,
    ListGroupMembersResponseTypeDef,
    ListGroupsResponseTypeDef,
    ListMailboxExportJobsResponseTypeDef,
    ListMailboxPermissionsResponseTypeDef,
    ListMobileDeviceAccessRulesResponseTypeDef,
    ListOrganizationsResponseTypeDef,
    ListResourceDelegatesResponseTypeDef,
    ListResourcesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListUsersResponseTypeDef,
    MailboxExportJobTypeDef,
    MemberTypeDef,
    MobileDeviceAccessMatchedRuleTypeDef,
    MobileDeviceAccessRuleTypeDef,
    OrganizationSummaryTypeDef,
    PaginatorConfigTypeDef,
    PermissionTypeDef,
    ResourceTypeDef,
    StartMailboxExportJobResponseTypeDef,
    TagTypeDef,
    UserTypeDef,
)

def get_structure() -> AccessControlRuleTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-workmail` version is the same as related `boto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-workmail docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_workmail/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
