"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessContextManagerAccessLevelCondition = exports.AccessContextManagerAccessLevelConditionTimeoutsOutputReference = exports.accessContextManagerAccessLevelConditionTimeoutsToTerraform = exports.AccessContextManagerAccessLevelConditionDevicePolicyOutputReference = exports.accessContextManagerAccessLevelConditionDevicePolicyToTerraform = exports.accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        minimum_version: cdktf.stringToTerraform(struct.minimumVersion),
        os_type: cdktf.stringToTerraform(struct.osType),
    };
}
exports.accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform = accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform;
function accessContextManagerAccessLevelConditionDevicePolicyToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        allowed_device_management_levels: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedDeviceManagementLevels),
        allowed_encryption_statuses: cdktf.listMapper(cdktf.stringToTerraform)(struct.allowedEncryptionStatuses),
        require_admin_approval: cdktf.booleanToTerraform(struct.requireAdminApproval),
        require_corp_owned: cdktf.booleanToTerraform(struct.requireCorpOwned),
        require_screen_lock: cdktf.booleanToTerraform(struct.requireScreenLock),
        os_constraints: cdktf.listMapper(accessContextManagerAccessLevelConditionDevicePolicyOsConstraintsToTerraform)(struct.osConstraints),
    };
}
exports.accessContextManagerAccessLevelConditionDevicePolicyToTerraform = accessContextManagerAccessLevelConditionDevicePolicyToTerraform;
class AccessContextManagerAccessLevelConditionDevicePolicyOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._allowedDeviceManagementLevels !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedDeviceManagementLevels = this._allowedDeviceManagementLevels;
        }
        if (this._allowedEncryptionStatuses !== undefined) {
            hasAnyValues = true;
            internalValueResult.allowedEncryptionStatuses = this._allowedEncryptionStatuses;
        }
        if (this._requireAdminApproval !== undefined) {
            hasAnyValues = true;
            internalValueResult.requireAdminApproval = this._requireAdminApproval;
        }
        if (this._requireCorpOwned !== undefined) {
            hasAnyValues = true;
            internalValueResult.requireCorpOwned = this._requireCorpOwned;
        }
        if (this._requireScreenLock !== undefined) {
            hasAnyValues = true;
            internalValueResult.requireScreenLock = this._requireScreenLock;
        }
        if (this._osConstraints !== undefined) {
            hasAnyValues = true;
            internalValueResult.osConstraints = this._osConstraints;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._allowedDeviceManagementLevels = undefined;
            this._allowedEncryptionStatuses = undefined;
            this._requireAdminApproval = undefined;
            this._requireCorpOwned = undefined;
            this._requireScreenLock = undefined;
            this._osConstraints = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._allowedDeviceManagementLevels = value.allowedDeviceManagementLevels;
            this._allowedEncryptionStatuses = value.allowedEncryptionStatuses;
            this._requireAdminApproval = value.requireAdminApproval;
            this._requireCorpOwned = value.requireCorpOwned;
            this._requireScreenLock = value.requireScreenLock;
            this._osConstraints = value.osConstraints;
        }
    }
    get allowedDeviceManagementLevels() {
        return this.getListAttribute('allowed_device_management_levels');
    }
    set allowedDeviceManagementLevels(value) {
        this._allowedDeviceManagementLevels = value;
    }
    resetAllowedDeviceManagementLevels() {
        this._allowedDeviceManagementLevels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedDeviceManagementLevelsInput() {
        return this._allowedDeviceManagementLevels;
    }
    get allowedEncryptionStatuses() {
        return this.getListAttribute('allowed_encryption_statuses');
    }
    set allowedEncryptionStatuses(value) {
        this._allowedEncryptionStatuses = value;
    }
    resetAllowedEncryptionStatuses() {
        this._allowedEncryptionStatuses = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get allowedEncryptionStatusesInput() {
        return this._allowedEncryptionStatuses;
    }
    get requireAdminApproval() {
        return this.getBooleanAttribute('require_admin_approval');
    }
    set requireAdminApproval(value) {
        this._requireAdminApproval = value;
    }
    resetRequireAdminApproval() {
        this._requireAdminApproval = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireAdminApprovalInput() {
        return this._requireAdminApproval;
    }
    get requireCorpOwned() {
        return this.getBooleanAttribute('require_corp_owned');
    }
    set requireCorpOwned(value) {
        this._requireCorpOwned = value;
    }
    resetRequireCorpOwned() {
        this._requireCorpOwned = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireCorpOwnedInput() {
        return this._requireCorpOwned;
    }
    get requireScreenLock() {
        return this.getBooleanAttribute('require_screen_lock');
    }
    set requireScreenLock(value) {
        this._requireScreenLock = value;
    }
    resetRequireScreenLock() {
        this._requireScreenLock = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requireScreenLockInput() {
        return this._requireScreenLock;
    }
    get osConstraints() {
        // Getting the computed value is not yet implemented
        return this.interpolationForAttribute('os_constraints');
    }
    set osConstraints(value) {
        this._osConstraints = value;
    }
    resetOsConstraints() {
        this._osConstraints = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get osConstraintsInput() {
        return this._osConstraints;
    }
}
exports.AccessContextManagerAccessLevelConditionDevicePolicyOutputReference = AccessContextManagerAccessLevelConditionDevicePolicyOutputReference;
_a = JSII_RTTI_SYMBOL_1;
AccessContextManagerAccessLevelConditionDevicePolicyOutputReference[_a] = { fqn: "@cdktf/provider-google.AccessContextManagerAccessLevelConditionDevicePolicyOutputReference", version: "0.8.23" };
function accessContextManagerAccessLevelConditionTimeoutsToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        create: cdktf.stringToTerraform(struct.create),
        delete: cdktf.stringToTerraform(struct.delete),
    };
}
exports.accessContextManagerAccessLevelConditionTimeoutsToTerraform = accessContextManagerAccessLevelConditionTimeoutsToTerraform;
class AccessContextManagerAccessLevelConditionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource, terraformAttribute) {
        super(terraformResource, terraformAttribute, false, 0);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._create !== undefined) {
            hasAnyValues = true;
            internalValueResult.create = this._create;
        }
        if (this._delete !== undefined) {
            hasAnyValues = true;
            internalValueResult.delete = this._delete;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._create = undefined;
            this._delete = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._create = value.create;
            this._delete = value.delete;
        }
    }
    get create() {
        return this.getStringAttribute('create');
    }
    set create(value) {
        this._create = value;
    }
    resetCreate() {
        this._create = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get createInput() {
        return this._create;
    }
    get delete() {
        return this.getStringAttribute('delete');
    }
    set delete(value) {
        this._delete = value;
    }
    resetDelete() {
        this._delete = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get deleteInput() {
        return this._delete;
    }
}
exports.AccessContextManagerAccessLevelConditionTimeoutsOutputReference = AccessContextManagerAccessLevelConditionTimeoutsOutputReference;
_b = JSII_RTTI_SYMBOL_1;
AccessContextManagerAccessLevelConditionTimeoutsOutputReference[_b] = { fqn: "@cdktf/provider-google.AccessContextManagerAccessLevelConditionTimeoutsOutputReference", version: "0.8.23" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition google_access_context_manager_access_level_condition}
*/
class AccessContextManagerAccessLevelCondition extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level_condition google_access_context_manager_access_level_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccessContextManagerAccessLevelConditionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_access_context_manager_access_level_condition',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.19.0',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // device_policy - computed: false, optional: true, required: false
        this._devicePolicy = new AccessContextManagerAccessLevelConditionDevicePolicyOutputReference(this, "device_policy");
        // timeouts - computed: false, optional: true, required: false
        this._timeouts = new AccessContextManagerAccessLevelConditionTimeoutsOutputReference(this, "timeouts");
        this._accessLevel = config.accessLevel;
        this._ipSubnetworks = config.ipSubnetworks;
        this._members = config.members;
        this._negate = config.negate;
        this._regions = config.regions;
        this._requiredAccessLevels = config.requiredAccessLevels;
        this._devicePolicy.internalValue = config.devicePolicy;
        this._timeouts.internalValue = config.timeouts;
    }
    get accessLevel() {
        return this.getStringAttribute('access_level');
    }
    set accessLevel(value) {
        this._accessLevel = value;
    }
    // Temporarily expose input value. Use with caution.
    get accessLevelInput() {
        return this._accessLevel;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ipSubnetworks() {
        return this.getListAttribute('ip_subnetworks');
    }
    set ipSubnetworks(value) {
        this._ipSubnetworks = value;
    }
    resetIpSubnetworks() {
        this._ipSubnetworks = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ipSubnetworksInput() {
        return this._ipSubnetworks;
    }
    get members() {
        return this.getListAttribute('members');
    }
    set members(value) {
        this._members = value;
    }
    resetMembers() {
        this._members = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get membersInput() {
        return this._members;
    }
    get negate() {
        return this.getBooleanAttribute('negate');
    }
    set negate(value) {
        this._negate = value;
    }
    resetNegate() {
        this._negate = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get negateInput() {
        return this._negate;
    }
    get regions() {
        return this.getListAttribute('regions');
    }
    set regions(value) {
        this._regions = value;
    }
    resetRegions() {
        this._regions = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get regionsInput() {
        return this._regions;
    }
    get requiredAccessLevels() {
        return this.getListAttribute('required_access_levels');
    }
    set requiredAccessLevels(value) {
        this._requiredAccessLevels = value;
    }
    resetRequiredAccessLevels() {
        this._requiredAccessLevels = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requiredAccessLevelsInput() {
        return this._requiredAccessLevels;
    }
    get devicePolicy() {
        return this._devicePolicy;
    }
    putDevicePolicy(value) {
        this._devicePolicy.internalValue = value;
    }
    resetDevicePolicy() {
        this._devicePolicy.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get devicePolicyInput() {
        return this._devicePolicy.internalValue;
    }
    get timeouts() {
        return this._timeouts;
    }
    putTimeouts(value) {
        this._timeouts.internalValue = value;
    }
    resetTimeouts() {
        this._timeouts.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeoutsInput() {
        return this._timeouts.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            access_level: cdktf.stringToTerraform(this._accessLevel),
            ip_subnetworks: cdktf.listMapper(cdktf.stringToTerraform)(this._ipSubnetworks),
            members: cdktf.listMapper(cdktf.stringToTerraform)(this._members),
            negate: cdktf.booleanToTerraform(this._negate),
            regions: cdktf.listMapper(cdktf.stringToTerraform)(this._regions),
            required_access_levels: cdktf.listMapper(cdktf.stringToTerraform)(this._requiredAccessLevels),
            device_policy: accessContextManagerAccessLevelConditionDevicePolicyToTerraform(this._devicePolicy.internalValue),
            timeouts: accessContextManagerAccessLevelConditionTimeoutsToTerraform(this._timeouts.internalValue),
        };
    }
}
exports.AccessContextManagerAccessLevelCondition = AccessContextManagerAccessLevelCondition;
_c = JSII_RTTI_SYMBOL_1;
AccessContextManagerAccessLevelCondition[_c] = { fqn: "@cdktf/provider-google.AccessContextManagerAccessLevelCondition", version: "0.8.23" };
// =================
// STATIC PROPERTIES
// =================
AccessContextManagerAccessLevelCondition.tfResourceType = "google_access_context_manager_access_level_condition";
//# sourceMappingURL=data:application/json;base64,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