import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerAccessPolicyIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_binding#members AccessContextManagerAccessPolicyIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_binding#name AccessContextManagerAccessPolicyIamBinding#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_binding#role AccessContextManagerAccessPolicyIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_binding#condition AccessContextManagerAccessPolicyIamBinding#condition}
    */
    readonly condition?: AccessContextManagerAccessPolicyIamBindingCondition;
}
export interface AccessContextManagerAccessPolicyIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_binding#description AccessContextManagerAccessPolicyIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_binding#expression AccessContextManagerAccessPolicyIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_binding#title AccessContextManagerAccessPolicyIamBinding#title}
    */
    readonly title: string;
}
export declare function accessContextManagerAccessPolicyIamBindingConditionToTerraform(struct?: AccessContextManagerAccessPolicyIamBindingConditionOutputReference | AccessContextManagerAccessPolicyIamBindingCondition): any;
export declare class AccessContextManagerAccessPolicyIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessPolicyIamBindingCondition | undefined;
    set internalValue(value: AccessContextManagerAccessPolicyIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_binding google_access_context_manager_access_policy_iam_binding}
*/
export declare class AccessContextManagerAccessPolicyIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_access_policy_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_binding google_access_context_manager_access_policy_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccessContextManagerAccessPolicyIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: AccessContextManagerAccessPolicyIamBindingConfig);
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): AccessContextManagerAccessPolicyIamBindingConditionOutputReference;
    putCondition(value: AccessContextManagerAccessPolicyIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): AccessContextManagerAccessPolicyIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
