import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AccessContextManagerAccessPolicyIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_member#member AccessContextManagerAccessPolicyIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_member#name AccessContextManagerAccessPolicyIamMember#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_member#role AccessContextManagerAccessPolicyIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_member#condition AccessContextManagerAccessPolicyIamMember#condition}
    */
    readonly condition?: AccessContextManagerAccessPolicyIamMemberCondition;
}
export interface AccessContextManagerAccessPolicyIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_member#description AccessContextManagerAccessPolicyIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_member#expression AccessContextManagerAccessPolicyIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_member#title AccessContextManagerAccessPolicyIamMember#title}
    */
    readonly title: string;
}
export declare function accessContextManagerAccessPolicyIamMemberConditionToTerraform(struct?: AccessContextManagerAccessPolicyIamMemberConditionOutputReference | AccessContextManagerAccessPolicyIamMemberCondition): any;
export declare class AccessContextManagerAccessPolicyIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AccessContextManagerAccessPolicyIamMemberCondition | undefined;
    set internalValue(value: AccessContextManagerAccessPolicyIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_member google_access_context_manager_access_policy_iam_member}
*/
export declare class AccessContextManagerAccessPolicyIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_access_context_manager_access_policy_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_policy_iam_member google_access_context_manager_access_policy_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AccessContextManagerAccessPolicyIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: AccessContextManagerAccessPolicyIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): AccessContextManagerAccessPolicyIamMemberConditionOutputReference;
    putCondition(value: AccessContextManagerAccessPolicyIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): AccessContextManagerAccessPolicyIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
