import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeEnvgroupAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Apigee environment group associated with the Apigee environment,
  in the format 'organizations/{{org_name}}/envgroups/{{envgroup_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment#envgroup_id ApigeeEnvgroupAttachment#envgroup_id}
    */
    readonly envgroupId: string;
    /**
    * The resource ID of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment#environment ApigeeEnvgroupAttachment#environment}
    */
    readonly environment: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment#timeouts ApigeeEnvgroupAttachment#timeouts}
    */
    readonly timeouts?: ApigeeEnvgroupAttachmentTimeouts;
}
export interface ApigeeEnvgroupAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment#create ApigeeEnvgroupAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment#delete ApigeeEnvgroupAttachment#delete}
    */
    readonly delete?: string;
}
export declare function apigeeEnvgroupAttachmentTimeoutsToTerraform(struct?: ApigeeEnvgroupAttachmentTimeoutsOutputReference | ApigeeEnvgroupAttachmentTimeouts | cdktf.IResolvable): any;
export declare class ApigeeEnvgroupAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeEnvgroupAttachmentTimeouts | undefined;
    set internalValue(value: ApigeeEnvgroupAttachmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment google_apigee_envgroup_attachment}
*/
export declare class ApigeeEnvgroupAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_envgroup_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_envgroup_attachment google_apigee_envgroup_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeEnvgroupAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeEnvgroupAttachmentConfig);
    private _envgroupId?;
    get envgroupId(): string;
    set envgroupId(value: string);
    get envgroupIdInput(): string | undefined;
    private _environment?;
    get environment(): string;
    set environment(value: string);
    get environmentInput(): string | undefined;
    get id(): string;
    get name(): string;
    private _timeouts;
    get timeouts(): ApigeeEnvgroupAttachmentTimeoutsOutputReference;
    putTimeouts(value: ApigeeEnvgroupAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApigeeEnvgroupAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
