import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeEnvironmentIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member#env_id ApigeeEnvironmentIamMember#env_id}
    */
    readonly envId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member#member ApigeeEnvironmentIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member#org_id ApigeeEnvironmentIamMember#org_id}
    */
    readonly orgId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member#role ApigeeEnvironmentIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member#condition ApigeeEnvironmentIamMember#condition}
    */
    readonly condition?: ApigeeEnvironmentIamMemberCondition;
}
export interface ApigeeEnvironmentIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member#description ApigeeEnvironmentIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member#expression ApigeeEnvironmentIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member#title ApigeeEnvironmentIamMember#title}
    */
    readonly title: string;
}
export declare function apigeeEnvironmentIamMemberConditionToTerraform(struct?: ApigeeEnvironmentIamMemberConditionOutputReference | ApigeeEnvironmentIamMemberCondition): any;
export declare class ApigeeEnvironmentIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeEnvironmentIamMemberCondition | undefined;
    set internalValue(value: ApigeeEnvironmentIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member google_apigee_environment_iam_member}
*/
export declare class ApigeeEnvironmentIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_environment_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_environment_iam_member google_apigee_environment_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeEnvironmentIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeEnvironmentIamMemberConfig);
    private _envId?;
    get envId(): string;
    set envId(value: string);
    get envIdInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): ApigeeEnvironmentIamMemberConditionOutputReference;
    putCondition(value: ApigeeEnvironmentIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): ApigeeEnvironmentIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
