import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Optional. API Proxy type supported by the environment. The type can be set when creating
  the Environment and cannot be changed. Possible values: ["API_PROXY_TYPE_UNSPECIFIED", "PROGRAMMABLE", "CONFIGURABLE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#api_proxy_type ApigeeEnvironment#api_proxy_type}
    */
    readonly apiProxyType?: string;
    /**
    * Optional. Deployment type supported by the environment. The deployment type can be
  set when creating the environment and cannot be changed. When you enable archive
  deployment, you will be prevented from performing a subset of actions within the
  environment, including:
  Managing the deployment of API proxy or shared flow revisions;
  Creating, updating, or deleting resource files;
  Creating, updating, or deleting target servers. Possible values: ["DEPLOYMENT_TYPE_UNSPECIFIED", "PROXY", "ARCHIVE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#deployment_type ApigeeEnvironment#deployment_type}
    */
    readonly deploymentType?: string;
    /**
    * Description of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#description ApigeeEnvironment#description}
    */
    readonly description?: string;
    /**
    * Display name of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#display_name ApigeeEnvironment#display_name}
    */
    readonly displayName?: string;
    /**
    * The resource ID of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#name ApigeeEnvironment#name}
    */
    readonly name: string;
    /**
    * The Apigee Organization associated with the Apigee environment,
  in the format 'organizations/{{org_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#org_id ApigeeEnvironment#org_id}
    */
    readonly orgId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#timeouts ApigeeEnvironment#timeouts}
    */
    readonly timeouts?: ApigeeEnvironmentTimeouts;
}
export interface ApigeeEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#create ApigeeEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#delete ApigeeEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_environment#update ApigeeEnvironment#update}
    */
    readonly update?: string;
}
export declare function apigeeEnvironmentTimeoutsToTerraform(struct?: ApigeeEnvironmentTimeoutsOutputReference | ApigeeEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class ApigeeEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeEnvironmentTimeouts | undefined;
    set internalValue(value: ApigeeEnvironmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_environment google_apigee_environment}
*/
export declare class ApigeeEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_environment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_environment google_apigee_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeEnvironmentConfig);
    private _apiProxyType?;
    get apiProxyType(): string;
    set apiProxyType(value: string);
    resetApiProxyType(): void;
    get apiProxyTypeInput(): string | undefined;
    private _deploymentType?;
    get deploymentType(): string;
    set deploymentType(value: string);
    resetDeploymentType(): void;
    get deploymentTypeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApigeeEnvironmentTimeoutsOutputReference;
    putTimeouts(value: ApigeeEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApigeeEnvironmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
