import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppEngineFirewallRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The action to take if this rule matches. Possible values: ["UNSPECIFIED_ACTION", "ALLOW", "DENY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule#action AppEngineFirewallRule#action}
    */
    readonly action: string;
    /**
    * An optional string description of this rule.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule#description AppEngineFirewallRule#description}
    */
    readonly description?: string;
    /**
    * A positive integer that defines the order of rule evaluation.
  Rules with the lowest priority are evaluated first.
  
  A default rule at priority Int32.MaxValue matches all IPv4 and
  IPv6 traffic when no previous rule matches. Only the action of
  this rule can be modified by the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule#priority AppEngineFirewallRule#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule#project AppEngineFirewallRule#project}
    */
    readonly project?: string;
    /**
    * IP address or range, defined using CIDR notation, of requests that this rule applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule#source_range AppEngineFirewallRule#source_range}
    */
    readonly sourceRange: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule#timeouts AppEngineFirewallRule#timeouts}
    */
    readonly timeouts?: AppEngineFirewallRuleTimeouts;
}
export interface AppEngineFirewallRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule#create AppEngineFirewallRule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule#delete AppEngineFirewallRule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule#update AppEngineFirewallRule#update}
    */
    readonly update?: string;
}
export declare function appEngineFirewallRuleTimeoutsToTerraform(struct?: AppEngineFirewallRuleTimeoutsOutputReference | AppEngineFirewallRuleTimeouts | cdktf.IResolvable): any;
export declare class AppEngineFirewallRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppEngineFirewallRuleTimeouts | undefined;
    set internalValue(value: AppEngineFirewallRuleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule google_app_engine_firewall_rule}
*/
export declare class AppEngineFirewallRule extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_app_engine_firewall_rule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_firewall_rule google_app_engine_firewall_rule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppEngineFirewallRuleConfig
    */
    constructor(scope: Construct, id: string, config: AppEngineFirewallRuleConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _sourceRange?;
    get sourceRange(): string;
    set sourceRange(value: string);
    get sourceRangeInput(): string | undefined;
    private _timeouts;
    get timeouts(): AppEngineFirewallRuleTimeoutsOutputReference;
    putTimeouts(value: AppEngineFirewallRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppEngineFirewallRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
