import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigtableInstanceIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding#instance BigtableInstanceIamBinding#instance}
    */
    readonly instance: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding#members BigtableInstanceIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding#project BigtableInstanceIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding#role BigtableInstanceIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding#condition BigtableInstanceIamBinding#condition}
    */
    readonly condition?: BigtableInstanceIamBindingCondition;
}
export interface BigtableInstanceIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding#description BigtableInstanceIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding#expression BigtableInstanceIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding#title BigtableInstanceIamBinding#title}
    */
    readonly title: string;
}
export declare function bigtableInstanceIamBindingConditionToTerraform(struct?: BigtableInstanceIamBindingConditionOutputReference | BigtableInstanceIamBindingCondition): any;
export declare class BigtableInstanceIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigtableInstanceIamBindingCondition | undefined;
    set internalValue(value: BigtableInstanceIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding google_bigtable_instance_iam_binding}
*/
export declare class BigtableInstanceIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigtable_instance_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_instance_iam_binding google_bigtable_instance_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigtableInstanceIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: BigtableInstanceIamBindingConfig);
    get etag(): string;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): BigtableInstanceIamBindingConditionOutputReference;
    putCondition(value: BigtableInstanceIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): BigtableInstanceIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
