import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigtableTableIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member#instance BigtableTableIamMember#instance}
    */
    readonly instance: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member#member BigtableTableIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member#project BigtableTableIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member#role BigtableTableIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member#table BigtableTableIamMember#table}
    */
    readonly table: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member#condition BigtableTableIamMember#condition}
    */
    readonly condition?: BigtableTableIamMemberCondition;
}
export interface BigtableTableIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member#description BigtableTableIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member#expression BigtableTableIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member#title BigtableTableIamMember#title}
    */
    readonly title: string;
}
export declare function bigtableTableIamMemberConditionToTerraform(struct?: BigtableTableIamMemberConditionOutputReference | BigtableTableIamMemberCondition): any;
export declare class BigtableTableIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigtableTableIamMemberCondition | undefined;
    set internalValue(value: BigtableTableIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member google_bigtable_table_iam_member}
*/
export declare class BigtableTableIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigtable_table_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigtable_table_iam_member google_bigtable_table_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigtableTableIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: BigtableTableIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    get tableInput(): string | undefined;
    private _condition;
    get condition(): BigtableTableIamMemberConditionOutputReference;
    putCondition(value: BigtableTableIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): BigtableTableIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
