import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudbuildWorkerPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * User specified annotations. See https://google.aip.dev/128#annotations for more details such as format and size limitations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#annotations CloudbuildWorkerPool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * A user-specified, human-readable name for the `WorkerPool`. If provided, this value must be 1-63 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#display_name CloudbuildWorkerPool#display_name}
    */
    readonly displayName?: string;
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#location CloudbuildWorkerPool#location}
    */
    readonly location: string;
    /**
    * User-defined name of the `WorkerPool`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#name CloudbuildWorkerPool#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#project CloudbuildWorkerPool#project}
    */
    readonly project?: string;
    /**
    * network_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#network_config CloudbuildWorkerPool#network_config}
    */
    readonly networkConfig?: CloudbuildWorkerPoolNetworkConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#timeouts CloudbuildWorkerPool#timeouts}
    */
    readonly timeouts?: CloudbuildWorkerPoolTimeouts;
    /**
    * worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#worker_config CloudbuildWorkerPool#worker_config}
    */
    readonly workerConfig?: CloudbuildWorkerPoolWorkerConfig;
}
export interface CloudbuildWorkerPoolNetworkConfig {
    /**
    * Required. Immutable. The network definition that the workers are peered to. If this section is left empty, the workers will be peered to `WorkerPool.project_id` on the service producer network. Must be in the format `projects/{project}/global/networks/{network}`, where `{project}` is a project number, such as `12345`, and `{network}` is the name of a VPC network in the project. See [Understanding network configuration options](https://cloud.google.com/cloud-build/docs/custom-workers/set-up-custom-worker-pool-environment#understanding_the_network_configuration_options)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#peered_network CloudbuildWorkerPool#peered_network}
    */
    readonly peeredNetwork: string;
}
export declare function cloudbuildWorkerPoolNetworkConfigToTerraform(struct?: CloudbuildWorkerPoolNetworkConfigOutputReference | CloudbuildWorkerPoolNetworkConfig): any;
export declare class CloudbuildWorkerPoolNetworkConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudbuildWorkerPoolNetworkConfig | undefined;
    set internalValue(value: CloudbuildWorkerPoolNetworkConfig | undefined);
    private _peeredNetwork?;
    get peeredNetwork(): string;
    set peeredNetwork(value: string);
    get peeredNetworkInput(): string | undefined;
}
export interface CloudbuildWorkerPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#create CloudbuildWorkerPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#delete CloudbuildWorkerPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#update CloudbuildWorkerPool#update}
    */
    readonly update?: string;
}
export declare function cloudbuildWorkerPoolTimeoutsToTerraform(struct?: CloudbuildWorkerPoolTimeoutsOutputReference | CloudbuildWorkerPoolTimeouts | cdktf.IResolvable): any;
export declare class CloudbuildWorkerPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudbuildWorkerPoolTimeouts | undefined;
    set internalValue(value: CloudbuildWorkerPoolTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CloudbuildWorkerPoolWorkerConfig {
    /**
    * Size of the disk attached to the worker, in GB. See [Worker pool config file](https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). Specify a value of up to 1000. If `0` is specified, Cloud Build will use a standard disk size.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#disk_size_gb CloudbuildWorkerPool#disk_size_gb}
    */
    readonly diskSizeGb?: number;
    /**
    * Machine type of a worker, such as `n1-standard-1`. See [Worker pool config file](https://cloud.google.com/cloud-build/docs/custom-workers/worker-pool-config-file). If left blank, Cloud Build will use `n1-standard-1`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#machine_type CloudbuildWorkerPool#machine_type}
    */
    readonly machineType?: string;
    /**
    * If true, workers are created without any public address, which prevents network egress to public IPs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool#no_external_ip CloudbuildWorkerPool#no_external_ip}
    */
    readonly noExternalIp?: boolean | cdktf.IResolvable;
}
export declare function cloudbuildWorkerPoolWorkerConfigToTerraform(struct?: CloudbuildWorkerPoolWorkerConfigOutputReference | CloudbuildWorkerPoolWorkerConfig): any;
export declare class CloudbuildWorkerPoolWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CloudbuildWorkerPoolWorkerConfig | undefined;
    set internalValue(value: CloudbuildWorkerPoolWorkerConfig | undefined);
    private _diskSizeGb?;
    get diskSizeGb(): number;
    set diskSizeGb(value: number);
    resetDiskSizeGb(): void;
    get diskSizeGbInput(): number | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _noExternalIp?;
    get noExternalIp(): boolean | cdktf.IResolvable;
    set noExternalIp(value: boolean | cdktf.IResolvable);
    resetNoExternalIp(): void;
    get noExternalIpInput(): boolean | cdktf.IResolvable | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool google_cloudbuild_worker_pool}
*/
export declare class CloudbuildWorkerPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_cloudbuild_worker_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloudbuild_worker_pool google_cloudbuild_worker_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudbuildWorkerPoolConfig
    */
    constructor(scope: Construct, id: string, config: CloudbuildWorkerPoolConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    get createTime(): string;
    get deleteTime(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get uid(): string;
    get updateTime(): string;
    private _networkConfig;
    get networkConfig(): CloudbuildWorkerPoolNetworkConfigOutputReference;
    putNetworkConfig(value: CloudbuildWorkerPoolNetworkConfig): void;
    resetNetworkConfig(): void;
    get networkConfigInput(): CloudbuildWorkerPoolNetworkConfig | undefined;
    private _timeouts;
    get timeouts(): CloudbuildWorkerPoolTimeoutsOutputReference;
    putTimeouts(value: CloudbuildWorkerPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudbuildWorkerPoolTimeouts | undefined;
    private _workerConfig;
    get workerConfig(): CloudbuildWorkerPoolWorkerConfigOutputReference;
    putWorkerConfig(value: CloudbuildWorkerPoolWorkerConfig): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): CloudbuildWorkerPoolWorkerConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
