import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeFirewallConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#description ComputeFirewall#description}
    */
    readonly description?: string;
    /**
    * If destination ranges are specified, the firewall will apply only to
  traffic that has destination IP address in these ranges. These ranges
  must be expressed in CIDR format. Only IPv4 is supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#destination_ranges ComputeFirewall#destination_ranges}
    */
    readonly destinationRanges?: string[];
    /**
    * Direction of traffic to which this firewall applies; default is
  INGRESS. Note: For INGRESS traffic, it is NOT supported to specify
  destinationRanges; For EGRESS traffic, it is NOT supported to specify
  'source_ranges' OR 'source_tags'. For INGRESS traffic, one of 'source_ranges',
  'source_tags' or 'source_service_accounts' is required. Possible values: ["INGRESS", "EGRESS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#direction ComputeFirewall#direction}
    */
    readonly direction?: string;
    /**
    * Denotes whether the firewall rule is disabled, i.e not applied to the
  network it is associated with. When set to true, the firewall rule is
  not enforced and the network behaves as if it did not exist. If this
  is unspecified, the firewall rule will be enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#disabled ComputeFirewall#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * This field denotes whether to enable logging for a particular firewall rule. If logging is enabled, logs will be exported to Stackdriver.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#enable_logging ComputeFirewall#enable_logging}
    */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#name ComputeFirewall#name}
    */
    readonly name: string;
    /**
    * The name or self_link of the network to attach this firewall to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#network ComputeFirewall#network}
    */
    readonly network: string;
    /**
    * Priority for this rule. This is an integer between 0 and 65535, both
  inclusive. When not specified, the value assumed is 1000. Relative
  priorities determine precedence of conflicting rules. Lower value of
  priority implies higher precedence (eg, a rule with priority 0 has
  higher precedence than a rule with priority 1). DENY rules take
  precedence over ALLOW rules having equal priority.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#priority ComputeFirewall#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#project ComputeFirewall#project}
    */
    readonly project?: string;
    /**
    * If source ranges are specified, the firewall will apply only to
  traffic that has source IP address in these ranges. These ranges must
  be expressed in CIDR format. One or both of sourceRanges and
  sourceTags may be set. If both properties are set, the firewall will
  apply to traffic that has source IP address within sourceRanges OR the
  source IP that belongs to a tag listed in the sourceTags property. The
  connection does not need to match both properties for the firewall to
  apply. Only IPv4 is supported. For INGRESS traffic, one of 'source_ranges',
  'source_tags' or 'source_service_accounts' is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#source_ranges ComputeFirewall#source_ranges}
    */
    readonly sourceRanges?: string[];
    /**
    * If source service accounts are specified, the firewall will apply only
  to traffic originating from an instance with a service account in this
  list. Source service accounts cannot be used to control traffic to an
  instance's external IP address because service accounts are associated
  with an instance, not an IP address. sourceRanges can be set at the
  same time as sourceServiceAccounts. If both are set, the firewall will
  apply to traffic that has source IP address within sourceRanges OR the
  source IP belongs to an instance with service account listed in
  sourceServiceAccount. The connection does not need to match both
  properties for the firewall to apply. sourceServiceAccounts cannot be
  used at the same time as sourceTags or targetTags. For INGRESS traffic,
  one of 'source_ranges', 'source_tags' or 'source_service_accounts' is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#source_service_accounts ComputeFirewall#source_service_accounts}
    */
    readonly sourceServiceAccounts?: string[];
    /**
    * If source tags are specified, the firewall will apply only to traffic
  with source IP that belongs to a tag listed in source tags. Source
  tags cannot be used to control traffic to an instance's external IP
  address. Because tags are associated with an instance, not an IP
  address. One or both of sourceRanges and sourceTags may be set. If
  both properties are set, the firewall will apply to traffic that has
  source IP address within sourceRanges OR the source IP that belongs to
  a tag listed in the sourceTags property. The connection does not need
  to match both properties for the firewall to apply. For INGRESS traffic,
  one of 'source_ranges', 'source_tags' or 'source_service_accounts' is required.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#source_tags ComputeFirewall#source_tags}
    */
    readonly sourceTags?: string[];
    /**
    * A list of service accounts indicating sets of instances located in the
  network that may make network connections as specified in allowed[].
  targetServiceAccounts cannot be used at the same time as targetTags or
  sourceTags. If neither targetServiceAccounts nor targetTags are
  specified, the firewall rule applies to all instances on the specified
  network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#target_service_accounts ComputeFirewall#target_service_accounts}
    */
    readonly targetServiceAccounts?: string[];
    /**
    * A list of instance tags indicating sets of instances located in the
  network that may make network connections as specified in allowed[].
  If no targetTags are specified, the firewall rule applies to all
  instances on the specified network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#target_tags ComputeFirewall#target_tags}
    */
    readonly targetTags?: string[];
    /**
    * allow block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#allow ComputeFirewall#allow}
    */
    readonly allow?: ComputeFirewallAllow[] | cdktf.IResolvable;
    /**
    * deny block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#deny ComputeFirewall#deny}
    */
    readonly deny?: ComputeFirewallDeny[] | cdktf.IResolvable;
    /**
    * log_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#log_config ComputeFirewall#log_config}
    */
    readonly logConfig?: ComputeFirewallLogConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#timeouts ComputeFirewall#timeouts}
    */
    readonly timeouts?: ComputeFirewallTimeouts;
}
export interface ComputeFirewallAllow {
    /**
    * An optional list of ports to which this rule applies. This field
  is only applicable for UDP or TCP protocol. Each entry must be
  either an integer or a range. If not specified, this rule
  applies to connections through any port.
  
  Example inputs include: ["22"], ["80","443"], and
  ["12345-12349"].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#ports ComputeFirewall#ports}
    */
    readonly ports?: string[];
    /**
    * The IP protocol to which this rule applies. The protocol type is
  required when creating a firewall rule. This value can either be
  one of the following well known protocol strings (tcp, udp,
  icmp, esp, ah, sctp, ipip, all), or the IP protocol number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#protocol ComputeFirewall#protocol}
    */
    readonly protocol: string;
}
export declare function computeFirewallAllowToTerraform(struct?: ComputeFirewallAllow | cdktf.IResolvable): any;
export interface ComputeFirewallDeny {
    /**
    * An optional list of ports to which this rule applies. This field
  is only applicable for UDP or TCP protocol. Each entry must be
  either an integer or a range. If not specified, this rule
  applies to connections through any port.
  
  Example inputs include: ["22"], ["80","443"], and
  ["12345-12349"].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#ports ComputeFirewall#ports}
    */
    readonly ports?: string[];
    /**
    * The IP protocol to which this rule applies. The protocol type is
  required when creating a firewall rule. This value can either be
  one of the following well known protocol strings (tcp, udp,
  icmp, esp, ah, sctp, ipip, all), or the IP protocol number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#protocol ComputeFirewall#protocol}
    */
    readonly protocol: string;
}
export declare function computeFirewallDenyToTerraform(struct?: ComputeFirewallDeny | cdktf.IResolvable): any;
export interface ComputeFirewallLogConfig {
    /**
    * This field denotes whether to include or exclude metadata for firewall logs. Possible values: ["EXCLUDE_ALL_METADATA", "INCLUDE_ALL_METADATA"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#metadata ComputeFirewall#metadata}
    */
    readonly metadata: string;
}
export declare function computeFirewallLogConfigToTerraform(struct?: ComputeFirewallLogConfigOutputReference | ComputeFirewallLogConfig): any;
export declare class ComputeFirewallLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeFirewallLogConfig | undefined;
    set internalValue(value: ComputeFirewallLogConfig | undefined);
    private _metadata?;
    get metadata(): string;
    set metadata(value: string);
    get metadataInput(): string | undefined;
}
export interface ComputeFirewallTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#create ComputeFirewall#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#delete ComputeFirewall#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall#update ComputeFirewall#update}
    */
    readonly update?: string;
}
export declare function computeFirewallTimeoutsToTerraform(struct?: ComputeFirewallTimeoutsOutputReference | ComputeFirewallTimeouts | cdktf.IResolvable): any;
export declare class ComputeFirewallTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeFirewallTimeouts | undefined;
    set internalValue(value: ComputeFirewallTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_firewall google_compute_firewall}
*/
export declare class ComputeFirewall extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_firewall";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_firewall google_compute_firewall} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeFirewallConfig
    */
    constructor(scope: Construct, id: string, config: ComputeFirewallConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destinationRanges?;
    get destinationRanges(): string[];
    set destinationRanges(value: string[]);
    resetDestinationRanges(): void;
    get destinationRangesInput(): string[] | undefined;
    private _direction?;
    get direction(): string;
    set direction(value: string);
    resetDirection(): void;
    get directionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    get enableLogging(): boolean | cdktf.IResolvable;
    set enableLogging(value: boolean | cdktf.IResolvable);
    resetEnableLogging(): void;
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    resetPriority(): void;
    get priorityInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _sourceRanges?;
    get sourceRanges(): string[];
    set sourceRanges(value: string[]);
    resetSourceRanges(): void;
    get sourceRangesInput(): string[] | undefined;
    private _sourceServiceAccounts?;
    get sourceServiceAccounts(): string[];
    set sourceServiceAccounts(value: string[]);
    resetSourceServiceAccounts(): void;
    get sourceServiceAccountsInput(): string[] | undefined;
    private _sourceTags?;
    get sourceTags(): string[];
    set sourceTags(value: string[]);
    resetSourceTags(): void;
    get sourceTagsInput(): string[] | undefined;
    private _targetServiceAccounts?;
    get targetServiceAccounts(): string[];
    set targetServiceAccounts(value: string[]);
    resetTargetServiceAccounts(): void;
    get targetServiceAccountsInput(): string[] | undefined;
    private _targetTags?;
    get targetTags(): string[];
    set targetTags(value: string[]);
    resetTargetTags(): void;
    get targetTagsInput(): string[] | undefined;
    private _allow?;
    get allow(): ComputeFirewallAllow[] | cdktf.IResolvable;
    set allow(value: ComputeFirewallAllow[] | cdktf.IResolvable);
    resetAllow(): void;
    get allowInput(): cdktf.IResolvable | ComputeFirewallAllow[] | undefined;
    private _deny?;
    get deny(): ComputeFirewallDeny[] | cdktf.IResolvable;
    set deny(value: ComputeFirewallDeny[] | cdktf.IResolvable);
    resetDeny(): void;
    get denyInput(): cdktf.IResolvable | ComputeFirewallDeny[] | undefined;
    private _logConfig;
    get logConfig(): ComputeFirewallLogConfigOutputReference;
    putLogConfig(value: ComputeFirewallLogConfig): void;
    resetLogConfig(): void;
    get logConfigInput(): ComputeFirewallLogConfig | undefined;
    private _timeouts;
    get timeouts(): ComputeFirewallTimeoutsOutputReference;
    putTimeouts(value: ComputeFirewallTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeFirewallTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
