import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeImageIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding#image ComputeImageIamBinding#image}
    */
    readonly image: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding#members ComputeImageIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding#project ComputeImageIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding#role ComputeImageIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding#condition ComputeImageIamBinding#condition}
    */
    readonly condition?: ComputeImageIamBindingCondition;
}
export interface ComputeImageIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding#description ComputeImageIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding#expression ComputeImageIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding#title ComputeImageIamBinding#title}
    */
    readonly title: string;
}
export declare function computeImageIamBindingConditionToTerraform(struct?: ComputeImageIamBindingConditionOutputReference | ComputeImageIamBindingCondition): any;
export declare class ComputeImageIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeImageIamBindingCondition | undefined;
    set internalValue(value: ComputeImageIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding google_compute_image_iam_binding}
*/
export declare class ComputeImageIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_image_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_image_iam_binding google_compute_image_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeImageIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: ComputeImageIamBindingConfig);
    get etag(): string;
    get id(): string;
    private _image?;
    get image(): string;
    set image(value: string);
    get imageInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): ComputeImageIamBindingConditionOutputReference;
    putCondition(value: ComputeImageIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): ComputeImageIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
