import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeSharedVpcServiceProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The ID of a host project to associate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#host_project ComputeSharedVpcServiceProject#host_project}
    */
    readonly hostProject: string;
    /**
    * The ID of the project that will serve as a Shared VPC service project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#service_project ComputeSharedVpcServiceProject#service_project}
    */
    readonly serviceProject: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#timeouts ComputeSharedVpcServiceProject#timeouts}
    */
    readonly timeouts?: ComputeSharedVpcServiceProjectTimeouts;
}
export interface ComputeSharedVpcServiceProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#create ComputeSharedVpcServiceProject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project#delete ComputeSharedVpcServiceProject#delete}
    */
    readonly delete?: string;
}
export declare function computeSharedVpcServiceProjectTimeoutsToTerraform(struct?: ComputeSharedVpcServiceProjectTimeoutsOutputReference | ComputeSharedVpcServiceProjectTimeouts | cdktf.IResolvable): any;
export declare class ComputeSharedVpcServiceProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeSharedVpcServiceProjectTimeouts | undefined;
    set internalValue(value: ComputeSharedVpcServiceProjectTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project google_compute_shared_vpc_service_project}
*/
export declare class ComputeSharedVpcServiceProject extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_shared_vpc_service_project";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_shared_vpc_service_project google_compute_shared_vpc_service_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeSharedVpcServiceProjectConfig
    */
    constructor(scope: Construct, id: string, config: ComputeSharedVpcServiceProjectConfig);
    private _hostProject?;
    get hostProject(): string;
    set hostProject(value: string);
    get hostProjectInput(): string | undefined;
    get id(): string;
    private _serviceProject?;
    get serviceProject(): string;
    set serviceProject(value: string);
    get serviceProjectInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeSharedVpcServiceProjectTimeoutsOutputReference;
    putTimeouts(value: ComputeSharedVpcServiceProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ComputeSharedVpcServiceProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
