import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleComputeSslCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
  
  
  These are in the same namespace as the managed SSL certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_ssl_certificate#name DataGoogleComputeSslCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/compute_ssl_certificate#project DataGoogleComputeSslCertificate#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/compute_ssl_certificate google_compute_ssl_certificate}
*/
export declare class DataGoogleComputeSslCertificate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_compute_ssl_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/compute_ssl_certificate google_compute_ssl_certificate} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleComputeSslCertificateConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleComputeSslCertificateConfig);
    get certificate(): string;
    get certificateId(): number;
    get creationTimestamp(): string;
    get description(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get namePrefix(): string;
    get privateKey(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
