import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleKmsCryptoKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The KeyRing that this key belongs to.
  Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}''.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key#key_ring DataGoogleKmsCryptoKey#key_ring}
    */
    readonly keyRing: string;
    /**
    * The resource name for the CryptoKey.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key#name DataGoogleKmsCryptoKey#name}
    */
    readonly name: string;
}
export interface DataGoogleKmsCryptoKeyVersionTemplate {
}
export declare function dataGoogleKmsCryptoKeyVersionTemplateToTerraform(struct?: DataGoogleKmsCryptoKeyVersionTemplate): any;
export declare class DataGoogleKmsCryptoKeyVersionTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleKmsCryptoKeyVersionTemplate | undefined;
    set internalValue(value: DataGoogleKmsCryptoKeyVersionTemplate | undefined);
    get algorithm(): string;
    get protectionLevel(): string;
}
export declare class DataGoogleKmsCryptoKeyVersionTemplateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleKmsCryptoKeyVersionTemplateOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key google_kms_crypto_key}
*/
export declare class DataGoogleKmsCryptoKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_kms_crypto_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_crypto_key google_kms_crypto_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleKmsCryptoKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleKmsCryptoKeyConfig);
    get destroyScheduledDuration(): string;
    get id(): string;
    get importOnly(): cdktf.IResolvable;
    private _keyRing?;
    get keyRing(): string;
    set keyRing(value: string);
    get keyRingInput(): string | undefined;
    labels(key: string): string | cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get purpose(): string;
    get rotationPeriod(): string;
    get skipInitialVersionCreation(): cdktf.IResolvable;
    private _versionTemplate;
    get versionTemplate(): DataGoogleKmsCryptoKeyVersionTemplateList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
