import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataGoogleSecretManagerSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret#project DataGoogleSecretManagerSecret#project}
    */
    readonly project?: string;
    /**
    * This must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret#secret_id DataGoogleSecretManagerSecret#secret_id}
    */
    readonly secretId: string;
}
export interface DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption {
}
export declare function dataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionToTerraform(struct?: DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption): any;
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryption | undefined);
    get kmsKeyName(): string;
}
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionOutputReference;
}
export interface DataGoogleSecretManagerSecretReplicationUserManagedReplicas {
}
export declare function dataGoogleSecretManagerSecretReplicationUserManagedReplicasToTerraform(struct?: DataGoogleSecretManagerSecretReplicationUserManagedReplicas): any;
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplicationUserManagedReplicas | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplicationUserManagedReplicas | undefined);
    private _customerManagedEncryption;
    get customerManagedEncryption(): DataGoogleSecretManagerSecretReplicationUserManagedReplicasCustomerManagedEncryptionList;
    get location(): string;
}
export declare class DataGoogleSecretManagerSecretReplicationUserManagedReplicasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationUserManagedReplicasOutputReference;
}
export interface DataGoogleSecretManagerSecretReplicationUserManaged {
}
export declare function dataGoogleSecretManagerSecretReplicationUserManagedToTerraform(struct?: DataGoogleSecretManagerSecretReplicationUserManaged): any;
export declare class DataGoogleSecretManagerSecretReplicationUserManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplicationUserManaged | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplicationUserManaged | undefined);
    private _replicas;
    get replicas(): DataGoogleSecretManagerSecretReplicationUserManagedReplicasList;
}
export declare class DataGoogleSecretManagerSecretReplicationUserManagedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationUserManagedOutputReference;
}
export interface DataGoogleSecretManagerSecretReplication {
}
export declare function dataGoogleSecretManagerSecretReplicationToTerraform(struct?: DataGoogleSecretManagerSecretReplication): any;
export declare class DataGoogleSecretManagerSecretReplicationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretReplication | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretReplication | undefined);
    get automatic(): cdktf.IResolvable;
    private _userManaged;
    get userManaged(): DataGoogleSecretManagerSecretReplicationUserManagedList;
}
export declare class DataGoogleSecretManagerSecretReplicationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretReplicationOutputReference;
}
export interface DataGoogleSecretManagerSecretRotation {
}
export declare function dataGoogleSecretManagerSecretRotationToTerraform(struct?: DataGoogleSecretManagerSecretRotation): any;
export declare class DataGoogleSecretManagerSecretRotationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretRotation | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretRotation | undefined);
    get nextRotationTime(): string;
    get rotationPeriod(): string;
}
export declare class DataGoogleSecretManagerSecretRotationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretRotationOutputReference;
}
export interface DataGoogleSecretManagerSecretTopics {
}
export declare function dataGoogleSecretManagerSecretTopicsToTerraform(struct?: DataGoogleSecretManagerSecretTopics): any;
export declare class DataGoogleSecretManagerSecretTopicsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataGoogleSecretManagerSecretTopics | undefined;
    set internalValue(value: DataGoogleSecretManagerSecretTopics | undefined);
    get name(): string;
}
export declare class DataGoogleSecretManagerSecretTopicsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataGoogleSecretManagerSecretTopicsOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret google_secret_manager_secret}
*/
export declare class DataGoogleSecretManagerSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "google_secret_manager_secret";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/d/secret_manager_secret google_secret_manager_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataGoogleSecretManagerSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataGoogleSecretManagerSecretConfig);
    get createTime(): string;
    get expireTime(): string;
    get id(): string;
    labels(key: string): string | cdktf.IResolvable;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _replication;
    get replication(): DataGoogleSecretManagerSecretReplicationList;
    private _rotation;
    get rotation(): DataGoogleSecretManagerSecretRotationList;
    private _secretId?;
    get secretId(): string;
    set secretId(value: string);
    get secretIdInput(): string | undefined;
    private _topics;
    get topics(): DataGoogleSecretManagerSecretTopicsList;
    get ttl(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
