import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The timeout duration which allows graceful decomissioning when you change the number of worker nodes directly through a terraform apply
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#graceful_decommission_timeout DataprocCluster#graceful_decommission_timeout}
    */
    readonly gracefulDecommissionTimeout?: string;
    /**
    * The list of labels (key/value pairs) to be applied to instances in the cluster. GCP generates some itself including goog-dataproc-cluster-name which is the name of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#labels DataprocCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the cluster, unique within the project and zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#name DataprocCluster#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the cluster will exist. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#project DataprocCluster#project}
    */
    readonly project?: string;
    /**
    * The region in which the cluster and associated nodes will be created in. Defaults to global.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#region DataprocCluster#region}
    */
    readonly region?: string;
    /**
    * cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cluster_config DataprocCluster#cluster_config}
    */
    readonly clusterConfig?: DataprocClusterClusterConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#timeouts DataprocCluster#timeouts}
    */
    readonly timeouts?: DataprocClusterTimeouts;
}
export interface DataprocClusterClusterConfigAutoscalingConfig {
    /**
    * The autoscaling policy used by the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#policy_uri DataprocCluster#policy_uri}
    */
    readonly policyUri: string;
}
export declare function dataprocClusterClusterConfigAutoscalingConfigToTerraform(struct?: DataprocClusterClusterConfigAutoscalingConfigOutputReference | DataprocClusterClusterConfigAutoscalingConfig): any;
export declare class DataprocClusterClusterConfigAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigAutoscalingConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigAutoscalingConfig | undefined);
    private _policyUri?;
    get policyUri(): string;
    set policyUri(value: string);
    get policyUriInput(): string | undefined;
}
export interface DataprocClusterClusterConfigEncryptionConfig {
    /**
    * The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kms_key_name DataprocCluster#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function dataprocClusterClusterConfigEncryptionConfigToTerraform(struct?: DataprocClusterClusterConfigEncryptionConfigOutputReference | DataprocClusterClusterConfigEncryptionConfig): any;
export declare class DataprocClusterClusterConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigEncryptionConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig {
    /**
    * Defines whether instances have integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#enable_integrity_monitoring DataprocCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether instances have Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#enable_secure_boot DataprocCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Defines whether instances have the vTPM enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#enable_vtpm DataprocCluster#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function dataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigToTerraform(struct?: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference | DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig): any;
export declare class DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataprocClusterClusterConfigGceClusterConfig {
    /**
    * By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. If set to true, all instances in the cluster will only have internal IP addresses. Note: Private Google Access (also known as privateIpGoogleAccess) must be enabled on the subnetwork that the cluster will be launched in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#internal_ip_only DataprocCluster#internal_ip_only}
    */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
    * A map of the Compute Engine metadata entries to add to all instances
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#metadata DataprocCluster#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The name or self_link of the Google Compute Engine network to the cluster will be part of. Conflicts with subnetwork. If neither is specified, this defaults to the "default" network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#network DataprocCluster#network}
    */
    readonly network?: string;
    /**
    * The service account to be used by the Node VMs. If not specified, the "default" service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#service_account DataprocCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs under the service_account specified. These can be either FQDNs, or scope aliases.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#service_account_scopes DataprocCluster#service_account_scopes}
    */
    readonly serviceAccountScopes?: string[];
    /**
    * The name or self_link of the Google Compute Engine subnetwork the cluster will be part of. Conflicts with network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#subnetwork DataprocCluster#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The list of instance tags applied to instances in the cluster. Tags are used to identify valid sources or targets for network firewalls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#tags DataprocCluster#tags}
    */
    readonly tags?: string[];
    /**
    * The GCP zone where your data is stored and used (i.e. where the master and the worker nodes will be created in). If region is set to 'global' (default) then zone is mandatory, otherwise GCP is able to make use of Auto Zone Placement to determine this automatically for you. Note: This setting additionally determines and restricts which computing resources are available for use with other configs such as cluster_config.master_config.machine_type and cluster_config.worker_config.machine_type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#zone DataprocCluster#zone}
    */
    readonly zone?: string;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#shielded_instance_config DataprocCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig;
}
export declare function dataprocClusterClusterConfigGceClusterConfigToTerraform(struct?: DataprocClusterClusterConfigGceClusterConfigOutputReference | DataprocClusterClusterConfigGceClusterConfig): any;
export declare class DataprocClusterClusterConfigGceClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigGceClusterConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigGceClusterConfig | undefined);
    private _internalIpOnly?;
    get internalIpOnly(): boolean | cdktf.IResolvable;
    set internalIpOnly(value: boolean | cdktf.IResolvable);
    resetInternalIpOnly(): void;
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[];
    set serviceAccountScopes(value: string[]);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined;
}
export interface DataprocClusterClusterConfigInitializationAction {
    /**
    * The script to be executed during initialization of the cluster. The script must be a GCS file with a gs:// prefix.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#script DataprocCluster#script}
    */
    readonly script: string;
    /**
    * The maximum duration (in seconds) which script is allowed to take to execute its action. GCP will default to a predetermined computed value if not set (currently 300).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#timeout_sec DataprocCluster#timeout_sec}
    */
    readonly timeoutSec?: number;
}
export declare function dataprocClusterClusterConfigInitializationActionToTerraform(struct?: DataprocClusterClusterConfigInitializationAction | cdktf.IResolvable): any;
export interface DataprocClusterClusterConfigMasterConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance. Often restricted to one of 1, 2, 4, or 8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerator_count DataprocCluster#accelerator_count}
    */
    readonly acceleratorCount: number;
    /**
    * The short name of the accelerator type to expose to this instance. For example, nvidia-tesla-k80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerator_type DataprocCluster#accelerator_type}
    */
    readonly acceleratorType: string;
}
export declare function dataprocClusterClusterConfigMasterConfigAcceleratorsToTerraform(struct?: DataprocClusterClusterConfigMasterConfigAccelerators | cdktf.IResolvable): any;
export interface DataprocClusterClusterConfigMasterConfigDiskConfig {
    /**
    * Size of the primary disk attached to each node, specified in GB. The primary disk contains the boot volume and system libraries, and the smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_size_gb DataprocCluster#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The disk type of the primary disk attached to each node. One of "pd-ssd" or "pd-standard". Defaults to "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_type DataprocCluster#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * The amount of local SSD disks that will be attached to each master cluster node. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_local_ssds DataprocCluster#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function dataprocClusterClusterConfigMasterConfigDiskConfigToTerraform(struct?: DataprocClusterClusterConfigMasterConfigDiskConfigOutputReference | DataprocClusterClusterConfigMasterConfigDiskConfig): any;
export declare class DataprocClusterClusterConfigMasterConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigMasterConfigDiskConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigMasterConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocClusterClusterConfigMasterConfig {
    /**
    * The URI for the image to use for this master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#image_uri DataprocCluster#image_uri}
    */
    readonly imageUri?: string;
    /**
    * The name of a Google Compute Engine machine type to create for the master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#machine_type DataprocCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The name of a minimum generation of CPU family for the master/worker. If not specified, GCP will default to a predetermined computed value for each zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#min_cpu_platform DataprocCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Specifies the number of master/worker nodes to create. If not specified, GCP will default to a predetermined computed value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_instances DataprocCluster#num_instances}
    */
    readonly numInstances?: number;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerators DataprocCluster#accelerators}
    */
    readonly accelerators?: DataprocClusterClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#disk_config DataprocCluster#disk_config}
    */
    readonly diskConfig?: DataprocClusterClusterConfigMasterConfigDiskConfig;
}
export declare function dataprocClusterClusterConfigMasterConfigToTerraform(struct?: DataprocClusterClusterConfigMasterConfigOutputReference | DataprocClusterClusterConfigMasterConfig): any;
export declare class DataprocClusterClusterConfigMasterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigMasterConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigMasterConfig | undefined);
    private _imageUri?;
    get imageUri(): string;
    set imageUri(value: string);
    resetImageUri(): void;
    get imageUriInput(): string | undefined;
    get instanceNames(): string[];
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _accelerators?;
    get accelerators(): DataprocClusterClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    set accelerators(value: DataprocClusterClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable);
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | DataprocClusterClusterConfigMasterConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): DataprocClusterClusterConfigMasterConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocClusterClusterConfigMasterConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocClusterClusterConfigMasterConfigDiskConfig | undefined;
}
export interface DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig {
    /**
    * Size of the primary disk attached to each preemptible worker node, specified in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_size_gb DataprocCluster#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The disk type of the primary disk attached to each preemptible worker node. One of "pd-ssd" or "pd-standard". Defaults to "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_type DataprocCluster#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * The amount of local SSD disks that will be attached to each preemptible worker node. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_local_ssds DataprocCluster#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function dataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigToTerraform(struct?: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference | DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig): any;
export declare class DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocClusterClusterConfigPreemptibleWorkerConfig {
    /**
    * Specifies the number of preemptible nodes to create. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_instances DataprocCluster#num_instances}
    */
    readonly numInstances?: number;
    /**
    * Specifies the preemptibility of the secondary nodes. Defaults to PREEMPTIBLE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#preemptibility DataprocCluster#preemptibility}
    */
    readonly preemptibility?: string;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#disk_config DataprocCluster#disk_config}
    */
    readonly diskConfig?: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig;
}
export declare function dataprocClusterClusterConfigPreemptibleWorkerConfigToTerraform(struct?: DataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference | DataprocClusterClusterConfigPreemptibleWorkerConfig): any;
export declare class DataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigPreemptibleWorkerConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigPreemptibleWorkerConfig | undefined);
    get instanceNames(): string[];
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string;
    set preemptibility(value: string);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _diskConfig;
    get diskConfig(): DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined;
}
export interface DataprocClusterClusterConfigSecurityConfigKerberosConfig {
    /**
    * The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cross_realm_trust_admin_server DataprocCluster#cross_realm_trust_admin_server}
    */
    readonly crossRealmTrustAdminServer?: string;
    /**
    * The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cross_realm_trust_kdc DataprocCluster#cross_realm_trust_kdc}
    */
    readonly crossRealmTrustKdc?: string;
    /**
    * The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cross_realm_trust_realm DataprocCluster#cross_realm_trust_realm}
    */
    readonly crossRealmTrustRealm?: string;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster
  Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cross_realm_trust_shared_password_uri DataprocCluster#cross_realm_trust_shared_password_uri}
    */
    readonly crossRealmTrustSharedPasswordUri?: string;
    /**
    * Flag to indicate whether to Kerberize the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#enable_kerberos DataprocCluster#enable_kerberos}
    */
    readonly enableKerberos?: boolean | cdktf.IResolvable;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kdc_db_key_uri DataprocCluster#kdc_db_key_uri}
    */
    readonly kdcDbKeyUri?: string;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#key_password_uri DataprocCluster#key_password_uri}
    */
    readonly keyPasswordUri?: string;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing
  the password to the user provided keystore. For the self-signed certificate, this password is generated
  by Dataproc
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#keystore_password_uri DataprocCluster#keystore_password_uri}
    */
    readonly keystorePasswordUri?: string;
    /**
    * The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#keystore_uri DataprocCluster#keystore_uri}
    */
    readonly keystoreUri?: string;
    /**
    * The uri of the KMS key used to encrypt various sensitive files.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kms_key_uri DataprocCluster#kms_key_uri}
    */
    readonly kmsKeyUri: string;
    /**
    * The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#realm DataprocCluster#realm}
    */
    readonly realm?: string;
    /**
    * The cloud Storage URI of a KMS encrypted file containing the root principal password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#root_principal_password_uri DataprocCluster#root_principal_password_uri}
    */
    readonly rootPrincipalPasswordUri: string;
    /**
    * The lifetime of the ticket granting ticket, in hours.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#tgt_lifetime_hours DataprocCluster#tgt_lifetime_hours}
    */
    readonly tgtLifetimeHours?: number;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#truststore_password_uri DataprocCluster#truststore_password_uri}
    */
    readonly truststorePasswordUri?: string;
    /**
    * The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#truststore_uri DataprocCluster#truststore_uri}
    */
    readonly truststoreUri?: string;
}
export declare function dataprocClusterClusterConfigSecurityConfigKerberosConfigToTerraform(struct?: DataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference | DataprocClusterClusterConfigSecurityConfigKerberosConfig): any;
export declare class DataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined);
    private _crossRealmTrustAdminServer?;
    get crossRealmTrustAdminServer(): string;
    set crossRealmTrustAdminServer(value: string);
    resetCrossRealmTrustAdminServer(): void;
    get crossRealmTrustAdminServerInput(): string | undefined;
    private _crossRealmTrustKdc?;
    get crossRealmTrustKdc(): string;
    set crossRealmTrustKdc(value: string);
    resetCrossRealmTrustKdc(): void;
    get crossRealmTrustKdcInput(): string | undefined;
    private _crossRealmTrustRealm?;
    get crossRealmTrustRealm(): string;
    set crossRealmTrustRealm(value: string);
    resetCrossRealmTrustRealm(): void;
    get crossRealmTrustRealmInput(): string | undefined;
    private _crossRealmTrustSharedPasswordUri?;
    get crossRealmTrustSharedPasswordUri(): string;
    set crossRealmTrustSharedPasswordUri(value: string);
    resetCrossRealmTrustSharedPasswordUri(): void;
    get crossRealmTrustSharedPasswordUriInput(): string | undefined;
    private _enableKerberos?;
    get enableKerberos(): boolean | cdktf.IResolvable;
    set enableKerberos(value: boolean | cdktf.IResolvable);
    resetEnableKerberos(): void;
    get enableKerberosInput(): boolean | cdktf.IResolvable | undefined;
    private _kdcDbKeyUri?;
    get kdcDbKeyUri(): string;
    set kdcDbKeyUri(value: string);
    resetKdcDbKeyUri(): void;
    get kdcDbKeyUriInput(): string | undefined;
    private _keyPasswordUri?;
    get keyPasswordUri(): string;
    set keyPasswordUri(value: string);
    resetKeyPasswordUri(): void;
    get keyPasswordUriInput(): string | undefined;
    private _keystorePasswordUri?;
    get keystorePasswordUri(): string;
    set keystorePasswordUri(value: string);
    resetKeystorePasswordUri(): void;
    get keystorePasswordUriInput(): string | undefined;
    private _keystoreUri?;
    get keystoreUri(): string;
    set keystoreUri(value: string);
    resetKeystoreUri(): void;
    get keystoreUriInput(): string | undefined;
    private _kmsKeyUri?;
    get kmsKeyUri(): string;
    set kmsKeyUri(value: string);
    get kmsKeyUriInput(): string | undefined;
    private _realm?;
    get realm(): string;
    set realm(value: string);
    resetRealm(): void;
    get realmInput(): string | undefined;
    private _rootPrincipalPasswordUri?;
    get rootPrincipalPasswordUri(): string;
    set rootPrincipalPasswordUri(value: string);
    get rootPrincipalPasswordUriInput(): string | undefined;
    private _tgtLifetimeHours?;
    get tgtLifetimeHours(): number;
    set tgtLifetimeHours(value: number);
    resetTgtLifetimeHours(): void;
    get tgtLifetimeHoursInput(): number | undefined;
    private _truststorePasswordUri?;
    get truststorePasswordUri(): string;
    set truststorePasswordUri(value: string);
    resetTruststorePasswordUri(): void;
    get truststorePasswordUriInput(): string | undefined;
    private _truststoreUri?;
    get truststoreUri(): string;
    set truststoreUri(value: string);
    resetTruststoreUri(): void;
    get truststoreUriInput(): string | undefined;
}
export interface DataprocClusterClusterConfigSecurityConfig {
    /**
    * kerberos_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kerberos_config DataprocCluster#kerberos_config}
    */
    readonly kerberosConfig: DataprocClusterClusterConfigSecurityConfigKerberosConfig;
}
export declare function dataprocClusterClusterConfigSecurityConfigToTerraform(struct?: DataprocClusterClusterConfigSecurityConfigOutputReference | DataprocClusterClusterConfigSecurityConfig): any;
export declare class DataprocClusterClusterConfigSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigSecurityConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigSecurityConfig | undefined);
    private _kerberosConfig;
    get kerberosConfig(): DataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference;
    putKerberosConfig(value: DataprocClusterClusterConfigSecurityConfigKerberosConfig): void;
    get kerberosConfigInput(): DataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined;
}
export interface DataprocClusterClusterConfigSoftwareConfig {
    /**
    * The Cloud Dataproc image version to use for the cluster - this controls the sets of software versions installed onto the nodes when you create clusters. If not specified, defaults to the latest version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#image_version DataprocCluster#image_version}
    */
    readonly imageVersion?: string;
    /**
    * The set of optional components to activate on the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#optional_components DataprocCluster#optional_components}
    */
    readonly optionalComponents?: string[];
    /**
    * A list of override and additional properties (key/value pairs) used to modify various aspects of the common configuration files used when creating a cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#override_properties DataprocCluster#override_properties}
    */
    readonly overrideProperties?: {
        [key: string]: string;
    };
}
export declare function dataprocClusterClusterConfigSoftwareConfigToTerraform(struct?: DataprocClusterClusterConfigSoftwareConfigOutputReference | DataprocClusterClusterConfigSoftwareConfig): any;
export declare class DataprocClusterClusterConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigSoftwareConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigSoftwareConfig | undefined);
    private _imageVersion?;
    get imageVersion(): string;
    set imageVersion(value: string);
    resetImageVersion(): void;
    get imageVersionInput(): string | undefined;
    private _optionalComponents?;
    get optionalComponents(): string[];
    set optionalComponents(value: string[]);
    resetOptionalComponents(): void;
    get optionalComponentsInput(): string[] | undefined;
    private _overrideProperties?;
    get overrideProperties(): {
        [key: string]: string;
    };
    set overrideProperties(value: {
        [key: string]: string;
    });
    resetOverrideProperties(): void;
    get overridePropertiesInput(): {
        [key: string]: string;
    } | undefined;
    properties(key: string): string | cdktf.IResolvable;
}
export interface DataprocClusterClusterConfigWorkerConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance. Often restricted to one of 1, 2, 4, or 8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerator_count DataprocCluster#accelerator_count}
    */
    readonly acceleratorCount: number;
    /**
    * The short name of the accelerator type to expose to this instance. For example, nvidia-tesla-k80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerator_type DataprocCluster#accelerator_type}
    */
    readonly acceleratorType: string;
}
export declare function dataprocClusterClusterConfigWorkerConfigAcceleratorsToTerraform(struct?: DataprocClusterClusterConfigWorkerConfigAccelerators | cdktf.IResolvable): any;
export interface DataprocClusterClusterConfigWorkerConfigDiskConfig {
    /**
    * Size of the primary disk attached to each node, specified in GB. The primary disk contains the boot volume and system libraries, and the smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_size_gb DataprocCluster#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The disk type of the primary disk attached to each node. One of "pd-ssd" or "pd-standard". Defaults to "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_type DataprocCluster#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * The amount of local SSD disks that will be attached to each master cluster node. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_local_ssds DataprocCluster#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function dataprocClusterClusterConfigWorkerConfigDiskConfigToTerraform(struct?: DataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference | DataprocClusterClusterConfigWorkerConfigDiskConfig): any;
export declare class DataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigWorkerConfigDiskConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocClusterClusterConfigWorkerConfig {
    /**
    * The URI for the image to use for this master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#image_uri DataprocCluster#image_uri}
    */
    readonly imageUri?: string;
    /**
    * The name of a Google Compute Engine machine type to create for the master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#machine_type DataprocCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The name of a minimum generation of CPU family for the master/worker. If not specified, GCP will default to a predetermined computed value for each zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#min_cpu_platform DataprocCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Specifies the number of master/worker nodes to create. If not specified, GCP will default to a predetermined computed value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_instances DataprocCluster#num_instances}
    */
    readonly numInstances?: number;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerators DataprocCluster#accelerators}
    */
    readonly accelerators?: DataprocClusterClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#disk_config DataprocCluster#disk_config}
    */
    readonly diskConfig?: DataprocClusterClusterConfigWorkerConfigDiskConfig;
}
export declare function dataprocClusterClusterConfigWorkerConfigToTerraform(struct?: DataprocClusterClusterConfigWorkerConfigOutputReference | DataprocClusterClusterConfigWorkerConfig): any;
export declare class DataprocClusterClusterConfigWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigWorkerConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigWorkerConfig | undefined);
    private _imageUri?;
    get imageUri(): string;
    set imageUri(value: string);
    resetImageUri(): void;
    get imageUriInput(): string | undefined;
    get instanceNames(): string[];
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _accelerators?;
    get accelerators(): DataprocClusterClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    set accelerators(value: DataprocClusterClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable);
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | DataprocClusterClusterConfigWorkerConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): DataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocClusterClusterConfigWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocClusterClusterConfigWorkerConfigDiskConfig | undefined;
}
export interface DataprocClusterClusterConfig {
    /**
    * The Cloud Storage staging bucket used to stage files, such as Hadoop jars, between client machines and the cluster. Note: If you don't explicitly specify a staging_bucket then GCP will auto create / assign one for you. However, you are not guaranteed an auto generated bucket which is solely dedicated to your cluster; it may be shared with other clusters in the same region/zone also choosing to use the auto generation option.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#staging_bucket DataprocCluster#staging_bucket}
    */
    readonly stagingBucket?: string;
    /**
    * The Cloud Storage temp bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. Note: If you don't explicitly specify a temp_bucket then GCP will auto create / assign one for you.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#temp_bucket DataprocCluster#temp_bucket}
    */
    readonly tempBucket?: string;
    /**
    * autoscaling_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#autoscaling_config DataprocCluster#autoscaling_config}
    */
    readonly autoscalingConfig?: DataprocClusterClusterConfigAutoscalingConfig;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#encryption_config DataprocCluster#encryption_config}
    */
    readonly encryptionConfig?: DataprocClusterClusterConfigEncryptionConfig;
    /**
    * gce_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#gce_cluster_config DataprocCluster#gce_cluster_config}
    */
    readonly gceClusterConfig?: DataprocClusterClusterConfigGceClusterConfig;
    /**
    * initialization_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#initialization_action DataprocCluster#initialization_action}
    */
    readonly initializationAction?: DataprocClusterClusterConfigInitializationAction[] | cdktf.IResolvable;
    /**
    * master_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#master_config DataprocCluster#master_config}
    */
    readonly masterConfig?: DataprocClusterClusterConfigMasterConfig;
    /**
    * preemptible_worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#preemptible_worker_config DataprocCluster#preemptible_worker_config}
    */
    readonly preemptibleWorkerConfig?: DataprocClusterClusterConfigPreemptibleWorkerConfig;
    /**
    * security_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#security_config DataprocCluster#security_config}
    */
    readonly securityConfig?: DataprocClusterClusterConfigSecurityConfig;
    /**
    * software_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#software_config DataprocCluster#software_config}
    */
    readonly softwareConfig?: DataprocClusterClusterConfigSoftwareConfig;
    /**
    * worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#worker_config DataprocCluster#worker_config}
    */
    readonly workerConfig?: DataprocClusterClusterConfigWorkerConfig;
}
export declare function dataprocClusterClusterConfigToTerraform(struct?: DataprocClusterClusterConfigOutputReference | DataprocClusterClusterConfig): any;
export declare class DataprocClusterClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfig | undefined);
    get bucket(): string;
    private _stagingBucket?;
    get stagingBucket(): string;
    set stagingBucket(value: string);
    resetStagingBucket(): void;
    get stagingBucketInput(): string | undefined;
    private _tempBucket?;
    get tempBucket(): string;
    set tempBucket(value: string);
    resetTempBucket(): void;
    get tempBucketInput(): string | undefined;
    private _autoscalingConfig;
    get autoscalingConfig(): DataprocClusterClusterConfigAutoscalingConfigOutputReference;
    putAutoscalingConfig(value: DataprocClusterClusterConfigAutoscalingConfig): void;
    resetAutoscalingConfig(): void;
    get autoscalingConfigInput(): DataprocClusterClusterConfigAutoscalingConfig | undefined;
    private _encryptionConfig;
    get encryptionConfig(): DataprocClusterClusterConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: DataprocClusterClusterConfigEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): DataprocClusterClusterConfigEncryptionConfig | undefined;
    private _gceClusterConfig;
    get gceClusterConfig(): DataprocClusterClusterConfigGceClusterConfigOutputReference;
    putGceClusterConfig(value: DataprocClusterClusterConfigGceClusterConfig): void;
    resetGceClusterConfig(): void;
    get gceClusterConfigInput(): DataprocClusterClusterConfigGceClusterConfig | undefined;
    private _initializationAction?;
    get initializationAction(): DataprocClusterClusterConfigInitializationAction[] | cdktf.IResolvable;
    set initializationAction(value: DataprocClusterClusterConfigInitializationAction[] | cdktf.IResolvable);
    resetInitializationAction(): void;
    get initializationActionInput(): cdktf.IResolvable | DataprocClusterClusterConfigInitializationAction[] | undefined;
    private _masterConfig;
    get masterConfig(): DataprocClusterClusterConfigMasterConfigOutputReference;
    putMasterConfig(value: DataprocClusterClusterConfigMasterConfig): void;
    resetMasterConfig(): void;
    get masterConfigInput(): DataprocClusterClusterConfigMasterConfig | undefined;
    private _preemptibleWorkerConfig;
    get preemptibleWorkerConfig(): DataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference;
    putPreemptibleWorkerConfig(value: DataprocClusterClusterConfigPreemptibleWorkerConfig): void;
    resetPreemptibleWorkerConfig(): void;
    get preemptibleWorkerConfigInput(): DataprocClusterClusterConfigPreemptibleWorkerConfig | undefined;
    private _securityConfig;
    get securityConfig(): DataprocClusterClusterConfigSecurityConfigOutputReference;
    putSecurityConfig(value: DataprocClusterClusterConfigSecurityConfig): void;
    resetSecurityConfig(): void;
    get securityConfigInput(): DataprocClusterClusterConfigSecurityConfig | undefined;
    private _softwareConfig;
    get softwareConfig(): DataprocClusterClusterConfigSoftwareConfigOutputReference;
    putSoftwareConfig(value: DataprocClusterClusterConfigSoftwareConfig): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): DataprocClusterClusterConfigSoftwareConfig | undefined;
    private _workerConfig;
    get workerConfig(): DataprocClusterClusterConfigWorkerConfigOutputReference;
    putWorkerConfig(value: DataprocClusterClusterConfigWorkerConfig): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): DataprocClusterClusterConfigWorkerConfig | undefined;
}
export interface DataprocClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#create DataprocCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#delete DataprocCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#update DataprocCluster#update}
    */
    readonly update?: string;
}
export declare function dataprocClusterTimeoutsToTerraform(struct?: DataprocClusterTimeoutsOutputReference | DataprocClusterTimeouts | cdktf.IResolvable): any;
export declare class DataprocClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterTimeouts | undefined;
    set internalValue(value: DataprocClusterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster google_dataproc_cluster}
*/
export declare class DataprocCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster google_dataproc_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataprocClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataprocClusterConfig);
    private _gracefulDecommissionTimeout?;
    get gracefulDecommissionTimeout(): string;
    set gracefulDecommissionTimeout(value: string);
    resetGracefulDecommissionTimeout(): void;
    get gracefulDecommissionTimeoutInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _clusterConfig;
    get clusterConfig(): DataprocClusterClusterConfigOutputReference;
    putClusterConfig(value: DataprocClusterClusterConfig): void;
    resetClusterConfig(): void;
    get clusterConfigInput(): DataprocClusterClusterConfig | undefined;
    private _timeouts;
    get timeouts(): DataprocClusterTimeoutsOutputReference;
    putTimeouts(value: DataprocClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataprocClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
