import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatastoreIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * Policy for including ancestors in the index. Default value: "NONE" Possible values: ["NONE", "ALL_ANCESTORS"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index#ancestor DatastoreIndex#ancestor}
    */
    readonly ancestor?: string;
    /**
    * The entity kind which the index applies to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index#kind DatastoreIndex#kind}
    */
    readonly kind: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index#project DatastoreIndex#project}
    */
    readonly project?: string;
    /**
    * properties block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index#properties DatastoreIndex#properties}
    */
    readonly properties?: DatastoreIndexProperties[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index#timeouts DatastoreIndex#timeouts}
    */
    readonly timeouts?: DatastoreIndexTimeouts;
}
export interface DatastoreIndexProperties {
    /**
    * The direction the index should optimize for sorting. Possible values: ["ASCENDING", "DESCENDING"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index#direction DatastoreIndex#direction}
    */
    readonly direction: string;
    /**
    * The property name to index.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index#name DatastoreIndex#name}
    */
    readonly name: string;
}
export declare function datastoreIndexPropertiesToTerraform(struct?: DatastoreIndexProperties | cdktf.IResolvable): any;
export interface DatastoreIndexTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index#create DatastoreIndex#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/datastore_index#delete DatastoreIndex#delete}
    */
    readonly delete?: string;
}
export declare function datastoreIndexTimeoutsToTerraform(struct?: DatastoreIndexTimeoutsOutputReference | DatastoreIndexTimeouts | cdktf.IResolvable): any;
export declare class DatastoreIndexTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatastoreIndexTimeouts | undefined;
    set internalValue(value: DatastoreIndexTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/datastore_index google_datastore_index}
*/
export declare class DatastoreIndex extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_datastore_index";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/datastore_index google_datastore_index} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatastoreIndexConfig
    */
    constructor(scope: Construct, id: string, config: DatastoreIndexConfig);
    private _ancestor?;
    get ancestor(): string;
    set ancestor(value: string);
    resetAncestor(): void;
    get ancestorInput(): string | undefined;
    get id(): string;
    get indexId(): string;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    get kindInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _properties?;
    get properties(): DatastoreIndexProperties[] | cdktf.IResolvable;
    set properties(value: DatastoreIndexProperties[] | cdktf.IResolvable);
    resetProperties(): void;
    get propertiesInput(): cdktf.IResolvable | DatastoreIndexProperties[] | undefined;
    private _timeouts;
    get timeouts(): DatastoreIndexTimeoutsOutputReference;
    putTimeouts(value: DatastoreIndexTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DatastoreIndexTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
