import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DialogflowFulfillmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The human-readable name of the fulfillment, unique within the agent.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#display_name DialogflowFulfillment#display_name}
    */
    readonly displayName: string;
    /**
    * Whether fulfillment is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#enabled DialogflowFulfillment#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#project DialogflowFulfillment#project}
    */
    readonly project?: string;
    /**
    * features block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#features DialogflowFulfillment#features}
    */
    readonly features?: DialogflowFulfillmentFeatures[] | cdktf.IResolvable;
    /**
    * generic_web_service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#generic_web_service DialogflowFulfillment#generic_web_service}
    */
    readonly genericWebService?: DialogflowFulfillmentGenericWebService;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#timeouts DialogflowFulfillment#timeouts}
    */
    readonly timeouts?: DialogflowFulfillmentTimeouts;
}
export interface DialogflowFulfillmentFeatures {
    /**
    * The type of the feature that enabled for fulfillment.
  * SMALLTALK: Fulfillment is enabled for SmallTalk. Possible values: ["SMALLTALK"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#type DialogflowFulfillment#type}
    */
    readonly type: string;
}
export declare function dialogflowFulfillmentFeaturesToTerraform(struct?: DialogflowFulfillmentFeatures | cdktf.IResolvable): any;
export interface DialogflowFulfillmentGenericWebService {
    /**
    * The password for HTTP Basic authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#password DialogflowFulfillment#password}
    */
    readonly password?: string;
    /**
    * The HTTP request headers to send together with fulfillment requests.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#request_headers DialogflowFulfillment#request_headers}
    */
    readonly requestHeaders?: {
        [key: string]: string;
    };
    /**
    * The fulfillment URI for receiving POST requests. It must use https protocol.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#uri DialogflowFulfillment#uri}
    */
    readonly uri: string;
    /**
    * The user name for HTTP Basic authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#username DialogflowFulfillment#username}
    */
    readonly username?: string;
}
export declare function dialogflowFulfillmentGenericWebServiceToTerraform(struct?: DialogflowFulfillmentGenericWebServiceOutputReference | DialogflowFulfillmentGenericWebService): any;
export declare class DialogflowFulfillmentGenericWebServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowFulfillmentGenericWebService | undefined;
    set internalValue(value: DialogflowFulfillmentGenericWebService | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _requestHeaders?;
    get requestHeaders(): {
        [key: string]: string;
    };
    set requestHeaders(value: {
        [key: string]: string;
    });
    resetRequestHeaders(): void;
    get requestHeadersInput(): {
        [key: string]: string;
    } | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export interface DialogflowFulfillmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#create DialogflowFulfillment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#delete DialogflowFulfillment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment#update DialogflowFulfillment#update}
    */
    readonly update?: string;
}
export declare function dialogflowFulfillmentTimeoutsToTerraform(struct?: DialogflowFulfillmentTimeoutsOutputReference | DialogflowFulfillmentTimeouts | cdktf.IResolvable): any;
export declare class DialogflowFulfillmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DialogflowFulfillmentTimeouts | undefined;
    set internalValue(value: DialogflowFulfillmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment google_dialogflow_fulfillment}
*/
export declare class DialogflowFulfillment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dialogflow_fulfillment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dialogflow_fulfillment google_dialogflow_fulfillment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DialogflowFulfillmentConfig
    */
    constructor(scope: Construct, id: string, config: DialogflowFulfillmentConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _features?;
    get features(): DialogflowFulfillmentFeatures[] | cdktf.IResolvable;
    set features(value: DialogflowFulfillmentFeatures[] | cdktf.IResolvable);
    resetFeatures(): void;
    get featuresInput(): cdktf.IResolvable | DialogflowFulfillmentFeatures[] | undefined;
    private _genericWebService;
    get genericWebService(): DialogflowFulfillmentGenericWebServiceOutputReference;
    putGenericWebService(value: DialogflowFulfillmentGenericWebService): void;
    resetGenericWebService(): void;
    get genericWebServiceInput(): DialogflowFulfillmentGenericWebService | undefined;
    private _timeouts;
    get timeouts(): DialogflowFulfillmentTimeoutsOutputReference;
    putTimeouts(value: DialogflowFulfillmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DialogflowFulfillmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
