import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirebaserulesRulesetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#project FirebaserulesRuleset#project}
    */
    readonly project?: string;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#source FirebaserulesRuleset#source}
    */
    readonly source: FirebaserulesRulesetSource;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#timeouts FirebaserulesRuleset#timeouts}
    */
    readonly timeouts?: FirebaserulesRulesetTimeouts;
}
export interface FirebaserulesRulesetMetadata {
}
export declare function firebaserulesRulesetMetadataToTerraform(struct?: FirebaserulesRulesetMetadata): any;
export declare class FirebaserulesRulesetMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirebaserulesRulesetMetadata | undefined;
    set internalValue(value: FirebaserulesRulesetMetadata | undefined);
    get services(): string[];
}
export declare class FirebaserulesRulesetMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirebaserulesRulesetMetadataOutputReference;
}
export interface FirebaserulesRulesetSourceFiles {
    /**
    * Textual Content.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#content FirebaserulesRuleset#content}
    */
    readonly content: string;
    /**
    * Fingerprint (e.g. github sha) associated with the `File`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#fingerprint FirebaserulesRuleset#fingerprint}
    */
    readonly fingerprint?: string;
    /**
    * File name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#name FirebaserulesRuleset#name}
    */
    readonly name: string;
}
export declare function firebaserulesRulesetSourceFilesToTerraform(struct?: FirebaserulesRulesetSourceFiles | cdktf.IResolvable): any;
export interface FirebaserulesRulesetSource {
    /**
    * `Language` of the `Source` bundle. If unspecified, the language will default to `FIREBASE_RULES`. Possible values: LANGUAGE_UNSPECIFIED, FIREBASE_RULES, EVENT_FLOW_TRIGGERS
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#language FirebaserulesRuleset#language}
    */
    readonly language?: string;
    /**
    * files block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#files FirebaserulesRuleset#files}
    */
    readonly files: FirebaserulesRulesetSourceFiles[] | cdktf.IResolvable;
}
export declare function firebaserulesRulesetSourceToTerraform(struct?: FirebaserulesRulesetSourceOutputReference | FirebaserulesRulesetSource): any;
export declare class FirebaserulesRulesetSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirebaserulesRulesetSource | undefined;
    set internalValue(value: FirebaserulesRulesetSource | undefined);
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    private _files?;
    get files(): FirebaserulesRulesetSourceFiles[] | cdktf.IResolvable;
    set files(value: FirebaserulesRulesetSourceFiles[] | cdktf.IResolvable);
    get filesInput(): cdktf.IResolvable | FirebaserulesRulesetSourceFiles[] | undefined;
}
export interface FirebaserulesRulesetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#create FirebaserulesRuleset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset#delete FirebaserulesRuleset#delete}
    */
    readonly delete?: string;
}
export declare function firebaserulesRulesetTimeoutsToTerraform(struct?: FirebaserulesRulesetTimeoutsOutputReference | FirebaserulesRulesetTimeouts | cdktf.IResolvable): any;
export declare class FirebaserulesRulesetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirebaserulesRulesetTimeouts | undefined;
    set internalValue(value: FirebaserulesRulesetTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset google_firebaserules_ruleset}
*/
export declare class FirebaserulesRuleset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_firebaserules_ruleset";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/firebaserules_ruleset google_firebaserules_ruleset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirebaserulesRulesetConfig
    */
    constructor(scope: Construct, id: string, config: FirebaserulesRulesetConfig);
    get createTime(): string;
    get id(): string;
    private _metadata;
    get metadata(): FirebaserulesRulesetMetadataList;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _source;
    get source(): FirebaserulesRulesetSourceOutputReference;
    putSource(value: FirebaserulesRulesetSource): void;
    get sourceInput(): FirebaserulesRulesetSource | undefined;
    private _timeouts;
    get timeouts(): FirebaserulesRulesetTimeoutsOutputReference;
    putTimeouts(value: FirebaserulesRulesetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): FirebaserulesRulesetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
