import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformTenantInboundSamlConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Human friendly display name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#display_name IdentityPlatformTenantInboundSamlConfig#display_name}
    */
    readonly displayName: string;
    /**
    * If this config allows users to sign in with the provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#enabled IdentityPlatformTenantInboundSamlConfig#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The name of the InboundSamlConfig resource. Must start with 'saml.' and can only have alphanumeric characters,
  hyphens, underscores or periods. The part after 'saml.' must also start with a lowercase letter, end with an
  alphanumeric character, and have at least 2 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#name IdentityPlatformTenantInboundSamlConfig#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#project IdentityPlatformTenantInboundSamlConfig#project}
    */
    readonly project?: string;
    /**
    * The name of the tenant where this inbound SAML config resource exists
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#tenant IdentityPlatformTenantInboundSamlConfig#tenant}
    */
    readonly tenant: string;
    /**
    * idp_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#idp_config IdentityPlatformTenantInboundSamlConfig#idp_config}
    */
    readonly idpConfig: IdentityPlatformTenantInboundSamlConfigIdpConfig;
    /**
    * sp_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#sp_config IdentityPlatformTenantInboundSamlConfig#sp_config}
    */
    readonly spConfig: IdentityPlatformTenantInboundSamlConfigSpConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#timeouts IdentityPlatformTenantInboundSamlConfig#timeouts}
    */
    readonly timeouts?: IdentityPlatformTenantInboundSamlConfigTimeouts;
}
export interface IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates {
    /**
    * The x509 certificate
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#x509_certificate IdentityPlatformTenantInboundSamlConfig#x509_certificate}
    */
    readonly x509Certificate?: string;
}
export declare function identityPlatformTenantInboundSamlConfigIdpConfigIdpCertificatesToTerraform(struct?: IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates | cdktf.IResolvable): any;
export interface IdentityPlatformTenantInboundSamlConfigIdpConfig {
    /**
    * Unique identifier for all SAML entities
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#idp_entity_id IdentityPlatformTenantInboundSamlConfig#idp_entity_id}
    */
    readonly idpEntityId: string;
    /**
    * Indicates if outbounding SAMLRequest should be signed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#sign_request IdentityPlatformTenantInboundSamlConfig#sign_request}
    */
    readonly signRequest?: boolean | cdktf.IResolvable;
    /**
    * URL to send Authentication request to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#sso_url IdentityPlatformTenantInboundSamlConfig#sso_url}
    */
    readonly ssoUrl: string;
    /**
    * idp_certificates block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#idp_certificates IdentityPlatformTenantInboundSamlConfig#idp_certificates}
    */
    readonly idpCertificates: IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
}
export declare function identityPlatformTenantInboundSamlConfigIdpConfigToTerraform(struct?: IdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference | IdentityPlatformTenantInboundSamlConfigIdpConfig): any;
export declare class IdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformTenantInboundSamlConfigIdpConfig | undefined;
    set internalValue(value: IdentityPlatformTenantInboundSamlConfigIdpConfig | undefined);
    private _idpEntityId?;
    get idpEntityId(): string;
    set idpEntityId(value: string);
    get idpEntityIdInput(): string | undefined;
    private _signRequest?;
    get signRequest(): boolean | cdktf.IResolvable;
    set signRequest(value: boolean | cdktf.IResolvable);
    resetSignRequest(): void;
    get signRequestInput(): boolean | cdktf.IResolvable | undefined;
    private _ssoUrl?;
    get ssoUrl(): string;
    set ssoUrl(value: string);
    get ssoUrlInput(): string | undefined;
    private _idpCertificates?;
    get idpCertificates(): IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable;
    set idpCertificates(value: IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | cdktf.IResolvable);
    get idpCertificatesInput(): cdktf.IResolvable | IdentityPlatformTenantInboundSamlConfigIdpConfigIdpCertificates[] | undefined;
}
export interface IdentityPlatformTenantInboundSamlConfigSpConfigSpCertificates {
}
export declare function identityPlatformTenantInboundSamlConfigSpConfigSpCertificatesToTerraform(struct?: IdentityPlatformTenantInboundSamlConfigSpConfigSpCertificates): any;
export declare class IdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): IdentityPlatformTenantInboundSamlConfigSpConfigSpCertificates | undefined;
    set internalValue(value: IdentityPlatformTenantInboundSamlConfigSpConfigSpCertificates | undefined);
    get x509Certificate(): string;
}
export declare class IdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): IdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesOutputReference;
}
export interface IdentityPlatformTenantInboundSamlConfigSpConfig {
    /**
    * Callback URI where responses from IDP are handled. Must start with 'https://'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#callback_uri IdentityPlatformTenantInboundSamlConfig#callback_uri}
    */
    readonly callbackUri: string;
    /**
    * Unique identifier for all SAML entities.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#sp_entity_id IdentityPlatformTenantInboundSamlConfig#sp_entity_id}
    */
    readonly spEntityId: string;
}
export declare function identityPlatformTenantInboundSamlConfigSpConfigToTerraform(struct?: IdentityPlatformTenantInboundSamlConfigSpConfigOutputReference | IdentityPlatformTenantInboundSamlConfigSpConfig): any;
export declare class IdentityPlatformTenantInboundSamlConfigSpConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformTenantInboundSamlConfigSpConfig | undefined;
    set internalValue(value: IdentityPlatformTenantInboundSamlConfigSpConfig | undefined);
    private _callbackUri?;
    get callbackUri(): string;
    set callbackUri(value: string);
    get callbackUriInput(): string | undefined;
    private _spCertificates;
    get spCertificates(): IdentityPlatformTenantInboundSamlConfigSpConfigSpCertificatesList;
    private _spEntityId?;
    get spEntityId(): string;
    set spEntityId(value: string);
    get spEntityIdInput(): string | undefined;
}
export interface IdentityPlatformTenantInboundSamlConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#create IdentityPlatformTenantInboundSamlConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#delete IdentityPlatformTenantInboundSamlConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config#update IdentityPlatformTenantInboundSamlConfig#update}
    */
    readonly update?: string;
}
export declare function identityPlatformTenantInboundSamlConfigTimeoutsToTerraform(struct?: IdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference | IdentityPlatformTenantInboundSamlConfigTimeouts | cdktf.IResolvable): any;
export declare class IdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformTenantInboundSamlConfigTimeouts | undefined;
    set internalValue(value: IdentityPlatformTenantInboundSamlConfigTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config google_identity_platform_tenant_inbound_saml_config}
*/
export declare class IdentityPlatformTenantInboundSamlConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_tenant_inbound_saml_config";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_inbound_saml_config google_identity_platform_tenant_inbound_saml_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityPlatformTenantInboundSamlConfigConfig
    */
    constructor(scope: Construct, id: string, config: IdentityPlatformTenantInboundSamlConfigConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tenant?;
    get tenant(): string;
    set tenant(value: string);
    get tenantInput(): string | undefined;
    private _idpConfig;
    get idpConfig(): IdentityPlatformTenantInboundSamlConfigIdpConfigOutputReference;
    putIdpConfig(value: IdentityPlatformTenantInboundSamlConfigIdpConfig): void;
    get idpConfigInput(): IdentityPlatformTenantInboundSamlConfigIdpConfig | undefined;
    private _spConfig;
    get spConfig(): IdentityPlatformTenantInboundSamlConfigSpConfigOutputReference;
    putSpConfig(value: IdentityPlatformTenantInboundSamlConfigSpConfig): void;
    get spConfigInput(): IdentityPlatformTenantInboundSamlConfigSpConfig | undefined;
    private _timeouts;
    get timeouts(): IdentityPlatformTenantInboundSamlConfigTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformTenantInboundSamlConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IdentityPlatformTenantInboundSamlConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
