import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IdentityPlatformTenantConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether to allow email/password user authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant#allow_password_signup IdentityPlatformTenant#allow_password_signup}
    */
    readonly allowPasswordSignup?: boolean | cdktf.IResolvable;
    /**
    * Whether authentication is disabled for the tenant. If true, the users under
  the disabled tenant are not allowed to sign-in. Admins of the disabled tenant
  are not able to manage its users.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant#disable_auth IdentityPlatformTenant#disable_auth}
    */
    readonly disableAuth?: boolean | cdktf.IResolvable;
    /**
    * Human friendly display name of the tenant.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant#display_name IdentityPlatformTenant#display_name}
    */
    readonly displayName: string;
    /**
    * Whether to enable email link user authentication.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant#enable_email_link_signin IdentityPlatformTenant#enable_email_link_signin}
    */
    readonly enableEmailLinkSignin?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant#project IdentityPlatformTenant#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant#timeouts IdentityPlatformTenant#timeouts}
    */
    readonly timeouts?: IdentityPlatformTenantTimeouts;
}
export interface IdentityPlatformTenantTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant#create IdentityPlatformTenant#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant#delete IdentityPlatformTenant#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant#update IdentityPlatformTenant#update}
    */
    readonly update?: string;
}
export declare function identityPlatformTenantTimeoutsToTerraform(struct?: IdentityPlatformTenantTimeoutsOutputReference | IdentityPlatformTenantTimeouts | cdktf.IResolvable): any;
export declare class IdentityPlatformTenantTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IdentityPlatformTenantTimeouts | undefined;
    set internalValue(value: IdentityPlatformTenantTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant google_identity_platform_tenant}
*/
export declare class IdentityPlatformTenant extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_identity_platform_tenant";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant google_identity_platform_tenant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IdentityPlatformTenantConfig
    */
    constructor(scope: Construct, id: string, config: IdentityPlatformTenantConfig);
    private _allowPasswordSignup?;
    get allowPasswordSignup(): boolean | cdktf.IResolvable;
    set allowPasswordSignup(value: boolean | cdktf.IResolvable);
    resetAllowPasswordSignup(): void;
    get allowPasswordSignupInput(): boolean | cdktf.IResolvable | undefined;
    private _disableAuth?;
    get disableAuth(): boolean | cdktf.IResolvable;
    set disableAuth(value: boolean | cdktf.IResolvable);
    resetDisableAuth(): void;
    get disableAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _enableEmailLinkSignin?;
    get enableEmailLinkSignin(): boolean | cdktf.IResolvable;
    set enableEmailLinkSignin(value: boolean | cdktf.IResolvable);
    resetEnableEmailLinkSignin(): void;
    get enableEmailLinkSigninInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): IdentityPlatformTenantTimeoutsOutputReference;
    putTimeouts(value: IdentityPlatformTenantTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): IdentityPlatformTenantTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
