import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitoringGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * A user-assigned name for this group, used only for display
  purposes.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#display_name MonitoringGroup#display_name}
    */
    readonly displayName: string;
    /**
    * The filter used to determine which monitored resources
  belong to this group.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#filter MonitoringGroup#filter}
    */
    readonly filter: string;
    /**
    * If true, the members of this group are considered to be a
  cluster. The system can perform additional analysis on
  groups that are clusters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#is_cluster MonitoringGroup#is_cluster}
    */
    readonly isCluster?: boolean | cdktf.IResolvable;
    /**
    * The name of the group's parent, if it has one. The format is
  "projects/{project_id_or_number}/groups/{group_id}". For
  groups with no parent, parentName is the empty string, "".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#parent_name MonitoringGroup#parent_name}
    */
    readonly parentName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#project MonitoringGroup#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#timeouts MonitoringGroup#timeouts}
    */
    readonly timeouts?: MonitoringGroupTimeouts;
}
export interface MonitoringGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#create MonitoringGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#delete MonitoringGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_group#update MonitoringGroup#update}
    */
    readonly update?: string;
}
export declare function monitoringGroupTimeoutsToTerraform(struct?: MonitoringGroupTimeoutsOutputReference | MonitoringGroupTimeouts | cdktf.IResolvable): any;
export declare class MonitoringGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitoringGroupTimeouts | undefined;
    set internalValue(value: MonitoringGroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_group google_monitoring_group}
*/
export declare class MonitoringGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_group google_monitoring_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitoringGroupConfig
    */
    constructor(scope: Construct, id: string, config: MonitoringGroupConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    get id(): string;
    private _isCluster?;
    get isCluster(): boolean | cdktf.IResolvable;
    set isCluster(value: boolean | cdktf.IResolvable);
    resetIsCluster(): void;
    get isClusterInput(): boolean | cdktf.IResolvable | undefined;
    get name(): string;
    private _parentName?;
    get parentName(): string;
    set parentName(value: string);
    resetParentName(): void;
    get parentNameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): MonitoringGroupTimeoutsOutputReference;
    putTimeouts(value: MonitoringGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): MonitoringGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
