import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkConnectivitySpokeConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of the spoke.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#description NetworkConnectivitySpoke#description}
    */
    readonly description?: string;
    /**
    * Immutable. The URI of the hub that this spoke is attached to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#hub NetworkConnectivitySpoke#hub}
    */
    readonly hub: string;
    /**
    * Optional labels in key:value format. For more information about labels, see [Requirements for labels](https://cloud.google.com/resource-manager/docs/creating-managing-labels#requirements).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#labels NetworkConnectivitySpoke#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#location NetworkConnectivitySpoke#location}
    */
    readonly location: string;
    /**
    * Immutable. The name of the spoke. Spoke names must be unique.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#name NetworkConnectivitySpoke#name}
    */
    readonly name: string;
    /**
    * The project for the resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#project NetworkConnectivitySpoke#project}
    */
    readonly project?: string;
    /**
    * linked_interconnect_attachments block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#linked_interconnect_attachments NetworkConnectivitySpoke#linked_interconnect_attachments}
    */
    readonly linkedInterconnectAttachments?: NetworkConnectivitySpokeLinkedInterconnectAttachments;
    /**
    * linked_router_appliance_instances block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#linked_router_appliance_instances NetworkConnectivitySpoke#linked_router_appliance_instances}
    */
    readonly linkedRouterApplianceInstances?: NetworkConnectivitySpokeLinkedRouterApplianceInstances;
    /**
    * linked_vpn_tunnels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#linked_vpn_tunnels NetworkConnectivitySpoke#linked_vpn_tunnels}
    */
    readonly linkedVpnTunnels?: NetworkConnectivitySpokeLinkedVpnTunnels;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#timeouts NetworkConnectivitySpoke#timeouts}
    */
    readonly timeouts?: NetworkConnectivitySpokeTimeouts;
}
export interface NetworkConnectivitySpokeLinkedInterconnectAttachments {
    /**
    * A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#site_to_site_data_transfer NetworkConnectivitySpoke#site_to_site_data_transfer}
    */
    readonly siteToSiteDataTransfer: boolean | cdktf.IResolvable;
    /**
    * The URIs of linked interconnect attachment resources
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#uris NetworkConnectivitySpoke#uris}
    */
    readonly uris: string[];
}
export declare function networkConnectivitySpokeLinkedInterconnectAttachmentsToTerraform(struct?: NetworkConnectivitySpokeLinkedInterconnectAttachmentsOutputReference | NetworkConnectivitySpokeLinkedInterconnectAttachments): any;
export declare class NetworkConnectivitySpokeLinkedInterconnectAttachmentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectivitySpokeLinkedInterconnectAttachments | undefined;
    set internalValue(value: NetworkConnectivitySpokeLinkedInterconnectAttachments | undefined);
    private _siteToSiteDataTransfer?;
    get siteToSiteDataTransfer(): boolean | cdktf.IResolvable;
    set siteToSiteDataTransfer(value: boolean | cdktf.IResolvable);
    get siteToSiteDataTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _uris?;
    get uris(): string[];
    set uris(value: string[]);
    get urisInput(): string[] | undefined;
}
export interface NetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances {
    /**
    * The IP address on the VM to use for peering.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#ip_address NetworkConnectivitySpoke#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * The URI of the virtual machine resource
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#virtual_machine NetworkConnectivitySpoke#virtual_machine}
    */
    readonly virtualMachine?: string;
}
export declare function networkConnectivitySpokeLinkedRouterApplianceInstancesInstancesToTerraform(struct?: NetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances | cdktf.IResolvable): any;
export interface NetworkConnectivitySpokeLinkedRouterApplianceInstances {
    /**
    * A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#site_to_site_data_transfer NetworkConnectivitySpoke#site_to_site_data_transfer}
    */
    readonly siteToSiteDataTransfer: boolean | cdktf.IResolvable;
    /**
    * instances block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#instances NetworkConnectivitySpoke#instances}
    */
    readonly instances: NetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances[] | cdktf.IResolvable;
}
export declare function networkConnectivitySpokeLinkedRouterApplianceInstancesToTerraform(struct?: NetworkConnectivitySpokeLinkedRouterApplianceInstancesOutputReference | NetworkConnectivitySpokeLinkedRouterApplianceInstances): any;
export declare class NetworkConnectivitySpokeLinkedRouterApplianceInstancesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectivitySpokeLinkedRouterApplianceInstances | undefined;
    set internalValue(value: NetworkConnectivitySpokeLinkedRouterApplianceInstances | undefined);
    private _siteToSiteDataTransfer?;
    get siteToSiteDataTransfer(): boolean | cdktf.IResolvable;
    set siteToSiteDataTransfer(value: boolean | cdktf.IResolvable);
    get siteToSiteDataTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _instances?;
    get instances(): NetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances[] | cdktf.IResolvable;
    set instances(value: NetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances[] | cdktf.IResolvable);
    get instancesInput(): cdktf.IResolvable | NetworkConnectivitySpokeLinkedRouterApplianceInstancesInstances[] | undefined;
}
export interface NetworkConnectivitySpokeLinkedVpnTunnels {
    /**
    * A value that controls whether site-to-site data transfer is enabled for these resources. Note that data transfer is available only in supported locations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#site_to_site_data_transfer NetworkConnectivitySpoke#site_to_site_data_transfer}
    */
    readonly siteToSiteDataTransfer: boolean | cdktf.IResolvable;
    /**
    * The URIs of linked VPN tunnel resources.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#uris NetworkConnectivitySpoke#uris}
    */
    readonly uris: string[];
}
export declare function networkConnectivitySpokeLinkedVpnTunnelsToTerraform(struct?: NetworkConnectivitySpokeLinkedVpnTunnelsOutputReference | NetworkConnectivitySpokeLinkedVpnTunnels): any;
export declare class NetworkConnectivitySpokeLinkedVpnTunnelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectivitySpokeLinkedVpnTunnels | undefined;
    set internalValue(value: NetworkConnectivitySpokeLinkedVpnTunnels | undefined);
    private _siteToSiteDataTransfer?;
    get siteToSiteDataTransfer(): boolean | cdktf.IResolvable;
    set siteToSiteDataTransfer(value: boolean | cdktf.IResolvable);
    get siteToSiteDataTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _uris?;
    get uris(): string[];
    set uris(value: string[]);
    get urisInput(): string[] | undefined;
}
export interface NetworkConnectivitySpokeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#create NetworkConnectivitySpoke#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#delete NetworkConnectivitySpoke#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke#update NetworkConnectivitySpoke#update}
    */
    readonly update?: string;
}
export declare function networkConnectivitySpokeTimeoutsToTerraform(struct?: NetworkConnectivitySpokeTimeoutsOutputReference | NetworkConnectivitySpokeTimeouts | cdktf.IResolvable): any;
export declare class NetworkConnectivitySpokeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkConnectivitySpokeTimeouts | undefined;
    set internalValue(value: NetworkConnectivitySpokeTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke google_network_connectivity_spoke}
*/
export declare class NetworkConnectivitySpoke extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_connectivity_spoke";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_connectivity_spoke google_network_connectivity_spoke} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkConnectivitySpokeConfig
    */
    constructor(scope: Construct, id: string, config: NetworkConnectivitySpokeConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hub?;
    get hub(): string;
    set hub(value: string);
    get hubInput(): string | undefined;
    get id(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get uniqueId(): string;
    get updateTime(): string;
    private _linkedInterconnectAttachments;
    get linkedInterconnectAttachments(): NetworkConnectivitySpokeLinkedInterconnectAttachmentsOutputReference;
    putLinkedInterconnectAttachments(value: NetworkConnectivitySpokeLinkedInterconnectAttachments): void;
    resetLinkedInterconnectAttachments(): void;
    get linkedInterconnectAttachmentsInput(): NetworkConnectivitySpokeLinkedInterconnectAttachments | undefined;
    private _linkedRouterApplianceInstances;
    get linkedRouterApplianceInstances(): NetworkConnectivitySpokeLinkedRouterApplianceInstancesOutputReference;
    putLinkedRouterApplianceInstances(value: NetworkConnectivitySpokeLinkedRouterApplianceInstances): void;
    resetLinkedRouterApplianceInstances(): void;
    get linkedRouterApplianceInstancesInput(): NetworkConnectivitySpokeLinkedRouterApplianceInstances | undefined;
    private _linkedVpnTunnels;
    get linkedVpnTunnels(): NetworkConnectivitySpokeLinkedVpnTunnelsOutputReference;
    putLinkedVpnTunnels(value: NetworkConnectivitySpokeLinkedVpnTunnels): void;
    resetLinkedVpnTunnels(): void;
    get linkedVpnTunnelsInput(): NetworkConnectivitySpokeLinkedVpnTunnels | undefined;
    private _timeouts;
    get timeouts(): NetworkConnectivitySpokeTimeoutsOutputReference;
    putTimeouts(value: NetworkConnectivitySpokeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkConnectivitySpokeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
