import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NotebooksRuntimeIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member#location NotebooksRuntimeIamMember#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member#member NotebooksRuntimeIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member#project NotebooksRuntimeIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member#role NotebooksRuntimeIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member#runtime_name NotebooksRuntimeIamMember#runtime_name}
    */
    readonly runtimeName: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member#condition NotebooksRuntimeIamMember#condition}
    */
    readonly condition?: NotebooksRuntimeIamMemberCondition;
}
export interface NotebooksRuntimeIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member#description NotebooksRuntimeIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member#expression NotebooksRuntimeIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member#title NotebooksRuntimeIamMember#title}
    */
    readonly title: string;
}
export declare function notebooksRuntimeIamMemberConditionToTerraform(struct?: NotebooksRuntimeIamMemberConditionOutputReference | NotebooksRuntimeIamMemberCondition): any;
export declare class NotebooksRuntimeIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NotebooksRuntimeIamMemberCondition | undefined;
    set internalValue(value: NotebooksRuntimeIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member google_notebooks_runtime_iam_member}
*/
export declare class NotebooksRuntimeIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_notebooks_runtime_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/notebooks_runtime_iam_member google_notebooks_runtime_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NotebooksRuntimeIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: NotebooksRuntimeIamMemberConfig);
    get etag(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _runtimeName?;
    get runtimeName(): string;
    set runtimeName(value: string);
    get runtimeNameInput(): string | undefined;
    private _condition;
    get condition(): NotebooksRuntimeIamMemberConditionOutputReference;
    putCondition(value: NotebooksRuntimeIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): NotebooksRuntimeIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
