import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OsConfigPatchDeploymentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the patch deployment. Length of the description is limited to 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#description OsConfigPatchDeployment#description}
    */
    readonly description?: string;
    /**
    * Duration of the patch. After the duration ends, the patch times out.
  A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s"
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#duration OsConfigPatchDeployment#duration}
    */
    readonly duration?: string;
    /**
    * A name for the patch deployment in the project. When creating a name the following rules apply:
  * Must contain only lowercase letters, numbers, and hyphens.
  * Must start with a letter.
  * Must be between 1-63 characters.
  * Must end with a number or a letter.
  * Must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#patch_deployment_id OsConfigPatchDeployment#patch_deployment_id}
    */
    readonly patchDeploymentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#project OsConfigPatchDeployment#project}
    */
    readonly project?: string;
    /**
    * instance_filter block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#instance_filter OsConfigPatchDeployment#instance_filter}
    */
    readonly instanceFilter: OsConfigPatchDeploymentInstanceFilter;
    /**
    * one_time_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#one_time_schedule OsConfigPatchDeployment#one_time_schedule}
    */
    readonly oneTimeSchedule?: OsConfigPatchDeploymentOneTimeSchedule;
    /**
    * patch_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#patch_config OsConfigPatchDeployment#patch_config}
    */
    readonly patchConfig?: OsConfigPatchDeploymentPatchConfig;
    /**
    * recurring_schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#recurring_schedule OsConfigPatchDeployment#recurring_schedule}
    */
    readonly recurringSchedule?: OsConfigPatchDeploymentRecurringSchedule;
    /**
    * rollout block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#rollout OsConfigPatchDeployment#rollout}
    */
    readonly rollout?: OsConfigPatchDeploymentRollout;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#timeouts OsConfigPatchDeployment#timeouts}
    */
    readonly timeouts?: OsConfigPatchDeploymentTimeouts;
}
export interface OsConfigPatchDeploymentInstanceFilterGroupLabels {
    /**
    * Compute Engine instance labels that must be present for a VM instance to be targeted by this filter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#labels OsConfigPatchDeployment#labels}
    */
    readonly labels: {
        [key: string]: string;
    };
}
export declare function osConfigPatchDeploymentInstanceFilterGroupLabelsToTerraform(struct?: OsConfigPatchDeploymentInstanceFilterGroupLabels | cdktf.IResolvable): any;
export interface OsConfigPatchDeploymentInstanceFilter {
    /**
    * Target all VM instances in the project. If true, no other criteria is permitted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#all OsConfigPatchDeployment#all}
    */
    readonly all?: boolean | cdktf.IResolvable;
    /**
    * Targets VMs whose name starts with one of these prefixes. Similar to labels, this is another way to group
  VMs when targeting configs, for example prefix="prod-".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#instance_name_prefixes OsConfigPatchDeployment#instance_name_prefixes}
    */
    readonly instanceNamePrefixes?: string[];
    /**
    * Targets any of the VM instances specified. Instances are specified by their URI in the 'form zones/{{zone}}/instances/{{instance_name}}',
  'projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}', or
  'https://www.googleapis.com/compute/v1/projects/{{project_id}}/zones/{{zone}}/instances/{{instance_name}}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#instances OsConfigPatchDeployment#instances}
    */
    readonly instances?: string[];
    /**
    * Targets VM instances in ANY of these zones. Leave empty to target VM instances in any zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#zones OsConfigPatchDeployment#zones}
    */
    readonly zones?: string[];
    /**
    * group_labels block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#group_labels OsConfigPatchDeployment#group_labels}
    */
    readonly groupLabels?: OsConfigPatchDeploymentInstanceFilterGroupLabels[] | cdktf.IResolvable;
}
export declare function osConfigPatchDeploymentInstanceFilterToTerraform(struct?: OsConfigPatchDeploymentInstanceFilterOutputReference | OsConfigPatchDeploymentInstanceFilter): any;
export declare class OsConfigPatchDeploymentInstanceFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentInstanceFilter | undefined;
    set internalValue(value: OsConfigPatchDeploymentInstanceFilter | undefined);
    private _all?;
    get all(): boolean | cdktf.IResolvable;
    set all(value: boolean | cdktf.IResolvable);
    resetAll(): void;
    get allInput(): boolean | cdktf.IResolvable | undefined;
    private _instanceNamePrefixes?;
    get instanceNamePrefixes(): string[];
    set instanceNamePrefixes(value: string[]);
    resetInstanceNamePrefixes(): void;
    get instanceNamePrefixesInput(): string[] | undefined;
    private _instances?;
    get instances(): string[];
    set instances(value: string[]);
    resetInstances(): void;
    get instancesInput(): string[] | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _groupLabels?;
    get groupLabels(): OsConfigPatchDeploymentInstanceFilterGroupLabels[] | cdktf.IResolvable;
    set groupLabels(value: OsConfigPatchDeploymentInstanceFilterGroupLabels[] | cdktf.IResolvable);
    resetGroupLabels(): void;
    get groupLabelsInput(): cdktf.IResolvable | OsConfigPatchDeploymentInstanceFilterGroupLabels[] | undefined;
}
export interface OsConfigPatchDeploymentOneTimeSchedule {
    /**
    * The desired patch job execution time. A timestamp in RFC3339 UTC "Zulu" format,
  accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#execute_time OsConfigPatchDeployment#execute_time}
    */
    readonly executeTime: string;
}
export declare function osConfigPatchDeploymentOneTimeScheduleToTerraform(struct?: OsConfigPatchDeploymentOneTimeScheduleOutputReference | OsConfigPatchDeploymentOneTimeSchedule): any;
export declare class OsConfigPatchDeploymentOneTimeScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentOneTimeSchedule | undefined;
    set internalValue(value: OsConfigPatchDeploymentOneTimeSchedule | undefined);
    private _executeTime?;
    get executeTime(): string;
    set executeTime(value: string);
    get executeTimeInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigApt {
    /**
    * List of packages to exclude from update. These packages will be excluded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#excludes OsConfigPatchDeployment#excludes}
    */
    readonly excludes?: string[];
    /**
    * An exclusive list of packages to be updated. These are the only packages that will be updated.
  If these packages are not installed, they will be ignored. This field cannot be specified with
  any other patch configuration fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#exclusive_packages OsConfigPatchDeployment#exclusive_packages}
    */
    readonly exclusivePackages?: string[];
    /**
    * By changing the type to DIST, the patching is performed using apt-get dist-upgrade instead. Possible values: ["DIST", "UPGRADE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#type OsConfigPatchDeployment#type}
    */
    readonly type?: string;
}
export declare function osConfigPatchDeploymentPatchConfigAptToTerraform(struct?: OsConfigPatchDeploymentPatchConfigAptOutputReference | OsConfigPatchDeploymentPatchConfigApt): any;
export declare class OsConfigPatchDeploymentPatchConfigAptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigApt | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigApt | undefined);
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePackages?;
    get exclusivePackages(): string[];
    set exclusivePackages(value: string[]);
    resetExclusivePackages(): void;
    get exclusivePackagesInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigGoo {
    /**
    * goo update settings. Use this setting to override the default goo patch rules.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#enabled OsConfigPatchDeployment#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function osConfigPatchDeploymentPatchConfigGooToTerraform(struct?: OsConfigPatchDeploymentPatchConfigGooOutputReference | OsConfigPatchDeploymentPatchConfigGoo): any;
export declare class OsConfigPatchDeploymentPatchConfigGooOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigGoo | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigGoo | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject {
    /**
    * Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#bucket OsConfigPatchDeployment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#generation_number OsConfigPatchDeployment#generation_number}
    */
    readonly generationNumber: string;
    /**
    * Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#object OsConfigPatchDeployment#object}
    */
    readonly object: string;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference | OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject): any;
export declare class OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig {
    /**
    * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
    */
    readonly allowedSuccessCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script will
  be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#interpreter OsConfigPatchDeployment#interpreter}
    */
    readonly interpreter?: string;
    /**
    * An absolute path to the executable on the VM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#local_path OsConfigPatchDeployment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs_object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#gcs_object OsConfigPatchDeployment#gcs_object}
    */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference | OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig): any;
export declare class OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[];
    set allowedSuccessCodes(value: number[]);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject;
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject): void;
    resetGcsObject(): void;
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigGcsObject | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject {
    /**
    * Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#bucket OsConfigPatchDeployment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#generation_number OsConfigPatchDeployment#generation_number}
    */
    readonly generationNumber: string;
    /**
    * Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#object OsConfigPatchDeployment#object}
    */
    readonly object: string;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference | OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject): any;
export declare class OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig {
    /**
    * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
    */
    readonly allowedSuccessCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script will
  be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#interpreter OsConfigPatchDeployment#interpreter}
    */
    readonly interpreter?: string;
    /**
    * An absolute path to the executable on the VM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#local_path OsConfigPatchDeployment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs_object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#gcs_object OsConfigPatchDeployment#gcs_object}
    */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference | OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig): any;
export declare class OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[];
    set allowedSuccessCodes(value: number[]);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject;
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject): void;
    resetGcsObject(): void;
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigGcsObject | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPostStep {
    /**
    * linux_exec_step_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#linux_exec_step_config OsConfigPatchDeployment#linux_exec_step_config}
    */
    readonly linuxExecStepConfig?: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig;
    /**
    * windows_exec_step_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#windows_exec_step_config OsConfigPatchDeployment#windows_exec_step_config}
    */
    readonly windowsExecStepConfig?: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig;
}
export declare function osConfigPatchDeploymentPatchConfigPostStepToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPostStepOutputReference | OsConfigPatchDeploymentPatchConfigPostStep): any;
export declare class OsConfigPatchDeploymentPatchConfigPostStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPostStep | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPostStep | undefined);
    private _linuxExecStepConfig;
    get linuxExecStepConfig(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfigOutputReference;
    putLinuxExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig): void;
    resetLinuxExecStepConfig(): void;
    get linuxExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPostStepLinuxExecStepConfig | undefined;
    private _windowsExecStepConfig;
    get windowsExecStepConfig(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfigOutputReference;
    putWindowsExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig): void;
    resetWindowsExecStepConfig(): void;
    get windowsExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPostStepWindowsExecStepConfig | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject {
    /**
    * Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#bucket OsConfigPatchDeployment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#generation_number OsConfigPatchDeployment#generation_number}
    */
    readonly generationNumber: string;
    /**
    * Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#object OsConfigPatchDeployment#object}
    */
    readonly object: string;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference | OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject): any;
export declare class OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig {
    /**
    * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
    */
    readonly allowedSuccessCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script will
  be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#interpreter OsConfigPatchDeployment#interpreter}
    */
    readonly interpreter?: string;
    /**
    * An absolute path to the executable on the VM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#local_path OsConfigPatchDeployment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs_object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#gcs_object OsConfigPatchDeployment#gcs_object}
    */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference | OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig): any;
export declare class OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[];
    set allowedSuccessCodes(value: number[]);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject;
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject): void;
    resetGcsObject(): void;
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigGcsObject | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject {
    /**
    * Bucket of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#bucket OsConfigPatchDeployment#bucket}
    */
    readonly bucket: string;
    /**
    * Generation number of the Cloud Storage object. This is used to ensure that the ExecStep specified by this PatchJob does not change.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#generation_number OsConfigPatchDeployment#generation_number}
    */
    readonly generationNumber: string;
    /**
    * Name of the Cloud Storage object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#object OsConfigPatchDeployment#object}
    */
    readonly object: string;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference | OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject): any;
export declare class OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _generationNumber?;
    get generationNumber(): string;
    set generationNumber(value: string);
    get generationNumberInput(): string | undefined;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig {
    /**
    * Defaults to [0]. A list of possible return values that the execution can return to indicate a success.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#allowed_success_codes OsConfigPatchDeployment#allowed_success_codes}
    */
    readonly allowedSuccessCodes?: number[];
    /**
    * The script interpreter to use to run the script. If no interpreter is specified the script will
  be executed directly, which will likely only succeed for scripts with shebang lines. Possible values: ["SHELL", "POWERSHELL"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#interpreter OsConfigPatchDeployment#interpreter}
    */
    readonly interpreter?: string;
    /**
    * An absolute path to the executable on the VM.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#local_path OsConfigPatchDeployment#local_path}
    */
    readonly localPath?: string;
    /**
    * gcs_object block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#gcs_object OsConfigPatchDeployment#gcs_object}
    */
    readonly gcsObject?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference | OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig): any;
export declare class OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined);
    private _allowedSuccessCodes?;
    get allowedSuccessCodes(): number[];
    set allowedSuccessCodes(value: number[]);
    resetAllowedSuccessCodes(): void;
    get allowedSuccessCodesInput(): number[] | undefined;
    private _interpreter?;
    get interpreter(): string;
    set interpreter(value: string);
    resetInterpreter(): void;
    get interpreterInput(): string | undefined;
    private _localPath?;
    get localPath(): string;
    set localPath(value: string);
    resetLocalPath(): void;
    get localPathInput(): string | undefined;
    private _gcsObject;
    get gcsObject(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObjectOutputReference;
    putGcsObject(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject): void;
    resetGcsObject(): void;
    get gcsObjectInput(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigGcsObject | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigPreStep {
    /**
    * linux_exec_step_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#linux_exec_step_config OsConfigPatchDeployment#linux_exec_step_config}
    */
    readonly linuxExecStepConfig?: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig;
    /**
    * windows_exec_step_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#windows_exec_step_config OsConfigPatchDeployment#windows_exec_step_config}
    */
    readonly windowsExecStepConfig?: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig;
}
export declare function osConfigPatchDeploymentPatchConfigPreStepToTerraform(struct?: OsConfigPatchDeploymentPatchConfigPreStepOutputReference | OsConfigPatchDeploymentPatchConfigPreStep): any;
export declare class OsConfigPatchDeploymentPatchConfigPreStepOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigPreStep | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigPreStep | undefined);
    private _linuxExecStepConfig;
    get linuxExecStepConfig(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfigOutputReference;
    putLinuxExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig): void;
    resetLinuxExecStepConfig(): void;
    get linuxExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPreStepLinuxExecStepConfig | undefined;
    private _windowsExecStepConfig;
    get windowsExecStepConfig(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfigOutputReference;
    putWindowsExecStepConfig(value: OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig): void;
    resetWindowsExecStepConfig(): void;
    get windowsExecStepConfigInput(): OsConfigPatchDeploymentPatchConfigPreStepWindowsExecStepConfig | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigWindowsUpdate {
    /**
    * Only apply updates of these windows update classifications. If empty, all updates are applied. Possible values: ["CRITICAL", "SECURITY", "DEFINITION", "DRIVER", "FEATURE_PACK", "SERVICE_PACK", "TOOL", "UPDATE_ROLLUP", "UPDATE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#classifications OsConfigPatchDeployment#classifications}
    */
    readonly classifications?: string[];
    /**
    * List of KBs to exclude from update.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#excludes OsConfigPatchDeployment#excludes}
    */
    readonly excludes?: string[];
    /**
    * An exclusive list of kbs to be updated. These are the only patches that will be updated.
  This field must not be used with other patch configurations.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#exclusive_patches OsConfigPatchDeployment#exclusive_patches}
    */
    readonly exclusivePatches?: string[];
}
export declare function osConfigPatchDeploymentPatchConfigWindowsUpdateToTerraform(struct?: OsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference | OsConfigPatchDeploymentPatchConfigWindowsUpdate): any;
export declare class OsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined);
    private _classifications?;
    get classifications(): string[];
    set classifications(value: string[]);
    resetClassifications(): void;
    get classificationsInput(): string[] | undefined;
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePatches?;
    get exclusivePatches(): string[];
    set exclusivePatches(value: string[]);
    resetExclusivePatches(): void;
    get exclusivePatchesInput(): string[] | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigYum {
    /**
    * List of packages to exclude from update. These packages will be excluded.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#excludes OsConfigPatchDeployment#excludes}
    */
    readonly excludes?: string[];
    /**
    * An exclusive list of packages to be updated. These are the only packages that will be updated.
  If these packages are not installed, they will be ignored. This field cannot be specified with
  any other patch configuration fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#exclusive_packages OsConfigPatchDeployment#exclusive_packages}
    */
    readonly exclusivePackages?: string[];
    /**
    * Will cause patch to run yum update-minimal instead.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#minimal OsConfigPatchDeployment#minimal}
    */
    readonly minimal?: boolean | cdktf.IResolvable;
    /**
    * Adds the --security flag to yum update. Not supported on all platforms.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#security OsConfigPatchDeployment#security}
    */
    readonly security?: boolean | cdktf.IResolvable;
}
export declare function osConfigPatchDeploymentPatchConfigYumToTerraform(struct?: OsConfigPatchDeploymentPatchConfigYumOutputReference | OsConfigPatchDeploymentPatchConfigYum): any;
export declare class OsConfigPatchDeploymentPatchConfigYumOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigYum | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigYum | undefined);
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePackages?;
    get exclusivePackages(): string[];
    set exclusivePackages(value: string[]);
    resetExclusivePackages(): void;
    get exclusivePackagesInput(): string[] | undefined;
    private _minimal?;
    get minimal(): boolean | cdktf.IResolvable;
    set minimal(value: boolean | cdktf.IResolvable);
    resetMinimal(): void;
    get minimalInput(): boolean | cdktf.IResolvable | undefined;
    private _security?;
    get security(): boolean | cdktf.IResolvable;
    set security(value: boolean | cdktf.IResolvable);
    resetSecurity(): void;
    get securityInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OsConfigPatchDeploymentPatchConfigZypper {
    /**
    * Install only patches with these categories. Common categories include security, recommended, and feature.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#categories OsConfigPatchDeployment#categories}
    */
    readonly categories?: string[];
    /**
    * List of packages to exclude from update.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#excludes OsConfigPatchDeployment#excludes}
    */
    readonly excludes?: string[];
    /**
    * An exclusive list of patches to be updated. These are the only patches that will be installed using 'zypper patch patch:' command.
  This field must not be used with any other patch configuration fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#exclusive_patches OsConfigPatchDeployment#exclusive_patches}
    */
    readonly exclusivePatches?: string[];
    /**
    * Install only patches with these severities. Common severities include critical, important, moderate, and low.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#severities OsConfigPatchDeployment#severities}
    */
    readonly severities?: string[];
    /**
    * Adds the --with-optional flag to zypper patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#with_optional OsConfigPatchDeployment#with_optional}
    */
    readonly withOptional?: boolean | cdktf.IResolvable;
    /**
    * Adds the --with-update flag, to zypper patch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#with_update OsConfigPatchDeployment#with_update}
    */
    readonly withUpdate?: boolean | cdktf.IResolvable;
}
export declare function osConfigPatchDeploymentPatchConfigZypperToTerraform(struct?: OsConfigPatchDeploymentPatchConfigZypperOutputReference | OsConfigPatchDeploymentPatchConfigZypper): any;
export declare class OsConfigPatchDeploymentPatchConfigZypperOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfigZypper | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfigZypper | undefined);
    private _categories?;
    get categories(): string[];
    set categories(value: string[]);
    resetCategories(): void;
    get categoriesInput(): string[] | undefined;
    private _excludes?;
    get excludes(): string[];
    set excludes(value: string[]);
    resetExcludes(): void;
    get excludesInput(): string[] | undefined;
    private _exclusivePatches?;
    get exclusivePatches(): string[];
    set exclusivePatches(value: string[]);
    resetExclusivePatches(): void;
    get exclusivePatchesInput(): string[] | undefined;
    private _severities?;
    get severities(): string[];
    set severities(value: string[]);
    resetSeverities(): void;
    get severitiesInput(): string[] | undefined;
    private _withOptional?;
    get withOptional(): boolean | cdktf.IResolvable;
    set withOptional(value: boolean | cdktf.IResolvable);
    resetWithOptional(): void;
    get withOptionalInput(): boolean | cdktf.IResolvable | undefined;
    private _withUpdate?;
    get withUpdate(): boolean | cdktf.IResolvable;
    set withUpdate(value: boolean | cdktf.IResolvable);
    resetWithUpdate(): void;
    get withUpdateInput(): boolean | cdktf.IResolvable | undefined;
}
export interface OsConfigPatchDeploymentPatchConfig {
    /**
    * Allows the patch job to run on Managed instance groups (MIGs).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#mig_instances_allowed OsConfigPatchDeployment#mig_instances_allowed}
    */
    readonly migInstancesAllowed?: boolean | cdktf.IResolvable;
    /**
    * Post-patch reboot settings. Possible values: ["DEFAULT", "ALWAYS", "NEVER"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#reboot_config OsConfigPatchDeployment#reboot_config}
    */
    readonly rebootConfig?: string;
    /**
    * apt block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#apt OsConfigPatchDeployment#apt}
    */
    readonly apt?: OsConfigPatchDeploymentPatchConfigApt;
    /**
    * goo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#goo OsConfigPatchDeployment#goo}
    */
    readonly goo?: OsConfigPatchDeploymentPatchConfigGoo;
    /**
    * post_step block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#post_step OsConfigPatchDeployment#post_step}
    */
    readonly postStep?: OsConfigPatchDeploymentPatchConfigPostStep;
    /**
    * pre_step block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#pre_step OsConfigPatchDeployment#pre_step}
    */
    readonly preStep?: OsConfigPatchDeploymentPatchConfigPreStep;
    /**
    * windows_update block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#windows_update OsConfigPatchDeployment#windows_update}
    */
    readonly windowsUpdate?: OsConfigPatchDeploymentPatchConfigWindowsUpdate;
    /**
    * yum block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#yum OsConfigPatchDeployment#yum}
    */
    readonly yum?: OsConfigPatchDeploymentPatchConfigYum;
    /**
    * zypper block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#zypper OsConfigPatchDeployment#zypper}
    */
    readonly zypper?: OsConfigPatchDeploymentPatchConfigZypper;
}
export declare function osConfigPatchDeploymentPatchConfigToTerraform(struct?: OsConfigPatchDeploymentPatchConfigOutputReference | OsConfigPatchDeploymentPatchConfig): any;
export declare class OsConfigPatchDeploymentPatchConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentPatchConfig | undefined;
    set internalValue(value: OsConfigPatchDeploymentPatchConfig | undefined);
    private _migInstancesAllowed?;
    get migInstancesAllowed(): boolean | cdktf.IResolvable;
    set migInstancesAllowed(value: boolean | cdktf.IResolvable);
    resetMigInstancesAllowed(): void;
    get migInstancesAllowedInput(): boolean | cdktf.IResolvable | undefined;
    private _rebootConfig?;
    get rebootConfig(): string;
    set rebootConfig(value: string);
    resetRebootConfig(): void;
    get rebootConfigInput(): string | undefined;
    private _apt;
    get apt(): OsConfigPatchDeploymentPatchConfigAptOutputReference;
    putApt(value: OsConfigPatchDeploymentPatchConfigApt): void;
    resetApt(): void;
    get aptInput(): OsConfigPatchDeploymentPatchConfigApt | undefined;
    private _goo;
    get goo(): OsConfigPatchDeploymentPatchConfigGooOutputReference;
    putGoo(value: OsConfigPatchDeploymentPatchConfigGoo): void;
    resetGoo(): void;
    get gooInput(): OsConfigPatchDeploymentPatchConfigGoo | undefined;
    private _postStep;
    get postStep(): OsConfigPatchDeploymentPatchConfigPostStepOutputReference;
    putPostStep(value: OsConfigPatchDeploymentPatchConfigPostStep): void;
    resetPostStep(): void;
    get postStepInput(): OsConfigPatchDeploymentPatchConfigPostStep | undefined;
    private _preStep;
    get preStep(): OsConfigPatchDeploymentPatchConfigPreStepOutputReference;
    putPreStep(value: OsConfigPatchDeploymentPatchConfigPreStep): void;
    resetPreStep(): void;
    get preStepInput(): OsConfigPatchDeploymentPatchConfigPreStep | undefined;
    private _windowsUpdate;
    get windowsUpdate(): OsConfigPatchDeploymentPatchConfigWindowsUpdateOutputReference;
    putWindowsUpdate(value: OsConfigPatchDeploymentPatchConfigWindowsUpdate): void;
    resetWindowsUpdate(): void;
    get windowsUpdateInput(): OsConfigPatchDeploymentPatchConfigWindowsUpdate | undefined;
    private _yum;
    get yum(): OsConfigPatchDeploymentPatchConfigYumOutputReference;
    putYum(value: OsConfigPatchDeploymentPatchConfigYum): void;
    resetYum(): void;
    get yumInput(): OsConfigPatchDeploymentPatchConfigYum | undefined;
    private _zypper;
    get zypper(): OsConfigPatchDeploymentPatchConfigZypperOutputReference;
    putZypper(value: OsConfigPatchDeploymentPatchConfigZypper): void;
    resetZypper(): void;
    get zypperInput(): OsConfigPatchDeploymentPatchConfigZypper | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth {
    /**
    * A day of the week. Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#day_of_week OsConfigPatchDeployment#day_of_week}
    */
    readonly dayOfWeek: string;
    /**
    * Week number in a month. 1-4 indicates the 1st to 4th week of the month. -1 indicates the last week of the month.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#week_ordinal OsConfigPatchDeployment#week_ordinal}
    */
    readonly weekOrdinal: number;
}
export declare function osConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference | OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth): any;
export declare class OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined;
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
    private _weekOrdinal?;
    get weekOrdinal(): number;
    set weekOrdinal(value: number);
    get weekOrdinalInput(): number | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleMonthly {
    /**
    * One day of the month. 1-31 indicates the 1st to the 31st day. -1 indicates the last day of the month.
  Months without the target day will be skipped. For example, a schedule to run "every month on the 31st"
  will not run in February, April, June, etc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#month_day OsConfigPatchDeployment#month_day}
    */
    readonly monthDay?: number;
    /**
    * week_day_of_month block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#week_day_of_month OsConfigPatchDeployment#week_day_of_month}
    */
    readonly weekDayOfMonth?: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth;
}
export declare function osConfigPatchDeploymentRecurringScheduleMonthlyToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference | OsConfigPatchDeploymentRecurringScheduleMonthly): any;
export declare class OsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleMonthly | undefined;
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleMonthly | undefined);
    private _monthDay?;
    get monthDay(): number;
    set monthDay(value: number);
    resetMonthDay(): void;
    get monthDayInput(): number | undefined;
    private _weekDayOfMonth;
    get weekDayOfMonth(): OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonthOutputReference;
    putWeekDayOfMonth(value: OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth): void;
    resetWeekDayOfMonth(): void;
    get weekDayOfMonthInput(): OsConfigPatchDeploymentRecurringScheduleMonthlyWeekDayOfMonth | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleTimeOfDay {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23.
  An API may choose to allow the value "24:00:00" for scenarios like business closing time.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#hours OsConfigPatchDeployment#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#minutes OsConfigPatchDeployment#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#nanos OsConfigPatchDeployment#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows leap-seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#seconds OsConfigPatchDeployment#seconds}
    */
    readonly seconds?: number;
}
export declare function osConfigPatchDeploymentRecurringScheduleTimeOfDayToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference | OsConfigPatchDeploymentRecurringScheduleTimeOfDay): any;
export declare class OsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined;
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleTimeZone {
    /**
    * IANA Time Zone Database time zone, e.g. "America/New_York".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#id OsConfigPatchDeployment#id}
    */
    readonly id: string;
    /**
    * IANA Time Zone Database version number, e.g. "2019a".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#version OsConfigPatchDeployment#version}
    */
    readonly version?: string;
}
export declare function osConfigPatchDeploymentRecurringScheduleTimeZoneToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference | OsConfigPatchDeploymentRecurringScheduleTimeZone): any;
export declare class OsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleTimeZone | undefined;
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleTimeZone | undefined);
    private _id?;
    get id(): string;
    set id(value: string);
    get idInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
}
export interface OsConfigPatchDeploymentRecurringScheduleWeekly {
    /**
    * IANA Time Zone Database time zone, e.g. "America/New_York". Possible values: ["MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#day_of_week OsConfigPatchDeployment#day_of_week}
    */
    readonly dayOfWeek: string;
}
export declare function osConfigPatchDeploymentRecurringScheduleWeeklyToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference | OsConfigPatchDeploymentRecurringScheduleWeekly): any;
export declare class OsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentRecurringScheduleWeekly | undefined;
    set internalValue(value: OsConfigPatchDeploymentRecurringScheduleWeekly | undefined);
    private _dayOfWeek?;
    get dayOfWeek(): string;
    set dayOfWeek(value: string);
    get dayOfWeekInput(): string | undefined;
}
export interface OsConfigPatchDeploymentRecurringSchedule {
    /**
    * The end time at which a recurring patch deployment schedule is no longer active.
  A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#end_time OsConfigPatchDeployment#end_time}
    */
    readonly endTime?: string;
    /**
    * The time that the recurring schedule becomes effective. Defaults to createTime of the patch deployment.
  A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#start_time OsConfigPatchDeployment#start_time}
    */
    readonly startTime?: string;
    /**
    * monthly block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#monthly OsConfigPatchDeployment#monthly}
    */
    readonly monthly?: OsConfigPatchDeploymentRecurringScheduleMonthly;
    /**
    * time_of_day block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#time_of_day OsConfigPatchDeployment#time_of_day}
    */
    readonly timeOfDay: OsConfigPatchDeploymentRecurringScheduleTimeOfDay;
    /**
    * time_zone block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#time_zone OsConfigPatchDeployment#time_zone}
    */
    readonly timeZone: OsConfigPatchDeploymentRecurringScheduleTimeZone;
    /**
    * weekly block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#weekly OsConfigPatchDeployment#weekly}
    */
    readonly weekly?: OsConfigPatchDeploymentRecurringScheduleWeekly;
}
export declare function osConfigPatchDeploymentRecurringScheduleToTerraform(struct?: OsConfigPatchDeploymentRecurringScheduleOutputReference | OsConfigPatchDeploymentRecurringSchedule): any;
export declare class OsConfigPatchDeploymentRecurringScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentRecurringSchedule | undefined;
    set internalValue(value: OsConfigPatchDeploymentRecurringSchedule | undefined);
    private _endTime?;
    get endTime(): string;
    set endTime(value: string);
    resetEndTime(): void;
    get endTimeInput(): string | undefined;
    get lastExecuteTime(): string;
    get nextExecuteTime(): string;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _monthly;
    get monthly(): OsConfigPatchDeploymentRecurringScheduleMonthlyOutputReference;
    putMonthly(value: OsConfigPatchDeploymentRecurringScheduleMonthly): void;
    resetMonthly(): void;
    get monthlyInput(): OsConfigPatchDeploymentRecurringScheduleMonthly | undefined;
    private _timeOfDay;
    get timeOfDay(): OsConfigPatchDeploymentRecurringScheduleTimeOfDayOutputReference;
    putTimeOfDay(value: OsConfigPatchDeploymentRecurringScheduleTimeOfDay): void;
    get timeOfDayInput(): OsConfigPatchDeploymentRecurringScheduleTimeOfDay | undefined;
    private _timeZone;
    get timeZone(): OsConfigPatchDeploymentRecurringScheduleTimeZoneOutputReference;
    putTimeZone(value: OsConfigPatchDeploymentRecurringScheduleTimeZone): void;
    get timeZoneInput(): OsConfigPatchDeploymentRecurringScheduleTimeZone | undefined;
    private _weekly;
    get weekly(): OsConfigPatchDeploymentRecurringScheduleWeeklyOutputReference;
    putWeekly(value: OsConfigPatchDeploymentRecurringScheduleWeekly): void;
    resetWeekly(): void;
    get weeklyInput(): OsConfigPatchDeploymentRecurringScheduleWeekly | undefined;
}
export interface OsConfigPatchDeploymentRolloutDisruptionBudget {
    /**
    * Specifies a fixed value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#fixed OsConfigPatchDeployment#fixed}
    */
    readonly fixed?: number;
    /**
    * Specifies the relative value defined as a percentage, which will be multiplied by a reference value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#percentage OsConfigPatchDeployment#percentage}
    */
    readonly percentage?: number;
}
export declare function osConfigPatchDeploymentRolloutDisruptionBudgetToTerraform(struct?: OsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference | OsConfigPatchDeploymentRolloutDisruptionBudget): any;
export declare class OsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentRolloutDisruptionBudget | undefined;
    set internalValue(value: OsConfigPatchDeploymentRolloutDisruptionBudget | undefined);
    private _fixed?;
    get fixed(): number;
    set fixed(value: number);
    resetFixed(): void;
    get fixedInput(): number | undefined;
    private _percentage?;
    get percentage(): number;
    set percentage(value: number);
    resetPercentage(): void;
    get percentageInput(): number | undefined;
}
export interface OsConfigPatchDeploymentRollout {
    /**
    * Mode of the patch rollout. Possible values: ["ZONE_BY_ZONE", "CONCURRENT_ZONES"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#mode OsConfigPatchDeployment#mode}
    */
    readonly mode: string;
    /**
    * disruption_budget block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#disruption_budget OsConfigPatchDeployment#disruption_budget}
    */
    readonly disruptionBudget: OsConfigPatchDeploymentRolloutDisruptionBudget;
}
export declare function osConfigPatchDeploymentRolloutToTerraform(struct?: OsConfigPatchDeploymentRolloutOutputReference | OsConfigPatchDeploymentRollout): any;
export declare class OsConfigPatchDeploymentRolloutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentRollout | undefined;
    set internalValue(value: OsConfigPatchDeploymentRollout | undefined);
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
    private _disruptionBudget;
    get disruptionBudget(): OsConfigPatchDeploymentRolloutDisruptionBudgetOutputReference;
    putDisruptionBudget(value: OsConfigPatchDeploymentRolloutDisruptionBudget): void;
    get disruptionBudgetInput(): OsConfigPatchDeploymentRolloutDisruptionBudget | undefined;
}
export interface OsConfigPatchDeploymentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#create OsConfigPatchDeployment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment#delete OsConfigPatchDeployment#delete}
    */
    readonly delete?: string;
}
export declare function osConfigPatchDeploymentTimeoutsToTerraform(struct?: OsConfigPatchDeploymentTimeoutsOutputReference | OsConfigPatchDeploymentTimeouts | cdktf.IResolvable): any;
export declare class OsConfigPatchDeploymentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsConfigPatchDeploymentTimeouts | undefined;
    set internalValue(value: OsConfigPatchDeploymentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment google_os_config_patch_deployment}
*/
export declare class OsConfigPatchDeployment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_os_config_patch_deployment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/os_config_patch_deployment google_os_config_patch_deployment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OsConfigPatchDeploymentConfig
    */
    constructor(scope: Construct, id: string, config: OsConfigPatchDeploymentConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    resetDuration(): void;
    get durationInput(): string | undefined;
    get id(): string;
    get lastExecuteTime(): string;
    get name(): string;
    private _patchDeploymentId?;
    get patchDeploymentId(): string;
    set patchDeploymentId(value: string);
    get patchDeploymentIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get updateTime(): string;
    private _instanceFilter;
    get instanceFilter(): OsConfigPatchDeploymentInstanceFilterOutputReference;
    putInstanceFilter(value: OsConfigPatchDeploymentInstanceFilter): void;
    get instanceFilterInput(): OsConfigPatchDeploymentInstanceFilter | undefined;
    private _oneTimeSchedule;
    get oneTimeSchedule(): OsConfigPatchDeploymentOneTimeScheduleOutputReference;
    putOneTimeSchedule(value: OsConfigPatchDeploymentOneTimeSchedule): void;
    resetOneTimeSchedule(): void;
    get oneTimeScheduleInput(): OsConfigPatchDeploymentOneTimeSchedule | undefined;
    private _patchConfig;
    get patchConfig(): OsConfigPatchDeploymentPatchConfigOutputReference;
    putPatchConfig(value: OsConfigPatchDeploymentPatchConfig): void;
    resetPatchConfig(): void;
    get patchConfigInput(): OsConfigPatchDeploymentPatchConfig | undefined;
    private _recurringSchedule;
    get recurringSchedule(): OsConfigPatchDeploymentRecurringScheduleOutputReference;
    putRecurringSchedule(value: OsConfigPatchDeploymentRecurringSchedule): void;
    resetRecurringSchedule(): void;
    get recurringScheduleInput(): OsConfigPatchDeploymentRecurringSchedule | undefined;
    private _rollout;
    get rollout(): OsConfigPatchDeploymentRolloutOutputReference;
    putRollout(value: OsConfigPatchDeploymentRollout): void;
    resetRollout(): void;
    get rolloutInput(): OsConfigPatchDeploymentRollout | undefined;
    private _timeouts;
    get timeouts(): OsConfigPatchDeploymentTimeoutsOutputReference;
    putTimeouts(value: OsConfigPatchDeploymentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): OsConfigPatchDeploymentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
