import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OsLoginSshPublicKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An expiration time in microseconds since epoch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key#expiration_time_usec OsLoginSshPublicKey#expiration_time_usec}
    */
    readonly expirationTimeUsec?: string;
    /**
    * Public key text in SSH format, defined by RFC4253 section 6.6.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key#key OsLoginSshPublicKey#key}
    */
    readonly key: string;
    /**
    * The project ID of the Google Cloud Platform project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key#project OsLoginSshPublicKey#project}
    */
    readonly project?: string;
    /**
    * The user email.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key#user OsLoginSshPublicKey#user}
    */
    readonly user: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key#timeouts OsLoginSshPublicKey#timeouts}
    */
    readonly timeouts?: OsLoginSshPublicKeyTimeouts;
}
export interface OsLoginSshPublicKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key#create OsLoginSshPublicKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key#delete OsLoginSshPublicKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key#update OsLoginSshPublicKey#update}
    */
    readonly update?: string;
}
export declare function osLoginSshPublicKeyTimeoutsToTerraform(struct?: OsLoginSshPublicKeyTimeoutsOutputReference | OsLoginSshPublicKeyTimeouts | cdktf.IResolvable): any;
export declare class OsLoginSshPublicKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OsLoginSshPublicKeyTimeouts | undefined;
    set internalValue(value: OsLoginSshPublicKeyTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key google_os_login_ssh_public_key}
*/
export declare class OsLoginSshPublicKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_os_login_ssh_public_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/os_login_ssh_public_key google_os_login_ssh_public_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OsLoginSshPublicKeyConfig
    */
    constructor(scope: Construct, id: string, config: OsLoginSshPublicKeyConfig);
    private _expirationTimeUsec?;
    get expirationTimeUsec(): string;
    set expirationTimeUsec(value: string);
    resetExpirationTimeUsec(): void;
    get expirationTimeUsecInput(): string | undefined;
    get fingerprint(): string;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    get userInput(): string | undefined;
    private _timeouts;
    get timeouts(): OsLoginSshPublicKeyTimeoutsOutputReference;
    putTimeouts(value: OsLoginSshPublicKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): OsLoginSshPublicKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
