import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCertificateTemplateIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_policy#certificate_template PrivatecaCertificateTemplateIamPolicy#certificate_template}
    */
    readonly certificateTemplate: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_policy#location PrivatecaCertificateTemplateIamPolicy#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_policy#policy_data PrivatecaCertificateTemplateIamPolicy#policy_data}
    */
    readonly policyData: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_policy#project PrivatecaCertificateTemplateIamPolicy#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_policy google_privateca_certificate_template_iam_policy}
*/
export declare class PrivatecaCertificateTemplateIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_privateca_certificate_template_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_template_iam_policy google_privateca_certificate_template_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivatecaCertificateTemplateIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: PrivatecaCertificateTemplateIamPolicyConfig);
    private _certificateTemplate?;
    get certificateTemplate(): string;
    set certificateTemplate(value: string);
    get certificateTemplateInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
