import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_binding#members ProjectIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_binding#project ProjectIamBinding#project}
    */
    readonly project: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_binding#role ProjectIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_binding#condition ProjectIamBinding#condition}
    */
    readonly condition?: ProjectIamBindingCondition;
}
export interface ProjectIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_binding#description ProjectIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_binding#expression ProjectIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/project_iam_binding#title ProjectIamBinding#title}
    */
    readonly title: string;
}
export declare function projectIamBindingConditionToTerraform(struct?: ProjectIamBindingConditionOutputReference | ProjectIamBindingCondition): any;
export declare class ProjectIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProjectIamBindingCondition | undefined;
    set internalValue(value: ProjectIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/project_iam_binding google_project_iam_binding}
*/
export declare class ProjectIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/project_iam_binding google_project_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: ProjectIamBindingConfig);
    get etag(): string;
    get id(): string;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): ProjectIamBindingConditionOutputReference;
    putCondition(value: ProjectIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): ProjectIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
