import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBucketIamPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_policy#bucket StorageBucketIamPolicy#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_policy#policy_data StorageBucketIamPolicy#policy_data}
    */
    readonly policyData: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_policy google_storage_bucket_iam_policy}
*/
export declare class StorageBucketIamPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_bucket_iam_policy";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket_iam_policy google_storage_bucket_iam_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageBucketIamPolicyConfig
    */
    constructor(scope: Construct, id: string, config: StorageBucketIamPolicyConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get etag(): string;
    get id(): string;
    private _policyData?;
    get policyData(): string;
    set policyData(value: string);
    get policyDataInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
