"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StorageNotification = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_notification google_storage_notification}
*/
class StorageNotification extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_notification google_storage_notification} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageNotificationConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'google_storage_notification',
            terraformGeneratorMetadata: {
                providerName: 'google',
                providerVersion: '4.19.0',
                providerVersionConstraint: '~> 4.0'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._bucket = config.bucket;
        this._customAttributes = config.customAttributes;
        this._eventTypes = config.eventTypes;
        this._objectNamePrefix = config.objectNamePrefix;
        this._payloadFormat = config.payloadFormat;
        this._topic = config.topic;
    }
    get bucket() {
        return this.getStringAttribute('bucket');
    }
    set bucket(value) {
        this._bucket = value;
    }
    // Temporarily expose input value. Use with caution.
    get bucketInput() {
        return this._bucket;
    }
    get customAttributes() {
        return this.getStringMapAttribute('custom_attributes');
    }
    set customAttributes(value) {
        this._customAttributes = value;
    }
    resetCustomAttributes() {
        this._customAttributes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get customAttributesInput() {
        return this._customAttributes;
    }
    get eventTypes() {
        return cdktf.Fn.tolist(this.getListAttribute('event_types'));
    }
    set eventTypes(value) {
        this._eventTypes = value;
    }
    resetEventTypes() {
        this._eventTypes = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get eventTypesInput() {
        return this._eventTypes;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    // notification_id - computed: true, optional: false, required: false
    get notificationId() {
        return this.getStringAttribute('notification_id');
    }
    get objectNamePrefix() {
        return this.getStringAttribute('object_name_prefix');
    }
    set objectNamePrefix(value) {
        this._objectNamePrefix = value;
    }
    resetObjectNamePrefix() {
        this._objectNamePrefix = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get objectNamePrefixInput() {
        return this._objectNamePrefix;
    }
    get payloadFormat() {
        return this.getStringAttribute('payload_format');
    }
    set payloadFormat(value) {
        this._payloadFormat = value;
    }
    // Temporarily expose input value. Use with caution.
    get payloadFormatInput() {
        return this._payloadFormat;
    }
    // self_link - computed: true, optional: false, required: false
    get selfLink() {
        return this.getStringAttribute('self_link');
    }
    get topic() {
        return this.getStringAttribute('topic');
    }
    set topic(value) {
        this._topic = value;
    }
    // Temporarily expose input value. Use with caution.
    get topicInput() {
        return this._topic;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            bucket: cdktf.stringToTerraform(this._bucket),
            custom_attributes: cdktf.hashMapper(cdktf.stringToTerraform)(this._customAttributes),
            event_types: cdktf.listMapper(cdktf.stringToTerraform)(this._eventTypes),
            object_name_prefix: cdktf.stringToTerraform(this._objectNamePrefix),
            payload_format: cdktf.stringToTerraform(this._payloadFormat),
            topic: cdktf.stringToTerraform(this._topic),
        };
    }
}
exports.StorageNotification = StorageNotification;
_a = JSII_RTTI_SYMBOL_1;
StorageNotification[_a] = { fqn: "@cdktf/provider-google.StorageNotification", version: "0.8.23" };
// =================
// STATIC PROPERTIES
// =================
StorageNotification.tfResourceType = "google_storage_notification";
//# sourceMappingURL=data:application/json;base64,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