# ASCIIColors

ASCIIColors is a Python utility that provides an easy way to add color and style to text output in the console. It offers a simple interface for printing text with various colors and styles, making it especially useful for enhancing the readability of console-based applications or adding emphasis to specific messages.

## Table of Contents

- [Installation](#installation)
- [Usage](#usage)
- [Methods](#methods)
- [Examples](#examples)
- [Contributing](#contributing)
- [License](#license)

## Installation

You can install ASCIIColors via `pip` from the Python Package Index (PyPI):

```bash
pip install ascii_colors
```

## Usage

ASCIIColors provides a set of methods for printing text with different colors and styles. Here's a basic example of how to use it:

```python
from asciicolors import ASCIIColors

# Print text in bright red color
ASCIIColors.print("Hello, world!", ASCIIColors.color_bright_red)
```

## Methods

ASCIIColors provides the following methods for formatting and printing text:

- `print(text, color=color_bright_red, style="", end="\n", flush=False)`: Prints text with the specified color and style.

- `warning(text, end="\n", flush=False)`: Prints text in a warning style.

- `error(text, end="\n", flush=False)`: Prints text in an error style.

- `success(text, end="\n", flush=False)`: Prints text in a success style.

- `info(text, end="\n", flush=False)`: Prints text in an info style.

- `red(text, end="\n", flush=False)`: Prints text in red color.

- `green(text, end="\n", flush=False)`: Prints text in green color.

- `blue(text, end="\n", flush=False)`: Prints text in blue color.

- `yellow(text, end="\n", flush=False)`: Prints text in yellow color.

- `magenta(text, end="\n", flush=False)`: Prints text in magenta color.

- `cyan(text, end="\n", flush=False)`: Prints text in cyan color.

- `bold(text, color=color_bright_red, end="\n", flush=False)`: Prints text in bold style with the specified color.

- `underline(text, color=color_bright_red, end="\n", flush=False)`: Prints text with an underline style and the specified color.

- `activate(color_or_style)`: Activates a specific color or style for subsequent text printing.

- `reset()`: Resets the color and style settings to their default values.

- `resetColor()`: Resets the color settings to their default value.

- `resetStyle()`: Resets the style settings to their default value.

- `resetAll()`: Resets both color and style settings to their default values.

## Examples

Here are some examples of how to use ASCIIColors to enhance your console output:

```python
from asciicolors import ASCIIColors

# Print an error message
ASCIIColors.error("This is an error message")

# Print a success message
ASCIIColors.success("Operation successful")

# Print a warning message
ASCIIColors.warning("Warning: This action cannot be undone")

# Print text in bold and underline style
ASCIIColors.bold("Important message", ASCIIColors.color_bright_blue)
ASCIIColors.underline("Underlined text", ASCIIColors.color_bright_green)

# Use specific colors directly
ASCIIColors.yellow("Yellow text")
ASCIIColors.red("Red text")
ASCIIColors.green("Green text")
ASCIIColors.cyan("Cyan text")

ASCIIColors.multicolor(["Green text","red text","yellow text"],[ASCIIColors.color_green, ASCIIColors.color_red, ASCIIColors.color_yellow])
```

Trace and color your exceptions using `trace_exception`: 

```python
# Trace all your exceptions using:
from asciicolors import trace_exception

try:
    #some nasty stuff that can crush
except Exception as ex:
    trace_exception(ex)

```


## Contributing

Contributions to ASCIIColors are welcome! If you have ideas for improvements or new features, please feel free to open an issue or submit a pull request. Make sure to follow the [contribution guidelines](CONTRIBUTING.md).

## License

ASCIIColors is licensed under the [Apache License 2.0](LICENSE). You are free to use, modify, and distribute this utility as per the terms of the license.
