# Generated by configen, do not edit.
# See https://github.com/facebookresearch/hydra/tree/master/tools/configen
# fmt: off
# isort:skip_file
# flake8: noqa

from dataclasses import dataclass, field
from conduit.data.datasets.audio.ecoacoustics import SoundscapeAttr
from conduit.data.datasets.vision.camelyon17 import Camelyon17Attr
from conduit.data.datasets.vision.camelyon17 import Camelyon17SplitScheme
from conduit.data.datasets.vision.celeba import CelebAttr
from conduit.data.datasets.vision.isic import IsicAttr
from conduit.data.datasets.vision.nico import NicoSuperclass
from conduit.data.datasets.vision.ssrp import SSRPSplit
from omegaconf import MISSING
from typing import Any
from typing import Dict
from typing import List
from typing import Optional


@dataclass
class CelebAConf:
    _target_: str = "conduit.data.datasets.CelebA"
    root: Any = MISSING  # Union[str, Path]
    download: bool = True
    superclass: Any = CelebAttr.Smiling  # Union[CelebAttr, str]
    subclass: Any = CelebAttr.Male  # Union[CelebAttr, str]
    transform: Any = None  # Union[Compose, BasicTransform, Callable[[Image], Any], NoneType]
    split: Any = None  # Union[CelebASplit, str, NoneType]


@dataclass
class ColoredMNISTConf:
    _target_: str = "conduit.data.datasets.ColoredMNIST"
    root: Any = MISSING  # Union[str, Path]
    download: bool = True
    transform: Any = None  # Union[Compose, BasicTransform, Callable[[Image], Any], NoneType]
    label_map: Optional[Dict[str, int]] = None
    colors: Optional[List[int]] = None
    num_colors: int = 10
    scale: float = 0.2
    correlation: Optional[float] = None
    binarize: bool = False
    greyscale: bool = False
    background: bool = False
    black: bool = True
    split: Any = None  # Union[ColoredMNISTSplit, str, NoneType]
    seed: Optional[int] = 42


@dataclass
class ISICConf:
    _target_: str = "conduit.data.datasets.ISIC"
    root: Any = MISSING  # Union[str, Path]
    download: bool = True
    max_samples: int = 25000
    context_attr: IsicAttr = IsicAttr.histo
    target_attr: IsicAttr = IsicAttr.malignant
    transform: Any = None  # Union[Compose, BasicTransform, Callable[[Image], Any], NoneType]


@dataclass
class NICOConf:
    _target_: str = "conduit.data.datasets.NICO"
    root: Any = MISSING  # Union[str, Path]
    download: bool = True
    transform: Any = None  # Union[Compose, BasicTransform, Callable[[Image], Any], NoneType]
    superclass: Any = NicoSuperclass.animals  # Union[NicoSuperclass, str, NoneType]


@dataclass
class SSRPConf:
    _target_: str = "conduit.data.datasets.SSRP"
    root: Any = MISSING  # Union[str, Path]
    split: Any = SSRPSplit.pretrain  # Union[SSRPSplit, str]
    download: bool = True
    transform: Any = None  # Union[Compose, BasicTransform, Callable[[Image], Any], NoneType]


@dataclass
class WaterbirdsConf:
    _target_: str = "conduit.data.datasets.Waterbirds"
    root: Any = MISSING  # Union[str, Path]
    download: bool = True
    transform: Any = None  # Union[Compose, BasicTransform, Callable[[Image], Any], NoneType]
    split: Any = None  # Union[WaterbirdsSplit, str, NoneType]


@dataclass
class Camelyon17Conf:
    _target_: str = "conduit.data.datasets.Camelyon17"
    root: Any = MISSING  # Union[str, Path]
    download: bool = True
    transform: Any = None  # Union[Compose, BasicTransform, Callable[[Image], Any], NoneType]
    split: Any = None  # Union[Camelyon17Split, str, NoneType]
    split_scheme: Any = Camelyon17SplitScheme.official  # Union[Camelyon17SplitScheme, str]
    superclass: Any = Camelyon17Attr.tumor  # Union[Camelyon17Attr, str]
    subclass: Any = Camelyon17Attr.center  # Union[Camelyon17Attr, str]


@dataclass
class EcoacousticsConf:
    _target_: str = "conduit.data.datasets.Ecoacoustics"
    root: Any = MISSING  # Union[str, Path]
    transform: Any = None  # Optional[Callable[[Tensor], Tensor]]
    download: bool = True
    target_attrs: Any = SoundscapeAttr.habitat  # Union[SoundscapeAttr, str, List[Union[SoundscapeAttr, str]]]
    segment_len: Optional[float] = 15
    preprocess: bool = False
