# AUTOGENERATED! DO NOT EDIT! File to edit: ../00_convert_messages.ipynb.

# %% auto 0
__all__ = ['Convert']

# %% ../00_convert_messages.ipynb 3
import pandas as pd
import json
from datetime import datetime
from datetime import date

# %% ../00_convert_messages.ipynb 4
class Convert():
    "Converts a text from a Linux log file into a Pandas Dataframe, OCSF JSON, or JSON."
    def log_to_ocsf(self, in_file):
        df = self.text_to_df(in_file)
        result = df.to_json(orient="records")
        return json.loads(result)
    
    def text_to_df(self, in_file):
        current_year = str(date.today().year)
        dfLog = pd.DataFrame( columns=[ 'time' , 'ip' , 'activity' , 'message' ] )
        with open( in_file , 'r' ) as logFile :
            rowNum = -1
            for line in logFile :
                tokens = line.split(" ")
                my_time_stamp = tokens[0] + '/' + tokens[1] + '/' + current_year + '-' + tokens[2]
                # my_time_stamp = datetime.strptime(my_time_stamp, '%b/%d/%Y-%H:%M:%S')
                my_address = tokens[3]
                my_type = tokens[4]
                my_message = " ".join( tokens[5:] )
                rowNum += 1
                dfLog.loc[ rowNum ] = [ my_time_stamp , my_address , my_type , my_message ]    
        return dfLog
