from signal import signal, SIGTERM
from types import FrameType

from buz.event.kombu.execution_strategy import ExecutionStrategy


class Worker:
    def __init__(
        self,
        execution_strategy: ExecutionStrategy,
    ) -> None:
        self.__execution_strategy = execution_strategy

    def start(self) -> None:
        signal(SIGTERM, self.__sigterm_handler)
        print("Starting buz worker...")
        self.__execution_strategy.start()
        print("Buz worker stopped gracefully")

    def __sigterm_handler(self, signum: int, frame: FrameType) -> None:
        self.stop()

    def stop(self) -> None:
        self.__execution_strategy.stop()
        print("Stopping buz worker...")
