"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getStackPrefix = void 0;
/**
 * Returns a prefix comprising of a delimited set of Stack Ids.
 *
 * For example: StackA/NestedStackB/
 *
 * TODO: Move this into a shared helper library.
 *
 * @param stack stack instance.
 */
exports.getStackPrefix = (stack) => {
    if (stack.nested) {
        return `${exports.getStackPrefix(stack.nestedStackParent)}${stack.node.id}/`;
    }
    else {
        return `${stack.stackName}/`;
    }
};
//# sourceMappingURL=data:application/json;base64,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