import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Pinpoint::ADMChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html
 */
export interface CfnADMChannelProps {
    /**
     * `AWS::Pinpoint::ADMChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientid
     */
    readonly clientId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientSecret`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientsecret
     */
    readonly clientSecret: string;
    /**
     * `AWS::Pinpoint::ADMChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::ADMChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::ADMChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html
 */
export declare class CfnADMChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::ADMChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnADMChannel;
    /**
     * `AWS::Pinpoint::ADMChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientid
     */
    clientId: string;
    /**
     * `AWS::Pinpoint::ADMChannel.ClientSecret`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-clientsecret
     */
    clientSecret: string;
    /**
     * `AWS::Pinpoint::ADMChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-admchannel.html#cfn-pinpoint-admchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::ADMChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnADMChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html
 */
export interface CfnAPNSChannelProps {
    /**
     * `AWS::Pinpoint::APNSChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSChannel.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-bundleid
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-certificate
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.DefaultAuthenticationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-defaultauthenticationmethod
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSChannel.PrivateKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-privatekey
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.TeamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-teamid
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkey
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkeyid
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::APNSChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html
 */
export declare class CfnAPNSChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAPNSChannel;
    /**
     * `AWS::Pinpoint::APNSChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSChannel.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-bundleid
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-certificate
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.DefaultAuthenticationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-defaultauthenticationmethod
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.PrivateKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-privatekey
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.TeamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-teamid
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkey
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSChannel.TokenKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnschannel.html#cfn-pinpoint-apnschannel-tokenkeyid
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSSandboxChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html
 */
export interface CfnAPNSSandboxChannelProps {
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-bundleid
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-certificate
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.DefaultAuthenticationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-defaultauthenticationmethod
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.PrivateKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-privatekey
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TeamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-teamid
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkey
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkeyid
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSSandboxChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::APNSSandboxChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html
 */
export declare class CfnAPNSSandboxChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSSandboxChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAPNSSandboxChannel;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-bundleid
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-certificate
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.DefaultAuthenticationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-defaultauthenticationmethod
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.PrivateKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-privatekey
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TeamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-teamid
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkey
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSSandboxChannel.TokenKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnssandboxchannel.html#cfn-pinpoint-apnssandboxchannel-tokenkeyid
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSSandboxChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSSandboxChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSVoipChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html
 */
export interface CfnAPNSVoipChannelProps {
    /**
     * `AWS::Pinpoint::APNSVoipChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-bundleid
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-certificate
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.DefaultAuthenticationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-defaultauthenticationmethod
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.PrivateKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-privatekey
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TeamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-teamid
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkey
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkeyid
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSVoipChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::APNSVoipChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html
 */
export declare class CfnAPNSVoipChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSVoipChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAPNSVoipChannel;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-bundleid
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-certificate
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.DefaultAuthenticationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-defaultauthenticationmethod
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.PrivateKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-privatekey
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TeamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-teamid
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkey
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipChannel.TokenKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipchannel.html#cfn-pinpoint-apnsvoipchannel-tokenkeyid
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSVoipChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSVoipChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::APNSVoipSandboxChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html
 */
export interface CfnAPNSVoipSandboxChannelProps {
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-bundleid
     */
    readonly bundleId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-certificate
     */
    readonly certificate?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.DefaultAuthenticationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-defaultauthenticationmethod
     */
    readonly defaultAuthenticationMethod?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.PrivateKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-privatekey
     */
    readonly privateKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TeamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-teamid
     */
    readonly teamId?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkey
     */
    readonly tokenKey?: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkeyid
     */
    readonly tokenKeyId?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::APNSVoipSandboxChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::APNSVoipSandboxChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html
 */
export declare class CfnAPNSVoipSandboxChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::APNSVoipSandboxChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAPNSVoipSandboxChannel;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.BundleId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-bundleid
     */
    bundleId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Certificate`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-certificate
     */
    certificate: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.DefaultAuthenticationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-defaultauthenticationmethod
     */
    defaultAuthenticationMethod: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.PrivateKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-privatekey
     */
    privateKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TeamId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-teamid
     */
    teamId: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkey
     */
    tokenKey: string | undefined;
    /**
     * `AWS::Pinpoint::APNSVoipSandboxChannel.TokenKeyId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-apnsvoipsandboxchannel.html#cfn-pinpoint-apnsvoipsandboxchannel-tokenkeyid
     */
    tokenKeyId: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::APNSVoipSandboxChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAPNSVoipSandboxChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::App`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html
 */
export interface CfnAppProps {
    /**
     * `AWS::Pinpoint::App.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-name
     */
    readonly name: string;
    /**
     * `AWS::Pinpoint::App.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Pinpoint::App`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::App
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::App";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApp;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::App.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-name
     */
    name: string;
    /**
     * `AWS::Pinpoint::App.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-app.html#cfn-pinpoint-app-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Pinpoint::App`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::ApplicationSettings`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 */
export interface CfnApplicationSettingsProps {
    /**
     * `AWS::Pinpoint::ApplicationSettings.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CampaignHook`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-campaignhook
     */
    readonly campaignHook?: CfnApplicationSettings.CampaignHookProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CloudWatchMetricsEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-cloudwatchmetricsenabled
     */
    readonly cloudWatchMetricsEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::ApplicationSettings.Limits`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-limits
     */
    readonly limits?: CfnApplicationSettings.LimitsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::ApplicationSettings.QuietTime`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-quiettime
     */
    readonly quietTime?: CfnApplicationSettings.QuietTimeProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::ApplicationSettings
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 */
export declare class CfnApplicationSettings extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::ApplicationSettings";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplicationSettings;
    /**
     * `AWS::Pinpoint::ApplicationSettings.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CampaignHook`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-campaignhook
     */
    campaignHook: CfnApplicationSettings.CampaignHookProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::ApplicationSettings.CloudWatchMetricsEnabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-cloudwatchmetricsenabled
     */
    cloudWatchMetricsEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::ApplicationSettings.Limits`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-limits
     */
    limits: CfnApplicationSettings.LimitsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::ApplicationSettings.QuietTime`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html#cfn-pinpoint-applicationsettings-quiettime
     */
    quietTime: CfnApplicationSettings.QuietTimeProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::ApplicationSettings`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationSettingsProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::ApplicationSettings
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 */
export declare namespace CfnApplicationSettings {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html
     */
    interface CampaignHookProperty {
        /**
         * `CfnApplicationSettings.CampaignHookProperty.LambdaFunctionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html#cfn-pinpoint-applicationsettings-campaignhook-lambdafunctionname
         */
        readonly lambdaFunctionName?: string;
        /**
         * `CfnApplicationSettings.CampaignHookProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html#cfn-pinpoint-applicationsettings-campaignhook-mode
         */
        readonly mode?: string;
        /**
         * `CfnApplicationSettings.CampaignHookProperty.WebUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-campaignhook.html#cfn-pinpoint-applicationsettings-campaignhook-weburl
         */
        readonly webUrl?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::ApplicationSettings
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 */
export declare namespace CfnApplicationSettings {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html
     */
    interface LimitsProperty {
        /**
         * `CfnApplicationSettings.LimitsProperty.Daily`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-daily
         */
        readonly daily?: number;
        /**
         * `CfnApplicationSettings.LimitsProperty.MaximumDuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-maximumduration
         */
        readonly maximumDuration?: number;
        /**
         * `CfnApplicationSettings.LimitsProperty.MessagesPerSecond`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-messagespersecond
         */
        readonly messagesPerSecond?: number;
        /**
         * `CfnApplicationSettings.LimitsProperty.Total`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-limits.html#cfn-pinpoint-applicationsettings-limits-total
         */
        readonly total?: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::ApplicationSettings`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::ApplicationSettings
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-applicationsettings.html
 */
export declare namespace CfnApplicationSettings {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-quiettime.html
     */
    interface QuietTimeProperty {
        /**
         * `CfnApplicationSettings.QuietTimeProperty.End`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-quiettime.html#cfn-pinpoint-applicationsettings-quiettime-end
         */
        readonly end: string;
        /**
         * `CfnApplicationSettings.QuietTimeProperty.Start`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-applicationsettings-quiettime.html#cfn-pinpoint-applicationsettings-quiettime-start
         */
        readonly start: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::BaiduChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html
 */
export interface CfnBaiduChannelProps {
    /**
     * `AWS::Pinpoint::BaiduChannel.ApiKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-apikey
     */
    readonly apiKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.SecretKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-secretkey
     */
    readonly secretKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::BaiduChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::BaiduChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html
 */
export declare class CfnBaiduChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::BaiduChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnBaiduChannel;
    /**
     * `AWS::Pinpoint::BaiduChannel.ApiKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-apikey
     */
    apiKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.SecretKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-secretkey
     */
    secretKey: string;
    /**
     * `AWS::Pinpoint::BaiduChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-baiduchannel.html#cfn-pinpoint-baiduchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::BaiduChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBaiduChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export interface CfnCampaignProps {
    /**
     * `AWS::Pinpoint::Campaign.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::Campaign.MessageConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-messageconfiguration
     */
    readonly messageConfiguration: CfnCampaign.MessageConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-name
     */
    readonly name: string;
    /**
     * `AWS::Pinpoint::Campaign.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-schedule
     */
    readonly schedule: CfnCampaign.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.SegmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentid
     */
    readonly segmentId: string;
    /**
     * `AWS::Pinpoint::Campaign.AdditionalTreatments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-additionaltreatments
     */
    readonly additionalTreatments?: Array<CfnCampaign.WriteTreatmentResourceProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.CampaignHook`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-campaignhook
     */
    readonly campaignHook?: CfnCampaign.CampaignHookProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-description
     */
    readonly description?: string;
    /**
     * `AWS::Pinpoint::Campaign.HoldoutPercent`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-holdoutpercent
     */
    readonly holdoutPercent?: number;
    /**
     * `AWS::Pinpoint::Campaign.IsPaused`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-ispaused
     */
    readonly isPaused?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Limits`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-limits
     */
    readonly limits?: CfnCampaign.LimitsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Priority`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-priority
     */
    readonly priority?: number;
    /**
     * `AWS::Pinpoint::Campaign.SegmentVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentversion
     */
    readonly segmentVersion?: number;
    /**
     * `AWS::Pinpoint::Campaign.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentdescription
     */
    readonly treatmentDescription?: string;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentname
     */
    readonly treatmentName?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare class CfnCampaign extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::Campaign";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCampaign;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CampaignId
     */
    readonly attrCampaignId: string;
    /**
     * `AWS::Pinpoint::Campaign.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::Campaign.MessageConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-messageconfiguration
     */
    messageConfiguration: CfnCampaign.MessageConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-name
     */
    name: string;
    /**
     * `AWS::Pinpoint::Campaign.Schedule`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-schedule
     */
    schedule: CfnCampaign.ScheduleProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Campaign.SegmentId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentid
     */
    segmentId: string;
    /**
     * `AWS::Pinpoint::Campaign.AdditionalTreatments`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-additionaltreatments
     */
    additionalTreatments: Array<CfnCampaign.WriteTreatmentResourceProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.CampaignHook`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-campaignhook
     */
    campaignHook: CfnCampaign.CampaignHookProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-description
     */
    description: string | undefined;
    /**
     * `AWS::Pinpoint::Campaign.HoldoutPercent`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-holdoutpercent
     */
    holdoutPercent: number | undefined;
    /**
     * `AWS::Pinpoint::Campaign.IsPaused`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-ispaused
     */
    isPaused: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Limits`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-limits
     */
    limits: CfnCampaign.LimitsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Priority`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-priority
     */
    priority: number | undefined;
    /**
     * `AWS::Pinpoint::Campaign.SegmentVersion`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-segmentversion
     */
    segmentVersion: number | undefined;
    /**
     * `AWS::Pinpoint::Campaign.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentdescription
     */
    treatmentDescription: string | undefined;
    /**
     * `AWS::Pinpoint::Campaign.TreatmentName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html#cfn-pinpoint-campaign-treatmentname
     */
    treatmentName: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::Campaign`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCampaignProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-attributedimension.html
     */
    interface AttributeDimensionProperty {
        /**
         * `CfnCampaign.AttributeDimensionProperty.AttributeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-attributedimension.html#cfn-pinpoint-campaign-attributedimension-attributetype
         */
        readonly attributeType?: string;
        /**
         * `CfnCampaign.AttributeDimensionProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-attributedimension.html#cfn-pinpoint-campaign-attributedimension-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html
     */
    interface CampaignEmailMessageProperty {
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.Body`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-body
         */
        readonly body?: string;
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.FromAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-fromaddress
         */
        readonly fromAddress?: string;
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.HtmlBody`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-htmlbody
         */
        readonly htmlBody?: string;
        /**
         * `CfnCampaign.CampaignEmailMessageProperty.Title`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignemailmessage.html#cfn-pinpoint-campaign-campaignemailmessage-title
         */
        readonly title?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigneventfilter.html
     */
    interface CampaignEventFilterProperty {
        /**
         * `CfnCampaign.CampaignEventFilterProperty.Dimensions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigneventfilter.html#cfn-pinpoint-campaign-campaigneventfilter-dimensions
         */
        readonly dimensions?: CfnCampaign.EventDimensionsProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.CampaignEventFilterProperty.FilterType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigneventfilter.html#cfn-pinpoint-campaign-campaigneventfilter-filtertype
         */
        readonly filterType?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html
     */
    interface CampaignHookProperty {
        /**
         * `CfnCampaign.CampaignHookProperty.LambdaFunctionName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html#cfn-pinpoint-campaign-campaignhook-lambdafunctionname
         */
        readonly lambdaFunctionName?: string;
        /**
         * `CfnCampaign.CampaignHookProperty.Mode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html#cfn-pinpoint-campaign-campaignhook-mode
         */
        readonly mode?: string;
        /**
         * `CfnCampaign.CampaignHookProperty.WebUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignhook.html#cfn-pinpoint-campaign-campaignhook-weburl
         */
        readonly webUrl?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigninappmessage.html
     */
    interface CampaignInAppMessageProperty {
        /**
         * `CfnCampaign.CampaignInAppMessageProperty.Content`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigninappmessage.html#cfn-pinpoint-campaign-campaigninappmessage-content
         */
        readonly content?: Array<CfnCampaign.InAppMessageContentProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnCampaign.CampaignInAppMessageProperty.CustomConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigninappmessage.html#cfn-pinpoint-campaign-campaigninappmessage-customconfig
         */
        readonly customConfig?: any | cdk.IResolvable;
        /**
         * `CfnCampaign.CampaignInAppMessageProperty.Layout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaigninappmessage.html#cfn-pinpoint-campaign-campaigninappmessage-layout
         */
        readonly layout?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html
     */
    interface CampaignSmsMessageProperty {
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.Body`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-body
         */
        readonly body?: string;
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.EntityId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-entityid
         */
        readonly entityId?: string;
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.MessageType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-messagetype
         */
        readonly messageType?: string;
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.OriginationNumber`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-originationnumber
         */
        readonly originationNumber?: string;
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.SenderId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-senderid
         */
        readonly senderId?: string;
        /**
         * `CfnCampaign.CampaignSmsMessageProperty.TemplateId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-campaignsmsmessage.html#cfn-pinpoint-campaign-campaignsmsmessage-templateid
         */
        readonly templateId?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-defaultbuttonconfiguration.html
     */
    interface DefaultButtonConfigurationProperty {
        /**
         * `CfnCampaign.DefaultButtonConfigurationProperty.BackgroundColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-defaultbuttonconfiguration.html#cfn-pinpoint-campaign-defaultbuttonconfiguration-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * `CfnCampaign.DefaultButtonConfigurationProperty.BorderRadius`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-defaultbuttonconfiguration.html#cfn-pinpoint-campaign-defaultbuttonconfiguration-borderradius
         */
        readonly borderRadius?: number;
        /**
         * `CfnCampaign.DefaultButtonConfigurationProperty.ButtonAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-defaultbuttonconfiguration.html#cfn-pinpoint-campaign-defaultbuttonconfiguration-buttonaction
         */
        readonly buttonAction?: string;
        /**
         * `CfnCampaign.DefaultButtonConfigurationProperty.Link`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-defaultbuttonconfiguration.html#cfn-pinpoint-campaign-defaultbuttonconfiguration-link
         */
        readonly link?: string;
        /**
         * `CfnCampaign.DefaultButtonConfigurationProperty.Text`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-defaultbuttonconfiguration.html#cfn-pinpoint-campaign-defaultbuttonconfiguration-text
         */
        readonly text?: string;
        /**
         * `CfnCampaign.DefaultButtonConfigurationProperty.TextColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-defaultbuttonconfiguration.html#cfn-pinpoint-campaign-defaultbuttonconfiguration-textcolor
         */
        readonly textColor?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html
     */
    interface EventDimensionsProperty {
        /**
         * `CfnCampaign.EventDimensionsProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html#cfn-pinpoint-campaign-eventdimensions-attributes
         */
        readonly attributes?: any | cdk.IResolvable;
        /**
         * `CfnCampaign.EventDimensionsProperty.EventType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html#cfn-pinpoint-campaign-eventdimensions-eventtype
         */
        readonly eventType?: CfnCampaign.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.EventDimensionsProperty.Metrics`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-eventdimensions.html#cfn-pinpoint-campaign-eventdimensions-metrics
         */
        readonly metrics?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagebodyconfig.html
     */
    interface InAppMessageBodyConfigProperty {
        /**
         * `CfnCampaign.InAppMessageBodyConfigProperty.Alignment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagebodyconfig.html#cfn-pinpoint-campaign-inappmessagebodyconfig-alignment
         */
        readonly alignment?: string;
        /**
         * `CfnCampaign.InAppMessageBodyConfigProperty.Body`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagebodyconfig.html#cfn-pinpoint-campaign-inappmessagebodyconfig-body
         */
        readonly body?: string;
        /**
         * `CfnCampaign.InAppMessageBodyConfigProperty.TextColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagebodyconfig.html#cfn-pinpoint-campaign-inappmessagebodyconfig-textcolor
         */
        readonly textColor?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagebutton.html
     */
    interface InAppMessageButtonProperty {
        /**
         * `CfnCampaign.InAppMessageButtonProperty.Android`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagebutton.html#cfn-pinpoint-campaign-inappmessagebutton-android
         */
        readonly android?: CfnCampaign.OverrideButtonConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.InAppMessageButtonProperty.DefaultConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagebutton.html#cfn-pinpoint-campaign-inappmessagebutton-defaultconfig
         */
        readonly defaultConfig?: CfnCampaign.DefaultButtonConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.InAppMessageButtonProperty.IOS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagebutton.html#cfn-pinpoint-campaign-inappmessagebutton-ios
         */
        readonly ios?: CfnCampaign.OverrideButtonConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.InAppMessageButtonProperty.Web`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagebutton.html#cfn-pinpoint-campaign-inappmessagebutton-web
         */
        readonly web?: CfnCampaign.OverrideButtonConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagecontent.html
     */
    interface InAppMessageContentProperty {
        /**
         * `CfnCampaign.InAppMessageContentProperty.BackgroundColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagecontent.html#cfn-pinpoint-campaign-inappmessagecontent-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * `CfnCampaign.InAppMessageContentProperty.BodyConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagecontent.html#cfn-pinpoint-campaign-inappmessagecontent-bodyconfig
         */
        readonly bodyConfig?: CfnCampaign.InAppMessageBodyConfigProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.InAppMessageContentProperty.HeaderConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagecontent.html#cfn-pinpoint-campaign-inappmessagecontent-headerconfig
         */
        readonly headerConfig?: CfnCampaign.InAppMessageHeaderConfigProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.InAppMessageContentProperty.ImageUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagecontent.html#cfn-pinpoint-campaign-inappmessagecontent-imageurl
         */
        readonly imageUrl?: string;
        /**
         * `CfnCampaign.InAppMessageContentProperty.PrimaryBtn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagecontent.html#cfn-pinpoint-campaign-inappmessagecontent-primarybtn
         */
        readonly primaryBtn?: CfnCampaign.InAppMessageButtonProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.InAppMessageContentProperty.SecondaryBtn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessagecontent.html#cfn-pinpoint-campaign-inappmessagecontent-secondarybtn
         */
        readonly secondaryBtn?: CfnCampaign.InAppMessageButtonProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessageheaderconfig.html
     */
    interface InAppMessageHeaderConfigProperty {
        /**
         * `CfnCampaign.InAppMessageHeaderConfigProperty.Alignment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessageheaderconfig.html#cfn-pinpoint-campaign-inappmessageheaderconfig-alignment
         */
        readonly alignment?: string;
        /**
         * `CfnCampaign.InAppMessageHeaderConfigProperty.Header`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessageheaderconfig.html#cfn-pinpoint-campaign-inappmessageheaderconfig-header
         */
        readonly header?: string;
        /**
         * `CfnCampaign.InAppMessageHeaderConfigProperty.TextColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-inappmessageheaderconfig.html#cfn-pinpoint-campaign-inappmessageheaderconfig-textcolor
         */
        readonly textColor?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html
     */
    interface LimitsProperty {
        /**
         * `CfnCampaign.LimitsProperty.Daily`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-daily
         */
        readonly daily?: number;
        /**
         * `CfnCampaign.LimitsProperty.MaximumDuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-maximumduration
         */
        readonly maximumDuration?: number;
        /**
         * `CfnCampaign.LimitsProperty.MessagesPerSecond`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-messagespersecond
         */
        readonly messagesPerSecond?: number;
        /**
         * `CfnCampaign.LimitsProperty.Session`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-session
         */
        readonly session?: number;
        /**
         * `CfnCampaign.LimitsProperty.Total`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-limits.html#cfn-pinpoint-campaign-limits-total
         */
        readonly total?: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html
     */
    interface MessageProperty {
        /**
         * `CfnCampaign.MessageProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-action
         */
        readonly action?: string;
        /**
         * `CfnCampaign.MessageProperty.Body`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-body
         */
        readonly body?: string;
        /**
         * `CfnCampaign.MessageProperty.ImageIconUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-imageiconurl
         */
        readonly imageIconUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.ImageSmallIconUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-imagesmalliconurl
         */
        readonly imageSmallIconUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.ImageUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-imageurl
         */
        readonly imageUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.JsonBody`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-jsonbody
         */
        readonly jsonBody?: string;
        /**
         * `CfnCampaign.MessageProperty.MediaUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-mediaurl
         */
        readonly mediaUrl?: string;
        /**
         * `CfnCampaign.MessageProperty.RawContent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-rawcontent
         */
        readonly rawContent?: string;
        /**
         * `CfnCampaign.MessageProperty.SilentPush`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-silentpush
         */
        readonly silentPush?: boolean | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageProperty.TimeToLive`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-timetolive
         */
        readonly timeToLive?: number;
        /**
         * `CfnCampaign.MessageProperty.Title`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-title
         */
        readonly title?: string;
        /**
         * `CfnCampaign.MessageProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-message.html#cfn-pinpoint-campaign-message-url
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html
     */
    interface MessageConfigurationProperty {
        /**
         * `CfnCampaign.MessageConfigurationProperty.ADMMessage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-admmessage
         */
        readonly admMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.APNSMessage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-apnsmessage
         */
        readonly apnsMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.BaiduMessage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-baidumessage
         */
        readonly baiduMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.DefaultMessage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-defaultmessage
         */
        readonly defaultMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.EmailMessage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-emailmessage
         */
        readonly emailMessage?: CfnCampaign.CampaignEmailMessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.GCMMessage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-gcmmessage
         */
        readonly gcmMessage?: CfnCampaign.MessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.InAppMessage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-inappmessage
         */
        readonly inAppMessage?: CfnCampaign.CampaignInAppMessageProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.MessageConfigurationProperty.SMSMessage`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-messageconfiguration.html#cfn-pinpoint-campaign-messageconfiguration-smsmessage
         */
        readonly smsMessage?: CfnCampaign.CampaignSmsMessageProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-metricdimension.html
     */
    interface MetricDimensionProperty {
        /**
         * `CfnCampaign.MetricDimensionProperty.ComparisonOperator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-metricdimension.html#cfn-pinpoint-campaign-metricdimension-comparisonoperator
         */
        readonly comparisonOperator?: string;
        /**
         * `CfnCampaign.MetricDimensionProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-metricdimension.html#cfn-pinpoint-campaign-metricdimension-value
         */
        readonly value?: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-overridebuttonconfiguration.html
     */
    interface OverrideButtonConfigurationProperty {
        /**
         * `CfnCampaign.OverrideButtonConfigurationProperty.ButtonAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-overridebuttonconfiguration.html#cfn-pinpoint-campaign-overridebuttonconfiguration-buttonaction
         */
        readonly buttonAction?: string;
        /**
         * `CfnCampaign.OverrideButtonConfigurationProperty.Link`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-overridebuttonconfiguration.html#cfn-pinpoint-campaign-overridebuttonconfiguration-link
         */
        readonly link?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule-quiettime.html
     */
    interface QuietTimeProperty {
        /**
         * `CfnCampaign.QuietTimeProperty.End`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule-quiettime.html#cfn-pinpoint-campaign-schedule-quiettime-end
         */
        readonly end: string;
        /**
         * `CfnCampaign.QuietTimeProperty.Start`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule-quiettime.html#cfn-pinpoint-campaign-schedule-quiettime-start
         */
        readonly start: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html
     */
    interface ScheduleProperty {
        /**
         * `CfnCampaign.ScheduleProperty.EndTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-endtime
         */
        readonly endTime?: string;
        /**
         * `CfnCampaign.ScheduleProperty.EventFilter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-eventfilter
         */
        readonly eventFilter?: CfnCampaign.CampaignEventFilterProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.ScheduleProperty.Frequency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-frequency
         */
        readonly frequency?: string;
        /**
         * `CfnCampaign.ScheduleProperty.IsLocalTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-islocaltime
         */
        readonly isLocalTime?: boolean | cdk.IResolvable;
        /**
         * `CfnCampaign.ScheduleProperty.QuietTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-quiettime
         */
        readonly quietTime?: CfnCampaign.QuietTimeProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.ScheduleProperty.StartTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-starttime
         */
        readonly startTime?: string;
        /**
         * `CfnCampaign.ScheduleProperty.TimeZone`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-schedule.html#cfn-pinpoint-campaign-schedule-timezone
         */
        readonly timeZone?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-setdimension.html
     */
    interface SetDimensionProperty {
        /**
         * `CfnCampaign.SetDimensionProperty.DimensionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-setdimension.html#cfn-pinpoint-campaign-setdimension-dimensiontype
         */
        readonly dimensionType?: string;
        /**
         * `CfnCampaign.SetDimensionProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-setdimension.html#cfn-pinpoint-campaign-setdimension-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Campaign`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Campaign
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-campaign.html
 */
export declare namespace CfnCampaign {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html
     */
    interface WriteTreatmentResourceProperty {
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.MessageConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-messageconfiguration
         */
        readonly messageConfiguration?: CfnCampaign.MessageConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.Schedule`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-schedule
         */
        readonly schedule?: CfnCampaign.ScheduleProperty | cdk.IResolvable;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.SizePercent`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-sizepercent
         */
        readonly sizePercent?: number;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.TreatmentDescription`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-treatmentdescription
         */
        readonly treatmentDescription?: string;
        /**
         * `CfnCampaign.WriteTreatmentResourceProperty.TreatmentName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-campaign-writetreatmentresource.html#cfn-pinpoint-campaign-writetreatmentresource-treatmentname
         */
        readonly treatmentName?: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::EmailChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html
 */
export interface CfnEmailChannelProps {
    /**
     * `AWS::Pinpoint::EmailChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::EmailChannel.FromAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-fromaddress
     */
    readonly fromAddress: string;
    /**
     * `AWS::Pinpoint::EmailChannel.Identity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-identity
     */
    readonly identity: string;
    /**
     * `AWS::Pinpoint::EmailChannel.ConfigurationSet`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-configurationset
     */
    readonly configurationSet?: string;
    /**
     * `AWS::Pinpoint::EmailChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::EmailChannel.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-rolearn
     */
    readonly roleArn?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::EmailChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::EmailChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html
 */
export declare class CfnEmailChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::EmailChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEmailChannel;
    /**
     * `AWS::Pinpoint::EmailChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::EmailChannel.FromAddress`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-fromaddress
     */
    fromAddress: string;
    /**
     * `AWS::Pinpoint::EmailChannel.Identity`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-identity
     */
    identity: string;
    /**
     * `AWS::Pinpoint::EmailChannel.ConfigurationSet`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-configurationset
     */
    configurationSet: string | undefined;
    /**
     * `AWS::Pinpoint::EmailChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::EmailChannel.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailchannel.html#cfn-pinpoint-emailchannel-rolearn
     */
    roleArn: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::EmailChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEmailChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::EmailTemplate`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html
 */
export interface CfnEmailTemplateProps {
    /**
     * `AWS::Pinpoint::EmailTemplate.Subject`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-subject
     */
    readonly subject: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatename
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.DefaultSubstitutions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-defaultsubstitutions
     */
    readonly defaultSubstitutions?: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.HtmlPart`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-htmlpart
     */
    readonly htmlPart?: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatedescription
     */
    readonly templateDescription?: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.TextPart`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-textpart
     */
    readonly textPart?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::EmailTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::EmailTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html
 */
export declare class CfnEmailTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::EmailTemplate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEmailTemplate;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.Subject`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-subject
     */
    subject: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatename
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::EmailTemplate.DefaultSubstitutions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-defaultsubstitutions
     */
    defaultSubstitutions: string | undefined;
    /**
     * `AWS::Pinpoint::EmailTemplate.HtmlPart`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-htmlpart
     */
    htmlPart: string | undefined;
    /**
     * `AWS::Pinpoint::EmailTemplate.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::EmailTemplate.TemplateDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-templatedescription
     */
    templateDescription: string | undefined;
    /**
     * `AWS::Pinpoint::EmailTemplate.TextPart`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-emailtemplate.html#cfn-pinpoint-emailtemplate-textpart
     */
    textPart: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::EmailTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEmailTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::EventStream`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html
 */
export interface CfnEventStreamProps {
    /**
     * `AWS::Pinpoint::EventStream.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::EventStream.DestinationStreamArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-destinationstreamarn
     */
    readonly destinationStreamArn: string;
    /**
     * `AWS::Pinpoint::EventStream.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-rolearn
     */
    readonly roleArn: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::EventStream`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::EventStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html
 */
export declare class CfnEventStream extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::EventStream";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventStream;
    /**
     * `AWS::Pinpoint::EventStream.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::EventStream.DestinationStreamArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-destinationstreamarn
     */
    destinationStreamArn: string;
    /**
     * `AWS::Pinpoint::EventStream.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-eventstream.html#cfn-pinpoint-eventstream-rolearn
     */
    roleArn: string;
    /**
     * Create a new `AWS::Pinpoint::EventStream`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventStreamProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::GCMChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html
 */
export interface CfnGCMChannelProps {
    /**
     * `AWS::Pinpoint::GCMChannel.ApiKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-apikey
     */
    readonly apiKey: string;
    /**
     * `AWS::Pinpoint::GCMChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::GCMChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::GCMChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::GCMChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html
 */
export declare class CfnGCMChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::GCMChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGCMChannel;
    /**
     * `AWS::Pinpoint::GCMChannel.ApiKey`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-apikey
     */
    apiKey: string;
    /**
     * `AWS::Pinpoint::GCMChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::GCMChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-gcmchannel.html#cfn-pinpoint-gcmchannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::GCMChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnGCMChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::InAppTemplate`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html
 */
export interface CfnInAppTemplateProps {
    /**
     * `AWS::Pinpoint::InAppTemplate.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-templatename
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::InAppTemplate.Content`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-content
     */
    readonly content?: Array<CfnInAppTemplate.InAppMessageContentProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::InAppTemplate.CustomConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-customconfig
     */
    readonly customConfig?: any | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::InAppTemplate.Layout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-layout
     */
    readonly layout?: string;
    /**
     * `AWS::Pinpoint::InAppTemplate.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::InAppTemplate.TemplateDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-templatedescription
     */
    readonly templateDescription?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::InAppTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::InAppTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html
 */
export declare class CfnInAppTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::InAppTemplate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInAppTemplate;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::InAppTemplate.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-templatename
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::InAppTemplate.Content`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-content
     */
    content: Array<CfnInAppTemplate.InAppMessageContentProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::InAppTemplate.CustomConfig`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-customconfig
     */
    customConfig: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::InAppTemplate.Layout`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-layout
     */
    layout: string | undefined;
    /**
     * `AWS::Pinpoint::InAppTemplate.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::InAppTemplate.TemplateDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html#cfn-pinpoint-inapptemplate-templatedescription
     */
    templateDescription: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::InAppTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInAppTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Pinpoint::InAppTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::InAppTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html
 */
export declare namespace CfnInAppTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-bodyconfig.html
     */
    interface BodyConfigProperty {
        /**
         * `CfnInAppTemplate.BodyConfigProperty.Alignment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-bodyconfig.html#cfn-pinpoint-inapptemplate-bodyconfig-alignment
         */
        readonly alignment?: string;
        /**
         * `CfnInAppTemplate.BodyConfigProperty.Body`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-bodyconfig.html#cfn-pinpoint-inapptemplate-bodyconfig-body
         */
        readonly body?: string;
        /**
         * `CfnInAppTemplate.BodyConfigProperty.TextColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-bodyconfig.html#cfn-pinpoint-inapptemplate-bodyconfig-textcolor
         */
        readonly textColor?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::InAppTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::InAppTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html
 */
export declare namespace CfnInAppTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-buttonconfig.html
     */
    interface ButtonConfigProperty {
        /**
         * `CfnInAppTemplate.ButtonConfigProperty.Android`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-buttonconfig.html#cfn-pinpoint-inapptemplate-buttonconfig-android
         */
        readonly android?: CfnInAppTemplate.OverrideButtonConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnInAppTemplate.ButtonConfigProperty.DefaultConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-buttonconfig.html#cfn-pinpoint-inapptemplate-buttonconfig-defaultconfig
         */
        readonly defaultConfig?: CfnInAppTemplate.DefaultButtonConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnInAppTemplate.ButtonConfigProperty.IOS`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-buttonconfig.html#cfn-pinpoint-inapptemplate-buttonconfig-ios
         */
        readonly ios?: CfnInAppTemplate.OverrideButtonConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnInAppTemplate.ButtonConfigProperty.Web`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-buttonconfig.html#cfn-pinpoint-inapptemplate-buttonconfig-web
         */
        readonly web?: CfnInAppTemplate.OverrideButtonConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::InAppTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::InAppTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html
 */
export declare namespace CfnInAppTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-defaultbuttonconfiguration.html
     */
    interface DefaultButtonConfigurationProperty {
        /**
         * `CfnInAppTemplate.DefaultButtonConfigurationProperty.BackgroundColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-defaultbuttonconfiguration.html#cfn-pinpoint-inapptemplate-defaultbuttonconfiguration-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * `CfnInAppTemplate.DefaultButtonConfigurationProperty.BorderRadius`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-defaultbuttonconfiguration.html#cfn-pinpoint-inapptemplate-defaultbuttonconfiguration-borderradius
         */
        readonly borderRadius?: number;
        /**
         * `CfnInAppTemplate.DefaultButtonConfigurationProperty.ButtonAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-defaultbuttonconfiguration.html#cfn-pinpoint-inapptemplate-defaultbuttonconfiguration-buttonaction
         */
        readonly buttonAction?: string;
        /**
         * `CfnInAppTemplate.DefaultButtonConfigurationProperty.Link`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-defaultbuttonconfiguration.html#cfn-pinpoint-inapptemplate-defaultbuttonconfiguration-link
         */
        readonly link?: string;
        /**
         * `CfnInAppTemplate.DefaultButtonConfigurationProperty.Text`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-defaultbuttonconfiguration.html#cfn-pinpoint-inapptemplate-defaultbuttonconfiguration-text
         */
        readonly text?: string;
        /**
         * `CfnInAppTemplate.DefaultButtonConfigurationProperty.TextColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-defaultbuttonconfiguration.html#cfn-pinpoint-inapptemplate-defaultbuttonconfiguration-textcolor
         */
        readonly textColor?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::InAppTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::InAppTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html
 */
export declare namespace CfnInAppTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-headerconfig.html
     */
    interface HeaderConfigProperty {
        /**
         * `CfnInAppTemplate.HeaderConfigProperty.Alignment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-headerconfig.html#cfn-pinpoint-inapptemplate-headerconfig-alignment
         */
        readonly alignment?: string;
        /**
         * `CfnInAppTemplate.HeaderConfigProperty.Header`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-headerconfig.html#cfn-pinpoint-inapptemplate-headerconfig-header
         */
        readonly header?: string;
        /**
         * `CfnInAppTemplate.HeaderConfigProperty.TextColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-headerconfig.html#cfn-pinpoint-inapptemplate-headerconfig-textcolor
         */
        readonly textColor?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::InAppTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::InAppTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html
 */
export declare namespace CfnInAppTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-inappmessagecontent.html
     */
    interface InAppMessageContentProperty {
        /**
         * `CfnInAppTemplate.InAppMessageContentProperty.BackgroundColor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-inappmessagecontent.html#cfn-pinpoint-inapptemplate-inappmessagecontent-backgroundcolor
         */
        readonly backgroundColor?: string;
        /**
         * `CfnInAppTemplate.InAppMessageContentProperty.BodyConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-inappmessagecontent.html#cfn-pinpoint-inapptemplate-inappmessagecontent-bodyconfig
         */
        readonly bodyConfig?: CfnInAppTemplate.BodyConfigProperty | cdk.IResolvable;
        /**
         * `CfnInAppTemplate.InAppMessageContentProperty.HeaderConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-inappmessagecontent.html#cfn-pinpoint-inapptemplate-inappmessagecontent-headerconfig
         */
        readonly headerConfig?: CfnInAppTemplate.HeaderConfigProperty | cdk.IResolvable;
        /**
         * `CfnInAppTemplate.InAppMessageContentProperty.ImageUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-inappmessagecontent.html#cfn-pinpoint-inapptemplate-inappmessagecontent-imageurl
         */
        readonly imageUrl?: string;
        /**
         * `CfnInAppTemplate.InAppMessageContentProperty.PrimaryBtn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-inappmessagecontent.html#cfn-pinpoint-inapptemplate-inappmessagecontent-primarybtn
         */
        readonly primaryBtn?: CfnInAppTemplate.ButtonConfigProperty | cdk.IResolvable;
        /**
         * `CfnInAppTemplate.InAppMessageContentProperty.SecondaryBtn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-inappmessagecontent.html#cfn-pinpoint-inapptemplate-inappmessagecontent-secondarybtn
         */
        readonly secondaryBtn?: CfnInAppTemplate.ButtonConfigProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::InAppTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::InAppTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-inapptemplate.html
 */
export declare namespace CfnInAppTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-overridebuttonconfiguration.html
     */
    interface OverrideButtonConfigurationProperty {
        /**
         * `CfnInAppTemplate.OverrideButtonConfigurationProperty.ButtonAction`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-overridebuttonconfiguration.html#cfn-pinpoint-inapptemplate-overridebuttonconfiguration-buttonaction
         */
        readonly buttonAction?: string;
        /**
         * `CfnInAppTemplate.OverrideButtonConfigurationProperty.Link`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-inapptemplate-overridebuttonconfiguration.html#cfn-pinpoint-inapptemplate-overridebuttonconfiguration-link
         */
        readonly link?: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::PushTemplate`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 */
export interface CfnPushTemplateProps {
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatename
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::PushTemplate.ADM`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm
     */
    readonly adm?: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.APNS`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns
     */
    readonly apns?: CfnPushTemplate.APNSPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.Baidu`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu
     */
    readonly baidu?: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.Default`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default
     */
    readonly default?: CfnPushTemplate.DefaultPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.DefaultSubstitutions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-defaultsubstitutions
     */
    readonly defaultSubstitutions?: string;
    /**
     * `AWS::Pinpoint::PushTemplate.GCM`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm
     */
    readonly gcm?: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::PushTemplate.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatedescription
     */
    readonly templateDescription?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::PushTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::PushTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 */
export declare class CfnPushTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::PushTemplate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPushTemplate;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatename
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::PushTemplate.ADM`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-adm
     */
    adm: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.APNS`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-apns
     */
    apns: CfnPushTemplate.APNSPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.Baidu`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-baidu
     */
    baidu: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.Default`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-default
     */
    default: CfnPushTemplate.DefaultPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.DefaultSubstitutions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-defaultsubstitutions
     */
    defaultSubstitutions: string | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.GCM`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-gcm
     */
    gcm: CfnPushTemplate.AndroidPushNotificationTemplateProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::PushTemplate.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::PushTemplate.TemplateDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html#cfn-pinpoint-pushtemplate-templatedescription
     */
    templateDescription: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::PushTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPushTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Pinpoint::PushTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::PushTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 */
export declare namespace CfnPushTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html
     */
    interface APNSPushNotificationTemplateProperty {
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-action
         */
        readonly action?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Body`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-body
         */
        readonly body?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.MediaUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-mediaurl
         */
        readonly mediaUrl?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Sound`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-sound
         */
        readonly sound?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Title`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-title
         */
        readonly title?: string;
        /**
         * `CfnPushTemplate.APNSPushNotificationTemplateProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-apnspushnotificationtemplate.html#cfn-pinpoint-pushtemplate-apnspushnotificationtemplate-url
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::PushTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::PushTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 */
export declare namespace CfnPushTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html
     */
    interface AndroidPushNotificationTemplateProperty {
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-action
         */
        readonly action?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Body`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-body
         */
        readonly body?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.ImageIconUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageiconurl
         */
        readonly imageIconUrl?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.ImageUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-imageurl
         */
        readonly imageUrl?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.SmallImageIconUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-smallimageiconurl
         */
        readonly smallImageIconUrl?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Sound`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-sound
         */
        readonly sound?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Title`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-title
         */
        readonly title?: string;
        /**
         * `CfnPushTemplate.AndroidPushNotificationTemplateProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-androidpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-androidpushnotificationtemplate-url
         */
        readonly url?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::PushTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::PushTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-pushtemplate.html
 */
export declare namespace CfnPushTemplate {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html
     */
    interface DefaultPushNotificationTemplateProperty {
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Action`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-action
         */
        readonly action?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Body`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-body
         */
        readonly body?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Sound`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-sound
         */
        readonly sound?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Title`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-title
         */
        readonly title?: string;
        /**
         * `CfnPushTemplate.DefaultPushNotificationTemplateProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-pushtemplate-defaultpushnotificationtemplate.html#cfn-pinpoint-pushtemplate-defaultpushnotificationtemplate-url
         */
        readonly url?: string;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::SMSChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html
 */
export interface CfnSMSChannelProps {
    /**
     * `AWS::Pinpoint::SMSChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::SMSChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::SMSChannel.SenderId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-senderid
     */
    readonly senderId?: string;
    /**
     * `AWS::Pinpoint::SMSChannel.ShortCode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-shortcode
     */
    readonly shortCode?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::SMSChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::SMSChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html
 */
export declare class CfnSMSChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::SMSChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSMSChannel;
    /**
     * `AWS::Pinpoint::SMSChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::SMSChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::SMSChannel.SenderId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-senderid
     */
    senderId: string | undefined;
    /**
     * `AWS::Pinpoint::SMSChannel.ShortCode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smschannel.html#cfn-pinpoint-smschannel-shortcode
     */
    shortCode: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::SMSChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSMSChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::Segment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export interface CfnSegmentProps {
    /**
     * `AWS::Pinpoint::Segment.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::Segment.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-name
     */
    readonly name: string;
    /**
     * `AWS::Pinpoint::Segment.Dimensions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-dimensions
     */
    readonly dimensions?: CfnSegment.SegmentDimensionsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Segment.SegmentGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-segmentgroups
     */
    readonly segmentGroups?: CfnSegment.SegmentGroupsProperty | cdk.IResolvable;
    /**
     * `AWS::Pinpoint::Segment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-tags
     */
    readonly tags?: any;
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare class CfnSegment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::Segment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSegment;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute SegmentId
     */
    readonly attrSegmentId: string;
    /**
     * `AWS::Pinpoint::Segment.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::Segment.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-name
     */
    name: string;
    /**
     * `AWS::Pinpoint::Segment.Dimensions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-dimensions
     */
    dimensions: CfnSegment.SegmentDimensionsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Segment.SegmentGroups`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-segmentgroups
     */
    segmentGroups: CfnSegment.SegmentGroupsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Pinpoint::Segment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html#cfn-pinpoint-segment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Pinpoint::Segment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSegmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-attributedimension.html
     */
    interface AttributeDimensionProperty {
        /**
         * `CfnSegment.AttributeDimensionProperty.AttributeType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-attributedimension.html#cfn-pinpoint-segment-attributedimension-attributetype
         */
        readonly attributeType?: string;
        /**
         * `CfnSegment.AttributeDimensionProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-attributedimension.html#cfn-pinpoint-segment-attributedimension-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior.html
     */
    interface BehaviorProperty {
        /**
         * `CfnSegment.BehaviorProperty.Recency`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior.html#cfn-pinpoint-segment-segmentdimensions-behavior-recency
         */
        readonly recency?: CfnSegment.RecencyProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates.html
     */
    interface CoordinatesProperty {
        /**
         * `CfnSegment.CoordinatesProperty.Latitude`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates-latitude
         */
        readonly latitude: number;
        /**
         * `CfnSegment.CoordinatesProperty.Longitude`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates-longitude
         */
        readonly longitude: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html
     */
    interface DemographicProperty {
        /**
         * `CfnSegment.DemographicProperty.AppVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-appversion
         */
        readonly appVersion?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Channel`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-channel
         */
        readonly channel?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.DeviceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-devicetype
         */
        readonly deviceType?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Make`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-make
         */
        readonly make?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Model`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-model
         */
        readonly model?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.DemographicProperty.Platform`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-demographic.html#cfn-pinpoint-segment-segmentdimensions-demographic-platform
         */
        readonly platform?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint.html
     */
    interface GPSPointProperty {
        /**
         * `CfnSegment.GPSPointProperty.Coordinates`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-coordinates
         */
        readonly coordinates: CfnSegment.CoordinatesProperty | cdk.IResolvable;
        /**
         * `CfnSegment.GPSPointProperty.RangeInKilometers`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location-gpspoint.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint-rangeinkilometers
         */
        readonly rangeInKilometers: number;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html
     */
    interface GroupsProperty {
        /**
         * `CfnSegment.GroupsProperty.Dimensions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-dimensions
         */
        readonly dimensions?: Array<CfnSegment.SegmentDimensionsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSegment.GroupsProperty.SourceSegments`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-sourcesegments
         */
        readonly sourceSegments?: Array<CfnSegment.SourceSegmentsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSegment.GroupsProperty.SourceType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-sourcetype
         */
        readonly sourceType?: string;
        /**
         * `CfnSegment.GroupsProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups.html#cfn-pinpoint-segment-segmentgroups-groups-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location.html
     */
    interface LocationProperty {
        /**
         * `CfnSegment.LocationProperty.Country`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location.html#cfn-pinpoint-segment-segmentdimensions-location-country
         */
        readonly country?: CfnSegment.SetDimensionProperty | cdk.IResolvable;
        /**
         * `CfnSegment.LocationProperty.GPSPoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-location.html#cfn-pinpoint-segment-segmentdimensions-location-gpspoint
         */
        readonly gpsPoint?: CfnSegment.GPSPointProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior-recency.html
     */
    interface RecencyProperty {
        /**
         * `CfnSegment.RecencyProperty.Duration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior-recency.html#cfn-pinpoint-segment-segmentdimensions-behavior-recency-duration
         */
        readonly duration: string;
        /**
         * `CfnSegment.RecencyProperty.RecencyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions-behavior-recency.html#cfn-pinpoint-segment-segmentdimensions-behavior-recency-recencytype
         */
        readonly recencyType: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html
     */
    interface SegmentDimensionsProperty {
        /**
         * `CfnSegment.SegmentDimensionsProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-attributes
         */
        readonly attributes?: any | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Behavior`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-behavior
         */
        readonly behavior?: CfnSegment.BehaviorProperty | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Demographic`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-demographic
         */
        readonly demographic?: CfnSegment.DemographicProperty | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Location`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-location
         */
        readonly location?: CfnSegment.LocationProperty | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.Metrics`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-metrics
         */
        readonly metrics?: any | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentDimensionsProperty.UserAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentdimensions.html#cfn-pinpoint-segment-segmentdimensions-userattributes
         */
        readonly userAttributes?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups.html
     */
    interface SegmentGroupsProperty {
        /**
         * `CfnSegment.SegmentGroupsProperty.Groups`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups.html#cfn-pinpoint-segment-segmentgroups-groups
         */
        readonly groups?: Array<CfnSegment.GroupsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnSegment.SegmentGroupsProperty.Include`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups.html#cfn-pinpoint-segment-segmentgroups-include
         */
        readonly include?: string;
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-setdimension.html
     */
    interface SetDimensionProperty {
        /**
         * `CfnSegment.SetDimensionProperty.DimensionType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-setdimension.html#cfn-pinpoint-segment-setdimension-dimensiontype
         */
        readonly dimensionType?: string;
        /**
         * `CfnSegment.SetDimensionProperty.Values`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-setdimension.html#cfn-pinpoint-segment-setdimension-values
         */
        readonly values?: string[];
    }
}
/**
 * A CloudFormation `AWS::Pinpoint::Segment`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::Segment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-segment.html
 */
export declare namespace CfnSegment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups-sourcesegments.html
     */
    interface SourceSegmentsProperty {
        /**
         * `CfnSegment.SourceSegmentsProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups-sourcesegments.html#cfn-pinpoint-segment-segmentgroups-groups-sourcesegments-id
         */
        readonly id: string;
        /**
         * `CfnSegment.SourceSegmentsProperty.Version`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-pinpoint-segment-segmentgroups-groups-sourcesegments.html#cfn-pinpoint-segment-segmentgroups-groups-sourcesegments-version
         */
        readonly version?: number;
    }
}
/**
 * Properties for defining a `AWS::Pinpoint::SmsTemplate`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html
 */
export interface CfnSmsTemplateProps {
    /**
     * `AWS::Pinpoint::SmsTemplate.Body`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-body
     */
    readonly body: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatename
     */
    readonly templateName: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.DefaultSubstitutions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-defaultsubstitutions
     */
    readonly defaultSubstitutions?: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-tags
     */
    readonly tags?: any;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatedescription
     */
    readonly templateDescription?: string;
}
/**
 * A CloudFormation `AWS::Pinpoint::SmsTemplate`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::SmsTemplate
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html
 */
export declare class CfnSmsTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::SmsTemplate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSmsTemplate;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.Body`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-body
     */
    body: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatename
     */
    templateName: string;
    /**
     * `AWS::Pinpoint::SmsTemplate.DefaultSubstitutions`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-defaultsubstitutions
     */
    defaultSubstitutions: string | undefined;
    /**
     * `AWS::Pinpoint::SmsTemplate.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Pinpoint::SmsTemplate.TemplateDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-smstemplate.html#cfn-pinpoint-smstemplate-templatedescription
     */
    templateDescription: string | undefined;
    /**
     * Create a new `AWS::Pinpoint::SmsTemplate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSmsTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Pinpoint::VoiceChannel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html
 */
export interface CfnVoiceChannelProps {
    /**
     * `AWS::Pinpoint::VoiceChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-applicationid
     */
    readonly applicationId: string;
    /**
     * `AWS::Pinpoint::VoiceChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Pinpoint::VoiceChannel`.
 *
 * @external
 * @cloudformationResource AWS::Pinpoint::VoiceChannel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html
 */
export declare class CfnVoiceChannel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Pinpoint::VoiceChannel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVoiceChannel;
    /**
     * `AWS::Pinpoint::VoiceChannel.ApplicationId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-applicationid
     */
    applicationId: string;
    /**
     * `AWS::Pinpoint::VoiceChannel.Enabled`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-pinpoint-voicechannel.html#cfn-pinpoint-voicechannel-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Pinpoint::VoiceChannel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVoiceChannelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
