import { IPolicyValidationPluginBeta1, IPolicyValidationContextBeta1, PolicyValidationPluginReportBeta1 } from 'aws-cdk-lib';
export interface CfnGuardValidatorProps {
    /**
     * Enable the default Control Tower Guard rules
     *
     * @default true
     */
    readonly controlTowerRulesEnabled?: boolean;
    /**
     * List of rule names to disable
     *
     * @default - no rules are disabled
     */
    readonly disabledRules?: string[];
    /**
     * Local file paths to either a directory containing
     * guard rules, or to an individual guard rule file
     *
     * If the path is to a directory then the directory must
     * only contain guard rule and the plugin will use
     * all the rules in the directory
     *
     * @default - no local rules will be used
     */
    readonly rules?: string[];
}
/**
 * A validation plugin using CFN Guard
 */
export declare class CfnGuardValidator implements IPolicyValidationPluginBeta1 {
    readonly name: string;
    private readonly rulesPaths;
    private readonly guard;
    private readonly disabledRules;
    private readonly executionConfig;
    constructor(props?: CfnGuardValidatorProps);
    /**
     * This is (hopefully) a temporary solution to https://github.com/aws-cloudformation/cloudformation-guard/issues/180
     * Rather than try and parse the output and split out the JSON entries we'll just
     * invoke guard separately for each rule.
     */
    private generateGuardExecutionConfig;
    validate(context: IPolicyValidationContextBeta1): PolicyValidationPluginReportBeta1;
    private execGuard;
}
