/**
 * plotly.js v2.12.1
 * Copyright 2012-2022, Plotly, Inc.
 * All rights reserved.
 * Licensed under the MIT license
 */
(function (f) {
    if (typeof exports === "object" && typeof module !== "undefined") {
        module.exports = f()
    } else if (typeof define === "function" && define.amd) {
        define([], f)
    } else {
        var g;
        if (typeof window !== "undefined") {
            g = window
        } else if (typeof global !== "undefined") {
            g = global
        } else if (typeof self !== "undefined") {
            g = self
        } else {
            g = this
        }
        g.Plotly = f()
    }
})(function () {
    var define, module, exports;
    return (function () {
        function r(e, n, t) {
            function o(i, f) {
                if (!n[i]) {
                    if (!e[i]) {
                        var c = "function" == typeof require && require;
                        if (!f && c) return c(i, !0);
                        if (u) return u(i, !0);
                        var a = new Error("Cannot find module '" + i + "'");
                        throw a.code = "MODULE_NOT_FOUND", a
                    }
                    var p = n[i] = {exports: {}};
                    e[i][0].call(p.exports, function (r) {
                        var n = e[i][1][r];
                        return o(n || r)
                    }, p, p.exports, r, e, n, t)
                }
                return n[i].exports
            }

            for (var u = "function" == typeof require && require, i = 0; i < t.length; i++) o(t[i]);
            return o
        }

        return r
    })()({
        1: [function (_dereq_, module, exports) {
            'use strict';

            var Lib = _dereq_('../src/lib');
            var rules = {
                "X,X div": "direction:ltr;font-family:\"Open Sans\",verdana,arial,sans-serif;margin:0;padding:0;",
                "X input,X button": "font-family:\"Open Sans\",verdana,arial,sans-serif;",
                "X input:focus,X button:focus": "outline:none;",
                "X a": "text-decoration:none;",
                "X a:hover": "text-decoration:none;",
                "X .crisp": "shape-rendering:crispEdges;",
                "X .user-select-none": "-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;-o-user-select:none;user-select:none;",
                "X svg": "overflow:hidden;",
                "X svg a": "fill:#447adb;",
                "X svg a:hover": "fill:#3c6dc5;",
                "X .main-svg": "position:absolute;top:0;left:0;pointer-events:none;",
                "X .main-svg .draglayer": "pointer-events:all;",
                "X .cursor-default": "cursor:default;",
                "X .cursor-pointer": "cursor:pointer;",
                "X .cursor-crosshair": "cursor:crosshair;",
                "X .cursor-move": "cursor:move;",
                "X .cursor-col-resize": "cursor:col-resize;",
                "X .cursor-row-resize": "cursor:row-resize;",
                "X .cursor-ns-resize": "cursor:ns-resize;",
                "X .cursor-ew-resize": "cursor:ew-resize;",
                "X .cursor-sw-resize": "cursor:sw-resize;",
                "X .cursor-s-resize": "cursor:s-resize;",
                "X .cursor-se-resize": "cursor:se-resize;",
                "X .cursor-w-resize": "cursor:w-resize;",
                "X .cursor-e-resize": "cursor:e-resize;",
                "X .cursor-nw-resize": "cursor:nw-resize;",
                "X .cursor-n-resize": "cursor:n-resize;",
                "X .cursor-ne-resize": "cursor:ne-resize;",
                "X .cursor-grab": "cursor:-webkit-grab;cursor:grab;",
                "X .modebar": "position:absolute;top:2px;right:2px;",
                "X .ease-bg": "-webkit-transition:background-color .3s ease 0s;-moz-transition:background-color .3s ease 0s;-ms-transition:background-color .3s ease 0s;-o-transition:background-color .3s ease 0s;transition:background-color .3s ease 0s;",
                "X .modebar--hover>:not(.watermark)": "opacity:0;-webkit-transition:opacity .3s ease 0s;-moz-transition:opacity .3s ease 0s;-ms-transition:opacity .3s ease 0s;-o-transition:opacity .3s ease 0s;transition:opacity .3s ease 0s;",
                "X:hover .modebar--hover .modebar-group": "opacity:1;",
                "X .modebar-group": "float:left;display:inline-block;box-sizing:border-box;padding-left:8px;position:relative;vertical-align:middle;white-space:nowrap;",
                "X .modebar-btn": "position:relative;font-size:16px;padding:3px 4px;height:22px;cursor:pointer;line-height:normal;box-sizing:border-box;",
                "X .modebar-btn svg": "position:relative;top:2px;",
                "X .modebar.vertical": "display:flex;flex-direction:column;flex-wrap:wrap;align-content:flex-end;max-height:100%;",
                "X .modebar.vertical svg": "top:-1px;",
                "X .modebar.vertical .modebar-group": "display:block;float:none;padding-left:0px;padding-bottom:8px;",
                "X .modebar.vertical .modebar-group .modebar-btn": "display:block;text-align:center;",
                "X [data-title]:before,X [data-title]:after": "position:absolute;-webkit-transform:translate3d(0, 0, 0);-moz-transform:translate3d(0, 0, 0);-ms-transform:translate3d(0, 0, 0);-o-transform:translate3d(0, 0, 0);transform:translate3d(0, 0, 0);display:none;opacity:0;z-index:1001;pointer-events:none;top:110%;right:50%;",
                "X [data-title]:hover:before,X [data-title]:hover:after": "display:block;opacity:1;",
                "X [data-title]:before": "content:\"\";position:absolute;background:rgba(0,0,0,0);border:6px solid rgba(0,0,0,0);z-index:1002;margin-top:-12px;border-bottom-color:#69738a;margin-right:-6px;",
                "X [data-title]:after": "content:attr(data-title);background:#69738a;color:#fff;padding:8px 10px;font-size:12px;line-height:12px;white-space:nowrap;margin-right:-18px;border-radius:2px;",
                "X .vertical [data-title]:before,X .vertical [data-title]:after": "top:0%;right:200%;",
                "X .vertical [data-title]:before": "border:6px solid rgba(0,0,0,0);border-left-color:#69738a;margin-top:8px;margin-right:-30px;",
                "X .select-outline": "fill:none;stroke-width:1;shape-rendering:crispEdges;",
                "X .select-outline-1": "stroke:#fff;",
                "X .select-outline-2": "stroke:#000;stroke-dasharray:2px 2px;",
                Y: "font-family:\"Open Sans\",verdana,arial,sans-serif;position:fixed;top:50px;right:20px;z-index:10000;font-size:10pt;max-width:180px;",
                "Y p": "margin:0;",
                "Y .notifier-note": "min-width:180px;max-width:250px;border:1px solid #fff;z-index:3000;margin:0;background-color:#8c97af;background-color:rgba(140,151,175,.9);color:#fff;padding:10px;overflow-wrap:break-word;word-wrap:break-word;-ms-hyphens:auto;-webkit-hyphens:auto;hyphens:auto;",
                "Y .notifier-close": "color:#fff;opacity:.8;float:right;padding:0 5px;background:none;border:none;font-size:20px;font-weight:bold;line-height:20px;",
                "Y .notifier-close:hover": "color:#444;text-decoration:none;cursor:pointer;"
            };

            for (var selector in rules) {
                var fullSelector = selector.replace(/^,/, ' ,')
                    .replace(/X/g, '.js-plotly-plot .plotly')
                    .replace(/Y/g, '.plotly-notifier');
                Lib.addStyleRule(fullSelector, rules[selector]);
            }

        }, {"../src/lib": 503}],
        2: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/transforms/aggregate');

        }, {"../src/transforms/aggregate": 1118}],
        3: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/bar');

        }, {"../src/traces/bar": 656}],
        4: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/barpolar');

        }, {"../src/traces/barpolar": 669}],
        5: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/box');

        }, {"../src/traces/box": 679}],
        6: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/components/calendars');

        }, {"../src/components/calendars": 364}],
        7: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/candlestick');

        }, {"../src/traces/candlestick": 688}],
        8: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/carpet');

        }, {"../src/traces/carpet": 707}],
        9: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/choropleth');

        }, {"../src/traces/choropleth": 721}],
        10: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/choroplethmapbox');

        }, {"../src/traces/choroplethmapbox": 728}],
        11: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/cone');

        }, {"../src/traces/cone": 734}],
        12: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/contour');

        }, {"../src/traces/contour": 749}],
        13: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/contourcarpet');

        }, {"../src/traces/contourcarpet": 760}],
        14: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/core');

        }, {"../src/core": 481}],
        15: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/densitymapbox');

        }, {"../src/traces/densitymapbox": 768}],
        16: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/transforms/filter');

        }, {"../src/transforms/filter": 1119}],
        17: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/funnel');

        }, {"../src/traces/funnel": 778}],
        18: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/funnelarea');

        }, {"../src/traces/funnelarea": 787}],
        19: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/transforms/groupby');

        }, {"../src/transforms/groupby": 1120}],
        20: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/heatmap');

        }, {"../src/traces/heatmap": 800}],
        21: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/heatmapgl');

        }, {"../src/traces/heatmapgl": 811}],
        22: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/histogram');

        }, {"../src/traces/histogram": 823}],
        23: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/histogram2d');

        }, {"../src/traces/histogram2d": 829}],
        24: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/histogram2dcontour');

        }, {"../src/traces/histogram2dcontour": 833}],
        25: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/icicle');

        }, {"../src/traces/icicle": 839}],
        26: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/image');

        }, {"../src/traces/image": 852}],
        27: [function (_dereq_, module, exports) {
            'use strict';

            var Plotly = _dereq_('./core');

            Plotly.register([
                // traces
                _dereq_('./bar'),
                _dereq_('./box'),
                _dereq_('./heatmap'),
                _dereq_('./histogram'),
                _dereq_('./histogram2d'),
                _dereq_('./histogram2dcontour'),
                _dereq_('./contour'),
                _dereq_('./scatterternary'),
                _dereq_('./violin'),
                _dereq_('./funnel'),
                _dereq_('./waterfall'),
                _dereq_('./image'),
                _dereq_('./pie'),
                _dereq_('./sunburst'),
                _dereq_('./treemap'),
                _dereq_('./icicle'),
                _dereq_('./funnelarea'),
                _dereq_('./scatter3d'),
                _dereq_('./surface'),
                _dereq_('./isosurface'),
                _dereq_('./volume'),
                _dereq_('./mesh3d'),
                _dereq_('./cone'),
                _dereq_('./streamtube'),
                _dereq_('./scattergeo'),
                _dereq_('./choropleth'),
                _dereq_('./scattergl'),
                _dereq_('./splom'),
                _dereq_('./pointcloud'),
                _dereq_('./heatmapgl'),
                _dereq_('./parcoords'),
                _dereq_('./parcats'),
                _dereq_('./scattermapbox'),
                _dereq_('./choroplethmapbox'),
                _dereq_('./densitymapbox'),
                _dereq_('./sankey'),
                _dereq_('./indicator'),
                _dereq_('./table'),
                _dereq_('./carpet'),
                _dereq_('./scattercarpet'),
                _dereq_('./contourcarpet'),
                _dereq_('./ohlc'),
                _dereq_('./candlestick'),
                _dereq_('./scatterpolar'),
                _dereq_('./scatterpolargl'),
                _dereq_('./barpolar'),
                _dereq_('./scattersmith'),

                // transforms
                _dereq_('./aggregate'),
                _dereq_('./filter'),
                _dereq_('./groupby'),
                _dereq_('./sort'),

                // components
                _dereq_('./calendars'),
            ]);

            module.exports = Plotly;

        }, {
            "./aggregate": 2,
            "./bar": 3,
            "./barpolar": 4,
            "./box": 5,
            "./calendars": 6,
            "./candlestick": 7,
            "./carpet": 8,
            "./choropleth": 9,
            "./choroplethmapbox": 10,
            "./cone": 11,
            "./contour": 12,
            "./contourcarpet": 13,
            "./core": 14,
            "./densitymapbox": 15,
            "./filter": 16,
            "./funnel": 17,
            "./funnelarea": 18,
            "./groupby": 19,
            "./heatmap": 20,
            "./heatmapgl": 21,
            "./histogram": 22,
            "./histogram2d": 23,
            "./histogram2dcontour": 24,
            "./icicle": 25,
            "./image": 26,
            "./indicator": 28,
            "./isosurface": 29,
            "./mesh3d": 30,
            "./ohlc": 31,
            "./parcats": 32,
            "./parcoords": 33,
            "./pie": 34,
            "./pointcloud": 35,
            "./sankey": 36,
            "./scatter3d": 37,
            "./scattercarpet": 38,
            "./scattergeo": 39,
            "./scattergl": 40,
            "./scattermapbox": 41,
            "./scatterpolar": 42,
            "./scatterpolargl": 43,
            "./scattersmith": 44,
            "./scatterternary": 45,
            "./sort": 46,
            "./splom": 47,
            "./streamtube": 48,
            "./sunburst": 49,
            "./surface": 50,
            "./table": 51,
            "./treemap": 52,
            "./violin": 53,
            "./volume": 54,
            "./waterfall": 55
        }],
        28: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/indicator');

        }, {"../src/traces/indicator": 860}],
        29: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/isosurface');

        }, {"../src/traces/isosurface": 866}],
        30: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/mesh3d');

        }, {"../src/traces/mesh3d": 871}],
        31: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/ohlc');

        }, {"../src/traces/ohlc": 876}],
        32: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/parcats');

        }, {"../src/traces/parcats": 885}],
        33: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/parcoords');

        }, {"../src/traces/parcoords": 896}],
        34: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/pie');

        }, {"../src/traces/pie": 907}],
        35: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/pointcloud');

        }, {"../src/traces/pointcloud": 916}],
        36: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/sankey');

        }, {"../src/traces/sankey": 922}],
        37: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/scatter3d');

        }, {"../src/traces/scatter3d": 960}],
        38: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/scattercarpet');

        }, {"../src/traces/scattercarpet": 967}],
        39: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/scattergeo');

        }, {"../src/traces/scattergeo": 975}],
        40: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/scattergl');

        }, {"../src/traces/scattergl": 989}],
        41: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/scattermapbox');

        }, {"../src/traces/scattermapbox": 999}],
        42: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/scatterpolar');

        }, {"../src/traces/scatterpolar": 1007}],
        43: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/scatterpolargl');

        }, {"../src/traces/scatterpolargl": 1015}],
        44: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/scattersmith');

        }, {"../src/traces/scattersmith": 1022}],
        45: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/scatterternary');

        }, {"../src/traces/scatterternary": 1030}],
        46: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/transforms/sort');

        }, {"../src/transforms/sort": 1122}],
        47: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/splom');

        }, {"../src/traces/splom": 1040}],
        48: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/streamtube');

        }, {"../src/traces/streamtube": 1048}],
        49: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/sunburst');

        }, {"../src/traces/sunburst": 1056}],
        50: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/surface');

        }, {"../src/traces/surface": 1065}],
        51: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/table');

        }, {"../src/traces/table": 1073}],
        52: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/treemap');

        }, {"../src/traces/treemap": 1084}],
        53: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/violin');

        }, {"../src/traces/violin": 1097}],
        54: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/volume');

        }, {"../src/traces/volume": 1105}],
        55: [function (_dereq_, module, exports) {
            'use strict';

            module.exports = _dereq_('../src/traces/waterfall');

        }, {"../src/traces/waterfall": 1113}],
        56: [function (_dereq_, module, exports) {
            (function (global, factory) {
                typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, _dereq_('d3-array'), _dereq_('d3-collection'), _dereq_('d3-shape'), _dereq_('elementary-circuits-directed-graph')) :
                    typeof define === 'function' && define.amd ? define(['exports', 'd3-array', 'd3-collection', 'd3-shape', 'elementary-circuits-directed-graph'], factory) :
                        (factory((global.d3 = global.d3 || {}), global.d3, global.d3, global.d3, null));
            }(this, (function (exports, d3Array, d3Collection, d3Shape, findCircuits) {
                'use strict';

                findCircuits = findCircuits && findCircuits.hasOwnProperty('default') ? findCircuits['default'] : findCircuits;

                // For a given link, return the target node's depth
                function targetDepth(d) {
                    return d.target.depth;
                }

                // The depth of a node when the nodeAlign (align) is set to 'left'
                function left(node) {
                    return node.depth;
                }

                // The depth of a node when the nodeAlign (align) is set to 'right'
                function right(node, n) {
                    return n - 1 - node.height;
                }

                // The depth of a node when the nodeAlign (align) is set to 'justify'
                function justify(node, n) {
                    return node.sourceLinks.length ? node.depth : n - 1;
                }

                // The depth of a node when the nodeAlign (align) is set to 'center'
                function center(node) {
                    return node.targetLinks.length ? node.depth : node.sourceLinks.length ? d3Array.min(node.sourceLinks, targetDepth) - 1 : 0;
                }

                // returns a function, using the parameter given to the sankey setting
                function constant(x) {
                    return function () {
                        return x;
                    };
                }

                var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
                    return typeof obj;
                } : function (obj) {
                    return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
                };

                /// https://github.com/tomshanley/d3-sankeyCircular-circular

                // sort links' breadth (ie top to bottom in a column), based on their source nodes' breadths
                function ascendingSourceBreadth(a, b) {
                    return ascendingBreadth(a.source, b.source) || a.index - b.index;
                }

                // sort links' breadth (ie top to bottom in a column), based on their target nodes' breadths
                function ascendingTargetBreadth(a, b) {
                    return ascendingBreadth(a.target, b.target) || a.index - b.index;
                }

                // sort nodes' breadth (ie top to bottom in a column)
                // if both nodes have circular links, or both don't have circular links, then sort by the top (y0) of the node
                // else push nodes that have top circular links to the top, and nodes that have bottom circular links to the bottom
                function ascendingBreadth(a, b) {
                    if (a.partOfCycle === b.partOfCycle) {
                        return a.y0 - b.y0;
                    } else {
                        if (a.circularLinkType === 'top' || b.circularLinkType === 'bottom') {
                            return -1;
                        } else {
                            return 1;
                        }
                    }
                }

                // return the value of a node or link
                function value(d) {
                    return d.value;
                }

                // return the vertical center of a node
                function nodeCenter(node) {
                    return (node.y0 + node.y1) / 2;
                }

                // return the vertical center of a link's source node
                function linkSourceCenter(link) {
                    return nodeCenter(link.source);
                }

                // return the vertical center of a link's target node
                function linkTargetCenter(link) {
                    return nodeCenter(link.target);
                }

                // Return the default value for ID for node, d.index
                function defaultId(d) {
                    return d.index;
                }

                // Return the default object the graph's nodes, graph.nodes
                function defaultNodes(graph) {
                    return graph.nodes;
                }

                // Return the default object the graph's nodes, graph.links
                function defaultLinks(graph) {
                    return graph.links;
                }

                // Return the node from the collection that matches the provided ID, or throw an error if no match
                function find(nodeById, id) {
                    var node = nodeById.get(id);
                    if (!node) throw new Error('missing: ' + id);
                    return node;
                }

                function getNodeID(node, id) {
                    return id(node);
                }

                // The main sankeyCircular functions

                // Some constants for circular link calculations
                var verticalMargin = 25;
                var baseRadius = 10;
                var scale = 0.3; //Possibly let user control this, although anything over 0.5 starts to get too cramped

                function sankeyCircular() {
                    // Set the default values
                    var x0 = 0,
                        y0 = 0,
                        x1 = 1,
                        y1 = 1,
                        // extent
                        dx = 24,
                        // nodeWidth
                        py,
                        // nodePadding, for vertical postioning
                        id = defaultId,
                        align = justify,
                        nodes = defaultNodes,
                        links = defaultLinks,
                        iterations = 32,
                        circularLinkGap = 2,
                        paddingRatio,
                        sortNodes = null;

                    function sankeyCircular() {
                        var graph = {
                            nodes: nodes.apply(null, arguments),
                            links: links.apply(null, arguments)

                            // Process the graph's nodes and links, setting their positions

                            // 1.  Associate the nodes with their respective links, and vice versa
                        };
                        computeNodeLinks(graph);

                        // 2.  Determine which links result in a circular path in the graph
                        identifyCircles(graph, id, sortNodes);

                        // 4. Calculate the nodes' values, based on the values of the incoming and outgoing links
                        computeNodeValues(graph);

                        // 5.  Calculate the nodes' depth based on the incoming and outgoing links
                        //     Sets the nodes':
                        //     - depth:  the depth in the graph
                        //     - column: the depth (0, 1, 2, etc), as is relates to visual position from left to right
                        //     - x0, x1: the x coordinates, as is relates to visual position from left to right
                        computeNodeDepths(graph);

                        // 3.  Determine how the circular links will be drawn,
                        //     either travelling back above the main chart ("top")
                        //     or below the main chart ("bottom")
                        selectCircularLinkTypes(graph, id);

                        // 6.  Calculate the nodes' and links' vertical position within their respective column
                        //     Also readjusts sankeyCircular size if circular links are needed, and node x's
                        computeNodeBreadths(graph, iterations, id);
                        computeLinkBreadths(graph);

                        // 7.  Sort links per node, based on the links' source/target nodes' breadths
                        // 8.  Adjust nodes that overlap links that span 2+ columns
                        var linkSortingIterations = 4; //Possibly let user control this number, like the iterations over node placement
                        for (var iteration = 0; iteration < linkSortingIterations; iteration++) {

                            sortSourceLinks(graph, y1, id);
                            sortTargetLinks(graph, y1, id);
                            resolveNodeLinkOverlaps(graph, y0, y1, id);
                            sortSourceLinks(graph, y1, id);
                            sortTargetLinks(graph, y1, id);
                        }

                        // 8.1  Adjust node and link positions back to fill height of chart area if compressed
                        fillHeight(graph, y0, y1);

                        // 9. Calculate visually appealling path for the circular paths, and create the "d" string
                        addCircularPathData(graph, circularLinkGap, y1, id);

                        return graph;
                    } // end of sankeyCircular function


                    // Set the sankeyCircular parameters
                    // nodeID, nodeAlign, nodeWidth, nodePadding, nodes, links, size, extent, iterations, nodePaddingRatio, circularLinkGap
                    sankeyCircular.nodeId = function (_) {
                        return arguments.length ? (id = typeof _ === 'function' ? _ : constant(_), sankeyCircular) : id;
                    };

                    sankeyCircular.nodeAlign = function (_) {
                        return arguments.length ? (align = typeof _ === 'function' ? _ : constant(_), sankeyCircular) : align;
                    };

                    sankeyCircular.nodeWidth = function (_) {
                        return arguments.length ? (dx = +_, sankeyCircular) : dx;
                    };

                    sankeyCircular.nodePadding = function (_) {
                        return arguments.length ? (py = +_, sankeyCircular) : py;
                    };

                    sankeyCircular.nodes = function (_) {
                        return arguments.length ? (nodes = typeof _ === 'function' ? _ : constant(_), sankeyCircular) : nodes;
                    };

                    sankeyCircular.links = function (_) {
                        return arguments.length ? (links = typeof _ === 'function' ? _ : constant(_), sankeyCircular) : links;
                    };

                    sankeyCircular.size = function (_) {
                        return arguments.length ? (x0 = y0 = 0, x1 = +_[0], y1 = +_[1], sankeyCircular) : [x1 - x0, y1 - y0];
                    };

                    sankeyCircular.extent = function (_) {
                        return arguments.length ? (x0 = +_[0][0], x1 = +_[1][0], y0 = +_[0][1], y1 = +_[1][1], sankeyCircular) : [[x0, y0], [x1, y1]];
                    };

                    sankeyCircular.iterations = function (_) {
                        return arguments.length ? (iterations = +_, sankeyCircular) : iterations;
                    };

                    sankeyCircular.circularLinkGap = function (_) {
                        return arguments.length ? (circularLinkGap = +_, sankeyCircular) : circularLinkGap;
                    };

                    sankeyCircular.nodePaddingRatio = function (_) {
                        return arguments.length ? (paddingRatio = +_, sankeyCircular) : paddingRatio;
                    };

                    sankeyCircular.sortNodes = function (_) {
                        return arguments.length ? (sortNodes = _, sankeyCircular) : sortNodes;
                    };

                    sankeyCircular.update = function (graph) {
                        // 5.  Calculate the nodes' depth based on the incoming and outgoing links
                        //     Sets the nodes':
                        //     - depth:  the depth in the graph
                        //     - column: the depth (0, 1, 2, etc), as is relates to visual position from left to right
                        //     - x0, x1: the x coordinates, as is relates to visual position from left to right
                        // computeNodeDepths(graph)

                        // 3.  Determine how the circular links will be drawn,
                        //     either travelling back above the main chart ("top")
                        //     or below the main chart ("bottom")
                        selectCircularLinkTypes(graph, id);

                        // 6.  Calculate the nodes' and links' vertical position within their respective column
                        //     Also readjusts sankeyCircular size if circular links are needed, and node x's
                        // computeNodeBreadths(graph, iterations, id)
                        computeLinkBreadths(graph);

                        // Force position of circular link type based on position
                        graph.links.forEach(function (link) {
                            if (link.circular) {
                                link.circularLinkType = link.y0 + link.y1 < y1 ? 'top' : 'bottom';

                                link.source.circularLinkType = link.circularLinkType;
                                link.target.circularLinkType = link.circularLinkType;
                            }
                        });

                        sortSourceLinks(graph, y1, id, false); // Sort links but do not move nodes
                        sortTargetLinks(graph, y1, id);

                        // 7.  Sort links per node, based on the links' source/target nodes' breadths
                        // 8.  Adjust nodes that overlap links that span 2+ columns
                        // var linkSortingIterations = 4; //Possibly let user control this number, like the iterations over node placement
                        // for (var iteration = 0; iteration < linkSortingIterations; iteration++) {
                        //
                        //   sortSourceLinks(graph, y1, id)
                        //   sortTargetLinks(graph, y1, id)
                        //   resolveNodeLinkOverlaps(graph, y0, y1, id)
                        //   sortSourceLinks(graph, y1, id)
                        //   sortTargetLinks(graph, y1, id)
                        //
                        // }

                        // 8.1  Adjust node and link positions back to fill height of chart area if compressed
                        // fillHeight(graph, y0, y1)

                        // 9. Calculate visually appealling path for the circular paths, and create the "d" string
                        addCircularPathData(graph, circularLinkGap, y1, id);
                        return graph;
                    };

                    // Populate the sourceLinks and targetLinks for each node.
                    // Also, if the source and target are not objects, assume they are indices.
                    function computeNodeLinks(graph) {
                        graph.nodes.forEach(function (node, i) {
                            node.index = i;
                            node.sourceLinks = [];
                            node.targetLinks = [];
                        });
                        var nodeById = d3Collection.map(graph.nodes, id);
                        graph.links.forEach(function (link, i) {
                            link.index = i;
                            var source = link.source;
                            var target = link.target;
                            if ((typeof source === "undefined" ? "undefined" : _typeof(source)) !== 'object') {
                                source = link.source = find(nodeById, source);
                            }
                            if ((typeof target === "undefined" ? "undefined" : _typeof(target)) !== 'object') {
                                target = link.target = find(nodeById, target);
                            }
                            source.sourceLinks.push(link);
                            target.targetLinks.push(link);
                        });
                        return graph;
                    }

                    // Compute the value (size) and cycleness of each node by summing the associated links.
                    function computeNodeValues(graph) {
                        graph.nodes.forEach(function (node) {
                            node.partOfCycle = false;
                            node.value = Math.max(d3Array.sum(node.sourceLinks, value), d3Array.sum(node.targetLinks, value));
                            node.sourceLinks.forEach(function (link) {
                                if (link.circular) {
                                    node.partOfCycle = true;
                                    node.circularLinkType = link.circularLinkType;
                                }
                            });
                            node.targetLinks.forEach(function (link) {
                                if (link.circular) {
                                    node.partOfCycle = true;
                                    node.circularLinkType = link.circularLinkType;
                                }
                            });
                        });
                    }

                    function getCircleMargins(graph) {
                        var totalTopLinksWidth = 0,
                            totalBottomLinksWidth = 0,
                            totalRightLinksWidth = 0,
                            totalLeftLinksWidth = 0;

                        var maxColumn = d3Array.max(graph.nodes, function (node) {
                            return node.column;
                        });

                        graph.links.forEach(function (link) {
                            if (link.circular) {
                                if (link.circularLinkType == 'top') {
                                    totalTopLinksWidth = totalTopLinksWidth + link.width;
                                } else {
                                    totalBottomLinksWidth = totalBottomLinksWidth + link.width;
                                }

                                if (link.target.column == 0) {
                                    totalLeftLinksWidth = totalLeftLinksWidth + link.width;
                                }

                                if (link.source.column == maxColumn) {
                                    totalRightLinksWidth = totalRightLinksWidth + link.width;
                                }
                            }
                        });

                        //account for radius of curves and padding between links
                        totalTopLinksWidth = totalTopLinksWidth > 0 ? totalTopLinksWidth + verticalMargin + baseRadius : totalTopLinksWidth;
                        totalBottomLinksWidth = totalBottomLinksWidth > 0 ? totalBottomLinksWidth + verticalMargin + baseRadius : totalBottomLinksWidth;
                        totalRightLinksWidth = totalRightLinksWidth > 0 ? totalRightLinksWidth + verticalMargin + baseRadius : totalRightLinksWidth;
                        totalLeftLinksWidth = totalLeftLinksWidth > 0 ? totalLeftLinksWidth + verticalMargin + baseRadius : totalLeftLinksWidth;

                        return {
                            "top": totalTopLinksWidth,
                            "bottom": totalBottomLinksWidth,
                            "left": totalLeftLinksWidth,
                            "right": totalRightLinksWidth
                        };
                    }

                    // Update the x0, y0, x1 and y1 for the sankeyCircular, to allow space for any circular links
                    function scaleSankeySize(graph, margin) {

                        var maxColumn = d3Array.max(graph.nodes, function (node) {
                            return node.column;
                        });

                        var currentWidth = x1 - x0;
                        var currentHeight = y1 - y0;

                        var newWidth = currentWidth + margin.right + margin.left;
                        var newHeight = currentHeight + margin.top + margin.bottom;

                        var scaleX = currentWidth / newWidth;
                        var scaleY = currentHeight / newHeight;

                        x0 = x0 * scaleX + margin.left;
                        x1 = margin.right == 0 ? x1 : x1 * scaleX;
                        y0 = y0 * scaleY + margin.top;
                        y1 = y1 * scaleY;

                        graph.nodes.forEach(function (node) {
                            node.x0 = x0 + node.column * ((x1 - x0 - dx) / maxColumn);
                            node.x1 = node.x0 + dx;
                        });

                        return scaleY;
                    }

                    // Iteratively assign the depth for each node.
                    // Nodes are assigned the maximum depth of incoming neighbors plus one;
                    // nodes with no incoming links are assigned depth zero, while
                    // nodes with no outgoing links are assigned the maximum depth.
                    function computeNodeDepths(graph) {
                        var nodes, next, x;

                        for (nodes = graph.nodes, next = [], x = 0; nodes.length; ++x, nodes = next, next = []) {
                            nodes.forEach(function (node) {
                                node.depth = x;
                                node.sourceLinks.forEach(function (link) {
                                    if (next.indexOf(link.target) < 0 && !link.circular) {
                                        next.push(link.target);
                                    }
                                });
                            });
                        }

                        for (nodes = graph.nodes, next = [], x = 0; nodes.length; ++x, nodes = next, next = []) {
                            nodes.forEach(function (node) {
                                node.height = x;
                                node.targetLinks.forEach(function (link) {
                                    if (next.indexOf(link.source) < 0 && !link.circular) {
                                        next.push(link.source);
                                    }
                                });
                            });
                        }

                        // assign column numbers, and get max value
                        graph.nodes.forEach(function (node) {
                            node.column = Math.floor(align.call(null, node, x));
                        });
                    }

                    // Assign nodes' breadths, and then shift nodes that overlap (resolveCollisions)
                    function computeNodeBreadths(graph, iterations, id) {
                        var columns = d3Collection.nest().key(function (d) {
                            return d.column;
                        }).sortKeys(d3Array.ascending).entries(graph.nodes).map(function (d) {
                            return d.values;
                        });

                        initializeNodeBreadth(id);
                        resolveCollisions();

                        for (var alpha = 1, n = iterations; n > 0; --n) {
                            relaxLeftAndRight(alpha *= 0.99, id);
                            resolveCollisions();
                        }

                        function initializeNodeBreadth(id) {

                            //override py if nodePadding has been set
                            if (paddingRatio) {
                                var padding = Infinity;
                                columns.forEach(function (nodes) {
                                    var thisPadding = y1 * paddingRatio / (nodes.length + 1);
                                    padding = thisPadding < padding ? thisPadding : padding;
                                });
                                py = padding;
                            }

                            var ky = d3Array.min(columns, function (nodes) {
                                return (y1 - y0 - (nodes.length - 1) * py) / d3Array.sum(nodes, value);
                            });

                            //calculate the widths of the links
                            ky = ky * scale;

                            graph.links.forEach(function (link) {
                                link.width = link.value * ky;
                            });

                            //determine how much to scale down the chart, based on circular links
                            var margin = getCircleMargins(graph);
                            var ratio = scaleSankeySize(graph, margin);

                            //re-calculate widths
                            ky = ky * ratio;

                            graph.links.forEach(function (link) {
                                link.width = link.value * ky;
                            });

                            columns.forEach(function (nodes) {
                                var nodesLength = nodes.length;
                                nodes.forEach(function (node, i) {
                                    if (node.depth == columns.length - 1 && nodesLength == 1) {
                                        node.y0 = y1 / 2 - node.value * ky;
                                        node.y1 = node.y0 + node.value * ky;
                                    } else if (node.depth == 0 && nodesLength == 1) {
                                        node.y0 = y1 / 2 - node.value * ky;
                                        node.y1 = node.y0 + node.value * ky;
                                    } else if (node.partOfCycle) {
                                        if (numberOfNonSelfLinkingCycles(node, id) == 0) {
                                            node.y0 = y1 / 2 + i;
                                            node.y1 = node.y0 + node.value * ky;
                                        } else if (node.circularLinkType == 'top') {
                                            node.y0 = y0 + i;
                                            node.y1 = node.y0 + node.value * ky;
                                        } else {
                                            node.y0 = y1 - node.value * ky - i;
                                            node.y1 = node.y0 + node.value * ky;
                                        }
                                    } else {
                                        if (margin.top == 0 || margin.bottom == 0) {
                                            node.y0 = (y1 - y0) / nodesLength * i;
                                            node.y1 = node.y0 + node.value * ky;
                                        } else {
                                            node.y0 = (y1 - y0) / 2 - nodesLength / 2 + i;
                                            node.y1 = node.y0 + node.value * ky;
                                        }
                                    }
                                });
                            });
                        }

                        // For each node in each column, check the node's vertical position in relation to its targets and sources vertical position
                        // and shift up/down to be closer to the vertical middle of those targets and sources
                        function relaxLeftAndRight(alpha, id) {
                            var columnsLength = columns.length;

                            columns.forEach(function (nodes) {
                                var n = nodes.length;
                                var depth = nodes[0].depth;

                                nodes.forEach(function (node) {
                                    // check the node is not an orphan
                                    var nodeHeight;
                                    if (node.sourceLinks.length || node.targetLinks.length) {
                                        if (node.partOfCycle && numberOfNonSelfLinkingCycles(node, id) > 0) ; else if (depth == 0 && n == 1) {
                                            nodeHeight = node.y1 - node.y0;

                                            node.y0 = y1 / 2 - nodeHeight / 2;
                                            node.y1 = y1 / 2 + nodeHeight / 2;
                                        } else if (depth == columnsLength - 1 && n == 1) {
                                            nodeHeight = node.y1 - node.y0;

                                            node.y0 = y1 / 2 - nodeHeight / 2;
                                            node.y1 = y1 / 2 + nodeHeight / 2;
                                        } else {
                                            var avg = 0;

                                            var avgTargetY = d3Array.mean(node.sourceLinks, linkTargetCenter);
                                            var avgSourceY = d3Array.mean(node.targetLinks, linkSourceCenter);

                                            if (avgTargetY && avgSourceY) {
                                                avg = (avgTargetY + avgSourceY) / 2;
                                            } else {
                                                avg = avgTargetY || avgSourceY;
                                            }

                                            var dy = (avg - nodeCenter(node)) * alpha;
                                            // positive if it node needs to move down
                                            node.y0 += dy;
                                            node.y1 += dy;
                                        }
                                    }
                                });
                            });
                        }

                        // For each column, check if nodes are overlapping, and if so, shift up/down
                        function resolveCollisions() {
                            columns.forEach(function (nodes) {
                                var node,
                                    dy,
                                    y = y0,
                                    n = nodes.length,
                                    i;

                                // Push any overlapping nodes down.
                                nodes.sort(ascendingBreadth);

                                for (i = 0; i < n; ++i) {
                                    node = nodes[i];
                                    dy = y - node.y0;

                                    if (dy > 0) {
                                        node.y0 += dy;
                                        node.y1 += dy;
                                    }
                                    y = node.y1 + py;
                                }

                                // If the bottommost node goes outside the bounds, push it back up.
                                dy = y - py - y1;
                                if (dy > 0) {
                                    y = node.y0 -= dy, node.y1 -= dy;

                                    // Push any overlapping nodes back up.
                                    for (i = n - 2; i >= 0; --i) {
                                        node = nodes[i];
                                        dy = node.y1 + py - y;
                                        if (dy > 0) node.y0 -= dy, node.y1 -= dy;
                                        y = node.y0;
                                    }
                                }
                            });
                        }
                    }

                    // Assign the links y0 and y1 based on source/target nodes position,
                    // plus the link's relative position to other links to the same node
                    function computeLinkBreadths(graph) {
                        graph.nodes.forEach(function (node) {
                            node.sourceLinks.sort(ascendingTargetBreadth);
                            node.targetLinks.sort(ascendingSourceBreadth);
                        });
                        graph.nodes.forEach(function (node) {
                            var y0 = node.y0;
                            var y1 = y0;

                            // start from the bottom of the node for cycle links
                            var y0cycle = node.y1;
                            var y1cycle = y0cycle;

                            node.sourceLinks.forEach(function (link) {
                                if (link.circular) {
                                    link.y0 = y0cycle - link.width / 2;
                                    y0cycle = y0cycle - link.width;
                                } else {
                                    link.y0 = y0 + link.width / 2;
                                    y0 += link.width;
                                }
                            });
                            node.targetLinks.forEach(function (link) {
                                if (link.circular) {
                                    link.y1 = y1cycle - link.width / 2;
                                    y1cycle = y1cycle - link.width;
                                } else {
                                    link.y1 = y1 + link.width / 2;
                                    y1 += link.width;
                                }
                            });
                        });
                    }

                    return sankeyCircular;
                }

                /// /////////////////////////////////////////////////////////////////////////////////
                // Cycle functions
                // portion of code to detect circular links based on Colin Fergus' bl.ock https://gist.github.com/cfergus/3956043

                // Identify circles in the link objects
                function identifyCircles(graph, id, sortNodes) {
                    var circularLinkID = 0;
                    if (sortNodes === null) {

                        // Building adjacency graph
                        var adjList = [];
                        for (var i = 0; i < graph.links.length; i++) {
                            var link = graph.links[i];
                            var source = link.source.index;
                            var target = link.target.index;
                            if (!adjList[source]) adjList[source] = [];
                            if (!adjList[target]) adjList[target] = [];

                            // Add links if not already in set
                            if (adjList[source].indexOf(target) === -1) adjList[source].push(target);
                        }

                        // Find all elementary circuits
                        var cycles = findCircuits(adjList);

                        // Sort by circuits length
                        cycles.sort(function (a, b) {
                            return a.length - b.length;
                        });

                        var circularLinks = {};
                        for (i = 0; i < cycles.length; i++) {
                            var cycle = cycles[i];
                            var last = cycle.slice(-2);
                            if (!circularLinks[last[0]]) circularLinks[last[0]] = {};
                            circularLinks[last[0]][last[1]] = true;
                        }

                        graph.links.forEach(function (link) {
                            var target = link.target.index;
                            var source = link.source.index;
                            // If self-linking or a back-edge
                            if (target === source || circularLinks[source] && circularLinks[source][target]) {
                                link.circular = true;
                                link.circularLinkID = circularLinkID;
                                circularLinkID = circularLinkID + 1;
                            } else {
                                link.circular = false;
                            }
                        });
                    } else {
                        graph.links.forEach(function (link) {
                            if (link.source[sortNodes] < link.target[sortNodes]) {
                                link.circular = false;
                            } else {
                                link.circular = true;
                                link.circularLinkID = circularLinkID;
                                circularLinkID = circularLinkID + 1;
                            }
                        });
                    }
                }

                // Assign a circular link type (top or bottom), based on:
                // - if the source/target node already has circular links, then use the same type
                // - if not, choose the type with fewer links
                function selectCircularLinkTypes(graph, id) {
                    var numberOfTops = 0;
                    var numberOfBottoms = 0;
                    graph.links.forEach(function (link) {
                        if (link.circular) {
                            // if either souce or target has type already use that
                            if (link.source.circularLinkType || link.target.circularLinkType) {
                                // default to source type if available
                                link.circularLinkType = link.source.circularLinkType ? link.source.circularLinkType : link.target.circularLinkType;
                            } else {
                                link.circularLinkType = numberOfTops < numberOfBottoms ? 'top' : 'bottom';
                            }

                            if (link.circularLinkType == 'top') {
                                numberOfTops = numberOfTops + 1;
                            } else {
                                numberOfBottoms = numberOfBottoms + 1;
                            }

                            graph.nodes.forEach(function (node) {
                                if (getNodeID(node, id) == getNodeID(link.source, id) || getNodeID(node, id) == getNodeID(link.target, id)) {
                                    node.circularLinkType = link.circularLinkType;
                                }
                            });
                        }
                    });

                    //correct self-linking links to be same direction as node
                    graph.links.forEach(function (link) {
                        if (link.circular) {
                            //if both source and target node are same type, then link should have same type
                            if (link.source.circularLinkType == link.target.circularLinkType) {
                                link.circularLinkType = link.source.circularLinkType;
                            }
                            //if link is selflinking, then link should have same type as node
                            if (selfLinking(link, id)) {
                                link.circularLinkType = link.source.circularLinkType;
                            }
                        }
                    });
                }

                // Return the angle between a straight line between the source and target of the link, and the vertical plane of the node
                function linkAngle(link) {
                    var adjacent = Math.abs(link.y1 - link.y0);
                    var opposite = Math.abs(link.target.x0 - link.source.x1);

                    return Math.atan(opposite / adjacent);
                }

                // Check if two circular links potentially overlap
                function circularLinksCross(link1, link2) {
                    if (link1.source.column < link2.target.column) {
                        return false;
                    } else if (link1.target.column > link2.source.column) {
                        return false;
                    } else {
                        return true;
                    }
                }

                // Return the number of circular links for node, not including self linking links
                function numberOfNonSelfLinkingCycles(node, id) {
                    var sourceCount = 0;
                    node.sourceLinks.forEach(function (l) {
                        sourceCount = l.circular && !selfLinking(l, id) ? sourceCount + 1 : sourceCount;
                    });

                    var targetCount = 0;
                    node.targetLinks.forEach(function (l) {
                        targetCount = l.circular && !selfLinking(l, id) ? targetCount + 1 : targetCount;
                    });

                    return sourceCount + targetCount;
                }

                // Check if a circular link is the only circular link for both its source and target node
                function onlyCircularLink(link) {
                    var nodeSourceLinks = link.source.sourceLinks;
                    var sourceCount = 0;
                    nodeSourceLinks.forEach(function (l) {
                        sourceCount = l.circular ? sourceCount + 1 : sourceCount;
                    });

                    var nodeTargetLinks = link.target.targetLinks;
                    var targetCount = 0;
                    nodeTargetLinks.forEach(function (l) {
                        targetCount = l.circular ? targetCount + 1 : targetCount;
                    });

                    if (sourceCount > 1 || targetCount > 1) {
                        return false;
                    } else {
                        return true;
                    }
                }

                // creates vertical buffer values per set of top/bottom links
                function calcVerticalBuffer(links, circularLinkGap, id) {
                    links.sort(sortLinkColumnAscending);
                    links.forEach(function (link, i) {
                        var buffer = 0;

                        if (selfLinking(link, id) && onlyCircularLink(link)) {
                            link.circularPathData.verticalBuffer = buffer + link.width / 2;
                        } else {
                            var j = 0;
                            for (j; j < i; j++) {
                                if (circularLinksCross(links[i], links[j])) {
                                    var bufferOverThisLink = links[j].circularPathData.verticalBuffer + links[j].width / 2 + circularLinkGap;
                                    buffer = bufferOverThisLink > buffer ? bufferOverThisLink : buffer;
                                }
                            }

                            link.circularPathData.verticalBuffer = buffer + link.width / 2;
                        }
                    });

                    return links;
                }

                // calculate the optimum path for a link to reduce overlaps
                function addCircularPathData(graph, circularLinkGap, y1, id) {
                    //var baseRadius = 10
                    var buffer = 5;
                    //var verticalMargin = 25

                    var minY = d3Array.min(graph.links, function (link) {
                        return link.source.y0;
                    });

                    // create object for circular Path Data
                    graph.links.forEach(function (link) {
                        if (link.circular) {
                            link.circularPathData = {};
                        }
                    });

                    // calc vertical offsets per top/bottom links
                    var topLinks = graph.links.filter(function (l) {
                        return l.circularLinkType == 'top';
                    });
                    /* topLinks = */
                    calcVerticalBuffer(topLinks, circularLinkGap, id);

                    var bottomLinks = graph.links.filter(function (l) {
                        return l.circularLinkType == 'bottom';
                    });
                    /* bottomLinks = */
                    calcVerticalBuffer(bottomLinks, circularLinkGap, id);

                    // add the base data for each link
                    graph.links.forEach(function (link) {
                        if (link.circular) {
                            link.circularPathData.arcRadius = link.width + baseRadius;
                            link.circularPathData.leftNodeBuffer = buffer;
                            link.circularPathData.rightNodeBuffer = buffer;
                            link.circularPathData.sourceWidth = link.source.x1 - link.source.x0;
                            link.circularPathData.sourceX = link.source.x0 + link.circularPathData.sourceWidth;
                            link.circularPathData.targetX = link.target.x0;
                            link.circularPathData.sourceY = link.y0;
                            link.circularPathData.targetY = link.y1;

                            // for self linking paths, and that the only circular link in/out of that node
                            if (selfLinking(link, id) && onlyCircularLink(link)) {
                                link.circularPathData.leftSmallArcRadius = baseRadius + link.width / 2;
                                link.circularPathData.leftLargeArcRadius = baseRadius + link.width / 2;
                                link.circularPathData.rightSmallArcRadius = baseRadius + link.width / 2;
                                link.circularPathData.rightLargeArcRadius = baseRadius + link.width / 2;

                                if (link.circularLinkType == 'bottom') {
                                    link.circularPathData.verticalFullExtent = link.source.y1 + verticalMargin + link.circularPathData.verticalBuffer;
                                    link.circularPathData.verticalLeftInnerExtent = link.circularPathData.verticalFullExtent - link.circularPathData.leftLargeArcRadius;
                                    link.circularPathData.verticalRightInnerExtent = link.circularPathData.verticalFullExtent - link.circularPathData.rightLargeArcRadius;
                                } else {
                                    // top links
                                    link.circularPathData.verticalFullExtent = link.source.y0 - verticalMargin - link.circularPathData.verticalBuffer;
                                    link.circularPathData.verticalLeftInnerExtent = link.circularPathData.verticalFullExtent + link.circularPathData.leftLargeArcRadius;
                                    link.circularPathData.verticalRightInnerExtent = link.circularPathData.verticalFullExtent + link.circularPathData.rightLargeArcRadius;
                                }
                            } else {
                                // else calculate normally
                                // add left extent coordinates, based on links with same source column and circularLink type
                                var thisColumn = link.source.column;
                                var thisCircularLinkType = link.circularLinkType;
                                var sameColumnLinks = graph.links.filter(function (l) {
                                    return l.source.column == thisColumn && l.circularLinkType == thisCircularLinkType;
                                });

                                if (link.circularLinkType == 'bottom') {
                                    sameColumnLinks.sort(sortLinkSourceYDescending);
                                } else {
                                    sameColumnLinks.sort(sortLinkSourceYAscending);
                                }

                                var radiusOffset = 0;
                                sameColumnLinks.forEach(function (l, i) {
                                    if (l.circularLinkID == link.circularLinkID) {
                                        link.circularPathData.leftSmallArcRadius = baseRadius + link.width / 2 + radiusOffset;
                                        link.circularPathData.leftLargeArcRadius = baseRadius + link.width / 2 + i * circularLinkGap + radiusOffset;
                                    }
                                    radiusOffset = radiusOffset + l.width;
                                });

                                // add right extent coordinates, based on links with same target column and circularLink type
                                thisColumn = link.target.column;
                                sameColumnLinks = graph.links.filter(function (l) {
                                    return l.target.column == thisColumn && l.circularLinkType == thisCircularLinkType;
                                });
                                if (link.circularLinkType == 'bottom') {
                                    sameColumnLinks.sort(sortLinkTargetYDescending);
                                } else {
                                    sameColumnLinks.sort(sortLinkTargetYAscending);
                                }

                                radiusOffset = 0;
                                sameColumnLinks.forEach(function (l, i) {
                                    if (l.circularLinkID == link.circularLinkID) {
                                        link.circularPathData.rightSmallArcRadius = baseRadius + link.width / 2 + radiusOffset;
                                        link.circularPathData.rightLargeArcRadius = baseRadius + link.width / 2 + i * circularLinkGap + radiusOffset;
                                    }
                                    radiusOffset = radiusOffset + l.width;
                                });

                                // bottom links
                                if (link.circularLinkType == 'bottom') {
                                    link.circularPathData.verticalFullExtent = Math.max(y1, link.source.y1, link.target.y1) + verticalMargin + link.circularPathData.verticalBuffer;
                                    link.circularPathData.verticalLeftInnerExtent = link.circularPathData.verticalFullExtent - link.circularPathData.leftLargeArcRadius;
                                    link.circularPathData.verticalRightInnerExtent = link.circularPathData.verticalFullExtent - link.circularPathData.rightLargeArcRadius;
                                } else {
                                    // top links
                                    link.circularPathData.verticalFullExtent = minY - verticalMargin - link.circularPathData.verticalBuffer;
                                    link.circularPathData.verticalLeftInnerExtent = link.circularPathData.verticalFullExtent + link.circularPathData.leftLargeArcRadius;
                                    link.circularPathData.verticalRightInnerExtent = link.circularPathData.verticalFullExtent + link.circularPathData.rightLargeArcRadius;
                                }
                            }

                            // all links
                            link.circularPathData.leftInnerExtent = link.circularPathData.sourceX + link.circularPathData.leftNodeBuffer;
                            link.circularPathData.rightInnerExtent = link.circularPathData.targetX - link.circularPathData.rightNodeBuffer;
                            link.circularPathData.leftFullExtent = link.circularPathData.sourceX + link.circularPathData.leftLargeArcRadius + link.circularPathData.leftNodeBuffer;
                            link.circularPathData.rightFullExtent = link.circularPathData.targetX - link.circularPathData.rightLargeArcRadius - link.circularPathData.rightNodeBuffer;
                        }

                        if (link.circular) {
                            link.path = createCircularPathString(link);
                        } else {
                            var normalPath = d3Shape.linkHorizontal().source(function (d) {
                                var x = d.source.x0 + (d.source.x1 - d.source.x0);
                                var y = d.y0;
                                return [x, y];
                            }).target(function (d) {
                                var x = d.target.x0;
                                var y = d.y1;
                                return [x, y];
                            });
                            link.path = normalPath(link);
                        }
                    });
                }

                // create a d path using the addCircularPathData
                function createCircularPathString(link) {
                    var pathString = '';
                    // 'pathData' is assigned a value but never used
                    // var pathData = {}

                    if (link.circularLinkType == 'top') {
                        pathString =
                            // start at the right of the source node
                            'M' + link.circularPathData.sourceX + ' ' + link.circularPathData.sourceY + ' ' +
                            // line right to buffer point
                            'L' + link.circularPathData.leftInnerExtent + ' ' + link.circularPathData.sourceY + ' ' +
                            // Arc around: Centre of arc X and  //Centre of arc Y
                            'A' + link.circularPathData.leftLargeArcRadius + ' ' + link.circularPathData.leftSmallArcRadius + ' 0 0 0 ' +
                            // End of arc X //End of arc Y
                            link.circularPathData.leftFullExtent + ' ' + (link.circularPathData.sourceY - link.circularPathData.leftSmallArcRadius) + ' ' + // End of arc X
                            // line up to buffer point
                            'L' + link.circularPathData.leftFullExtent + ' ' + link.circularPathData.verticalLeftInnerExtent + ' ' +
                            // Arc around: Centre of arc X and  //Centre of arc Y
                            'A' + link.circularPathData.leftLargeArcRadius + ' ' + link.circularPathData.leftLargeArcRadius + ' 0 0 0 ' +
                            // End of arc X //End of arc Y
                            link.circularPathData.leftInnerExtent + ' ' + link.circularPathData.verticalFullExtent + ' ' + // End of arc X
                            // line left to buffer point
                            'L' + link.circularPathData.rightInnerExtent + ' ' + link.circularPathData.verticalFullExtent + ' ' +
                            // Arc around: Centre of arc X and  //Centre of arc Y
                            'A' + link.circularPathData.rightLargeArcRadius + ' ' + link.circularPathData.rightLargeArcRadius + ' 0 0 0 ' +
                            // End of arc X //End of arc Y
                            link.circularPathData.rightFullExtent + ' ' + link.circularPathData.verticalRightInnerExtent + ' ' + // End of arc X
                            // line down
                            'L' + link.circularPathData.rightFullExtent + ' ' + (link.circularPathData.targetY - link.circularPathData.rightSmallArcRadius) + ' ' +
                            // Arc around: Centre of arc X and  //Centre of arc Y
                            'A' + link.circularPathData.rightLargeArcRadius + ' ' + link.circularPathData.rightSmallArcRadius + ' 0 0 0 ' +
                            // End of arc X //End of arc Y
                            link.circularPathData.rightInnerExtent + ' ' + link.circularPathData.targetY + ' ' + // End of arc X
                            // line to end
                            'L' + link.circularPathData.targetX + ' ' + link.circularPathData.targetY;
                    } else {
                        // bottom path
                        pathString =
                            // start at the right of the source node
                            'M' + link.circularPathData.sourceX + ' ' + link.circularPathData.sourceY + ' ' +
                            // line right to buffer point
                            'L' + link.circularPathData.leftInnerExtent + ' ' + link.circularPathData.sourceY + ' ' +
                            // Arc around: Centre of arc X and  //Centre of arc Y
                            'A' + link.circularPathData.leftLargeArcRadius + ' ' + link.circularPathData.leftSmallArcRadius + ' 0 0 1 ' +
                            // End of arc X //End of arc Y
                            link.circularPathData.leftFullExtent + ' ' + (link.circularPathData.sourceY + link.circularPathData.leftSmallArcRadius) + ' ' + // End of arc X
                            // line down to buffer point
                            'L' + link.circularPathData.leftFullExtent + ' ' + link.circularPathData.verticalLeftInnerExtent + ' ' +
                            // Arc around: Centre of arc X and  //Centre of arc Y
                            'A' + link.circularPathData.leftLargeArcRadius + ' ' + link.circularPathData.leftLargeArcRadius + ' 0 0 1 ' +
                            // End of arc X //End of arc Y
                            link.circularPathData.leftInnerExtent + ' ' + link.circularPathData.verticalFullExtent + ' ' + // End of arc X
                            // line left to buffer point
                            'L' + link.circularPathData.rightInnerExtent + ' ' + link.circularPathData.verticalFullExtent + ' ' +
                            // Arc around: Centre of arc X and  //Centre of arc Y
                            'A' + link.circularPathData.rightLargeArcRadius + ' ' + link.circularPathData.rightLargeArcRadius + ' 0 0 1 ' +
                            // End of arc X //End of arc Y
                            link.circularPathData.rightFullExtent + ' ' + link.circularPathData.verticalRightInnerExtent + ' ' + // End of arc X
                            // line up
                            'L' + link.circularPathData.rightFullExtent + ' ' + (link.circularPathData.targetY + link.circularPathData.rightSmallArcRadius) + ' ' +
                            // Arc around: Centre of arc X and  //Centre of arc Y
                            'A' + link.circularPathData.rightLargeArcRadius + ' ' + link.circularPathData.rightSmallArcRadius + ' 0 0 1 ' +
                            // End of arc X //End of arc Y
                            link.circularPathData.rightInnerExtent + ' ' + link.circularPathData.targetY + ' ' + // End of arc X
                            // line to end
                            'L' + link.circularPathData.targetX + ' ' + link.circularPathData.targetY;
                    }

                    return pathString;
                }

                // sort links based on the distance between the source and tartget node columns
                // if the same, then use Y position of the source node
                function sortLinkColumnAscending(link1, link2) {
                    if (linkColumnDistance(link1) == linkColumnDistance(link2)) {
                        return link1.circularLinkType == 'bottom' ? sortLinkSourceYDescending(link1, link2) : sortLinkSourceYAscending(link1, link2);
                    } else {
                        return linkColumnDistance(link2) - linkColumnDistance(link1);
                    }
                }

                // sort ascending links by their source vertical position, y0
                function sortLinkSourceYAscending(link1, link2) {
                    return link1.y0 - link2.y0;
                }

                // sort descending links by their source vertical position, y0
                function sortLinkSourceYDescending(link1, link2) {
                    return link2.y0 - link1.y0;
                }

                // sort ascending links by their target vertical position, y1
                function sortLinkTargetYAscending(link1, link2) {
                    return link1.y1 - link2.y1;
                }

                // sort descending links by their target vertical position, y1
                function sortLinkTargetYDescending(link1, link2) {
                    return link2.y1 - link1.y1;
                }

                // return the distance between the link's target and source node, in terms of the nodes' column
                function linkColumnDistance(link) {
                    return link.target.column - link.source.column;
                }

                // return the distance between the link's target and source node, in terms of the nodes' X coordinate
                function linkXLength(link) {
                    return link.target.x0 - link.source.x1;
                }

                // Return the Y coordinate on the longerLink path * which is perpendicular shorterLink's source.
                // * approx, based on a straight line from target to source, when in fact the path is a bezier
                function linkPerpendicularYToLinkSource(longerLink, shorterLink) {
                    // get the angle for the longer link
                    var angle = linkAngle(longerLink);

                    // get the adjacent length to the other link's x position
                    var heightFromY1ToPependicular = linkXLength(shorterLink) / Math.tan(angle);

                    // add or subtract from longer link1's original y1, depending on the slope
                    var yPerpendicular = incline(longerLink) == 'up' ? longerLink.y1 + heightFromY1ToPependicular : longerLink.y1 - heightFromY1ToPependicular;

                    return yPerpendicular;
                }

                // Return the Y coordinate on the longerLink path * which is perpendicular shorterLink's source.
                // * approx, based on a straight line from target to source, when in fact the path is a bezier
                function linkPerpendicularYToLinkTarget(longerLink, shorterLink) {
                    // get the angle for the longer link
                    var angle = linkAngle(longerLink);

                    // get the adjacent length to the other link's x position
                    var heightFromY1ToPependicular = linkXLength(shorterLink) / Math.tan(angle);

                    // add or subtract from longer link's original y1, depending on the slope
                    var yPerpendicular = incline(longerLink) == 'up' ? longerLink.y1 - heightFromY1ToPependicular : longerLink.y1 + heightFromY1ToPependicular;

                    return yPerpendicular;
                }

                // Move any nodes that overlap links which span 2+ columns
                function resolveNodeLinkOverlaps(graph, y0, y1, id) {

                    graph.links.forEach(function (link) {
                        if (link.circular) {
                            return;
                        }

                        if (link.target.column - link.source.column > 1) {
                            var columnToTest = link.source.column + 1;
                            var maxColumnToTest = link.target.column - 1;

                            var i = 1;
                            var numberOfColumnsToTest = maxColumnToTest - columnToTest + 1;

                            for (i = 1; columnToTest <= maxColumnToTest; columnToTest++, i++) {
                                graph.nodes.forEach(function (node) {
                                    if (node.column == columnToTest) {
                                        var t = i / (numberOfColumnsToTest + 1);

                                        // Find all the points of a cubic bezier curve in javascript
                                        // https://stackoverflow.com/questions/15397596/find-all-the-points-of-a-cubic-bezier-curve-in-javascript

                                        var B0_t = Math.pow(1 - t, 3);
                                        var B1_t = 3 * t * Math.pow(1 - t, 2);
                                        var B2_t = 3 * Math.pow(t, 2) * (1 - t);
                                        var B3_t = Math.pow(t, 3);

                                        var py_t = B0_t * link.y0 + B1_t * link.y0 + B2_t * link.y1 + B3_t * link.y1;

                                        var linkY0AtColumn = py_t - link.width / 2;
                                        var linkY1AtColumn = py_t + link.width / 2;
                                        var dy;

                                        // If top of link overlaps node, push node up
                                        if (linkY0AtColumn > node.y0 && linkY0AtColumn < node.y1) {

                                            dy = node.y1 - linkY0AtColumn + 10;
                                            dy = node.circularLinkType == 'bottom' ? dy : -dy;

                                            node = adjustNodeHeight(node, dy, y0, y1);

                                            // check if other nodes need to move up too
                                            graph.nodes.forEach(function (otherNode) {
                                                // don't need to check itself or nodes at different columns
                                                if (getNodeID(otherNode, id) == getNodeID(node, id) || otherNode.column != node.column) {
                                                    return;
                                                }
                                                if (nodesOverlap(node, otherNode)) {
                                                    adjustNodeHeight(otherNode, dy, y0, y1);
                                                }
                                            });
                                        } else if (linkY1AtColumn > node.y0 && linkY1AtColumn < node.y1) {
                                            // If bottom of link overlaps node, push node down
                                            dy = linkY1AtColumn - node.y0 + 10;

                                            node = adjustNodeHeight(node, dy, y0, y1);

                                            // check if other nodes need to move down too
                                            graph.nodes.forEach(function (otherNode) {
                                                // don't need to check itself or nodes at different columns
                                                if (getNodeID(otherNode, id) == getNodeID(node, id) || otherNode.column != node.column) {
                                                    return;
                                                }
                                                if (otherNode.y0 < node.y1 && otherNode.y1 > node.y1) {
                                                    adjustNodeHeight(otherNode, dy, y0, y1);
                                                }
                                            });
                                        } else if (linkY0AtColumn < node.y0 && linkY1AtColumn > node.y1) {
                                            // if link completely overlaps node
                                            dy = linkY1AtColumn - node.y0 + 10;

                                            node = adjustNodeHeight(node, dy, y0, y1);

                                            graph.nodes.forEach(function (otherNode) {
                                                // don't need to check itself or nodes at different columns
                                                if (getNodeID(otherNode, id) == getNodeID(node, id) || otherNode.column != node.column) {
                                                    return;
                                                }
                                                if (otherNode.y0 < node.y1 && otherNode.y1 > node.y1) {
                                                    adjustNodeHeight(otherNode, dy, y0, y1);
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    });
                }

                // check if two nodes overlap
                function nodesOverlap(nodeA, nodeB) {
                    // test if nodeA top partially overlaps nodeB
                    if (nodeA.y0 > nodeB.y0 && nodeA.y0 < nodeB.y1) {
                        return true;
                    } else if (nodeA.y1 > nodeB.y0 && nodeA.y1 < nodeB.y1) {
                        // test if nodeA bottom partially overlaps nodeB
                        return true;
                    } else if (nodeA.y0 < nodeB.y0 && nodeA.y1 > nodeB.y1) {
                        // test if nodeA covers nodeB
                        return true;
                    } else {
                        return false;
                    }
                }

                // update a node, and its associated links, vertical positions (y0, y1)
                function adjustNodeHeight(node, dy, sankeyY0, sankeyY1) {
                    if (node.y0 + dy >= sankeyY0 && node.y1 + dy <= sankeyY1) {
                        node.y0 = node.y0 + dy;
                        node.y1 = node.y1 + dy;

                        node.targetLinks.forEach(function (l) {
                            l.y1 = l.y1 + dy;
                        });

                        node.sourceLinks.forEach(function (l) {
                            l.y0 = l.y0 + dy;
                        });
                    }
                    return node;
                }

                // sort and set the links' y0 for each node
                function sortSourceLinks(graph, y1, id, moveNodes) {
                    graph.nodes.forEach(function (node) {
                        // move any nodes up which are off the bottom
                        if (moveNodes && node.y + (node.y1 - node.y0) > y1) {
                            node.y = node.y - (node.y + (node.y1 - node.y0) - y1);
                        }

                        var nodesSourceLinks = graph.links.filter(function (l) {
                            return getNodeID(l.source, id) == getNodeID(node, id);
                        });

                        var nodeSourceLinksLength = nodesSourceLinks.length;

                        // if more than 1 link then sort
                        if (nodeSourceLinksLength > 1) {
                            nodesSourceLinks.sort(function (link1, link2) {
                                // if both are not circular...
                                if (!link1.circular && !link2.circular) {
                                    // if the target nodes are the same column, then sort by the link's target y
                                    if (link1.target.column == link2.target.column) {
                                        return link1.y1 - link2.y1;
                                    } else if (!sameInclines(link1, link2)) {
                                        // if the links slope in different directions, then sort by the link's target y
                                        return link1.y1 - link2.y1;

                                        // if the links slope in same directions, then sort by any overlap
                                    } else {
                                        if (link1.target.column > link2.target.column) {
                                            var link2Adj = linkPerpendicularYToLinkTarget(link2, link1);
                                            return link1.y1 - link2Adj;
                                        }
                                        if (link2.target.column > link1.target.column) {
                                            var link1Adj = linkPerpendicularYToLinkTarget(link1, link2);
                                            return link1Adj - link2.y1;
                                        }
                                    }
                                }

                                // if only one is circular, the move top links up, or bottom links down
                                if (link1.circular && !link2.circular) {
                                    return link1.circularLinkType == 'top' ? -1 : 1;
                                } else if (link2.circular && !link1.circular) {
                                    return link2.circularLinkType == 'top' ? 1 : -1;
                                }

                                // if both links are circular...
                                if (link1.circular && link2.circular) {
                                    // ...and they both loop the same way (both top)
                                    if (link1.circularLinkType === link2.circularLinkType && link1.circularLinkType == 'top') {
                                        // ...and they both connect to a target with same column, then sort by the target's y
                                        if (link1.target.column === link2.target.column) {
                                            return link1.target.y1 - link2.target.y1;
                                        } else {
                                            // ...and they connect to different column targets, then sort by how far back they
                                            return link2.target.column - link1.target.column;
                                        }
                                    } else if (link1.circularLinkType === link2.circularLinkType && link1.circularLinkType == 'bottom') {
                                        // ...and they both loop the same way (both bottom)
                                        // ...and they both connect to a target with same column, then sort by the target's y
                                        if (link1.target.column === link2.target.column) {
                                            return link2.target.y1 - link1.target.y1;
                                        } else {
                                            // ...and they connect to different column targets, then sort by how far back they
                                            return link1.target.column - link2.target.column;
                                        }
                                    } else {
                                        // ...and they loop around different ways, the move top up and bottom down
                                        return link1.circularLinkType == 'top' ? -1 : 1;
                                    }
                                }
                            });
                        }

                        // update y0 for links
                        var ySourceOffset = node.y0;

                        nodesSourceLinks.forEach(function (link) {
                            link.y0 = ySourceOffset + link.width / 2;
                            ySourceOffset = ySourceOffset + link.width;
                        });

                        // correct any circular bottom links so they are at the bottom of the node
                        nodesSourceLinks.forEach(function (link, i) {
                            if (link.circularLinkType == 'bottom') {
                                var j = i + 1;
                                var offsetFromBottom = 0;
                                // sum the widths of any links that are below this link
                                for (j; j < nodeSourceLinksLength; j++) {
                                    offsetFromBottom = offsetFromBottom + nodesSourceLinks[j].width;
                                }
                                link.y0 = node.y1 - offsetFromBottom - link.width / 2;
                            }
                        });
                    });
                }

                // sort and set the links' y1 for each node
                function sortTargetLinks(graph, y1, id) {
                    graph.nodes.forEach(function (node) {
                        var nodesTargetLinks = graph.links.filter(function (l) {
                            return getNodeID(l.target, id) == getNodeID(node, id);
                        });

                        var nodesTargetLinksLength = nodesTargetLinks.length;

                        if (nodesTargetLinksLength > 1) {
                            nodesTargetLinks.sort(function (link1, link2) {
                                // if both are not circular, the base on the source y position
                                if (!link1.circular && !link2.circular) {
                                    if (link1.source.column == link2.source.column) {
                                        return link1.y0 - link2.y0;
                                    } else if (!sameInclines(link1, link2)) {
                                        return link1.y0 - link2.y0;
                                    } else {
                                        // get the angle of the link to the further source node (ie the smaller column)
                                        if (link2.source.column < link1.source.column) {
                                            var link2Adj = linkPerpendicularYToLinkSource(link2, link1);

                                            return link1.y0 - link2Adj;
                                        }
                                        if (link1.source.column < link2.source.column) {
                                            var link1Adj = linkPerpendicularYToLinkSource(link1, link2);

                                            return link1Adj - link2.y0;
                                        }
                                    }
                                }

                                // if only one is circular, the move top links up, or bottom links down
                                if (link1.circular && !link2.circular) {
                                    return link1.circularLinkType == 'top' ? -1 : 1;
                                } else if (link2.circular && !link1.circular) {
                                    return link2.circularLinkType == 'top' ? 1 : -1;
                                }

                                // if both links are circular...
                                if (link1.circular && link2.circular) {
                                    // ...and they both loop the same way (both top)
                                    if (link1.circularLinkType === link2.circularLinkType && link1.circularLinkType == 'top') {
                                        // ...and they both connect to a target with same column, then sort by the target's y
                                        if (link1.source.column === link2.source.column) {
                                            return link1.source.y1 - link2.source.y1;
                                        } else {
                                            // ...and they connect to different column targets, then sort by how far back they
                                            return link1.source.column - link2.source.column;
                                        }
                                    } else if (link1.circularLinkType === link2.circularLinkType && link1.circularLinkType == 'bottom') {
                                        // ...and they both loop the same way (both bottom)
                                        // ...and they both connect to a target with same column, then sort by the target's y
                                        if (link1.source.column === link2.source.column) {
                                            return link1.source.y1 - link2.source.y1;
                                        } else {
                                            // ...and they connect to different column targets, then sort by how far back they
                                            return link2.source.column - link1.source.column;
                                        }
                                    } else {
                                        // ...and they loop around different ways, the move top up and bottom down
                                        return link1.circularLinkType == 'top' ? -1 : 1;
                                    }
                                }
                            });
                        }

                        // update y1 for links
                        var yTargetOffset = node.y0;

                        nodesTargetLinks.forEach(function (link) {
                            link.y1 = yTargetOffset + link.width / 2;
                            yTargetOffset = yTargetOffset + link.width;
                        });

                        // correct any circular bottom links so they are at the bottom of the node
                        nodesTargetLinks.forEach(function (link, i) {
                            if (link.circularLinkType == 'bottom') {
                                var j = i + 1;
                                var offsetFromBottom = 0;
                                // sum the widths of any links that are below this link
                                for (j; j < nodesTargetLinksLength; j++) {
                                    offsetFromBottom = offsetFromBottom + nodesTargetLinks[j].width;
                                }
                                link.y1 = node.y1 - offsetFromBottom - link.width / 2;
                            }
                        });
                    });
                }

                // test if links both slope up, or both slope down
                function sameInclines(link1, link2) {
                    return incline(link1) == incline(link2);
                }

                // returns the slope of a link, from source to target
                // up => slopes up from source to target
                // down => slopes down from source to target
                function incline(link) {
                    return link.y0 - link.y1 > 0 ? 'up' : 'down';
                }

                // check if link is self linking, ie links a node to the same node
                function selfLinking(link, id) {
                    return getNodeID(link.source, id) == getNodeID(link.target, id);
                }

                function fillHeight(graph, y0, y1) {

                    var nodes = graph.nodes;
                    var links = graph.links;

                    var top = false;
                    var bottom = false;

                    links.forEach(function (link) {
                        if (link.circularLinkType == "top") {
                            top = true;
                        } else if (link.circularLinkType == "bottom") {
                            bottom = true;
                        }
                    });

                    if (top == false || bottom == false) {
                        var minY0 = d3Array.min(nodes, function (node) {
                            return node.y0;
                        });
                        var maxY1 = d3Array.max(nodes, function (node) {
                            return node.y1;
                        });
                        var currentHeight = maxY1 - minY0;
                        var chartHeight = y1 - y0;
                        var ratio = chartHeight / currentHeight;

                        nodes.forEach(function (node) {
                            var nodeHeight = (node.y1 - node.y0) * ratio;
                            node.y0 = (node.y0 - minY0) * ratio;
                            node.y1 = node.y0 + nodeHeight;
                        });

                        links.forEach(function (link) {
                            link.y0 = (link.y0 - minY0) * ratio;
                            link.y1 = (link.y1 - minY0) * ratio;
                            link.width = link.width * ratio;
                        });
                    }
                }

                exports.sankeyCircular = sankeyCircular;
                exports.sankeyCenter = center;
                exports.sankeyLeft = left;
                exports.sankeyRight = right;
                exports.sankeyJustify = justify;

                Object.defineProperty(exports, '__esModule', {value: true});

            })));

        }, {
            "d3-array": 107,
            "d3-collection": 108,
            "d3-shape": 119,
            "elementary-circuits-directed-graph": 130
        }],
        57: [function (_dereq_, module, exports) {
// https://github.com/d3/d3-sankey Version 0.7.2. Copyright 2019 Mike Bostock.
            (function (global, factory) {
                typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, _dereq_('d3-array'), _dereq_('d3-collection'), _dereq_('d3-shape')) :
                    typeof define === 'function' && define.amd ? define(['exports', 'd3-array', 'd3-collection', 'd3-shape'], factory) :
                        (factory((global.d3 = global.d3 || {}), global.d3, global.d3, global.d3));
            }(this, (function (exports, d3Array, d3Collection, d3Shape) {
                'use strict';

                function targetDepth(d) {
                    return d.target.depth;
                }

                function left(node) {
                    return node.depth;
                }

                function right(node, n) {
                    return n - 1 - node.height;
                }

                function justify(node, n) {
                    return node.sourceLinks.length ? node.depth : n - 1;
                }

                function center(node) {
                    return node.targetLinks.length ? node.depth
                        : node.sourceLinks.length ? d3Array.min(node.sourceLinks, targetDepth) - 1
                            : 0;
                }

                function constant(x) {
                    return function () {
                        return x;
                    };
                }

                function ascendingSourceBreadth(a, b) {
                    return ascendingBreadth(a.source, b.source) || a.index - b.index;
                }

                function ascendingTargetBreadth(a, b) {
                    return ascendingBreadth(a.target, b.target) || a.index - b.index;
                }

                function ascendingBreadth(a, b) {
                    return a.y0 - b.y0;
                }

                function value(d) {
                    return d.value;
                }

                function nodeCenter(node) {
                    return (node.y0 + node.y1) / 2;
                }

                function weightedSource(link) {
                    return nodeCenter(link.source) * link.value;
                }

                function weightedTarget(link) {
                    return nodeCenter(link.target) * link.value;
                }

                function defaultId(d) {
                    return d.index;
                }

                function defaultNodes(graph) {
                    return graph.nodes;
                }

                function defaultLinks(graph) {
                    return graph.links;
                }

                function find(nodeById, id) {
                    var node = nodeById.get(id);
                    if (!node) throw new Error("missing: " + id);
                    return node;
                }

                var sankey = function () {
                    var x0 = 0, y0 = 0, x1 = 1, y1 = 1, // extent
                        dx = 24, // nodeWidth
                        py = 8, // nodePadding
                        id = defaultId,
                        align = justify,
                        nodes = defaultNodes,
                        links = defaultLinks,
                        iterations = 32,
                        maxPaddedSpace = 2 / 3; // Defined as a fraction of the total available space

                    function sankey() {
                        var graph = {
                            nodes: nodes.apply(null, arguments),
                            links: links.apply(null, arguments)
                        };
                        computeNodeLinks(graph);
                        computeNodeValues(graph);
                        computeNodeDepths(graph);
                        computeNodeBreadths(graph, iterations);
                        computeLinkBreadths(graph);
                        return graph;
                    }

                    sankey.update = function (graph) {
                        computeLinkBreadths(graph);
                        return graph;
                    };

                    sankey.nodeId = function (_) {
                        return arguments.length ? (id = typeof _ === "function" ? _ : constant(_), sankey) : id;
                    };

                    sankey.nodeAlign = function (_) {
                        return arguments.length ? (align = typeof _ === "function" ? _ : constant(_), sankey) : align;
                    };

                    sankey.nodeWidth = function (_) {
                        return arguments.length ? (dx = +_, sankey) : dx;
                    };

                    sankey.nodePadding = function (_) {
                        return arguments.length ? (py = +_, sankey) : py;
                    };

                    sankey.nodes = function (_) {
                        return arguments.length ? (nodes = typeof _ === "function" ? _ : constant(_), sankey) : nodes;
                    };

                    sankey.links = function (_) {
                        return arguments.length ? (links = typeof _ === "function" ? _ : constant(_), sankey) : links;
                    };

                    sankey.size = function (_) {
                        return arguments.length ? (x0 = y0 = 0, x1 = +_[0], y1 = +_[1], sankey) : [x1 - x0, y1 - y0];
                    };

                    sankey.extent = function (_) {
                        return arguments.length ? (x0 = +_[0][0], x1 = +_[1][0], y0 = +_[0][1], y1 = +_[1][1], sankey) : [[x0, y0], [x1, y1]];
                    };

                    sankey.iterations = function (_) {
                        return arguments.length ? (iterations = +_, sankey) : iterations;
                    };

                    // Populate the sourceLinks and targetLinks for each node.
                    // Also, if the source and target are not objects, assume they are indices.
                    function computeNodeLinks(graph) {
                        graph.nodes.forEach(function (node, i) {
                            node.index = i;
                            node.sourceLinks = [];
                            node.targetLinks = [];
                        });

                        var nodeById = d3Collection.map(graph.nodes, id);
                        graph.links.forEach(function (link, i) {
                            link.index = i;
                            var source = link.source, target = link.target;
                            if (typeof source !== "object") source = link.source = find(nodeById, source);
                            if (typeof target !== "object") target = link.target = find(nodeById, target);
                            source.sourceLinks.push(link);
                            target.targetLinks.push(link);
                        });
                    }

                    // Compute the value (size) of each node by summing the associated links.
                    function computeNodeValues(graph) {
                        graph.nodes.forEach(function (node) {
                            node.value = Math.max(
                                d3Array.sum(node.sourceLinks, value),
                                d3Array.sum(node.targetLinks, value)
                            );
                        });
                    }

                    // Iteratively assign the depth (x-position) for each node.
                    // Nodes are assigned the maximum depth of incoming neighbors plus one;
                    // nodes with no incoming links are assigned depth zero, while
                    // nodes with no outgoing links are assigned the maximum depth.
                    function computeNodeDepths(graph) {
                        var nodes, next, x;

                        for (nodes = graph.nodes, next = [], x = 0; nodes.length; ++x, nodes = next, next = []) {
                            nodes.forEach(function (node) {
                                node.depth = x;
                                node.sourceLinks.forEach(function (link) {
                                    if (next.indexOf(link.target) < 0) {
                                        next.push(link.target);
                                    }
                                });
                            });
                        }

                        for (nodes = graph.nodes, next = [], x = 0; nodes.length; ++x, nodes = next, next = []) {
                            nodes.forEach(function (node) {
                                node.height = x;
                                node.targetLinks.forEach(function (link) {
                                    if (next.indexOf(link.source) < 0) {
                                        next.push(link.source);
                                    }
                                });
                            });
                        }

                        var kx = (x1 - x0 - dx) / (x - 1);
                        graph.nodes.forEach(function (node) {
                            node.x1 = (node.x0 = x0 + Math.max(0, Math.min(x - 1, Math.floor(align.call(null, node, x)))) * kx) + dx;
                        });
                    }

                    function computeNodeBreadths(graph) {
                        var columns = d3Collection.nest()
                            .key(function (d) {
                                return d.x0;
                            })
                            .sortKeys(d3Array.ascending)
                            .entries(graph.nodes)
                            .map(function (d) {
                                return d.values;
                            });

                        //
                        initializeNodeBreadth();
                        resolveCollisions();
                        for (var alpha = 1, n = iterations; n > 0; --n) {
                            relaxRightToLeft(alpha *= 0.99);
                            resolveCollisions();
                            relaxLeftToRight(alpha);
                            resolveCollisions();
                        }

                        function initializeNodeBreadth() {
                            var L = d3Array.max(columns, function (nodes) {
                                return nodes.length;
                            });
                            var maxNodePadding = maxPaddedSpace * (y1 - y0) / (L - 1);
                            if (py > maxNodePadding) py = maxNodePadding;
                            var ky = d3Array.min(columns, function (nodes) {
                                return (y1 - y0 - (nodes.length - 1) * py) / d3Array.sum(nodes, value);
                            });

                            columns.forEach(function (nodes) {
                                nodes.forEach(function (node, i) {
                                    node.y1 = (node.y0 = i) + node.value * ky;
                                });
                            });

                            graph.links.forEach(function (link) {
                                link.width = link.value * ky;
                            });
                        }

                        function relaxLeftToRight(alpha) {
                            columns.forEach(function (nodes) {
                                nodes.forEach(function (node) {
                                    if (node.targetLinks.length) {
                                        var dy = (d3Array.sum(node.targetLinks, weightedSource) / d3Array.sum(node.targetLinks, value) - nodeCenter(node)) * alpha;
                                        node.y0 += dy, node.y1 += dy;
                                    }
                                });
                            });
                        }

                        function relaxRightToLeft(alpha) {
                            columns.slice().reverse().forEach(function (nodes) {
                                nodes.forEach(function (node) {
                                    if (node.sourceLinks.length) {
                                        var dy = (d3Array.sum(node.sourceLinks, weightedTarget) / d3Array.sum(node.sourceLinks, value) - nodeCenter(node)) * alpha;
                                        node.y0 += dy, node.y1 += dy;
                                    }
                                });
                            });
                        }

                        function resolveCollisions() {
                            columns.forEach(function (nodes) {
                                var node,
                                    dy,
                                    y = y0,
                                    n = nodes.length,
                                    i;

                                // Push any overlapping nodes down.
                                nodes.sort(ascendingBreadth);
                                for (i = 0; i < n; ++i) {
                                    node = nodes[i];
                                    dy = y - node.y0;
                                    if (dy > 0) node.y0 += dy, node.y1 += dy;
                                    y = node.y1 + py;
                                }

                                // If the bottommost node goes outside the bounds, push it back up.
                                dy = y - py - y1;
                                if (dy > 0) {
                                    y = (node.y0 -= dy), node.y1 -= dy;

                                    // Push any overlapping nodes back up.
                                    for (i = n - 2; i >= 0; --i) {
                                        node = nodes[i];
                                        dy = node.y1 + py - y;
                                        if (dy > 0) node.y0 -= dy, node.y1 -= dy;
                                        y = node.y0;
                                    }
                                }
                            });
                        }
                    }

                    function computeLinkBreadths(graph) {
                        graph.nodes.forEach(function (node) {
                            node.sourceLinks.sort(ascendingTargetBreadth);
                            node.targetLinks.sort(ascendingSourceBreadth);
                        });
                        graph.nodes.forEach(function (node) {
                            var y0 = node.y0, y1 = y0;
                            node.sourceLinks.forEach(function (link) {
                                link.y0 = y0 + link.width / 2, y0 += link.width;
                            });
                            node.targetLinks.forEach(function (link) {
                                link.y1 = y1 + link.width / 2, y1 += link.width;
                            });
                        });
                    }

                    return sankey;
                };

                function horizontalSource(d) {
                    return [d.source.x1, d.y0];
                }

                function horizontalTarget(d) {
                    return [d.target.x0, d.y1];
                }

                var sankeyLinkHorizontal = function () {
                    return d3Shape.linkHorizontal()
                        .source(horizontalSource)
                        .target(horizontalTarget);
                };

                exports.sankey = sankey;
                exports.sankeyCenter = center;
                exports.sankeyLeft = left;
                exports.sankeyRight = right;
                exports.sankeyJustify = justify;
                exports.sankeyLinkHorizontal = sankeyLinkHorizontal;

                Object.defineProperty(exports, '__esModule', {value: true});

            })));

        }, {"d3-array": 107, "d3-collection": 108, "d3-shape": 119}],
        58: [function (_dereq_, module, exports) {
            !function () {
                var d3 = {
                    version: "3.8.0"
                };
                var d3_arraySlice = [].slice, d3_array = function (list) {
                    return d3_arraySlice.call(list);
                };
                var d3_document = self.document;

                function d3_documentElement(node) {
                    return node && (node.ownerDocument || node.document || node).documentElement;
                }

                function d3_window(node) {
                    return node && (node.ownerDocument && node.ownerDocument.defaultView || node.document && node || node.defaultView);
                }

                if (d3_document) {
                    try {
                        d3_array(d3_document.documentElement.childNodes)[0].nodeType;
                    } catch (e) {
                        d3_array = function (list) {
                            var i = list.length, array = new Array(i);
                            while (i--) array[i] = list[i];
                            return array;
                        };
                    }
                }
                if (!Date.now) Date.now = function () {
                    return +new Date();
                };
                if (d3_document) {
                    try {
                        d3_document.createElement("DIV").style.setProperty("opacity", 0, "");
                    } catch (error) {
                        var d3_element_prototype = this.Element.prototype,
                            d3_element_setAttribute = d3_element_prototype.setAttribute,
                            d3_element_setAttributeNS = d3_element_prototype.setAttributeNS,
                            d3_style_prototype = this.CSSStyleDeclaration.prototype,
                            d3_style_setProperty = d3_style_prototype.setProperty;
                        d3_element_prototype.setAttribute = function (name, value) {
                            d3_element_setAttribute.call(this, name, value + "");
                        };
                        d3_element_prototype.setAttributeNS = function (space, local, value) {
                            d3_element_setAttributeNS.call(this, space, local, value + "");
                        };
                        d3_style_prototype.setProperty = function (name, value, priority) {
                            d3_style_setProperty.call(this, name, value + "", priority);
                        };
                    }
                }
                d3.ascending = d3_ascending;

                function d3_ascending(a, b) {
                    return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
                }

                d3.descending = function (a, b) {
                    return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
                };
                d3.min = function (array, f) {
                    var i = -1, n = array.length, a, b;
                    if (arguments.length === 1) {
                        while (++i < n) if ((b = array[i]) != null && b >= b) {
                            a = b;
                            break;
                        }
                        while (++i < n) if ((b = array[i]) != null && a > b) a = b;
                    } else {
                        while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
                            a = b;
                            break;
                        }
                        while (++i < n) if ((b = f.call(array, array[i], i)) != null && a > b) a = b;
                    }
                    return a;
                };
                d3.max = function (array, f) {
                    var i = -1, n = array.length, a, b;
                    if (arguments.length === 1) {
                        while (++i < n) if ((b = array[i]) != null && b >= b) {
                            a = b;
                            break;
                        }
                        while (++i < n) if ((b = array[i]) != null && b > a) a = b;
                    } else {
                        while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
                            a = b;
                            break;
                        }
                        while (++i < n) if ((b = f.call(array, array[i], i)) != null && b > a) a = b;
                    }
                    return a;
                };
                d3.extent = function (array, f) {
                    var i = -1, n = array.length, a, b, c;
                    if (arguments.length === 1) {
                        while (++i < n) if ((b = array[i]) != null && b >= b) {
                            a = c = b;
                            break;
                        }
                        while (++i < n) if ((b = array[i]) != null) {
                            if (a > b) a = b;
                            if (c < b) c = b;
                        }
                    } else {
                        while (++i < n) if ((b = f.call(array, array[i], i)) != null && b >= b) {
                            a = c = b;
                            break;
                        }
                        while (++i < n) if ((b = f.call(array, array[i], i)) != null) {
                            if (a > b) a = b;
                            if (c < b) c = b;
                        }
                    }
                    return [a, c];
                };

                function d3_number(x) {
                    return x === null ? NaN : +x;
                }

                function d3_numeric(x) {
                    return !isNaN(x);
                }

                d3.sum = function (array, f) {
                    var s = 0, n = array.length, a, i = -1;
                    if (arguments.length === 1) {
                        while (++i < n) if (d3_numeric(a = +array[i])) s += a;
                    } else {
                        while (++i < n) if (d3_numeric(a = +f.call(array, array[i], i))) s += a;
                    }
                    return s;
                };
                d3.mean = function (array, f) {
                    var s = 0, n = array.length, a, i = -1, j = n;
                    if (arguments.length === 1) {
                        while (++i < n) if (d3_numeric(a = d3_number(array[i]))) s += a; else --j;
                    } else {
                        while (++i < n) if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) s += a; else --j;
                    }
                    if (j) return s / j;
                };
                d3.quantile = function (values, p) {
                    var H = (values.length - 1) * p + 1, h = Math.floor(H),
                        v = +values[h - 1], e = H - h;
                    return e ? v + e * (values[h] - v) : v;
                };
                d3.median = function (array, f) {
                    var numbers = [], n = array.length, a, i = -1;
                    if (arguments.length === 1) {
                        while (++i < n) if (d3_numeric(a = d3_number(array[i]))) numbers.push(a);
                    } else {
                        while (++i < n) if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) numbers.push(a);
                    }
                    if (numbers.length) return d3.quantile(numbers.sort(d3_ascending), .5);
                };
                d3.variance = function (array, f) {
                    var n = array.length, m = 0, a, d, s = 0, i = -1, j = 0;
                    if (arguments.length === 1) {
                        while (++i < n) {
                            if (d3_numeric(a = d3_number(array[i]))) {
                                d = a - m;
                                m += d / ++j;
                                s += d * (a - m);
                            }
                        }
                    } else {
                        while (++i < n) {
                            if (d3_numeric(a = d3_number(f.call(array, array[i], i)))) {
                                d = a - m;
                                m += d / ++j;
                                s += d * (a - m);
                            }
                        }
                    }
                    if (j > 1) return s / (j - 1);
                };
                d3.deviation = function () {
                    var v = d3.variance.apply(this, arguments);
                    return v ? Math.sqrt(v) : v;
                };

                function d3_bisector(compare) {
                    return {
                        left: function (a, x, lo, hi) {
                            if (arguments.length < 3) lo = 0;
                            if (arguments.length < 4) hi = a.length;
                            while (lo < hi) {
                                var mid = lo + hi >>> 1;
                                if (compare(a[mid], x) < 0) lo = mid + 1; else hi = mid;
                            }
                            return lo;
                        },
                        right: function (a, x, lo, hi) {
                            if (arguments.length < 3) lo = 0;
                            if (arguments.length < 4) hi = a.length;
                            while (lo < hi) {
                                var mid = lo + hi >>> 1;
                                if (compare(a[mid], x) > 0) hi = mid; else lo = mid + 1;
                            }
                            return lo;
                        }
                    };
                }

                var d3_bisect = d3_bisector(d3_ascending);
                d3.bisectLeft = d3_bisect.left;
                d3.bisect = d3.bisectRight = d3_bisect.right;
                d3.bisector = function (f) {
                    return d3_bisector(f.length === 1 ? function (d, x) {
                        return d3_ascending(f(d), x);
                    } : f);
                };
                d3.shuffle = function (array, i0, i1) {
                    if ((m = arguments.length) < 3) {
                        i1 = array.length;
                        if (m < 2) i0 = 0;
                    }
                    var m = i1 - i0, t, i;
                    while (m) {
                        i = Math.random() * m-- | 0;
                        t = array[m + i0], array[m + i0] = array[i + i0], array[i + i0] = t;
                    }
                    return array;
                };
                d3.permute = function (array, indexes) {
                    var i = indexes.length, permutes = new Array(i);
                    while (i--) permutes[i] = array[indexes[i]];
                    return permutes;
                };
                d3.pairs = function (array) {
                    var i = 0, n = array.length - 1, p0, p1 = array[0],
                        pairs = new Array(n < 0 ? 0 : n);
                    while (i < n) pairs[i] = [p0 = p1, p1 = array[++i]];
                    return pairs;
                };
                d3.transpose = function (matrix) {
                    if (!(n = matrix.length)) return [];
                    for (var i = -1, m = d3.min(matrix, d3_transposeLength), transpose = new Array(m); ++i < m;) {
                        for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n;) {
                            row[j] = matrix[j][i];
                        }
                    }
                    return transpose;
                };

                function d3_transposeLength(d) {
                    return d.length;
                }

                d3.zip = function () {
                    return d3.transpose(arguments);
                };
                d3.keys = function (map) {
                    var keys = [];
                    for (var key in map) keys.push(key);
                    return keys;
                };
                d3.values = function (map) {
                    var values = [];
                    for (var key in map) values.push(map[key]);
                    return values;
                };
                d3.entries = function (map) {
                    var entries = [];
                    for (var key in map) entries.push({
                        key: key,
                        value: map[key]
                    });
                    return entries;
                };
                d3.merge = function (arrays) {
                    var n = arrays.length, m, i = -1, j = 0, merged, array;
                    while (++i < n) j += arrays[i].length;
                    merged = new Array(j);
                    while (--n >= 0) {
                        array = arrays[n];
                        m = array.length;
                        while (--m >= 0) {
                            merged[--j] = array[m];
                        }
                    }
                    return merged;
                };
                var abs = Math.abs;
                d3.range = function (start, stop, step) {
                    if (arguments.length < 3) {
                        step = 1;
                        if (arguments.length < 2) {
                            stop = start;
                            start = 0;
                        }
                    }
                    if ((stop - start) / step === Infinity) throw new Error("infinite range");
                    var range = [], k = d3_range_integerScale(abs(step)),
                        i = -1, j;
                    start *= k, stop *= k, step *= k;
                    if (step < 0) while ((j = start + step * ++i) > stop) range.push(j / k); else while ((j = start + step * ++i) < stop) range.push(j / k);
                    return range;
                };

                function d3_range_integerScale(x) {
                    var k = 1;
                    while (x * k % 1) k *= 10;
                    return k;
                }

                function d3_class(ctor, properties) {
                    for (var key in properties) {
                        Object.defineProperty(ctor.prototype, key, {
                            value: properties[key],
                            enumerable: false
                        });
                    }
                }

                d3.map = function (object, f) {
                    var map = new d3_Map();
                    if (object instanceof d3_Map) {
                        object.forEach(function (key, value) {
                            map.set(key, value);
                        });
                    } else if (Array.isArray(object)) {
                        var i = -1, n = object.length, o;
                        if (arguments.length === 1) while (++i < n) map.set(i, object[i]); else while (++i < n) map.set(f.call(object, o = object[i], i), o);
                    } else {
                        for (var key in object) map.set(key, object[key]);
                    }
                    return map;
                };

                function d3_Map() {
                    this._ = Object.create(null);
                }

                var d3_map_proto = "__proto__", d3_map_zero = "\x00";
                d3_class(d3_Map, {
                    has: d3_map_has,
                    get: function (key) {
                        return this._[d3_map_escape(key)];
                    },
                    set: function (key, value) {
                        return this._[d3_map_escape(key)] = value;
                    },
                    remove: d3_map_remove,
                    keys: d3_map_keys,
                    values: function () {
                        var values = [];
                        for (var key in this._) values.push(this._[key]);
                        return values;
                    },
                    entries: function () {
                        var entries = [];
                        for (var key in this._) entries.push({
                            key: d3_map_unescape(key),
                            value: this._[key]
                        });
                        return entries;
                    },
                    size: d3_map_size,
                    empty: d3_map_empty,
                    forEach: function (f) {
                        for (var key in this._) f.call(this, d3_map_unescape(key), this._[key]);
                    }
                });

                function d3_map_escape(key) {
                    return (key += "") === d3_map_proto || key[0] === d3_map_zero ? d3_map_zero + key : key;
                }

                function d3_map_unescape(key) {
                    return (key += "")[0] === d3_map_zero ? key.slice(1) : key;
                }

                function d3_map_has(key) {
                    return d3_map_escape(key) in this._;
                }

                function d3_map_remove(key) {
                    return (key = d3_map_escape(key)) in this._ && delete this._[key];
                }

                function d3_map_keys() {
                    var keys = [];
                    for (var key in this._) keys.push(d3_map_unescape(key));
                    return keys;
                }

                function d3_map_size() {
                    var size = 0;
                    for (var key in this._) ++size;
                    return size;
                }

                function d3_map_empty() {
                    for (var key in this._) return false;
                    return true;
                }

                d3.nest = function () {
                    var nest = {}, keys = [], sortKeys = [], sortValues, rollup;

                    function map(mapType, array, depth) {
                        if (depth >= keys.length) return rollup ? rollup.call(nest, array) : sortValues ? array.sort(sortValues) : array;
                        var i = -1, n = array.length, key = keys[depth++],
                            keyValue, object, setter,
                            valuesByKey = new d3_Map(), values;
                        while (++i < n) {
                            if (values = valuesByKey.get(keyValue = key(object = array[i]))) {
                                values.push(object);
                            } else {
                                valuesByKey.set(keyValue, [object]);
                            }
                        }
                        if (mapType) {
                            object = mapType();
                            setter = function (keyValue, values) {
                                object.set(keyValue, map(mapType, values, depth));
                            };
                        } else {
                            object = {};
                            setter = function (keyValue, values) {
                                object[keyValue] = map(mapType, values, depth);
                            };
                        }
                        valuesByKey.forEach(setter);
                        return object;
                    }

                    function entries(map, depth) {
                        if (depth >= keys.length) return map;
                        var array = [], sortKey = sortKeys[depth++];
                        map.forEach(function (key, keyMap) {
                            array.push({
                                key: key,
                                values: entries(keyMap, depth)
                            });
                        });
                        return sortKey ? array.sort(function (a, b) {
                            return sortKey(a.key, b.key);
                        }) : array;
                    }

                    nest.map = function (array, mapType) {
                        return map(mapType, array, 0);
                    };
                    nest.entries = function (array) {
                        return entries(map(d3.map, array, 0), 0);
                    };
                    nest.key = function (d) {
                        keys.push(d);
                        return nest;
                    };
                    nest.sortKeys = function (order) {
                        sortKeys[keys.length - 1] = order;
                        return nest;
                    };
                    nest.sortValues = function (order) {
                        sortValues = order;
                        return nest;
                    };
                    nest.rollup = function (f) {
                        rollup = f;
                        return nest;
                    };
                    return nest;
                };
                d3.set = function (array) {
                    var set = new d3_Set();
                    if (array) for (var i = 0, n = array.length; i < n; ++i) set.add(array[i]);
                    return set;
                };

                function d3_Set() {
                    this._ = Object.create(null);
                }

                d3_class(d3_Set, {
                    has: d3_map_has,
                    add: function (key) {
                        this._[d3_map_escape(key += "")] = true;
                        return key;
                    },
                    remove: d3_map_remove,
                    values: d3_map_keys,
                    size: d3_map_size,
                    empty: d3_map_empty,
                    forEach: function (f) {
                        for (var key in this._) f.call(this, d3_map_unescape(key));
                    }
                });
                d3.behavior = {};

                function d3_identity(d) {
                    return d;
                }

                d3.rebind = function (target, source) {
                    var i = 1, n = arguments.length, method;
                    while (++i < n) target[method = arguments[i]] = d3_rebind(target, source, source[method]);
                    return target;
                };

                function d3_rebind(target, source, method) {
                    return function () {
                        var value = method.apply(source, arguments);
                        return value === source ? target : value;
                    };
                }

                function d3_vendorSymbol(object, name) {
                    if (name in object) return name;
                    name = name.charAt(0).toUpperCase() + name.slice(1);
                    for (var i = 0, n = d3_vendorPrefixes.length; i < n; ++i) {
                        var prefixName = d3_vendorPrefixes[i] + name;
                        if (prefixName in object) return prefixName;
                    }
                }

                var d3_vendorPrefixes = ["webkit", "ms", "moz", "Moz", "o", "O"];

                function d3_noop() {
                }

                d3.dispatch = function () {
                    var dispatch = new d3_dispatch(), i = -1,
                        n = arguments.length;
                    while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);
                    return dispatch;
                };

                function d3_dispatch() {
                }

                d3_dispatch.prototype.on = function (type, listener) {
                    var i = type.indexOf("."), name = "";
                    if (i >= 0) {
                        name = type.slice(i + 1);
                        type = type.slice(0, i);
                    }
                    if (type) return arguments.length < 2 ? this[type].on(name) : this[type].on(name, listener);
                    if (arguments.length === 2) {
                        if (listener == null) for (type in this) {
                            if (this.hasOwnProperty(type)) this[type].on(name, null);
                        }
                        return this;
                    }
                };

                function d3_dispatch_event(dispatch) {
                    var listeners = [], listenerByName = new d3_Map();

                    function event() {
                        var z = listeners, i = -1, n = z.length, l;
                        while (++i < n) if (l = z[i].on) l.apply(this, arguments);
                        return dispatch;
                    }

                    event.on = function (name, listener) {
                        var l = listenerByName.get(name), i;
                        if (arguments.length < 2) return l && l.on;
                        if (l) {
                            l.on = null;
                            listeners = listeners.slice(0, i = listeners.indexOf(l)).concat(listeners.slice(i + 1));
                            listenerByName.remove(name);
                        }
                        if (listener) listeners.push(listenerByName.set(name, {
                            on: listener
                        }));
                        return dispatch;
                    };
                    return event;
                }

                d3.event = null;

                function d3_eventPreventDefault() {
                    d3.event.preventDefault();
                }

                function d3_eventSource() {
                    var e = d3.event, s;
                    while (s = e.sourceEvent) e = s;
                    return e;
                }

                function d3_eventDispatch(target) {
                    var dispatch = new d3_dispatch(), i = 0,
                        n = arguments.length;
                    while (++i < n) dispatch[arguments[i]] = d3_dispatch_event(dispatch);
                    dispatch.of = function (thiz, argumentz) {
                        return function (e1) {
                            try {
                                var e0 = e1.sourceEvent = d3.event;
                                e1.target = target;
                                d3.event = e1;
                                dispatch[e1.type].apply(thiz, argumentz);
                            } finally {
                                d3.event = e0;
                            }
                        };
                    };
                    return dispatch;
                }

                d3.requote = function (s) {
                    return s.replace(d3_requote_re, "\\$&");
                };
                var d3_requote_re = /[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;
                var d3_subclass = {}.__proto__ ? function (object, prototype) {
                    object.__proto__ = prototype;
                } : function (object, prototype) {
                    for (var property in prototype) object[property] = prototype[property];
                };

                function d3_selection(groups) {
                    d3_subclass(groups, d3_selectionPrototype);
                    return groups;
                }

                var d3_select = function (s, n) {
                    return n.querySelector(s);
                }, d3_selectAll = function (s, n) {
                    return n.querySelectorAll(s);
                }, d3_selectMatches = function (n, s) {
                    var d3_selectMatcher = n.matches || n[d3_vendorSymbol(n, "matchesSelector")];
                    d3_selectMatches = function (n, s) {
                        return d3_selectMatcher.call(n, s);
                    };
                    return d3_selectMatches(n, s);
                };
                if (typeof Sizzle === "function") {
                    d3_select = function (s, n) {
                        return Sizzle(s, n)[0] || null;
                    };
                    d3_selectAll = Sizzle;
                    d3_selectMatches = Sizzle.matchesSelector;
                }
                d3.selection = function () {
                    return d3.select(d3_document.documentElement);
                };
                var d3_selectionPrototype = d3.selection.prototype = [];
                d3_selectionPrototype.select = function (selector) {
                    var subgroups = [], subgroup, subnode, group, node;
                    selector = d3_selection_selector(selector);
                    for (var j = -1, m = this.length; ++j < m;) {
                        subgroups.push(subgroup = []);
                        subgroup.parentNode = (group = this[j]).parentNode;
                        for (var i = -1, n = group.length; ++i < n;) {
                            if (node = group[i]) {
                                subgroup.push(subnode = selector.call(node, node.__data__, i, j));
                                if (subnode && "__data__" in node) subnode.__data__ = node.__data__;
                            } else {
                                subgroup.push(null);
                            }
                        }
                    }
                    return d3_selection(subgroups);
                };

                function d3_selection_selector(selector) {
                    return typeof selector === "function" ? selector : function () {
                        return d3_select(selector, this);
                    };
                }

                d3_selectionPrototype.selectAll = function (selector) {
                    var subgroups = [], subgroup, node;
                    selector = d3_selection_selectorAll(selector);
                    for (var j = -1, m = this.length; ++j < m;) {
                        for (var group = this[j], i = -1, n = group.length; ++i < n;) {
                            if (node = group[i]) {
                                subgroups.push(subgroup = d3_array(selector.call(node, node.__data__, i, j)));
                                subgroup.parentNode = node;
                            }
                        }
                    }
                    return d3_selection(subgroups);
                };

                function d3_selection_selectorAll(selector) {
                    return typeof selector === "function" ? selector : function () {
                        return d3_selectAll(selector, this);
                    };
                }

                var d3_nsXhtml = "http://www.w3.org/1999/xhtml";
                var d3_nsPrefix = {
                    svg: "http://www.w3.org/2000/svg",
                    xhtml: d3_nsXhtml,
                    xlink: "http://www.w3.org/1999/xlink",
                    xml: "http://www.w3.org/XML/1998/namespace",
                    xmlns: "http://www.w3.org/2000/xmlns/"
                };
                d3.ns = {
                    prefix: d3_nsPrefix,
                    qualify: function (name) {
                        var i = name.indexOf(":"), prefix = name;
                        if (i >= 0 && (prefix = name.slice(0, i)) !== "xmlns") name = name.slice(i + 1);
                        return d3_nsPrefix.hasOwnProperty(prefix) ? {
                            space: d3_nsPrefix[prefix],
                            local: name
                        } : name;
                    }
                };
                d3_selectionPrototype.attr = function (name, value) {
                    if (arguments.length < 2) {
                        if (typeof name === "string") {
                            var node = this.node();
                            name = d3.ns.qualify(name);
                            return name.local ? node.getAttributeNS(name.space, name.local) : node.getAttribute(name);
                        }
                        for (value in name) this.each(d3_selection_attr(value, name[value]));
                        return this;
                    }
                    return this.each(d3_selection_attr(name, value));
                };

                function d3_selection_attr(name, value) {
                    name = d3.ns.qualify(name);

                    function attrNull() {
                        this.removeAttribute(name);
                    }

                    function attrNullNS() {
                        this.removeAttributeNS(name.space, name.local);
                    }

                    function attrConstant() {
                        this.setAttribute(name, value);
                    }

                    function attrConstantNS() {
                        this.setAttributeNS(name.space, name.local, value);
                    }

                    function attrFunction() {
                        var x = value.apply(this, arguments);
                        if (x == null) this.removeAttribute(name); else this.setAttribute(name, x);
                    }

                    function attrFunctionNS() {
                        var x = value.apply(this, arguments);
                        if (x == null) this.removeAttributeNS(name.space, name.local); else this.setAttributeNS(name.space, name.local, x);
                    }

                    return value == null ? name.local ? attrNullNS : attrNull : typeof value === "function" ? name.local ? attrFunctionNS : attrFunction : name.local ? attrConstantNS : attrConstant;
                }

                function d3_collapse(s) {
                    return s.trim().replace(/\s+/g, " ");
                }

                d3_selectionPrototype.classed = function (name, value) {
                    if (arguments.length < 2) {
                        if (typeof name === "string") {
                            var node = this.node(),
                                n = (name = d3_selection_classes(name)).length,
                                i = -1;
                            if (value = node.classList) {
                                while (++i < n) if (!value.contains(name[i])) return false;
                            } else {
                                value = node.getAttribute("class");
                                while (++i < n) if (!d3_selection_classedRe(name[i]).test(value)) return false;
                            }
                            return true;
                        }
                        for (value in name) this.each(d3_selection_classed(value, name[value]));
                        return this;
                    }
                    return this.each(d3_selection_classed(name, value));
                };

                function d3_selection_classedRe(name) {
                    return new RegExp("(?:^|\\s+)" + d3.requote(name) + "(?:\\s+|$)", "g");
                }

                function d3_selection_classes(name) {
                    return (name + "").trim().split(/^|\s+/);
                }

                function d3_selection_classed(name, value) {
                    name = d3_selection_classes(name).map(d3_selection_classedName);
                    var n = name.length;

                    function classedConstant() {
                        var i = -1;
                        while (++i < n) name[i](this, value);
                    }

                    function classedFunction() {
                        var i = -1, x = value.apply(this, arguments);
                        while (++i < n) name[i](this, x);
                    }

                    return typeof value === "function" ? classedFunction : classedConstant;
                }

                function d3_selection_classedName(name) {
                    var re = d3_selection_classedRe(name);
                    return function (node, value) {
                        if (c = node.classList) return value ? c.add(name) : c.remove(name);
                        var c = node.getAttribute("class") || "";
                        if (value) {
                            re.lastIndex = 0;
                            if (!re.test(c)) node.setAttribute("class", d3_collapse(c + " " + name));
                        } else {
                            node.setAttribute("class", d3_collapse(c.replace(re, " ")));
                        }
                    };
                }

                d3_selectionPrototype.style = function (name, value, priority) {
                    var n = arguments.length;
                    if (n < 3) {
                        if (typeof name !== "string") {
                            if (n < 2) value = "";
                            for (priority in name) this.each(d3_selection_style(priority, name[priority], value));
                            return this;
                        }
                        if (n < 2) {
                            var node = this.node();
                            return d3_window(node).getComputedStyle(node, null).getPropertyValue(name);
                        }
                        priority = "";
                    }
                    return this.each(d3_selection_style(name, value, priority));
                };

                function d3_selection_style(name, value, priority) {
                    function styleNull() {
                        this.style.removeProperty(name);
                    }

                    function styleConstant() {
                        this.style.setProperty(name, value, priority);
                    }

                    function styleFunction() {
                        var x = value.apply(this, arguments);
                        if (x == null) this.style.removeProperty(name); else this.style.setProperty(name, x, priority);
                    }

                    return value == null ? styleNull : typeof value === "function" ? styleFunction : styleConstant;
                }

                d3_selectionPrototype.property = function (name, value) {
                    if (arguments.length < 2) {
                        if (typeof name === "string") return this.node()[name];
                        for (value in name) this.each(d3_selection_property(value, name[value]));
                        return this;
                    }
                    return this.each(d3_selection_property(name, value));
                };

                function d3_selection_property(name, value) {
                    function propertyNull() {
                        delete this[name];
                    }

                    function propertyConstant() {
                        this[name] = value;
                    }

                    function propertyFunction() {
                        var x = value.apply(this, arguments);
                        if (x == null) delete this[name]; else this[name] = x;
                    }

                    return value == null ? propertyNull : typeof value === "function" ? propertyFunction : propertyConstant;
                }

                d3_selectionPrototype.text = function (value) {
                    return arguments.length ? this.each(typeof value === "function" ? function () {
                        var v = value.apply(this, arguments);
                        this.textContent = v == null ? "" : v;
                    } : value == null ? function () {
                        this.textContent = "";
                    } : function () {
                        this.textContent = value;
                    }) : this.node().textContent;
                };
                d3_selectionPrototype.html = function (value) {
                    return arguments.length ? this.each(typeof value === "function" ? function () {
                        var v = value.apply(this, arguments);
                        this.innerHTML = v == null ? "" : v;
                    } : value == null ? function () {
                        this.innerHTML = "";
                    } : function () {
                        this.innerHTML = value;
                    }) : this.node().innerHTML;
                };
                d3_selectionPrototype.append = function (name) {
                    name = d3_selection_creator(name);
                    return this.select(function () {
                        return this.appendChild(name.apply(this, arguments));
                    });
                };

                function d3_selection_creator(name) {
                    function create() {
                        var document = this.ownerDocument,
                            namespace = this.namespaceURI;
                        return namespace === d3_nsXhtml && document.documentElement.namespaceURI === d3_nsXhtml ? document.createElement(name) : document.createElementNS(namespace, name);
                    }

                    function createNS() {
                        return this.ownerDocument.createElementNS(name.space, name.local);
                    }

                    return typeof name === "function" ? name : (name = d3.ns.qualify(name)).local ? createNS : create;
                }

                d3_selectionPrototype.insert = function (name, before) {
                    name = d3_selection_creator(name);
                    before = d3_selection_selector(before);
                    return this.select(function () {
                        return this.insertBefore(name.apply(this, arguments), before.apply(this, arguments) || null);
                    });
                };
                d3_selectionPrototype.remove = function () {
                    return this.each(d3_selectionRemove);
                };

                function d3_selectionRemove() {
                    var parent = this.parentNode;
                    if (parent) parent.removeChild(this);
                }

                d3_selectionPrototype.data = function (value, key) {
                    var i = -1, n = this.length, group, node;
                    if (!arguments.length) {
                        value = new Array(n = (group = this[0]).length);
                        while (++i < n) {
                            if (node = group[i]) {
                                value[i] = node.__data__;
                            }
                        }
                        return value;
                    }

                    function bind(group, groupData) {
                        var i, n = group.length, m = groupData.length,
                            n0 = Math.min(n, m), updateNodes = new Array(m),
                            enterNodes = new Array(m), exitNodes = new Array(n),
                            node, nodeData;
                        if (key) {
                            var nodeByKeyValue = new d3_Map(),
                                keyValues = new Array(n), keyValue;
                            for (i = -1; ++i < n;) {
                                if (node = group[i]) {
                                    if (nodeByKeyValue.has(keyValue = key.call(node, node.__data__, i))) {
                                        exitNodes[i] = node;
                                    } else {
                                        nodeByKeyValue.set(keyValue, node);
                                    }
                                    keyValues[i] = keyValue;
                                }
                            }
                            for (i = -1; ++i < m;) {
                                if (!(node = nodeByKeyValue.get(keyValue = key.call(groupData, nodeData = groupData[i], i)))) {
                                    enterNodes[i] = d3_selection_dataNode(nodeData);
                                } else if (node !== true) {
                                    updateNodes[i] = node;
                                    node.__data__ = nodeData;
                                }
                                nodeByKeyValue.set(keyValue, true);
                            }
                            for (i = -1; ++i < n;) {
                                if (i in keyValues && nodeByKeyValue.get(keyValues[i]) !== true) {
                                    exitNodes[i] = group[i];
                                }
                            }
                        } else {
                            for (i = -1; ++i < n0;) {
                                node = group[i];
                                nodeData = groupData[i];
                                if (node) {
                                    node.__data__ = nodeData;
                                    updateNodes[i] = node;
                                } else {
                                    enterNodes[i] = d3_selection_dataNode(nodeData);
                                }
                            }
                            for (; i < m; ++i) {
                                enterNodes[i] = d3_selection_dataNode(groupData[i]);
                            }
                            for (; i < n; ++i) {
                                exitNodes[i] = group[i];
                            }
                        }
                        enterNodes.update = updateNodes;
                        enterNodes.parentNode = updateNodes.parentNode = exitNodes.parentNode = group.parentNode;
                        enter.push(enterNodes);
                        update.push(updateNodes);
                        exit.push(exitNodes);
                    }

                    var enter = d3_selection_enter([]),
                        update = d3_selection([]), exit = d3_selection([]);
                    if (typeof value === "function") {
                        while (++i < n) {
                            bind(group = this[i], value.call(group, group.parentNode.__data__, i));
                        }
                    } else {
                        while (++i < n) {
                            bind(group = this[i], value);
                        }
                    }
                    update.enter = function () {
                        return enter;
                    };
                    update.exit = function () {
                        return exit;
                    };
                    return update;
                };

                function d3_selection_dataNode(data) {
                    return {
                        __data__: data
                    };
                }

                d3_selectionPrototype.datum = function (value) {
                    return arguments.length ? this.property("__data__", value) : this.property("__data__");
                };
                d3_selectionPrototype.filter = function (filter) {
                    var subgroups = [], subgroup, group, node;
                    if (typeof filter !== "function") filter = d3_selection_filter(filter);
                    for (var j = 0, m = this.length; j < m; j++) {
                        subgroups.push(subgroup = []);
                        subgroup.parentNode = (group = this[j]).parentNode;
                        for (var i = 0, n = group.length; i < n; i++) {
                            if ((node = group[i]) && filter.call(node, node.__data__, i, j)) {
                                subgroup.push(node);
                            }
                        }
                    }
                    return d3_selection(subgroups);
                };

                function d3_selection_filter(selector) {
                    return function () {
                        return d3_selectMatches(this, selector);
                    };
                }

                d3_selectionPrototype.order = function () {
                    for (var j = -1, m = this.length; ++j < m;) {
                        for (var group = this[j], i = group.length - 1, next = group[i], node; --i >= 0;) {
                            if (node = group[i]) {
                                if (next && next !== node.nextSibling) next.parentNode.insertBefore(node, next);
                                next = node;
                            }
                        }
                    }
                    return this;
                };
                d3_selectionPrototype.sort = function (comparator) {
                    comparator = d3_selection_sortComparator.apply(this, arguments);
                    for (var j = -1, m = this.length; ++j < m;) this[j].sort(comparator);
                    return this.order();
                };

                function d3_selection_sortComparator(comparator) {
                    if (!arguments.length) comparator = d3_ascending;
                    return function (a, b) {
                        return a && b ? comparator(a.__data__, b.__data__) : !a - !b;
                    };
                }

                d3_selectionPrototype.each = function (callback) {
                    return d3_selection_each(this, function (node, i, j) {
                        callback.call(node, node.__data__, i, j);
                    });
                };

                function d3_selection_each(groups, callback) {
                    for (var j = 0, m = groups.length; j < m; j++) {
                        for (var group = groups[j], i = 0, n = group.length, node; i < n; i++) {
                            if (node = group[i]) callback(node, i, j);
                        }
                    }
                    return groups;
                }

                d3_selectionPrototype.call = function (callback) {
                    var args = d3_array(arguments);
                    callback.apply(args[0] = this, args);
                    return this;
                };
                d3_selectionPrototype.empty = function () {
                    return !this.node();
                };
                d3_selectionPrototype.node = function () {
                    for (var j = 0, m = this.length; j < m; j++) {
                        for (var group = this[j], i = 0, n = group.length; i < n; i++) {
                            var node = group[i];
                            if (node) return node;
                        }
                    }
                    return null;
                };
                d3_selectionPrototype.size = function () {
                    var n = 0;
                    d3_selection_each(this, function () {
                        ++n;
                    });
                    return n;
                };

                function d3_selection_enter(selection) {
                    d3_subclass(selection, d3_selection_enterPrototype);
                    return selection;
                }

                var d3_selection_enterPrototype = [];
                d3.selection.enter = d3_selection_enter;
                d3.selection.enter.prototype = d3_selection_enterPrototype;
                d3_selection_enterPrototype.append = d3_selectionPrototype.append;
                d3_selection_enterPrototype.empty = d3_selectionPrototype.empty;
                d3_selection_enterPrototype.node = d3_selectionPrototype.node;
                d3_selection_enterPrototype.call = d3_selectionPrototype.call;
                d3_selection_enterPrototype.size = d3_selectionPrototype.size;
                d3_selection_enterPrototype.select = function (selector) {
                    var subgroups = [], subgroup, subnode, upgroup, group, node;
                    for (var j = -1, m = this.length; ++j < m;) {
                        upgroup = (group = this[j]).update;
                        subgroups.push(subgroup = []);
                        subgroup.parentNode = group.parentNode;
                        for (var i = -1, n = group.length; ++i < n;) {
                            if (node = group[i]) {
                                subgroup.push(upgroup[i] = subnode = selector.call(group.parentNode, node.__data__, i, j));
                                subnode.__data__ = node.__data__;
                            } else {
                                subgroup.push(null);
                            }
                        }
                    }
                    return d3_selection(subgroups);
                };
                d3_selection_enterPrototype.insert = function (name, before) {
                    if (arguments.length < 2) before = d3_selection_enterInsertBefore(this);
                    return d3_selectionPrototype.insert.call(this, name, before);
                };

                function d3_selection_enterInsertBefore(enter) {
                    var i0, j0;
                    return function (d, i, j) {
                        var group = enter[j].update, n = group.length, node;
                        if (j != j0) j0 = j, i0 = 0;
                        if (i >= i0) i0 = i + 1;
                        while (!(node = group[i0]) && ++i0 < n) ;
                        return node;
                    };
                }

                d3.select = function (node) {
                    var group;
                    if (typeof node === "string") {
                        group = [d3_select(node, d3_document)];
                        group.parentNode = d3_document.documentElement;
                    } else {
                        group = [node];
                        group.parentNode = d3_documentElement(node);
                    }
                    return d3_selection([group]);
                };
                d3.selectAll = function (nodes) {
                    var group;
                    if (typeof nodes === "string") {
                        group = d3_array(d3_selectAll(nodes, d3_document));
                        group.parentNode = d3_document.documentElement;
                    } else {
                        group = d3_array(nodes);
                        group.parentNode = null;
                    }
                    return d3_selection([group]);
                };
                d3_selectionPrototype.on = function (type, listener, capture) {
                    var n = arguments.length;
                    if (n < 3) {
                        if (typeof type !== "string") {
                            if (n < 2) listener = false;
                            for (capture in type) this.each(d3_selection_on(capture, type[capture], listener));
                            return this;
                        }
                        if (n < 2) return (n = this.node()["__on" + type]) && n._;
                        capture = false;
                    }
                    return this.each(d3_selection_on(type, listener, capture));
                };

                function d3_selection_on(type, listener, capture) {
                    var name = "__on" + type, i = type.indexOf("."),
                        wrap = d3_selection_onListener;
                    if (i > 0) type = type.slice(0, i);
                    var filter = d3_selection_onFilters.get(type);
                    if (filter) type = filter, wrap = d3_selection_onFilter;

                    function onRemove() {
                        var l = this[name];
                        if (l) {
                            this.removeEventListener(type, l, l.$);
                            delete this[name];
                        }
                    }

                    function onAdd() {
                        var l = wrap(listener, d3_array(arguments));
                        onRemove.call(this);
                        this.addEventListener(type, this[name] = l, l.$ = capture);
                        l._ = listener;
                    }

                    function removeAll() {
                        var re = new RegExp("^__on([^.]+)" + d3.requote(type) + "$"),
                            match;
                        for (var name in this) {
                            if (match = name.match(re)) {
                                var l = this[name];
                                this.removeEventListener(match[1], l, l.$);
                                delete this[name];
                            }
                        }
                    }

                    return i ? listener ? onAdd : onRemove : listener ? d3_noop : removeAll;
                }

                var d3_selection_onFilters = d3.map({
                    mouseenter: "mouseover",
                    mouseleave: "mouseout"
                });
                if (d3_document) {
                    d3_selection_onFilters.forEach(function (k) {
                        if ("on" + k in d3_document) d3_selection_onFilters.remove(k);
                    });
                }

                function d3_selection_onListener(listener, argumentz) {
                    return function (e) {
                        var o = d3.event;
                        d3.event = e;
                        argumentz[0] = this.__data__;
                        try {
                            listener.apply(this, argumentz);
                        } finally {
                            d3.event = o;
                        }
                    };
                }

                function d3_selection_onFilter(listener, argumentz) {
                    var l = d3_selection_onListener(listener, argumentz);
                    return function (e) {
                        var target = this, related = e.relatedTarget;
                        if (!related || related !== target && !(related.compareDocumentPosition(target) & 8)) {
                            l.call(target, e);
                        }
                    };
                }

                var d3_event_dragSelect, d3_event_dragId = 0;

                function d3_event_dragSuppress(node) {
                    var name = ".dragsuppress-" + ++d3_event_dragId,
                        click = "click" + name,
                        w = d3.select(d3_window(node)).on("touchmove" + name, d3_eventPreventDefault).on("dragstart" + name, d3_eventPreventDefault).on("selectstart" + name, d3_eventPreventDefault);
                    if (d3_event_dragSelect == null) {
                        d3_event_dragSelect = "onselectstart" in node ? false : d3_vendorSymbol(node.style, "userSelect");
                    }
                    if (d3_event_dragSelect) {
                        var style = d3_documentElement(node).style,
                            select = style[d3_event_dragSelect];
                        style[d3_event_dragSelect] = "none";
                    }
                    return function (suppressClick) {
                        w.on(name, null);
                        if (d3_event_dragSelect) style[d3_event_dragSelect] = select;
                        if (suppressClick) {
                            var off = function () {
                                w.on(click, null);
                            };
                            w.on(click, function () {
                                d3_eventPreventDefault();
                                off();
                            }, true);
                            setTimeout(off, 0);
                        }
                    };
                }

                d3.mouse = function (container) {
                    return d3_mousePoint(container, d3_eventSource());
                };
                var d3_mouse_bug44083 = this.navigator && /WebKit/.test(this.navigator.userAgent) ? -1 : 0;

                function d3_mousePoint(container, e) {
                    if (e.changedTouches) e = e.changedTouches[0];
                    var svg = container.ownerSVGElement || container;
                    if (svg.createSVGPoint) {
                        var point = svg.createSVGPoint();
                        if (d3_mouse_bug44083 < 0) {
                            var window = d3_window(container);
                            if (window.scrollX || window.scrollY) {
                                svg = d3.select("body").append("svg").style({
                                    position: "absolute",
                                    top: 0,
                                    left: 0,
                                    margin: 0,
                                    padding: 0,
                                    border: "none"
                                }, "important");
                                var ctm = svg[0][0].getScreenCTM();
                                d3_mouse_bug44083 = !(ctm.f || ctm.e);
                                svg.remove();
                            }
                        }
                        if (d3_mouse_bug44083) point.x = e.pageX, point.y = e.pageY; else point.x = e.clientX,
                            point.y = e.clientY;
                        point = point.matrixTransform(container.getScreenCTM().inverse());
                        return [point.x, point.y];
                    }
                    var rect = container.getBoundingClientRect();
                    return [e.clientX - rect.left - container.clientLeft, e.clientY - rect.top - container.clientTop];
                }

                d3.touch = function (container, touches, identifier) {
                    if (arguments.length < 3) identifier = touches, touches = d3_eventSource().changedTouches;
                    if (touches) for (var i = 0, n = touches.length, touch; i < n; ++i) {
                        if ((touch = touches[i]).identifier === identifier) {
                            return d3_mousePoint(container, touch);
                        }
                    }
                };
                d3.behavior.drag = function () {
                    var event = d3_eventDispatch(drag, "drag", "dragstart", "dragend"),
                        origin = null,
                        mousedown = dragstart(d3_noop, d3.mouse, d3_window, "mousemove", "mouseup"),
                        touchstart = dragstart(d3_behavior_dragTouchId, d3.touch, d3_identity, "touchmove", "touchend");

                    function drag() {
                        this.on("mousedown.drag", mousedown).on("touchstart.drag", touchstart);
                    }

                    function dragstart(id, position, subject, move, end) {
                        return function () {
                            var that = this,
                                target = d3.event.target.correspondingElement || d3.event.target,
                                parent = that.parentNode,
                                dispatch = event.of(that, arguments),
                                dragged = 0, dragId = id(),
                                dragName = ".drag" + (dragId == null ? "" : "-" + dragId),
                                dragOffset,
                                dragSubject = d3.select(subject(target)).on(move + dragName, moved).on(end + dragName, ended),
                                dragRestore = d3_event_dragSuppress(target),
                                position0 = position(parent, dragId);
                            if (origin) {
                                dragOffset = origin.apply(that, arguments);
                                dragOffset = [dragOffset.x - position0[0], dragOffset.y - position0[1]];
                            } else {
                                dragOffset = [0, 0];
                            }
                            dispatch({
                                type: "dragstart"
                            });

                            function moved() {
                                var position1 = position(parent, dragId), dx,
                                    dy;
                                if (!position1) return;
                                dx = position1[0] - position0[0];
                                dy = position1[1] - position0[1];
                                dragged |= dx | dy;
                                position0 = position1;
                                dispatch({
                                    type: "drag",
                                    x: position1[0] + dragOffset[0],
                                    y: position1[1] + dragOffset[1],
                                    dx: dx,
                                    dy: dy
                                });
                            }

                            function ended() {
                                if (!position(parent, dragId)) return;
                                dragSubject.on(move + dragName, null).on(end + dragName, null);
                                dragRestore(dragged);
                                dispatch({
                                    type: "dragend"
                                });
                            }
                        };
                    }

                    drag.origin = function (x) {
                        if (!arguments.length) return origin;
                        origin = x;
                        return drag;
                    };
                    return d3.rebind(drag, event, "on");
                };

                function d3_behavior_dragTouchId() {
                    return d3.event.changedTouches[0].identifier;
                }

                d3.touches = function (container, touches) {
                    if (arguments.length < 2) touches = d3_eventSource().touches;
                    return touches ? d3_array(touches).map(function (touch) {
                        var point = d3_mousePoint(container, touch);
                        point.identifier = touch.identifier;
                        return point;
                    }) : [];
                };
                var Îµ = 1e-6, Îµ2 = Îµ * Îµ, Ï€ = Math.PI,
                    Ï„ = 2 * Ï€, Ï„Îµ = Ï„ -Îµ, halfÏ€ = Ï€ / 2, d3_radians = Ï€ / 180, d3_degrees = 180 / Ï€;

                function d3_sgn(x) {
                    return x > 0 ? 1 : x < 0 ? -1 : 0;
                }

                function d3_cross2d(a, b, c) {
                    return (b[0] - a[0]) * (c[1] - a[1]) - (b[1] - a[1]) * (c[0] - a[0]);
                }

                function d3_acos(x) {
                    return x > 1 ? 0 : x < -1 ? Ï€ : Math.acos(x);
                }

                function d3_asin(x) {
                    return x > 1 ? halfÏ€ : x < -1 ? -halfÏ€ : Math.asin(x);
                }

                function d3_sinh(x) {
                    return ((x = Math.exp(x)) - 1 / x) / 2;
                }

                function d3_cosh(x) {
                    return ((x = Math.exp(x)) + 1 / x) / 2;
                }

                function d3_tanh(x) {
                    return ((x = Math.exp(2 * x)) - 1) / (x + 1);
                }

                function d3_haversin(x) {
                    return (x = Math.sin(x / 2)) * x;
                }

                var Ï = Math.SQRT2, Ï2 = 2, Ï4 = 4;
                d3.interpolateZoom = function (p0, p1) {
                    var ux0 = p0[0], uy0 = p0[1], w0 = p0[2], ux1 = p1[0],
                        uy1 = p1[1], w1 = p1[2], dx = ux1 - ux0, dy = uy1 - uy0,
                        d2 = dx * dx + dy * dy, i, S;
                    if (d2 < Îµ2) {
                        S = Math.log(w1 / w0) / Ï;
                        i = function (t) {
                            return [ux0 + t * dx, uy0 + t * dy, w0 * Math.exp(Ï * t * S)];
                        };
                    } else {
                        var d1 = Math.sqrt(d2),
                            b0 = (w1 * w1 - w0 * w0 + Ï4 * d2) / (2 * w0 * Ï2 * d1),
                            b1 = (w1 * w1 - w0 * w0 - Ï4 * d2) / (2 * w1 * Ï2 * d1),
                            r0 = Math.log(Math.sqrt(b0 * b0 + 1) - b0),
                            r1 = Math.log(Math.sqrt(b1 * b1 + 1) - b1);
                        S = (r1 - r0) / Ï;
                        i = function (t) {
                            var s = t * S, coshr0 = d3_cosh(r0),
                                u = w0 / (Ï2 * d1) * (coshr0 * d3_tanh(Ï * s + r0) - d3_sinh(r0));
                            return [ux0 + u * dx, uy0 + u * dy, w0 * coshr0 / d3_cosh(Ï * s + r0)];
                        };
                    }
                    i.duration = S * 1e3;
                    return i;
                };
                d3.behavior.zoom = function () {
                    var view = {
                            x: 0,
                            y: 0,
                            k: 1
                        }, translate0, center0, center, size = [960, 500],
                        scaleExtent = d3_behavior_zoomInfinity, duration = 250,
                        zooming = 0, mousedown = "mousedown.zoom",
                        mousemove = "mousemove.zoom", mouseup = "mouseup.zoom",
                        mousewheelTimer, touchstart = "touchstart.zoom",
                        touchtime,
                        event = d3_eventDispatch(zoom, "zoomstart", "zoom", "zoomend"),
                        x0, x1, y0, y1;
                    if (!d3_behavior_zoomWheel) {
                        d3_behavior_zoomWheel = "onwheel" in d3_document ? (d3_behavior_zoomDelta = function () {
                            return -d3.event.deltaY * (d3.event.deltaMode ? 120 : 1);
                        }, "wheel") : "onmousewheel" in d3_document ? (d3_behavior_zoomDelta = function () {
                            return d3.event.wheelDelta;
                        }, "mousewheel") : (d3_behavior_zoomDelta = function () {
                            return -d3.event.detail;
                        }, "MozMousePixelScroll");
                    }

                    function zoom(g) {
                        g.on(mousedown, mousedowned).on(d3_behavior_zoomWheel + ".zoom", mousewheeled).on("dblclick.zoom", dblclicked).on(touchstart, touchstarted);
                    }

                    zoom.event = function (g) {
                        g.each(function () {
                            var dispatch = event.of(this, arguments),
                                view1 = view;
                            if (d3_transitionInheritId) {
                                d3.select(this).transition().each("start.zoom", function () {
                                    view = this.__chart__ || {
                                        x: 0,
                                        y: 0,
                                        k: 1
                                    };
                                    zoomstarted(dispatch);
                                }).tween("zoom:zoom", function () {
                                    var dx = size[0], dy = size[1],
                                        cx = center0 ? center0[0] : dx / 2,
                                        cy = center0 ? center0[1] : dy / 2,
                                        i = d3.interpolateZoom([(cx - view.x) / view.k, (cy - view.y) / view.k, dx / view.k], [(cx - view1.x) / view1.k, (cy - view1.y) / view1.k, dx / view1.k]);
                                    return function (t) {
                                        var l = i(t), k = dx / l[2];
                                        this.__chart__ = view = {
                                            x: cx - l[0] * k,
                                            y: cy - l[1] * k,
                                            k: k
                                        };
                                        zoomed(dispatch);
                                    };
                                }).each("interrupt.zoom", function () {
                                    zoomended(dispatch);
                                }).each("end.zoom", function () {
                                    zoomended(dispatch);
                                });
                            } else {
                                this.__chart__ = view;
                                zoomstarted(dispatch);
                                zoomed(dispatch);
                                zoomended(dispatch);
                            }
                        });
                    };
                    zoom.translate = function (_) {
                        if (!arguments.length) return [view.x, view.y];
                        view = {
                            x: +_[0],
                            y: +_[1],
                            k: view.k
                        };
                        rescale();
                        return zoom;
                    };
                    zoom.scale = function (_) {
                        if (!arguments.length) return view.k;
                        view = {
                            x: view.x,
                            y: view.y,
                            k: null
                        };
                        scaleTo(+_);
                        rescale();
                        return zoom;
                    };
                    zoom.scaleExtent = function (_) {
                        if (!arguments.length) return scaleExtent;
                        scaleExtent = _ == null ? d3_behavior_zoomInfinity : [+_[0], +_[1]];
                        return zoom;
                    };
                    zoom.center = function (_) {
                        if (!arguments.length) return center;
                        center = _ && [+_[0], +_[1]];
                        return zoom;
                    };
                    zoom.size = function (_) {
                        if (!arguments.length) return size;
                        size = _ && [+_[0], +_[1]];
                        return zoom;
                    };
                    zoom.duration = function (_) {
                        if (!arguments.length) return duration;
                        duration = +_;
                        return zoom;
                    };
                    zoom.x = function (z) {
                        if (!arguments.length) return x1;
                        x1 = z;
                        x0 = z.copy();
                        view = {
                            x: 0,
                            y: 0,
                            k: 1
                        };
                        return zoom;
                    };
                    zoom.y = function (z) {
                        if (!arguments.length) return y1;
                        y1 = z;
                        y0 = z.copy();
                        view = {
                            x: 0,
                            y: 0,
                            k: 1
                        };
                        return zoom;
                    };

                    function location(p) {
                        return [(p[0] - view.x) / view.k, (p[1] - view.y) / view.k];
                    }

                    function point(l) {
                        return [l[0] * view.k + view.x, l[1] * view.k + view.y];
                    }

                    function scaleTo(s) {
                        view.k = Math.max(scaleExtent[0], Math.min(scaleExtent[1], s));
                    }

                    function translateTo(p, l) {
                        l = point(l);
                        view.x += p[0] - l[0];
                        view.y += p[1] - l[1];
                    }

                    function zoomTo(that, p, l, k) {
                        that.__chart__ = {
                            x: view.x,
                            y: view.y,
                            k: view.k
                        };
                        scaleTo(Math.pow(2, k));
                        translateTo(center0 = p, l);
                        that = d3.select(that);
                        if (duration > 0) that = that.transition().duration(duration);
                        that.call(zoom.event);
                    }

                    function rescale() {
                        if (x1) x1.domain(x0.range().map(function (x) {
                            return (x - view.x) / view.k;
                        }).map(x0.invert));
                        if (y1) y1.domain(y0.range().map(function (y) {
                            return (y - view.y) / view.k;
                        }).map(y0.invert));
                    }

                    function zoomstarted(dispatch) {
                        if (!zooming++) dispatch({
                            type: "zoomstart"
                        });
                    }

                    function zoomed(dispatch) {
                        rescale();
                        dispatch({
                            type: "zoom",
                            scale: view.k,
                            translate: [view.x, view.y]
                        });
                    }

                    function zoomended(dispatch) {
                        if (!--zooming) dispatch({
                            type: "zoomend"
                        }), center0 = null;
                    }

                    function mousedowned() {
                        var that = this, dispatch = event.of(that, arguments),
                            dragged = 0,
                            subject = d3.select(d3_window(that)).on(mousemove, moved).on(mouseup, ended),
                            location0 = location(d3.mouse(that)),
                            dragRestore = d3_event_dragSuppress(that);
                        d3_selection_interrupt.call(that);
                        zoomstarted(dispatch);

                        function moved() {
                            dragged = 1;
                            translateTo(d3.mouse(that), location0);
                            zoomed(dispatch);
                        }

                        function ended() {
                            subject.on(mousemove, null).on(mouseup, null);
                            dragRestore(dragged);
                            zoomended(dispatch);
                        }
                    }

                    function touchstarted() {
                        var that = this, dispatch = event.of(that, arguments),
                            locations0 = {}, distance0 = 0, scale0,
                            zoomName = ".zoom-" + d3.event.changedTouches[0].identifier,
                            touchmove = "touchmove" + zoomName,
                            touchend = "touchend" + zoomName, targets = [],
                            subject = d3.select(that),
                            dragRestore = d3_event_dragSuppress(that);
                        started();
                        zoomstarted(dispatch);
                        subject.on(mousedown, null).on(touchstart, started);

                        function relocate() {
                            var touches = d3.touches(that);
                            scale0 = view.k;
                            touches.forEach(function (t) {
                                if (t.identifier in locations0) locations0[t.identifier] = location(t);
                            });
                            return touches;
                        }

                        function started() {
                            var target = d3.event.target;
                            d3.select(target).on(touchmove, moved).on(touchend, ended);
                            targets.push(target);
                            var changed = d3.event.changedTouches;
                            for (var i = 0, n = changed.length; i < n; ++i) {
                                locations0[changed[i].identifier] = null;
                            }
                            var touches = relocate(), now = Date.now();
                            if (touches.length === 1) {
                                if (now - touchtime < 500) {
                                    var p = touches[0];
                                    zoomTo(that, p, locations0[p.identifier], Math.floor(Math.log(view.k) / Math.LN2) + 1);
                                    d3_eventPreventDefault();
                                }
                                touchtime = now;
                            } else if (touches.length > 1) {
                                var p = touches[0], q = touches[1],
                                    dx = p[0] - q[0], dy = p[1] - q[1];
                                distance0 = dx * dx + dy * dy;
                            }
                        }

                        function moved() {
                            var touches = d3.touches(that), p0, l0, p1, l1;
                            d3_selection_interrupt.call(that);
                            for (var i = 0, n = touches.length; i < n; ++i, l1 = null) {
                                p1 = touches[i];
                                if (l1 = locations0[p1.identifier]) {
                                    if (l0) break;
                                    p0 = p1, l0 = l1;
                                }
                            }
                            if (l1) {
                                var distance1 = (distance1 = p1[0] - p0[0]) * distance1 + (distance1 = p1[1] - p0[1]) * distance1,
                                    scale1 = distance0 && Math.sqrt(distance1 / distance0);
                                p0 = [(p0[0] + p1[0]) / 2, (p0[1] + p1[1]) / 2];
                                l0 = [(l0[0] + l1[0]) / 2, (l0[1] + l1[1]) / 2];
                                scaleTo(scale1 * scale0);
                            }
                            touchtime = null;
                            translateTo(p0, l0);
                            zoomed(dispatch);
                        }

                        function ended() {
                            if (d3.event.touches.length) {
                                var changed = d3.event.changedTouches;
                                for (var i = 0, n = changed.length; i < n; ++i) {
                                    delete locations0[changed[i].identifier];
                                }
                                for (var identifier in locations0) {
                                    return void relocate();
                                }
                            }
                            d3.selectAll(targets).on(zoomName, null);
                            subject.on(mousedown, mousedowned).on(touchstart, touchstarted);
                            dragRestore();
                            zoomended(dispatch);
                        }
                    }

                    function mousewheeled() {
                        var dispatch = event.of(this, arguments);
                        if (mousewheelTimer) clearTimeout(mousewheelTimer); else d3_selection_interrupt.call(this),
                            translate0 = location(center0 = center || d3.mouse(this)), zoomstarted(dispatch);
                        mousewheelTimer = setTimeout(function () {
                            mousewheelTimer = null;
                            zoomended(dispatch);
                        }, 50);
                        d3_eventPreventDefault();
                        scaleTo(Math.pow(2, d3_behavior_zoomDelta() * .002) * view.k);
                        translateTo(center0, translate0);
                        zoomed(dispatch);
                    }

                    function dblclicked() {
                        var p = d3.mouse(this), k = Math.log(view.k) / Math.LN2;
                        zoomTo(this, p, location(p), d3.event.shiftKey ? Math.ceil(k) - 1 : Math.floor(k) + 1);
                    }

                    return d3.rebind(zoom, event, "on");
                };
                var d3_behavior_zoomInfinity = [0, Infinity],
                    d3_behavior_zoomDelta, d3_behavior_zoomWheel;
                d3.color = d3_color;

                function d3_color() {
                }

                d3_color.prototype.toString = function () {
                    return this.rgb() + "";
                };
                d3.hsl = d3_hsl;

                function d3_hsl(h, s, l) {
                    return this instanceof d3_hsl ? void (this.h = +h, this.s = +s, this.l = +l) : arguments.length < 2 ? h instanceof d3_hsl ? new d3_hsl(h.h, h.s, h.l) : d3_rgb_parse("" + h, d3_rgb_hsl, d3_hsl) : new d3_hsl(h, s, l);
                }

                var d3_hslPrototype = d3_hsl.prototype = new d3_color();
                d3_hslPrototype.brighter = function (k) {
                    k = Math.pow(.7, arguments.length ? k : 1);
                    return new d3_hsl(this.h, this.s, this.l / k);
                };
                d3_hslPrototype.darker = function (k) {
                    k = Math.pow(.7, arguments.length ? k : 1);
                    return new d3_hsl(this.h, this.s, k * this.l);
                };
                d3_hslPrototype.rgb = function () {
                    return d3_hsl_rgb(this.h, this.s, this.l);
                };

                function d3_hsl_rgb(h, s, l) {
                    var m1, m2;
                    h = isNaN(h) ? 0 : (h %= 360) < 0 ? h + 360 : h;
                    s = isNaN(s) ? 0 : s < 0 ? 0 : s > 1 ? 1 : s;
                    l = l < 0 ? 0 : l > 1 ? 1 : l;
                    m2 = l <= .5 ? l * (1 + s) : l + s - l * s;
                    m1 = 2 * l - m2;

                    function v(h) {
                        if (h > 360) h -= 360; else if (h < 0) h += 360;
                        if (h < 60) return m1 + (m2 - m1) * h / 60;
                        if (h < 180) return m2;
                        if (h < 240) return m1 + (m2 - m1) * (240 - h) / 60;
                        return m1;
                    }

                    function vv(h) {
                        return Math.round(v(h) * 255);
                    }

                    return new d3_rgb(vv(h + 120), vv(h), vv(h - 120));
                }

                d3.hcl = d3_hcl;

                function d3_hcl(h, c, l) {
                    return this instanceof d3_hcl ? void (this.h = +h, this.c = +c, this.l = +l) : arguments.length < 2 ? h instanceof d3_hcl ? new d3_hcl(h.h, h.c, h.l) : h instanceof d3_lab ? d3_lab_hcl(h.l, h.a, h.b) : d3_lab_hcl((h = d3_rgb_lab((h = d3.rgb(h)).r, h.g, h.b)).l, h.a, h.b) : new d3_hcl(h, c, l);
                }

                var d3_hclPrototype = d3_hcl.prototype = new d3_color();
                d3_hclPrototype.brighter = function (k) {
                    return new d3_hcl(this.h, this.c, Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)));
                };
                d3_hclPrototype.darker = function (k) {
                    return new d3_hcl(this.h, this.c, Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)));
                };
                d3_hclPrototype.rgb = function () {
                    return d3_hcl_lab(this.h, this.c, this.l).rgb();
                };

                function d3_hcl_lab(h, c, l) {
                    if (isNaN(h)) h = 0;
                    if (isNaN(c)) c = 0;
                    return new d3_lab(l, Math.cos(h *= d3_radians) * c, Math.sin(h) * c);
                }

                d3.lab = d3_lab;

                function d3_lab(l, a, b) {
                    return this instanceof d3_lab ? void (this.l = +l, this.a = +a, this.b = +b) : arguments.length < 2 ? l instanceof d3_lab ? new d3_lab(l.l, l.a, l.b) : l instanceof d3_hcl ? d3_hcl_lab(l.h, l.c, l.l) : d3_rgb_lab((l = d3_rgb(l)).r, l.g, l.b) : new d3_lab(l, a, b);
                }

                var d3_lab_K = 18;
                var d3_lab_X = .95047, d3_lab_Y = 1, d3_lab_Z = 1.08883;
                var d3_labPrototype = d3_lab.prototype = new d3_color();
                d3_labPrototype.brighter = function (k) {
                    return new d3_lab(Math.min(100, this.l + d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);
                };
                d3_labPrototype.darker = function (k) {
                    return new d3_lab(Math.max(0, this.l - d3_lab_K * (arguments.length ? k : 1)), this.a, this.b);
                };
                d3_labPrototype.rgb = function () {
                    return d3_lab_rgb(this.l, this.a, this.b);
                };

                function d3_lab_rgb(l, a, b) {
                    var y = (l + 16) / 116, x = y + a / 500, z = y - b / 200;
                    x = d3_lab_xyz(x) * d3_lab_X;
                    y = d3_lab_xyz(y) * d3_lab_Y;
                    z = d3_lab_xyz(z) * d3_lab_Z;
                    return new d3_rgb(d3_xyz_rgb(3.2404542 * x - 1.5371385 * y - .4985314 * z), d3_xyz_rgb(-.969266 * x + 1.8760108 * y + .041556 * z), d3_xyz_rgb(.0556434 * x - .2040259 * y + 1.0572252 * z));
                }

                function d3_lab_hcl(l, a, b) {
                    return l > 0 ? new d3_hcl(Math.atan2(b, a) * d3_degrees, Math.sqrt(a * a + b * b), l) : new d3_hcl(NaN, NaN, l);
                }

                function d3_lab_xyz(x) {
                    return x > .206893034 ? x * x * x : (x - 4 / 29) / 7.787037;
                }

                function d3_xyz_lab(x) {
                    return x > .008856 ? Math.pow(x, 1 / 3) : 7.787037 * x + 4 / 29;
                }

                function d3_xyz_rgb(r) {
                    return Math.round(255 * (r <= .00304 ? 12.92 * r : 1.055 * Math.pow(r, 1 / 2.4) - .055));
                }

                d3.rgb = d3_rgb;

                function d3_rgb(r, g, b) {
                    return this instanceof d3_rgb ? void (this.r = ~~r, this.g = ~~g, this.b = ~~b) : arguments.length < 2 ? r instanceof d3_rgb ? new d3_rgb(r.r, r.g, r.b) : d3_rgb_parse("" + r, d3_rgb, d3_hsl_rgb) : new d3_rgb(r, g, b);
                }

                function d3_rgbNumber(value) {
                    return new d3_rgb(value >> 16, value >> 8 & 255, value & 255);
                }

                function d3_rgbString(value) {
                    return d3_rgbNumber(value) + "";
                }

                var d3_rgbPrototype = d3_rgb.prototype = new d3_color();
                d3_rgbPrototype.brighter = function (k) {
                    k = Math.pow(.7, arguments.length ? k : 1);
                    var r = this.r, g = this.g, b = this.b, i = 30;
                    if (!r && !g && !b) return new d3_rgb(i, i, i);
                    if (r && r < i) r = i;
                    if (g && g < i) g = i;
                    if (b && b < i) b = i;
                    return new d3_rgb(Math.min(255, r / k), Math.min(255, g / k), Math.min(255, b / k));
                };
                d3_rgbPrototype.darker = function (k) {
                    k = Math.pow(.7, arguments.length ? k : 1);
                    return new d3_rgb(k * this.r, k * this.g, k * this.b);
                };
                d3_rgbPrototype.hsl = function () {
                    return d3_rgb_hsl(this.r, this.g, this.b);
                };
                d3_rgbPrototype.toString = function () {
                    return "#" + d3_rgb_hex(this.r) + d3_rgb_hex(this.g) + d3_rgb_hex(this.b);
                };

                function d3_rgb_hex(v) {
                    return v < 16 ? "0" + Math.max(0, v).toString(16) : Math.min(255, v).toString(16);
                }

                function d3_rgb_parse(format, rgb, hsl) {
                    var r = 0, g = 0, b = 0, m1, m2, color;
                    m1 = /([a-z]+)\((.*)\)/.exec(format = format.toLowerCase());
                    if (m1) {
                        m2 = m1[2].split(",");
                        switch (m1[1]) {
                            case "hsl": {
                                return hsl(parseFloat(m2[0]), parseFloat(m2[1]) / 100, parseFloat(m2[2]) / 100);
                            }

                            case "rgb": {
                                return rgb(d3_rgb_parseNumber(m2[0]), d3_rgb_parseNumber(m2[1]), d3_rgb_parseNumber(m2[2]));
                            }
                        }
                    }
                    if (color = d3_rgb_names.get(format)) {
                        return rgb(color.r, color.g, color.b);
                    }
                    if (format != null && format.charAt(0) === "#" && !isNaN(color = parseInt(format.slice(1), 16))) {
                        if (format.length === 4) {
                            r = (color & 3840) >> 4;
                            r = r >> 4 | r;
                            g = color & 240;
                            g = g >> 4 | g;
                            b = color & 15;
                            b = b << 4 | b;
                        } else if (format.length === 7) {
                            r = (color & 16711680) >> 16;
                            g = (color & 65280) >> 8;
                            b = color & 255;
                        }
                    }
                    return rgb(r, g, b);
                }

                function d3_rgb_hsl(r, g, b) {
                    var min = Math.min(r /= 255, g /= 255, b /= 255),
                        max = Math.max(r, g, b), d = max - min, h, s,
                        l = (max + min) / 2;
                    if (d) {
                        s = l < .5 ? d / (max + min) : d / (2 - max - min);
                        if (r == max) h = (g - b) / d + (g < b ? 6 : 0); else if (g == max) h = (b - r) / d + 2; else h = (r - g) / d + 4;
                        h *= 60;
                    } else {
                        h = NaN;
                        s = l > 0 && l < 1 ? 0 : h;
                    }
                    return new d3_hsl(h, s, l);
                }

                function d3_rgb_lab(r, g, b) {
                    r = d3_rgb_xyz(r);
                    g = d3_rgb_xyz(g);
                    b = d3_rgb_xyz(b);
                    var x = d3_xyz_lab((.4124564 * r + .3575761 * g + .1804375 * b) / d3_lab_X),
                        y = d3_xyz_lab((.2126729 * r + .7151522 * g + .072175 * b) / d3_lab_Y),
                        z = d3_xyz_lab((.0193339 * r + .119192 * g + .9503041 * b) / d3_lab_Z);
                    return d3_lab(116 * y - 16, 500 * (x - y), 200 * (y - z));
                }

                function d3_rgb_xyz(r) {
                    return (r /= 255) <= .04045 ? r / 12.92 : Math.pow((r + .055) / 1.055, 2.4);
                }

                function d3_rgb_parseNumber(c) {
                    var f = parseFloat(c);
                    return c.charAt(c.length - 1) === "%" ? Math.round(f * 2.55) : f;
                }

                var d3_rgb_names = d3.map({
                    aliceblue: 15792383,
                    antiquewhite: 16444375,
                    aqua: 65535,
                    aquamarine: 8388564,
                    azure: 15794175,
                    beige: 16119260,
                    bisque: 16770244,
                    black: 0,
                    blanchedalmond: 16772045,
                    blue: 255,
                    blueviolet: 9055202,
                    brown: 10824234,
                    burlywood: 14596231,
                    cadetblue: 6266528,
                    chartreuse: 8388352,
                    chocolate: 13789470,
                    coral: 16744272,
                    cornflowerblue: 6591981,
                    cornsilk: 16775388,
                    crimson: 14423100,
                    cyan: 65535,
                    darkblue: 139,
                    darkcyan: 35723,
                    darkgoldenrod: 12092939,
                    darkgray: 11119017,
                    darkgreen: 25600,
                    darkgrey: 11119017,
                    darkkhaki: 12433259,
                    darkmagenta: 9109643,
                    darkolivegreen: 5597999,
                    darkorange: 16747520,
                    darkorchid: 10040012,
                    darkred: 9109504,
                    darksalmon: 15308410,
                    darkseagreen: 9419919,
                    darkslateblue: 4734347,
                    darkslategray: 3100495,
                    darkslategrey: 3100495,
                    darkturquoise: 52945,
                    darkviolet: 9699539,
                    deeppink: 16716947,
                    deepskyblue: 49151,
                    dimgray: 6908265,
                    dimgrey: 6908265,
                    dodgerblue: 2003199,
                    firebrick: 11674146,
                    floralwhite: 16775920,
                    forestgreen: 2263842,
                    fuchsia: 16711935,
                    gainsboro: 14474460,
                    ghostwhite: 16316671,
                    gold: 16766720,
                    goldenrod: 14329120,
                    gray: 8421504,
                    green: 32768,
                    greenyellow: 11403055,
                    grey: 8421504,
                    honeydew: 15794160,
                    hotpink: 16738740,
                    indianred: 13458524,
                    indigo: 4915330,
                    ivory: 16777200,
                    khaki: 15787660,
                    lavender: 15132410,
                    lavenderblush: 16773365,
                    lawngreen: 8190976,
                    lemonchiffon: 16775885,
                    lightblue: 11393254,
                    lightcoral: 15761536,
                    lightcyan: 14745599,
                    lightgoldenrodyellow: 16448210,
                    lightgray: 13882323,
                    lightgreen: 9498256,
                    lightgrey: 13882323,
                    lightpink: 16758465,
                    lightsalmon: 16752762,
                    lightseagreen: 2142890,
                    lightskyblue: 8900346,
                    lightslategray: 7833753,
                    lightslategrey: 7833753,
                    lightsteelblue: 11584734,
                    lightyellow: 16777184,
                    lime: 65280,
                    limegreen: 3329330,
                    linen: 16445670,
                    magenta: 16711935,
                    maroon: 8388608,
                    mediumaquamarine: 6737322,
                    mediumblue: 205,
                    mediumorchid: 12211667,
                    mediumpurple: 9662683,
                    mediumseagreen: 3978097,
                    mediumslateblue: 8087790,
                    mediumspringgreen: 64154,
                    mediumturquoise: 4772300,
                    mediumvioletred: 13047173,
                    midnightblue: 1644912,
                    mintcream: 16121850,
                    mistyrose: 16770273,
                    moccasin: 16770229,
                    navajowhite: 16768685,
                    navy: 128,
                    oldlace: 16643558,
                    olive: 8421376,
                    olivedrab: 7048739,
                    orange: 16753920,
                    orangered: 16729344,
                    orchid: 14315734,
                    palegoldenrod: 15657130,
                    palegreen: 10025880,
                    paleturquoise: 11529966,
                    palevioletred: 14381203,
                    papayawhip: 16773077,
                    peachpuff: 16767673,
                    peru: 13468991,
                    pink: 16761035,
                    plum: 14524637,
                    powderblue: 11591910,
                    purple: 8388736,
                    rebeccapurple: 6697881,
                    red: 16711680,
                    rosybrown: 12357519,
                    royalblue: 4286945,
                    saddlebrown: 9127187,
                    salmon: 16416882,
                    sandybrown: 16032864,
                    seagreen: 3050327,
                    seashell: 16774638,
                    sienna: 10506797,
                    silver: 12632256,
                    skyblue: 8900331,
                    slateblue: 6970061,
                    slategray: 7372944,
                    slategrey: 7372944,
                    snow: 16775930,
                    springgreen: 65407,
                    steelblue: 4620980,
                    tan: 13808780,
                    teal: 32896,
                    thistle: 14204888,
                    tomato: 16737095,
                    turquoise: 4251856,
                    violet: 15631086,
                    wheat: 16113331,
                    white: 16777215,
                    whitesmoke: 16119285,
                    yellow: 16776960,
                    yellowgreen: 10145074
                });
                d3_rgb_names.forEach(function (key, value) {
                    d3_rgb_names.set(key, d3_rgbNumber(value));
                });

                function d3_functor(v) {
                    return typeof v === "function" ? v : function () {
                        return v;
                    };
                }

                d3.functor = d3_functor;
                d3.xhr = d3_xhrType(d3_identity);

                function d3_xhrType(response) {
                    return function (url, mimeType, callback) {
                        if (arguments.length === 2 && typeof mimeType === "function") callback = mimeType,
                            mimeType = null;
                        return d3_xhr(url, mimeType, response, callback);
                    };
                }

                function d3_xhr(url, mimeType, response, callback) {
                    var xhr = {},
                        dispatch = d3.dispatch("beforesend", "progress", "load", "error"),
                        headers = {}, request = new XMLHttpRequest(),
                        responseType = null;
                    if (self.XDomainRequest && !("withCredentials" in request) && /^(http(s)?:)?\/\//.test(url)) request = new XDomainRequest();
                    "onload" in request ? request.onload = request.onerror = respond : request.onreadystatechange = function () {
                        request.readyState > 3 && respond();
                    };

                    function respond() {
                        var status = request.status, result;
                        if (!status && d3_xhrHasResponse(request) || status >= 200 && status < 300 || status === 304) {
                            try {
                                result = response.call(xhr, request);
                            } catch (e) {
                                dispatch.error.call(xhr, e);
                                return;
                            }
                            dispatch.load.call(xhr, result);
                        } else {
                            dispatch.error.call(xhr, request);
                        }
                    }

                    request.onprogress = function (event) {
                        var o = d3.event;
                        d3.event = event;
                        try {
                            dispatch.progress.call(xhr, request);
                        } finally {
                            d3.event = o;
                        }
                    };
                    xhr.header = function (name, value) {
                        name = (name + "").toLowerCase();
                        if (arguments.length < 2) return headers[name];
                        if (value == null) delete headers[name]; else headers[name] = value + "";
                        return xhr;
                    };
                    xhr.mimeType = function (value) {
                        if (!arguments.length) return mimeType;
                        mimeType = value == null ? null : value + "";
                        return xhr;
                    };
                    xhr.responseType = function (value) {
                        if (!arguments.length) return responseType;
                        responseType = value;
                        return xhr;
                    };
                    xhr.response = function (value) {
                        response = value;
                        return xhr;
                    };
                    ["get", "post"].forEach(function (method) {
                        xhr[method] = function () {
                            return xhr.send.apply(xhr, [method].concat(d3_array(arguments)));
                        };
                    });
                    xhr.send = function (method, data, callback) {
                        if (arguments.length === 2 && typeof data === "function") callback = data, data = null;
                        request.open(method, url, true);
                        if (mimeType != null && !("accept" in headers)) headers["accept"] = mimeType + ",*/*";
                        if (request.setRequestHeader) for (var name in headers) request.setRequestHeader(name, headers[name]);
                        if (mimeType != null && request.overrideMimeType) request.overrideMimeType(mimeType);
                        if (responseType != null) request.responseType = responseType;
                        if (callback != null) xhr.on("error", callback).on("load", function (request) {
                            callback(null, request);
                        });
                        dispatch.beforesend.call(xhr, request);
                        request.send(data == null ? null : data);
                        return xhr;
                    };
                    xhr.abort = function () {
                        request.abort();
                        return xhr;
                    };
                    d3.rebind(xhr, dispatch, "on");
                    return callback == null ? xhr : xhr.get(d3_xhr_fixCallback(callback));
                }

                function d3_xhr_fixCallback(callback) {
                    return callback.length === 1 ? function (error, request) {
                        callback(error == null ? request : null);
                    } : callback;
                }

                function d3_xhrHasResponse(request) {
                    var type = request.responseType;
                    return type && type !== "text" ? request.response : request.responseText;
                }

                d3.dsv = function (delimiter, mimeType) {
                    var reFormat = new RegExp('["' + delimiter + "\n]"),
                        delimiterCode = delimiter.charCodeAt(0);

                    function dsv(url, row, callback) {
                        if (arguments.length < 3) callback = row, row = null;
                        var xhr = d3_xhr(url, mimeType, row == null ? response : typedResponse(row), callback);
                        xhr.row = function (_) {
                            return arguments.length ? xhr.response((row = _) == null ? response : typedResponse(_)) : row;
                        };
                        return xhr;
                    }

                    function response(request) {
                        return dsv.parse(request.responseText);
                    }

                    function typedResponse(f) {
                        return function (request) {
                            return dsv.parse(request.responseText, f);
                        };
                    }

                    dsv.parse = function (text, f) {
                        var o;
                        return dsv.parseRows(text, function (row, i) {
                            if (o) return o(row, i - 1);
                            var a = function (d) {
                                var obj = {};
                                var len = row.length;
                                for (var k = 0; k < len; ++k) {
                                    obj[row[k]] = d[k];
                                }
                                return obj;
                            };
                            o = f ? function (row, i) {
                                return f(a(row), i);
                            } : a;
                        });
                    };
                    dsv.parseRows = function (text, f) {
                        var EOL = {}, EOF = {}, rows = [], N = text.length,
                            I = 0, n = 0, t, eol;

                        function token() {
                            if (I >= N) return EOF;
                            if (eol) return eol = false, EOL;
                            var j = I;
                            if (text.charCodeAt(j) === 34) {
                                var i = j;
                                while (i++ < N) {
                                    if (text.charCodeAt(i) === 34) {
                                        if (text.charCodeAt(i + 1) !== 34) break;
                                        ++i;
                                    }
                                }
                                I = i + 2;
                                var c = text.charCodeAt(i + 1);
                                if (c === 13) {
                                    eol = true;
                                    if (text.charCodeAt(i + 2) === 10) ++I;
                                } else if (c === 10) {
                                    eol = true;
                                }
                                return text.slice(j + 1, i).replace(/""/g, '"');
                            }
                            while (I < N) {
                                var c = text.charCodeAt(I++), k = 1;
                                if (c === 10) eol = true; else if (c === 13) {
                                    eol = true;
                                    if (text.charCodeAt(I) === 10) ++I, ++k;
                                } else if (c !== delimiterCode) continue;
                                return text.slice(j, I - k);
                            }
                            return text.slice(j);
                        }

                        while ((t = token()) !== EOF) {
                            var a = [];
                            while (t !== EOL && t !== EOF) {
                                a.push(t);
                                t = token();
                            }
                            if (f && (a = f(a, n++)) == null) continue;
                            rows.push(a);
                        }
                        return rows;
                    };
                    dsv.format = function (rows) {
                        if (Array.isArray(rows[0])) return dsv.formatRows(rows);
                        var fieldSet = new d3_Set(), fields = [];
                        rows.forEach(function (row) {
                            for (var field in row) {
                                if (!fieldSet.has(field)) {
                                    fields.push(fieldSet.add(field));
                                }
                            }
                        });
                        return [fields.map(formatValue).join(delimiter)].concat(rows.map(function (row) {
                            return fields.map(function (field) {
                                return formatValue(row[field]);
                            }).join(delimiter);
                        })).join("\n");
                    };
                    dsv.formatRows = function (rows) {
                        return rows.map(formatRow).join("\n");
                    };

                    function formatRow(row) {
                        return row.map(formatValue).join(delimiter);
                    }

                    function formatValue(text) {
                        return reFormat.test(text) ? '"' + text.replace(/\"/g, '""') + '"' : text;
                    }

                    return dsv;
                };
                d3.csv = d3.dsv(",", "text/csv");
                d3.tsv = d3.dsv("	", "text/tab-separated-values");
                var d3_timer_queueHead, d3_timer_queueTail, d3_timer_interval,
                    d3_timer_timeout,
                    d3_timer_frame = this[d3_vendorSymbol(this, "requestAnimationFrame")] || function (callback) {
                        setTimeout(callback, 17);
                    };
                d3.timer = function () {
                    d3_timer.apply(this, arguments);
                };

                function d3_timer(callback, delay, then) {
                    var n = arguments.length;
                    if (n < 2) delay = 0;
                    if (n < 3) then = Date.now();
                    var time = then + delay, timer = {
                        c: callback,
                        t: time,
                        n: null
                    };
                    if (d3_timer_queueTail) d3_timer_queueTail.n = timer; else d3_timer_queueHead = timer;
                    d3_timer_queueTail = timer;
                    if (!d3_timer_interval) {
                        d3_timer_timeout = clearTimeout(d3_timer_timeout);
                        d3_timer_interval = 1;
                        d3_timer_frame(d3_timer_step);
                    }
                    return timer;
                }

                function d3_timer_step() {
                    var now = d3_timer_mark(), delay = d3_timer_sweep() - now;
                    if (delay > 24) {
                        if (isFinite(delay)) {
                            clearTimeout(d3_timer_timeout);
                            d3_timer_timeout = setTimeout(d3_timer_step, delay);
                        }
                        d3_timer_interval = 0;
                    } else {
                        d3_timer_interval = 1;
                        d3_timer_frame(d3_timer_step);
                    }
                }

                d3.timer.flush = function () {
                    d3_timer_mark();
                    d3_timer_sweep();
                };

                function d3_timer_mark() {
                    var now = Date.now(), timer = d3_timer_queueHead;
                    while (timer) {
                        if (now >= timer.t && timer.c(now - timer.t)) timer.c = null;
                        timer = timer.n;
                    }
                    return now;
                }

                function d3_timer_sweep() {
                    var t0, t1 = d3_timer_queueHead, time = Infinity;
                    while (t1) {
                        if (t1.c) {
                            if (t1.t < time) time = t1.t;
                            t1 = (t0 = t1).n;
                        } else {
                            t1 = t0 ? t0.n = t1.n : d3_timer_queueHead = t1.n;
                        }
                    }
                    d3_timer_queueTail = t0;
                    return time;
                }

                d3.round = function (x, n) {
                    return n ? Math.round(x * (n = Math.pow(10, n))) / n : Math.round(x);
                };
                d3.geom = {};

                function d3_geom_pointX(d) {
                    return d[0];
                }

                function d3_geom_pointY(d) {
                    return d[1];
                }

                d3.geom.hull = function (vertices) {
                    var x = d3_geom_pointX, y = d3_geom_pointY;
                    if (arguments.length) return hull(vertices);

                    function hull(data) {
                        if (data.length < 3) return [];
                        var fx = d3_functor(x), fy = d3_functor(y), i,
                            n = data.length, points = [], flippedPoints = [];
                        for (i = 0; i < n; i++) {
                            points.push([+fx.call(this, data[i], i), +fy.call(this, data[i], i), i]);
                        }
                        points.sort(d3_geom_hullOrder);
                        for (i = 0; i < n; i++) flippedPoints.push([points[i][0], -points[i][1]]);
                        var upper = d3_geom_hullUpper(points),
                            lower = d3_geom_hullUpper(flippedPoints);
                        var skipLeft = lower[0] === upper[0],
                            skipRight = lower[lower.length - 1] === upper[upper.length - 1],
                            polygon = [];
                        for (i = upper.length - 1; i >= 0; --i) polygon.push(data[points[upper[i]][2]]);
                        for (i = +skipLeft; i < lower.length - skipRight; ++i) polygon.push(data[points[lower[i]][2]]);
                        return polygon;
                    }

                    hull.x = function (_) {
                        return arguments.length ? (x = _, hull) : x;
                    };
                    hull.y = function (_) {
                        return arguments.length ? (y = _, hull) : y;
                    };
                    return hull;
                };

                function d3_geom_hullUpper(points) {
                    var n = points.length, hull = [0, 1], hs = 2;
                    for (var i = 2; i < n; i++) {
                        while (hs > 1 && d3_cross2d(points[hull[hs - 2]], points[hull[hs - 1]], points[i]) <= 0) --hs;
                        hull[hs++] = i;
                    }
                    return hull.slice(0, hs);
                }

                function d3_geom_hullOrder(a, b) {
                    return a[0] - b[0] || a[1] - b[1];
                }

                d3.geom.polygon = function (coordinates) {
                    d3_subclass(coordinates, d3_geom_polygonPrototype);
                    return coordinates;
                };
                var d3_geom_polygonPrototype = d3.geom.polygon.prototype = [];
                d3_geom_polygonPrototype.area = function () {
                    var i = -1, n = this.length, a, b = this[n - 1], area = 0;
                    while (++i < n) {
                        a = b;
                        b = this[i];
                        area += a[1] * b[0] - a[0] * b[1];
                    }
                    return area * .5;
                };
                d3_geom_polygonPrototype.centroid = function (k) {
                    var i = -1, n = this.length, x = 0, y = 0, a,
                        b = this[n - 1], c;
                    if (!arguments.length) k = -1 / (6 * this.area());
                    while (++i < n) {
                        a = b;
                        b = this[i];
                        c = a[0] * b[1] - b[0] * a[1];
                        x += (a[0] + b[0]) * c;
                        y += (a[1] + b[1]) * c;
                    }
                    return [x * k, y * k];
                };
                d3_geom_polygonPrototype.clip = function (subject) {
                    var input, closed = d3_geom_polygonClosed(subject), i = -1,
                        n = this.length - d3_geom_polygonClosed(this), j, m,
                        a = this[n - 1], b, c, d;
                    while (++i < n) {
                        input = subject.slice();
                        subject.length = 0;
                        b = this[i];
                        c = input[(m = input.length - closed) - 1];
                        j = -1;
                        while (++j < m) {
                            d = input[j];
                            if (d3_geom_polygonInside(d, a, b)) {
                                if (!d3_geom_polygonInside(c, a, b)) {
                                    subject.push(d3_geom_polygonIntersect(c, d, a, b));
                                }
                                subject.push(d);
                            } else if (d3_geom_polygonInside(c, a, b)) {
                                subject.push(d3_geom_polygonIntersect(c, d, a, b));
                            }
                            c = d;
                        }
                        if (closed) subject.push(subject[0]);
                        a = b;
                    }
                    return subject;
                };

                function d3_geom_polygonInside(p, a, b) {
                    return (b[0] - a[0]) * (p[1] - a[1]) < (b[1] - a[1]) * (p[0] - a[0]);
                }

                function d3_geom_polygonIntersect(c, d, a, b) {
                    var x1 = c[0], x3 = a[0], x21 = d[0] - x1, x43 = b[0] - x3,
                        y1 = c[1], y3 = a[1], y21 = d[1] - y1, y43 = b[1] - y3,
                        ua = (x43 * (y1 - y3) - y43 * (x1 - x3)) / (y43 * x21 - x43 * y21);
                    return [x1 + ua * x21, y1 + ua * y21];
                }

                function d3_geom_polygonClosed(coordinates) {
                    var a = coordinates[0],
                        b = coordinates[coordinates.length - 1];
                    return !(a[0] - b[0] || a[1] - b[1]);
                }

                var d3_geom_voronoiEdges, d3_geom_voronoiCells,
                    d3_geom_voronoiBeaches, d3_geom_voronoiBeachPool = [],
                    d3_geom_voronoiFirstCircle, d3_geom_voronoiCircles,
                    d3_geom_voronoiCirclePool = [];

                function d3_geom_voronoiBeach() {
                    d3_geom_voronoiRedBlackNode(this);
                    this.edge = this.site = this.circle = null;
                }

                function d3_geom_voronoiCreateBeach(site) {
                    var beach = d3_geom_voronoiBeachPool.pop() || new d3_geom_voronoiBeach();
                    beach.site = site;
                    return beach;
                }

                function d3_geom_voronoiDetachBeach(beach) {
                    d3_geom_voronoiDetachCircle(beach);
                    d3_geom_voronoiBeaches.remove(beach);
                    d3_geom_voronoiBeachPool.push(beach);
                    d3_geom_voronoiRedBlackNode(beach);
                }

                function d3_geom_voronoiRemoveBeach(beach) {
                    var circle = beach.circle, x = circle.x, y = circle.cy,
                        vertex = {
                            x: x,
                            y: y
                        }, previous = beach.P, next = beach.N,
                        disappearing = [beach];
                    d3_geom_voronoiDetachBeach(beach);
                    var lArc = previous;
                    while (lArc.circle && abs(x - lArc.circle.x) < Îµ && abs(y - lArc.circle.cy) < Îµ) {
                        previous = lArc.P;
                        disappearing.unshift(lArc);
                        d3_geom_voronoiDetachBeach(lArc);
                        lArc = previous;
                    }
                    disappearing.unshift(lArc);
                    d3_geom_voronoiDetachCircle(lArc);
                    var rArc = next;
                    while (rArc.circle && abs(x - rArc.circle.x) < Îµ && abs(y - rArc.circle.cy) < Îµ) {
                        next = rArc.N;
                        disappearing.push(rArc);
                        d3_geom_voronoiDetachBeach(rArc);
                        rArc = next;
                    }
                    disappearing.push(rArc);
                    d3_geom_voronoiDetachCircle(rArc);
                    var nArcs = disappearing.length, iArc;
                    for (iArc = 1; iArc < nArcs; ++iArc) {
                        rArc = disappearing[iArc];
                        lArc = disappearing[iArc - 1];
                        d3_geom_voronoiSetEdgeEnd(rArc.edge, lArc.site, rArc.site, vertex);
                    }
                    lArc = disappearing[0];
                    rArc = disappearing[nArcs - 1];
                    rArc.edge = d3_geom_voronoiCreateEdge(lArc.site, rArc.site, null, vertex);
                    d3_geom_voronoiAttachCircle(lArc);
                    d3_geom_voronoiAttachCircle(rArc);
                }

                function d3_geom_voronoiAddBeach(site) {
                    var x = site.x, directrix = site.y, lArc, rArc, dxl, dxr,
                        node = d3_geom_voronoiBeaches._;
                    while (node) {
                        dxl = d3_geom_voronoiLeftBreakPoint(node, directrix) - x;
                        if (dxl > Îµ) node = node.L; else {
                            dxr = x - d3_geom_voronoiRightBreakPoint(node, directrix);
                            if (dxr > Îµ) {
                                if (!node.R) {
                                    lArc = node;
                                    break;
                                }
                                node = node.R;
                            } else {
                                if (dxl > -Îµ) {
                                    lArc = node.P;
                                    rArc = node;
                                } else if (dxr > -Îµ) {
                                    lArc = node;
                                    rArc = node.N;
                                } else {
                                    lArc = rArc = node;
                                }
                                break;
                            }
                        }
                    }
                    var newArc = d3_geom_voronoiCreateBeach(site);
                    d3_geom_voronoiBeaches.insert(lArc, newArc);
                    if (!lArc && !rArc) return;
                    if (lArc === rArc) {
                        d3_geom_voronoiDetachCircle(lArc);
                        rArc = d3_geom_voronoiCreateBeach(lArc.site);
                        d3_geom_voronoiBeaches.insert(newArc, rArc);
                        newArc.edge = rArc.edge = d3_geom_voronoiCreateEdge(lArc.site, newArc.site);
                        d3_geom_voronoiAttachCircle(lArc);
                        d3_geom_voronoiAttachCircle(rArc);
                        return;
                    }
                    if (!rArc) {
                        newArc.edge = d3_geom_voronoiCreateEdge(lArc.site, newArc.site);
                        return;
                    }
                    d3_geom_voronoiDetachCircle(lArc);
                    d3_geom_voronoiDetachCircle(rArc);
                    var lSite = lArc.site, ax = lSite.x, ay = lSite.y,
                        bx = site.x - ax, by = site.y - ay, rSite = rArc.site,
                        cx = rSite.x - ax, cy = rSite.y - ay,
                        d = 2 * (bx * cy - by * cx), hb = bx * bx + by * by,
                        hc = cx * cx + cy * cy, vertex = {
                            x: (cy * hb - by * hc) / d + ax,
                            y: (bx * hc - cx * hb) / d + ay
                        };
                    d3_geom_voronoiSetEdgeEnd(rArc.edge, lSite, rSite, vertex);
                    newArc.edge = d3_geom_voronoiCreateEdge(lSite, site, null, vertex);
                    rArc.edge = d3_geom_voronoiCreateEdge(site, rSite, null, vertex);
                    d3_geom_voronoiAttachCircle(lArc);
                    d3_geom_voronoiAttachCircle(rArc);
                }

                function d3_geom_voronoiLeftBreakPoint(arc, directrix) {
                    var site = arc.site, rfocx = site.x, rfocy = site.y,
                        pby2 = rfocy - directrix;
                    if (!pby2) return rfocx;
                    var lArc = arc.P;
                    if (!lArc) return -Infinity;
                    site = lArc.site;
                    var lfocx = site.x, lfocy = site.y,
                        plby2 = lfocy - directrix;
                    if (!plby2) return lfocx;
                    var hl = lfocx - rfocx, aby2 = 1 / pby2 - 1 / plby2,
                        b = hl / plby2;
                    if (aby2) return (-b + Math.sqrt(b * b - 2 * aby2 * (hl * hl / (-2 * plby2) - lfocy + plby2 / 2 + rfocy - pby2 / 2))) / aby2 + rfocx;
                    return (rfocx + lfocx) / 2;
                }

                function d3_geom_voronoiRightBreakPoint(arc, directrix) {
                    var rArc = arc.N;
                    if (rArc) return d3_geom_voronoiLeftBreakPoint(rArc, directrix);
                    var site = arc.site;
                    return site.y === directrix ? site.x : Infinity;
                }

                function d3_geom_voronoiCell(site) {
                    this.site = site;
                    this.edges = [];
                }

                d3_geom_voronoiCell.prototype.prepare = function () {
                    var halfEdges = this.edges, iHalfEdge = halfEdges.length,
                        edge;
                    while (iHalfEdge--) {
                        edge = halfEdges[iHalfEdge].edge;
                        if (!edge.b || !edge.a) halfEdges.splice(iHalfEdge, 1);
                    }
                    halfEdges.sort(d3_geom_voronoiHalfEdgeOrder);
                    return halfEdges.length;
                };

                function d3_geom_voronoiCloseCells(extent) {
                    var x0 = extent[0][0], x1 = extent[1][0], y0 = extent[0][1],
                        y1 = extent[1][1], x2, y2, x3, y3,
                        cells = d3_geom_voronoiCells, iCell = cells.length,
                        cell, iHalfEdge, halfEdges, nHalfEdges, start, end;
                    while (iCell--) {
                        cell = cells[iCell];
                        if (!cell || !cell.prepare()) continue;
                        halfEdges = cell.edges;
                        nHalfEdges = halfEdges.length;
                        iHalfEdge = 0;
                        while (iHalfEdge < nHalfEdges) {
                            end = halfEdges[iHalfEdge].end(), x3 = end.x, y3 = end.y;
                            start = halfEdges[++iHalfEdge % nHalfEdges].start(), x2 = start.x, y2 = start.y;
                            if (abs(x3 - x2) > Îµ || abs(y3 - y2) > Îµ) {
                                halfEdges.splice(iHalfEdge, 0, new d3_geom_voronoiHalfEdge(d3_geom_voronoiCreateBorderEdge(cell.site, end, abs(x3 - x0) < Îµ && y1 - y3 > Îµ ? {
                                    x: x0,
                                    y: abs(x2 - x0) < Îµ ? y2 : y1
                                } : abs(y3 - y1) < Îµ && x1 - x3 > Îµ ? {
                                    x: abs(y2 - y1) < Îµ ? x2 : x1,
                                    y: y1
                                } : abs(x3 - x1) < Îµ && y3 - y0 > Îµ ? {
                                    x: x1,
                                    y: abs(x2 - x1) < Îµ ? y2 : y0
                                } : abs(y3 - y0) < Îµ && x3 - x0 > Îµ ? {
                                    x: abs(y2 - y0) < Îµ ? x2 : x0,
                                    y: y0
                                } : null), cell.site, null));
                                ++nHalfEdges;
                            }
                        }
                    }
                }

                function d3_geom_voronoiHalfEdgeOrder(a, b) {
                    return b.angle - a.angle;
                }

                function d3_geom_voronoiCircle() {
                    d3_geom_voronoiRedBlackNode(this);
                    this.x = this.y = this.arc = this.site = this.cy = null;
                }

                function d3_geom_voronoiAttachCircle(arc) {
                    var lArc = arc.P, rArc = arc.N;
                    if (!lArc || !rArc) return;
                    var lSite = lArc.site, cSite = arc.site, rSite = rArc.site;
                    if (lSite === rSite) return;
                    var bx = cSite.x, by = cSite.y, ax = lSite.x - bx,
                        ay = lSite.y - by, cx = rSite.x - bx, cy = rSite.y - by;
                    var d = 2 * (ax * cy - ay * cx);
                    if (d >= -Îµ2) return;
                    var ha = ax * ax + ay * ay, hc = cx * cx + cy * cy,
                        x = (cy * ha - ay * hc) / d,
                        y = (ax * hc - cx * ha) / d, cy = y + by;
                    var circle = d3_geom_voronoiCirclePool.pop() || new d3_geom_voronoiCircle();
                    circle.arc = arc;
                    circle.site = cSite;
                    circle.x = x + bx;
                    circle.y = cy + Math.sqrt(x * x + y * y);
                    circle.cy = cy;
                    arc.circle = circle;
                    var before = null, node = d3_geom_voronoiCircles._;
                    while (node) {
                        if (circle.y < node.y || circle.y === node.y && circle.x <= node.x) {
                            if (node.L) node = node.L; else {
                                before = node.P;
                                break;
                            }
                        } else {
                            if (node.R) node = node.R; else {
                                before = node;
                                break;
                            }
                        }
                    }
                    d3_geom_voronoiCircles.insert(before, circle);
                    if (!before) d3_geom_voronoiFirstCircle = circle;
                }

                function d3_geom_voronoiDetachCircle(arc) {
                    var circle = arc.circle;
                    if (circle) {
                        if (!circle.P) d3_geom_voronoiFirstCircle = circle.N;
                        d3_geom_voronoiCircles.remove(circle);
                        d3_geom_voronoiCirclePool.push(circle);
                        d3_geom_voronoiRedBlackNode(circle);
                        arc.circle = null;
                    }
                }

                function d3_geom_clipLine(x0, y0, x1, y1) {
                    return function (line) {
                        var a = line.a, b = line.b, ax = a.x, ay = a.y,
                            bx = b.x, by = b.y, t0 = 0, t1 = 1, dx = bx - ax,
                            dy = by - ay, r;
                        r = x0 - ax;
                        if (!dx && r > 0) return;
                        r /= dx;
                        if (dx < 0) {
                            if (r < t0) return;
                            if (r < t1) t1 = r;
                        } else if (dx > 0) {
                            if (r > t1) return;
                            if (r > t0) t0 = r;
                        }
                        r = x1 - ax;
                        if (!dx && r < 0) return;
                        r /= dx;
                        if (dx < 0) {
                            if (r > t1) return;
                            if (r > t0) t0 = r;
                        } else if (dx > 0) {
                            if (r < t0) return;
                            if (r < t1) t1 = r;
                        }
                        r = y0 - ay;
                        if (!dy && r > 0) return;
                        r /= dy;
                        if (dy < 0) {
                            if (r < t0) return;
                            if (r < t1) t1 = r;
                        } else if (dy > 0) {
                            if (r > t1) return;
                            if (r > t0) t0 = r;
                        }
                        r = y1 - ay;
                        if (!dy && r < 0) return;
                        r /= dy;
                        if (dy < 0) {
                            if (r > t1) return;
                            if (r > t0) t0 = r;
                        } else if (dy > 0) {
                            if (r < t0) return;
                            if (r < t1) t1 = r;
                        }
                        if (t0 > 0) line.a = {
                            x: ax + t0 * dx,
                            y: ay + t0 * dy
                        };
                        if (t1 < 1) line.b = {
                            x: ax + t1 * dx,
                            y: ay + t1 * dy
                        };
                        return line;
                    };
                }

                function d3_geom_voronoiClipEdges(extent) {
                    var edges = d3_geom_voronoiEdges,
                        clip = d3_geom_clipLine(extent[0][0], extent[0][1], extent[1][0], extent[1][1]),
                        i = edges.length, e;
                    while (i--) {
                        e = edges[i];
                        if (!d3_geom_voronoiConnectEdge(e, extent) || !clip(e) || abs(e.a.x - e.b.x) < Îµ && abs(e.a.y - e.b.y) < Îµ) {
                            e.a = e.b = null;
                            edges.splice(i, 1);
                        }
                    }
                }

                function d3_geom_voronoiConnectEdge(edge, extent) {
                    var vb = edge.b;
                    if (vb) return true;
                    var va = edge.a, x0 = extent[0][0], x1 = extent[1][0],
                        y0 = extent[0][1], y1 = extent[1][1], lSite = edge.l,
                        rSite = edge.r, lx = lSite.x, ly = lSite.y,
                        rx = rSite.x, ry = rSite.y, fx = (lx + rx) / 2,
                        fy = (ly + ry) / 2, fm, fb;
                    if (ry === ly) {
                        if (fx < x0 || fx >= x1) return;
                        if (lx > rx) {
                            if (!va) va = {
                                x: fx,
                                y: y0
                            }; else if (va.y >= y1) return;
                            vb = {
                                x: fx,
                                y: y1
                            };
                        } else {
                            if (!va) va = {
                                x: fx,
                                y: y1
                            }; else if (va.y < y0) return;
                            vb = {
                                x: fx,
                                y: y0
                            };
                        }
                    } else {
                        fm = (lx - rx) / (ry - ly);
                        fb = fy - fm * fx;
                        if (fm < -1 || fm > 1) {
                            if (lx > rx) {
                                if (!va) va = {
                                    x: (y0 - fb) / fm,
                                    y: y0
                                }; else if (va.y >= y1) return;
                                vb = {
                                    x: (y1 - fb) / fm,
                                    y: y1
                                };
                            } else {
                                if (!va) va = {
                                    x: (y1 - fb) / fm,
                                    y: y1
                                }; else if (va.y < y0) return;
                                vb = {
                                    x: (y0 - fb) / fm,
                                    y: y0
                                };
                            }
                        } else {
                            if (ly < ry) {
                                if (!va) va = {
                                    x: x0,
                                    y: fm * x0 + fb
                                }; else if (va.x >= x1) return;
                                vb = {
                                    x: x1,
                                    y: fm * x1 + fb
                                };
                            } else {
                                if (!va) va = {
                                    x: x1,
                                    y: fm * x1 + fb
                                }; else if (va.x < x0) return;
                                vb = {
                                    x: x0,
                                    y: fm * x0 + fb
                                };
                            }
                        }
                    }
                    edge.a = va;
                    edge.b = vb;
                    return true;
                }

                function d3_geom_voronoiEdge(lSite, rSite) {
                    this.l = lSite;
                    this.r = rSite;
                    this.a = this.b = null;
                }

                function d3_geom_voronoiCreateEdge(lSite, rSite, va, vb) {
                    var edge = new d3_geom_voronoiEdge(lSite, rSite);
                    d3_geom_voronoiEdges.push(edge);
                    if (va) d3_geom_voronoiSetEdgeEnd(edge, lSite, rSite, va);
                    if (vb) d3_geom_voronoiSetEdgeEnd(edge, rSite, lSite, vb);
                    d3_geom_voronoiCells[lSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge, lSite, rSite));
                    d3_geom_voronoiCells[rSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge, rSite, lSite));
                    return edge;
                }

                function d3_geom_voronoiCreateBorderEdge(lSite, va, vb) {
                    var edge = new d3_geom_voronoiEdge(lSite, null);
                    edge.a = va;
                    edge.b = vb;
                    d3_geom_voronoiEdges.push(edge);
                    return edge;
                }

                function d3_geom_voronoiSetEdgeEnd(edge, lSite, rSite, vertex) {
                    if (!edge.a && !edge.b) {
                        edge.a = vertex;
                        edge.l = lSite;
                        edge.r = rSite;
                    } else if (edge.l === rSite) {
                        edge.b = vertex;
                    } else {
                        edge.a = vertex;
                    }
                }

                function d3_geom_voronoiHalfEdge(edge, lSite, rSite) {
                    var va = edge.a, vb = edge.b;
                    this.edge = edge;
                    this.site = lSite;
                    this.angle = rSite ? Math.atan2(rSite.y - lSite.y, rSite.x - lSite.x) : edge.l === lSite ? Math.atan2(vb.x - va.x, va.y - vb.y) : Math.atan2(va.x - vb.x, vb.y - va.y);
                }

                d3_geom_voronoiHalfEdge.prototype = {
                    start: function () {
                        return this.edge.l === this.site ? this.edge.a : this.edge.b;
                    },
                    end: function () {
                        return this.edge.l === this.site ? this.edge.b : this.edge.a;
                    }
                };

                function d3_geom_voronoiRedBlackTree() {
                    this._ = null;
                }

                function d3_geom_voronoiRedBlackNode(node) {
                    node.U = node.C = node.L = node.R = node.P = node.N = null;
                }

                d3_geom_voronoiRedBlackTree.prototype = {
                    insert: function (after, node) {
                        var parent, grandpa, uncle;
                        if (after) {
                            node.P = after;
                            node.N = after.N;
                            if (after.N) after.N.P = node;
                            after.N = node;
                            if (after.R) {
                                after = after.R;
                                while (after.L) after = after.L;
                                after.L = node;
                            } else {
                                after.R = node;
                            }
                            parent = after;
                        } else if (this._) {
                            after = d3_geom_voronoiRedBlackFirst(this._);
                            node.P = null;
                            node.N = after;
                            after.P = after.L = node;
                            parent = after;
                        } else {
                            node.P = node.N = null;
                            this._ = node;
                            parent = null;
                        }
                        node.L = node.R = null;
                        node.U = parent;
                        node.C = true;
                        after = node;
                        while (parent && parent.C) {
                            grandpa = parent.U;
                            if (parent === grandpa.L) {
                                uncle = grandpa.R;
                                if (uncle && uncle.C) {
                                    parent.C = uncle.C = false;
                                    grandpa.C = true;
                                    after = grandpa;
                                } else {
                                    if (after === parent.R) {
                                        d3_geom_voronoiRedBlackRotateLeft(this, parent);
                                        after = parent;
                                        parent = after.U;
                                    }
                                    parent.C = false;
                                    grandpa.C = true;
                                    d3_geom_voronoiRedBlackRotateRight(this, grandpa);
                                }
                            } else {
                                uncle = grandpa.L;
                                if (uncle && uncle.C) {
                                    parent.C = uncle.C = false;
                                    grandpa.C = true;
                                    after = grandpa;
                                } else {
                                    if (after === parent.L) {
                                        d3_geom_voronoiRedBlackRotateRight(this, parent);
                                        after = parent;
                                        parent = after.U;
                                    }
                                    parent.C = false;
                                    grandpa.C = true;
                                    d3_geom_voronoiRedBlackRotateLeft(this, grandpa);
                                }
                            }
                            parent = after.U;
                        }
                        this._.C = false;
                    },
                    remove: function (node) {
                        if (node.N) node.N.P = node.P;
                        if (node.P) node.P.N = node.N;
                        node.N = node.P = null;
                        var parent = node.U, sibling, left = node.L,
                            right = node.R, next, red;
                        if (!left) next = right; else if (!right) next = left; else next = d3_geom_voronoiRedBlackFirst(right);
                        if (parent) {
                            if (parent.L === node) parent.L = next; else parent.R = next;
                        } else {
                            this._ = next;
                        }
                        if (left && right) {
                            red = next.C;
                            next.C = node.C;
                            next.L = left;
                            left.U = next;
                            if (next !== right) {
                                parent = next.U;
                                next.U = node.U;
                                node = next.R;
                                parent.L = node;
                                next.R = right;
                                right.U = next;
                            } else {
                                next.U = parent;
                                parent = next;
                                node = next.R;
                            }
                        } else {
                            red = node.C;
                            node = next;
                        }
                        if (node) node.U = parent;
                        if (red) return;
                        if (node && node.C) {
                            node.C = false;
                            return;
                        }
                        do {
                            if (node === this._) break;
                            if (node === parent.L) {
                                sibling = parent.R;
                                if (sibling.C) {
                                    sibling.C = false;
                                    parent.C = true;
                                    d3_geom_voronoiRedBlackRotateLeft(this, parent);
                                    sibling = parent.R;
                                }
                                if (sibling.L && sibling.L.C || sibling.R && sibling.R.C) {
                                    if (!sibling.R || !sibling.R.C) {
                                        sibling.L.C = false;
                                        sibling.C = true;
                                        d3_geom_voronoiRedBlackRotateRight(this, sibling);
                                        sibling = parent.R;
                                    }
                                    sibling.C = parent.C;
                                    parent.C = sibling.R.C = false;
                                    d3_geom_voronoiRedBlackRotateLeft(this, parent);
                                    node = this._;
                                    break;
                                }
                            } else {
                                sibling = parent.L;
                                if (sibling.C) {
                                    sibling.C = false;
                                    parent.C = true;
                                    d3_geom_voronoiRedBlackRotateRight(this, parent);
                                    sibling = parent.L;
                                }
                                if (sibling.L && sibling.L.C || sibling.R && sibling.R.C) {
                                    if (!sibling.L || !sibling.L.C) {
                                        sibling.R.C = false;
                                        sibling.C = true;
                                        d3_geom_voronoiRedBlackRotateLeft(this, sibling);
                                        sibling = parent.L;
                                    }
                                    sibling.C = parent.C;
                                    parent.C = sibling.L.C = false;
                                    d3_geom_voronoiRedBlackRotateRight(this, parent);
                                    node = this._;
                                    break;
                                }
                            }
                            sibling.C = true;
                            node = parent;
                            parent = parent.U;
                        } while (!node.C);
                        if (node) node.C = false;
                    }
                };

                function d3_geom_voronoiRedBlackRotateLeft(tree, node) {
                    var p = node, q = node.R, parent = p.U;
                    if (parent) {
                        if (parent.L === p) parent.L = q; else parent.R = q;
                    } else {
                        tree._ = q;
                    }
                    q.U = parent;
                    p.U = q;
                    p.R = q.L;
                    if (p.R) p.R.U = p;
                    q.L = p;
                }

                function d3_geom_voronoiRedBlackRotateRight(tree, node) {
                    var p = node, q = node.L, parent = p.U;
                    if (parent) {
                        if (parent.L === p) parent.L = q; else parent.R = q;
                    } else {
                        tree._ = q;
                    }
                    q.U = parent;
                    p.U = q;
                    p.L = q.R;
                    if (p.L) p.L.U = p;
                    q.R = p;
                }

                function d3_geom_voronoiRedBlackFirst(node) {
                    while (node.L) node = node.L;
                    return node;
                }

                function d3_geom_voronoi(sites, bbox) {
                    var site = sites.sort(d3_geom_voronoiVertexOrder).pop(), x0,
                        y0, circle;
                    d3_geom_voronoiEdges = [];
                    d3_geom_voronoiCells = new Array(sites.length);
                    d3_geom_voronoiBeaches = new d3_geom_voronoiRedBlackTree();
                    d3_geom_voronoiCircles = new d3_geom_voronoiRedBlackTree();
                    while (true) {
                        circle = d3_geom_voronoiFirstCircle;
                        if (site && (!circle || site.y < circle.y || site.y === circle.y && site.x < circle.x)) {
                            if (site.x !== x0 || site.y !== y0) {
                                d3_geom_voronoiCells[site.i] = new d3_geom_voronoiCell(site);
                                d3_geom_voronoiAddBeach(site);
                                x0 = site.x, y0 = site.y;
                            }
                            site = sites.pop();
                        } else if (circle) {
                            d3_geom_voronoiRemoveBeach(circle.arc);
                        } else {
                            break;
                        }
                    }
                    if (bbox) d3_geom_voronoiClipEdges(bbox), d3_geom_voronoiCloseCells(bbox);
                    var diagram = {
                        cells: d3_geom_voronoiCells,
                        edges: d3_geom_voronoiEdges
                    };
                    d3_geom_voronoiBeaches = d3_geom_voronoiCircles = d3_geom_voronoiEdges = d3_geom_voronoiCells = null;
                    return diagram;
                }

                function d3_geom_voronoiVertexOrder(a, b) {
                    return b.y - a.y || b.x - a.x;
                }

                d3.geom.voronoi = function (points) {
                    var x = d3_geom_pointX, y = d3_geom_pointY, fx = x, fy = y,
                        clipExtent = d3_geom_voronoiClipExtent;
                    if (points) return voronoi(points);

                    function voronoi(data) {
                        var polygons = new Array(data.length),
                            x0 = clipExtent[0][0], y0 = clipExtent[0][1],
                            x1 = clipExtent[1][0], y1 = clipExtent[1][1];
                        d3_geom_voronoi(sites(data), clipExtent).cells.forEach(function (cell, i) {
                            var edges = cell.edges, site = cell.site,
                                polygon = polygons[i] = edges.length ? edges.map(function (e) {
                                    var s = e.start();
                                    return [s.x, s.y];
                                }) : site.x >= x0 && site.x <= x1 && site.y >= y0 && site.y <= y1 ? [[x0, y1], [x1, y1], [x1, y0], [x0, y0]] : [];
                            polygon.point = data[i];
                        });
                        return polygons;
                    }

                    function sites(data) {
                        return data.map(function (d, i) {
                            return {
                                x: Math.round(fx(d, i) / Îµ) * Îµ,
                                y: Math.round(fy(d, i) / Îµ) * Îµ,
                                i: i
                            };
                        });
                    }

                    voronoi.links = function (data) {
                        return d3_geom_voronoi(sites(data)).edges.filter(function (edge) {
                            return edge.l && edge.r;
                        }).map(function (edge) {
                            return {
                                source: data[edge.l.i],
                                target: data[edge.r.i]
                            };
                        });
                    };
                    voronoi.triangles = function (data) {
                        var triangles = [];
                        d3_geom_voronoi(sites(data)).cells.forEach(function (cell, i) {
                            var site = cell.site,
                                edges = cell.edges.sort(d3_geom_voronoiHalfEdgeOrder),
                                j = -1, m = edges.length, e0, s0,
                                e1 = edges[m - 1].edge,
                                s1 = e1.l === site ? e1.r : e1.l;
                            while (++j < m) {
                                e0 = e1;
                                s0 = s1;
                                e1 = edges[j].edge;
                                s1 = e1.l === site ? e1.r : e1.l;
                                if (i < s0.i && i < s1.i && d3_geom_voronoiTriangleArea(site, s0, s1) < 0) {
                                    triangles.push([data[i], data[s0.i], data[s1.i]]);
                                }
                            }
                        });
                        return triangles;
                    };
                    voronoi.x = function (_) {
                        return arguments.length ? (fx = d3_functor(x = _), voronoi) : x;
                    };
                    voronoi.y = function (_) {
                        return arguments.length ? (fy = d3_functor(y = _), voronoi) : y;
                    };
                    voronoi.clipExtent = function (_) {
                        if (!arguments.length) return clipExtent === d3_geom_voronoiClipExtent ? null : clipExtent;
                        clipExtent = _ == null ? d3_geom_voronoiClipExtent : _;
                        return voronoi;
                    };
                    voronoi.size = function (_) {
                        if (!arguments.length) return clipExtent === d3_geom_voronoiClipExtent ? null : clipExtent && clipExtent[1];
                        return voronoi.clipExtent(_ && [[0, 0], _]);
                    };
                    return voronoi;
                };
                var d3_geom_voronoiClipExtent = [[-1e6, -1e6], [1e6, 1e6]];

                function d3_geom_voronoiTriangleArea(a, b, c) {
                    return (a.x - c.x) * (b.y - a.y) - (a.x - b.x) * (c.y - a.y);
                }

                d3.geom.delaunay = function (vertices) {
                    return d3.geom.voronoi().triangles(vertices);
                };
                d3.geom.quadtree = function (points, x1, y1, x2, y2) {
                    var x = d3_geom_pointX, y = d3_geom_pointY, compat;
                    if (compat = arguments.length) {
                        x = d3_geom_quadtreeCompatX;
                        y = d3_geom_quadtreeCompatY;
                        if (compat === 3) {
                            y2 = y1;
                            x2 = x1;
                            y1 = x1 = 0;
                        }
                        return quadtree(points);
                    }

                    function quadtree(data) {
                        var d, fx = d3_functor(x), fy = d3_functor(y), xs, ys,
                            i, n, x1_, y1_, x2_, y2_;
                        if (x1 != null) {
                            x1_ = x1, y1_ = y1, x2_ = x2, y2_ = y2;
                        } else {
                            x2_ = y2_ = -(x1_ = y1_ = Infinity);
                            xs = [], ys = [];
                            n = data.length;
                            if (compat) for (i = 0; i < n; ++i) {
                                d = data[i];
                                if (d.x < x1_) x1_ = d.x;
                                if (d.y < y1_) y1_ = d.y;
                                if (d.x > x2_) x2_ = d.x;
                                if (d.y > y2_) y2_ = d.y;
                                xs.push(d.x);
                                ys.push(d.y);
                            } else for (i = 0; i < n; ++i) {
                                var x_ = +fx(d = data[i], i), y_ = +fy(d, i);
                                if (x_ < x1_) x1_ = x_;
                                if (y_ < y1_) y1_ = y_;
                                if (x_ > x2_) x2_ = x_;
                                if (y_ > y2_) y2_ = y_;
                                xs.push(x_);
                                ys.push(y_);
                            }
                        }
                        var dx = x2_ - x1_, dy = y2_ - y1_;
                        if (dx > dy) y2_ = y1_ + dx; else x2_ = x1_ + dy;

                        function insert(n, d, x, y, x1, y1, x2, y2) {
                            if (isNaN(x) || isNaN(y)) return;
                            if (n.leaf) {
                                var nx = n.x, ny = n.y;
                                if (nx != null) {
                                    if (abs(nx - x) + abs(ny - y) < .01) {
                                        insertChild(n, d, x, y, x1, y1, x2, y2);
                                    } else {
                                        var nPoint = n.point;
                                        n.x = n.y = n.point = null;
                                        insertChild(n, nPoint, nx, ny, x1, y1, x2, y2);
                                        insertChild(n, d, x, y, x1, y1, x2, y2);
                                    }
                                } else {
                                    n.x = x, n.y = y, n.point = d;
                                }
                            } else {
                                insertChild(n, d, x, y, x1, y1, x2, y2);
                            }
                        }

                        function insertChild(n, d, x, y, x1, y1, x2, y2) {
                            var xm = (x1 + x2) * .5, ym = (y1 + y2) * .5,
                                right = x >= xm, below = y >= ym,
                                i = below << 1 | right;
                            n.leaf = false;
                            n = n.nodes[i] || (n.nodes[i] = d3_geom_quadtreeNode());
                            if (right) x1 = xm; else x2 = xm;
                            if (below) y1 = ym; else y2 = ym;
                            insert(n, d, x, y, x1, y1, x2, y2);
                        }

                        var root = d3_geom_quadtreeNode();
                        root.add = function (d) {
                            insert(root, d, +fx(d, ++i), +fy(d, i), x1_, y1_, x2_, y2_);
                        };
                        root.visit = function (f) {
                            d3_geom_quadtreeVisit(f, root, x1_, y1_, x2_, y2_);
                        };
                        root.find = function (point) {
                            return d3_geom_quadtreeFind(root, point[0], point[1], x1_, y1_, x2_, y2_);
                        };
                        i = -1;
                        if (x1 == null) {
                            while (++i < n) {
                                insert(root, data[i], xs[i], ys[i], x1_, y1_, x2_, y2_);
                            }
                            --i;
                        } else data.forEach(root.add);
                        xs = ys = data = d = null;
                        return root;
                    }

                    quadtree.x = function (_) {
                        return arguments.length ? (x = _, quadtree) : x;
                    };
                    quadtree.y = function (_) {
                        return arguments.length ? (y = _, quadtree) : y;
                    };
                    quadtree.extent = function (_) {
                        if (!arguments.length) return x1 == null ? null : [[x1, y1], [x2, y2]];
                        if (_ == null) x1 = y1 = x2 = y2 = null; else x1 = +_[0][0], y1 = +_[0][1], x2 = +_[1][0],
                            y2 = +_[1][1];
                        return quadtree;
                    };
                    quadtree.size = function (_) {
                        if (!arguments.length) return x1 == null ? null : [x2 - x1, y2 - y1];
                        if (_ == null) x1 = y1 = x2 = y2 = null; else x1 = y1 = 0, x2 = +_[0], y2 = +_[1];
                        return quadtree;
                    };
                    return quadtree;
                };

                function d3_geom_quadtreeCompatX(d) {
                    return d.x;
                }

                function d3_geom_quadtreeCompatY(d) {
                    return d.y;
                }

                function d3_geom_quadtreeNode() {
                    return {
                        leaf: true,
                        nodes: [],
                        point: null,
                        x: null,
                        y: null
                    };
                }

                function d3_geom_quadtreeVisit(f, node, x1, y1, x2, y2) {
                    if (!f(node, x1, y1, x2, y2)) {
                        var sx = (x1 + x2) * .5, sy = (y1 + y2) * .5,
                            children = node.nodes;
                        if (children[0]) d3_geom_quadtreeVisit(f, children[0], x1, y1, sx, sy);
                        if (children[1]) d3_geom_quadtreeVisit(f, children[1], sx, y1, x2, sy);
                        if (children[2]) d3_geom_quadtreeVisit(f, children[2], x1, sy, sx, y2);
                        if (children[3]) d3_geom_quadtreeVisit(f, children[3], sx, sy, x2, y2);
                    }
                }

                function d3_geom_quadtreeFind(root, x, y, x0, y0, x3, y3) {
                    var minDistance2 = Infinity, closestPoint;
                    (function find(node, x1, y1, x2, y2) {
                        if (x1 > x3 || y1 > y3 || x2 < x0 || y2 < y0) return;
                        if (point = node.point) {
                            var point, dx = x - node.x, dy = y - node.y,
                                distance2 = dx * dx + dy * dy;
                            if (distance2 < minDistance2) {
                                var distance = Math.sqrt(minDistance2 = distance2);
                                x0 = x - distance, y0 = y - distance;
                                x3 = x + distance, y3 = y + distance;
                                closestPoint = point;
                            }
                        }
                        var children = node.nodes, xm = (x1 + x2) * .5,
                            ym = (y1 + y2) * .5, right = x >= xm,
                            below = y >= ym;
                        for (var i = below << 1 | right, j = i + 4; i < j; ++i) {
                            if (node = children[i & 3]) switch (i & 3) {
                                case 0:
                                    find(node, x1, y1, xm, ym);
                                    break;

                                case 1:
                                    find(node, xm, y1, x2, ym);
                                    break;

                                case 2:
                                    find(node, x1, ym, xm, y2);
                                    break;

                                case 3:
                                    find(node, xm, ym, x2, y2);
                                    break;
                            }
                        }
                    })(root, x0, y0, x3, y3);
                    return closestPoint;
                }

                d3.interpolateRgb = d3_interpolateRgb;

                function d3_interpolateRgb(a, b) {
                    a = d3.rgb(a);
                    b = d3.rgb(b);
                    var ar = a.r, ag = a.g, ab = a.b, br = b.r - ar,
                        bg = b.g - ag, bb = b.b - ab;
                    return function (t) {
                        return "#" + d3_rgb_hex(Math.round(ar + br * t)) + d3_rgb_hex(Math.round(ag + bg * t)) + d3_rgb_hex(Math.round(ab + bb * t));
                    };
                }

                d3.interpolateObject = d3_interpolateObject;

                function d3_interpolateObject(a, b) {
                    var i = {}, c = {}, k;
                    for (k in a) {
                        if (k in b) {
                            i[k] = d3_interpolate(a[k], b[k]);
                        } else {
                            c[k] = a[k];
                        }
                    }
                    for (k in b) {
                        if (!(k in a)) {
                            c[k] = b[k];
                        }
                    }
                    return function (t) {
                        for (k in i) c[k] = i[k](t);
                        return c;
                    };
                }

                d3.interpolateNumber = d3_interpolateNumber;

                function d3_interpolateNumber(a, b) {
                    a = +a, b = +b;
                    return function (t) {
                        return a * (1 - t) + b * t;
                    };
                }

                d3.interpolateString = d3_interpolateString;

                function d3_interpolateString(a, b) {
                    var bi = d3_interpolate_numberA.lastIndex = d3_interpolate_numberB.lastIndex = 0,
                        am, bm, bs, i = -1, s = [], q = [];
                    a = a + "", b = b + "";
                    while ((am = d3_interpolate_numberA.exec(a)) && (bm = d3_interpolate_numberB.exec(b))) {
                        if ((bs = bm.index) > bi) {
                            bs = b.slice(bi, bs);
                            if (s[i]) s[i] += bs; else s[++i] = bs;
                        }
                        if ((am = am[0]) === (bm = bm[0])) {
                            if (s[i]) s[i] += bm; else s[++i] = bm;
                        } else {
                            s[++i] = null;
                            q.push({
                                i: i,
                                x: d3_interpolateNumber(am, bm)
                            });
                        }
                        bi = d3_interpolate_numberB.lastIndex;
                    }
                    if (bi < b.length) {
                        bs = b.slice(bi);
                        if (s[i]) s[i] += bs; else s[++i] = bs;
                    }
                    return s.length < 2 ? q[0] ? (b = q[0].x, function (t) {
                        return b(t) + "";
                    }) : function () {
                        return b;
                    } : (b = q.length, function (t) {
                        for (var i = 0, o; i < b; ++i) s[(o = q[i]).i] = o.x(t);
                        return s.join("");
                    });
                }

                var d3_interpolate_numberA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,
                    d3_interpolate_numberB = new RegExp(d3_interpolate_numberA.source, "g");
                d3.interpolate = d3_interpolate;

                function d3_interpolate(a, b) {
                    var i = d3.interpolators.length, f;
                    while (--i >= 0 && !(f = d3.interpolators[i](a, b))) ;
                    return f;
                }

                d3.interpolators = [function (a, b) {
                    var t = typeof b;
                    return (t === "string" ? d3_rgb_names.has(b.toLowerCase()) || /^(#|rgb\(|hsl\()/i.test(b) ? d3_interpolateRgb : d3_interpolateString : b instanceof d3_color ? d3_interpolateRgb : Array.isArray(b) ? d3_interpolateArray : t === "object" && isNaN(b) ? d3_interpolateObject : d3_interpolateNumber)(a, b);
                }];
                d3.interpolateArray = d3_interpolateArray;

                function d3_interpolateArray(a, b) {
                    var x = [], c = [], na = a.length, nb = b.length,
                        n0 = Math.min(a.length, b.length), i;
                    for (i = 0; i < n0; ++i) x.push(d3_interpolate(a[i], b[i]));
                    for (; i < na; ++i) c[i] = a[i];
                    for (; i < nb; ++i) c[i] = b[i];
                    return function (t) {
                        for (i = 0; i < n0; ++i) c[i] = x[i](t);
                        return c;
                    };
                }

                var d3_ease_default = function () {
                    return d3_identity;
                };
                var d3_ease = d3.map({
                    linear: d3_ease_default,
                    poly: d3_ease_poly,
                    quad: function () {
                        return d3_ease_quad;
                    },
                    cubic: function () {
                        return d3_ease_cubic;
                    },
                    sin: function () {
                        return d3_ease_sin;
                    },
                    exp: function () {
                        return d3_ease_exp;
                    },
                    circle: function () {
                        return d3_ease_circle;
                    },
                    elastic: d3_ease_elastic,
                    back: d3_ease_back,
                    bounce: function () {
                        return d3_ease_bounce;
                    }
                });
                var d3_ease_mode = d3.map({
                    "in": d3_identity,
                    out: d3_ease_reverse,
                    "in-out": d3_ease_reflect,
                    "out-in": function (f) {
                        return d3_ease_reflect(d3_ease_reverse(f));
                    }
                });
                d3.ease = function (name) {
                    var i = name.indexOf("-"),
                        t = i >= 0 ? name.slice(0, i) : name,
                        m = i >= 0 ? name.slice(i + 1) : "in";
                    t = d3_ease.get(t) || d3_ease_default;
                    m = d3_ease_mode.get(m) || d3_identity;
                    return d3_ease_clamp(m(t.apply(null, d3_arraySlice.call(arguments, 1))));
                };

                function d3_ease_clamp(f) {
                    return function (t) {
                        return t <= 0 ? 0 : t >= 1 ? 1 : f(t);
                    };
                }

                function d3_ease_reverse(f) {
                    return function (t) {
                        return 1 - f(1 - t);
                    };
                }

                function d3_ease_reflect(f) {
                    return function (t) {
                        return .5 * (t < .5 ? f(2 * t) : 2 - f(2 - 2 * t));
                    };
                }

                function d3_ease_quad(t) {
                    return t * t;
                }

                function d3_ease_cubic(t) {
                    return t * t * t;
                }

                function d3_ease_cubicInOut(t) {
                    if (t <= 0) return 0;
                    if (t >= 1) return 1;
                    var t2 = t * t, t3 = t2 * t;
                    return 4 * (t < .5 ? t3 : 3 * (t - t2) + t3 - .75);
                }

                function d3_ease_poly(e) {
                    return function (t) {
                        return Math.pow(t, e);
                    };
                }

                function d3_ease_sin(t) {
                    return 1 - Math.cos(t * halfÏ€);
                }

                function d3_ease_exp(t) {
                    return Math.pow(2, 10 * (t - 1));
                }

                function d3_ease_circle(t) {
                    return 1 - Math.sqrt(1 - t * t);
                }

                function d3_ease_elastic(a, p) {
                    var s;
                    if (arguments.length < 2) p = .45;
                    if (arguments.length) s = p / Ï„ *
                    Math.asin(1 / a);
                else
                    a = 1, s = p / 4;
                    return function (t) {
                        return 1 + a * Math.pow(2, -10 * t) * Math.sin((t - s) * Ï„ / p);
                    };
                }

                function d3_ease_back(s) {
                    if (!s) s = 1.70158;
                    return function (t) {
                        return t * t * ((s + 1) * t - s);
                    };
                }

                function d3_ease_bounce(t) {
                    return t < 1 / 2.75 ? 7.5625 * t * t : t < 2 / 2.75 ? 7.5625 * (t -= 1.5 / 2.75) * t + .75 : t < 2.5 / 2.75 ? 7.5625 * (t -= 2.25 / 2.75) * t + .9375 : 7.5625 * (t -= 2.625 / 2.75) * t + .984375;
                }

                d3.interpolateHcl = d3_interpolateHcl;

                function d3_interpolateHcl(a, b) {
                    a = d3.hcl(a);
                    b = d3.hcl(b);
                    var ah = a.h, ac = a.c, al = a.l, bh = b.h - ah,
                        bc = b.c - ac, bl = b.l - al;
                    if (isNaN(bc)) bc = 0, ac = isNaN(ac) ? b.c : ac;
                    if (isNaN(bh)) bh = 0, ah = isNaN(ah) ? b.h : ah; else if (bh > 180) bh -= 360; else if (bh < -180) bh += 360;
                    return function (t) {
                        return d3_hcl_lab(ah + bh * t, ac + bc * t, al + bl * t) + "";
                    };
                }

                d3.interpolateHsl = d3_interpolateHsl;

                function d3_interpolateHsl(a, b) {
                    a = d3.hsl(a);
                    b = d3.hsl(b);
                    var ah = a.h, as = a.s, al = a.l, bh = b.h - ah,
                        bs = b.s - as, bl = b.l - al;
                    if (isNaN(bs)) bs = 0, as = isNaN(as) ? b.s : as;
                    if (isNaN(bh)) bh = 0, ah = isNaN(ah) ? b.h : ah; else if (bh > 180) bh -= 360; else if (bh < -180) bh += 360;
                    return function (t) {
                        return d3_hsl_rgb(ah + bh * t, as + bs * t, al + bl * t) + "";
                    };
                }

                d3.interpolateLab = d3_interpolateLab;

                function d3_interpolateLab(a, b) {
                    a = d3.lab(a);
                    b = d3.lab(b);
                    var al = a.l, aa = a.a, ab = a.b, bl = b.l - al,
                        ba = b.a - aa, bb = b.b - ab;
                    return function (t) {
                        return d3_lab_rgb(al + bl * t, aa + ba * t, ab + bb * t) + "";
                    };
                }

                d3.interpolateRound = d3_interpolateRound;

                function d3_interpolateRound(a, b) {
                    b -= a;
                    return function (t) {
                        return Math.round(a + b * t);
                    };
                }

                d3.transform = function (string) {
                    var g = d3_document.createElementNS(d3.ns.prefix.svg, "g");
                    return (d3.transform = function (string) {
                        if (string != null) {
                            g.setAttribute("transform", string);
                            var t = g.transform.baseVal.consolidate();
                        }
                        return new d3_transform(t ? t.matrix : d3_transformIdentity);
                    })(string);
                };

                function d3_transform(m) {
                    var r0 = [m.a, m.b], r1 = [m.c, m.d],
                        kx = d3_transformNormalize(r0),
                        kz = d3_transformDot(r0, r1),
                        ky = d3_transformNormalize(d3_transformCombine(r1, r0, -kz)) || 0;
                    if (r0[0] * r1[1] < r1[0] * r0[1]) {
                        r0[0] *= -1;
                        r0[1] *= -1;
                        kx *= -1;
                        kz *= -1;
                    }
                    this.rotate = (kx ? Math.atan2(r0[1], r0[0]) : Math.atan2(-r1[0], r1[1])) * d3_degrees;
                    this.translate = [m.e, m.f];
                    this.scale = [kx, ky];
                    this.skew = ky ? Math.atan2(kz, ky) * d3_degrees : 0;
                }

                d3_transform.prototype.toString = function () {
                    return "translate(" + this.translate + ")rotate(" + this.rotate + ")skewX(" + this.skew + ")scale(" + this.scale + ")";
                };

                function d3_transformDot(a, b) {
                    return a[0] * b[0] + a[1] * b[1];
                }

                function d3_transformNormalize(a) {
                    var k = Math.sqrt(d3_transformDot(a, a));
                    if (k) {
                        a[0] /= k;
                        a[1] /= k;
                    }
                    return k;
                }

                function d3_transformCombine(a, b, k) {
                    a[0] += k * b[0];
                    a[1] += k * b[1];
                    return a;
                }

                var d3_transformIdentity = {
                    a: 1,
                    b: 0,
                    c: 0,
                    d: 1,
                    e: 0,
                    f: 0
                };
                d3.interpolateTransform = d3_interpolateTransform;

                function d3_interpolateTransformPop(s) {
                    return s.length ? s.pop() + "," : "";
                }

                function d3_interpolateTranslate(ta, tb, s, q) {
                    if (ta[0] !== tb[0] || ta[1] !== tb[1]) {
                        var i = s.push("translate(", null, ",", null, ")");
                        q.push({
                            i: i - 4,
                            x: d3_interpolateNumber(ta[0], tb[0])
                        }, {
                            i: i - 2,
                            x: d3_interpolateNumber(ta[1], tb[1])
                        });
                    } else if (tb[0] || tb[1]) {
                        s.push("translate(" + tb + ")");
                    }
                }

                function d3_interpolateRotate(ra, rb, s, q) {
                    if (ra !== rb) {
                        if (ra - rb > 180) rb += 360; else if (rb - ra > 180) ra += 360;
                        q.push({
                            i: s.push(d3_interpolateTransformPop(s) + "rotate(", null, ")") - 2,
                            x: d3_interpolateNumber(ra, rb)
                        });
                    } else if (rb) {
                        s.push(d3_interpolateTransformPop(s) + "rotate(" + rb + ")");
                    }
                }

                function d3_interpolateSkew(wa, wb, s, q) {
                    if (wa !== wb) {
                        q.push({
                            i: s.push(d3_interpolateTransformPop(s) + "skewX(", null, ")") - 2,
                            x: d3_interpolateNumber(wa, wb)
                        });
                    } else if (wb) {
                        s.push(d3_interpolateTransformPop(s) + "skewX(" + wb + ")");
                    }
                }

                function d3_interpolateScale(ka, kb, s, q) {
                    if (ka[0] !== kb[0] || ka[1] !== kb[1]) {
                        var i = s.push(d3_interpolateTransformPop(s) + "scale(", null, ",", null, ")");
                        q.push({
                            i: i - 4,
                            x: d3_interpolateNumber(ka[0], kb[0])
                        }, {
                            i: i - 2,
                            x: d3_interpolateNumber(ka[1], kb[1])
                        });
                    } else if (kb[0] !== 1 || kb[1] !== 1) {
                        s.push(d3_interpolateTransformPop(s) + "scale(" + kb + ")");
                    }
                }

                function d3_interpolateTransform(a, b) {
                    var s = [], q = [];
                    a = d3.transform(a), b = d3.transform(b);
                    d3_interpolateTranslate(a.translate, b.translate, s, q);
                    d3_interpolateRotate(a.rotate, b.rotate, s, q);
                    d3_interpolateSkew(a.skew, b.skew, s, q);
                    d3_interpolateScale(a.scale, b.scale, s, q);
                    a = b = null;
                    return function (t) {
                        var i = -1, n = q.length, o;
                        while (++i < n) s[(o = q[i]).i] = o.x(t);
                        return s.join("");
                    };
                }

                function d3_uninterpolateNumber(a, b) {
                    b = (b -= a = +a) || 1 / b;
                    return function (x) {
                        return (x - a) / b;
                    };
                }

                function d3_uninterpolateClamp(a, b) {
                    b = (b -= a = +a) || 1 / b;
                    return function (x) {
                        return Math.max(0, Math.min(1, (x - a) / b));
                    };
                }

                d3.layout = {};
                d3.layout.bundle = function () {
                    return function (links) {
                        var paths = [], i = -1, n = links.length;
                        while (++i < n) paths.push(d3_layout_bundlePath(links[i]));
                        return paths;
                    };
                };

                function d3_layout_bundlePath(link) {
                    var start = link.source, end = link.target,
                        lca = d3_layout_bundleLeastCommonAncestor(start, end),
                        points = [start];
                    while (start !== lca) {
                        start = start.parent;
                        points.push(start);
                    }
                    var k = points.length;
                    while (end !== lca) {
                        points.splice(k, 0, end);
                        end = end.parent;
                    }
                    return points;
                }

                function d3_layout_bundleAncestors(node) {
                    var ancestors = [], parent = node.parent;
                    while (parent != null) {
                        ancestors.push(node);
                        node = parent;
                        parent = parent.parent;
                    }
                    ancestors.push(node);
                    return ancestors;
                }

                function d3_layout_bundleLeastCommonAncestor(a, b) {
                    if (a === b) return a;
                    var aNodes = d3_layout_bundleAncestors(a),
                        bNodes = d3_layout_bundleAncestors(b),
                        aNode = aNodes.pop(), bNode = bNodes.pop(),
                        sharedNode = null;
                    while (aNode === bNode) {
                        sharedNode = aNode;
                        aNode = aNodes.pop();
                        bNode = bNodes.pop();
                    }
                    return sharedNode;
                }

                d3.layout.chord = function () {
                    var chord = {}, chords, groups, matrix, n, padding = 0,
                        sortGroups, sortSubgroups, sortChords;

                    function relayout() {
                        var subgroups = {}, groupSums = [],
                            groupIndex = d3.range(n), subgroupIndex = [], k, x,
                            x0, i, j;
                        chords = [];
                        groups = [];
                        k = 0, i = -1;
                        while (++i < n) {
                            x = 0, j = -1;
                            while (++j < n) {
                                x += matrix[i][j];
                            }
                            groupSums.push(x);
                            subgroupIndex.push(d3.range(n));
                            k += x;
                        }
                        if (sortGroups) {
                            groupIndex.sort(function (a, b) {
                                return sortGroups(groupSums[a], groupSums[b]);
                            });
                        }
                        if (sortSubgroups) {
                            subgroupIndex.forEach(function (d, i) {
                                d.sort(function (a, b) {
                                    return sortSubgroups(matrix[i][a], matrix[i][b]);
                                });
                            });
                        }
                        k = (Ï„ -padding * n
                    ) /
                        k;
                        x = 0, i = -1;
                        while (++i < n) {
                            x0 = x, j = -1;
                            while (++j < n) {
                                var di = groupIndex[i],
                                    dj = subgroupIndex[di][j],
                                    v = matrix[di][dj], a0 = x, a1 = x += v * k;
                                subgroups[di + "-" + dj] = {
                                    index: di,
                                    subindex: dj,
                                    startAngle: a0,
                                    endAngle: a1,
                                    value: v
                                };
                            }
                            groups[di] = {
                                index: di,
                                startAngle: x0,
                                endAngle: x,
                                value: groupSums[di]
                            };
                            x += padding;
                        }
                        i = -1;
                        while (++i < n) {
                            j = i - 1;
                            while (++j < n) {
                                var source = subgroups[i + "-" + j],
                                    target = subgroups[j + "-" + i];
                                if (source.value || target.value) {
                                    chords.push(source.value < target.value ? {
                                        source: target,
                                        target: source
                                    } : {
                                        source: source,
                                        target: target
                                    });
                                }
                            }
                        }
                        if (sortChords) resort();
                    }

                    function resort() {
                        chords.sort(function (a, b) {
                            return sortChords((a.source.value + a.target.value) / 2, (b.source.value + b.target.value) / 2);
                        });
                    }

                    chord.matrix = function (x) {
                        if (!arguments.length) return matrix;
                        n = (matrix = x) && matrix.length;
                        chords = groups = null;
                        return chord;
                    };
                    chord.padding = function (x) {
                        if (!arguments.length) return padding;
                        padding = x;
                        chords = groups = null;
                        return chord;
                    };
                    chord.sortGroups = function (x) {
                        if (!arguments.length) return sortGroups;
                        sortGroups = x;
                        chords = groups = null;
                        return chord;
                    };
                    chord.sortSubgroups = function (x) {
                        if (!arguments.length) return sortSubgroups;
                        sortSubgroups = x;
                        chords = null;
                        return chord;
                    };
                    chord.sortChords = function (x) {
                        if (!arguments.length) return sortChords;
                        sortChords = x;
                        if (chords) resort();
                        return chord;
                    };
                    chord.chords = function () {
                        if (!chords) relayout();
                        return chords;
                    };
                    chord.groups = function () {
                        if (!groups) relayout();
                        return groups;
                    };
                    return chord;
                };
                d3.layout.force = function () {
                    var force = {}, event = d3.dispatch("start", "tick", "end"),
                        timer, size = [1, 1], drag, alpha, friction = .9,
                        linkDistance = d3_layout_forceLinkDistance,
                        linkStrength = d3_layout_forceLinkStrength,
                        charge = -30,
                        chargeDistance2 = d3_layout_forceChargeDistance2,
                        gravity = .1, theta2 = .64, nodes = [], links = [],
                        distances, strengths, charges;

                    function repulse(node) {
                        return function (quad, x1, _, x2) {
                            if (quad.point !== node) {
                                var dx = quad.cx - node.x,
                                    dy = quad.cy - node.y, dw = x2 - x1,
                                    dn = dx * dx + dy * dy;
                                if (dw * dw / theta2 < dn) {
                                    if (dn < chargeDistance2) {
                                        var k = quad.charge / dn;
                                        node.px -= dx * k;
                                        node.py -= dy * k;
                                    }
                                    return true;
                                }
                                if (quad.point && dn && dn < chargeDistance2) {
                                    var k = quad.pointCharge / dn;
                                    node.px -= dx * k;
                                    node.py -= dy * k;
                                }
                            }
                            return !quad.charge;
                        };
                    }

                    force.tick = function () {
                        if ((alpha *= .99) < .005) {
                            timer = null;
                            event.end({
                                type: "end",
                                alpha: alpha = 0
                            });
                            return true;
                        }
                        var n = nodes.length, m = links.length, q, i, o, s, t,
                            l, k, x, y;
                        for (i = 0; i < m; ++i) {
                            o = links[i];
                            s = o.source;
                            t = o.target;
                            x = t.x - s.x;
                            y = t.y - s.y;
                            if (l = x * x + y * y) {
                                l = alpha * strengths[i] * ((l = Math.sqrt(l)) - distances[i]) / l;
                                x *= l;
                                y *= l;
                                t.x -= x * (k = s.weight + t.weight ? s.weight / (s.weight + t.weight) : .5);
                                t.y -= y * k;
                                s.x += x * (k = 1 - k);
                                s.y += y * k;
                            }
                        }
                        if (k = alpha * gravity) {
                            x = size[0] / 2;
                            y = size[1] / 2;
                            i = -1;
                            if (k) while (++i < n) {
                                o = nodes[i];
                                o.x += (x - o.x) * k;
                                o.y += (y - o.y) * k;
                            }
                        }
                        if (charge) {
                            d3_layout_forceAccumulate(q = d3.geom.quadtree(nodes), alpha, charges);
                            i = -1;
                            while (++i < n) {
                                if (!(o = nodes[i]).fixed) {
                                    q.visit(repulse(o));
                                }
                            }
                        }
                        i = -1;
                        while (++i < n) {
                            o = nodes[i];
                            if (o.fixed) {
                                o.x = o.px;
                                o.y = o.py;
                            } else {
                                o.x -= (o.px - (o.px = o.x)) * friction;
                                o.y -= (o.py - (o.py = o.y)) * friction;
                            }
                        }
                        event.tick({
                            type: "tick",
                            alpha: alpha
                        });
                    };
                    force.nodes = function (x) {
                        if (!arguments.length) return nodes;
                        nodes = x;
                        return force;
                    };
                    force.links = function (x) {
                        if (!arguments.length) return links;
                        links = x;
                        return force;
                    };
                    force.size = function (x) {
                        if (!arguments.length) return size;
                        size = x;
                        return force;
                    };
                    force.linkDistance = function (x) {
                        if (!arguments.length) return linkDistance;
                        linkDistance = typeof x === "function" ? x : +x;
                        return force;
                    };
                    force.distance = force.linkDistance;
                    force.linkStrength = function (x) {
                        if (!arguments.length) return linkStrength;
                        linkStrength = typeof x === "function" ? x : +x;
                        return force;
                    };
                    force.friction = function (x) {
                        if (!arguments.length) return friction;
                        friction = +x;
                        return force;
                    };
                    force.charge = function (x) {
                        if (!arguments.length) return charge;
                        charge = typeof x === "function" ? x : +x;
                        return force;
                    };
                    force.chargeDistance = function (x) {
                        if (!arguments.length) return Math.sqrt(chargeDistance2);
                        chargeDistance2 = x * x;
                        return force;
                    };
                    force.gravity = function (x) {
                        if (!arguments.length) return gravity;
                        gravity = +x;
                        return force;
                    };
                    force.theta = function (x) {
                        if (!arguments.length) return Math.sqrt(theta2);
                        theta2 = x * x;
                        return force;
                    };
                    force.alpha = function (x) {
                        if (!arguments.length) return alpha;
                        x = +x;
                        if (alpha) {
                            if (x > 0) {
                                alpha = x;
                            } else {
                                timer.c = null, timer.t = NaN, timer = null;
                                event.end({
                                    type: "end",
                                    alpha: alpha = 0
                                });
                            }
                        } else if (x > 0) {
                            event.start({
                                type: "start",
                                alpha: alpha = x
                            });
                            timer = d3_timer(force.tick);
                        }
                        return force;
                    };
                    force.start = function () {
                        var i, n = nodes.length, m = links.length, w = size[0],
                            h = size[1], neighbors, o;
                        for (i = 0; i < n; ++i) {
                            (o = nodes[i]).index = i;
                            o.weight = 0;
                        }
                        for (i = 0; i < m; ++i) {
                            o = links[i];
                            if (typeof o.source == "number") o.source = nodes[o.source];
                            if (typeof o.target == "number") o.target = nodes[o.target];
                            ++o.source.weight;
                            ++o.target.weight;
                        }
                        for (i = 0; i < n; ++i) {
                            o = nodes[i];
                            if (isNaN(o.x)) o.x = position("x", w);
                            if (isNaN(o.y)) o.y = position("y", h);
                            if (isNaN(o.px)) o.px = o.x;
                            if (isNaN(o.py)) o.py = o.y;
                        }
                        distances = [];
                        if (typeof linkDistance === "function") for (i = 0; i < m; ++i) distances[i] = +linkDistance.call(this, links[i], i); else for (i = 0; i < m; ++i) distances[i] = linkDistance;
                        strengths = [];
                        if (typeof linkStrength === "function") for (i = 0; i < m; ++i) strengths[i] = +linkStrength.call(this, links[i], i); else for (i = 0; i < m; ++i) strengths[i] = linkStrength;
                        charges = [];
                        if (typeof charge === "function") for (i = 0; i < n; ++i) charges[i] = +charge.call(this, nodes[i], i); else for (i = 0; i < n; ++i) charges[i] = charge;

                        function position(dimension, size) {
                            if (!neighbors) {
                                neighbors = new Array(n);
                                for (j = 0; j < n; ++j) {
                                    neighbors[j] = [];
                                }
                                for (j = 0; j < m; ++j) {
                                    var o = links[j];
                                    neighbors[o.source.index].push(o.target);
                                    neighbors[o.target.index].push(o.source);
                                }
                            }
                            var candidates = neighbors[i], j = -1,
                                l = candidates.length, x;
                            while (++j < l) if (!isNaN(x = candidates[j][dimension])) return x;
                            return Math.random() * size;
                        }

                        return force.resume();
                    };
                    force.resume = function () {
                        return force.alpha(.1);
                    };
                    force.stop = function () {
                        return force.alpha(0);
                    };
                    force.drag = function () {
                        if (!drag) drag = d3.behavior.drag().origin(d3_identity).on("dragstart.force", d3_layout_forceDragstart).on("drag.force", dragmove).on("dragend.force", d3_layout_forceDragend);
                        if (!arguments.length) return drag;
                        this.on("mouseover.force", d3_layout_forceMouseover).on("mouseout.force", d3_layout_forceMouseout).call(drag);
                    };

                    function dragmove(d) {
                        d.px = d3.event.x, d.py = d3.event.y;
                        force.resume();
                    }

                    return d3.rebind(force, event, "on");
                };

                function d3_layout_forceDragstart(d) {
                    d.fixed |= 2;
                }

                function d3_layout_forceDragend(d) {
                    d.fixed &= ~6;
                }

                function d3_layout_forceMouseover(d) {
                    d.fixed |= 4;
                    d.px = d.x, d.py = d.y;
                }

                function d3_layout_forceMouseout(d) {
                    d.fixed &= ~4;
                }

                function d3_layout_forceAccumulate(quad, alpha, charges) {
                    var cx = 0, cy = 0;
                    quad.charge = 0;
                    if (!quad.leaf) {
                        var nodes = quad.nodes, n = nodes.length, i = -1, c;
                        while (++i < n) {
                            c = nodes[i];
                            if (c == null) continue;
                            d3_layout_forceAccumulate(c, alpha, charges);
                            quad.charge += c.charge;
                            cx += c.charge * c.cx;
                            cy += c.charge * c.cy;
                        }
                    }
                    if (quad.point) {
                        if (!quad.leaf) {
                            quad.point.x += Math.random() - .5;
                            quad.point.y += Math.random() - .5;
                        }
                        var k = alpha * charges[quad.point.index];
                        quad.charge += quad.pointCharge = k;
                        cx += k * quad.point.x;
                        cy += k * quad.point.y;
                    }
                    quad.cx = cx / quad.charge;
                    quad.cy = cy / quad.charge;
                }

                var d3_layout_forceLinkDistance = 20,
                    d3_layout_forceLinkStrength = 1,
                    d3_layout_forceChargeDistance2 = Infinity;
                d3.layout.hierarchy = function () {
                    var sort = d3_layout_hierarchySort,
                        children = d3_layout_hierarchyChildren,
                        value = d3_layout_hierarchyValue;

                    function hierarchy(root) {
                        var stack = [root], nodes = [], node;
                        root.depth = 0;
                        while ((node = stack.pop()) != null) {
                            nodes.push(node);
                            if ((childs = children.call(hierarchy, node, node.depth)) && (n = childs.length)) {
                                var n, childs, child;
                                while (--n >= 0) {
                                    stack.push(child = childs[n]);
                                    child.parent = node;
                                    child.depth = node.depth + 1;
                                }
                                if (value) node.value = 0;
                                node.children = childs;
                            } else {
                                if (value) node.value = +value.call(hierarchy, node, node.depth) || 0;
                                delete node.children;
                            }
                        }
                        d3_layout_hierarchyVisitAfter(root, function (node) {
                            var childs, parent;
                            if (sort && (childs = node.children)) childs.sort(sort);
                            if (value && (parent = node.parent)) parent.value += node.value;
                        });
                        return nodes;
                    }

                    hierarchy.sort = function (x) {
                        if (!arguments.length) return sort;
                        sort = x;
                        return hierarchy;
                    };
                    hierarchy.children = function (x) {
                        if (!arguments.length) return children;
                        children = x;
                        return hierarchy;
                    };
                    hierarchy.value = function (x) {
                        if (!arguments.length) return value;
                        value = x;
                        return hierarchy;
                    };
                    hierarchy.revalue = function (root) {
                        if (value) {
                            d3_layout_hierarchyVisitBefore(root, function (node) {
                                if (node.children) node.value = 0;
                            });
                            d3_layout_hierarchyVisitAfter(root, function (node) {
                                var parent;
                                if (!node.children) node.value = +value.call(hierarchy, node, node.depth) || 0;
                                if (parent = node.parent) parent.value += node.value;
                            });
                        }
                        return root;
                    };
                    return hierarchy;
                };

                function d3_layout_hierarchyRebind(object, hierarchy) {
                    d3.rebind(object, hierarchy, "sort", "children", "value");
                    object.nodes = object;
                    object.links = d3_layout_hierarchyLinks;
                    return object;
                }

                function d3_layout_hierarchyVisitBefore(node, callback) {
                    var nodes = [node];
                    while ((node = nodes.pop()) != null) {
                        callback(node);
                        if ((children = node.children) && (n = children.length)) {
                            var n, children;
                            while (--n >= 0) nodes.push(children[n]);
                        }
                    }
                }

                function d3_layout_hierarchyVisitAfter(node, callback) {
                    var nodes = [node], nodes2 = [];
                    while ((node = nodes.pop()) != null) {
                        nodes2.push(node);
                        if ((children = node.children) && (n = children.length)) {
                            var i = -1, n, children;
                            while (++i < n) nodes.push(children[i]);
                        }
                    }
                    while ((node = nodes2.pop()) != null) {
                        callback(node);
                    }
                }

                function d3_layout_hierarchyChildren(d) {
                    return d.children;
                }

                function d3_layout_hierarchyValue(d) {
                    return d.value;
                }

                function d3_layout_hierarchySort(a, b) {
                    return b.value - a.value;
                }

                function d3_layout_hierarchyLinks(nodes) {
                    return d3.merge(nodes.map(function (parent) {
                        return (parent.children || []).map(function (child) {
                            return {
                                source: parent,
                                target: child
                            };
                        });
                    }));
                }

                d3.layout.partition = function () {
                    var hierarchy = d3.layout.hierarchy(), size = [1, 1];

                    function position(node, x, dx, dy) {
                        var children = node.children;
                        node.x = x;
                        node.y = node.depth * dy;
                        node.dx = dx;
                        node.dy = dy;
                        if (children && (n = children.length)) {
                            var i = -1, n, c, d;
                            dx = node.value ? dx / node.value : 0;
                            while (++i < n) {
                                position(c = children[i], x, d = c.value * dx, dy);
                                x += d;
                            }
                        }
                    }

                    function depth(node) {
                        var children = node.children, d = 0;
                        if (children && (n = children.length)) {
                            var i = -1, n;
                            while (++i < n) d = Math.max(d, depth(children[i]));
                        }
                        return 1 + d;
                    }

                    function partition(d, i) {
                        var nodes = hierarchy.call(this, d, i);
                        position(nodes[0], 0, size[0], size[1] / depth(nodes[0]));
                        return nodes;
                    }

                    partition.size = function (x) {
                        if (!arguments.length) return size;
                        size = x;
                        return partition;
                    };
                    return d3_layout_hierarchyRebind(partition, hierarchy);
                };
                d3.layout.pie = function () {
                    var value = Number, sort = d3_layout_pieSortByValue,
                        startAngle = 0, endAngle = Ï„,
                    padAngle = 0;

                    function pie(data) {
                        var n = data.length, values = data.map(function (d, i) {
                                return +value.call(pie, d, i);
                            }),
                            a = +(typeof startAngle === "function" ? startAngle.apply(this, arguments) : startAngle),
                            da = (typeof endAngle === "function" ? endAngle.apply(this, arguments) : endAngle) - a,
                            p = Math.min(Math.abs(da) / n, +(typeof padAngle === "function" ? padAngle.apply(this, arguments) : padAngle)),
                            pa = p * (da < 0 ? -1 : 1), sum = d3.sum(values),
                            k = sum ? (da - n * pa) / sum : 0,
                            index = d3.range(n), arcs = [], v;
                        if (sort != null) index.sort(sort === d3_layout_pieSortByValue ? function (i, j) {
                            return values[j] - values[i];
                        } : function (i, j) {
                            return sort(data[i], data[j]);
                        });
                        index.forEach(function (i) {
                            arcs[i] = {
                                data: data[i],
                                value: v = values[i],
                                startAngle: a,
                                endAngle: a += v * k + pa,
                                padAngle: p
                            };
                        });
                        return arcs;
                    }

                    pie.value = function (_) {
                        if (!arguments.length) return value;
                        value = _;
                        return pie;
                    };
                    pie.sort = function (_) {
                        if (!arguments.length) return sort;
                        sort = _;
                        return pie;
                    };
                    pie.startAngle = function (_) {
                        if (!arguments.length) return startAngle;
                        startAngle = _;
                        return pie;
                    };
                    pie.endAngle = function (_) {
                        if (!arguments.length) return endAngle;
                        endAngle = _;
                        return pie;
                    };
                    pie.padAngle = function (_) {
                        if (!arguments.length) return padAngle;
                        padAngle = _;
                        return pie;
                    };
                    return pie;
                };
                var d3_layout_pieSortByValue = {};
                d3.layout.stack = function () {
                    var values = d3_identity,
                        order = d3_layout_stackOrderDefault,
                        offset = d3_layout_stackOffsetZero,
                        out = d3_layout_stackOut, x = d3_layout_stackX,
                        y = d3_layout_stackY;

                    function stack(data, index) {
                        if (!(n = data.length)) return data;
                        var series = data.map(function (d, i) {
                            return values.call(stack, d, i);
                        });
                        var points = series.map(function (d) {
                            return d.map(function (v, i) {
                                return [x.call(stack, v, i), y.call(stack, v, i)];
                            });
                        });
                        var orders = order.call(stack, points, index);
                        series = d3.permute(series, orders);
                        points = d3.permute(points, orders);
                        var offsets = offset.call(stack, points, index);
                        var m = series[0].length, n, i, j, o;
                        for (j = 0; j < m; ++j) {
                            out.call(stack, series[0][j], o = offsets[j], points[0][j][1]);
                            for (i = 1; i < n; ++i) {
                                out.call(stack, series[i][j], o += points[i - 1][j][1], points[i][j][1]);
                            }
                        }
                        return data;
                    }

                    stack.values = function (x) {
                        if (!arguments.length) return values;
                        values = x;
                        return stack;
                    };
                    stack.order = function (x) {
                        if (!arguments.length) return order;
                        order = typeof x === "function" ? x : d3_layout_stackOrders.get(x) || d3_layout_stackOrderDefault;
                        return stack;
                    };
                    stack.offset = function (x) {
                        if (!arguments.length) return offset;
                        offset = typeof x === "function" ? x : d3_layout_stackOffsets.get(x) || d3_layout_stackOffsetZero;
                        return stack;
                    };
                    stack.x = function (z) {
                        if (!arguments.length) return x;
                        x = z;
                        return stack;
                    };
                    stack.y = function (z) {
                        if (!arguments.length) return y;
                        y = z;
                        return stack;
                    };
                    stack.out = function (z) {
                        if (!arguments.length) return out;
                        out = z;
                        return stack;
                    };
                    return stack;
                };

                function d3_layout_stackX(d) {
                    return d.x;
                }

                function d3_layout_stackY(d) {
                    return d.y;
                }

                function d3_layout_stackOut(d, y0, y) {
                    d.y0 = y0;
                    d.y = y;
                }

                var d3_layout_stackOrders = d3.map({
                    "inside-out": function (data) {
                        var n = data.length, i, j,
                            max = data.map(d3_layout_stackMaxIndex),
                            sums = data.map(d3_layout_stackReduceSum),
                            index = d3.range(n).sort(function (a, b) {
                                return max[a] - max[b];
                            }), top = 0, bottom = 0, tops = [], bottoms = [];
                        for (i = 0; i < n; ++i) {
                            j = index[i];
                            if (top < bottom) {
                                top += sums[j];
                                tops.push(j);
                            } else {
                                bottom += sums[j];
                                bottoms.push(j);
                            }
                        }
                        return bottoms.reverse().concat(tops);
                    },
                    reverse: function (data) {
                        return d3.range(data.length).reverse();
                    },
                    "default": d3_layout_stackOrderDefault
                });
                var d3_layout_stackOffsets = d3.map({
                    silhouette: function (data) {
                        var n = data.length, m = data[0].length, sums = [],
                            max = 0, i, j, o, y0 = [];
                        for (j = 0; j < m; ++j) {
                            for (i = 0, o = 0; i < n; i++) o += data[i][j][1];
                            if (o > max) max = o;
                            sums.push(o);
                        }
                        for (j = 0; j < m; ++j) {
                            y0[j] = (max - sums[j]) / 2;
                        }
                        return y0;
                    },
                    wiggle: function (data) {
                        var n = data.length, x = data[0], m = x.length, i, j, k,
                            s1, s2, s3, dx, o, o0, y0 = [];
                        y0[0] = o = o0 = 0;
                        for (j = 1; j < m; ++j) {
                            for (i = 0, s1 = 0; i < n; ++i) s1 += data[i][j][1];
                            for (i = 0, s2 = 0, dx = x[j][0] - x[j - 1][0]; i < n; ++i) {
                                for (k = 0, s3 = (data[i][j][1] - data[i][j - 1][1]) / (2 * dx); k < i; ++k) {
                                    s3 += (data[k][j][1] - data[k][j - 1][1]) / dx;
                                }
                                s2 += s3 * data[i][j][1];
                            }
                            y0[j] = o -= s1 ? s2 / s1 * dx : 0;
                            if (o < o0) o0 = o;
                        }
                        for (j = 0; j < m; ++j) y0[j] -= o0;
                        return y0;
                    },
                    expand: function (data) {
                        var n = data.length, m = data[0].length, k = 1 / n, i,
                            j, o, y0 = [];
                        for (j = 0; j < m; ++j) {
                            for (i = 0, o = 0; i < n; i++) o += data[i][j][1];
                            if (o) for (i = 0; i < n; i++) data[i][j][1] /= o; else for (i = 0; i < n; i++) data[i][j][1] = k;
                        }
                        for (j = 0; j < m; ++j) y0[j] = 0;
                        return y0;
                    },
                    zero: d3_layout_stackOffsetZero
                });

                function d3_layout_stackOrderDefault(data) {
                    return d3.range(data.length);
                }

                function d3_layout_stackOffsetZero(data) {
                    var j = -1, m = data[0].length, y0 = [];
                    while (++j < m) y0[j] = 0;
                    return y0;
                }

                function d3_layout_stackMaxIndex(array) {
                    var i = 1, j = 0, v = array[0][1], k, n = array.length;
                    for (; i < n; ++i) {
                        if ((k = array[i][1]) > v) {
                            j = i;
                            v = k;
                        }
                    }
                    return j;
                }

                function d3_layout_stackReduceSum(d) {
                    return d.reduce(d3_layout_stackSum, 0);
                }

                function d3_layout_stackSum(p, d) {
                    return p + d[1];
                }

                d3.layout.histogram = function () {
                    var frequency = true, valuer = Number,
                        ranger = d3_layout_histogramRange,
                        binner = d3_layout_histogramBinSturges;

                    function histogram(data, i) {
                        var bins = [], values = data.map(valuer, this),
                            range = ranger.call(this, values, i),
                            thresholds = binner.call(this, range, values, i),
                            bin, i = -1, n = values.length,
                            m = thresholds.length - 1,
                            k = frequency ? 1 : 1 / n, x;
                        while (++i < m) {
                            bin = bins[i] = [];
                            bin.dx = thresholds[i + 1] - (bin.x = thresholds[i]);
                            bin.y = 0;
                        }
                        if (m > 0) {
                            i = -1;
                            while (++i < n) {
                                x = values[i];
                                if (x >= range[0] && x <= range[1]) {
                                    bin = bins[d3.bisect(thresholds, x, 1, m) - 1];
                                    bin.y += k;
                                    bin.push(data[i]);
                                }
                            }
                        }
                        return bins;
                    }

                    histogram.value = function (x) {
                        if (!arguments.length) return valuer;
                        valuer = x;
                        return histogram;
                    };
                    histogram.range = function (x) {
                        if (!arguments.length) return ranger;
                        ranger = d3_functor(x);
                        return histogram;
                    };
                    histogram.bins = function (x) {
                        if (!arguments.length) return binner;
                        binner = typeof x === "number" ? function (range) {
                            return d3_layout_histogramBinFixed(range, x);
                        } : d3_functor(x);
                        return histogram;
                    };
                    histogram.frequency = function (x) {
                        if (!arguments.length) return frequency;
                        frequency = !!x;
                        return histogram;
                    };
                    return histogram;
                };

                function d3_layout_histogramBinSturges(range, values) {
                    return d3_layout_histogramBinFixed(range, Math.ceil(Math.log(values.length) / Math.LN2 + 1));
                }

                function d3_layout_histogramBinFixed(range, n) {
                    var x = -1, b = +range[0], m = (range[1] - b) / n, f = [];
                    while (++x <= n) f[x] = m * x + b;
                    return f;
                }

                function d3_layout_histogramRange(values) {
                    return [d3.min(values), d3.max(values)];
                }

                d3.layout.pack = function () {
                    var hierarchy = d3.layout.hierarchy().sort(d3_layout_packSort),
                        padding = 0, size = [1, 1], radius;

                    function pack(d, i) {
                        var nodes = hierarchy.call(this, d, i), root = nodes[0],
                            w = size[0], h = size[1],
                            r = radius == null ? Math.sqrt : typeof radius === "function" ? radius : function () {
                                return radius;
                            };
                        root.x = root.y = 0;
                        d3_layout_hierarchyVisitAfter(root, function (d) {
                            d.r = +r(d.value);
                        });
                        d3_layout_hierarchyVisitAfter(root, d3_layout_packSiblings);
                        if (padding) {
                            var dr = padding * (radius ? 1 : Math.max(2 * root.r / w, 2 * root.r / h)) / 2;
                            d3_layout_hierarchyVisitAfter(root, function (d) {
                                d.r += dr;
                            });
                            d3_layout_hierarchyVisitAfter(root, d3_layout_packSiblings);
                            d3_layout_hierarchyVisitAfter(root, function (d) {
                                d.r -= dr;
                            });
                        }
                        d3_layout_packTransform(root, w / 2, h / 2, radius ? 1 : 1 / Math.max(2 * root.r / w, 2 * root.r / h));
                        return nodes;
                    }

                    pack.size = function (_) {
                        if (!arguments.length) return size;
                        size = _;
                        return pack;
                    };
                    pack.radius = function (_) {
                        if (!arguments.length) return radius;
                        radius = _ == null || typeof _ === "function" ? _ : +_;
                        return pack;
                    };
                    pack.padding = function (_) {
                        if (!arguments.length) return padding;
                        padding = +_;
                        return pack;
                    };
                    return d3_layout_hierarchyRebind(pack, hierarchy);
                };

                function d3_layout_packSort(a, b) {
                    return a.value - b.value;
                }

                function d3_layout_packInsert(a, b) {
                    var c = a._pack_next;
                    a._pack_next = b;
                    b._pack_prev = a;
                    b._pack_next = c;
                    c._pack_prev = b;
                }

                function d3_layout_packSplice(a, b) {
                    a._pack_next = b;
                    b._pack_prev = a;
                }

                function d3_layout_packIntersects(a, b) {
                    var dx = b.x - a.x, dy = b.y - a.y, dr = a.r + b.r;
                    return .999 * dr * dr > dx * dx + dy * dy;
                }

                function d3_layout_packSiblings(node) {
                    if (!(nodes = node.children) || !(n = nodes.length)) return;
                    var nodes, xMin = Infinity, xMax = -Infinity,
                        yMin = Infinity, yMax = -Infinity, a, b, c, i, j, k, n;

                    function bound(node) {
                        xMin = Math.min(node.x - node.r, xMin);
                        xMax = Math.max(node.x + node.r, xMax);
                        yMin = Math.min(node.y - node.r, yMin);
                        yMax = Math.max(node.y + node.r, yMax);
                    }

                    nodes.forEach(d3_layout_packLink);
                    a = nodes[0];
                    a.x = -a.r;
                    a.y = 0;
                    bound(a);
                    if (n > 1) {
                        b = nodes[1];
                        b.x = b.r;
                        b.y = 0;
                        bound(b);
                        if (n > 2) {
                            c = nodes[2];
                            d3_layout_packPlace(a, b, c);
                            bound(c);
                            d3_layout_packInsert(a, c);
                            a._pack_prev = c;
                            d3_layout_packInsert(c, b);
                            b = a._pack_next;
                            for (i = 3; i < n; i++) {
                                d3_layout_packPlace(a, b, c = nodes[i]);
                                var isect = 0, s1 = 1, s2 = 1;
                                for (j = b._pack_next; j !== b; j = j._pack_next, s1++) {
                                    if (d3_layout_packIntersects(j, c)) {
                                        isect = 1;
                                        break;
                                    }
                                }
                                if (isect == 1) {
                                    for (k = a._pack_prev; k !== j._pack_prev; k = k._pack_prev, s2++) {
                                        if (d3_layout_packIntersects(k, c)) {
                                            break;
                                        }
                                    }
                                }
                                if (isect) {
                                    if (s1 < s2 || s1 == s2 && b.r < a.r) d3_layout_packSplice(a, b = j); else d3_layout_packSplice(a = k, b);
                                    i--;
                                } else {
                                    d3_layout_packInsert(a, c);
                                    b = c;
                                    bound(c);
                                }
                            }
                        }
                    }
                    var cx = (xMin + xMax) / 2, cy = (yMin + yMax) / 2, cr = 0;
                    for (i = 0; i < n; i++) {
                        c = nodes[i];
                        c.x -= cx;
                        c.y -= cy;
                        cr = Math.max(cr, c.r + Math.sqrt(c.x * c.x + c.y * c.y));
                    }
                    node.r = cr;
                    nodes.forEach(d3_layout_packUnlink);
                }

                function d3_layout_packLink(node) {
                    node._pack_next = node._pack_prev = node;
                }

                function d3_layout_packUnlink(node) {
                    delete node._pack_next;
                    delete node._pack_prev;
                }

                function d3_layout_packTransform(node, x, y, k) {
                    var children = node.children;
                    node.x = x += k * node.x;
                    node.y = y += k * node.y;
                    node.r *= k;
                    if (children) {
                        var i = -1, n = children.length;
                        while (++i < n) d3_layout_packTransform(children[i], x, y, k);
                    }
                }

                function d3_layout_packPlace(a, b, c) {
                    var db = a.r + c.r, dx = b.x - a.x, dy = b.y - a.y;
                    if (db && (dx || dy)) {
                        var da = b.r + c.r, dc = dx * dx + dy * dy;
                        da *= da;
                        db *= db;
                        var x = .5 + (db - da) / (2 * dc),
                            y = Math.sqrt(Math.max(0, 2 * da * (db + dc) - (db -= dc) * db - da * da)) / (2 * dc);
                        c.x = a.x + x * dx + y * dy;
                        c.y = a.y + x * dy - y * dx;
                    } else {
                        c.x = a.x + db;
                        c.y = a.y;
                    }
                }

                d3.layout.tree = function () {
                    var hierarchy = d3.layout.hierarchy().sort(null).value(null),
                        separation = d3_layout_treeSeparation, size = [1, 1],
                        nodeSize = null;

                    function tree(d, i) {
                        var nodes = hierarchy.call(this, d, i),
                            root0 = nodes[0], root1 = wrapTree(root0);
                        d3_layout_hierarchyVisitAfter(root1, firstWalk), root1.parent.m = -root1.z;
                        d3_layout_hierarchyVisitBefore(root1, secondWalk);
                        if (nodeSize) d3_layout_hierarchyVisitBefore(root0, sizeNode); else {
                            var left = root0, right = root0, bottom = root0;
                            d3_layout_hierarchyVisitBefore(root0, function (node) {
                                if (node.x < left.x) left = node;
                                if (node.x > right.x) right = node;
                                if (node.depth > bottom.depth) bottom = node;
                            });
                            var tx = separation(left, right) / 2 - left.x,
                                kx = size[0] / (right.x + separation(right, left) / 2 + tx),
                                ky = size[1] / (bottom.depth || 1);
                            d3_layout_hierarchyVisitBefore(root0, function (node) {
                                node.x = (node.x + tx) * kx;
                                node.y = node.depth * ky;
                            });
                        }
                        return nodes;
                    }

                    function wrapTree(root0) {
                        var root1 = {
                            A: null,
                            children: [root0]
                        }, queue = [root1], node1;
                        while ((node1 = queue.pop()) != null) {
                            for (var children = node1.children, child, i = 0, n = children.length; i < n; ++i) {
                                queue.push((children[i] = child = {
                                    _: children[i],
                                    parent: node1,
                                    children: (child = children[i].children) && child.slice() || [],
                                    A: null,
                                    a: null,
                                    z: 0,
                                    m: 0,
                                    c: 0,
                                    s: 0,
                                    t: null,
                                    i: i
                                }).a = child);
                            }
                        }
                        return root1.children[0];
                    }

                    function firstWalk(v) {
                        var children = v.children, siblings = v.parent.children,
                            w = v.i ? siblings[v.i - 1] : null;
                        if (children.length) {
                            d3_layout_treeShift(v);
                            var midpoint = (children[0].z + children[children.length - 1].z) / 2;
                            if (w) {
                                v.z = w.z + separation(v._, w._);
                                v.m = v.z - midpoint;
                            } else {
                                v.z = midpoint;
                            }
                        } else if (w) {
                            v.z = w.z + separation(v._, w._);
                        }
                        v.parent.A = apportion(v, w, v.parent.A || siblings[0]);
                    }

                    function secondWalk(v) {
                        v._.x = v.z + v.parent.m;
                        v.m += v.parent.m;
                    }

                    function apportion(v, w, ancestor) {
                        if (w) {
                            var vip = v, vop = v, vim = w,
                                vom = vip.parent.children[0], sip = vip.m,
                                sop = vop.m, sim = vim.m, som = vom.m, shift;
                            while (vim = d3_layout_treeRight(vim), vip = d3_layout_treeLeft(vip), vim && vip) {
                                vom = d3_layout_treeLeft(vom);
                                vop = d3_layout_treeRight(vop);
                                vop.a = v;
                                shift = vim.z + sim - vip.z - sip + separation(vim._, vip._);
                                if (shift > 0) {
                                    d3_layout_treeMove(d3_layout_treeAncestor(vim, v, ancestor), v, shift);
                                    sip += shift;
                                    sop += shift;
                                }
                                sim += vim.m;
                                sip += vip.m;
                                som += vom.m;
                                sop += vop.m;
                            }
                            if (vim && !d3_layout_treeRight(vop)) {
                                vop.t = vim;
                                vop.m += sim - sop;
                            }
                            if (vip && !d3_layout_treeLeft(vom)) {
                                vom.t = vip;
                                vom.m += sip - som;
                                ancestor = v;
                            }
                        }
                        return ancestor;
                    }

                    function sizeNode(node) {
                        node.x *= size[0];
                        node.y = node.depth * size[1];
                    }

                    tree.separation = function (x) {
                        if (!arguments.length) return separation;
                        separation = x;
                        return tree;
                    };
                    tree.size = function (x) {
                        if (!arguments.length) return nodeSize ? null : size;
                        nodeSize = (size = x) == null ? sizeNode : null;
                        return tree;
                    };
                    tree.nodeSize = function (x) {
                        if (!arguments.length) return nodeSize ? size : null;
                        nodeSize = (size = x) == null ? null : sizeNode;
                        return tree;
                    };
                    return d3_layout_hierarchyRebind(tree, hierarchy);
                };

                function d3_layout_treeSeparation(a, b) {
                    return a.parent == b.parent ? 1 : 2;
                }

                function d3_layout_treeLeft(v) {
                    var children = v.children;
                    return children.length ? children[0] : v.t;
                }

                function d3_layout_treeRight(v) {
                    var children = v.children, n;
                    return (n = children.length) ? children[n - 1] : v.t;
                }

                function d3_layout_treeMove(wm, wp, shift) {
                    var change = shift / (wp.i - wm.i);
                    wp.c -= change;
                    wp.s += shift;
                    wm.c += change;
                    wp.z += shift;
                    wp.m += shift;
                }

                function d3_layout_treeShift(v) {
                    var shift = 0, change = 0, children = v.children,
                        i = children.length, w;
                    while (--i >= 0) {
                        w = children[i];
                        w.z += shift;
                        w.m += shift;
                        shift += w.s + (change += w.c);
                    }
                }

                function d3_layout_treeAncestor(vim, v, ancestor) {
                    return vim.a.parent === v.parent ? vim.a : ancestor;
                }

                d3.layout.cluster = function () {
                    var hierarchy = d3.layout.hierarchy().sort(null).value(null),
                        separation = d3_layout_treeSeparation, size = [1, 1],
                        nodeSize = false;

                    function cluster(d, i) {
                        var nodes = hierarchy.call(this, d, i), root = nodes[0],
                            previousNode, x = 0;
                        d3_layout_hierarchyVisitAfter(root, function (node) {
                            var children = node.children;
                            if (children && children.length) {
                                node.x = d3_layout_clusterX(children);
                                node.y = d3_layout_clusterY(children);
                            } else {
                                node.x = previousNode ? x += separation(node, previousNode) : 0;
                                node.y = 0;
                                previousNode = node;
                            }
                        });
                        var left = d3_layout_clusterLeft(root),
                            right = d3_layout_clusterRight(root),
                            x0 = left.x - separation(left, right) / 2,
                            x1 = right.x + separation(right, left) / 2;
                        d3_layout_hierarchyVisitAfter(root, nodeSize ? function (node) {
                            node.x = (node.x - root.x) * size[0];
                            node.y = (root.y - node.y) * size[1];
                        } : function (node) {
                            node.x = (node.x - x0) / (x1 - x0) * size[0];
                            node.y = (1 - (root.y ? node.y / root.y : 1)) * size[1];
                        });
                        return nodes;
                    }

                    cluster.separation = function (x) {
                        if (!arguments.length) return separation;
                        separation = x;
                        return cluster;
                    };
                    cluster.size = function (x) {
                        if (!arguments.length) return nodeSize ? null : size;
                        nodeSize = (size = x) == null;
                        return cluster;
                    };
                    cluster.nodeSize = function (x) {
                        if (!arguments.length) return nodeSize ? size : null;
                        nodeSize = (size = x) != null;
                        return cluster;
                    };
                    return d3_layout_hierarchyRebind(cluster, hierarchy);
                };

                function d3_layout_clusterY(children) {
                    return 1 + d3.max(children, function (child) {
                        return child.y;
                    });
                }

                function d3_layout_clusterX(children) {
                    return children.reduce(function (x, child) {
                        return x + child.x;
                    }, 0) / children.length;
                }

                function d3_layout_clusterLeft(node) {
                    var children = node.children;
                    return children && children.length ? d3_layout_clusterLeft(children[0]) : node;
                }

                function d3_layout_clusterRight(node) {
                    var children = node.children, n;
                    return children && (n = children.length) ? d3_layout_clusterRight(children[n - 1]) : node;
                }

                d3.layout.treemap = function () {
                    var hierarchy = d3.layout.hierarchy(), round = Math.round,
                        size = [1, 1], padding = null,
                        pad = d3_layout_treemapPadNull, sticky = false,
                        stickies, mode = "squarify",
                        ratio = .5 * (1 + Math.sqrt(5));

                    function scale(children, k) {
                        var i = -1, n = children.length, child, area;
                        while (++i < n) {
                            area = (child = children[i]).value * (k < 0 ? 0 : k);
                            child.area = isNaN(area) || area <= 0 ? 0 : area;
                        }
                    }

                    function squarify(node) {
                        var children = node.children;
                        if (children && children.length) {
                            var rect = pad(node), row = [],
                                remaining = children.slice(), child,
                                best = Infinity, score,
                                u = mode === "slice" ? rect.dx : mode === "dice" ? rect.dy : mode === "slice-dice" ? node.depth & 1 ? rect.dy : rect.dx : Math.min(rect.dx, rect.dy),
                                n;
                            scale(remaining, rect.dx * rect.dy / node.value);
                            row.area = 0;
                            while ((n = remaining.length) > 0) {
                                row.push(child = remaining[n - 1]);
                                row.area += child.area;
                                if (mode !== "squarify" || (score = worst(row, u)) <= best) {
                                    remaining.pop();
                                    best = score;
                                } else {
                                    row.area -= row.pop().area;
                                    position(row, u, rect, false);
                                    u = Math.min(rect.dx, rect.dy);
                                    row.length = row.area = 0;
                                    best = Infinity;
                                }
                            }
                            if (row.length) {
                                position(row, u, rect, true);
                                row.length = row.area = 0;
                            }
                            children.forEach(squarify);
                        }
                    }

                    function stickify(node) {
                        var children = node.children;
                        if (children && children.length) {
                            var rect = pad(node), remaining = children.slice(),
                                child, row = [];
                            scale(remaining, rect.dx * rect.dy / node.value);
                            row.area = 0;
                            while (child = remaining.pop()) {
                                row.push(child);
                                row.area += child.area;
                                if (child.z != null) {
                                    position(row, child.z ? rect.dx : rect.dy, rect, !remaining.length);
                                    row.length = row.area = 0;
                                }
                            }
                            children.forEach(stickify);
                        }
                    }

                    function worst(row, u) {
                        var s = row.area, r, rmax = 0, rmin = Infinity, i = -1,
                            n = row.length;
                        while (++i < n) {
                            if (!(r = row[i].area)) continue;
                            if (r < rmin) rmin = r;
                            if (r > rmax) rmax = r;
                        }
                        s *= s;
                        u *= u;
                        return s ? Math.max(u * rmax * ratio / s, s / (u * rmin * ratio)) : Infinity;
                    }

                    function position(row, u, rect, flush) {
                        var i = -1, n = row.length, x = rect.x, y = rect.y,
                            v = u ? round(row.area / u) : 0, o;
                        if (u == rect.dx) {
                            if (flush || v > rect.dy) v = rect.dy;
                            while (++i < n) {
                                o = row[i];
                                o.x = x;
                                o.y = y;
                                o.dy = v;
                                x += o.dx = Math.min(rect.x + rect.dx - x, v ? round(o.area / v) : 0);
                            }
                            o.z = true;
                            o.dx += rect.x + rect.dx - x;
                            rect.y += v;
                            rect.dy -= v;
                        } else {
                            if (flush || v > rect.dx) v = rect.dx;
                            while (++i < n) {
                                o = row[i];
                                o.x = x;
                                o.y = y;
                                o.dx = v;
                                y += o.dy = Math.min(rect.y + rect.dy - y, v ? round(o.area / v) : 0);
                            }
                            o.z = false;
                            o.dy += rect.y + rect.dy - y;
                            rect.x += v;
                            rect.dx -= v;
                        }
                    }

                    function treemap(d) {
                        var nodes = stickies || hierarchy(d), root = nodes[0];
                        root.x = root.y = 0;
                        if (root.value) root.dx = size[0], root.dy = size[1]; else root.dx = root.dy = 0;
                        if (stickies) hierarchy.revalue(root);
                        scale([root], root.dx * root.dy / root.value);
                        (stickies ? stickify : squarify)(root);
                        if (sticky) stickies = nodes;
                        return nodes;
                    }

                    treemap.size = function (x) {
                        if (!arguments.length) return size;
                        size = x;
                        return treemap;
                    };
                    treemap.padding = function (x) {
                        if (!arguments.length) return padding;

                        function padFunction(node) {
                            var p = x.call(treemap, node, node.depth);
                            return p == null ? d3_layout_treemapPadNull(node) : d3_layout_treemapPad(node, typeof p === "number" ? [p, p, p, p] : p);
                        }

                        function padConstant(node) {
                            return d3_layout_treemapPad(node, x);
                        }

                        var type;
                        pad = (padding = x) == null ? d3_layout_treemapPadNull : (type = typeof x) === "function" ? padFunction : type === "number" ? (x = [x, x, x, x],
                            padConstant) : padConstant;
                        return treemap;
                    };
                    treemap.round = function (x) {
                        if (!arguments.length) return round != Number;
                        round = x ? Math.round : Number;
                        return treemap;
                    };
                    treemap.sticky = function (x) {
                        if (!arguments.length) return sticky;
                        sticky = x;
                        stickies = null;
                        return treemap;
                    };
                    treemap.ratio = function (x) {
                        if (!arguments.length) return ratio;
                        ratio = x;
                        return treemap;
                    };
                    treemap.mode = function (x) {
                        if (!arguments.length) return mode;
                        mode = x + "";
                        return treemap;
                    };
                    return d3_layout_hierarchyRebind(treemap, hierarchy);
                };

                function d3_layout_treemapPadNull(node) {
                    return {
                        x: node.x,
                        y: node.y,
                        dx: node.dx,
                        dy: node.dy
                    };
                }

                function d3_layout_treemapPad(node, padding) {
                    var x = node.x + padding[3], y = node.y + padding[0],
                        dx = node.dx - padding[1] - padding[3],
                        dy = node.dy - padding[0] - padding[2];
                    if (dx < 0) {
                        x += dx / 2;
                        dx = 0;
                    }
                    if (dy < 0) {
                        y += dy / 2;
                        dy = 0;
                    }
                    return {
                        x: x,
                        y: y,
                        dx: dx,
                        dy: dy
                    };
                }

                d3.random = {
                    normal: function (Âµ, Ïƒ) {
                        var n = arguments.length;
                        if (n < 2) Ïƒ = 1;
                        if (n < 1) Âµ = 0;
                        return function () {
                            var x, y, r;
                            do {
                                x = Math.random() * 2 - 1;
                                y = Math.random() * 2 - 1;
                                r = x * x + y * y;
                            } while (!r || r > 1);
                            return Âµ + Ïƒ * x * Math.sqrt(-2 * Math.log(r) / r);
                        };
                    },
                    logNormal: function () {
                        var random = d3.random.normal.apply(d3, arguments);
                        return function () {
                            return Math.exp(random());
                        };
                    },
                    bates: function (m) {
                        var random = d3.random.irwinHall(m);
                        return function () {
                            return random() / m;
                        };
                    },
                    irwinHall: function (m) {
                        return function () {
                            for (var s = 0, j = 0; j < m; j++) s += Math.random();
                            return s;
                        };
                    }
                };
                d3.scale = {};

                function d3_scaleExtent(domain) {
                    var start = domain[0], stop = domain[domain.length - 1];
                    return start < stop ? [start, stop] : [stop, start];
                }

                function d3_scaleRange(scale) {
                    return scale.rangeExtent ? scale.rangeExtent() : d3_scaleExtent(scale.range());
                }

                function d3_scale_bilinear(domain, range, uninterpolate, interpolate) {
                    var u = uninterpolate(domain[0], domain[1]),
                        i = interpolate(range[0], range[1]);
                    return function (x) {
                        return i(u(x));
                    };
                }

                function d3_scale_nice(domain, nice) {
                    var i0 = 0, i1 = domain.length - 1, x0 = domain[i0],
                        x1 = domain[i1], dx;
                    if (x1 < x0) {
                        dx = i0, i0 = i1, i1 = dx;
                        dx = x0, x0 = x1, x1 = dx;
                    }
                    domain[i0] = nice.floor(x0);
                    domain[i1] = nice.ceil(x1);
                    return domain;
                }

                function d3_scale_niceStep(step) {
                    return step ? {
                        floor: function (x) {
                            return Math.floor(x / step) * step;
                        },
                        ceil: function (x) {
                            return Math.ceil(x / step) * step;
                        }
                    } : d3_scale_niceIdentity;
                }

                var d3_scale_niceIdentity = {
                    floor: d3_identity,
                    ceil: d3_identity
                };

                function d3_scale_polylinear(domain, range, uninterpolate, interpolate) {
                    var u = [], i = [], j = 0,
                        k = Math.min(domain.length, range.length) - 1;
                    if (domain[k] < domain[0]) {
                        domain = domain.slice().reverse();
                        range = range.slice().reverse();
                    }
                    while (++j <= k) {
                        u.push(uninterpolate(domain[j - 1], domain[j]));
                        i.push(interpolate(range[j - 1], range[j]));
                    }
                    return function (x) {
                        var j = d3.bisect(domain, x, 1, k) - 1;
                        return i[j](u[j](x));
                    };
                }

                d3.scale.linear = function () {
                    return d3_scale_linear([0, 1], [0, 1], d3_interpolate, false);
                };

                function d3_scale_linear(domain, range, interpolate, clamp) {
                    var output, input;

                    function rescale() {
                        var linear = Math.min(domain.length, range.length) > 2 ? d3_scale_polylinear : d3_scale_bilinear,
                            uninterpolate = clamp ? d3_uninterpolateClamp : d3_uninterpolateNumber;
                        output = linear(domain, range, uninterpolate, interpolate);
                        input = linear(range, domain, uninterpolate, d3_interpolate);
                        return scale;
                    }

                    function scale(x) {
                        return output(x);
                    }

                    scale.invert = function (y) {
                        return input(y);
                    };
                    scale.domain = function (x) {
                        if (!arguments.length) return domain;
                        domain = x.map(Number);
                        return rescale();
                    };
                    scale.range = function (x) {
                        if (!arguments.length) return range;
                        range = x;
                        return rescale();
                    };
                    scale.rangeRound = function (x) {
                        return scale.range(x).interpolate(d3_interpolateRound);
                    };
                    scale.clamp = function (x) {
                        if (!arguments.length) return clamp;
                        clamp = x;
                        return rescale();
                    };
                    scale.interpolate = function (x) {
                        if (!arguments.length) return interpolate;
                        interpolate = x;
                        return rescale();
                    };
                    scale.ticks = function (m) {
                        return d3_scale_linearTicks(domain, m);
                    };
                    scale.tickFormat = function (m, format) {
                        return d3_scale_linearTickFormat(domain, m, format);
                    };
                    scale.nice = function (m) {
                        d3_scale_linearNice(domain, m);
                        return rescale();
                    };
                    scale.copy = function () {
                        return d3_scale_linear(domain, range, interpolate, clamp);
                    };
                    return rescale();
                }

                function d3_scale_linearRebind(scale, linear) {
                    return d3.rebind(scale, linear, "range", "rangeRound", "interpolate", "clamp");
                }

                function d3_scale_linearNice(domain, m) {
                    d3_scale_nice(domain, d3_scale_niceStep(d3_scale_linearTickRange(domain, m)[2]));
                    d3_scale_nice(domain, d3_scale_niceStep(d3_scale_linearTickRange(domain, m)[2]));
                    return domain;
                }

                function d3_scale_linearTickRange(domain, m) {
                    if (m == null) m = 10;
                    var extent = d3_scaleExtent(domain),
                        span = extent[1] - extent[0],
                        step = Math.pow(10, Math.floor(Math.log(span / m) / Math.LN10)),
                        err = m / span * step;
                    if (err <= .15) step *= 10; else if (err <= .35) step *= 5; else if (err <= .75) step *= 2;
                    extent[0] = Math.ceil(extent[0] / step) * step;
                    extent[1] = Math.floor(extent[1] / step) * step + step * .5;
                    extent[2] = step;
                    return extent;
                }

                function d3_scale_linearTicks(domain, m) {
                    return d3.range.apply(d3, d3_scale_linearTickRange(domain, m));
                }

                var d3_scale_linearFormatSignificant = {
                    s: 1,
                    g: 1,
                    p: 1,
                    r: 1,
                    e: 1
                };

                function d3_scale_linearPrecision(value) {
                    return -Math.floor(Math.log(value) / Math.LN10 + .01);
                }

                function d3_scale_linearFormatPrecision(type, range) {
                    var p = d3_scale_linearPrecision(range[2]);
                    return type in d3_scale_linearFormatSignificant ? Math.abs(p - d3_scale_linearPrecision(Math.max(abs(range[0]), abs(range[1])))) + +(type !== "e") : p - (type === "%") * 2;
                }

                d3.scale.log = function () {
                    return d3_scale_log(d3.scale.linear().domain([0, 1]), 10, true, [1, 10]);
                };

                function d3_scale_log(linear, base, positive, domain) {
                    function log(x) {
                        return (positive ? Math.log(x < 0 ? 0 : x) : -Math.log(x > 0 ? 0 : -x)) / Math.log(base);
                    }

                    function pow(x) {
                        return positive ? Math.pow(base, x) : -Math.pow(base, -x);
                    }

                    function scale(x) {
                        return linear(log(x));
                    }

                    scale.invert = function (x) {
                        return pow(linear.invert(x));
                    };
                    scale.domain = function (x) {
                        if (!arguments.length) return domain;
                        positive = x[0] >= 0;
                        linear.domain((domain = x.map(Number)).map(log));
                        return scale;
                    };
                    scale.base = function (_) {
                        if (!arguments.length) return base;
                        base = +_;
                        linear.domain(domain.map(log));
                        return scale;
                    };
                    scale.nice = function () {
                        var niced = d3_scale_nice(domain.map(log), positive ? Math : d3_scale_logNiceNegative);
                        linear.domain(niced);
                        domain = niced.map(pow);
                        return scale;
                    };
                    scale.ticks = function () {
                        var extent = d3_scaleExtent(domain), ticks = [],
                            u = extent[0], v = extent[1],
                            i = Math.floor(log(u)), j = Math.ceil(log(v)),
                            n = base % 1 ? 2 : base;
                        if (isFinite(j - i)) {
                            if (positive) {
                                for (; i < j; i++) for (var k = 1; k < n; k++) ticks.push(pow(i) * k);
                                ticks.push(pow(i));
                            } else {
                                ticks.push(pow(i));
                                for (; i++ < j;) for (var k = n - 1; k > 0; k--) ticks.push(pow(i) * k);
                            }
                            for (i = 0; ticks[i] < u; i++) {
                            }
                            for (j = ticks.length; ticks[j - 1] > v; j--) {
                            }
                            ticks = ticks.slice(i, j);
                        }
                        return ticks;
                    };
                    scale.copy = function () {
                        return d3_scale_log(linear.copy(), base, positive, domain);
                    };
                    return d3_scale_linearRebind(scale, linear);
                }

                var d3_scale_logNiceNegative = {
                    floor: function (x) {
                        return -Math.ceil(-x);
                    },
                    ceil: function (x) {
                        return -Math.floor(-x);
                    }
                };
                d3.scale.pow = function () {
                    return d3_scale_pow(d3.scale.linear(), 1, [0, 1]);
                };

                function d3_scale_pow(linear, exponent, domain) {
                    var powp = d3_scale_powPow(exponent),
                        powb = d3_scale_powPow(1 / exponent);

                    function scale(x) {
                        return linear(powp(x));
                    }

                    scale.invert = function (x) {
                        return powb(linear.invert(x));
                    };
                    scale.domain = function (x) {
                        if (!arguments.length) return domain;
                        linear.domain((domain = x.map(Number)).map(powp));
                        return scale;
                    };
                    scale.ticks = function (m) {
                        return d3_scale_linearTicks(domain, m);
                    };
                    scale.tickFormat = function (m, format) {
                        return d3_scale_linearTickFormat(domain, m, format);
                    };
                    scale.nice = function (m) {
                        return scale.domain(d3_scale_linearNice(domain, m));
                    };
                    scale.exponent = function (x) {
                        if (!arguments.length) return exponent;
                        powp = d3_scale_powPow(exponent = x);
                        powb = d3_scale_powPow(1 / exponent);
                        linear.domain(domain.map(powp));
                        return scale;
                    };
                    scale.copy = function () {
                        return d3_scale_pow(linear.copy(), exponent, domain);
                    };
                    return d3_scale_linearRebind(scale, linear);
                }

                function d3_scale_powPow(e) {
                    return function (x) {
                        return x < 0 ? -Math.pow(-x, e) : Math.pow(x, e);
                    };
                }

                d3.scale.sqrt = function () {
                    return d3.scale.pow().exponent(.5);
                };
                d3.scale.ordinal = function () {
                    return d3_scale_ordinal([], {
                        t: "range",
                        a: [[]]
                    });
                };

                function d3_scale_ordinal(domain, ranger) {
                    var index, range, rangeBand;

                    function scale(x) {
                        return range[((index.get(x) || (ranger.t === "range" ? index.set(x, domain.push(x)) : NaN)) - 1) % range.length];
                    }

                    function steps(start, step) {
                        return d3.range(domain.length).map(function (i) {
                            return start + step * i;
                        });
                    }

                    scale.domain = function (x) {
                        if (!arguments.length) return domain;
                        domain = [];
                        index = new d3_Map();
                        var i = -1, n = x.length, xi;
                        while (++i < n) if (!index.has(xi = x[i])) index.set(xi, domain.push(xi));
                        return scale[ranger.t].apply(scale, ranger.a);
                    };
                    scale.range = function (x) {
                        if (!arguments.length) return range;
                        range = x;
                        rangeBand = 0;
                        ranger = {
                            t: "range",
                            a: arguments
                        };
                        return scale;
                    };
                    scale.rangePoints = function (x, padding) {
                        if (arguments.length < 2) padding = 0;
                        var start = x[0], stop = x[1],
                            step = domain.length < 2 ? (start = (start + stop) / 2,
                                0) : (stop - start) / (domain.length - 1 + padding);
                        range = steps(start + step * padding / 2, step);
                        rangeBand = 0;
                        ranger = {
                            t: "rangePoints",
                            a: arguments
                        };
                        return scale;
                    };
                    scale.rangeRoundPoints = function (x, padding) {
                        if (arguments.length < 2) padding = 0;
                        var start = x[0], stop = x[1],
                            step = domain.length < 2 ? (start = stop = Math.round((start + stop) / 2),
                                0) : (stop - start) / (domain.length - 1 + padding) | 0;
                        range = steps(start + Math.round(step * padding / 2 + (stop - start - (domain.length - 1 + padding) * step) / 2), step);
                        rangeBand = 0;
                        ranger = {
                            t: "rangeRoundPoints",
                            a: arguments
                        };
                        return scale;
                    };
                    scale.rangeBands = function (x, padding, outerPadding) {
                        if (arguments.length < 2) padding = 0;
                        if (arguments.length < 3) outerPadding = padding;
                        var reverse = x[1] < x[0], start = x[reverse - 0],
                            stop = x[1 - reverse],
                            step = (stop - start) / (domain.length - padding + 2 * outerPadding);
                        range = steps(start + step * outerPadding, step);
                        if (reverse) range.reverse();
                        rangeBand = step * (1 - padding);
                        ranger = {
                            t: "rangeBands",
                            a: arguments
                        };
                        return scale;
                    };
                    scale.rangeRoundBands = function (x, padding, outerPadding) {
                        if (arguments.length < 2) padding = 0;
                        if (arguments.length < 3) outerPadding = padding;
                        var reverse = x[1] < x[0], start = x[reverse - 0],
                            stop = x[1 - reverse],
                            step = Math.floor((stop - start) / (domain.length - padding + 2 * outerPadding));
                        range = steps(start + Math.round((stop - start - (domain.length - padding) * step) / 2), step);
                        if (reverse) range.reverse();
                        rangeBand = Math.round(step * (1 - padding));
                        ranger = {
                            t: "rangeRoundBands",
                            a: arguments
                        };
                        return scale;
                    };
                    scale.rangeBand = function () {
                        return rangeBand;
                    };
                    scale.rangeExtent = function () {
                        return d3_scaleExtent(ranger.a[0]);
                    };
                    scale.copy = function () {
                        return d3_scale_ordinal(domain, ranger);
                    };
                    return scale.domain(domain);
                }

                d3.scale.category10 = function () {
                    return d3.scale.ordinal().range(d3_category10);
                };
                d3.scale.category20 = function () {
                    return d3.scale.ordinal().range(d3_category20);
                };
                d3.scale.category20b = function () {
                    return d3.scale.ordinal().range(d3_category20b);
                };
                d3.scale.category20c = function () {
                    return d3.scale.ordinal().range(d3_category20c);
                };
                var d3_category10 = [2062260, 16744206, 2924588, 14034728, 9725885, 9197131, 14907330, 8355711, 12369186, 1556175].map(d3_rgbString);
                var d3_category20 = [2062260, 11454440, 16744206, 16759672, 2924588, 10018698, 14034728, 16750742, 9725885, 12955861, 9197131, 12885140, 14907330, 16234194, 8355711, 13092807, 12369186, 14408589, 1556175, 10410725].map(d3_rgbString);
                var d3_category20b = [3750777, 5395619, 7040719, 10264286, 6519097, 9216594, 11915115, 13556636, 9202993, 12426809, 15186514, 15190932, 8666169, 11356490, 14049643, 15177372, 8077683, 10834324, 13528509, 14589654].map(d3_rgbString);
                var d3_category20c = [3244733, 7057110, 10406625, 13032431, 15095053, 16616764, 16625259, 16634018, 3253076, 7652470, 10607003, 13101504, 7695281, 10394312, 12369372, 14342891, 6513507, 9868950, 12434877, 14277081].map(d3_rgbString);
                d3.scale.quantile = function () {
                    return d3_scale_quantile([], []);
                };

                function d3_scale_quantile(domain, range) {
                    var thresholds;

                    function rescale() {
                        var k = 0, q = range.length;
                        thresholds = [];
                        while (++k < q) thresholds[k - 1] = d3.quantile(domain, k / q);
                        return scale;
                    }

                    function scale(x) {
                        if (!isNaN(x = +x)) return range[d3.bisect(thresholds, x)];
                    }

                    scale.domain = function (x) {
                        if (!arguments.length) return domain;
                        domain = x.map(d3_number).filter(d3_numeric).sort(d3_ascending);
                        return rescale();
                    };
                    scale.range = function (x) {
                        if (!arguments.length) return range;
                        range = x;
                        return rescale();
                    };
                    scale.quantiles = function () {
                        return thresholds;
                    };
                    scale.invertExtent = function (y) {
                        y = range.indexOf(y);
                        return y < 0 ? [NaN, NaN] : [y > 0 ? thresholds[y - 1] : domain[0], y < thresholds.length ? thresholds[y] : domain[domain.length - 1]];
                    };
                    scale.copy = function () {
                        return d3_scale_quantile(domain, range);
                    };
                    return rescale();
                }

                d3.scale.quantize = function () {
                    return d3_scale_quantize(0, 1, [0, 1]);
                };

                function d3_scale_quantize(x0, x1, range) {
                    var kx, i;

                    function scale(x) {
                        return range[Math.max(0, Math.min(i, Math.floor(kx * (x - x0))))];
                    }

                    function rescale() {
                        kx = range.length / (x1 - x0);
                        i = range.length - 1;
                        return scale;
                    }

                    scale.domain = function (x) {
                        if (!arguments.length) return [x0, x1];
                        x0 = +x[0];
                        x1 = +x[x.length - 1];
                        return rescale();
                    };
                    scale.range = function (x) {
                        if (!arguments.length) return range;
                        range = x;
                        return rescale();
                    };
                    scale.invertExtent = function (y) {
                        y = range.indexOf(y);
                        y = y < 0 ? NaN : y / kx + x0;
                        return [y, y + 1 / kx];
                    };
                    scale.copy = function () {
                        return d3_scale_quantize(x0, x1, range);
                    };
                    return rescale();
                }

                d3.scale.threshold = function () {
                    return d3_scale_threshold([.5], [0, 1]);
                };

                function d3_scale_threshold(domain, range) {
                    function scale(x) {
                        if (x <= x) return range[d3.bisect(domain, x)];
                    }

                    scale.domain = function (_) {
                        if (!arguments.length) return domain;
                        domain = _;
                        return scale;
                    };
                    scale.range = function (_) {
                        if (!arguments.length) return range;
                        range = _;
                        return scale;
                    };
                    scale.invertExtent = function (y) {
                        y = range.indexOf(y);
                        return [domain[y - 1], domain[y]];
                    };
                    scale.copy = function () {
                        return d3_scale_threshold(domain, range);
                    };
                    return scale;
                }

                d3.scale.identity = function () {
                    return d3_scale_identity([0, 1]);
                };

                function d3_scale_identity(domain) {
                    function identity(x) {
                        return +x;
                    }

                    identity.invert = identity;
                    identity.domain = identity.range = function (x) {
                        if (!arguments.length) return domain;
                        domain = x.map(identity);
                        return identity;
                    };
                    identity.ticks = function (m) {
                        return d3_scale_linearTicks(domain, m);
                    };
                    identity.tickFormat = function (m, format) {
                        return d3_scale_linearTickFormat(domain, m, format);
                    };
                    identity.copy = function () {
                        return d3_scale_identity(domain);
                    };
                    return identity;
                }

                d3.svg = {};

                function d3_zero() {
                    return 0;
                }

                d3.svg.arc = function () {
                    var innerRadius = d3_svg_arcInnerRadius,
                        outerRadius = d3_svg_arcOuterRadius,
                        cornerRadius = d3_zero, padRadius = d3_svg_arcAuto,
                        startAngle = d3_svg_arcStartAngle,
                        endAngle = d3_svg_arcEndAngle,
                        padAngle = d3_svg_arcPadAngle;

                    function arc() {
                        var r0 = Math.max(0, +innerRadius.apply(this, arguments)),
                            r1 = Math.max(0, +outerRadius.apply(this, arguments)),
                            a0 = startAngle.apply(this, arguments) - halfÏ€,
                            a1 = endAngle.apply(this, arguments) - halfÏ€,
                            da = Math.abs(a1 - a0), cw = a0 > a1 ? 0 : 1;
                        if (r1 < r0) rc = r1, r1 = r0, r0 = rc;
                        if (da >= Ï„
                        Îµ
                    )
                        return circleSegment(r1, cw) + (r0 ? circleSegment(r0, 1 - cw) : "") + "Z";
                        var rc, cr, rp, ap, p0 = 0, p1 = 0, x0, y0, x1, y1, x2,
                            y2, x3, y3, path = [];
                        if (ap = (+padAngle.apply(this, arguments) || 0) / 2) {
                            rp = padRadius === d3_svg_arcAuto ? Math.sqrt(r0 * r0 + r1 * r1) : +padRadius.apply(this, arguments);
                            if (!cw) p1 *= -1;
                            if (r1) p1 = d3_asin(rp / r1 * Math.sin(ap));
                            if (r0) p0 = d3_asin(rp / r0 * Math.sin(ap));
                        }
                        if (r1) {
                            x0 = r1 * Math.cos(a0 + p1);
                            y0 = r1 * Math.sin(a0 + p1);
                            x1 = r1 * Math.cos(a1 - p1);
                            y1 = r1 * Math.sin(a1 - p1);
                            var l1 = Math.abs(a1 - a0 - 2 * p1) <= Ï€ ? 0 : 1;
                            if (p1 && d3_svg_arcSweep(x0, y0, x1, y1) === cw ^ l1) {
                                var h1 = (a0 + a1) / 2;
                                x0 = r1 * Math.cos(h1);
                                y0 = r1 * Math.sin(h1);
                                x1 = y1 = null;
                            }
                        } else {
                            x0 = y0 = 0;
                        }
                        if (r0) {
                            x2 = r0 * Math.cos(a1 - p0);
                            y2 = r0 * Math.sin(a1 - p0);
                            x3 = r0 * Math.cos(a0 + p0);
                            y3 = r0 * Math.sin(a0 + p0);
                            var l0 = Math.abs(a0 - a1 + 2 * p0) <= Ï€ ? 0 : 1;
                            if (p0 && d3_svg_arcSweep(x2, y2, x3, y3) === 1 - cw ^ l0) {
                                var h0 = (a0 + a1) / 2;
                                x2 = r0 * Math.cos(h0);
                                y2 = r0 * Math.sin(h0);
                                x3 = y3 = null;
                            }
                        } else {
                            x2 = y2 = 0;
                        }
                        if (da > Îµ && (rc = Math.min(Math.abs(r1 - r0) / 2, +cornerRadius.apply(this, arguments))) > .001) {
                            cr = r0 < r1 ^ cw ? 0 : 1;
                            var rc1 = rc, rc0 = rc;
                            if (da < Ï€) {
                                var oc = x3 == null ? [x2, y2] : x1 == null ? [x0, y0] : d3_geom_polygonIntersect([x0, y0], [x3, y3], [x1, y1], [x2, y2]),
                                    ax = x0 - oc[0], ay = y0 - oc[1],
                                    bx = x1 - oc[0], by = y1 - oc[1],
                                    kc = 1 / Math.sin(Math.acos((ax * bx + ay * by) / (Math.sqrt(ax * ax + ay * ay) * Math.sqrt(bx * bx + by * by))) / 2),
                                    lc = Math.sqrt(oc[0] * oc[0] + oc[1] * oc[1]);
                                rc0 = Math.min(rc, (r0 - lc) / (kc - 1));
                                rc1 = Math.min(rc, (r1 - lc) / (kc + 1));
                            }
                            if (x1 != null) {
                                var t30 = d3_svg_arcCornerTangents(x3 == null ? [x2, y2] : [x3, y3], [x0, y0], r1, rc1, cw),
                                    t12 = d3_svg_arcCornerTangents([x1, y1], [x2, y2], r1, rc1, cw);
                                if (rc === rc1) {
                                    path.push("M", t30[0], "A", rc1, ",", rc1, " 0 0,", cr, " ", t30[1], "A", r1, ",", r1, " 0 ", 1 - cw ^ d3_svg_arcSweep(t30[1][0], t30[1][1], t12[1][0], t12[1][1]), ",", cw, " ", t12[1], "A", rc1, ",", rc1, " 0 0,", cr, " ", t12[0]);
                                } else {
                                    path.push("M", t30[0], "A", rc1, ",", rc1, " 0 1,", cr, " ", t12[0]);
                                }
                            } else {
                                path.push("M", x0, ",", y0);
                            }
                            if (x3 != null) {
                                var t03 = d3_svg_arcCornerTangents([x0, y0], [x3, y3], r0, -rc0, cw),
                                    t21 = d3_svg_arcCornerTangents([x2, y2], x1 == null ? [x0, y0] : [x1, y1], r0, -rc0, cw);
                                if (rc === rc0) {
                                    path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr, " ", t21[1], "A", r0, ",", r0, " 0 ", cw ^ d3_svg_arcSweep(t21[1][0], t21[1][1], t03[1][0], t03[1][1]), ",", 1 - cw, " ", t03[1], "A", rc0, ",", rc0, " 0 0,", cr, " ", t03[0]);
                                } else {
                                    path.push("L", t21[0], "A", rc0, ",", rc0, " 0 0,", cr, " ", t03[0]);
                                }
                            } else {
                                path.push("L", x2, ",", y2);
                            }
                        } else {
                            path.push("M", x0, ",", y0);
                            if (x1 != null) path.push("A", r1, ",", r1, " 0 ", l1, ",", cw, " ", x1, ",", y1);
                            path.push("L", x2, ",", y2);
                            if (x3 != null) path.push("A", r0, ",", r0, " 0 ", l0, ",", 1 - cw, " ", x3, ",", y3);
                        }
                        path.push("Z");
                        return path.join("");
                    }

                    function circleSegment(r1, cw) {
                        return "M0," + r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + -r1 + "A" + r1 + "," + r1 + " 0 1," + cw + " 0," + r1;
                    }

                    arc.innerRadius = function (v) {
                        if (!arguments.length) return innerRadius;
                        innerRadius = d3_functor(v);
                        return arc;
                    };
                    arc.outerRadius = function (v) {
                        if (!arguments.length) return outerRadius;
                        outerRadius = d3_functor(v);
                        return arc;
                    };
                    arc.cornerRadius = function (v) {
                        if (!arguments.length) return cornerRadius;
                        cornerRadius = d3_functor(v);
                        return arc;
                    };
                    arc.padRadius = function (v) {
                        if (!arguments.length) return padRadius;
                        padRadius = v == d3_svg_arcAuto ? d3_svg_arcAuto : d3_functor(v);
                        return arc;
                    };
                    arc.startAngle = function (v) {
                        if (!arguments.length) return startAngle;
                        startAngle = d3_functor(v);
                        return arc;
                    };
                    arc.endAngle = function (v) {
                        if (!arguments.length) return endAngle;
                        endAngle = d3_functor(v);
                        return arc;
                    };
                    arc.padAngle = function (v) {
                        if (!arguments.length) return padAngle;
                        padAngle = d3_functor(v);
                        return arc;
                    };
                    arc.centroid = function () {
                        var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2,
                            a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - halfÏ€;
                        return [Math.cos(a) * r, Math.sin(a) * r];
                    };
                    return arc;
                };
                var d3_svg_arcAuto = "auto";

                function d3_svg_arcInnerRadius(d) {
                    return d.innerRadius;
                }

                function d3_svg_arcOuterRadius(d) {
                    return d.outerRadius;
                }

                function d3_svg_arcStartAngle(d) {
                    return d.startAngle;
                }

                function d3_svg_arcEndAngle(d) {
                    return d.endAngle;
                }

                function d3_svg_arcPadAngle(d) {
                    return d && d.padAngle;
                }

                function d3_svg_arcSweep(x0, y0, x1, y1) {
                    return (x0 - x1) * y0 - (y0 - y1) * x0 > 0 ? 0 : 1;
                }

                function d3_svg_arcCornerTangents(p0, p1, r1, rc, cw) {
                    var x01 = p0[0] - p1[0], y01 = p0[1] - p1[1],
                        lo = (cw ? rc : -rc) / Math.sqrt(x01 * x01 + y01 * y01),
                        ox = lo * y01, oy = -lo * x01, x1 = p0[0] + ox,
                        y1 = p0[1] + oy, x2 = p1[0] + ox, y2 = p1[1] + oy,
                        x3 = (x1 + x2) / 2, y3 = (y1 + y2) / 2, dx = x2 - x1,
                        dy = y2 - y1, d2 = dx * dx + dy * dy, r = r1 - rc,
                        D = x1 * y2 - x2 * y1,
                        d = (dy < 0 ? -1 : 1) * Math.sqrt(Math.max(0, r * r * d2 - D * D)),
                        cx0 = (D * dy - dx * d) / d2,
                        cy0 = (-D * dx - dy * d) / d2,
                        cx1 = (D * dy + dx * d) / d2,
                        cy1 = (-D * dx + dy * d) / d2, dx0 = cx0 - x3,
                        dy0 = cy0 - y3, dx1 = cx1 - x3, dy1 = cy1 - y3;
                    if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1) cx0 = cx1, cy0 = cy1;
                    return [[cx0 - ox, cy0 - oy], [cx0 * r1 / r, cy0 * r1 / r]];
                }

                function d3_true() {
                    return true;
                }

                function d3_svg_line(projection) {
                    var x = d3_geom_pointX, y = d3_geom_pointY,
                        defined = d3_true, interpolate = d3_svg_lineLinear,
                        interpolateKey = interpolate.key, tension = .7;

                    function line(data) {
                        var segments = [], points = [], i = -1, n = data.length,
                            d, fx = d3_functor(x), fy = d3_functor(y);

                        function segment() {
                            segments.push("M", interpolate(projection(points), tension));
                        }

                        while (++i < n) {
                            if (defined.call(this, d = data[i], i)) {
                                points.push([+fx.call(this, d, i), +fy.call(this, d, i)]);
                            } else if (points.length) {
                                segment();
                                points = [];
                            }
                        }
                        if (points.length) segment();
                        return segments.length ? segments.join("") : null;
                    }

                    line.x = function (_) {
                        if (!arguments.length) return x;
                        x = _;
                        return line;
                    };
                    line.y = function (_) {
                        if (!arguments.length) return y;
                        y = _;
                        return line;
                    };
                    line.defined = function (_) {
                        if (!arguments.length) return defined;
                        defined = _;
                        return line;
                    };
                    line.interpolate = function (_) {
                        if (!arguments.length) return interpolateKey;
                        if (typeof _ === "function") interpolateKey = interpolate = _; else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
                        return line;
                    };
                    line.tension = function (_) {
                        if (!arguments.length) return tension;
                        tension = _;
                        return line;
                    };
                    return line;
                }

                d3.svg.line = function () {
                    return d3_svg_line(d3_identity);
                };
                var d3_svg_lineInterpolators = d3.map({
                    linear: d3_svg_lineLinear,
                    "linear-closed": d3_svg_lineLinearClosed,
                    step: d3_svg_lineStep,
                    "step-before": d3_svg_lineStepBefore,
                    "step-after": d3_svg_lineStepAfter,
                    basis: d3_svg_lineBasis,
                    "basis-open": d3_svg_lineBasisOpen,
                    "basis-closed": d3_svg_lineBasisClosed,
                    bundle: d3_svg_lineBundle,
                    cardinal: d3_svg_lineCardinal,
                    "cardinal-open": d3_svg_lineCardinalOpen,
                    "cardinal-closed": d3_svg_lineCardinalClosed,
                    monotone: d3_svg_lineMonotone
                });
                d3_svg_lineInterpolators.forEach(function (key, value) {
                    value.key = key;
                    value.closed = /-closed$/.test(key);
                });

                function d3_svg_lineLinear(points) {
                    return points.length > 1 ? points.join("L") : points + "Z";
                }

                function d3_svg_lineLinearClosed(points) {
                    return points.join("L") + "Z";
                }

                function d3_svg_lineStep(points) {
                    var i = 0, n = points.length, p = points[0],
                        path = [p[0], ",", p[1]];
                    while (++i < n) path.push("H", (p[0] + (p = points[i])[0]) / 2, "V", p[1]);
                    if (n > 1) path.push("H", p[0]);
                    return path.join("");
                }

                function d3_svg_lineStepBefore(points) {
                    var i = 0, n = points.length, p = points[0],
                        path = [p[0], ",", p[1]];
                    while (++i < n) path.push("V", (p = points[i])[1], "H", p[0]);
                    return path.join("");
                }

                function d3_svg_lineStepAfter(points) {
                    var i = 0, n = points.length, p = points[0],
                        path = [p[0], ",", p[1]];
                    while (++i < n) path.push("H", (p = points[i])[0], "V", p[1]);
                    return path.join("");
                }

                function d3_svg_lineCardinalOpen(points, tension) {
                    return points.length < 4 ? d3_svg_lineLinear(points) : points[1] + d3_svg_lineHermite(points.slice(1, -1), d3_svg_lineCardinalTangents(points, tension));
                }

                function d3_svg_lineCardinalClosed(points, tension) {
                    return points.length < 3 ? d3_svg_lineLinearClosed(points) : points[0] + d3_svg_lineHermite((points.push(points[0]),
                        points), d3_svg_lineCardinalTangents([points[points.length - 2]].concat(points, [points[1]]), tension));
                }

                function d3_svg_lineCardinal(points, tension) {
                    return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineCardinalTangents(points, tension));
                }

                function d3_svg_lineHermite(points, tangents) {
                    if (tangents.length < 1 || points.length != tangents.length && points.length != tangents.length + 2) {
                        return d3_svg_lineLinear(points);
                    }
                    var quad = points.length != tangents.length, path = "",
                        p0 = points[0], p = points[1], t0 = tangents[0], t = t0,
                        pi = 1;
                    if (quad) {
                        path += "Q" + (p[0] - t0[0] * 2 / 3) + "," + (p[1] - t0[1] * 2 / 3) + "," + p[0] + "," + p[1];
                        p0 = points[1];
                        pi = 2;
                    }
                    if (tangents.length > 1) {
                        t = tangents[1];
                        p = points[pi];
                        pi++;
                        path += "C" + (p0[0] + t0[0]) + "," + (p0[1] + t0[1]) + "," + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
                        for (var i = 2; i < tangents.length; i++, pi++) {
                            p = points[pi];
                            t = tangents[i];
                            path += "S" + (p[0] - t[0]) + "," + (p[1] - t[1]) + "," + p[0] + "," + p[1];
                        }
                    }
                    if (quad) {
                        var lp = points[pi];
                        path += "Q" + (p[0] + t[0] * 2 / 3) + "," + (p[1] + t[1] * 2 / 3) + "," + lp[0] + "," + lp[1];
                    }
                    return path;
                }

                function d3_svg_lineCardinalTangents(points, tension) {
                    var tangents = [], a = (1 - tension) / 2, p0,
                        p1 = points[0], p2 = points[1], i = 1,
                        n = points.length;
                    while (++i < n) {
                        p0 = p1;
                        p1 = p2;
                        p2 = points[i];
                        tangents.push([a * (p2[0] - p0[0]), a * (p2[1] - p0[1])]);
                    }
                    return tangents;
                }

                function d3_svg_lineBasis(points) {
                    if (points.length < 3) return d3_svg_lineLinear(points);
                    var i = 1, n = points.length, pi = points[0], x0 = pi[0],
                        y0 = pi[1], px = [x0, x0, x0, (pi = points[1])[0]],
                        py = [y0, y0, y0, pi[1]],
                        path = [x0, ",", y0, "L", d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py)];
                    points.push(points[n - 1]);
                    while (++i <= n) {
                        pi = points[i];
                        px.shift();
                        px.push(pi[0]);
                        py.shift();
                        py.push(pi[1]);
                        d3_svg_lineBasisBezier(path, px, py);
                    }
                    points.pop();
                    path.push("L", pi);
                    return path.join("");
                }

                function d3_svg_lineBasisOpen(points) {
                    if (points.length < 4) return d3_svg_lineLinear(points);
                    var path = [], i = -1, n = points.length, pi, px = [0],
                        py = [0];
                    while (++i < 3) {
                        pi = points[i];
                        px.push(pi[0]);
                        py.push(pi[1]);
                    }
                    path.push(d3_svg_lineDot4(d3_svg_lineBasisBezier3, px) + "," + d3_svg_lineDot4(d3_svg_lineBasisBezier3, py));
                    --i;
                    while (++i < n) {
                        pi = points[i];
                        px.shift();
                        px.push(pi[0]);
                        py.shift();
                        py.push(pi[1]);
                        d3_svg_lineBasisBezier(path, px, py);
                    }
                    return path.join("");
                }

                function d3_svg_lineBasisClosed(points) {
                    var path, i = -1, n = points.length, m = n + 4, pi, px = [],
                        py = [];
                    while (++i < 4) {
                        pi = points[i % n];
                        px.push(pi[0]);
                        py.push(pi[1]);
                    }
                    path = [d3_svg_lineDot4(d3_svg_lineBasisBezier3, px), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, py)];
                    --i;
                    while (++i < m) {
                        pi = points[i % n];
                        px.shift();
                        px.push(pi[0]);
                        py.shift();
                        py.push(pi[1]);
                        d3_svg_lineBasisBezier(path, px, py);
                    }
                    return path.join("");
                }

                function d3_svg_lineBundle(points, tension) {
                    var n = points.length - 1;
                    if (n) {
                        var x0 = points[0][0], y0 = points[0][1],
                            dx = points[n][0] - x0, dy = points[n][1] - y0,
                            i = -1, p, t;
                        while (++i <= n) {
                            p = points[i];
                            t = i / n;
                            p[0] = tension * p[0] + (1 - tension) * (x0 + t * dx);
                            p[1] = tension * p[1] + (1 - tension) * (y0 + t * dy);
                        }
                    }
                    return d3_svg_lineBasis(points);
                }

                function d3_svg_lineDot4(a, b) {
                    return a[0] * b[0] + a[1] * b[1] + a[2] * b[2] + a[3] * b[3];
                }

                var d3_svg_lineBasisBezier1 = [0, 2 / 3, 1 / 3, 0],
                    d3_svg_lineBasisBezier2 = [0, 1 / 3, 2 / 3, 0],
                    d3_svg_lineBasisBezier3 = [0, 1 / 6, 2 / 3, 1 / 6];

                function d3_svg_lineBasisBezier(path, x, y) {
                    path.push("C", d3_svg_lineDot4(d3_svg_lineBasisBezier1, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier1, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier2, y), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, x), ",", d3_svg_lineDot4(d3_svg_lineBasisBezier3, y));
                }

                function d3_svg_lineSlope(p0, p1) {
                    return (p1[1] - p0[1]) / (p1[0] - p0[0]);
                }

                function d3_svg_lineFiniteDifferences(points) {
                    var i = 0, j = points.length - 1, m = [], p0 = points[0],
                        p1 = points[1], d = m[0] = d3_svg_lineSlope(p0, p1);
                    while (++i < j) {
                        m[i] = (d + (d = d3_svg_lineSlope(p0 = p1, p1 = points[i + 1]))) / 2;
                    }
                    m[i] = d;
                    return m;
                }

                function d3_svg_lineMonotoneTangents(points) {
                    var tangents = [], d, a, b, s,
                        m = d3_svg_lineFiniteDifferences(points), i = -1,
                        j = points.length - 1;
                    while (++i < j) {
                        d = d3_svg_lineSlope(points[i], points[i + 1]);
                        if (abs(d) < Îµ) {
                            m[i] = m[i + 1] = 0;
                        } else {
                            a = m[i] / d;
                            b = m[i + 1] / d;
                            s = a * a + b * b;
                            if (s > 9) {
                                s = d * 3 / Math.sqrt(s);
                                m[i] = s * a;
                                m[i + 1] = s * b;
                            }
                        }
                    }
                    i = -1;
                    while (++i <= j) {
                        s = (points[Math.min(j, i + 1)][0] - points[Math.max(0, i - 1)][0]) / (6 * (1 + m[i] * m[i]));
                        tangents.push([s || 0, m[i] * s || 0]);
                    }
                    return tangents;
                }

                function d3_svg_lineMonotone(points) {
                    return points.length < 3 ? d3_svg_lineLinear(points) : points[0] + d3_svg_lineHermite(points, d3_svg_lineMonotoneTangents(points));
                }

                d3.svg.line.radial = function () {
                    var line = d3_svg_line(d3_svg_lineRadial);
                    line.radius = line.x, delete line.x;
                    line.angle = line.y, delete line.y;
                    return line;
                };

                function d3_svg_lineRadial(points) {
                    var point, i = -1, n = points.length, r, a;
                    while (++i < n) {
                        point = points[i];
                        r = point[0];
                        a = point[1] - halfÏ€;
                        point[0] = r * Math.cos(a);
                        point[1] = r * Math.sin(a);
                    }
                    return points;
                }

                function d3_svg_area(projection) {
                    var x0 = d3_geom_pointX, x1 = d3_geom_pointX, y0 = 0,
                        y1 = d3_geom_pointY, defined = d3_true,
                        interpolate = d3_svg_lineLinear,
                        interpolateKey = interpolate.key,
                        interpolateReverse = interpolate, L = "L", tension = .7;

                    function area(data) {
                        var segments = [], points0 = [], points1 = [], i = -1,
                            n = data.length, d, fx0 = d3_functor(x0),
                            fy0 = d3_functor(y0),
                            fx1 = x0 === x1 ? function () {
                                return x;
                            } : d3_functor(x1), fy1 = y0 === y1 ? function () {
                                return y;
                            } : d3_functor(y1), x, y;

                        function segment() {
                            segments.push("M", interpolate(projection(points1), tension), L, interpolateReverse(projection(points0.reverse()), tension), "Z");
                        }

                        while (++i < n) {
                            if (defined.call(this, d = data[i], i)) {
                                points0.push([x = +fx0.call(this, d, i), y = +fy0.call(this, d, i)]);
                                points1.push([+fx1.call(this, d, i), +fy1.call(this, d, i)]);
                            } else if (points0.length) {
                                segment();
                                points0 = [];
                                points1 = [];
                            }
                        }
                        if (points0.length) segment();
                        return segments.length ? segments.join("") : null;
                    }

                    area.x = function (_) {
                        if (!arguments.length) return x1;
                        x0 = x1 = _;
                        return area;
                    };
                    area.x0 = function (_) {
                        if (!arguments.length) return x0;
                        x0 = _;
                        return area;
                    };
                    area.x1 = function (_) {
                        if (!arguments.length) return x1;
                        x1 = _;
                        return area;
                    };
                    area.y = function (_) {
                        if (!arguments.length) return y1;
                        y0 = y1 = _;
                        return area;
                    };
                    area.y0 = function (_) {
                        if (!arguments.length) return y0;
                        y0 = _;
                        return area;
                    };
                    area.y1 = function (_) {
                        if (!arguments.length) return y1;
                        y1 = _;
                        return area;
                    };
                    area.defined = function (_) {
                        if (!arguments.length) return defined;
                        defined = _;
                        return area;
                    };
                    area.interpolate = function (_) {
                        if (!arguments.length) return interpolateKey;
                        if (typeof _ === "function") interpolateKey = interpolate = _; else interpolateKey = (interpolate = d3_svg_lineInterpolators.get(_) || d3_svg_lineLinear).key;
                        interpolateReverse = interpolate.reverse || interpolate;
                        L = interpolate.closed ? "M" : "L";
                        return area;
                    };
                    area.tension = function (_) {
                        if (!arguments.length) return tension;
                        tension = _;
                        return area;
                    };
                    return area;
                }

                d3_svg_lineStepBefore.reverse = d3_svg_lineStepAfter;
                d3_svg_lineStepAfter.reverse = d3_svg_lineStepBefore;
                d3.svg.area = function () {
                    return d3_svg_area(d3_identity);
                };
                d3.svg.area.radial = function () {
                    var area = d3_svg_area(d3_svg_lineRadial);
                    area.radius = area.x, delete area.x;
                    area.innerRadius = area.x0, delete area.x0;
                    area.outerRadius = area.x1, delete area.x1;
                    area.angle = area.y, delete area.y;
                    area.startAngle = area.y0, delete area.y0;
                    area.endAngle = area.y1, delete area.y1;
                    return area;
                };

                function d3_source(d) {
                    return d.source;
                }

                function d3_target(d) {
                    return d.target;
                }

                d3.svg.chord = function () {
                    var source = d3_source, target = d3_target,
                        radius = d3_svg_chordRadius,
                        startAngle = d3_svg_arcStartAngle,
                        endAngle = d3_svg_arcEndAngle;

                    function chord(d, i) {
                        var s = subgroup(this, source, d, i),
                            t = subgroup(this, target, d, i);
                        return "M" + s.p0 + arc(s.r, s.p1, s.a1 - s.a0) + (equals(s, t) ? curve(s.r, s.p1, s.r, s.p0) : curve(s.r, s.p1, t.r, t.p0) + arc(t.r, t.p1, t.a1 - t.a0) + curve(t.r, t.p1, s.r, s.p0)) + "Z";
                    }

                    function subgroup(self, f, d, i) {
                        var subgroup = f.call(self, d, i),
                            r = radius.call(self, subgroup, i),
                            a0 = startAngle.call(self, subgroup, i) - halfÏ€,
                            a1 = endAngle.call(self, subgroup, i) - halfÏ€;
                        return {
                            r: r,
                            a0: a0,
                            a1: a1,
                            p0: [r * Math.cos(a0), r * Math.sin(a0)],
                            p1: [r * Math.cos(a1), r * Math.sin(a1)]
                        };
                    }

                    function equals(a, b) {
                        return a.a0 == b.a0 && a.a1 == b.a1;
                    }

                    function arc(r, p, a) {
                        return "A" + r + "," + r + " 0 " + +(a > Ï€) + ",1 " + p;
                    }

                    function curve(r0, p0, r1, p1) {
                        return "Q 0,0 " + p1;
                    }

                    chord.radius = function (v) {
                        if (!arguments.length) return radius;
                        radius = d3_functor(v);
                        return chord;
                    };
                    chord.source = function (v) {
                        if (!arguments.length) return source;
                        source = d3_functor(v);
                        return chord;
                    };
                    chord.target = function (v) {
                        if (!arguments.length) return target;
                        target = d3_functor(v);
                        return chord;
                    };
                    chord.startAngle = function (v) {
                        if (!arguments.length) return startAngle;
                        startAngle = d3_functor(v);
                        return chord;
                    };
                    chord.endAngle = function (v) {
                        if (!arguments.length) return endAngle;
                        endAngle = d3_functor(v);
                        return chord;
                    };
                    return chord;
                };

                function d3_svg_chordRadius(d) {
                    return d.radius;
                }

                d3.svg.diagonal = function () {
                    var source = d3_source, target = d3_target,
                        projection = d3_svg_diagonalProjection;

                    function diagonal(d, i) {
                        var p0 = source.call(this, d, i),
                            p3 = target.call(this, d, i), m = (p0.y + p3.y) / 2,
                            p = [p0, {
                                x: p0.x,
                                y: m
                            }, {
                                x: p3.x,
                                y: m
                            }, p3];
                        p = p.map(projection);
                        return "M" + p[0] + "C" + p[1] + " " + p[2] + " " + p[3];
                    }

                    diagonal.source = function (x) {
                        if (!arguments.length) return source;
                        source = d3_functor(x);
                        return diagonal;
                    };
                    diagonal.target = function (x) {
                        if (!arguments.length) return target;
                        target = d3_functor(x);
                        return diagonal;
                    };
                    diagonal.projection = function (x) {
                        if (!arguments.length) return projection;
                        projection = x;
                        return diagonal;
                    };
                    return diagonal;
                };

                function d3_svg_diagonalProjection(d) {
                    return [d.x, d.y];
                }

                d3.svg.diagonal.radial = function () {
                    var diagonal = d3.svg.diagonal(),
                        projection = d3_svg_diagonalProjection,
                        projection_ = diagonal.projection;
                    diagonal.projection = function (x) {
                        return arguments.length ? projection_(d3_svg_diagonalRadialProjection(projection = x)) : projection;
                    };
                    return diagonal;
                };

                function d3_svg_diagonalRadialProjection(projection) {
                    return function () {
                        var d = projection.apply(this, arguments), r = d[0],
                            a = d[1] - halfÏ€;
                        return [r * Math.cos(a), r * Math.sin(a)];
                    };
                }

                d3.svg.symbol = function () {
                    var type = d3_svg_symbolType, size = d3_svg_symbolSize;

                    function symbol(d, i) {
                        return (d3_svg_symbols.get(type.call(this, d, i)) || d3_svg_symbolCircle)(size.call(this, d, i));
                    }

                    symbol.type = function (x) {
                        if (!arguments.length) return type;
                        type = d3_functor(x);
                        return symbol;
                    };
                    symbol.size = function (x) {
                        if (!arguments.length) return size;
                        size = d3_functor(x);
                        return symbol;
                    };
                    return symbol;
                };

                function d3_svg_symbolSize() {
                    return 64;
                }

                function d3_svg_symbolType() {
                    return "circle";
                }

                function d3_svg_symbolCircle(size) {
                    var r = Math.sqrt(size / Ï€);
                    return "M0," + r + "A" + r + "," + r + " 0 1,1 0," + -r + "A" + r + "," + r + " 0 1,1 0," + r + "Z";
                }

                var d3_svg_symbols = d3.map({
                    circle: d3_svg_symbolCircle,
                    cross: function (size) {
                        var r = Math.sqrt(size / 5) / 2;
                        return "M" + -3 * r + "," + -r + "H" + -r + "V" + -3 * r + "H" + r + "V" + -r + "H" + 3 * r + "V" + r + "H" + r + "V" + 3 * r + "H" + -r + "V" + r + "H" + -3 * r + "Z";
                    },
                    diamond: function (size) {
                        var ry = Math.sqrt(size / (2 * d3_svg_symbolTan30)),
                            rx = ry * d3_svg_symbolTan30;
                        return "M0," + -ry + "L" + rx + ",0" + " 0," + ry + " " + -rx + ",0" + "Z";
                    },
                    square: function (size) {
                        var r = Math.sqrt(size) / 2;
                        return "M" + -r + "," + -r + "L" + r + "," + -r + " " + r + "," + r + " " + -r + "," + r + "Z";
                    },
                    "triangle-down": function (size) {
                        var rx = Math.sqrt(size / d3_svg_symbolSqrt3),
                            ry = rx * d3_svg_symbolSqrt3 / 2;
                        return "M0," + ry + "L" + rx + "," + -ry + " " + -rx + "," + -ry + "Z";
                    },
                    "triangle-up": function (size) {
                        var rx = Math.sqrt(size / d3_svg_symbolSqrt3),
                            ry = rx * d3_svg_symbolSqrt3 / 2;
                        return "M0," + -ry + "L" + rx + "," + ry + " " + -rx + "," + ry + "Z";
                    }
                });
                d3.svg.symbolTypes = d3_svg_symbols.keys();
                var d3_svg_symbolSqrt3 = Math.sqrt(3),
                    d3_svg_symbolTan30 = Math.tan(30 * d3_radians);
                d3_selectionPrototype.transition = function (name) {
                    var id = d3_transitionInheritId || ++d3_transitionId,
                        ns = d3_transitionNamespace(name), subgroups = [],
                        subgroup, node, transition = d3_transitionInherit || {
                            time: Date.now(),
                            ease: d3_ease_cubicInOut,
                            delay: 0,
                            duration: 250
                        };
                    for (var j = -1, m = this.length; ++j < m;) {
                        subgroups.push(subgroup = []);
                        for (var group = this[j], i = -1, n = group.length; ++i < n;) {
                            if (node = group[i]) d3_transitionNode(node, i, ns, id, transition);
                            subgroup.push(node);
                        }
                    }
                    return d3_transition(subgroups, ns, id);
                };
                d3_selectionPrototype.interrupt = function (name) {
                    return this.each(name == null ? d3_selection_interrupt : d3_selection_interruptNS(d3_transitionNamespace(name)));
                };
                var d3_selection_interrupt = d3_selection_interruptNS(d3_transitionNamespace());

                function d3_selection_interruptNS(ns) {
                    return function () {
                        var lock, activeId, active;
                        if ((lock = this[ns]) && (active = lock[activeId = lock.active])) {
                            active.timer.c = null;
                            active.timer.t = NaN;
                            if (--lock.count) delete lock[activeId]; else delete this[ns];
                            lock.active += .5;
                            active.event && active.event.interrupt.call(this, this.__data__, active.index);
                        }
                    };
                }

                function d3_transition(groups, ns, id) {
                    d3_subclass(groups, d3_transitionPrototype);
                    groups.namespace = ns;
                    groups.id = id;
                    return groups;
                }

                var d3_transitionPrototype = [], d3_transitionId = 0,
                    d3_transitionInheritId, d3_transitionInherit;
                d3_transitionPrototype.call = d3_selectionPrototype.call;
                d3_transitionPrototype.empty = d3_selectionPrototype.empty;
                d3_transitionPrototype.node = d3_selectionPrototype.node;
                d3_transitionPrototype.size = d3_selectionPrototype.size;
                d3.transition = function (selection, name) {
                    return selection && selection.transition ? d3_transitionInheritId ? selection.transition(name) : selection : d3.selection().transition(selection);
                };
                d3.transition.prototype = d3_transitionPrototype;
                d3_transitionPrototype.select = function (selector) {
                    var id = this.id, ns = this.namespace, subgroups = [],
                        subgroup, subnode, node;
                    selector = d3_selection_selector(selector);
                    for (var j = -1, m = this.length; ++j < m;) {
                        subgroups.push(subgroup = []);
                        for (var group = this[j], i = -1, n = group.length; ++i < n;) {
                            if ((node = group[i]) && (subnode = selector.call(node, node.__data__, i, j))) {
                                if ("__data__" in node) subnode.__data__ = node.__data__;
                                d3_transitionNode(subnode, i, ns, id, node[ns][id]);
                                subgroup.push(subnode);
                            } else {
                                subgroup.push(null);
                            }
                        }
                    }
                    return d3_transition(subgroups, ns, id);
                };
                d3_transitionPrototype.selectAll = function (selector) {
                    var id = this.id, ns = this.namespace, subgroups = [],
                        subgroup, subnodes, node, subnode, transition;
                    selector = d3_selection_selectorAll(selector);
                    for (var j = -1, m = this.length; ++j < m;) {
                        for (var group = this[j], i = -1, n = group.length; ++i < n;) {
                            if (node = group[i]) {
                                transition = node[ns][id];
                                subnodes = selector.call(node, node.__data__, i, j);
                                subgroups.push(subgroup = []);
                                for (var k = -1, o = subnodes.length; ++k < o;) {
                                    if (subnode = subnodes[k]) d3_transitionNode(subnode, k, ns, id, transition);
                                    subgroup.push(subnode);
                                }
                            }
                        }
                    }
                    return d3_transition(subgroups, ns, id);
                };
                d3_transitionPrototype.filter = function (filter) {
                    var subgroups = [], subgroup, group, node;
                    if (typeof filter !== "function") filter = d3_selection_filter(filter);
                    for (var j = 0, m = this.length; j < m; j++) {
                        subgroups.push(subgroup = []);
                        for (var group = this[j], i = 0, n = group.length; i < n; i++) {
                            if ((node = group[i]) && filter.call(node, node.__data__, i, j)) {
                                subgroup.push(node);
                            }
                        }
                    }
                    return d3_transition(subgroups, this.namespace, this.id);
                };
                d3_transitionPrototype.tween = function (name, tween) {
                    var id = this.id, ns = this.namespace;
                    if (arguments.length < 2) return this.node()[ns][id].tween.get(name);
                    return d3_selection_each(this, tween == null ? function (node) {
                        node[ns][id].tween.remove(name);
                    } : function (node) {
                        node[ns][id].tween.set(name, tween);
                    });
                };

                function d3_transition_tween(groups, name, value, tween) {
                    var id = groups.id, ns = groups.namespace;
                    return d3_selection_each(groups, typeof value === "function" ? function (node, i, j) {
                        node[ns][id].tween.set(name, tween(value.call(node, node.__data__, i, j)));
                    } : (value = tween(value), function (node) {
                        node[ns][id].tween.set(name, value);
                    }));
                }

                d3_transitionPrototype.attr = function (nameNS, value) {
                    if (arguments.length < 2) {
                        for (value in nameNS) this.attr(value, nameNS[value]);
                        return this;
                    }
                    var interpolate = nameNS == "transform" ? d3_interpolateTransform : d3_interpolate,
                        name = d3.ns.qualify(nameNS);

                    function attrNull() {
                        this.removeAttribute(name);
                    }

                    function attrNullNS() {
                        this.removeAttributeNS(name.space, name.local);
                    }

                    function attrTween(b) {
                        return b == null ? attrNull : (b += "", function () {
                            var a = this.getAttribute(name), i;
                            return a !== b && (i = interpolate(a, b), function (t) {
                                this.setAttribute(name, i(t));
                            });
                        });
                    }

                    function attrTweenNS(b) {
                        return b == null ? attrNullNS : (b += "", function () {
                            var a = this.getAttributeNS(name.space, name.local),
                                i;
                            return a !== b && (i = interpolate(a, b), function (t) {
                                this.setAttributeNS(name.space, name.local, i(t));
                            });
                        });
                    }

                    return d3_transition_tween(this, "attr." + nameNS, value, name.local ? attrTweenNS : attrTween);
                };
                d3_transitionPrototype.attrTween = function (nameNS, tween) {
                    var name = d3.ns.qualify(nameNS);

                    function attrTween(d, i) {
                        var f = tween.call(this, d, i, this.getAttribute(name));
                        return f && function (t) {
                            this.setAttribute(name, f(t));
                        };
                    }

                    function attrTweenNS(d, i) {
                        var f = tween.call(this, d, i, this.getAttributeNS(name.space, name.local));
                        return f && function (t) {
                            this.setAttributeNS(name.space, name.local, f(t));
                        };
                    }

                    return this.tween("attr." + nameNS, name.local ? attrTweenNS : attrTween);
                };
                d3_transitionPrototype.style = function (name, value, priority) {
                    var n = arguments.length;
                    if (n < 3) {
                        if (typeof name !== "string") {
                            if (n < 2) value = "";
                            for (priority in name) this.style(priority, name[priority], value);
                            return this;
                        }
                        priority = "";
                    }

                    function styleNull() {
                        this.style.removeProperty(name);
                    }

                    function styleString(b) {
                        return b == null ? styleNull : (b += "", function () {
                            var a = d3_window(this).getComputedStyle(this, null).getPropertyValue(name),
                                i;
                            return a !== b && (i = d3_interpolate(a, b), function (t) {
                                this.style.setProperty(name, i(t), priority);
                            });
                        });
                    }

                    return d3_transition_tween(this, "style." + name, value, styleString);
                };
                d3_transitionPrototype.styleTween = function (name, tween, priority) {
                    if (arguments.length < 3) priority = "";

                    function styleTween(d, i) {
                        var f = tween.call(this, d, i, d3_window(this).getComputedStyle(this, null).getPropertyValue(name));
                        return f && function (t) {
                            this.style.setProperty(name, f(t), priority);
                        };
                    }

                    return this.tween("style." + name, styleTween);
                };
                d3_transitionPrototype.text = function (value) {
                    return d3_transition_tween(this, "text", value, d3_transition_text);
                };

                function d3_transition_text(b) {
                    if (b == null) b = "";
                    return function () {
                        this.textContent = b;
                    };
                }

                d3_transitionPrototype.remove = function () {
                    var ns = this.namespace;
                    return this.each("end.transition", function () {
                        var p;
                        if (this[ns].count < 2 && (p = this.parentNode)) p.removeChild(this);
                    });
                };
                d3_transitionPrototype.ease = function (value) {
                    var id = this.id, ns = this.namespace;
                    if (arguments.length < 1) return this.node()[ns][id].ease;
                    if (typeof value !== "function") value = d3.ease.apply(d3, arguments);
                    return d3_selection_each(this, function (node) {
                        node[ns][id].ease = value;
                    });
                };
                d3_transitionPrototype.delay = function (value) {
                    var id = this.id, ns = this.namespace;
                    if (arguments.length < 1) return this.node()[ns][id].delay;
                    return d3_selection_each(this, typeof value === "function" ? function (node, i, j) {
                        node[ns][id].delay = +value.call(node, node.__data__, i, j);
                    } : (value = +value, function (node) {
                        node[ns][id].delay = value;
                    }));
                };
                d3_transitionPrototype.duration = function (value) {
                    var id = this.id, ns = this.namespace;
                    if (arguments.length < 1) return this.node()[ns][id].duration;
                    return d3_selection_each(this, typeof value === "function" ? function (node, i, j) {
                        node[ns][id].duration = Math.max(1, value.call(node, node.__data__, i, j));
                    } : (value = Math.max(1, value), function (node) {
                        node[ns][id].duration = value;
                    }));
                };
                d3_transitionPrototype.each = function (type, listener) {
                    var id = this.id, ns = this.namespace;
                    if (arguments.length < 2) {
                        var inherit = d3_transitionInherit,
                            inheritId = d3_transitionInheritId;
                        try {
                            d3_transitionInheritId = id;
                            d3_selection_each(this, function (node, i, j) {
                                d3_transitionInherit = node[ns][id];
                                type.call(node, node.__data__, i, j);
                            });
                        } finally {
                            d3_transitionInherit = inherit;
                            d3_transitionInheritId = inheritId;
                        }
                    } else {
                        d3_selection_each(this, function (node) {
                            var transition = node[ns][id];
                            (transition.event || (transition.event = d3.dispatch("start", "end", "interrupt"))).on(type, listener);
                        });
                    }
                    return this;
                };
                d3_transitionPrototype.transition = function () {
                    var id0 = this.id, id1 = ++d3_transitionId,
                        ns = this.namespace, subgroups = [], subgroup, group,
                        node, transition;
                    for (var j = 0, m = this.length; j < m; j++) {
                        subgroups.push(subgroup = []);
                        for (var group = this[j], i = 0, n = group.length; i < n; i++) {
                            if (node = group[i]) {
                                transition = node[ns][id0];
                                d3_transitionNode(node, i, ns, id1, {
                                    time: transition.time,
                                    ease: transition.ease,
                                    delay: transition.delay + transition.duration,
                                    duration: transition.duration
                                });
                            }
                            subgroup.push(node);
                        }
                    }
                    return d3_transition(subgroups, ns, id1);
                };

                function d3_transitionNamespace(name) {
                    return name == null ? "__transition__" : "__transition_" + name + "__";
                }

                function d3_transitionNode(node, i, ns, id, inherit) {
                    var lock = node[ns] || (node[ns] = {
                            active: 0,
                            count: 0
                        }), transition = lock[id], time, timer, duration, ease,
                        tweens;

                    function schedule(elapsed) {
                        var delay = transition.delay;
                        timer.t = delay + time;
                        if (delay <= elapsed) return start(elapsed - delay);
                        timer.c = start;
                    }

                    function start(elapsed) {
                        var activeId = lock.active, active = lock[activeId];
                        if (active) {
                            active.timer.c = null;
                            active.timer.t = NaN;
                            --lock.count;
                            delete lock[activeId];
                            active.event && active.event.interrupt.call(node, node.__data__, active.index);
                        }
                        for (var cancelId in lock) {
                            if (+cancelId < id) {
                                var cancel = lock[cancelId];
                                cancel.timer.c = null;
                                cancel.timer.t = NaN;
                                --lock.count;
                                delete lock[cancelId];
                            }
                        }
                        timer.c = tick;
                        d3_timer(function () {
                            if (timer.c && tick(elapsed || 1)) {
                                timer.c = null;
                                timer.t = NaN;
                            }
                            return 1;
                        }, 0, time);
                        lock.active = id;
                        transition.event && transition.event.start.call(node, node.__data__, i);
                        tweens = [];
                        transition.tween.forEach(function (key, value) {
                            if (value = value.call(node, node.__data__, i)) {
                                tweens.push(value);
                            }
                        });
                        ease = transition.ease;
                        duration = transition.duration;
                    }

                    function tick(elapsed) {
                        var t = elapsed / duration, e = ease(t),
                            n = tweens.length;
                        while (n > 0) {
                            tweens[--n].call(node, e);
                        }
                        if (t >= 1) {
                            transition.event && transition.event.end.call(node, node.__data__, i);
                            if (--lock.count) delete lock[id]; else delete node[ns];
                            return 1;
                        }
                    }

                    if (!transition) {
                        time = inherit.time;
                        timer = d3_timer(schedule, 0, time);
                        transition = lock[id] = {
                            tween: new d3_Map(),
                            time: time,
                            timer: timer,
                            delay: inherit.delay,
                            duration: inherit.duration,
                            ease: inherit.ease,
                            index: i
                        };
                        inherit = null;
                        ++lock.count;
                    }
                }

                d3.svg.axis = function () {
                    var scale = d3.scale.linear(),
                        orient = d3_svg_axisDefaultOrient, innerTickSize = 6,
                        outerTickSize = 6, tickPadding = 3,
                        tickArguments_ = [10], tickValues = null, tickFormat_;

                    function axis(g) {
                        g.each(function () {
                            var g = d3.select(this);
                            var scale0 = this.__chart__ || scale,
                                scale1 = this.__chart__ = scale.copy();
                            var ticks = tickValues == null ? scale1.ticks ? scale1.ticks.apply(scale1, tickArguments_) : scale1.domain() : tickValues,
                                tickFormat = tickFormat_ == null ? scale1.tickFormat ? scale1.tickFormat.apply(scale1, tickArguments_) : d3_identity : tickFormat_,
                                tick = g.selectAll(".tick").data(ticks, scale1),
                                tickEnter = tick.enter().insert("g", ".domain").attr("class", "tick").style("opacity", Îµ),
                                tickExit = d3.transition(tick.exit()).style("opacity", Îµ).remove(),
                                tickUpdate = d3.transition(tick.order()).style("opacity", 1),
                                tickSpacing = Math.max(innerTickSize, 0) + tickPadding,
                                tickTransform;
                            var range = d3_scaleRange(scale1),
                                path = g.selectAll(".domain").data([0]),
                                pathUpdate = (path.enter().append("path").attr("class", "domain"),
                                    d3.transition(path));
                            tickEnter.append("line");
                            tickEnter.append("text");
                            var lineEnter = tickEnter.select("line"),
                                lineUpdate = tickUpdate.select("line"),
                                text = tick.select("text").text(tickFormat),
                                textEnter = tickEnter.select("text"),
                                textUpdate = tickUpdate.select("text"),
                                sign = orient === "top" || orient === "left" ? -1 : 1,
                                x1, x2, y1, y2;
                            if (orient === "bottom" || orient === "top") {
                                tickTransform = d3_svg_axisX, x1 = "x", y1 = "y", x2 = "x2", y2 = "y2";
                                text.attr("dy", sign < 0 ? "0em" : ".71em").style("text-anchor", "middle");
                                pathUpdate.attr("d", "M" + range[0] + "," + sign * outerTickSize + "V0H" + range[1] + "V" + sign * outerTickSize);
                            } else {
                                tickTransform = d3_svg_axisY, x1 = "y", y1 = "x", x2 = "y2", y2 = "x2";
                                text.attr("dy", ".32em").style("text-anchor", sign < 0 ? "end" : "start");
                                pathUpdate.attr("d", "M" + sign * outerTickSize + "," + range[0] + "H0V" + range[1] + "H" + sign * outerTickSize);
                            }
                            lineEnter.attr(y2, sign * innerTickSize);
                            textEnter.attr(y1, sign * tickSpacing);
                            lineUpdate.attr(x2, 0).attr(y2, sign * innerTickSize);
                            textUpdate.attr(x1, 0).attr(y1, sign * tickSpacing);
                            if (scale1.rangeBand) {
                                var x = scale1, dx = x.rangeBand() / 2;
                                scale0 = scale1 = function (d) {
                                    return x(d) + dx;
                                };
                            } else if (scale0.rangeBand) {
                                scale0 = scale1;
                            } else {
                                tickExit.call(tickTransform, scale1, scale0);
                            }
                            tickEnter.call(tickTransform, scale0, scale1);
                            tickUpdate.call(tickTransform, scale1, scale1);
                        });
                    }

                    axis.scale = function (x) {
                        if (!arguments.length) return scale;
                        scale = x;
                        return axis;
                    };
                    axis.orient = function (x) {
                        if (!arguments.length) return orient;
                        orient = x in d3_svg_axisOrients ? x + "" : d3_svg_axisDefaultOrient;
                        return axis;
                    };
                    axis.ticks = function () {
                        if (!arguments.length) return tickArguments_;
                        tickArguments_ = d3_array(arguments);
                        return axis;
                    };
                    axis.tickValues = function (x) {
                        if (!arguments.length) return tickValues;
                        tickValues = x;
                        return axis;
                    };
                    axis.tickFormat = function (x) {
                        if (!arguments.length) return tickFormat_;
                        tickFormat_ = x;
                        return axis;
                    };
                    axis.tickSize = function (x) {
                        var n = arguments.length;
                        if (!n) return innerTickSize;
                        innerTickSize = +x;
                        outerTickSize = +arguments[n - 1];
                        return axis;
                    };
                    axis.innerTickSize = function (x) {
                        if (!arguments.length) return innerTickSize;
                        innerTickSize = +x;
                        return axis;
                    };
                    axis.outerTickSize = function (x) {
                        if (!arguments.length) return outerTickSize;
                        outerTickSize = +x;
                        return axis;
                    };
                    axis.tickPadding = function (x) {
                        if (!arguments.length) return tickPadding;
                        tickPadding = +x;
                        return axis;
                    };
                    axis.tickSubdivide = function () {
                        return arguments.length && axis;
                    };
                    return axis;
                };
                var d3_svg_axisDefaultOrient = "bottom", d3_svg_axisOrients = {
                    top: 1,
                    right: 1,
                    bottom: 1,
                    left: 1
                };

                function d3_svg_axisX(selection, x0, x1) {
                    selection.attr("transform", function (d) {
                        var v0 = x0(d);
                        return "translate(" + (isFinite(v0) ? v0 : x1(d)) + ",0)";
                    });
                }

                function d3_svg_axisY(selection, y0, y1) {
                    selection.attr("transform", function (d) {
                        var v0 = y0(d);
                        return "translate(0," + (isFinite(v0) ? v0 : y1(d)) + ")";
                    });
                }

                d3.svg.brush = function () {
                    var event = d3_eventDispatch(brush, "brushstart", "brush", "brushend"),
                        x = null, y = null, xExtent = [0, 0], yExtent = [0, 0],
                        xExtentDomain, yExtentDomain, xClamp = true,
                        yClamp = true, resizes = d3_svg_brushResizes[0];

                    function brush(g) {
                        g.each(function () {
                            var g = d3.select(this).style("pointer-events", "all").style("-webkit-tap-highlight-color", "rgba(0,0,0,0)").on("mousedown.brush", brushstart).on("touchstart.brush", brushstart);
                            var background = g.selectAll(".background").data([0]);
                            background.enter().append("rect").attr("class", "background").style("visibility", "hidden").style("cursor", "crosshair");
                            g.selectAll(".extent").data([0]).enter().append("rect").attr("class", "extent").style("cursor", "move");
                            var resize = g.selectAll(".resize").data(resizes, d3_identity);
                            resize.exit().remove();
                            resize.enter().append("g").attr("class", function (d) {
                                return "resize " + d;
                            }).style("cursor", function (d) {
                                return d3_svg_brushCursor[d];
                            }).append("rect").attr("x", function (d) {
                                return /[ew]$/.test(d) ? -3 : null;
                            }).attr("y", function (d) {
                                return /^[ns]/.test(d) ? -3 : null;
                            }).attr("width", 6).attr("height", 6).style("visibility", "hidden");
                            resize.style("display", brush.empty() ? "none" : null);
                            var gUpdate = d3.transition(g),
                                backgroundUpdate = d3.transition(background),
                                range;
                            if (x) {
                                range = d3_scaleRange(x);
                                backgroundUpdate.attr("x", range[0]).attr("width", range[1] - range[0]);
                                redrawX(gUpdate);
                            }
                            if (y) {
                                range = d3_scaleRange(y);
                                backgroundUpdate.attr("y", range[0]).attr("height", range[1] - range[0]);
                                redrawY(gUpdate);
                            }
                            redraw(gUpdate);
                        });
                    }

                    brush.event = function (g) {
                        g.each(function () {
                            var event_ = event.of(this, arguments), extent1 = {
                                x: xExtent,
                                y: yExtent,
                                i: xExtentDomain,
                                j: yExtentDomain
                            }, extent0 = this.__chart__ || extent1;
                            this.__chart__ = extent1;
                            if (d3_transitionInheritId) {
                                d3.select(this).transition().each("start.brush", function () {
                                    xExtentDomain = extent0.i;
                                    yExtentDomain = extent0.j;
                                    xExtent = extent0.x;
                                    yExtent = extent0.y;
                                    event_({
                                        type: "brushstart"
                                    });
                                }).tween("brush:brush", function () {
                                    var xi = d3_interpolateArray(xExtent, extent1.x),
                                        yi = d3_interpolateArray(yExtent, extent1.y);
                                    xExtentDomain = yExtentDomain = null;
                                    return function (t) {
                                        xExtent = extent1.x = xi(t);
                                        yExtent = extent1.y = yi(t);
                                        event_({
                                            type: "brush",
                                            mode: "resize"
                                        });
                                    };
                                }).each("end.brush", function () {
                                    xExtentDomain = extent1.i;
                                    yExtentDomain = extent1.j;
                                    event_({
                                        type: "brush",
                                        mode: "resize"
                                    });
                                    event_({
                                        type: "brushend"
                                    });
                                });
                            } else {
                                event_({
                                    type: "brushstart"
                                });
                                event_({
                                    type: "brush",
                                    mode: "resize"
                                });
                                event_({
                                    type: "brushend"
                                });
                            }
                        });
                    };

                    function redraw(g) {
                        g.selectAll(".resize").attr("transform", function (d) {
                            return "translate(" + xExtent[+/e$/.test(d)] + "," + yExtent[+/^s/.test(d)] + ")";
                        });
                    }

                    function redrawX(g) {
                        g.select(".extent").attr("x", xExtent[0]);
                        g.selectAll(".extent,.n>rect,.s>rect").attr("width", xExtent[1] - xExtent[0]);
                    }

                    function redrawY(g) {
                        g.select(".extent").attr("y", yExtent[0]);
                        g.selectAll(".extent,.e>rect,.w>rect").attr("height", yExtent[1] - yExtent[0]);
                    }

                    function brushstart() {
                        var target = this,
                            eventTarget = d3.select(d3.event.target),
                            event_ = event.of(target, arguments),
                            g = d3.select(target),
                            resizing = eventTarget.datum(),
                            resizingX = !/^(n|s)$/.test(resizing) && x,
                            resizingY = !/^(e|w)$/.test(resizing) && y,
                            dragging = eventTarget.classed("extent"),
                            dragRestore = d3_event_dragSuppress(target), center,
                            origin = d3.mouse(target), offset;
                        var w = d3.select(d3_window(target)).on("keydown.brush", keydown).on("keyup.brush", keyup);
                        if (d3.event.changedTouches) {
                            w.on("touchmove.brush", brushmove).on("touchend.brush", brushend);
                        } else {
                            w.on("mousemove.brush", brushmove).on("mouseup.brush", brushend);
                        }
                        g.interrupt().selectAll("*").interrupt();
                        if (dragging) {
                            origin[0] = xExtent[0] - origin[0];
                            origin[1] = yExtent[0] - origin[1];
                        } else if (resizing) {
                            var ex = +/w$/.test(resizing),
                                ey = +/^n/.test(resizing);
                            offset = [xExtent[1 - ex] - origin[0], yExtent[1 - ey] - origin[1]];
                            origin[0] = xExtent[ex];
                            origin[1] = yExtent[ey];
                        } else if (d3.event.altKey) center = origin.slice();
                        g.style("pointer-events", "none").selectAll(".resize").style("display", null);
                        d3.select("body").style("cursor", eventTarget.style("cursor"));
                        event_({
                            type: "brushstart"
                        });
                        brushmove();

                        function keydown() {
                            if (d3.event.keyCode == 32) {
                                if (!dragging) {
                                    center = null;
                                    origin[0] -= xExtent[1];
                                    origin[1] -= yExtent[1];
                                    dragging = 2;
                                }
                                d3_eventPreventDefault();
                            }
                        }

                        function keyup() {
                            if (d3.event.keyCode == 32 && dragging == 2) {
                                origin[0] += xExtent[1];
                                origin[1] += yExtent[1];
                                dragging = 0;
                                d3_eventPreventDefault();
                            }
                        }

                        function brushmove() {
                            var point = d3.mouse(target), moved = false;
                            if (offset) {
                                point[0] += offset[0];
                                point[1] += offset[1];
                            }
                            if (!dragging) {
                                if (d3.event.altKey) {
                                    if (!center) center = [(xExtent[0] + xExtent[1]) / 2, (yExtent[0] + yExtent[1]) / 2];
                                    origin[0] = xExtent[+(point[0] < center[0])];
                                    origin[1] = yExtent[+(point[1] < center[1])];
                                } else center = null;
                            }
                            if (resizingX && move1(point, x, 0)) {
                                redrawX(g);
                                moved = true;
                            }
                            if (resizingY && move1(point, y, 1)) {
                                redrawY(g);
                                moved = true;
                            }
                            if (moved) {
                                redraw(g);
                                event_({
                                    type: "brush",
                                    mode: dragging ? "move" : "resize"
                                });
                            }
                        }

                        function move1(point, scale, i) {
                            var range = d3_scaleRange(scale), r0 = range[0],
                                r1 = range[1], position = origin[i],
                                extent = i ? yExtent : xExtent,
                                size = extent[1] - extent[0], min, max;
                            if (dragging) {
                                r0 -= position;
                                r1 -= size + position;
                            }
                            min = (i ? yClamp : xClamp) ? Math.max(r0, Math.min(r1, point[i])) : point[i];
                            if (dragging) {
                                max = (min += position) + size;
                            } else {
                                if (center) position = Math.max(r0, Math.min(r1, 2 * center[i] - min));
                                if (position < min) {
                                    max = min;
                                    min = position;
                                } else {
                                    max = position;
                                }
                            }
                            if (extent[0] != min || extent[1] != max) {
                                if (i) yExtentDomain = null; else xExtentDomain = null;
                                extent[0] = min;
                                extent[1] = max;
                                return true;
                            }
                        }

                        function brushend() {
                            brushmove();
                            g.style("pointer-events", "all").selectAll(".resize").style("display", brush.empty() ? "none" : null);
                            d3.select("body").style("cursor", null);
                            w.on("mousemove.brush", null).on("mouseup.brush", null).on("touchmove.brush", null).on("touchend.brush", null).on("keydown.brush", null).on("keyup.brush", null);
                            dragRestore();
                            event_({
                                type: "brushend"
                            });
                        }
                    }

                    brush.x = function (z) {
                        if (!arguments.length) return x;
                        x = z;
                        resizes = d3_svg_brushResizes[!x << 1 | !y];
                        return brush;
                    };
                    brush.y = function (z) {
                        if (!arguments.length) return y;
                        y = z;
                        resizes = d3_svg_brushResizes[!x << 1 | !y];
                        return brush;
                    };
                    brush.clamp = function (z) {
                        if (!arguments.length) return x && y ? [xClamp, yClamp] : x ? xClamp : y ? yClamp : null;
                        if (x && y) xClamp = !!z[0], yClamp = !!z[1]; else if (x) xClamp = !!z; else if (y) yClamp = !!z;
                        return brush;
                    };
                    brush.extent = function (z) {
                        var x0, x1, y0, y1, t;
                        if (!arguments.length) {
                            if (x) {
                                if (xExtentDomain) {
                                    x0 = xExtentDomain[0], x1 = xExtentDomain[1];
                                } else {
                                    x0 = xExtent[0], x1 = xExtent[1];
                                    if (x.invert) x0 = x.invert(x0), x1 = x.invert(x1);
                                    if (x1 < x0) t = x0, x0 = x1, x1 = t;
                                }
                            }
                            if (y) {
                                if (yExtentDomain) {
                                    y0 = yExtentDomain[0], y1 = yExtentDomain[1];
                                } else {
                                    y0 = yExtent[0], y1 = yExtent[1];
                                    if (y.invert) y0 = y.invert(y0), y1 = y.invert(y1);
                                    if (y1 < y0) t = y0, y0 = y1, y1 = t;
                                }
                            }
                            return x && y ? [[x0, y0], [x1, y1]] : x ? [x0, x1] : y && [y0, y1];
                        }
                        if (x) {
                            x0 = z[0], x1 = z[1];
                            if (y) x0 = x0[0], x1 = x1[0];
                            xExtentDomain = [x0, x1];
                            if (x.invert) x0 = x(x0), x1 = x(x1);
                            if (x1 < x0) t = x0, x0 = x1, x1 = t;
                            if (x0 != xExtent[0] || x1 != xExtent[1]) xExtent = [x0, x1];
                        }
                        if (y) {
                            y0 = z[0], y1 = z[1];
                            if (x) y0 = y0[1], y1 = y1[1];
                            yExtentDomain = [y0, y1];
                            if (y.invert) y0 = y(y0), y1 = y(y1);
                            if (y1 < y0) t = y0, y0 = y1, y1 = t;
                            if (y0 != yExtent[0] || y1 != yExtent[1]) yExtent = [y0, y1];
                        }
                        return brush;
                    };
                    brush.clear = function () {
                        if (!brush.empty()) {
                            xExtent = [0, 0], yExtent = [0, 0];
                            xExtentDomain = yExtentDomain = null;
                        }
                        return brush;
                    };
                    brush.empty = function () {
                        return !!x && xExtent[0] == xExtent[1] || !!y && yExtent[0] == yExtent[1];
                    };
                    return d3.rebind(brush, event, "on");
                };
                var d3_svg_brushCursor = {
                    n: "ns-resize",
                    e: "ew-resize",
                    s: "ns-resize",
                    w: "ew-resize",
                    nw: "nwse-resize",
                    ne: "nesw-resize",
                    se: "nwse-resize",
                    sw: "nesw-resize"
                };
                var d3_svg_brushResizes = [["n", "e", "s", "w", "nw", "ne", "se", "sw"], ["e", "w"], ["n", "s"], []];
                d3.text = d3_xhrType(function (request) {
                    return request.responseText;
                });
                d3.json = function (url, callback) {
                    return d3_xhr(url, "application/json", d3_json, callback);
                };

                function d3_json(request) {
                    return JSON.parse(request.responseText);
                }

                d3.html = function (url, callback) {
                    return d3_xhr(url, "text/html", d3_html, callback);
                };

                function d3_html(request) {
                    var range = d3_document.createRange();
                    range.selectNode(d3_document.body);
                    return range.createContextualFragment(request.responseText);
                }

                d3.xml = d3_xhrType(function (request) {
                    return request.responseXML;
                });
                if (typeof define === "function" && define.amd) this.d3 = d3, define(d3); else if (typeof module === "object" && module.exports) module.exports = d3; else this.d3 = d3;
            }.apply(self);
        }, {}],
        59: [function (_dereq_, module, exports) {
            'use strict'

            module.exports = _dereq_('./quad')

        }, {"./quad": 60}],
        60: [function (_dereq_, module, exports) {
            /**
             * @module  point-cluster/quad
             *
             * Bucket based quad tree clustering
             */

            'use strict'

            var search = _dereq_('binary-search-bounds')
            var clamp = _dereq_('clamp')
            var rect = _dereq_('parse-rect')
            var getBounds = _dereq_('array-bounds')
            var pick = _dereq_('pick-by-alias')
            var defined = _dereq_('defined')
            var flatten = _dereq_('flatten-vertex-data')
            var isObj = _dereq_('is-obj')
            var dtype = _dereq_('dtype')
            var log2 = _dereq_('math-log2')

            var MAX_GROUP_ID = 1073741824

            module.exports = function cluster(srcPoints, options) {
                if (!options) {
                    options = {}
                }

                srcPoints = flatten(srcPoints, 'float64')

                options = pick(options, {
                    bounds: 'range bounds dataBox databox',
                    maxDepth: 'depth maxDepth maxdepth level maxLevel maxlevel levels',
                    dtype: 'type dtype format out dst output destination'
                    // sort: 'sortBy sortby sort',
                    // pick: 'pick levelPoint',
                    // nodeSize: 'node nodeSize minNodeSize minSize size'
                })

                // let nodeSize = defined(options.nodeSize, 1)
                var maxDepth = defined(options.maxDepth, 255)
                var bounds = defined(options.bounds, getBounds(srcPoints, 2))
                if (bounds[0] === bounds[2]) {
                    bounds[2]++
                }
                if (bounds[1] === bounds[3]) {
                    bounds[3]++
                }

                var points = normalize(srcPoints, bounds)

                // init variables
                var n = srcPoints.length >>> 1
                var ids
                if (!options.dtype) {
                    options.dtype = 'array'
                }

                if (typeof options.dtype === 'string') {
                    ids = new (dtype(options.dtype))(n)
                } else if (options.dtype) {
                    ids = options.dtype
                    if (Array.isArray(ids)) {
                        ids.length = n
                    }
                }
                for (var i = 0; i < n; ++i) {
                    ids[i] = i
                }

                // representative point indexes for levels
                var levels = []

                // starting indexes of subranges in sub levels, levels.length * 4
                var sublevels = []

                // unique group ids, sorted in z-curve fashion within levels by shifting bits
                var groups = []

                // level offsets in `ids`
                var offsets = []


                // sort points
                sort(0, 0, 1, ids, 0, 1)


                // return reordered ids with provided methods
                // save level offsets in output buffer
                var offset = 0
                for (var level = 0; level < levels.length; level++) {
                    var levelItems = levels[level]
                    if (ids.set) {
                        ids.set(levelItems, offset)
                    } else {
                        for (var i$1 = 0, l = levelItems.length; i$1 < l; i$1++) {
                            ids[i$1 + offset] = levelItems[i$1]
                        }
                    }
                    var nextOffset = offset + levels[level].length
                    offsets[level] = [offset, nextOffset]
                    offset = nextOffset
                }

                ids.range = range

                return ids


                // FIXME: it is possible to create one typed array heap and reuse that to avoid memory blow
                function sort(x, y, diam, ids, level, group) {
                    if (!ids.length) {
                        return null
                    }

                    // save first point as level representative
                    var levelItems = levels[level] || (levels[level] = [])
                    var levelGroups = groups[level] || (groups[level] = [])
                    var sublevel = sublevels[level] || (sublevels[level] = [])
                    var offset = levelItems.length

                    level++

                    // max depth reached - put all items into a first group
                    // alternatively - if group id overflow - avoid proceeding
                    if (level > maxDepth || group > MAX_GROUP_ID) {
                        for (var i = 0; i < ids.length; i++) {
                            levelItems.push(ids[i])
                            levelGroups.push(group)
                            sublevel.push(null, null, null, null)
                        }

                        return offset
                    }

                    levelItems.push(ids[0])
                    levelGroups.push(group)

                    if (ids.length <= 1) {
                        sublevel.push(null, null, null, null)
                        return offset
                    }


                    var d2 = diam * .5
                    var cx = x + d2, cy = y + d2

                    // distribute points by 4 buckets
                    var lolo = [], lohi = [], hilo = [], hihi = []

                    for (var i$1 = 1, l = ids.length; i$1 < l; i$1++) {
                        var idx = ids[i$1],
                            x$1 = points[idx * 2],
                            y$1 = points[idx * 2 + 1]
                        x$1 < cx ? (y$1 < cy ? lolo.push(idx) : lohi.push(idx)) : (y$1 < cy ? hilo.push(idx) : hihi.push(idx))
                    }

                    group <<= 2

                    sublevel.push(
                        sort(x, y, d2, lolo, level, group),
                        sort(x, cy, d2, lohi, level, group + 1),
                        sort(cx, y, d2, hilo, level, group + 2),
                        sort(cx, cy, d2, hihi, level, group + 3)
                    )

                    return offset
                }

                // get all points within the passed range
                function range() {
                    var args = [], len = arguments.length;
                    while (len--) args[len] = arguments[len];

                    var options

                    if (isObj(args[args.length - 1])) {
                        var arg = args.pop()

                        // detect if that was a rect object
                        if (!args.length && (arg.x != null || arg.l != null || arg.left != null)) {
                            args = [arg]
                            options = {}
                        }

                        options = pick(arg, {
                            level: 'level maxLevel',
                            d: 'd diam diameter r radius px pxSize pixel pixelSize maxD size minSize',
                            lod: 'lod details ranges offsets'
                        })
                    } else {
                        options = {}
                    }

                    if (!args.length) {
                        args = bounds
                    }

                    var box = rect.apply(void 0, args)

                    var ref = [
                        Math.min(box.x, box.x + box.width),
                        Math.min(box.y, box.y + box.height),
                        Math.max(box.x, box.x + box.width),
                        Math.max(box.y, box.y + box.height)
                    ];
                    var minX = ref[0];
                    var minY = ref[1];
                    var maxX = ref[2];
                    var maxY = ref[3];

                    var ref$1 = normalize([minX, minY, maxX, maxY], bounds);
                    var nminX = ref$1[0];
                    var nminY = ref$1[1];
                    var nmaxX = ref$1[2];
                    var nmaxY = ref$1[3];

                    var maxLevel = defined(options.level, levels.length)

                    // limit maxLevel by px size
                    if (options.d != null) {
                        var d
                        if (typeof options.d === 'number') {
                            d = [options.d, options.d]
                        } else if (options.d.length) {
                            d = options.d
                        }

                        maxLevel = Math.min(
                            Math.max(
                                Math.ceil(-log2(Math.abs(d[0]) / (bounds[2] - bounds[0]))),
                                Math.ceil(-log2(Math.abs(d[1]) / (bounds[3] - bounds[1])))
                            ),
                            maxLevel
                        )
                    }
                    maxLevel = Math.min(maxLevel, levels.length)

                    // return levels of details
                    if (options.lod) {
                        return lod(nminX, nminY, nmaxX, nmaxY, maxLevel)
                    }


                    // do selection ids
                    var selection = []

                    // FIXME: probably we can do LOD here beforehead
                    select(0, 0, 1, 0, 0, 1)

                    function select(lox, loy, d, level, from, to) {
                        if (from === null || to === null) {
                            return
                        }

                        var hix = lox + d
                        var hiy = loy + d

                        // if box does not intersect level - ignore
                        if (nminX > hix || nminY > hiy || nmaxX < lox || nmaxY < loy) {
                            return
                        }
                        if (level >= maxLevel) {
                            return
                        }
                        if (from === to) {
                            return
                        }

                        // if points fall into box range - take it
                        var levelItems = levels[level]

                        if (to === undefined) {
                            to = levelItems.length
                        }

                        for (var i = from; i < to; i++) {
                            var id = levelItems[i]

                            var px = srcPoints[id * 2]
                            var py = srcPoints[id * 2 + 1]

                            if (px >= minX && px <= maxX && py >= minY && py <= maxY) {
                                selection.push(id)
                            }
                        }

                        // for every subsection do select
                        var offsets = sublevels[level]
                        var off0 = offsets[from * 4 + 0]
                        var off1 = offsets[from * 4 + 1]
                        var off2 = offsets[from * 4 + 2]
                        var off3 = offsets[from * 4 + 3]
                        var end = nextOffset(offsets, from + 1)

                        var d2 = d * .5
                        var nextLevel = level + 1
                        select(lox, loy, d2, nextLevel, off0, off1 || off2 || off3 || end)
                        select(lox, loy + d2, d2, nextLevel, off1, off2 || off3 || end)
                        select(lox + d2, loy, d2, nextLevel, off2, off3 || end)
                        select(lox + d2, loy + d2, d2, nextLevel, off3, end)
                    }

                    function nextOffset(offsets, from) {
                        var offset = null, i = 0
                        while (offset === null) {
                            offset = offsets[from * 4 + i]
                            i++
                            if (i > offsets.length) {
                                return null
                            }
                        }
                        return offset
                    }

                    return selection
                }

                // get range offsets within levels to render lods appropriate for zoom level
                // TODO: it is possible to store minSize of a point to optimize neede level calc
                function lod(lox, loy, hix, hiy, maxLevel) {
                    var ranges = []

                    for (var level = 0; level < maxLevel; level++) {
                        var levelGroups = groups[level]
                        var from = offsets[level][0]

                        var levelGroupStart = group(lox, loy, level)
                        var levelGroupEnd = group(hix, hiy, level)

                        // FIXME: utilize sublevels to speed up search range here
                        var startOffset = search.ge(levelGroups, levelGroupStart)
                        var endOffset = search.gt(levelGroups, levelGroupEnd, startOffset, levelGroups.length - 1)

                        ranges[level] = [startOffset + from, endOffset + from]
                    }

                    return ranges
                }

                // get group id closest to the x,y coordinate, corresponding to a level
                function group(x, y, level) {
                    var group = 1

                    var cx = .5, cy = .5
                    var diam = .5

                    for (var i = 0; i < level; i++) {
                        group <<= 2

                        group += x < cx ? (y < cy ? 0 : 1) : (y < cy ? 2 : 3)

                        diam *= .5

                        cx += x < cx ? -diam : diam
                        cy += y < cy ? -diam : diam
                    }

                    return group
                }
            }


// normalize points by bounds
            function normalize(pts, bounds) {
                var lox = bounds[0];
                var loy = bounds[1];
                var hix = bounds[2];
                var hiy = bounds[3];
                var scaleX = 1.0 / (hix - lox)
                var scaleY = 1.0 / (hiy - loy)
                var result = new Array(pts.length)

                for (var i = 0, n = pts.length / 2; i < n; i++) {
                    result[2 * i] = clamp((pts[2 * i] - lox) * scaleX, 0, 1)
                    result[2 * i + 1] = clamp((pts[2 * i + 1] - loy) * scaleY, 0, 1)
                }

                return result
            }

        }, {
            "array-bounds": 71,
            "binary-search-bounds": 80,
            "clamp": 86,
            "defined": 124,
            "dtype": 127,
            "flatten-vertex-data": 191,
            "is-obj": 235,
            "math-log2": 240,
            "parse-rect": 249,
            "pick-by-alias": 253
        }],
        61: [function (_dereq_, module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {value: true});
            var meta_1 = _dereq_("@turf/meta");
// Note: change RADIUS => earthRadius
            var RADIUS = 6378137;

            /**
             * Takes one or more features and returns their area in square meters.
             *
             * @name area
             * @param {GeoJSON} geojson input GeoJSON feature(s)
             * @returns {number} area in square meters
             * @example
             * var polygon = turf.polygon([[[125, -15], [113, -22], [154, -27], [144, -15], [125, -15]]]);
             *
             * var area = turf.area(polygon);
             *
             * //addToMap
             * var addToMap = [polygon]
             * polygon.properties.area = area
             */
            function area(geojson) {
                return meta_1.geomReduce(geojson, function (value, geom) {
                    return value + calculateArea(geom);
                }, 0);
            }

            exports.default = area;

            /**
             * Calculate Area
             *
             * @private
             * @param {Geometry} geom GeoJSON Geometries
             * @returns {number} area
             */
            function calculateArea(geom) {
                var total = 0;
                var i;
                switch (geom.type) {
                    case "Polygon":
                        return polygonArea(geom.coordinates);
                    case "MultiPolygon":
                        for (i = 0; i < geom.coordinates.length; i++) {
                            total += polygonArea(geom.coordinates[i]);
                        }
                        return total;
                    case "Point":
                    case "MultiPoint":
                    case "LineString":
                    case "MultiLineString":
                        return 0;
                }
                return 0;
            }

            function polygonArea(coords) {
                var total = 0;
                if (coords && coords.length > 0) {
                    total += Math.abs(ringArea(coords[0]));
                    for (var i = 1; i < coords.length; i++) {
                        total -= Math.abs(ringArea(coords[i]));
                    }
                }
                return total;
            }

            /**
             * @private
             * Calculate the approximate area of the polygon were it projected onto the earth.
             * Note that this area will be positive if ring is oriented clockwise, otherwise it will be negative.
             *
             * Reference:
             * Robert. G. Chamberlain and William H. Duquette, "Some Algorithms for Polygons on a Sphere",
             * JPL Publication 07-03, Jet Propulsion
             * Laboratory, Pasadena, CA, June 2007 https://trs.jpl.nasa.gov/handle/2014/40409
             *
             * @param {Array<Array<number>>} coords Ring Coordinates
             * @returns {number} The approximate signed geodesic area of the polygon in square meters.
             */
            function ringArea(coords) {
                var p1;
                var p2;
                var p3;
                var lowerIndex;
                var middleIndex;
                var upperIndex;
                var i;
                var total = 0;
                var coordsLength = coords.length;
                if (coordsLength > 2) {
                    for (i = 0; i < coordsLength; i++) {
                        if (i === coordsLength - 2) {
                            // i = N-2
                            lowerIndex = coordsLength - 2;
                            middleIndex = coordsLength - 1;
                            upperIndex = 0;
                        } else if (i === coordsLength - 1) {
                            // i = N-1
                            lowerIndex = coordsLength - 1;
                            middleIndex = 0;
                            upperIndex = 1;
                        } else {
                            // i = 0 to N-3
                            lowerIndex = i;
                            middleIndex = i + 1;
                            upperIndex = i + 2;
                        }
                        p1 = coords[lowerIndex];
                        p2 = coords[middleIndex];
                        p3 = coords[upperIndex];
                        total += (rad(p3[0]) - rad(p1[0])) * Math.sin(rad(p2[1]));
                    }
                    total = (total * RADIUS * RADIUS) / 2;
                }
                return total;
            }

            function rad(num) {
                return (num * Math.PI) / 180;
            }

        }, {"@turf/meta": 63}],
        62: [function (_dereq_, module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {value: true});
            /**
             * @module helpers
             */
            /**
             * Earth Radius used with the Harvesine formula and approximates using a spherical (non-ellipsoid) Earth.
             *
             * @memberof helpers
             * @type {number}
             */
            exports.earthRadius = 6371008.8;
            /**
             * Unit of measurement factors using a spherical (non-ellipsoid) earth radius.
             *
             * @memberof helpers
             * @type {Object}
             */
            exports.factors = {
                centimeters: exports.earthRadius * 100,
                centimetres: exports.earthRadius * 100,
                degrees: exports.earthRadius / 111325,
                feet: exports.earthRadius * 3.28084,
                inches: exports.earthRadius * 39.37,
                kilometers: exports.earthRadius / 1000,
                kilometres: exports.earthRadius / 1000,
                meters: exports.earthRadius,
                metres: exports.earthRadius,
                miles: exports.earthRadius / 1609.344,
                millimeters: exports.earthRadius * 1000,
                millimetres: exports.earthRadius * 1000,
                nauticalmiles: exports.earthRadius / 1852,
                radians: 1,
                yards: exports.earthRadius * 1.0936,
            };
            /**
             * Units of measurement factors based on 1 meter.
             *
             * @memberof helpers
             * @type {Object}
             */
            exports.unitsFactors = {
                centimeters: 100,
                centimetres: 100,
                degrees: 1 / 111325,
                feet: 3.28084,
                inches: 39.37,
                kilometers: 1 / 1000,
                kilometres: 1 / 1000,
                meters: 1,
                metres: 1,
                miles: 1 / 1609.344,
                millimeters: 1000,
                millimetres: 1000,
                nauticalmiles: 1 / 1852,
                radians: 1 / exports.earthRadius,
                yards: 1.0936133,
            };
            /**
             * Area of measurement factors based on 1 square meter.
             *
             * @memberof helpers
             * @type {Object}
             */
            exports.areaFactors = {
                acres: 0.000247105,
                centimeters: 10000,
                centimetres: 10000,
                feet: 10.763910417,
                hectares: 0.0001,
                inches: 1550.003100006,
                kilometers: 0.000001,
                kilometres: 0.000001,
                meters: 1,
                metres: 1,
                miles: 3.86e-7,
                millimeters: 1000000,
                millimetres: 1000000,
                yards: 1.195990046,
            };

            /**
             * Wraps a GeoJSON {@link Geometry} in a GeoJSON {@link Feature}.
             *
             * @name feature
             * @param {Geometry} geometry input geometry
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature} a GeoJSON Feature
             * @example
             * var geometry = {
             *   "type": "Point",
             *   "coordinates": [110, 50]
             * };
             *
             * var feature = turf.feature(geometry);
             *
             * //=feature
             */
            function feature(geom, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var feat = {type: "Feature"};
                if (options.id === 0 || options.id) {
                    feat.id = options.id;
                }
                if (options.bbox) {
                    feat.bbox = options.bbox;
                }
                feat.properties = properties || {};
                feat.geometry = geom;
                return feat;
            }

            exports.feature = feature;

            /**
             * Creates a GeoJSON {@link Geometry} from a Geometry string type & coordinates.
             * For GeometryCollection type use `helpers.geometryCollection`
             *
             * @name geometry
             * @param {string} type Geometry Type
             * @param {Array<any>} coordinates Coordinates
             * @param {Object} [options={}] Optional Parameters
             * @returns {Geometry} a GeoJSON Geometry
             * @example
             * var type = "Point";
             * var coordinates = [110, 50];
             * var geometry = turf.geometry(type, coordinates);
             * // => geometry
             */
            function geometry(type, coordinates, _options) {
                if (_options === void 0) {
                    _options = {};
                }
                switch (type) {
                    case "Point":
                        return point(coordinates).geometry;
                    case "LineString":
                        return lineString(coordinates).geometry;
                    case "Polygon":
                        return polygon(coordinates).geometry;
                    case "MultiPoint":
                        return multiPoint(coordinates).geometry;
                    case "MultiLineString":
                        return multiLineString(coordinates).geometry;
                    case "MultiPolygon":
                        return multiPolygon(coordinates).geometry;
                    default:
                        throw new Error(type + " is invalid");
                }
            }

            exports.geometry = geometry;

            /**
             * Creates a {@link Point} {@link Feature} from a Position.
             *
             * @name point
             * @param {Array<number>} coordinates longitude, latitude position (each in decimal degrees)
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<Point>} a Point feature
             * @example
             * var point = turf.point([-75.343, 39.984]);
             *
             * //=point
             */
            function point(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                if (!coordinates) {
                    throw new Error("coordinates is required");
                }
                if (!Array.isArray(coordinates)) {
                    throw new Error("coordinates must be an Array");
                }
                if (coordinates.length < 2) {
                    throw new Error("coordinates must be at least 2 numbers long");
                }
                if (!isNumber(coordinates[0]) || !isNumber(coordinates[1])) {
                    throw new Error("coordinates must contain numbers");
                }
                var geom = {
                    type: "Point",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.point = point;

            /**
             * Creates a {@link Point} {@link FeatureCollection} from an Array of Point coordinates.
             *
             * @name points
             * @param {Array<Array<number>>} coordinates an array of Points
             * @param {Object} [properties={}] Translate these properties to each Feature
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north]
             * associated with the FeatureCollection
             * @param {string|number} [options.id] Identifier associated with the FeatureCollection
             * @returns {FeatureCollection<Point>} Point Feature
             * @example
             * var points = turf.points([
             *   [-75, 39],
             *   [-80, 45],
             *   [-78, 50]
             * ]);
             *
             * //=points
             */
            function points(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                return featureCollection(coordinates.map(function (coords) {
                    return point(coords, properties);
                }), options);
            }

            exports.points = points;

            /**
             * Creates a {@link Polygon} {@link Feature} from an Array of LinearRings.
             *
             * @name polygon
             * @param {Array<Array<Array<number>>>} coordinates an array of LinearRings
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<Polygon>} Polygon Feature
             * @example
             * var polygon = turf.polygon([[[-5, 52], [-4, 56], [-2, 51], [-7, 54], [-5, 52]]], { name: 'poly1' });
             *
             * //=polygon
             */
            function polygon(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                for (var _i = 0, coordinates_1 = coordinates; _i < coordinates_1.length; _i++) {
                    var ring = coordinates_1[_i];
                    if (ring.length < 4) {
                        throw new Error("Each LinearRing of a Polygon must have 4 or more Positions.");
                    }
                    for (var j = 0; j < ring[ring.length - 1].length; j++) {
                        // Check if first point of Polygon contains two numbers
                        if (ring[ring.length - 1][j] !== ring[0][j]) {
                            throw new Error("First and last Position are not equivalent.");
                        }
                    }
                }
                var geom = {
                    type: "Polygon",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.polygon = polygon;

            /**
             * Creates a {@link Polygon} {@link FeatureCollection} from an Array of Polygon coordinates.
             *
             * @name polygons
             * @param {Array<Array<Array<Array<number>>>>} coordinates an array of Polygon coordinates
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the FeatureCollection
             * @returns {FeatureCollection<Polygon>} Polygon FeatureCollection
             * @example
             * var polygons = turf.polygons([
             *   [[[-5, 52], [-4, 56], [-2, 51], [-7, 54], [-5, 52]]],
             *   [[[-15, 42], [-14, 46], [-12, 41], [-17, 44], [-15, 42]]],
             * ]);
             *
             * //=polygons
             */
            function polygons(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                return featureCollection(coordinates.map(function (coords) {
                    return polygon(coords, properties);
                }), options);
            }

            exports.polygons = polygons;

            /**
             * Creates a {@link LineString} {@link Feature} from an Array of Positions.
             *
             * @name lineString
             * @param {Array<Array<number>>} coordinates an array of Positions
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<LineString>} LineString Feature
             * @example
             * var linestring1 = turf.lineString([[-24, 63], [-23, 60], [-25, 65], [-20, 69]], {name: 'line 1'});
             * var linestring2 = turf.lineString([[-14, 43], [-13, 40], [-15, 45], [-10, 49]], {name: 'line 2'});
             *
             * //=linestring1
             * //=linestring2
             */
            function lineString(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                if (coordinates.length < 2) {
                    throw new Error("coordinates must be an array of two or more positions");
                }
                var geom = {
                    type: "LineString",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.lineString = lineString;

            /**
             * Creates a {@link LineString} {@link FeatureCollection} from an Array of LineString coordinates.
             *
             * @name lineStrings
             * @param {Array<Array<Array<number>>>} coordinates an array of LinearRings
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north]
             * associated with the FeatureCollection
             * @param {string|number} [options.id] Identifier associated with the FeatureCollection
             * @returns {FeatureCollection<LineString>} LineString FeatureCollection
             * @example
             * var linestrings = turf.lineStrings([
             *   [[-24, 63], [-23, 60], [-25, 65], [-20, 69]],
             *   [[-14, 43], [-13, 40], [-15, 45], [-10, 49]]
             * ]);
             *
             * //=linestrings
             */
            function lineStrings(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                return featureCollection(coordinates.map(function (coords) {
                    return lineString(coords, properties);
                }), options);
            }

            exports.lineStrings = lineStrings;

            /**
             * Takes one or more {@link Feature|Features} and creates a {@link FeatureCollection}.
             *
             * @name featureCollection
             * @param {Feature[]} features input features
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {FeatureCollection} FeatureCollection of Features
             * @example
             * var locationA = turf.point([-75.343, 39.984], {name: 'Location A'});
             * var locationB = turf.point([-75.833, 39.284], {name: 'Location B'});
             * var locationC = turf.point([-75.534, 39.123], {name: 'Location C'});
             *
             * var collection = turf.featureCollection([
             *   locationA,
             *   locationB,
             *   locationC
             * ]);
             *
             * //=collection
             */
            function featureCollection(features, options) {
                if (options === void 0) {
                    options = {};
                }
                var fc = {type: "FeatureCollection"};
                if (options.id) {
                    fc.id = options.id;
                }
                if (options.bbox) {
                    fc.bbox = options.bbox;
                }
                fc.features = features;
                return fc;
            }

            exports.featureCollection = featureCollection;

            /**
             * Creates a {@link Feature<MultiLineString>} based on a
             * coordinate array. Properties can be added optionally.
             *
             * @name multiLineString
             * @param {Array<Array<Array<number>>>} coordinates an array of LineStrings
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<MultiLineString>} a MultiLineString feature
             * @throws {Error} if no coordinates are passed
             * @example
             * var multiLine = turf.multiLineString([[[0,0],[10,10]]]);
             *
             * //=multiLine
             */
            function multiLineString(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var geom = {
                    type: "MultiLineString",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.multiLineString = multiLineString;

            /**
             * Creates a {@link Feature<MultiPoint>} based on a
             * coordinate array. Properties can be added optionally.
             *
             * @name multiPoint
             * @param {Array<Array<number>>} coordinates an array of Positions
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<MultiPoint>} a MultiPoint feature
             * @throws {Error} if no coordinates are passed
             * @example
             * var multiPt = turf.multiPoint([[0,0],[10,10]]);
             *
             * //=multiPt
             */
            function multiPoint(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var geom = {
                    type: "MultiPoint",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.multiPoint = multiPoint;

            /**
             * Creates a {@link Feature<MultiPolygon>} based on a
             * coordinate array. Properties can be added optionally.
             *
             * @name multiPolygon
             * @param {Array<Array<Array<Array<number>>>>} coordinates an array of Polygons
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<MultiPolygon>} a multipolygon feature
             * @throws {Error} if no coordinates are passed
             * @example
             * var multiPoly = turf.multiPolygon([[[[0,0],[0,10],[10,10],[10,0],[0,0]]]]);
             *
             * //=multiPoly
             *
             */
            function multiPolygon(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var geom = {
                    type: "MultiPolygon",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.multiPolygon = multiPolygon;

            /**
             * Creates a {@link Feature<GeometryCollection>} based on a
             * coordinate array. Properties can be added optionally.
             *
             * @name geometryCollection
             * @param {Array<Geometry>} geometries an array of GeoJSON Geometries
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<GeometryCollection>} a GeoJSON GeometryCollection Feature
             * @example
             * var pt = turf.geometry("Point", [100, 0]);
             * var line = turf.geometry("LineString", [[101, 0], [102, 1]]);
             * var collection = turf.geometryCollection([pt, line]);
             *
             * // => collection
             */
            function geometryCollection(geometries, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var geom = {
                    type: "GeometryCollection",
                    geometries: geometries,
                };
                return feature(geom, properties, options);
            }

            exports.geometryCollection = geometryCollection;

            /**
             * Round number to precision
             *
             * @param {number} num Number
             * @param {number} [precision=0] Precision
             * @returns {number} rounded number
             * @example
             * turf.round(120.4321)
             * //=120
             *
             * turf.round(120.4321, 2)
             * //=120.43
             */
            function round(num, precision) {
                if (precision === void 0) {
                    precision = 0;
                }
                if (precision && !(precision >= 0)) {
                    throw new Error("precision must be a positive number");
                }
                var multiplier = Math.pow(10, precision || 0);
                return Math.round(num * multiplier) / multiplier;
            }

            exports.round = round;

            /**
             * Convert a distance measurement (assuming a spherical Earth) from radians to a more friendly unit.
             * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet
             *
             * @name radiansToLength
             * @param {number} radians in radians across the sphere
             * @param {string} [units="kilometers"] can be degrees, radians, miles, inches, yards, metres,
             * meters, kilometres, kilometers.
             * @returns {number} distance
             */
            function radiansToLength(radians, units) {
                if (units === void 0) {
                    units = "kilometers";
                }
                var factor = exports.factors[units];
                if (!factor) {
                    throw new Error(units + " units is invalid");
                }
                return radians * factor;
            }

            exports.radiansToLength = radiansToLength;

            /**
             * Convert a distance measurement (assuming a spherical Earth) from a real-world unit into radians
             * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet
             *
             * @name lengthToRadians
             * @param {number} distance in real units
             * @param {string} [units="kilometers"] can be degrees, radians, miles, inches, yards, metres,
             * meters, kilometres, kilometers.
             * @returns {number} radians
             */
            function lengthToRadians(distance, units) {
                if (units === void 0) {
                    units = "kilometers";
                }
                var factor = exports.factors[units];
                if (!factor) {
                    throw new Error(units + " units is invalid");
                }
                return distance / factor;
            }

            exports.lengthToRadians = lengthToRadians;

            /**
             * Convert a distance measurement (assuming a spherical Earth) from a real-world unit into degrees
             * Valid units: miles, nauticalmiles, inches, yards, meters, metres, centimeters, kilometres, feet
             *
             * @name lengthToDegrees
             * @param {number} distance in real units
             * @param {string} [units="kilometers"] can be degrees, radians, miles, inches, yards, metres,
             * meters, kilometres, kilometers.
             * @returns {number} degrees
             */
            function lengthToDegrees(distance, units) {
                return radiansToDegrees(lengthToRadians(distance, units));
            }

            exports.lengthToDegrees = lengthToDegrees;

            /**
             * Converts any bearing angle from the north line direction (positive clockwise)
             * and returns an angle between 0-360 degrees (positive clockwise), 0 being the north line
             *
             * @name bearingToAzimuth
             * @param {number} bearing angle, between -180 and +180 degrees
             * @returns {number} angle between 0 and 360 degrees
             */
            function bearingToAzimuth(bearing) {
                var angle = bearing % 360;
                if (angle < 0) {
                    angle += 360;
                }
                return angle;
            }

            exports.bearingToAzimuth = bearingToAzimuth;

            /**
             * Converts an angle in radians to degrees
             *
             * @name radiansToDegrees
             * @param {number} radians angle in radians
             * @returns {number} degrees between 0 and 360 degrees
             */
            function radiansToDegrees(radians) {
                var degrees = radians % (2 * Math.PI);
                return (degrees * 180) / Math.PI;
            }

            exports.radiansToDegrees = radiansToDegrees;

            /**
             * Converts an angle in degrees to radians
             *
             * @name degreesToRadians
             * @param {number} degrees angle between 0 and 360 degrees
             * @returns {number} angle in radians
             */
            function degreesToRadians(degrees) {
                var radians = degrees % 360;
                return (radians * Math.PI) / 180;
            }

            exports.degreesToRadians = degreesToRadians;

            /**
             * Converts a length to the requested unit.
             * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet
             *
             * @param {number} length to be converted
             * @param {Units} [originalUnit="kilometers"] of the length
             * @param {Units} [finalUnit="kilometers"] returned unit
             * @returns {number} the converted length
             */
            function convertLength(length, originalUnit, finalUnit) {
                if (originalUnit === void 0) {
                    originalUnit = "kilometers";
                }
                if (finalUnit === void 0) {
                    finalUnit = "kilometers";
                }
                if (!(length >= 0)) {
                    throw new Error("length must be a positive number");
                }
                return radiansToLength(lengthToRadians(length, originalUnit), finalUnit);
            }

            exports.convertLength = convertLength;

            /**
             * Converts a area to the requested unit.
             * Valid units: kilometers, kilometres, meters, metres, centimetres, millimeters, acres, miles, yards, feet, inches, hectares
             * @param {number} area to be converted
             * @param {Units} [originalUnit="meters"] of the distance
             * @param {Units} [finalUnit="kilometers"] returned unit
             * @returns {number} the converted area
             */
            function convertArea(area, originalUnit, finalUnit) {
                if (originalUnit === void 0) {
                    originalUnit = "meters";
                }
                if (finalUnit === void 0) {
                    finalUnit = "kilometers";
                }
                if (!(area >= 0)) {
                    throw new Error("area must be a positive number");
                }
                var startFactor = exports.areaFactors[originalUnit];
                if (!startFactor) {
                    throw new Error("invalid original units");
                }
                var finalFactor = exports.areaFactors[finalUnit];
                if (!finalFactor) {
                    throw new Error("invalid final units");
                }
                return (area / startFactor) * finalFactor;
            }

            exports.convertArea = convertArea;

            /**
             * isNumber
             *
             * @param {*} num Number to validate
             * @returns {boolean} true/false
             * @example
             * turf.isNumber(123)
             * //=true
             * turf.isNumber('foo')
             * //=false
             */
            function isNumber(num) {
                return !isNaN(num) && num !== null && !Array.isArray(num);
            }

            exports.isNumber = isNumber;

            /**
             * isObject
             *
             * @param {*} input variable to validate
             * @returns {boolean} true/false
             * @example
             * turf.isObject({elevation: 10})
             * //=true
             * turf.isObject('foo')
             * //=false
             */
            function isObject(input) {
                return !!input && input.constructor === Object;
            }

            exports.isObject = isObject;

            /**
             * Validate BBox
             *
             * @private
             * @param {Array<number>} bbox BBox to validate
             * @returns {void}
             * @throws Error if BBox is not valid
             * @example
             * validateBBox([-180, -40, 110, 50])
             * //=OK
             * validateBBox([-180, -40])
             * //=Error
             * validateBBox('Foo')
             * //=Error
             * validateBBox(5)
             * //=Error
             * validateBBox(null)
             * //=Error
             * validateBBox(undefined)
             * //=Error
             */
            function validateBBox(bbox) {
                if (!bbox) {
                    throw new Error("bbox is required");
                }
                if (!Array.isArray(bbox)) {
                    throw new Error("bbox must be an Array");
                }
                if (bbox.length !== 4 && bbox.length !== 6) {
                    throw new Error("bbox must be an Array of 4 or 6 numbers");
                }
                bbox.forEach(function (num) {
                    if (!isNumber(num)) {
                        throw new Error("bbox must only contain numbers");
                    }
                });
            }

            exports.validateBBox = validateBBox;

            /**
             * Validate Id
             *
             * @private
             * @param {string|number} id Id to validate
             * @returns {void}
             * @throws Error if Id is not valid
             * @example
             * validateId([-180, -40, 110, 50])
             * //=Error
             * validateId([-180, -40])
             * //=Error
             * validateId('Foo')
             * //=OK
             * validateId(5)
             * //=OK
             * validateId(null)
             * //=Error
             * validateId(undefined)
             * //=Error
             */
            function validateId(id) {
                if (!id) {
                    throw new Error("id is required");
                }
                if (["string", "number"].indexOf(typeof id) === -1) {
                    throw new Error("id must be a number or a string");
                }
            }

            exports.validateId = validateId;

        }, {}],
        63: [function (_dereq_, module, exports) {
            'use strict';

            Object.defineProperty(exports, '__esModule', {value: true});

            var helpers = _dereq_('@turf/helpers');

            /**
             * Callback for coordEach
             *
             * @callback coordEachCallback
             * @param {Array<number>} currentCoord The current coordinate being processed.
             * @param {number} coordIndex The current index of the coordinate being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             * @param {number} geometryIndex The current index of the Geometry being processed.
             */

            /**
             * Iterate over coordinates in any GeoJSON object, similar to Array.forEach()
             *
             * @name coordEach
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentCoord, coordIndex, featureIndex, multiFeatureIndex)
             * @param {boolean} [excludeWrapCoord=false] whether or not to include the final coordinate of LinearRings that wraps the ring in its iteration.
             * @returns {void}
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {"foo": "bar"}),
             *   turf.point([36, 53], {"hello": "world"})
             * ]);
             *
             * turf.coordEach(features, function (currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
             *   //=currentCoord
             *   //=coordIndex
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             * });
             */
            function coordEach(geojson, callback, excludeWrapCoord) {
                // Handles null Geometry -- Skips this GeoJSON
                if (geojson === null) return;
                var j,
                    k,
                    l,
                    geometry,
                    stopG,
                    coords,
                    geometryMaybeCollection,
                    wrapShrink = 0,
                    coordIndex = 0,
                    isGeometryCollection,
                    type = geojson.type,
                    isFeatureCollection = type === "FeatureCollection",
                    isFeature = type === "Feature",
                    stop = isFeatureCollection ? geojson.features.length : 1;

                // This logic may look a little weird. The reason why it is that way
                // is because it's trying to be fast. GeoJSON supports multiple kinds
                // of objects at its root: FeatureCollection, Features, Geometries.
                // This function has the responsibility of handling all of them, and that
                // means that some of the `for` loops you see below actually just don't apply
                // to certain inputs. For instance, if you give this just a
                // Point geometry, then both loops are short-circuited and all we do
                // is gradually rename the input until it's called 'geometry'.
                //
                // This also aims to allocate as few resources as possible: just a
                // few numbers and booleans, rather than any temporary arrays as would
                // be required with the normalization approach.
                for (var featureIndex = 0; featureIndex < stop; featureIndex++) {
                    geometryMaybeCollection = isFeatureCollection
                        ? geojson.features[featureIndex].geometry
                        : isFeature
                            ? geojson.geometry
                            : geojson;
                    isGeometryCollection = geometryMaybeCollection
                        ? geometryMaybeCollection.type === "GeometryCollection"
                        : false;
                    stopG = isGeometryCollection
                        ? geometryMaybeCollection.geometries.length
                        : 1;

                    for (var geomIndex = 0; geomIndex < stopG; geomIndex++) {
                        var multiFeatureIndex = 0;
                        var geometryIndex = 0;
                        geometry = isGeometryCollection
                            ? geometryMaybeCollection.geometries[geomIndex]
                            : geometryMaybeCollection;

                        // Handles null Geometry -- Skips this geometry
                        if (geometry === null) continue;
                        coords = geometry.coordinates;
                        var geomType = geometry.type;

                        wrapShrink =
                            excludeWrapCoord &&
                            (geomType === "Polygon" || geomType === "MultiPolygon")
                                ? 1
                                : 0;

                        switch (geomType) {
                            case null:
                                break;
                            case "Point":
                                if (
                                    callback(
                                        coords,
                                        coordIndex,
                                        featureIndex,
                                        multiFeatureIndex,
                                        geometryIndex
                                    ) === false
                                )
                                    return false;
                                coordIndex++;
                                multiFeatureIndex++;
                                break;
                            case "LineString":
                            case "MultiPoint":
                                for (j = 0; j < coords.length; j++) {
                                    if (
                                        callback(
                                            coords[j],
                                            coordIndex,
                                            featureIndex,
                                            multiFeatureIndex,
                                            geometryIndex
                                        ) === false
                                    )
                                        return false;
                                    coordIndex++;
                                    if (geomType === "MultiPoint") multiFeatureIndex++;
                                }
                                if (geomType === "LineString") multiFeatureIndex++;
                                break;
                            case "Polygon":
                            case "MultiLineString":
                                for (j = 0; j < coords.length; j++) {
                                    for (k = 0; k < coords[j].length - wrapShrink; k++) {
                                        if (
                                            callback(
                                                coords[j][k],
                                                coordIndex,
                                                featureIndex,
                                                multiFeatureIndex,
                                                geometryIndex
                                            ) === false
                                        )
                                            return false;
                                        coordIndex++;
                                    }
                                    if (geomType === "MultiLineString") multiFeatureIndex++;
                                    if (geomType === "Polygon") geometryIndex++;
                                }
                                if (geomType === "Polygon") multiFeatureIndex++;
                                break;
                            case "MultiPolygon":
                                for (j = 0; j < coords.length; j++) {
                                    geometryIndex = 0;
                                    for (k = 0; k < coords[j].length; k++) {
                                        for (l = 0; l < coords[j][k].length - wrapShrink; l++) {
                                            if (
                                                callback(
                                                    coords[j][k][l],
                                                    coordIndex,
                                                    featureIndex,
                                                    multiFeatureIndex,
                                                    geometryIndex
                                                ) === false
                                            )
                                                return false;
                                            coordIndex++;
                                        }
                                        geometryIndex++;
                                    }
                                    multiFeatureIndex++;
                                }
                                break;
                            case "GeometryCollection":
                                for (j = 0; j < geometry.geometries.length; j++)
                                    if (
                                        coordEach(geometry.geometries[j], callback, excludeWrapCoord) ===
                                        false
                                    )
                                        return false;
                                break;
                            default:
                                throw new Error("Unknown Geometry Type");
                        }
                    }
                }
            }

            /**
             * Callback for coordReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback coordReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Array<number>} currentCoord The current coordinate being processed.
             * @param {number} coordIndex The current index of the coordinate being processed.
             * Starts at index 0, if an initialValue is provided, and at index 1 otherwise.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             * @param {number} geometryIndex The current index of the Geometry being processed.
             */

            /**
             * Reduce coordinates in any GeoJSON object, similar to Array.reduce()
             *
             * @name coordReduce
             * @param {FeatureCollection|Geometry|Feature} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentCoord, coordIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @param {boolean} [excludeWrapCoord=false] whether or not to include the final coordinate of LinearRings that wraps the ring in its iteration.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {"foo": "bar"}),
             *   turf.point([36, 53], {"hello": "world"})
             * ]);
             *
             * turf.coordReduce(features, function (previousValue, currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
             *   //=previousValue
             *   //=currentCoord
             *   //=coordIndex
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             *   return currentCoord;
             * });
             */
            function coordReduce(geojson, callback, initialValue, excludeWrapCoord) {
                var previousValue = initialValue;
                coordEach(
                    geojson,
                    function (
                        currentCoord,
                        coordIndex,
                        featureIndex,
                        multiFeatureIndex,
                        geometryIndex
                    ) {
                        if (coordIndex === 0 && initialValue === undefined)
                            previousValue = currentCoord;
                        else
                            previousValue = callback(
                                previousValue,
                                currentCoord,
                                coordIndex,
                                featureIndex,
                                multiFeatureIndex,
                                geometryIndex
                            );
                    },
                    excludeWrapCoord
                );
                return previousValue;
            }

            /**
             * Callback for propEach
             *
             * @callback propEachCallback
             * @param {Object} currentProperties The current Properties being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             */

            /**
             * Iterate over properties in any GeoJSON object, similar to Array.forEach()
             *
             * @name propEach
             * @param {FeatureCollection|Feature} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentProperties, featureIndex)
             * @returns {void}
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.propEach(features, function (currentProperties, featureIndex) {
             *   //=currentProperties
             *   //=featureIndex
             * });
             */
            function propEach(geojson, callback) {
                var i;
                switch (geojson.type) {
                    case "FeatureCollection":
                        for (i = 0; i < geojson.features.length; i++) {
                            if (callback(geojson.features[i].properties, i) === false) break;
                        }
                        break;
                    case "Feature":
                        callback(geojson.properties, 0);
                        break;
                }
            }

            /**
             * Callback for propReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback propReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {*} currentProperties The current Properties being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             */

            /**
             * Reduce properties in any GeoJSON object into a single value,
             * similar to how Array.reduce works. However, in this case we lazily run
             * the reduction, so an array of all properties is unnecessary.
             *
             * @name propReduce
             * @param {FeatureCollection|Feature} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentProperties, featureIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.propReduce(features, function (previousValue, currentProperties, featureIndex) {
             *   //=previousValue
             *   //=currentProperties
             *   //=featureIndex
             *   return currentProperties
             * });
             */
            function propReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                propEach(geojson, function (currentProperties, featureIndex) {
                    if (featureIndex === 0 && initialValue === undefined)
                        previousValue = currentProperties;
                    else
                        previousValue = callback(previousValue, currentProperties, featureIndex);
                });
                return previousValue;
            }

            /**
             * Callback for featureEach
             *
             * @callback featureEachCallback
             * @param {Feature<any>} currentFeature The current Feature being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             */

            /**
             * Iterate over features in any GeoJSON object, similar to
             * Array.forEach.
             *
             * @name featureEach
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentFeature, featureIndex)
             * @returns {void}
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {foo: 'bar'}),
             *   turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.featureEach(features, function (currentFeature, featureIndex) {
             *   //=currentFeature
             *   //=featureIndex
             * });
             */
            function featureEach(geojson, callback) {
                if (geojson.type === "Feature") {
                    callback(geojson, 0);
                } else if (geojson.type === "FeatureCollection") {
                    for (var i = 0; i < geojson.features.length; i++) {
                        if (callback(geojson.features[i], i) === false) break;
                    }
                }
            }

            /**
             * Callback for featureReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback featureReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Feature} currentFeature The current Feature being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             */

            /**
             * Reduce features in any GeoJSON object, similar to Array.reduce().
             *
             * @name featureReduce
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentFeature, featureIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {"foo": "bar"}),
             *   turf.point([36, 53], {"hello": "world"})
             * ]);
             *
             * turf.featureReduce(features, function (previousValue, currentFeature, featureIndex) {
             *   //=previousValue
             *   //=currentFeature
             *   //=featureIndex
             *   return currentFeature
             * });
             */
            function featureReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                featureEach(geojson, function (currentFeature, featureIndex) {
                    if (featureIndex === 0 && initialValue === undefined)
                        previousValue = currentFeature;
                    else previousValue = callback(previousValue, currentFeature, featureIndex);
                });
                return previousValue;
            }

            /**
             * Get all coordinates from any GeoJSON object.
             *
             * @name coordAll
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @returns {Array<Array<number>>} coordinate position array
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {foo: 'bar'}),
             *   turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * var coords = turf.coordAll(features);
             * //= [[26, 37], [36, 53]]
             */
            function coordAll(geojson) {
                var coords = [];
                coordEach(geojson, function (coord) {
                    coords.push(coord);
                });
                return coords;
            }

            /**
             * Callback for geomEach
             *
             * @callback geomEachCallback
             * @param {Geometry} currentGeometry The current Geometry being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {Object} featureProperties The current Feature Properties being processed.
             * @param {Array<number>} featureBBox The current Feature BBox being processed.
             * @param {number|string} featureId The current Feature Id being processed.
             */

            /**
             * Iterate over each geometry in any GeoJSON object, similar to Array.forEach()
             *
             * @name geomEach
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentGeometry, featureIndex, featureProperties, featureBBox, featureId)
             * @returns {void}
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.geomEach(features, function (currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {
             *   //=currentGeometry
             *   //=featureIndex
             *   //=featureProperties
             *   //=featureBBox
             *   //=featureId
             * });
             */
            function geomEach(geojson, callback) {
                var i,
                    j,
                    g,
                    geometry,
                    stopG,
                    geometryMaybeCollection,
                    isGeometryCollection,
                    featureProperties,
                    featureBBox,
                    featureId,
                    featureIndex = 0,
                    isFeatureCollection = geojson.type === "FeatureCollection",
                    isFeature = geojson.type === "Feature",
                    stop = isFeatureCollection ? geojson.features.length : 1;

                // This logic may look a little weird. The reason why it is that way
                // is because it's trying to be fast. GeoJSON supports multiple kinds
                // of objects at its root: FeatureCollection, Features, Geometries.
                // This function has the responsibility of handling all of them, and that
                // means that some of the `for` loops you see below actually just don't apply
                // to certain inputs. For instance, if you give this just a
                // Point geometry, then both loops are short-circuited and all we do
                // is gradually rename the input until it's called 'geometry'.
                //
                // This also aims to allocate as few resources as possible: just a
                // few numbers and booleans, rather than any temporary arrays as would
                // be required with the normalization approach.
                for (i = 0; i < stop; i++) {
                    geometryMaybeCollection = isFeatureCollection
                        ? geojson.features[i].geometry
                        : isFeature
                            ? geojson.geometry
                            : geojson;
                    featureProperties = isFeatureCollection
                        ? geojson.features[i].properties
                        : isFeature
                            ? geojson.properties
                            : {};
                    featureBBox = isFeatureCollection
                        ? geojson.features[i].bbox
                        : isFeature
                            ? geojson.bbox
                            : undefined;
                    featureId = isFeatureCollection
                        ? geojson.features[i].id
                        : isFeature
                            ? geojson.id
                            : undefined;
                    isGeometryCollection = geometryMaybeCollection
                        ? geometryMaybeCollection.type === "GeometryCollection"
                        : false;
                    stopG = isGeometryCollection
                        ? geometryMaybeCollection.geometries.length
                        : 1;

                    for (g = 0; g < stopG; g++) {
                        geometry = isGeometryCollection
                            ? geometryMaybeCollection.geometries[g]
                            : geometryMaybeCollection;

                        // Handle null Geometry
                        if (geometry === null) {
                            if (
                                callback(
                                    null,
                                    featureIndex,
                                    featureProperties,
                                    featureBBox,
                                    featureId
                                ) === false
                            )
                                return false;
                            continue;
                        }
                        switch (geometry.type) {
                            case "Point":
                            case "LineString":
                            case "MultiPoint":
                            case "Polygon":
                            case "MultiLineString":
                            case "MultiPolygon": {
                                if (
                                    callback(
                                        geometry,
                                        featureIndex,
                                        featureProperties,
                                        featureBBox,
                                        featureId
                                    ) === false
                                )
                                    return false;
                                break;
                            }
                            case "GeometryCollection": {
                                for (j = 0; j < geometry.geometries.length; j++) {
                                    if (
                                        callback(
                                            geometry.geometries[j],
                                            featureIndex,
                                            featureProperties,
                                            featureBBox,
                                            featureId
                                        ) === false
                                    )
                                        return false;
                                }
                                break;
                            }
                            default:
                                throw new Error("Unknown Geometry Type");
                        }
                    }
                    // Only increase `featureIndex` per each feature
                    featureIndex++;
                }
            }

            /**
             * Callback for geomReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback geomReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Geometry} currentGeometry The current Geometry being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {Object} featureProperties The current Feature Properties being processed.
             * @param {Array<number>} featureBBox The current Feature BBox being processed.
             * @param {number|string} featureId The current Feature Id being processed.
             */

            /**
             * Reduce geometry in any GeoJSON object, similar to Array.reduce().
             *
             * @name geomReduce
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.geomReduce(features, function (previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {
             *   //=previousValue
             *   //=currentGeometry
             *   //=featureIndex
             *   //=featureProperties
             *   //=featureBBox
             *   //=featureId
             *   return currentGeometry
             * });
             */
            function geomReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                geomEach(
                    geojson,
                    function (
                        currentGeometry,
                        featureIndex,
                        featureProperties,
                        featureBBox,
                        featureId
                    ) {
                        if (featureIndex === 0 && initialValue === undefined)
                            previousValue = currentGeometry;
                        else
                            previousValue = callback(
                                previousValue,
                                currentGeometry,
                                featureIndex,
                                featureProperties,
                                featureBBox,
                                featureId
                            );
                    }
                );
                return previousValue;
            }

            /**
             * Callback for flattenEach
             *
             * @callback flattenEachCallback
             * @param {Feature} currentFeature The current flattened feature being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             */

            /**
             * Iterate over flattened features in any GeoJSON object, similar to
             * Array.forEach.
             *
             * @name flattenEach
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentFeature, featureIndex, multiFeatureIndex)
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.multiPoint([[40, 30], [36, 53]], {hello: 'world'})
             * ]);
             *
             * turf.flattenEach(features, function (currentFeature, featureIndex, multiFeatureIndex) {
             *   //=currentFeature
             *   //=featureIndex
             *   //=multiFeatureIndex
             * });
             */
            function flattenEach(geojson, callback) {
                geomEach(geojson, function (geometry, featureIndex, properties, bbox, id) {
                    // Callback for single geometry
                    var type = geometry === null ? null : geometry.type;
                    switch (type) {
                        case null:
                        case "Point":
                        case "LineString":
                        case "Polygon":
                            if (
                                callback(
                                    helpers.feature(geometry, properties, {
                                        bbox: bbox,
                                        id: id
                                    }),
                                    featureIndex,
                                    0
                                ) === false
                            )
                                return false;
                            return;
                    }

                    var geomType;

                    // Callback for multi-geometry
                    switch (type) {
                        case "MultiPoint":
                            geomType = "Point";
                            break;
                        case "MultiLineString":
                            geomType = "LineString";
                            break;
                        case "MultiPolygon":
                            geomType = "Polygon";
                            break;
                    }

                    for (
                        var multiFeatureIndex = 0;
                        multiFeatureIndex < geometry.coordinates.length;
                        multiFeatureIndex++
                    ) {
                        var coordinate = geometry.coordinates[multiFeatureIndex];
                        var geom = {
                            type: geomType,
                            coordinates: coordinate,
                        };
                        if (
                            callback(helpers.feature(geom, properties), featureIndex, multiFeatureIndex) ===
                            false
                        )
                            return false;
                    }
                });
            }

            /**
             * Callback for flattenReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback flattenReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Feature} currentFeature The current Feature being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             */

            /**
             * Reduce flattened features in any GeoJSON object, similar to Array.reduce().
             *
             * @name flattenReduce
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentFeature, featureIndex, multiFeatureIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.multiPoint([[40, 30], [36, 53]], {hello: 'world'})
             * ]);
             *
             * turf.flattenReduce(features, function (previousValue, currentFeature, featureIndex, multiFeatureIndex) {
             *   //=previousValue
             *   //=currentFeature
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   return currentFeature
             * });
             */
            function flattenReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                flattenEach(
                    geojson,
                    function (currentFeature, featureIndex, multiFeatureIndex) {
                        if (
                            featureIndex === 0 &&
                            multiFeatureIndex === 0 &&
                            initialValue === undefined
                        )
                            previousValue = currentFeature;
                        else
                            previousValue = callback(
                                previousValue,
                                currentFeature,
                                featureIndex,
                                multiFeatureIndex
                            );
                    }
                );
                return previousValue;
            }

            /**
             * Callback for segmentEach
             *
             * @callback segmentEachCallback
             * @param {Feature<LineString>} currentSegment The current Segment being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             * @param {number} geometryIndex The current index of the Geometry being processed.
             * @param {number} segmentIndex The current index of the Segment being processed.
             * @returns {void}
             */

            /**
             * Iterate over 2-vertex line segment in any GeoJSON object, similar to Array.forEach()
             * (Multi)Point geometries do not contain segments therefore they are ignored during this operation.
             *
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON
             * @param {Function} callback a method that takes (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex)
             * @returns {void}
             * @example
             * var polygon = turf.polygon([[[-50, 5], [-40, -10], [-50, -10], [-40, 5], [-50, 5]]]);
             *
             * // Iterate over GeoJSON by 2-vertex segments
             * turf.segmentEach(polygon, function (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {
             *   //=currentSegment
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             *   //=segmentIndex
             * });
             *
             * // Calculate the total number of segments
             * var total = 0;
             * turf.segmentEach(polygon, function () {
             *     total++;
             * });
             */
            function segmentEach(geojson, callback) {
                flattenEach(geojson, function (feature, featureIndex, multiFeatureIndex) {
                    var segmentIndex = 0;

                    // Exclude null Geometries
                    if (!feature.geometry) return;
                    // (Multi)Point geometries do not contain segments therefore they are ignored during this operation.
                    var type = feature.geometry.type;
                    if (type === "Point" || type === "MultiPoint") return;

                    // Generate 2-vertex line segments
                    var previousCoords;
                    var previousFeatureIndex = 0;
                    var previousMultiIndex = 0;
                    var prevGeomIndex = 0;
                    if (
                        coordEach(
                            feature,
                            function (
                                currentCoord,
                                coordIndex,
                                featureIndexCoord,
                                multiPartIndexCoord,
                                geometryIndex
                            ) {
                                // Simulating a meta.coordReduce() since `reduce` operations cannot be stopped by returning `false`
                                if (
                                    previousCoords === undefined ||
                                    featureIndex > previousFeatureIndex ||
                                    multiPartIndexCoord > previousMultiIndex ||
                                    geometryIndex > prevGeomIndex
                                ) {
                                    previousCoords = currentCoord;
                                    previousFeatureIndex = featureIndex;
                                    previousMultiIndex = multiPartIndexCoord;
                                    prevGeomIndex = geometryIndex;
                                    segmentIndex = 0;
                                    return;
                                }
                                var currentSegment = helpers.lineString(
                                    [previousCoords, currentCoord],
                                    feature.properties
                                );
                                if (
                                    callback(
                                        currentSegment,
                                        featureIndex,
                                        multiFeatureIndex,
                                        geometryIndex,
                                        segmentIndex
                                    ) === false
                                )
                                    return false;
                                segmentIndex++;
                                previousCoords = currentCoord;
                            }
                        ) === false
                    )
                        return false;
                });
            }

            /**
             * Callback for segmentReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback segmentReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Feature<LineString>} currentSegment The current Segment being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             * @param {number} geometryIndex The current index of the Geometry being processed.
             * @param {number} segmentIndex The current index of the Segment being processed.
             */

            /**
             * Reduce 2-vertex line segment in any GeoJSON object, similar to Array.reduce()
             * (Multi)Point geometries do not contain segments therefore they are ignored during this operation.
             *
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON
             * @param {Function} callback a method that takes (previousValue, currentSegment, currentIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {void}
             * @example
             * var polygon = turf.polygon([[[-50, 5], [-40, -10], [-50, -10], [-40, 5], [-50, 5]]]);
             *
             * // Iterate over GeoJSON by 2-vertex segments
             * turf.segmentReduce(polygon, function (previousSegment, currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {
             *   //= previousSegment
             *   //= currentSegment
             *   //= featureIndex
             *   //= multiFeatureIndex
             *   //= geometryIndex
             *   //= segmentIndex
             *   return currentSegment
             * });
             *
             * // Calculate the total number of segments
             * var initialValue = 0
             * var total = turf.segmentReduce(polygon, function (previousValue) {
             *     previousValue++;
             *     return previousValue;
             * }, initialValue);
             */
            function segmentReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                var started = false;
                segmentEach(
                    geojson,
                    function (
                        currentSegment,
                        featureIndex,
                        multiFeatureIndex,
                        geometryIndex,
                        segmentIndex
                    ) {
                        if (started === false && initialValue === undefined)
                            previousValue = currentSegment;
                        else
                            previousValue = callback(
                                previousValue,
                                currentSegment,
                                featureIndex,
                                multiFeatureIndex,
                                geometryIndex,
                                segmentIndex
                            );
                        started = true;
                    }
                );
                return previousValue;
            }

            /**
             * Callback for lineEach
             *
             * @callback lineEachCallback
             * @param {Feature<LineString>} currentLine The current LineString|LinearRing being processed
             * @param {number} featureIndex The current index of the Feature being processed
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed
             * @param {number} geometryIndex The current index of the Geometry being processed
             */

            /**
             * Iterate over line or ring coordinates in LineString, Polygon, MultiLineString, MultiPolygon Features or Geometries,
             * similar to Array.forEach.
             *
             * @name lineEach
             * @param {Geometry|Feature<LineString|Polygon|MultiLineString|MultiPolygon>} geojson object
             * @param {Function} callback a method that takes (currentLine, featureIndex, multiFeatureIndex, geometryIndex)
             * @example
             * var multiLine = turf.multiLineString([
             *   [[26, 37], [35, 45]],
             *   [[36, 53], [38, 50], [41, 55]]
             * ]);
             *
             * turf.lineEach(multiLine, function (currentLine, featureIndex, multiFeatureIndex, geometryIndex) {
             *   //=currentLine
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             * });
             */
            function lineEach(geojson, callback) {
                // validation
                if (!geojson) throw new Error("geojson is required");

                flattenEach(geojson, function (feature, featureIndex, multiFeatureIndex) {
                    if (feature.geometry === null) return;
                    var type = feature.geometry.type;
                    var coords = feature.geometry.coordinates;
                    switch (type) {
                        case "LineString":
                            if (callback(feature, featureIndex, multiFeatureIndex, 0, 0) === false)
                                return false;
                            break;
                        case "Polygon":
                            for (
                                var geometryIndex = 0;
                                geometryIndex < coords.length;
                                geometryIndex++
                            ) {
                                if (
                                    callback(
                                        helpers.lineString(coords[geometryIndex], feature.properties),
                                        featureIndex,
                                        multiFeatureIndex,
                                        geometryIndex
                                    ) === false
                                )
                                    return false;
                            }
                            break;
                    }
                });
            }

            /**
             * Callback for lineReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback lineReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Feature<LineString>} currentLine The current LineString|LinearRing being processed.
             * @param {number} featureIndex The current index of the Feature being processed
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed
             * @param {number} geometryIndex The current index of the Geometry being processed
             */

            /**
             * Reduce features in any GeoJSON object, similar to Array.reduce().
             *
             * @name lineReduce
             * @param {Geometry|Feature<LineString|Polygon|MultiLineString|MultiPolygon>} geojson object
             * @param {Function} callback a method that takes (previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var multiPoly = turf.multiPolygon([
             *   turf.polygon([[[12,48],[2,41],[24,38],[12,48]], [[9,44],[13,41],[13,45],[9,44]]]),
             *   turf.polygon([[[5, 5], [0, 0], [2, 2], [4, 4], [5, 5]]])
             * ]);
             *
             * turf.lineReduce(multiPoly, function (previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex) {
             *   //=previousValue
             *   //=currentLine
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             *   return currentLine
             * });
             */
            function lineReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                lineEach(
                    geojson,
                    function (currentLine, featureIndex, multiFeatureIndex, geometryIndex) {
                        if (featureIndex === 0 && initialValue === undefined)
                            previousValue = currentLine;
                        else
                            previousValue = callback(
                                previousValue,
                                currentLine,
                                featureIndex,
                                multiFeatureIndex,
                                geometryIndex
                            );
                    }
                );
                return previousValue;
            }

            /**
             * Finds a particular 2-vertex LineString Segment from a GeoJSON using `@turf/meta` indexes.
             *
             * Negative indexes are permitted.
             * Point & MultiPoint will always return null.
             *
             * @param {FeatureCollection|Feature|Geometry} geojson Any GeoJSON Feature or Geometry
             * @param {Object} [options={}] Optional parameters
             * @param {number} [options.featureIndex=0] Feature Index
             * @param {number} [options.multiFeatureIndex=0] Multi-Feature Index
             * @param {number} [options.geometryIndex=0] Geometry Index
             * @param {number} [options.segmentIndex=0] Segment Index
             * @param {Object} [options.properties={}] Translate Properties to output LineString
             * @param {BBox} [options.bbox={}] Translate BBox to output LineString
             * @param {number|string} [options.id={}] Translate Id to output LineString
             * @returns {Feature<LineString>} 2-vertex GeoJSON Feature LineString
             * @example
             * var multiLine = turf.multiLineString([
             *     [[10, 10], [50, 30], [30, 40]],
             *     [[-10, -10], [-50, -30], [-30, -40]]
             * ]);
             *
             * // First Segment (defaults are 0)
             * turf.findSegment(multiLine);
             * // => Feature<LineString<[[10, 10], [50, 30]]>>
             *
             * // First Segment of 2nd Multi Feature
             * turf.findSegment(multiLine, {multiFeatureIndex: 1});
             * // => Feature<LineString<[[-10, -10], [-50, -30]]>>
             *
             * // Last Segment of Last Multi Feature
             * turf.findSegment(multiLine, {multiFeatureIndex: -1, segmentIndex: -1});
             * // => Feature<LineString<[[-50, -30], [-30, -40]]>>
             */
            function findSegment(geojson, options) {
                // Optional Parameters
                options = options || {};
                if (!helpers.isObject(options)) throw new Error("options is invalid");
                var featureIndex = options.featureIndex || 0;
                var multiFeatureIndex = options.multiFeatureIndex || 0;
                var geometryIndex = options.geometryIndex || 0;
                var segmentIndex = options.segmentIndex || 0;

                // Find FeatureIndex
                var properties = options.properties;
                var geometry;

                switch (geojson.type) {
                    case "FeatureCollection":
                        if (featureIndex < 0)
                            featureIndex = geojson.features.length + featureIndex;
                        properties = properties || geojson.features[featureIndex].properties;
                        geometry = geojson.features[featureIndex].geometry;
                        break;
                    case "Feature":
                        properties = properties || geojson.properties;
                        geometry = geojson.geometry;
                        break;
                    case "Point":
                    case "MultiPoint":
                        return null;
                    case "LineString":
                    case "Polygon":
                    case "MultiLineString":
                    case "MultiPolygon":
                        geometry = geojson;
                        break;
                    default:
                        throw new Error("geojson is invalid");
                }

                // Find SegmentIndex
                if (geometry === null) return null;
                var coords = geometry.coordinates;
                switch (geometry.type) {
                    case "Point":
                    case "MultiPoint":
                        return null;
                    case "LineString":
                        if (segmentIndex < 0) segmentIndex = coords.length + segmentIndex - 1;
                        return helpers.lineString(
                            [coords[segmentIndex], coords[segmentIndex + 1]],
                            properties,
                            options
                        );
                    case "Polygon":
                        if (geometryIndex < 0) geometryIndex = coords.length + geometryIndex;
                        if (segmentIndex < 0)
                            segmentIndex = coords[geometryIndex].length + segmentIndex - 1;
                        return helpers.lineString(
                            [
                                coords[geometryIndex][segmentIndex],
                                coords[geometryIndex][segmentIndex + 1],
                            ],
                            properties,
                            options
                        );
                    case "MultiLineString":
                        if (multiFeatureIndex < 0)
                            multiFeatureIndex = coords.length + multiFeatureIndex;
                        if (segmentIndex < 0)
                            segmentIndex = coords[multiFeatureIndex].length + segmentIndex - 1;
                        return helpers.lineString(
                            [
                                coords[multiFeatureIndex][segmentIndex],
                                coords[multiFeatureIndex][segmentIndex + 1],
                            ],
                            properties,
                            options
                        );
                    case "MultiPolygon":
                        if (multiFeatureIndex < 0)
                            multiFeatureIndex = coords.length + multiFeatureIndex;
                        if (geometryIndex < 0)
                            geometryIndex = coords[multiFeatureIndex].length + geometryIndex;
                        if (segmentIndex < 0)
                            segmentIndex =
                                coords[multiFeatureIndex][geometryIndex].length - segmentIndex - 1;
                        return helpers.lineString(
                            [
                                coords[multiFeatureIndex][geometryIndex][segmentIndex],
                                coords[multiFeatureIndex][geometryIndex][segmentIndex + 1],
                            ],
                            properties,
                            options
                        );
                }
                throw new Error("geojson is invalid");
            }

            /**
             * Finds a particular Point from a GeoJSON using `@turf/meta` indexes.
             *
             * Negative indexes are permitted.
             *
             * @param {FeatureCollection|Feature|Geometry} geojson Any GeoJSON Feature or Geometry
             * @param {Object} [options={}] Optional parameters
             * @param {number} [options.featureIndex=0] Feature Index
             * @param {number} [options.multiFeatureIndex=0] Multi-Feature Index
             * @param {number} [options.geometryIndex=0] Geometry Index
             * @param {number} [options.coordIndex=0] Coord Index
             * @param {Object} [options.properties={}] Translate Properties to output Point
             * @param {BBox} [options.bbox={}] Translate BBox to output Point
             * @param {number|string} [options.id={}] Translate Id to output Point
             * @returns {Feature<Point>} 2-vertex GeoJSON Feature Point
             * @example
             * var multiLine = turf.multiLineString([
             *     [[10, 10], [50, 30], [30, 40]],
             *     [[-10, -10], [-50, -30], [-30, -40]]
             * ]);
             *
             * // First Segment (defaults are 0)
             * turf.findPoint(multiLine);
             * // => Feature<Point<[10, 10]>>
             *
             * // First Segment of the 2nd Multi-Feature
             * turf.findPoint(multiLine, {multiFeatureIndex: 1});
             * // => Feature<Point<[-10, -10]>>
             *
             * // Last Segment of last Multi-Feature
             * turf.findPoint(multiLine, {multiFeatureIndex: -1, coordIndex: -1});
             * // => Feature<Point<[-30, -40]>>
             */
            function findPoint(geojson, options) {
                // Optional Parameters
                options = options || {};
                if (!helpers.isObject(options)) throw new Error("options is invalid");
                var featureIndex = options.featureIndex || 0;
                var multiFeatureIndex = options.multiFeatureIndex || 0;
                var geometryIndex = options.geometryIndex || 0;
                var coordIndex = options.coordIndex || 0;

                // Find FeatureIndex
                var properties = options.properties;
                var geometry;

                switch (geojson.type) {
                    case "FeatureCollection":
                        if (featureIndex < 0)
                            featureIndex = geojson.features.length + featureIndex;
                        properties = properties || geojson.features[featureIndex].properties;
                        geometry = geojson.features[featureIndex].geometry;
                        break;
                    case "Feature":
                        properties = properties || geojson.properties;
                        geometry = geojson.geometry;
                        break;
                    case "Point":
                    case "MultiPoint":
                        return null;
                    case "LineString":
                    case "Polygon":
                    case "MultiLineString":
                    case "MultiPolygon":
                        geometry = geojson;
                        break;
                    default:
                        throw new Error("geojson is invalid");
                }

                // Find Coord Index
                if (geometry === null) return null;
                var coords = geometry.coordinates;
                switch (geometry.type) {
                    case "Point":
                        return helpers.point(coords, properties, options);
                    case "MultiPoint":
                        if (multiFeatureIndex < 0)
                            multiFeatureIndex = coords.length + multiFeatureIndex;
                        return helpers.point(coords[multiFeatureIndex], properties, options);
                    case "LineString":
                        if (coordIndex < 0) coordIndex = coords.length + coordIndex;
                        return helpers.point(coords[coordIndex], properties, options);
                    case "Polygon":
                        if (geometryIndex < 0) geometryIndex = coords.length + geometryIndex;
                        if (coordIndex < 0)
                            coordIndex = coords[geometryIndex].length + coordIndex;
                        return helpers.point(coords[geometryIndex][coordIndex], properties, options);
                    case "MultiLineString":
                        if (multiFeatureIndex < 0)
                            multiFeatureIndex = coords.length + multiFeatureIndex;
                        if (coordIndex < 0)
                            coordIndex = coords[multiFeatureIndex].length + coordIndex;
                        return helpers.point(coords[multiFeatureIndex][coordIndex], properties, options);
                    case "MultiPolygon":
                        if (multiFeatureIndex < 0)
                            multiFeatureIndex = coords.length + multiFeatureIndex;
                        if (geometryIndex < 0)
                            geometryIndex = coords[multiFeatureIndex].length + geometryIndex;
                        if (coordIndex < 0)
                            coordIndex =
                                coords[multiFeatureIndex][geometryIndex].length - coordIndex;
                        return helpers.point(
                            coords[multiFeatureIndex][geometryIndex][coordIndex],
                            properties,
                            options
                        );
                }
                throw new Error("geojson is invalid");
            }

            exports.coordEach = coordEach;
            exports.coordReduce = coordReduce;
            exports.propEach = propEach;
            exports.propReduce = propReduce;
            exports.featureEach = featureEach;
            exports.featureReduce = featureReduce;
            exports.coordAll = coordAll;
            exports.geomEach = geomEach;
            exports.geomReduce = geomReduce;
            exports.flattenEach = flattenEach;
            exports.flattenReduce = flattenReduce;
            exports.segmentEach = segmentEach;
            exports.segmentReduce = segmentReduce;
            exports.lineEach = lineEach;
            exports.lineReduce = lineReduce;
            exports.findSegment = findSegment;
            exports.findPoint = findPoint;

        }, {"@turf/helpers": 62}],
        64: [function (_dereq_, module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {value: true});
            var meta_1 = _dereq_("@turf/meta");

            /**
             * Takes a set of features, calculates the bbox of all input features, and returns a bounding box.
             *
             * @name bbox
             * @param {GeoJSON} geojson any GeoJSON object
             * @returns {BBox} bbox extent in [minX, minY, maxX, maxY] order
             * @example
             * var line = turf.lineString([[-74, 40], [-78, 42], [-82, 35]]);
             * var bbox = turf.bbox(line);
             * var bboxPolygon = turf.bboxPolygon(bbox);
             *
             * //addToMap
             * var addToMap = [line, bboxPolygon]
             */
            function bbox(geojson) {
                var result = [Infinity, Infinity, -Infinity, -Infinity];
                meta_1.coordEach(geojson, function (coord) {
                    if (result[0] > coord[0]) {
                        result[0] = coord[0];
                    }
                    if (result[1] > coord[1]) {
                        result[1] = coord[1];
                    }
                    if (result[2] < coord[0]) {
                        result[2] = coord[0];
                    }
                    if (result[3] < coord[1]) {
                        result[3] = coord[1];
                    }
                });
                return result;
            }

            bbox["default"] = bbox;
            exports.default = bbox;

        }, {"@turf/meta": 66}],
        65: [function (_dereq_, module, exports) {
            arguments[4][62][0].apply(exports, arguments)
        }, {"dup": 62}],
        66: [function (_dereq_, module, exports) {
            arguments[4][63][0].apply(exports, arguments)
        }, {"@turf/helpers": 65, "dup": 63}],
        67: [function (_dereq_, module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {value: true});
            var meta_1 = _dereq_("@turf/meta");
            var helpers_1 = _dereq_("@turf/helpers");

            /**
             * Takes one or more features and calculates the centroid using the mean of all vertices.
             * This lessens the effect of small islands and artifacts when calculating the centroid of a set of polygons.
             *
             * @name centroid
             * @param {GeoJSON} geojson GeoJSON to be centered
             * @param {Object} [options={}] Optional Parameters
             * @param {Object} [options.properties={}] an Object that is used as the {@link Feature}'s properties
             * @returns {Feature<Point>} the centroid of the input features
             * @example
             * var polygon = turf.polygon([[[-81, 41], [-88, 36], [-84, 31], [-80, 33], [-77, 39], [-81, 41]]]);
             *
             * var centroid = turf.centroid(polygon);
             *
             * //addToMap
             * var addToMap = [polygon, centroid]
             */
            function centroid(geojson, options) {
                if (options === void 0) {
                    options = {};
                }
                var xSum = 0;
                var ySum = 0;
                var len = 0;
                meta_1.coordEach(geojson, function (coord) {
                    xSum += coord[0];
                    ySum += coord[1];
                    len++;
                });
                return helpers_1.point([xSum / len, ySum / len], options.properties);
            }

            exports.default = centroid;

        }, {"@turf/helpers": 68, "@turf/meta": 69}],
        68: [function (_dereq_, module, exports) {
            "use strict";
            Object.defineProperty(exports, "__esModule", {value: true});
            /**
             * @module helpers
             */
            /**
             * Earth Radius used with the Harvesine formula and approximates using a spherical (non-ellipsoid) Earth.
             *
             * @memberof helpers
             * @type {number}
             */
            exports.earthRadius = 6371008.8;
            /**
             * Unit of measurement factors using a spherical (non-ellipsoid) earth radius.
             *
             * @memberof helpers
             * @type {Object}
             */
            exports.factors = {
                centimeters: exports.earthRadius * 100,
                centimetres: exports.earthRadius * 100,
                degrees: exports.earthRadius / 111325,
                feet: exports.earthRadius * 3.28084,
                inches: exports.earthRadius * 39.370,
                kilometers: exports.earthRadius / 1000,
                kilometres: exports.earthRadius / 1000,
                meters: exports.earthRadius,
                metres: exports.earthRadius,
                miles: exports.earthRadius / 1609.344,
                millimeters: exports.earthRadius * 1000,
                millimetres: exports.earthRadius * 1000,
                nauticalmiles: exports.earthRadius / 1852,
                radians: 1,
                yards: exports.earthRadius / 1.0936,
            };
            /**
             * Units of measurement factors based on 1 meter.
             *
             * @memberof helpers
             * @type {Object}
             */
            exports.unitsFactors = {
                centimeters: 100,
                centimetres: 100,
                degrees: 1 / 111325,
                feet: 3.28084,
                inches: 39.370,
                kilometers: 1 / 1000,
                kilometres: 1 / 1000,
                meters: 1,
                metres: 1,
                miles: 1 / 1609.344,
                millimeters: 1000,
                millimetres: 1000,
                nauticalmiles: 1 / 1852,
                radians: 1 / exports.earthRadius,
                yards: 1 / 1.0936,
            };
            /**
             * Area of measurement factors based on 1 square meter.
             *
             * @memberof helpers
             * @type {Object}
             */
            exports.areaFactors = {
                acres: 0.000247105,
                centimeters: 10000,
                centimetres: 10000,
                feet: 10.763910417,
                inches: 1550.003100006,
                kilometers: 0.000001,
                kilometres: 0.000001,
                meters: 1,
                metres: 1,
                miles: 3.86e-7,
                millimeters: 1000000,
                millimetres: 1000000,
                yards: 1.195990046,
            };

            /**
             * Wraps a GeoJSON {@link Geometry} in a GeoJSON {@link Feature}.
             *
             * @name feature
             * @param {Geometry} geometry input geometry
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature} a GeoJSON Feature
             * @example
             * var geometry = {
             *   "type": "Point",
             *   "coordinates": [110, 50]
             * };
             *
             * var feature = turf.feature(geometry);
             *
             * //=feature
             */
            function feature(geom, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var feat = {type: "Feature"};
                if (options.id === 0 || options.id) {
                    feat.id = options.id;
                }
                if (options.bbox) {
                    feat.bbox = options.bbox;
                }
                feat.properties = properties || {};
                feat.geometry = geom;
                return feat;
            }

            exports.feature = feature;

            /**
             * Creates a GeoJSON {@link Geometry} from a Geometry string type & coordinates.
             * For GeometryCollection type use `helpers.geometryCollection`
             *
             * @name geometry
             * @param {string} type Geometry Type
             * @param {Array<any>} coordinates Coordinates
             * @param {Object} [options={}] Optional Parameters
             * @returns {Geometry} a GeoJSON Geometry
             * @example
             * var type = "Point";
             * var coordinates = [110, 50];
             * var geometry = turf.geometry(type, coordinates);
             * // => geometry
             */
            function geometry(type, coordinates, options) {
                if (options === void 0) {
                    options = {};
                }
                switch (type) {
                    case "Point":
                        return point(coordinates).geometry;
                    case "LineString":
                        return lineString(coordinates).geometry;
                    case "Polygon":
                        return polygon(coordinates).geometry;
                    case "MultiPoint":
                        return multiPoint(coordinates).geometry;
                    case "MultiLineString":
                        return multiLineString(coordinates).geometry;
                    case "MultiPolygon":
                        return multiPolygon(coordinates).geometry;
                    default:
                        throw new Error(type + " is invalid");
                }
            }

            exports.geometry = geometry;

            /**
             * Creates a {@link Point} {@link Feature} from a Position.
             *
             * @name point
             * @param {Array<number>} coordinates longitude, latitude position (each in decimal degrees)
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<Point>} a Point feature
             * @example
             * var point = turf.point([-75.343, 39.984]);
             *
             * //=point
             */
            function point(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var geom = {
                    type: "Point",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.point = point;

            /**
             * Creates a {@link Point} {@link FeatureCollection} from an Array of Point coordinates.
             *
             * @name points
             * @param {Array<Array<number>>} coordinates an array of Points
             * @param {Object} [properties={}] Translate these properties to each Feature
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north]
             * associated with the FeatureCollection
             * @param {string|number} [options.id] Identifier associated with the FeatureCollection
             * @returns {FeatureCollection<Point>} Point Feature
             * @example
             * var points = turf.points([
             *   [-75, 39],
             *   [-80, 45],
             *   [-78, 50]
             * ]);
             *
             * //=points
             */
            function points(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                return featureCollection(coordinates.map(function (coords) {
                    return point(coords, properties);
                }), options);
            }

            exports.points = points;

            /**
             * Creates a {@link Polygon} {@link Feature} from an Array of LinearRings.
             *
             * @name polygon
             * @param {Array<Array<Array<number>>>} coordinates an array of LinearRings
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<Polygon>} Polygon Feature
             * @example
             * var polygon = turf.polygon([[[-5, 52], [-4, 56], [-2, 51], [-7, 54], [-5, 52]]], { name: 'poly1' });
             *
             * //=polygon
             */
            function polygon(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                for (var _i = 0, coordinates_1 = coordinates; _i < coordinates_1.length; _i++) {
                    var ring = coordinates_1[_i];
                    if (ring.length < 4) {
                        throw new Error("Each LinearRing of a Polygon must have 4 or more Positions.");
                    }
                    for (var j = 0; j < ring[ring.length - 1].length; j++) {
                        // Check if first point of Polygon contains two numbers
                        if (ring[ring.length - 1][j] !== ring[0][j]) {
                            throw new Error("First and last Position are not equivalent.");
                        }
                    }
                }
                var geom = {
                    type: "Polygon",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.polygon = polygon;

            /**
             * Creates a {@link Polygon} {@link FeatureCollection} from an Array of Polygon coordinates.
             *
             * @name polygons
             * @param {Array<Array<Array<Array<number>>>>} coordinates an array of Polygon coordinates
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the FeatureCollection
             * @returns {FeatureCollection<Polygon>} Polygon FeatureCollection
             * @example
             * var polygons = turf.polygons([
             *   [[[-5, 52], [-4, 56], [-2, 51], [-7, 54], [-5, 52]]],
             *   [[[-15, 42], [-14, 46], [-12, 41], [-17, 44], [-15, 42]]],
             * ]);
             *
             * //=polygons
             */
            function polygons(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                return featureCollection(coordinates.map(function (coords) {
                    return polygon(coords, properties);
                }), options);
            }

            exports.polygons = polygons;

            /**
             * Creates a {@link LineString} {@link Feature} from an Array of Positions.
             *
             * @name lineString
             * @param {Array<Array<number>>} coordinates an array of Positions
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<LineString>} LineString Feature
             * @example
             * var linestring1 = turf.lineString([[-24, 63], [-23, 60], [-25, 65], [-20, 69]], {name: 'line 1'});
             * var linestring2 = turf.lineString([[-14, 43], [-13, 40], [-15, 45], [-10, 49]], {name: 'line 2'});
             *
             * //=linestring1
             * //=linestring2
             */
            function lineString(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                if (coordinates.length < 2) {
                    throw new Error("coordinates must be an array of two or more positions");
                }
                var geom = {
                    type: "LineString",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.lineString = lineString;

            /**
             * Creates a {@link LineString} {@link FeatureCollection} from an Array of LineString coordinates.
             *
             * @name lineStrings
             * @param {Array<Array<Array<number>>>} coordinates an array of LinearRings
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north]
             * associated with the FeatureCollection
             * @param {string|number} [options.id] Identifier associated with the FeatureCollection
             * @returns {FeatureCollection<LineString>} LineString FeatureCollection
             * @example
             * var linestrings = turf.lineStrings([
             *   [[-24, 63], [-23, 60], [-25, 65], [-20, 69]],
             *   [[-14, 43], [-13, 40], [-15, 45], [-10, 49]]
             * ]);
             *
             * //=linestrings
             */
            function lineStrings(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                return featureCollection(coordinates.map(function (coords) {
                    return lineString(coords, properties);
                }), options);
            }

            exports.lineStrings = lineStrings;

            /**
             * Takes one or more {@link Feature|Features} and creates a {@link FeatureCollection}.
             *
             * @name featureCollection
             * @param {Feature[]} features input features
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {FeatureCollection} FeatureCollection of Features
             * @example
             * var locationA = turf.point([-75.343, 39.984], {name: 'Location A'});
             * var locationB = turf.point([-75.833, 39.284], {name: 'Location B'});
             * var locationC = turf.point([-75.534, 39.123], {name: 'Location C'});
             *
             * var collection = turf.featureCollection([
             *   locationA,
             *   locationB,
             *   locationC
             * ]);
             *
             * //=collection
             */
            function featureCollection(features, options) {
                if (options === void 0) {
                    options = {};
                }
                var fc = {type: "FeatureCollection"};
                if (options.id) {
                    fc.id = options.id;
                }
                if (options.bbox) {
                    fc.bbox = options.bbox;
                }
                fc.features = features;
                return fc;
            }

            exports.featureCollection = featureCollection;

            /**
             * Creates a {@link Feature<MultiLineString>} based on a
             * coordinate array. Properties can be added optionally.
             *
             * @name multiLineString
             * @param {Array<Array<Array<number>>>} coordinates an array of LineStrings
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<MultiLineString>} a MultiLineString feature
             * @throws {Error} if no coordinates are passed
             * @example
             * var multiLine = turf.multiLineString([[[0,0],[10,10]]]);
             *
             * //=multiLine
             */
            function multiLineString(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var geom = {
                    type: "MultiLineString",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.multiLineString = multiLineString;

            /**
             * Creates a {@link Feature<MultiPoint>} based on a
             * coordinate array. Properties can be added optionally.
             *
             * @name multiPoint
             * @param {Array<Array<number>>} coordinates an array of Positions
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<MultiPoint>} a MultiPoint feature
             * @throws {Error} if no coordinates are passed
             * @example
             * var multiPt = turf.multiPoint([[0,0],[10,10]]);
             *
             * //=multiPt
             */
            function multiPoint(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var geom = {
                    type: "MultiPoint",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.multiPoint = multiPoint;

            /**
             * Creates a {@link Feature<MultiPolygon>} based on a
             * coordinate array. Properties can be added optionally.
             *
             * @name multiPolygon
             * @param {Array<Array<Array<Array<number>>>>} coordinates an array of Polygons
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<MultiPolygon>} a multipolygon feature
             * @throws {Error} if no coordinates are passed
             * @example
             * var multiPoly = turf.multiPolygon([[[[0,0],[0,10],[10,10],[10,0],[0,0]]]]);
             *
             * //=multiPoly
             *
             */
            function multiPolygon(coordinates, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var geom = {
                    type: "MultiPolygon",
                    coordinates: coordinates,
                };
                return feature(geom, properties, options);
            }

            exports.multiPolygon = multiPolygon;

            /**
             * Creates a {@link Feature<GeometryCollection>} based on a
             * coordinate array. Properties can be added optionally.
             *
             * @name geometryCollection
             * @param {Array<Geometry>} geometries an array of GeoJSON Geometries
             * @param {Object} [properties={}] an Object of key-value pairs to add as properties
             * @param {Object} [options={}] Optional Parameters
             * @param {Array<number>} [options.bbox] Bounding Box Array [west, south, east, north] associated with the Feature
             * @param {string|number} [options.id] Identifier associated with the Feature
             * @returns {Feature<GeometryCollection>} a GeoJSON GeometryCollection Feature
             * @example
             * var pt = turf.geometry("Point", [100, 0]);
             * var line = turf.geometry("LineString", [[101, 0], [102, 1]]);
             * var collection = turf.geometryCollection([pt, line]);
             *
             * // => collection
             */
            function geometryCollection(geometries, properties, options) {
                if (options === void 0) {
                    options = {};
                }
                var geom = {
                    type: "GeometryCollection",
                    geometries: geometries,
                };
                return feature(geom, properties, options);
            }

            exports.geometryCollection = geometryCollection;

            /**
             * Round number to precision
             *
             * @param {number} num Number
             * @param {number} [precision=0] Precision
             * @returns {number} rounded number
             * @example
             * turf.round(120.4321)
             * //=120
             *
             * turf.round(120.4321, 2)
             * //=120.43
             */
            function round(num, precision) {
                if (precision === void 0) {
                    precision = 0;
                }
                if (precision && !(precision >= 0)) {
                    throw new Error("precision must be a positive number");
                }
                var multiplier = Math.pow(10, precision || 0);
                return Math.round(num * multiplier) / multiplier;
            }

            exports.round = round;

            /**
             * Convert a distance measurement (assuming a spherical Earth) from radians to a more friendly unit.
             * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet
             *
             * @name radiansToLength
             * @param {number} radians in radians across the sphere
             * @param {string} [units="kilometers"] can be degrees, radians, miles, or kilometers inches, yards, metres,
             * meters, kilometres, kilometers.
             * @returns {number} distance
             */
            function radiansToLength(radians, units) {
                if (units === void 0) {
                    units = "kilometers";
                }
                var factor = exports.factors[units];
                if (!factor) {
                    throw new Error(units + " units is invalid");
                }
                return radians * factor;
            }

            exports.radiansToLength = radiansToLength;

            /**
             * Convert a distance measurement (assuming a spherical Earth) from a real-world unit into radians
             * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet
             *
             * @name lengthToRadians
             * @param {number} distance in real units
             * @param {string} [units="kilometers"] can be degrees, radians, miles, or kilometers inches, yards, metres,
             * meters, kilometres, kilometers.
             * @returns {number} radians
             */
            function lengthToRadians(distance, units) {
                if (units === void 0) {
                    units = "kilometers";
                }
                var factor = exports.factors[units];
                if (!factor) {
                    throw new Error(units + " units is invalid");
                }
                return distance / factor;
            }

            exports.lengthToRadians = lengthToRadians;

            /**
             * Convert a distance measurement (assuming a spherical Earth) from a real-world unit into degrees
             * Valid units: miles, nauticalmiles, inches, yards, meters, metres, centimeters, kilometres, feet
             *
             * @name lengthToDegrees
             * @param {number} distance in real units
             * @param {string} [units="kilometers"] can be degrees, radians, miles, or kilometers inches, yards, metres,
             * meters, kilometres, kilometers.
             * @returns {number} degrees
             */
            function lengthToDegrees(distance, units) {
                return radiansToDegrees(lengthToRadians(distance, units));
            }

            exports.lengthToDegrees = lengthToDegrees;

            /**
             * Converts any bearing angle from the north line direction (positive clockwise)
             * and returns an angle between 0-360 degrees (positive clockwise), 0 being the north line
             *
             * @name bearingToAzimuth
             * @param {number} bearing angle, between -180 and +180 degrees
             * @returns {number} angle between 0 and 360 degrees
             */
            function bearingToAzimuth(bearing) {
                var angle = bearing % 360;
                if (angle < 0) {
                    angle += 360;
                }
                return angle;
            }

            exports.bearingToAzimuth = bearingToAzimuth;

            /**
             * Converts an angle in radians to degrees
             *
             * @name radiansToDegrees
             * @param {number} radians angle in radians
             * @returns {number} degrees between 0 and 360 degrees
             */
            function radiansToDegrees(radians) {
                var degrees = radians % (2 * Math.PI);
                return degrees * 180 / Math.PI;
            }

            exports.radiansToDegrees = radiansToDegrees;

            /**
             * Converts an angle in degrees to radians
             *
             * @name degreesToRadians
             * @param {number} degrees angle between 0 and 360 degrees
             * @returns {number} angle in radians
             */
            function degreesToRadians(degrees) {
                var radians = degrees % 360;
                return radians * Math.PI / 180;
            }

            exports.degreesToRadians = degreesToRadians;

            /**
             * Converts a length to the requested unit.
             * Valid units: miles, nauticalmiles, inches, yards, meters, metres, kilometers, centimeters, feet
             *
             * @param {number} length to be converted
             * @param {Units} [originalUnit="kilometers"] of the length
             * @param {Units} [finalUnit="kilometers"] returned unit
             * @returns {number} the converted length
             */
            function convertLength(length, originalUnit, finalUnit) {
                if (originalUnit === void 0) {
                    originalUnit = "kilometers";
                }
                if (finalUnit === void 0) {
                    finalUnit = "kilometers";
                }
                if (!(length >= 0)) {
                    throw new Error("length must be a positive number");
                }
                return radiansToLength(lengthToRadians(length, originalUnit), finalUnit);
            }

            exports.convertLength = convertLength;

            /**
             * Converts a area to the requested unit.
             * Valid units: kilometers, kilometres, meters, metres, centimetres, millimeters, acres, miles, yards, feet, inches
             * @param {number} area to be converted
             * @param {Units} [originalUnit="meters"] of the distance
             * @param {Units} [finalUnit="kilometers"] returned unit
             * @returns {number} the converted distance
             */
            function convertArea(area, originalUnit, finalUnit) {
                if (originalUnit === void 0) {
                    originalUnit = "meters";
                }
                if (finalUnit === void 0) {
                    finalUnit = "kilometers";
                }
                if (!(area >= 0)) {
                    throw new Error("area must be a positive number");
                }
                var startFactor = exports.areaFactors[originalUnit];
                if (!startFactor) {
                    throw new Error("invalid original units");
                }
                var finalFactor = exports.areaFactors[finalUnit];
                if (!finalFactor) {
                    throw new Error("invalid final units");
                }
                return (area / startFactor) * finalFactor;
            }

            exports.convertArea = convertArea;

            /**
             * isNumber
             *
             * @param {*} num Number to validate
             * @returns {boolean} true/false
             * @example
             * turf.isNumber(123)
             * //=true
             * turf.isNumber('foo')
             * //=false
             */
            function isNumber(num) {
                return !isNaN(num) && num !== null && !Array.isArray(num) && !/^\s*$/.test(num);
            }

            exports.isNumber = isNumber;

            /**
             * isObject
             *
             * @param {*} input variable to validate
             * @returns {boolean} true/false
             * @example
             * turf.isObject({elevation: 10})
             * //=true
             * turf.isObject('foo')
             * //=false
             */
            function isObject(input) {
                return (!!input) && (input.constructor === Object);
            }

            exports.isObject = isObject;

            /**
             * Validate BBox
             *
             * @private
             * @param {Array<number>} bbox BBox to validate
             * @returns {void}
             * @throws Error if BBox is not valid
             * @example
             * validateBBox([-180, -40, 110, 50])
             * //=OK
             * validateBBox([-180, -40])
             * //=Error
             * validateBBox('Foo')
             * //=Error
             * validateBBox(5)
             * //=Error
             * validateBBox(null)
             * //=Error
             * validateBBox(undefined)
             * //=Error
             */
            function validateBBox(bbox) {
                if (!bbox) {
                    throw new Error("bbox is required");
                }
                if (!Array.isArray(bbox)) {
                    throw new Error("bbox must be an Array");
                }
                if (bbox.length !== 4 && bbox.length !== 6) {
                    throw new Error("bbox must be an Array of 4 or 6 numbers");
                }
                bbox.forEach(function (num) {
                    if (!isNumber(num)) {
                        throw new Error("bbox must only contain numbers");
                    }
                });
            }

            exports.validateBBox = validateBBox;

            /**
             * Validate Id
             *
             * @private
             * @param {string|number} id Id to validate
             * @returns {void}
             * @throws Error if Id is not valid
             * @example
             * validateId([-180, -40, 110, 50])
             * //=Error
             * validateId([-180, -40])
             * //=Error
             * validateId('Foo')
             * //=OK
             * validateId(5)
             * //=OK
             * validateId(null)
             * //=Error
             * validateId(undefined)
             * //=Error
             */
            function validateId(id) {
                if (!id) {
                    throw new Error("id is required");
                }
                if (["string", "number"].indexOf(typeof id) === -1) {
                    throw new Error("id must be a number or a string");
                }
            }

            exports.validateId = validateId;

// Deprecated methods
            function radians2degrees() {
                throw new Error("method has been renamed to `radiansToDegrees`");
            }

            exports.radians2degrees = radians2degrees;

            function degrees2radians() {
                throw new Error("method has been renamed to `degreesToRadians`");
            }

            exports.degrees2radians = degrees2radians;

            function distanceToDegrees() {
                throw new Error("method has been renamed to `lengthToDegrees`");
            }

            exports.distanceToDegrees = distanceToDegrees;

            function distanceToRadians() {
                throw new Error("method has been renamed to `lengthToRadians`");
            }

            exports.distanceToRadians = distanceToRadians;

            function radiansToDistance() {
                throw new Error("method has been renamed to `radiansToLength`");
            }

            exports.radiansToDistance = radiansToDistance;

            function bearingToAngle() {
                throw new Error("method has been renamed to `bearingToAzimuth`");
            }

            exports.bearingToAngle = bearingToAngle;

            function convertDistance() {
                throw new Error("method has been renamed to `convertLength`");
            }

            exports.convertDistance = convertDistance;

        }, {}],
        69: [function (_dereq_, module, exports) {
            'use strict';

            Object.defineProperty(exports, '__esModule', {value: true});

            var helpers = _dereq_('@turf/helpers');

            /**
             * Callback for coordEach
             *
             * @callback coordEachCallback
             * @param {Array<number>} currentCoord The current coordinate being processed.
             * @param {number} coordIndex The current index of the coordinate being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             * @param {number} geometryIndex The current index of the Geometry being processed.
             */

            /**
             * Iterate over coordinates in any GeoJSON object, similar to Array.forEach()
             *
             * @name coordEach
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentCoord, coordIndex, featureIndex, multiFeatureIndex)
             * @param {boolean} [excludeWrapCoord=false] whether or not to include the final coordinate of LinearRings that wraps the ring in its iteration.
             * @returns {void}
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {"foo": "bar"}),
             *   turf.point([36, 53], {"hello": "world"})
             * ]);
             *
             * turf.coordEach(features, function (currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
             *   //=currentCoord
             *   //=coordIndex
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             * });
             */
            function coordEach(geojson, callback, excludeWrapCoord) {
                // Handles null Geometry -- Skips this GeoJSON
                if (geojson === null) return;
                var j, k, l, geometry, stopG, coords,
                    geometryMaybeCollection,
                    wrapShrink = 0,
                    coordIndex = 0,
                    isGeometryCollection,
                    type = geojson.type,
                    isFeatureCollection = type === 'FeatureCollection',
                    isFeature = type === 'Feature',
                    stop = isFeatureCollection ? geojson.features.length : 1;

                // This logic may look a little weird. The reason why it is that way
                // is because it's trying to be fast. GeoJSON supports multiple kinds
                // of objects at its root: FeatureCollection, Features, Geometries.
                // This function has the responsibility of handling all of them, and that
                // means that some of the `for` loops you see below actually just don't apply
                // to certain inputs. For instance, if you give this just a
                // Point geometry, then both loops are short-circuited and all we do
                // is gradually rename the input until it's called 'geometry'.
                //
                // This also aims to allocate as few resources as possible: just a
                // few numbers and booleans, rather than any temporary arrays as would
                // be required with the normalization approach.
                for (var featureIndex = 0; featureIndex < stop; featureIndex++) {
                    geometryMaybeCollection = (isFeatureCollection ? geojson.features[featureIndex].geometry :
                        (isFeature ? geojson.geometry : geojson));
                    isGeometryCollection = (geometryMaybeCollection) ? geometryMaybeCollection.type === 'GeometryCollection' : false;
                    stopG = isGeometryCollection ? geometryMaybeCollection.geometries.length : 1;

                    for (var geomIndex = 0; geomIndex < stopG; geomIndex++) {
                        var multiFeatureIndex = 0;
                        var geometryIndex = 0;
                        geometry = isGeometryCollection ?
                            geometryMaybeCollection.geometries[geomIndex] : geometryMaybeCollection;

                        // Handles null Geometry -- Skips this geometry
                        if (geometry === null) continue;
                        coords = geometry.coordinates;
                        var geomType = geometry.type;

                        wrapShrink = (excludeWrapCoord && (geomType === 'Polygon' || geomType === 'MultiPolygon')) ? 1 : 0;

                        switch (geomType) {
                            case null:
                                break;
                            case 'Point':
                                if (callback(coords, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
                                coordIndex++;
                                multiFeatureIndex++;
                                break;
                            case 'LineString':
                            case 'MultiPoint':
                                for (j = 0; j < coords.length; j++) {
                                    if (callback(coords[j], coordIndex, featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
                                    coordIndex++;
                                    if (geomType === 'MultiPoint') multiFeatureIndex++;
                                }
                                if (geomType === 'LineString') multiFeatureIndex++;
                                break;
                            case 'Polygon':
                            case 'MultiLineString':
                                for (j = 0; j < coords.length; j++) {
                                    for (k = 0; k < coords[j].length - wrapShrink; k++) {
                                        if (callback(coords[j][k], coordIndex, featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
                                        coordIndex++;
                                    }
                                    if (geomType === 'MultiLineString') multiFeatureIndex++;
                                    if (geomType === 'Polygon') geometryIndex++;
                                }
                                if (geomType === 'Polygon') multiFeatureIndex++;
                                break;
                            case 'MultiPolygon':
                                for (j = 0; j < coords.length; j++) {
                                    geometryIndex = 0;
                                    for (k = 0; k < coords[j].length; k++) {
                                        for (l = 0; l < coords[j][k].length - wrapShrink; l++) {
                                            if (callback(coords[j][k][l], coordIndex, featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
                                            coordIndex++;
                                        }
                                        geometryIndex++;
                                    }
                                    multiFeatureIndex++;
                                }
                                break;
                            case 'GeometryCollection':
                                for (j = 0; j < geometry.geometries.length; j++)
                                    if (coordEach(geometry.geometries[j], callback, excludeWrapCoord) === false) return false;
                                break;
                            default:
                                throw new Error('Unknown Geometry Type');
                        }
                    }
                }
            }

            /**
             * Callback for coordReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback coordReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Array<number>} currentCoord The current coordinate being processed.
             * @param {number} coordIndex The current index of the coordinate being processed.
             * Starts at index 0, if an initialValue is provided, and at index 1 otherwise.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             * @param {number} geometryIndex The current index of the Geometry being processed.
             */

            /**
             * Reduce coordinates in any GeoJSON object, similar to Array.reduce()
             *
             * @name coordReduce
             * @param {FeatureCollection|Geometry|Feature} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentCoord, coordIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @param {boolean} [excludeWrapCoord=false] whether or not to include the final coordinate of LinearRings that wraps the ring in its iteration.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {"foo": "bar"}),
             *   turf.point([36, 53], {"hello": "world"})
             * ]);
             *
             * turf.coordReduce(features, function (previousValue, currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
             *   //=previousValue
             *   //=currentCoord
             *   //=coordIndex
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             *   return currentCoord;
             * });
             */
            function coordReduce(geojson, callback, initialValue, excludeWrapCoord) {
                var previousValue = initialValue;
                coordEach(geojson, function (currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
                    if (coordIndex === 0 && initialValue === undefined) previousValue = currentCoord;
                    else previousValue = callback(previousValue, currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex);
                }, excludeWrapCoord);
                return previousValue;
            }

            /**
             * Callback for propEach
             *
             * @callback propEachCallback
             * @param {Object} currentProperties The current Properties being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             */

            /**
             * Iterate over properties in any GeoJSON object, similar to Array.forEach()
             *
             * @name propEach
             * @param {FeatureCollection|Feature} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentProperties, featureIndex)
             * @returns {void}
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.propEach(features, function (currentProperties, featureIndex) {
             *   //=currentProperties
             *   //=featureIndex
             * });
             */
            function propEach(geojson, callback) {
                var i;
                switch (geojson.type) {
                    case 'FeatureCollection':
                        for (i = 0; i < geojson.features.length; i++) {
                            if (callback(geojson.features[i].properties, i) === false) break;
                        }
                        break;
                    case 'Feature':
                        callback(geojson.properties, 0);
                        break;
                }
            }


            /**
             * Callback for propReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback propReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {*} currentProperties The current Properties being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             */

            /**
             * Reduce properties in any GeoJSON object into a single value,
             * similar to how Array.reduce works. However, in this case we lazily run
             * the reduction, so an array of all properties is unnecessary.
             *
             * @name propReduce
             * @param {FeatureCollection|Feature} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentProperties, featureIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.propReduce(features, function (previousValue, currentProperties, featureIndex) {
             *   //=previousValue
             *   //=currentProperties
             *   //=featureIndex
             *   return currentProperties
             * });
             */
            function propReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                propEach(geojson, function (currentProperties, featureIndex) {
                    if (featureIndex === 0 && initialValue === undefined) previousValue = currentProperties;
                    else previousValue = callback(previousValue, currentProperties, featureIndex);
                });
                return previousValue;
            }

            /**
             * Callback for featureEach
             *
             * @callback featureEachCallback
             * @param {Feature<any>} currentFeature The current Feature being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             */

            /**
             * Iterate over features in any GeoJSON object, similar to
             * Array.forEach.
             *
             * @name featureEach
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentFeature, featureIndex)
             * @returns {void}
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {foo: 'bar'}),
             *   turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.featureEach(features, function (currentFeature, featureIndex) {
             *   //=currentFeature
             *   //=featureIndex
             * });
             */
            function featureEach(geojson, callback) {
                if (geojson.type === 'Feature') {
                    callback(geojson, 0);
                } else if (geojson.type === 'FeatureCollection') {
                    for (var i = 0; i < geojson.features.length; i++) {
                        if (callback(geojson.features[i], i) === false) break;
                    }
                }
            }

            /**
             * Callback for featureReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback featureReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Feature} currentFeature The current Feature being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             */

            /**
             * Reduce features in any GeoJSON object, similar to Array.reduce().
             *
             * @name featureReduce
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentFeature, featureIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {"foo": "bar"}),
             *   turf.point([36, 53], {"hello": "world"})
             * ]);
             *
             * turf.featureReduce(features, function (previousValue, currentFeature, featureIndex) {
             *   //=previousValue
             *   //=currentFeature
             *   //=featureIndex
             *   return currentFeature
             * });
             */
            function featureReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                featureEach(geojson, function (currentFeature, featureIndex) {
                    if (featureIndex === 0 && initialValue === undefined) previousValue = currentFeature;
                    else previousValue = callback(previousValue, currentFeature, featureIndex);
                });
                return previousValue;
            }

            /**
             * Get all coordinates from any GeoJSON object.
             *
             * @name coordAll
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @returns {Array<Array<number>>} coordinate position array
             * @example
             * var features = turf.featureCollection([
             *   turf.point([26, 37], {foo: 'bar'}),
             *   turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * var coords = turf.coordAll(features);
             * //= [[26, 37], [36, 53]]
             */
            function coordAll(geojson) {
                var coords = [];
                coordEach(geojson, function (coord) {
                    coords.push(coord);
                });
                return coords;
            }

            /**
             * Callback for geomEach
             *
             * @callback geomEachCallback
             * @param {Geometry} currentGeometry The current Geometry being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {Object} featureProperties The current Feature Properties being processed.
             * @param {Array<number>} featureBBox The current Feature BBox being processed.
             * @param {number|string} featureId The current Feature Id being processed.
             */

            /**
             * Iterate over each geometry in any GeoJSON object, similar to Array.forEach()
             *
             * @name geomEach
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentGeometry, featureIndex, featureProperties, featureBBox, featureId)
             * @returns {void}
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.geomEach(features, function (currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {
             *   //=currentGeometry
             *   //=featureIndex
             *   //=featureProperties
             *   //=featureBBox
             *   //=featureId
             * });
             */
            function geomEach(geojson, callback) {
                var i, j, g, geometry, stopG,
                    geometryMaybeCollection,
                    isGeometryCollection,
                    featureProperties,
                    featureBBox,
                    featureId,
                    featureIndex = 0,
                    isFeatureCollection = geojson.type === 'FeatureCollection',
                    isFeature = geojson.type === 'Feature',
                    stop = isFeatureCollection ? geojson.features.length : 1;

                // This logic may look a little weird. The reason why it is that way
                // is because it's trying to be fast. GeoJSON supports multiple kinds
                // of objects at its root: FeatureCollection, Features, Geometries.
                // This function has the responsibility of handling all of them, and that
                // means that some of the `for` loops you see below actually just don't apply
                // to certain inputs. For instance, if you give this just a
                // Point geometry, then both loops are short-circuited and all we do
                // is gradually rename the input until it's called 'geometry'.
                //
                // This also aims to allocate as few resources as possible: just a
                // few numbers and booleans, rather than any temporary arrays as would
                // be required with the normalization approach.
                for (i = 0; i < stop; i++) {

                    geometryMaybeCollection = (isFeatureCollection ? geojson.features[i].geometry :
                        (isFeature ? geojson.geometry : geojson));
                    featureProperties = (isFeatureCollection ? geojson.features[i].properties :
                        (isFeature ? geojson.properties : {}));
                    featureBBox = (isFeatureCollection ? geojson.features[i].bbox :
                        (isFeature ? geojson.bbox : undefined));
                    featureId = (isFeatureCollection ? geojson.features[i].id :
                        (isFeature ? geojson.id : undefined));
                    isGeometryCollection = (geometryMaybeCollection) ? geometryMaybeCollection.type === 'GeometryCollection' : false;
                    stopG = isGeometryCollection ? geometryMaybeCollection.geometries.length : 1;

                    for (g = 0; g < stopG; g++) {
                        geometry = isGeometryCollection ?
                            geometryMaybeCollection.geometries[g] : geometryMaybeCollection;

                        // Handle null Geometry
                        if (geometry === null) {
                            if (callback(null, featureIndex, featureProperties, featureBBox, featureId) === false) return false;
                            continue;
                        }
                        switch (geometry.type) {
                            case 'Point':
                            case 'LineString':
                            case 'MultiPoint':
                            case 'Polygon':
                            case 'MultiLineString':
                            case 'MultiPolygon': {
                                if (callback(geometry, featureIndex, featureProperties, featureBBox, featureId) === false) return false;
                                break;
                            }
                            case 'GeometryCollection': {
                                for (j = 0; j < geometry.geometries.length; j++) {
                                    if (callback(geometry.geometries[j], featureIndex, featureProperties, featureBBox, featureId) === false) return false;
                                }
                                break;
                            }
                            default:
                                throw new Error('Unknown Geometry Type');
                        }
                    }
                    // Only increase `featureIndex` per each feature
                    featureIndex++;
                }
            }

            /**
             * Callback for geomReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback geomReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Geometry} currentGeometry The current Geometry being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {Object} featureProperties The current Feature Properties being processed.
             * @param {Array<number>} featureBBox The current Feature BBox being processed.
             * @param {number|string} featureId The current Feature Id being processed.
             */

            /**
             * Reduce geometry in any GeoJSON object, similar to Array.reduce().
             *
             * @name geomReduce
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.point([36, 53], {hello: 'world'})
             * ]);
             *
             * turf.geomReduce(features, function (previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {
             *   //=previousValue
             *   //=currentGeometry
             *   //=featureIndex
             *   //=featureProperties
             *   //=featureBBox
             *   //=featureId
             *   return currentGeometry
             * });
             */
            function geomReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                geomEach(geojson, function (currentGeometry, featureIndex, featureProperties, featureBBox, featureId) {
                    if (featureIndex === 0 && initialValue === undefined) previousValue = currentGeometry;
                    else previousValue = callback(previousValue, currentGeometry, featureIndex, featureProperties, featureBBox, featureId);
                });
                return previousValue;
            }

            /**
             * Callback for flattenEach
             *
             * @callback flattenEachCallback
             * @param {Feature} currentFeature The current flattened feature being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             */

            /**
             * Iterate over flattened features in any GeoJSON object, similar to
             * Array.forEach.
             *
             * @name flattenEach
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (currentFeature, featureIndex, multiFeatureIndex)
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.multiPoint([[40, 30], [36, 53]], {hello: 'world'})
             * ]);
             *
             * turf.flattenEach(features, function (currentFeature, featureIndex, multiFeatureIndex) {
             *   //=currentFeature
             *   //=featureIndex
             *   //=multiFeatureIndex
             * });
             */
            function flattenEach(geojson, callback) {
                geomEach(geojson, function (geometry, featureIndex, properties, bbox, id) {
                    // Callback for single geometry
                    var type = (geometry === null) ? null : geometry.type;
                    switch (type) {
                        case null:
                        case 'Point':
                        case 'LineString':
                        case 'Polygon':
                            if (callback(helpers.feature(geometry, properties, {
                                bbox: bbox,
                                id: id
                            }), featureIndex, 0) === false) return false;
                            return;
                    }

                    var geomType;

                    // Callback for multi-geometry
                    switch (type) {
                        case 'MultiPoint':
                            geomType = 'Point';
                            break;
                        case 'MultiLineString':
                            geomType = 'LineString';
                            break;
                        case 'MultiPolygon':
                            geomType = 'Polygon';
                            break;
                    }

                    for (var multiFeatureIndex = 0; multiFeatureIndex < geometry.coordinates.length; multiFeatureIndex++) {
                        var coordinate = geometry.coordinates[multiFeatureIndex];
                        var geom = {
                            type: geomType,
                            coordinates: coordinate
                        };
                        if (callback(helpers.feature(geom, properties), featureIndex, multiFeatureIndex) === false) return false;
                    }
                });
            }

            /**
             * Callback for flattenReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback flattenReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Feature} currentFeature The current Feature being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             */

            /**
             * Reduce flattened features in any GeoJSON object, similar to Array.reduce().
             *
             * @name flattenReduce
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON object
             * @param {Function} callback a method that takes (previousValue, currentFeature, featureIndex, multiFeatureIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var features = turf.featureCollection([
             *     turf.point([26, 37], {foo: 'bar'}),
             *     turf.multiPoint([[40, 30], [36, 53]], {hello: 'world'})
             * ]);
             *
             * turf.flattenReduce(features, function (previousValue, currentFeature, featureIndex, multiFeatureIndex) {
             *   //=previousValue
             *   //=currentFeature
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   return currentFeature
             * });
             */
            function flattenReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                flattenEach(geojson, function (currentFeature, featureIndex, multiFeatureIndex) {
                    if (featureIndex === 0 && multiFeatureIndex === 0 && initialValue === undefined) previousValue = currentFeature;
                    else previousValue = callback(previousValue, currentFeature, featureIndex, multiFeatureIndex);
                });
                return previousValue;
            }

            /**
             * Callback for segmentEach
             *
             * @callback segmentEachCallback
             * @param {Feature<LineString>} currentSegment The current Segment being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             * @param {number} geometryIndex The current index of the Geometry being processed.
             * @param {number} segmentIndex The current index of the Segment being processed.
             * @returns {void}
             */

            /**
             * Iterate over 2-vertex line segment in any GeoJSON object, similar to Array.forEach()
             * (Multi)Point geometries do not contain segments therefore they are ignored during this operation.
             *
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON
             * @param {Function} callback a method that takes (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex)
             * @returns {void}
             * @example
             * var polygon = turf.polygon([[[-50, 5], [-40, -10], [-50, -10], [-40, 5], [-50, 5]]]);
             *
             * // Iterate over GeoJSON by 2-vertex segments
             * turf.segmentEach(polygon, function (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {
             *   //=currentSegment
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             *   //=segmentIndex
             * });
             *
             * // Calculate the total number of segments
             * var total = 0;
             * turf.segmentEach(polygon, function () {
             *     total++;
             * });
             */
            function segmentEach(geojson, callback) {
                flattenEach(geojson, function (feature, featureIndex, multiFeatureIndex) {
                    var segmentIndex = 0;

                    // Exclude null Geometries
                    if (!feature.geometry) return;
                    // (Multi)Point geometries do not contain segments therefore they are ignored during this operation.
                    var type = feature.geometry.type;
                    if (type === 'Point' || type === 'MultiPoint') return;

                    // Generate 2-vertex line segments
                    var previousCoords;
                    var previousFeatureIndex = 0;
                    var previousMultiIndex = 0;
                    var prevGeomIndex = 0;
                    if (coordEach(feature, function (currentCoord, coordIndex, featureIndexCoord, multiPartIndexCoord, geometryIndex) {
                        // Simulating a meta.coordReduce() since `reduce` operations cannot be stopped by returning `false`
                        if (previousCoords === undefined || featureIndex > previousFeatureIndex || multiPartIndexCoord > previousMultiIndex || geometryIndex > prevGeomIndex) {
                            previousCoords = currentCoord;
                            previousFeatureIndex = featureIndex;
                            previousMultiIndex = multiPartIndexCoord;
                            prevGeomIndex = geometryIndex;
                            segmentIndex = 0;
                            return;
                        }
                        var currentSegment = helpers.lineString([previousCoords, currentCoord], feature.properties);
                        if (callback(currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) === false) return false;
                        segmentIndex++;
                        previousCoords = currentCoord;
                    }) === false) return false;
                });
            }

            /**
             * Callback for segmentReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback segmentReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Feature<LineString>} currentSegment The current Segment being processed.
             * @param {number} featureIndex The current index of the Feature being processed.
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed.
             * @param {number} geometryIndex The current index of the Geometry being processed.
             * @param {number} segmentIndex The current index of the Segment being processed.
             */

            /**
             * Reduce 2-vertex line segment in any GeoJSON object, similar to Array.reduce()
             * (Multi)Point geometries do not contain segments therefore they are ignored during this operation.
             *
             * @param {FeatureCollection|Feature|Geometry} geojson any GeoJSON
             * @param {Function} callback a method that takes (previousValue, currentSegment, currentIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {void}
             * @example
             * var polygon = turf.polygon([[[-50, 5], [-40, -10], [-50, -10], [-40, 5], [-50, 5]]]);
             *
             * // Iterate over GeoJSON by 2-vertex segments
             * turf.segmentReduce(polygon, function (previousSegment, currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {
             *   //= previousSegment
             *   //= currentSegment
             *   //= featureIndex
             *   //= multiFeatureIndex
             *   //= geometryIndex
             *   //= segmentInex
             *   return currentSegment
             * });
             *
             * // Calculate the total number of segments
             * var initialValue = 0
             * var total = turf.segmentReduce(polygon, function (previousValue) {
             *     previousValue++;
             *     return previousValue;
             * }, initialValue);
             */
            function segmentReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                var started = false;
                segmentEach(geojson, function (currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex) {
                    if (started === false && initialValue === undefined) previousValue = currentSegment;
                    else previousValue = callback(previousValue, currentSegment, featureIndex, multiFeatureIndex, geometryIndex, segmentIndex);
                    started = true;
                });
                return previousValue;
            }

            /**
             * Callback for lineEach
             *
             * @callback lineEachCallback
             * @param {Feature<LineString>} currentLine The current LineString|LinearRing being processed
             * @param {number} featureIndex The current index of the Feature being processed
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed
             * @param {number} geometryIndex The current index of the Geometry being processed
             */

            /**
             * Iterate over line or ring coordinates in LineString, Polygon, MultiLineString, MultiPolygon Features or Geometries,
             * similar to Array.forEach.
             *
             * @name lineEach
             * @param {Geometry|Feature<LineString|Polygon|MultiLineString|MultiPolygon>} geojson object
             * @param {Function} callback a method that takes (currentLine, featureIndex, multiFeatureIndex, geometryIndex)
             * @example
             * var multiLine = turf.multiLineString([
             *   [[26, 37], [35, 45]],
             *   [[36, 53], [38, 50], [41, 55]]
             * ]);
             *
             * turf.lineEach(multiLine, function (currentLine, featureIndex, multiFeatureIndex, geometryIndex) {
             *   //=currentLine
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             * });
             */
            function lineEach(geojson, callback) {
                // validation
                if (!geojson) throw new Error('geojson is required');

                flattenEach(geojson, function (feature, featureIndex, multiFeatureIndex) {
                    if (feature.geometry === null) return;
                    var type = feature.geometry.type;
                    var coords = feature.geometry.coordinates;
                    switch (type) {
                        case 'LineString':
                            if (callback(feature, featureIndex, multiFeatureIndex, 0, 0) === false) return false;
                            break;
                        case 'Polygon':
                            for (var geometryIndex = 0; geometryIndex < coords.length; geometryIndex++) {
                                if (callback(helpers.lineString(coords[geometryIndex], feature.properties), featureIndex, multiFeatureIndex, geometryIndex) === false) return false;
                            }
                            break;
                    }
                });
            }

            /**
             * Callback for lineReduce
             *
             * The first time the callback function is called, the values provided as arguments depend
             * on whether the reduce method has an initialValue argument.
             *
             * If an initialValue is provided to the reduce method:
             *  - The previousValue argument is initialValue.
             *  - The currentValue argument is the value of the first element present in the array.
             *
             * If an initialValue is not provided:
             *  - The previousValue argument is the value of the first element present in the array.
             *  - The currentValue argument is the value of the second element present in the array.
             *
             * @callback lineReduceCallback
             * @param {*} previousValue The accumulated value previously returned in the last invocation
             * of the callback, or initialValue, if supplied.
             * @param {Feature<LineString>} currentLine The current LineString|LinearRing being processed.
             * @param {number} featureIndex The current index of the Feature being processed
             * @param {number} multiFeatureIndex The current index of the Multi-Feature being processed
             * @param {number} geometryIndex The current index of the Geometry being processed
             */

            /**
             * Reduce features in any GeoJSON object, similar to Array.reduce().
             *
             * @name lineReduce
             * @param {Geometry|Feature<LineString|Polygon|MultiLineString|MultiPolygon>} geojson object
             * @param {Function} callback a method that takes (previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex)
             * @param {*} [initialValue] Value to use as the first argument to the first call of the callback.
             * @returns {*} The value that results from the reduction.
             * @example
             * var multiPoly = turf.multiPolygon([
             *   turf.polygon([[[12,48],[2,41],[24,38],[12,48]], [[9,44],[13,41],[13,45],[9,44]]]),
             *   turf.polygon([[[5, 5], [0, 0], [2, 2], [4, 4], [5, 5]]])
             * ]);
             *
             * turf.lineReduce(multiPoly, function (previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex) {
             *   //=previousValue
             *   //=currentLine
             *   //=featureIndex
             *   //=multiFeatureIndex
             *   //=geometryIndex
             *   return currentLine
             * });
             */
            function lineReduce(geojson, callback, initialValue) {
                var previousValue = initialValue;
                lineEach(geojson, function (currentLine, featureIndex, multiFeatureIndex, geometryIndex) {
                    if (featureIndex === 0 && initialValue === undefined) previousValue = currentLine;
                    else previousValue = callback(previousValue, currentLine, featureIndex, multiFeatureIndex, geometryIndex);
                });
                return previousValue;
            }

            /**
             * Finds a particular 2-vertex LineString Segment from a GeoJSON using `@turf/meta` indexes.
             *
             * Negative indexes are permitted.
             * Point & MultiPoint will always return null.
             *
             * @param {FeatureCollection|Feature|Geometry} geojson Any GeoJSON Feature or Geometry
             * @param {Object} [options={}] Optional parameters
             * @param {number} [options.featureIndex=0] Feature Index
             * @param {number} [options.multiFeatureIndex=0] Multi-Feature Index
             * @param {number} [options.geometryIndex=0] Geometry Index
             * @param {number} [options.segmentIndex=0] Segment Index
             * @param {Object} [options.properties={}] Translate Properties to output LineString
             * @param {BBox} [options.bbox={}] Translate BBox to output LineString
             * @param {number|string} [options.id={}] Translate Id to output LineString
             * @returns {Feature<LineString>} 2-vertex GeoJSON Feature LineString
             * @example
             * var multiLine = turf.multiLineString([
             *     [[10, 10], [50, 30], [30, 40]],
             *     [[-10, -10], [-50, -30], [-30, -40]]
             * ]);
             *
             * // First Segment (defaults are 0)
             * turf.findSegment(multiLine);
             * // => Feature<LineString<[[10, 10], [50, 30]]>>
             *
             * // First Segment of 2nd Multi Feature
             * turf.findSegment(multiLine, {multiFeatureIndex: 1});
             * // => Feature<LineString<[[-10, -10], [-50, -30]]>>
             *
             * // Last Segment of Last Multi Feature
             * turf.findSegment(multiLine, {multiFeatureIndex: -1, segmentIndex: -1});
             * // => Feature<LineString<[[-50, -30], [-30, -40]]>>
             */
            function findSegment(geojson, options) {
                // Optional Parameters
                options = options || {};
                if (!helpers.isObject(options)) throw new Error('options is invalid');
                var featureIndex = options.featureIndex || 0;
                var multiFeatureIndex = options.multiFeatureIndex || 0;
                var geometryIndex = options.geometryIndex || 0;
                var segmentIndex = options.segmentIndex || 0;

                // Find FeatureIndex
                var properties = options.properties;
                var geometry;

                switch (geojson.type) {
                    case 'FeatureCollection':
                        if (featureIndex < 0) featureIndex = geojson.features.length + featureIndex;
                        properties = properties || geojson.features[featureIndex].properties;
                        geometry = geojson.features[featureIndex].geometry;
                        break;
                    case 'Feature':
                        properties = properties || geojson.properties;
                        geometry = geojson.geometry;
                        break;
                    case 'Point':
                    case 'MultiPoint':
                        return null;
                    case 'LineString':
                    case 'Polygon':
                    case 'MultiLineString':
                    case 'MultiPolygon':
                        geometry = geojson;
                        break;
                    default:
                        throw new Error('geojson is invalid');
                }

                // Find SegmentIndex
                if (geometry === null) return null;
                var coords = geometry.coordinates;
                switch (geometry.type) {
                    case 'Point':
                    case 'MultiPoint':
                        return null;
                    case 'LineString':
                        if (segmentIndex < 0) segmentIndex = coords.length + segmentIndex - 1;
                        return helpers.lineString([coords[segmentIndex], coords[segmentIndex + 1]], properties, options);
                    case 'Polygon':
                        if (geometryIndex < 0) geometryIndex = coords.length + geometryIndex;
                        if (segmentIndex < 0) segmentIndex = coords[geometryIndex].length + segmentIndex - 1;
                        return helpers.lineString([coords[geometryIndex][segmentIndex], coords[geometryIndex][segmentIndex + 1]], properties, options);
                    case 'MultiLineString':
                        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
                        if (segmentIndex < 0) segmentIndex = coords[multiFeatureIndex].length + segmentIndex - 1;
                        return helpers.lineString([coords[multiFeatureIndex][segmentIndex], coords[multiFeatureIndex][segmentIndex + 1]], properties, options);
                    case 'MultiPolygon':
                        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
                        if (geometryIndex < 0) geometryIndex = coords[multiFeatureIndex].length + geometryIndex;
                        if (segmentIndex < 0) segmentIndex = coords[multiFeatureIndex][geometryIndex].length - segmentIndex - 1;
                        return helpers.lineString([coords[multiFeatureIndex][geometryIndex][segmentIndex], coords[multiFeatureIndex][geometryIndex][segmentIndex + 1]], properties, options);
                }
                throw new Error('geojson is invalid');
            }

            /**
             * Finds a particular Point from a GeoJSON using `@turf/meta` indexes.
             *
             * Negative indexes are permitted.
             *
             * @param {FeatureCollection|Feature|Geometry} geojson Any GeoJSON Feature or Geometry
             * @param {Object} [options={}] Optional parameters
             * @param {number} [options.featureIndex=0] Feature Index
             * @param {number} [options.multiFeatureIndex=0] Multi-Feature Index
             * @param {number} [options.geometryIndex=0] Geometry Index
             * @param {number} [options.coordIndex=0] Coord Index
             * @param {Object} [options.properties={}] Translate Properties to output Point
             * @param {BBox} [options.bbox={}] Translate BBox to output Point
             * @param {number|string} [options.id={}] Translate Id to output Point
             * @returns {Feature<Point>} 2-vertex GeoJSON Feature Point
             * @example
             * var multiLine = turf.multiLineString([
             *     [[10, 10], [50, 30], [30, 40]],
             *     [[-10, -10], [-50, -30], [-30, -40]]
             * ]);
             *
             * // First Segment (defaults are 0)
             * turf.findPoint(multiLine);
             * // => Feature<Point<[10, 10]>>
             *
             * // First Segment of the 2nd Multi-Feature
             * turf.findPoint(multiLine, {multiFeatureIndex: 1});
             * // => Feature<Point<[-10, -10]>>
             *
             * // Last Segment of last Multi-Feature
             * turf.findPoint(multiLine, {multiFeatureIndex: -1, coordIndex: -1});
             * // => Feature<Point<[-30, -40]>>
             */
            function findPoint(geojson, options) {
                // Optional Parameters
                options = options || {};
                if (!helpers.isObject(options)) throw new Error('options is invalid');
                var featureIndex = options.featureIndex || 0;
                var multiFeatureIndex = options.multiFeatureIndex || 0;
                var geometryIndex = options.geometryIndex || 0;
                var coordIndex = options.coordIndex || 0;

                // Find FeatureIndex
                var properties = options.properties;
                var geometry;

                switch (geojson.type) {
                    case 'FeatureCollection':
                        if (featureIndex < 0) featureIndex = geojson.features.length + featureIndex;
                        properties = properties || geojson.features[featureIndex].properties;
                        geometry = geojson.features[featureIndex].geometry;
                        break;
                    case 'Feature':
                        properties = properties || geojson.properties;
                        geometry = geojson.geometry;
                        break;
                    case 'Point':
                    case 'MultiPoint':
                        return null;
                    case 'LineString':
                    case 'Polygon':
                    case 'MultiLineString':
                    case 'MultiPolygon':
                        geometry = geojson;
                        break;
                    default:
                        throw new Error('geojson is invalid');
                }

                // Find Coord Index
                if (geometry === null) return null;
                var coords = geometry.coordinates;
                switch (geometry.type) {
                    case 'Point':
                        return helpers.point(coords, properties, options);
                    case 'MultiPoint':
                        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
                        return helpers.point(coords[multiFeatureIndex], properties, options);
                    case 'LineString':
                        if (coordIndex < 0) coordIndex = coords.length + coordIndex;
                        return helpers.point(coords[coordIndex], properties, options);
                    case 'Polygon':
                        if (geometryIndex < 0) geometryIndex = coords.length + geometryIndex;
                        if (coordIndex < 0) coordIndex = coords[geometryIndex].length + coordIndex;
                        return helpers.point(coords[geometryIndex][coordIndex], properties, options);
                    case 'MultiLineString':
                        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
                        if (coordIndex < 0) coordIndex = coords[multiFeatureIndex].length + coordIndex;
                        return helpers.point(coords[multiFeatureIndex][coordIndex], properties, options);
                    case 'MultiPolygon':
                        if (multiFeatureIndex < 0) multiFeatureIndex = coords.length + multiFeatureIndex;
                        if (geometryIndex < 0) geometryIndex = coords[multiFeatureIndex].length + geometryIndex;
                        if (coordIndex < 0) coordIndex = coords[multiFeatureIndex][geometryIndex].length - coordIndex;
                        return helpers.point(coords[multiFeatureIndex][geometryIndex][coordIndex], properties, options);
                }
                throw new Error('geojson is invalid');
            }

            exports.coordEach = coordEach;
            exports.coordReduce = coordReduce;
            exports.propEach = propEach;
            exports.propReduce = propReduce;
            exports.featureEach = featureEach;
            exports.featureReduce = featureReduce;
            exports.coordAll = coordAll;
            exports.geomEach = geomEach;
            exports.geomReduce = geomReduce;
            exports.flattenEach = flattenEach;
            exports.flattenReduce = flattenReduce;
            exports.segmentEach = segmentEach;
            exports.segmentReduce = segmentReduce;
            exports.lineEach = lineEach;
            exports.lineReduce = lineReduce;
            exports.findSegment = findSegment;
            exports.findPoint = findPoint;

        }, {"@turf/helpers": 68}],
        70: [function (_dereq_, module, exports) {

            module.exports = absolutize

            /**
             * redefine `path` with absolute coordinates
             *
             * @param {Array} path
             * @return {Array}
             */

            function absolutize(path) {
                var startX = 0
                var startY = 0
                var x = 0
                var y = 0

                return path.map(function (seg) {
                    seg = seg.slice()
                    var type = seg[0]
                    var command = type.toUpperCase()

                    // is relative
                    if (type != command) {
                        seg[0] = command
                        switch (type) {
                            case 'a':
                                seg[6] += x
                                seg[7] += y
                                break
                            case 'v':
                                seg[1] += y
                                break
                            case 'h':
                                seg[1] += x
                                break
                            default:
                                for (var i = 1; i < seg.length;) {
                                    seg[i++] += x
                                    seg[i++] += y
                                }
                        }
                    }

                    // update cursor state
                    switch (command) {
                        case 'Z':
                            x = startX
                            y = startY
                            break
                        case 'H':
                            x = seg[1]
                            break
                        case 'V':
                            y = seg[1]
                            break
                        case 'M':
                            x = startX = seg[1]
                            y = startY = seg[2]
                            break
                        default:
                            x = seg[seg.length - 2]
                            y = seg[seg.length - 1]
                    }

                    return seg
                })
            }

        }, {}],
        71: [function (_dereq_, module, exports) {
            'use strict'

            module.exports = normalize;

            function normalize(arr, dim) {
                if (!arr || arr.length == null) throw Error('Argument should be an array')

                if (dim == null) dim = 1
                else dim = Math.floor(dim)

                var bounds = Array(dim * 2)

                for (var offset = 0; offset < dim; offset++) {
                    var max = -Infinity, min = Infinity, i = offset,
                        l = arr.length;

                    for (; i < l; i += dim) {
                        if (arr[i] > max) max = arr[i];
                        if (arr[i] < min) min = arr[i];
                    }

                    bounds[offset] = min
                    bounds[dim + offset] = max
                }

                return bounds;
            }

        }, {}],
        72: [function (_dereq_, module, exports) {
            'use strict';
            module.exports = function (arr, predicate, ctx) {
                if (typeof Array.prototype.findIndex === 'function') {
                    return arr.findIndex(predicate, ctx);
                }

                if (typeof predicate !== 'function') {
                    throw new TypeError('predicate must be a function');
                }

                var list = Object(arr);
                var len = list.length;

                if (len === 0) {
                    return -1;
                }

                for (var i = 0; i < len; i++) {
                    if (predicate.call(ctx, list[i], i, list)) {
                        return i;
                    }
                }

                return -1;
            };

        }, {}],
        73: [function (_dereq_, module, exports) {
            'use strict'

            var getBounds = _dereq_('array-bounds')

            module.exports = normalize;

            function normalize(arr, dim, bounds) {
                if (!arr || arr.length == null) throw Error('Argument should be an array')

                if (dim == null) dim = 1
                if (bounds == null) bounds = getBounds(arr, dim)

                for (var offset = 0; offset < dim; offset++) {
                    var max = bounds[dim + offset], min = bounds[offset],
                        i = offset, l = arr.length;

                    if (max === Infinity && min === -Infinity) {
                        for (i = offset; i < l; i += dim) {
                            arr[i] = arr[i] === max ? 1 : arr[i] === min ? 0 : .5
                        }
                    } else if (max === Infinity) {
                        for (i = offset; i < l; i += dim) {
                            arr[i] = arr[i] === max ? 1 : 0
                        }
                    } else if (min === -Infinity) {
                        for (i = offset; i < l; i += dim) {
                            arr[i] = arr[i] === min ? 0 : 1
                        }
                    } else {
                        var range = max - min
                        for (i = offset; i < l; i += dim) {
                            if (!isNaN(arr[i])) {
                                arr[i] = range === 0 ? .5 : (arr[i] - min) / range
                            }
                        }
                    }
                }

                return arr;
            }

        }, {"array-bounds": 71}],
        74: [function (_dereq_, module, exports) {

            module.exports = function newArray(start, end) {
                var n0 = typeof start === 'number',
                    n1 = typeof end === 'number'

                if (n0 && !n1) {
                    end = start
                    start = 0
                } else if (!n0 && !n1) {
                    start = 0
                    end = 0
                }

                start = start | 0
                end = end | 0
                var len = end - start
                if (len < 0)
                    throw new Error('array length must be positive')

                var a = new Array(len)
                for (var i = 0, c = start; i < len; i++, c++)
                    a[i] = c
                return a
            }
        }, {}],
        75: [function (_dereq_, module, exports) {
            (function (global) {
                (function () {
                    'use strict';

                    var objectAssign = _dereq_('object-assign');

// compare and isBuffer taken from https://github.com/feross/buffer/blob/680e9e5e488f22aac27599a57dc844a6315928dd/index.js
// original notice:

                    /*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
 * @license  MIT
 */
                    function compare(a, b) {
                        if (a === b) {
                            return 0;
                        }

                        var x = a.length;
                        var y = b.length;

                        for (var i = 0, len = Math.min(x, y); i < len; ++i) {
                            if (a[i] !== b[i]) {
                                x = a[i];
                                y = b[i];
                                break;
                            }
                        }

                        if (x < y) {
                            return -1;
                        }
                        if (y < x) {
                            return 1;
                        }
                        return 0;
                    }

                    function isBuffer(b) {
                        if (global.Buffer && typeof global.Buffer.isBuffer === 'function') {
                            return global.Buffer.isBuffer(b);
                        }
                        return !!(b != null && b._isBuffer);
                    }

// based on node assert, original notice:
// NB: The URL to the CommonJS spec is kept just for tradition.
//     node-assert has evolved a lot since then, both in API and behavior.

// http://wiki.commonjs.org/wiki/Unit_Testing/1.0
//
// THIS IS NOT TESTED NOR LIKELY TO WORK OUTSIDE V8!
//
// Originally from narwhal.js (http://narwhaljs.org)
// Copyright (c) 2009 Thomas Robinson <280north.com>
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the 'Software'), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
// ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

                    var util = _dereq_('util/');
                    var hasOwn = Object.prototype.hasOwnProperty;
                    var pSlice = Array.prototype.slice;
                    var functionsHaveNames = (function () {
                        return function foo() {
                        }.name === 'foo';
                    }());

                    function pToString(obj) {
                        return Object.prototype.toString.call(obj);
                    }

                    function isView(arrbuf) {
                        if (isBuffer(arrbuf)) {
                            return false;
                        }
                        if (typeof global.ArrayBuffer !== 'function') {
                            return false;
                        }
                        if (typeof ArrayBuffer.isView === 'function') {
                            return ArrayBuffer.isView(arrbuf);
                        }
                        if (!arrbuf) {
                            return false;
                        }
                        if (arrbuf instanceof DataView) {
                            return true;
                        }
                        if (arrbuf.buffer && arrbuf.buffer instanceof ArrayBuffer) {
                            return true;
                        }
                        return false;
                    }

// 1. The assert module provides functions that throw
// AssertionError's when particular conditions are not met. The
// assert module must conform to the following interface.

                    var assert = module.exports = ok;

// 2. The AssertionError is defined in assert.
// new assert.AssertionError({ message: message,
//                             actual: actual,
//                             expected: expected })

                    var regex = /\s*function\s+([^\(\s]*)\s*/;

// based on https://github.com/ljharb/function.prototype.name/blob/adeeeec8bfcc6068b187d7d9fb3d5bb1d3a30899/implementation.js
                    function getName(func) {
                        if (!util.isFunction(func)) {
                            return;
                        }
                        if (functionsHaveNames) {
                            return func.name;
                        }
                        var str = func.toString();
                        var match = str.match(regex);
                        return match && match[1];
                    }

                    assert.AssertionError = function AssertionError(options) {
                        this.name = 'AssertionError';
                        this.actual = options.actual;
                        this.expected = options.expected;
                        this.operator = options.operator;
                        if (options.message) {
                            this.message = options.message;
                            this.generatedMessage = false;
                        } else {
                            this.message = getMessage(this);
                            this.generatedMessage = true;
                        }
                        var stackStartFunction = options.stackStartFunction || fail;
                        if (Error.captureStackTrace) {
                            Error.captureStackTrace(this, stackStartFunction);
                        } else {
                            // non v8 browsers so we can have a stacktrace
                            var err = new Error();
                            if (err.stack) {
                                var out = err.stack;

                                // try to strip useless frames
                                var fn_name = getName(stackStartFunction);
                                var idx = out.indexOf('\n' + fn_name);
                                if (idx >= 0) {
                                    // once we have located the function frame
                                    // we need to strip out everything before it (and its line)
                                    var next_line = out.indexOf('\n', idx + 1);
                                    out = out.substring(next_line + 1);
                                }

                                this.stack = out;
                            }
                        }
                    };

// assert.AssertionError instanceof Error
                    util.inherits(assert.AssertionError, Error);

                    function truncate(s, n) {
                        if (typeof s === 'string') {
                            return s.length < n ? s : s.slice(0, n);
                        } else {
                            return s;
                        }
                    }

                    function inspect(something) {
                        if (functionsHaveNames || !util.isFunction(something)) {
                            return util.inspect(something);
                        }
                        var rawname = getName(something);
                        var name = rawname ? ': ' + rawname : '';
                        return '[Function' + name + ']';
                    }

                    function getMessage(self) {
                        return truncate(inspect(self.actual), 128) + ' ' +
                            self.operator + ' ' +
                            truncate(inspect(self.expected), 128);
                    }

// At present only the three keys mentioned above are used and
// understood by the spec. Implementations or sub modules can pass
// other keys to the AssertionError's constructor - they will be
// ignored.

// 3. All of the following functions must throw an AssertionError
// when a corresponding condition is not met, with a message that
// may be undefined if not provided.  All assertion methods provide
// both the actual and expected values to the assertion error for
// display purposes.

                    function fail(actual, expected, message, operator, stackStartFunction) {
                        throw new assert.AssertionError({
                            message: message,
                            actual: actual,
                            expected: expected,
                            operator: operator,
                            stackStartFunction: stackStartFunction
                        });
                    }

// EXTENSION! allows for well behaved errors defined elsewhere.
                    assert.fail = fail;

// 4. Pure assertion tests whether a value is truthy, as determined
// by !!guard.
// assert.ok(guard, message_opt);
// This statement is equivalent to assert.equal(true, !!guard,
// message_opt);. To test strictly for the value true, use
// assert.strictEqual(true, guard, message_opt);.

                    function ok(value, message) {
                        if (!value) fail(value, true, message, '==', assert.ok);
                    }

                    assert.ok = ok;

// 5. The equality assertion tests shallow, coercive equality with
// ==.
// assert.equal(actual, expected, message_opt);

                    assert.equal = function equal(actual, expected, message) {
                        if (actual != expected) fail(actual, expected, message, '==', assert.equal);
                    };

// 6. The non-equality assertion tests for whether two objects are not equal
// with != assert.notEqual(actual, expected, message_opt);

                    assert.notEqual = function notEqual(actual, expected, message) {
                        if (actual == expected) {
                            fail(actual, expected, message, '!=', assert.notEqual);
                        }
                    };

// 7. The equivalence assertion tests a deep equality relation.
// assert.deepEqual(actual, expected, message_opt);

                    assert.deepEqual = function deepEqual(actual, expected, message) {
                        if (!_deepEqual(actual, expected, false)) {
                            fail(actual, expected, message, 'deepEqual', assert.deepEqual);
                        }
                    };

                    assert.deepStrictEqual = function deepStrictEqual(actual, expected, message) {
                        if (!_deepEqual(actual, expected, true)) {
                            fail(actual, expected, message, 'deepStrictEqual', assert.deepStrictEqual);
                        }
                    };

                    function _deepEqual(actual, expected, strict, memos) {
                        // 7.1. All identical values are equivalent, as determined by ===.
                        if (actual === expected) {
                            return true;
                        } else if (isBuffer(actual) && isBuffer(expected)) {
                            return compare(actual, expected) === 0;

                            // 7.2. If the expected value is a Date object, the actual value is
                            // equivalent if it is also a Date object that refers to the same time.
                        } else if (util.isDate(actual) && util.isDate(expected)) {
                            return actual.getTime() === expected.getTime();

                            // 7.3 If the expected value is a RegExp object, the actual value is
                            // equivalent if it is also a RegExp object with the same source and
                            // properties (`global`, `multiline`, `lastIndex`, `ignoreCase`).
                        } else if (util.isRegExp(actual) && util.isRegExp(expected)) {
                            return actual.source === expected.source &&
                                actual.global === expected.global &&
                                actual.multiline === expected.multiline &&
                                actual.lastIndex === expected.lastIndex &&
                                actual.ignoreCase === expected.ignoreCase;

                            // 7.4. Other pairs that do not both pass typeof value == 'object',
                            // equivalence is determined by ==.
                        } else if ((actual === null || typeof actual !== 'object') &&
                            (expected === null || typeof expected !== 'object')) {
                            return strict ? actual === expected : actual == expected;

                            // If both values are instances of typed arrays, wrap their underlying
                            // ArrayBuffers in a Buffer each to increase performance
                            // This optimization requires the arrays to have the same type as checked by
                            // Object.prototype.toString (aka pToString). Never perform binary
                            // comparisons for Float*Arrays, though, since e.g. +0 === -0 but their
                            // bit patterns are not identical.
                        } else if (isView(actual) && isView(expected) &&
                            pToString(actual) === pToString(expected) &&
                            !(actual instanceof Float32Array ||
                                actual instanceof Float64Array)) {
                            return compare(new Uint8Array(actual.buffer),
                                new Uint8Array(expected.buffer)) === 0;

                            // 7.5 For all other Object pairs, including Array objects, equivalence is
                            // determined by having the same number of owned properties (as verified
                            // with Object.prototype.hasOwnProperty.call), the same set of keys
                            // (although not necessarily the same order), equivalent values for every
                            // corresponding key, and an identical 'prototype' property. Note: this
                            // accounts for both named and indexed properties on Arrays.
                        } else if (isBuffer(actual) !== isBuffer(expected)) {
                            return false;
                        } else {
                            memos = memos || {actual: [], expected: []};

                            var actualIndex = memos.actual.indexOf(actual);
                            if (actualIndex !== -1) {
                                if (actualIndex === memos.expected.indexOf(expected)) {
                                    return true;
                                }
                            }

                            memos.actual.push(actual);
                            memos.expected.push(expected);

                            return objEquiv(actual, expected, strict, memos);
                        }
                    }

                    function isArguments(object) {
                        return Object.prototype.toString.call(object) == '[object Arguments]';
                    }

                    function objEquiv(a, b, strict, actualVisitedObjects) {
                        if (a === null || a === undefined || b === null || b === undefined)
                            return false;
                        // if one is a primitive, the other must be same
                        if (util.isPrimitive(a) || util.isPrimitive(b))
                            return a === b;
                        if (strict && Object.getPrototypeOf(a) !== Object.getPrototypeOf(b))
                            return false;
                        var aIsArgs = isArguments(a);
                        var bIsArgs = isArguments(b);
                        if ((aIsArgs && !bIsArgs) || (!aIsArgs && bIsArgs))
                            return false;
                        if (aIsArgs) {
                            a = pSlice.call(a);
                            b = pSlice.call(b);
                            return _deepEqual(a, b, strict);
                        }
                        var ka = objectKeys(a);
                        var kb = objectKeys(b);
                        var key, i;
                        // having the same number of owned properties (keys incorporates
                        // hasOwnProperty)
                        if (ka.length !== kb.length)
                            return false;
                        //the same set of keys (although not necessarily the same order),
                        ka.sort();
                        kb.sort();
                        //~~~cheap key test
                        for (i = ka.length - 1; i >= 0; i--) {
                            if (ka[i] !== kb[i])
                                return false;
                        }
                        //equivalent values for every corresponding key, and
                        //~~~possibly expensive deep test
                        for (i = ka.length - 1; i >= 0; i--) {
                            key = ka[i];
                            if (!_deepEqual(a[key], b[key], strict, actualVisitedObjects))
                                return false;
                        }
                        return true;
                    }

// 8. The non-equivalence assertion tests for any deep inequality.
// assert.notDeepEqual(actual, expected, message_opt);

                    assert.notDeepEqual = function notDeepEqual(actual, expected, message) {
                        if (_deepEqual(actual, expected, false)) {
                            fail(actual, expected, message, 'notDeepEqual', assert.notDeepEqual);
                        }
                    };

                    assert.notDeepStrictEqual = notDeepStrictEqual;

                    function notDeepStrictEqual(actual, expected, message) {
                        if (_deepEqual(actual, expected, true)) {
                            fail(actual, expected, message, 'notDeepStrictEqual', notDeepStrictEqual);
                        }
                    }


// 9. The strict equality assertion tests strict equality, as determined by ===.
// assert.strictEqual(actual, expected, message_opt);

                    assert.strictEqual = function strictEqual(actual, expected, message) {
                        if (actual !== expected) {
                            fail(actual, expected, message, '===', assert.strictEqual);
                        }
                    };

// 10. The strict non-equality assertion tests for strict inequality, as
// determined by !==.  assert.notStrictEqual(actual, expected, message_opt);

                    assert.notStrictEqual = function notStrictEqual(actual, expected, message) {
                        if (actual === expected) {
                            fail(actual, expected, message, '!==', assert.notStrictEqual);
                        }
                    };

                    function expectedException(actual, expected) {
                        if (!actual || !expected) {
                            return false;
                        }

                        if (Object.prototype.toString.call(expected) == '[object RegExp]') {
                            return expected.test(actual);
                        }

                        try {
                            if (actual instanceof expected) {
                                return true;
                            }
                        } catch (e) {
                            // Ignore.  The instanceof check doesn't work for arrow functions.
                        }

                        if (Error.isPrototypeOf(expected)) {
                            return false;
                        }

                        return expected.call({}, actual) === true;
                    }

                    function _tryBlock(block) {
                        var error;
                        try {
                            block();
                        } catch (e) {
                            error = e;
                        }
                        return error;
                    }

                    function _throws(shouldThrow, block, expected, message) {
                        var actual;

                        if (typeof block !== 'function') {
                            throw new TypeError('"block" argument must be a function');
                        }

                        if (typeof expected === 'string') {
                            message = expected;
                            expected = null;
                        }

                        actual = _tryBlock(block);

                        message = (expected && expected.name ? ' (' + expected.name + ').' : '.') +
                            (message ? ' ' + message : '.');

                        if (shouldThrow && !actual) {
                            fail(actual, expected, 'Missing expected exception' + message);
                        }

                        var userProvidedMessage = typeof message === 'string';
                        var isUnwantedException = !shouldThrow && util.isError(actual);
                        var isUnexpectedException = !shouldThrow && actual && !expected;

                        if ((isUnwantedException &&
                                userProvidedMessage &&
                                expectedException(actual, expected)) ||
                            isUnexpectedException) {
                            fail(actual, expected, 'Got unwanted exception' + message);
                        }

                        if ((shouldThrow && actual && expected &&
                            !expectedException(actual, expected)) || (!shouldThrow && actual)) {
                            throw actual;
                        }
                    }

// 11. Expected to throw an error:
// assert.throws(block, Error_opt, message_opt);

                    assert.throws = function (block, /*optional*/error, /*optional*/message) {
                        _throws(true, block, error, message);
                    };

// EXTENSION! This is annoying to write outside this module.
                    assert.doesNotThrow = function (block, /*optional*/error, /*optional*/message) {
                        _throws(false, block, error, message);
                    };

                    assert.ifError = function (err) {
                        if (err) throw err;
                    };

// Expose a strict only variant of assert
                    function strict(value, message) {
                        if (!value) fail(value, true, message, '==', strict);
                    }

                    assert.strict = objectAssign(strict, assert, {
                        equal: assert.strictEqual,
                        deepEqual: assert.deepStrictEqual,
                        notEqual: assert.notStrictEqual,
                        notDeepEqual: assert.notDeepStrictEqual
                    });
                    assert.strict.strict = assert.strict;

                    var objectKeys = Object.keys || function (obj) {
                        var keys = [];
                        for (var key in obj) {
                            if (hasOwn.call(obj, key)) keys.push(key);
                        }
                        return keys;
                    };

                }).call(this)
            }).call(this, typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
        }, {"object-assign": 247, "util/": 78}],
        76: [function (_dereq_, module, exports) {
            if (typeof Object.create === 'function') {
                // implementation from standard node.js 'util' module
                module.exports = function inherits(ctor, superCtor) {
                    ctor.super_ = superCtor
                    ctor.prototype = Object.create(superCtor.prototype, {
                        constructor: {
                            value: ctor,
                            enumerable: false,
                            writable: true,
                            configurable: true
                        }
                    });
                };
            } else {
                // old school shim for old browsers
                module.exports = function inherits(ctor, superCtor) {
                    ctor.super_ = superCtor
                    var TempCtor = function () {
                    }
                    TempCtor.prototype = superCtor.prototype
                    ctor.prototype = new TempCtor()
                    ctor.prototype.constructor = ctor
                }
            }

        }, {}],
        77: [function (_dereq_, module, exports) {
            module.exports = function isBuffer(arg) {
                return arg && typeof arg === 'object'
                    && typeof arg.copy === 'function'
                    && typeof arg.fill === 'function'
                    && typeof arg.readUInt8 === 'function';
            }
        }, {}],
        78: [function (_dereq_, module, exports) {
            (function (process, global) {
                (function () {
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

                    var formatRegExp = /%[sdj%]/g;
                    exports.format = function (f) {
                        if (!isString(f)) {
                            var objects = [];
                            for (var i = 0; i < arguments.length; i++) {
                                objects.push(inspect(arguments[i]));
                            }
                            return objects.join(' ');
                        }

                        var i = 1;
                        var args = arguments;
                        var len = args.length;
                        var str = String(f).replace(formatRegExp, function (x) {
                            if (x === '%%') return '%';
                            if (i >= len) return x;
                            switch (x) {
                                case '%s':
                                    return String(args[i++]);
                                case '%d':
                                    return Number(args[i++]);
                                case '%j':
                                    try {
                                        return JSON.stringify(args[i++]);
                                    } catch (_) {
                                        return '[Circular]';
                                    }
                                default:
                                    return x;
                            }
                        });
                        for (var x = args[i]; i < len; x = args[++i]) {
                            if (isNull(x) || !isObject(x)) {
                                str += ' ' + x;
                            } else {
                                str += ' ' + inspect(x);
                            }
                        }
                        return str;
                    };


// Mark that a method should not be used.
// Returns a modified function which warns once by default.
// If --no-deprecation is set, then it is a no-op.
                    exports.deprecate = function (fn, msg) {
                        // Allow for deprecating things in the process of starting up.
                        if (isUndefined(global.process)) {
                            return function () {
                                return exports.deprecate(fn, msg).apply(this, arguments);
                            };
                        }

                        if (process.noDeprecation === true) {
                            return fn;
                        }

                        var warned = false;

                        function deprecated() {
                            if (!warned) {
                                if (process.throwDeprecation) {
                                    throw new Error(msg);
                                } else if (process.traceDeprecation) {
                                    console.trace(msg);
                                } else {
                                    console.error(msg);
                                }
                                warned = true;
                            }
                            return fn.apply(this, arguments);
                        }

                        return deprecated;
                    };


                    var debugs = {};
                    var debugEnviron;
                    exports.debuglog = function (set) {
                        if (isUndefined(debugEnviron))
                            debugEnviron = process.env.NODE_DEBUG || '';
                        set = set.toUpperCase();
                        if (!debugs[set]) {
                            if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
                                var pid = process.pid;
                                debugs[set] = function () {
                                    var msg = exports.format.apply(exports, arguments);
                                    console.error('%s %d: %s', set, pid, msg);
                                };
                            } else {
                                debugs[set] = function () {
                                };
                            }
                        }
                        return debugs[set];
                    };


                    /**
                     * Echos the value of a value. Trys to print the value out
                     * in the best way possible given the different types.
                     *
                     * @param {Object} obj The object to print out.
                     * @param {Object} opts Optional options object that alters the output.
                     */

                    /* legacy: obj, showHidden, depth, colors*/
                    function inspect(obj, opts) {
                        // default options
                        var ctx = {
                            seen: [],
                            stylize: stylizeNoColor
                        };
                        // legacy...
                        if (arguments.length >= 3) ctx.depth = arguments[2];
                        if (arguments.length >= 4) ctx.colors = arguments[3];
                        if (isBoolean(opts)) {
                            // legacy...
                            ctx.showHidden = opts;
                        } else if (opts) {
                            // got an "options" object
                            exports._extend(ctx, opts);
                        }
                        // set default options
                        if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
                        if (isUndefined(ctx.depth)) ctx.depth = 2;
                        if (isUndefined(ctx.colors)) ctx.colors = false;
                        if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
                        if (ctx.colors) ctx.stylize = stylizeWithColor;
                        return formatValue(ctx, obj, ctx.depth);
                    }

                    exports.inspect = inspect;


// http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
                    inspect.colors = {
                        'bold': [1, 22],
                        'italic': [3, 23],
                        'underline': [4, 24],
                        'inverse': [7, 27],
                        'white': [37, 39],
                        'grey': [90, 39],
                        'black': [30, 39],
                        'blue': [34, 39],
                        'cyan': [36, 39],
                        'green': [32, 39],
                        'magenta': [35, 39],
                        'red': [31, 39],
                        'yellow': [33, 39]
                    };

// Don't use 'blue' not visible on cmd.exe
                    inspect.styles = {
                        'special': 'cyan',
                        'number': 'yellow',
                        'boolean': 'yellow',
                        'undefined': 'grey',
                        'null': 'bold',
                        'string': 'green',
                        'date': 'magenta',
                        // "name": intentionally not styling
                        'regexp': 'red'
                    };


                    function stylizeWithColor(str, styleType) {
                        var style = inspect.styles[styleType];

                        if (style) {
                            return '\u001b[' + inspect.colors[style][0] + 'm' + str +
                                '\u001b[' + inspect.colors[style][1] + 'm';
                        } else {
                            return str;
                        }
                    }


                    function stylizeNoColor(str, styleType) {
                        return str;
                    }


                    function arrayToHash(array) {
                        var hash = {};

                        array.forEach(function (val, idx) {
                            hash[val] = true;
                        });

                        return hash;
                    }


                    function formatValue(ctx, value, recurseTimes) {
                        // Provide a hook for user-specified inspect functions.
                        // Check that value is an object with an inspect function on it
                        if (ctx.customInspect &&
                            value &&
                            isFunction(value.inspect) &&
                            // Filter out the util module, it's inspect function is special
                            value.inspect !== exports.inspect &&
                            // Also filter out any prototype objects using the circular check.
                            !(value.constructor && value.constructor.prototype === value)) {
                            var ret = value.inspect(recurseTimes, ctx);
                            if (!isString(ret)) {
                                ret = formatValue(ctx, ret, recurseTimes);
                            }
                            return ret;
                        }

                        // Primitive types cannot have properties
                        var primitive = formatPrimitive(ctx, value);
                        if (primitive) {
                            return primitive;
                        }

                        // Look up the keys of the object.
                        var keys = Object.keys(value);
                        var visibleKeys = arrayToHash(keys);

                        if (ctx.showHidden) {
                            keys = Object.getOwnPropertyNames(value);
                        }

                        // IE doesn't make error fields non-enumerable
                        // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
                        if (isError(value)
                            && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
                            return formatError(value);
                        }

                        // Some type of object without properties can be shortcutted.
                        if (keys.length === 0) {
                            if (isFunction(value)) {
                                var name = value.name ? ': ' + value.name : '';
                                return ctx.stylize('[Function' + name + ']', 'special');
                            }
                            if (isRegExp(value)) {
                                return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
                            }
                            if (isDate(value)) {
                                return ctx.stylize(Date.prototype.toString.call(value), 'date');
                            }
                            if (isError(value)) {
                                return formatError(value);
                            }
                        }

                        var base = '', array = false, braces = ['{', '}'];

                        // Make Array say that they are Array
                        if (isArray(value)) {
                            array = true;
                            braces = ['[', ']'];
                        }

                        // Make functions say that they are functions
                        if (isFunction(value)) {
                            var n = value.name ? ': ' + value.name : '';
                            base = ' [Function' + n + ']';
                        }

                        // Make RegExps say that they are RegExps
                        if (isRegExp(value)) {
                            base = ' ' + RegExp.prototype.toString.call(value);
                        }

                        // Make dates with properties first say the date
                        if (isDate(value)) {
                            base = ' ' + Date.prototype.toUTCString.call(value);
                        }

                        // Make error with message first say the error
                        if (isError(value)) {
                            base = ' ' + formatError(value);
                        }

                        if (keys.length === 0 && (!array || value.length == 0)) {
                            return braces[0] + base + braces[1];
                        }

                        if (recurseTimes < 0) {
                            if (isRegExp(value)) {
                                return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
                            } else {
                                return ctx.stylize('[Object]', 'special');
                            }
                        }

                        ctx.seen.push(value);

                        var output;
                        if (array) {
                            output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
                        } else {
                            output = keys.map(function (key) {
                                return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
                            });
                        }

                        ctx.seen.pop();

                        return reduceToSingleString(output, base, braces);
                    }


                    function formatPrimitive(ctx, value) {
                        if (isUndefined(value))
                            return ctx.stylize('undefined', 'undefined');
                        if (isString(value)) {
                            var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                .replace(/'/g, "\\'")
                                .replace(/\\"/g, '"') + '\'';
                            return ctx.stylize(simple, 'string');
                        }
                        if (isNumber(value))
                            return ctx.stylize('' + value, 'number');
                        if (isBoolean(value))
                            return ctx.stylize('' + value, 'boolean');
                        // For some reason typeof null is "object", so special case here.
                        if (isNull(value))
                            return ctx.stylize('null', 'null');
                    }


                    function formatError(value) {
                        return '[' + Error.prototype.toString.call(value) + ']';
                    }


                    function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
                        var output = [];
                        for (var i = 0, l = value.length; i < l; ++i) {
                            if (hasOwnProperty(value, String(i))) {
                                output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
                                    String(i), true));
                            } else {
                                output.push('');
                            }
                        }
                        keys.forEach(function (key) {
                            if (!key.match(/^\d+$/)) {
                                output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
                                    key, true));
                            }
                        });
                        return output;
                    }


                    function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
                        var name, str, desc;
                        desc = Object.getOwnPropertyDescriptor(value, key) || {value: value[key]};
                        if (desc.get) {
                            if (desc.set) {
                                str = ctx.stylize('[Getter/Setter]', 'special');
                            } else {
                                str = ctx.stylize('[Getter]', 'special');
                            }
                        } else {
                            if (desc.set) {
                                str = ctx.stylize('[Setter]', 'special');
                            }
                        }
                        if (!hasOwnProperty(visibleKeys, key)) {
                            name = '[' + key + ']';
                        }
                        if (!str) {
                            if (ctx.seen.indexOf(desc.value) < 0) {
                                if (isNull(recurseTimes)) {
                                    str = formatValue(ctx, desc.value, null);
                                } else {
                                    str = formatValue(ctx, desc.value, recurseTimes - 1);
                                }
                                if (str.indexOf('\n') > -1) {
                                    if (array) {
                                        str = str.split('\n').map(function (line) {
                                            return '  ' + line;
                                        }).join('\n').substr(2);
                                    } else {
                                        str = '\n' + str.split('\n').map(function (line) {
                                            return '   ' + line;
                                        }).join('\n');
                                    }
                                }
                            } else {
                                str = ctx.stylize('[Circular]', 'special');
                            }
                        }
                        if (isUndefined(name)) {
                            if (array && key.match(/^\d+$/)) {
                                return str;
                            }
                            name = JSON.stringify('' + key);
                            if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
                                name = name.substr(1, name.length - 2);
                                name = ctx.stylize(name, 'name');
                            } else {
                                name = name.replace(/'/g, "\\'")
                                    .replace(/\\"/g, '"')
                                    .replace(/(^"|"$)/g, "'");
                                name = ctx.stylize(name, 'string');
                            }
                        }

                        return name + ': ' + str;
                    }


                    function reduceToSingleString(output, base, braces) {
                        var numLinesEst = 0;
                        var length = output.reduce(function (prev, cur) {
                            numLinesEst++;
                            if (cur.indexOf('\n') >= 0) numLinesEst++;
                            return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
                        }, 0);

                        if (length > 60) {
                            return braces[0] +
                                (base === '' ? '' : base + '\n ') +
                                ' ' +
                                output.join(',\n  ') +
                                ' ' +
                                braces[1];
                        }

                        return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
                    }


// NOTE: These type checking functions intentionally don't use `instanceof`
// because it is fragile and can be easily faked with `Object.create()`.
                    function isArray(ar) {
                        return Array.isArray(ar);
                    }

                    exports.isArray = isArray;

                    function isBoolean(arg) {
                        return typeof arg === 'boolean';
                    }

                    exports.isBoolean = isBoolean;

                    function isNull(arg) {
                        return arg === null;
                    }

                    exports.isNull = isNull;

                    function isNullOrUndefined(arg) {
                        return arg == null;
                    }

                    exports.isNullOrUndefined = isNullOrUndefined;

                    function isNumber(arg) {
                        return typeof arg === 'number';
                    }

                    exports.isNumber = isNumber;

                    function isString(arg) {
                        return typeof arg === 'string';
                    }

                    exports.isString = isString;

                    function isSymbol(arg) {
                        return typeof arg === 'symbol';
                    }

                    exports.isSymbol = isSymbol;

                    function isUndefined(arg) {
                        return arg === void 0;
                    }

                    exports.isUndefined = isUndefined;

                    function isRegExp(re) {
                        return isObject(re) && objectToString(re) === '[object RegExp]';
                    }

                    exports.isRegExp = isRegExp;

                    function isObject(arg) {
                        return typeof arg === 'object' && arg !== null;
                    }

                    exports.isObject = isObject;

                    function isDate(d) {
                        return isObject(d) && objectToString(d) === '[object Date]';
                    }

                    exports.isDate = isDate;

                    function isError(e) {
                        return isObject(e) &&
                            (objectToString(e) === '[object Error]' || e instanceof Error);
                    }

                    exports.isError = isError;

                    function isFunction(arg) {
                        return typeof arg === 'function';
                    }

                    exports.isFunction = isFunction;

                    function isPrimitive(arg) {
                        return arg === null ||
                            typeof arg === 'boolean' ||
                            typeof arg === 'number' ||
                            typeof arg === 'string' ||
                            typeof arg === 'symbol' ||  // ES6 symbol
                            typeof arg === 'undefined';
                    }

                    exports.isPrimitive = isPrimitive;

                    exports.isBuffer = _dereq_('./support/isBuffer');

                    function objectToString(o) {
                        return Object.prototype.toString.call(o);
                    }


                    function pad(n) {
                        return n < 10 ? '0' + n.toString(10) : n.toString(10);
                    }


                    var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
                        'Oct', 'Nov', 'Dec'];

// 26 Feb 16:19:34
                    function timestamp() {
                        var d = new Date();
                        var time = [pad(d.getHours()),
                            pad(d.getMinutes()),
                            pad(d.getSeconds())].join(':');
                        return [d.getDate(), months[d.getMonth()], time].join(' ');
                    }


// log is just a thin wrapper to console.log that prepends a timestamp
                    exports.log = function () {
                        console.log('%s - %s', timestamp(), exports.format.apply(exports, arguments));
                    };


                    /**
                     * Inherit the prototype methods from one constructor into another.
                     *
                     * The Function.prototype.inherits from lang.js rewritten as a standalone
                     * function (not on Function.prototype). NOTE: If this file is to be loaded
                     * during bootstrapping this function needs to be rewritten using some native
                     * functions as prototype setup using normal JavaScript does not work as
                     * expected during bootstrapping (see mirror.js in r114903).
                     *
                     * @param {function} ctor Constructor function which needs to inherit the
                     *     prototype.
                     * @param {function} superCtor Constructor function to inherit prototype from.
                     */
                    exports.inherits = _dereq_('inherits');

                    exports._extend = function (origin, add) {
                        // Don't do anything if add isn't an object
                        if (!add || !isObject(add)) return origin;

                        var keys = Object.keys(add);
                        var i = keys.length;
                        while (i--) {
                            origin[keys[i]] = add[keys[i]];
                        }
                        return origin;
                    };

                    function hasOwnProperty(obj, prop) {
                        return Object.prototype.hasOwnProperty.call(obj, prop);
                    }

                }).call(this)
            }).call(this, _dereq_('_process'), typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
        }, {"./support/isBuffer": 77, "_process": 277, "inherits": 76}],
        79: [function (_dereq_, module, exports) {
            'use strict'

            exports.byteLength = byteLength
            exports.toByteArray = toByteArray
            exports.fromByteArray = fromByteArray

            var lookup = []
            var revLookup = []
            var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

            var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
            for (var i = 0, len = code.length; i < len; ++i) {
                lookup[i] = code[i]
                revLookup[code.charCodeAt(i)] = i
            }

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
            revLookup['-'.charCodeAt(0)] = 62
            revLookup['_'.charCodeAt(0)] = 63

            function getLens(b64) {
                var len = b64.length

                if (len % 4 > 0) {
                    throw new Error('Invalid string. Length must be a multiple of 4')
                }

                // Trim off extra bytes after placeholder bytes are found
                // See: https://github.com/beatgammit/base64-js/issues/42
                var validLen = b64.indexOf('=')
                if (validLen === -1) validLen = len

                var placeHoldersLen = validLen === len
                    ? 0
                    : 4 - (validLen % 4)

                return [validLen, placeHoldersLen]
            }

// base64 is 4/3 + up to two characters of the original data
            function byteLength(b64) {
                var lens = getLens(b64)
                var validLen = lens[0]
                var placeHoldersLen = lens[1]
                return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
            }

            function _byteLength(b64, validLen, placeHoldersLen) {
                return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
            }

            function toByteArray(b64) {
                var tmp
                var lens = getLens(b64)
                var validLen = lens[0]
                var placeHoldersLen = lens[1]

                var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

                var curByte = 0

                // if there are placeholders, only get up to the last complete 4 chars
                var len = placeHoldersLen > 0
                    ? validLen - 4
                    : validLen

                var i
                for (i = 0; i < len; i += 4) {
                    tmp =
                        (revLookup[b64.charCodeAt(i)] << 18) |
                        (revLookup[b64.charCodeAt(i + 1)] << 12) |
                        (revLookup[b64.charCodeAt(i + 2)] << 6) |
                        revLookup[b64.charCodeAt(i + 3)]
                    arr[curByte++] = (tmp >> 16) & 0xFF
                    arr[curByte++] = (tmp >> 8) & 0xFF
                    arr[curByte++] = tmp & 0xFF
                }

                if (placeHoldersLen === 2) {
                    tmp =
                        (revLookup[b64.charCodeAt(i)] << 2) |
                        (revLookup[b64.charCodeAt(i + 1)] >> 4)
                    arr[curByte++] = tmp & 0xFF
                }

                if (placeHoldersLen === 1) {
                    tmp =
                        (revLookup[b64.charCodeAt(i)] << 10) |
                        (revLookup[b64.charCodeAt(i + 1)] << 4) |
                        (revLookup[b64.charCodeAt(i + 2)] >> 2)
                    arr[curByte++] = (tmp >> 8) & 0xFF
                    arr[curByte++] = tmp & 0xFF
                }

                return arr
            }

            function tripletToBase64(num) {
                return lookup[num >> 18 & 0x3F] +
                    lookup[num >> 12 & 0x3F] +
                    lookup[num >> 6 & 0x3F] +
                    lookup[num & 0x3F]
            }

            function encodeChunk(uint8, start, end) {
                var tmp
                var output = []
                for (var i = start; i < end; i += 3) {
                    tmp =
                        ((uint8[i] << 16) & 0xFF0000) +
                        ((uint8[i + 1] << 8) & 0xFF00) +
                        (uint8[i + 2] & 0xFF)
                    output.push(tripletToBase64(tmp))
                }
                return output.join('')
            }

            function fromByteArray(uint8) {
                var tmp
                var len = uint8.length
                var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
                var parts = []
                var maxChunkLength = 16383 // must be multiple of 3

                // go through the array every three bytes, we'll deal with trailing stuff later
                for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
                    parts.push(encodeChunk(
                        uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)
                    ))
                }

                // pad the end with zeros, but make sure to not forget the extra bytes
                if (extraBytes === 1) {
                    tmp = uint8[len - 1]
                    parts.push(
                        lookup[tmp >> 2] +
                        lookup[(tmp << 4) & 0x3F] +
                        '=='
                    )
                } else if (extraBytes === 2) {
                    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
                    parts.push(
                        lookup[tmp >> 10] +
                        lookup[(tmp >> 4) & 0x3F] +
                        lookup[(tmp << 2) & 0x3F] +
                        '='
                    )
                }

                return parts.join('')
            }

        }, {}],
        80: [function (_dereq_, module, exports) {
            "use strict"

// (a, y, c, l, h) = (array, y[, cmp, lo, hi])

            function ge(a, y, c, l, h) {
                var i = h + 1;
                while (l <= h) {
                    var m = (l + h) >>> 1, x = a[m];
                    var p = (c !== undefined) ? c(x, y) : (x - y);
                    if (p >= 0) {
                        i = m;
                        h = m - 1
                    } else {
                        l = m + 1
                    }
                }
                return i;
            };

            function gt(a, y, c, l, h) {
                var i = h + 1;
                while (l <= h) {
                    var m = (l + h) >>> 1, x = a[m];
                    var p = (c !== undefined) ? c(x, y) : (x - y);
                    if (p > 0) {
                        i = m;
                        h = m - 1
                    } else {
                        l = m + 1
                    }
                }
                return i;
            };

            function lt(a, y, c, l, h) {
                var i = l - 1;
                while (l <= h) {
                    var m = (l + h) >>> 1, x = a[m];
                    var p = (c !== undefined) ? c(x, y) : (x - y);
                    if (p < 0) {
                        i = m;
                        l = m + 1
                    } else {
                        h = m - 1
                    }
                }
                return i;
            };

            function le(a, y, c, l, h) {
                var i = l - 1;
                while (l <= h) {
                    var m = (l + h) >>> 1, x = a[m];
                    var p = (c !== undefined) ? c(x, y) : (x - y);
                    if (p <= 0) {
                        i = m;
                        l = m + 1
                    } else {
                        h = m - 1
                    }
                }
                return i;
            };

            function eq(a, y, c, l, h) {
                while (l <= h) {
                    var m = (l + h) >>> 1, x = a[m];
                    var p = (c !== undefined) ? c(x, y) : (x - y);
                    if (p === 0) {
                        return m
                    }
                    if (p <= 0) {
                        l = m + 1
                    } else {
                        h = m - 1
                    }
                }
                return -1;
            };

            function norm(a, y, c, l, h, f) {
                if (typeof c === 'function') {
                    return f(a, y, c, (l === undefined) ? 0 : l | 0, (h === undefined) ? a.length - 1 : h | 0);
                }
                return f(a, y, undefined, (c === undefined) ? 0 : c | 0, (l === undefined) ? a.length - 1 : l | 0);
            }

            module.exports = {
                ge: function (a, y, c, l, h) {
                    return norm(a, y, c, l, h, ge)
                },
                gt: function (a, y, c, l, h) {
                    return norm(a, y, c, l, h, gt)
                },
                lt: function (a, y, c, l, h) {
                    return norm(a, y, c, l, h, lt)
                },
                le: function (a, y, c, l, h) {
                    return norm(a, y, c, l, h, le)
                },
                eq: function (a, y, c, l, h) {
                    return norm(a, y, c, l, h, eq)
                }
            }

        }, {}],
        81: [function (_dereq_, module, exports) {
            /**
             * Bit twiddling hacks for JavaScript.
             *
             * Author: Mikola Lysenko
             *
             * Ported from Stanford bit twiddling hack library:
             *    http://graphics.stanford.edu/~seander/bithacks.html
             */

            "use strict";
            "use restrict";

//Number of bits in an integer
            var INT_BITS = 32;

//Constants
            exports.INT_BITS = INT_BITS;
            exports.INT_MAX = 0x7fffffff;
            exports.INT_MIN = -1 << (INT_BITS - 1);

//Returns -1, 0, +1 depending on sign of x
            exports.sign = function (v) {
                return (v > 0) - (v < 0);
            }

//Computes absolute value of integer
            exports.abs = function (v) {
                var mask = v >> (INT_BITS - 1);
                return (v ^ mask) - mask;
            }

//Computes minimum of integers x and y
            exports.min = function (x, y) {
                return y ^ ((x ^ y) & -(x < y));
            }

//Computes maximum of integers x and y
            exports.max = function (x, y) {
                return x ^ ((x ^ y) & -(x < y));
            }

//Checks if a number is a power of two
            exports.isPow2 = function (v) {
                return !(v & (v - 1)) && (!!v);
            }

//Computes log base 2 of v
            exports.log2 = function (v) {
                var r, shift;
                r = (v > 0xFFFF) << 4;
                v >>>= r;
                shift = (v > 0xFF) << 3;
                v >>>= shift;
                r |= shift;
                shift = (v > 0xF) << 2;
                v >>>= shift;
                r |= shift;
                shift = (v > 0x3) << 1;
                v >>>= shift;
                r |= shift;
                return r | (v >> 1);
            }

//Computes log base 10 of v
            exports.log10 = function (v) {
                return (v >= 1000000000) ? 9 : (v >= 100000000) ? 8 : (v >= 10000000) ? 7 :
                    (v >= 1000000) ? 6 : (v >= 100000) ? 5 : (v >= 10000) ? 4 :
                        (v >= 1000) ? 3 : (v >= 100) ? 2 : (v >= 10) ? 1 : 0;
            }

//Counts number of bits
            exports.popCount = function (v) {
                v = v - ((v >>> 1) & 0x55555555);
                v = (v & 0x33333333) + ((v >>> 2) & 0x33333333);
                return ((v + (v >>> 4) & 0xF0F0F0F) * 0x1010101) >>> 24;
            }

//Counts number of trailing zeros
            function countTrailingZeros(v) {
                var c = 32;
                v &= -v;
                if (v) c--;
                if (v & 0x0000FFFF) c -= 16;
                if (v & 0x00FF00FF) c -= 8;
                if (v & 0x0F0F0F0F) c -= 4;
                if (v & 0x33333333) c -= 2;
                if (v & 0x55555555) c -= 1;
                return c;
            }

            exports.countTrailingZeros = countTrailingZeros;

//Rounds to next power of 2
            exports.nextPow2 = function (v) {
                v += v === 0;
                --v;
                v |= v >>> 1;
                v |= v >>> 2;
                v |= v >>> 4;
                v |= v >>> 8;
                v |= v >>> 16;
                return v + 1;
            }

//Rounds down to previous power of 2
            exports.prevPow2 = function (v) {
                v |= v >>> 1;
                v |= v >>> 2;
                v |= v >>> 4;
                v |= v >>> 8;
                v |= v >>> 16;
                return v - (v >>> 1);
            }

//Computes parity of word
            exports.parity = function (v) {
                v ^= v >>> 16;
                v ^= v >>> 8;
                v ^= v >>> 4;
                v &= 0xf;
                return (0x6996 >>> v) & 1;
            }

            var REVERSE_TABLE = new Array(256);

            (function (tab) {
                for (var i = 0; i < 256; ++i) {
                    var v = i, r = i, s = 7;
                    for (v >>>= 1; v; v >>>= 1) {
                        r <<= 1;
                        r |= v & 1;
                        --s;
                    }
                    tab[i] = (r << s) & 0xff;
                }
            })(REVERSE_TABLE);

//Reverse bits in a 32 bit word
            exports.reverse = function (v) {
                return (REVERSE_TABLE[v & 0xff] << 24) |
                    (REVERSE_TABLE[(v >>> 8) & 0xff] << 16) |
                    (REVERSE_TABLE[(v >>> 16) & 0xff] << 8) |
                    REVERSE_TABLE[(v >>> 24) & 0xff];
            }

//Interleave bits of 2 coordinates with 16 bits.  Useful for fast quadtree codes
            exports.interleave2 = function (x, y) {
                x &= 0xFFFF;
                x = (x | (x << 8)) & 0x00FF00FF;
                x = (x | (x << 4)) & 0x0F0F0F0F;
                x = (x | (x << 2)) & 0x33333333;
                x = (x | (x << 1)) & 0x55555555;

                y &= 0xFFFF;
                y = (y | (y << 8)) & 0x00FF00FF;
                y = (y | (y << 4)) & 0x0F0F0F0F;
                y = (y | (y << 2)) & 0x33333333;
                y = (y | (y << 1)) & 0x55555555;

                return x | (y << 1);
            }

//Extracts the nth interleaved component
            exports.deinterleave2 = function (v, n) {
                v = (v >>> n) & 0x55555555;
                v = (v | (v >>> 1)) & 0x33333333;
                v = (v | (v >>> 2)) & 0x0F0F0F0F;
                v = (v | (v >>> 4)) & 0x00FF00FF;
                v = (v | (v >>> 16)) & 0x000FFFF;
                return (v << 16) >> 16;
            }


//Interleave bits of 3 coordinates, each with 10 bits.  Useful for fast octree codes
            exports.interleave3 = function (x, y, z) {
                x &= 0x3FF;
                x = (x | (x << 16)) & 4278190335;
                x = (x | (x << 8)) & 251719695;
                x = (x | (x << 4)) & 3272356035;
                x = (x | (x << 2)) & 1227133513;

                y &= 0x3FF;
                y = (y | (y << 16)) & 4278190335;
                y = (y | (y << 8)) & 251719695;
                y = (y | (y << 4)) & 3272356035;
                y = (y | (y << 2)) & 1227133513;
                x |= (y << 1);

                z &= 0x3FF;
                z = (z | (z << 16)) & 4278190335;
                z = (z | (z << 8)) & 251719695;
                z = (z | (z << 4)) & 3272356035;
                z = (z | (z << 2)) & 1227133513;

                return x | (z << 2);
            }

//Extracts nth interleaved component of a 3-tuple
            exports.deinterleave3 = function (v, n) {
                v = (v >>> n) & 1227133513;
                v = (v | (v >>> 2)) & 3272356035;
                v = (v | (v >>> 4)) & 251719695;
                v = (v | (v >>> 8)) & 4278190335;
                v = (v | (v >>> 16)) & 0x3FF;
                return (v << 22) >> 22;
            }

//Computes next combination in colexicographic order (this is mistakenly called nextPermutation on the bit twiddling hacks page)
            exports.nextCombination = function (v) {
                var t = v | (v - 1);
                return (t + 1) | (((~t & -~t) - 1) >>> (countTrailingZeros(v) + 1));
            }


        }, {}],
        82: [function (_dereq_, module, exports) {
            'use strict'

            var clamp = _dereq_('clamp')

            module.exports = calcSDF

            var INF = 1e20;

            function calcSDF(src, options) {
                if (!options) options = {}

                var cutoff = options.cutoff == null ? 0.25 : options.cutoff
                var radius = options.radius == null ? 8 : options.radius
                var channel = options.channel || 0
                var w, h, size, data, intData, stride, ctx, canvas, imgData, i,
                    l

                // handle image container
                if (ArrayBuffer.isView(src) || Array.isArray(src)) {
                    if (!options.width || !options.height) throw Error('For raw data width and height should be provided by options')
                    w = options.width, h = options.height
                    data = src

                    if (!options.stride) stride = Math.floor(src.length / w / h)
                    else stride = options.stride
                } else {
                    if (window.HTMLCanvasElement && src instanceof window.HTMLCanvasElement) {
                        canvas = src
                        ctx = canvas.getContext('2d')
                        w = canvas.width, h = canvas.height
                        imgData = ctx.getImageData(0, 0, w, h)
                        data = imgData.data
                        stride = 4
                    } else if (window.CanvasRenderingContext2D && src instanceof window.CanvasRenderingContext2D) {
                        canvas = src.canvas
                        ctx = src
                        w = canvas.width, h = canvas.height
                        imgData = ctx.getImageData(0, 0, w, h)
                        data = imgData.data
                        stride = 4
                    } else if (window.ImageData && src instanceof window.ImageData) {
                        imgData = src
                        w = src.width, h = src.height
                        data = imgData.data
                        stride = 4
                    }
                }

                size = Math.max(w, h)

                //convert int data to floats
                if ((window.Uint8ClampedArray && data instanceof window.Uint8ClampedArray) || (window.Uint8Array && data instanceof window.Uint8Array)) {
                    intData = data
                    data = Array(w * h)

                    for (i = 0, l = intData.length; i < l; i++) {
                        data[i] = intData[i * stride + channel] / 255
                    }
                } else {
                    if (stride !== 1) throw Error('Raw data can have only 1 value per pixel')
                }

                // temporary arrays for the distance transform
                var gridOuter = Array(w * h)
                var gridInner = Array(w * h)
                var f = Array(size)
                var d = Array(size)
                var z = Array(size + 1)
                var v = Array(size)

                for (i = 0, l = w * h; i < l; i++) {
                    var a = data[i]
                    gridOuter[i] = a === 1 ? 0 : a === 0 ? INF : Math.pow(Math.max(0, 0.5 - a), 2)
                    gridInner[i] = a === 1 ? INF : a === 0 ? 0 : Math.pow(Math.max(0, a - 0.5), 2)
                }

                edt(gridOuter, w, h, f, d, v, z)
                edt(gridInner, w, h, f, d, v, z)

                var dist = window.Float32Array ? new Float32Array(w * h) : new Array(w * h)

                for (i = 0, l = w * h; i < l; i++) {
                    dist[i] = clamp(1 - ((gridOuter[i] - gridInner[i]) / radius + cutoff), 0, 1)
                }

                return dist
            }

// 2D Euclidean distance transform by Felzenszwalb & Huttenlocher https://cs.brown.edu/~pff/dt/
            function edt(data, width, height, f, d, v, z) {
                for (var x = 0; x < width; x++) {
                    for (var y = 0; y < height; y++) {
                        f[y] = data[y * width + x]
                    }
                    edt1d(f, d, v, z, height)
                    for (y = 0; y < height; y++) {
                        data[y * width + x] = d[y]
                    }
                }
                for (y = 0; y < height; y++) {
                    for (x = 0; x < width; x++) {
                        f[x] = data[y * width + x]
                    }
                    edt1d(f, d, v, z, width)
                    for (x = 0; x < width; x++) {
                        data[y * width + x] = Math.sqrt(d[x])
                    }
                }
            }

// 1D squared distance transform
            function edt1d(f, d, v, z, n) {
                v[0] = 0;
                z[0] = -INF
                z[1] = +INF

                for (var q = 1, k = 0; q < n; q++) {
                    var s = ((f[q] + q * q) - (f[v[k]] + v[k] * v[k])) / (2 * q - 2 * v[k])
                    while (s <= z[k]) {
                        k--
                        s = ((f[q] + q * q) - (f[v[k]] + v[k] * v[k])) / (2 * q - 2 * v[k])
                    }
                    k++
                    v[k] = q
                    z[k] = s
                    z[k + 1] = +INF
                }

                for (q = 0, k = 0; q < n; q++) {
                    while (z[k + 1] < q) k++
                    d[q] = (q - v[k]) * (q - v[k]) + f[v[k]]
                }
            }

        }, {"clamp": 86}],
        83: [function (_dereq_, module, exports) {

        }, {}],
        84: [function (_dereq_, module, exports) {
// Copyright Joyent, Inc. and other Node contributors.
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to permit
// persons to whom the Software is furnished to do so, subject to the
// following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
// NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
// DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
// OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
// USE OR OTHER DEALINGS IN THE SOFTWARE.

            'use strict';

            var R = typeof Reflect === 'object' ? Reflect : null
            var ReflectApply = R && typeof R.apply === 'function'
                ? R.apply
                : function ReflectApply(target, receiver, args) {
                    return Function.prototype.apply.call(target, receiver, args);
                }

            var ReflectOwnKeys
            if (R && typeof R.ownKeys === 'function') {
                ReflectOwnKeys = R.ownKeys
            } else if (Object.getOwnPropertySymbols) {
                ReflectOwnKeys = function ReflectOwnKeys(target) {
                    return Object.getOwnPropertyNames(target)
                        .concat(Object.getOwnPropertySymbols(target));
                };
            } else {
                ReflectOwnKeys = function ReflectOwnKeys(target) {
                    return Object.getOwnPropertyNames(target);
                };
            }

            function ProcessEmitWarning(warning) {
                if (console && console.warn) console.warn(warning);
            }

            var NumberIsNaN = Number.isNaN || function NumberIsNaN(value) {
                return value !== value;
            }

            function EventEmitter() {
                EventEmitter.init.call(this);
            }

            module.exports = EventEmitter;
            module.exports.once = once;

// Backwards-compat with node 0.10.x
            EventEmitter.EventEmitter = EventEmitter;

            EventEmitter.prototype._events = undefined;
            EventEmitter.prototype._eventsCount = 0;
            EventEmitter.prototype._maxListeners = undefined;

// By default EventEmitters will print a warning if more than 10 listeners are
// added to it. This is a useful default which helps finding memory leaks.
            var defaultMaxListeners = 10;

            function checkListener(listener) {
                if (typeof listener !== 'function') {
                    throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof listener);
                }
            }

            Object.defineProperty(EventEmitter, 'defaultMaxListeners', {
                enumerable: true,
                get: function () {
                    return defaultMaxListeners;
                },
                set: function (arg) {
                    if (typeof arg !== 'number' || arg < 0 || NumberIsNaN(arg)) {
                        throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + arg + '.');
                    }
                    defaultMaxListeners = arg;
                }
            });

            EventEmitter.init = function () {

                if (this._events === undefined ||
                    this._events === Object.getPrototypeOf(this)._events) {
                    this._events = Object.create(null);
                    this._eventsCount = 0;
                }

                this._maxListeners = this._maxListeners || undefined;
            };

// Obviously not all Emitters should be limited to 10. This function allows
// that to be increased. Set to zero for unlimited.
            EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
                if (typeof n !== 'number' || n < 0 || NumberIsNaN(n)) {
                    throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + n + '.');
                }
                this._maxListeners = n;
                return this;
            };

            function _getMaxListeners(that) {
                if (that._maxListeners === undefined)
                    return EventEmitter.defaultMaxListeners;
                return that._maxListeners;
            }

            EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
                return _getMaxListeners(this);
            };

            EventEmitter.prototype.emit = function emit(type) {
                var args = [];
                for (var i = 1; i < arguments.length; i++) args.push(arguments[i]);
                var doError = (type === 'error');

                var events = this._events;
                if (events !== undefined)
                    doError = (doError && events.error === undefined);
                else if (!doError)
                    return false;

                // If there is no 'error' event listener then throw.
                if (doError) {
                    var er;
                    if (args.length > 0)
                        er = args[0];
                    if (er instanceof Error) {
                        // Note: The comments on the `throw` lines are intentional, they show
                        // up in Node's output if this results in an unhandled exception.
                        throw er; // Unhandled 'error' event
                    }
                    // At least give some kind of context to the user
                    var err = new Error('Unhandled error.' + (er ? ' (' + er.message + ')' : ''));
                    err.context = er;
                    throw err; // Unhandled 'error' event
                }

                var handler = events[type];

                if (handler === undefined)
                    return false;

                if (typeof handler === 'function') {
                    ReflectApply(handler, this, args);
                } else {
                    var len = handler.length;
                    var listeners = arrayClone(handler, len);
                    for (var i = 0; i < len; ++i)
                        ReflectApply(listeners[i], this, args);
                }

                return true;
            };

            function _addListener(target, type, listener, prepend) {
                var m;
                var events;
                var existing;

                checkListener(listener);

                events = target._events;
                if (events === undefined) {
                    events = target._events = Object.create(null);
                    target._eventsCount = 0;
                } else {
                    // To avoid recursion in the case that type === "newListener"! Before
                    // adding it to the listeners, first emit "newListener".
                    if (events.newListener !== undefined) {
                        target.emit('newListener', type,
                            listener.listener ? listener.listener : listener);

                        // Re-assign `events` because a newListener handler could have caused the
                        // this._events to be assigned to a new object
                        events = target._events;
                    }
                    existing = events[type];
                }

                if (existing === undefined) {
                    // Optimize the case of one listener. Don't need the extra array object.
                    existing = events[type] = listener;
                    ++target._eventsCount;
                } else {
                    if (typeof existing === 'function') {
                        // Adding the second element, need to change to array.
                        existing = events[type] =
                            prepend ? [listener, existing] : [existing, listener];
                        // If we've already got an array, just append.
                    } else if (prepend) {
                        existing.unshift(listener);
                    } else {
                        existing.push(listener);
                    }

                    // Check for listener leak
                    m = _getMaxListeners(target);
                    if (m > 0 && existing.length > m && !existing.warned) {
                        existing.warned = true;
                        // No error code for this since it is a Warning
                        // eslint-disable-next-line no-restricted-syntax
                        var w = new Error('Possible EventEmitter memory leak detected. ' +
                            existing.length + ' ' + String(type) + ' listeners ' +
                            'added. Use emitter.setMaxListeners() to ' +
                            'increase limit');
                        w.name = 'MaxListenersExceededWarning';
                        w.emitter = target;
                        w.type = type;
                        w.count = existing.length;
                        ProcessEmitWarning(w);
                    }
                }

                return target;
            }

            EventEmitter.prototype.addListener = function addListener(type, listener) {
                return _addListener(this, type, listener, false);
            };

            EventEmitter.prototype.on = EventEmitter.prototype.addListener;

            EventEmitter.prototype.prependListener =
                function prependListener(type, listener) {
                    return _addListener(this, type, listener, true);
                };

            function onceWrapper() {
                if (!this.fired) {
                    this.target.removeListener(this.type, this.wrapFn);
                    this.fired = true;
                    if (arguments.length === 0)
                        return this.listener.call(this.target);
                    return this.listener.apply(this.target, arguments);
                }
            }

            function _onceWrap(target, type, listener) {
                var state = {
                    fired: false,
                    wrapFn: undefined,
                    target: target,
                    type: type,
                    listener: listener
                };
                var wrapped = onceWrapper.bind(state);
                wrapped.listener = listener;
                state.wrapFn = wrapped;
                return wrapped;
            }

            EventEmitter.prototype.once = function once(type, listener) {
                checkListener(listener);
                this.on(type, _onceWrap(this, type, listener));
                return this;
            };

            EventEmitter.prototype.prependOnceListener =
                function prependOnceListener(type, listener) {
                    checkListener(listener);
                    this.prependListener(type, _onceWrap(this, type, listener));
                    return this;
                };

// Emits a 'removeListener' event if and only if the listener was removed.
            EventEmitter.prototype.removeListener =
                function removeListener(type, listener) {
                    var list, events, position, i, originalListener;

                    checkListener(listener);

                    events = this._events;
                    if (events === undefined)
                        return this;

                    list = events[type];
                    if (list === undefined)
                        return this;

                    if (list === listener || list.listener === listener) {
                        if (--this._eventsCount === 0)
                            this._events = Object.create(null);
                        else {
                            delete events[type];
                            if (events.removeListener)
                                this.emit('removeListener', type, list.listener || listener);
                        }
                    } else if (typeof list !== 'function') {
                        position = -1;

                        for (i = list.length - 1; i >= 0; i--) {
                            if (list[i] === listener || list[i].listener === listener) {
                                originalListener = list[i].listener;
                                position = i;
                                break;
                            }
                        }

                        if (position < 0)
                            return this;

                        if (position === 0)
                            list.shift();
                        else {
                            spliceOne(list, position);
                        }

                        if (list.length === 1)
                            events[type] = list[0];

                        if (events.removeListener !== undefined)
                            this.emit('removeListener', type, originalListener || listener);
                    }

                    return this;
                };

            EventEmitter.prototype.off = EventEmitter.prototype.removeListener;

            EventEmitter.prototype.removeAllListeners =
                function removeAllListeners(type) {
                    var listeners, events, i;

                    events = this._events;
                    if (events === undefined)
                        return this;

                    // not listening for removeListener, no need to emit
                    if (events.removeListener === undefined) {
                        if (arguments.length === 0) {
                            this._events = Object.create(null);
                            this._eventsCount = 0;
                        } else if (events[type] !== undefined) {
                            if (--this._eventsCount === 0)
                                this._events = Object.create(null);
                            else
                                delete events[type];
                        }
                        return this;
                    }

                    // emit removeListener for all listeners on all events
                    if (arguments.length === 0) {
                        var keys = Object.keys(events);
                        var key;
                        for (i = 0; i < keys.length; ++i) {
                            key = keys[i];
                            if (key === 'removeListener') continue;
                            this.removeAllListeners(key);
                        }
                        this.removeAllListeners('removeListener');
                        this._events = Object.create(null);
                        this._eventsCount = 0;
                        return this;
                    }

                    listeners = events[type];

                    if (typeof listeners === 'function') {
                        this.removeListener(type, listeners);
                    } else if (listeners !== undefined) {
                        // LIFO order
                        for (i = listeners.length - 1; i >= 0; i--) {
                            this.removeListener(type, listeners[i]);
                        }
                    }

                    return this;
                };

            function _listeners(target, type, unwrap) {
                var events = target._events;

                if (events === undefined)
                    return [];

                var evlistener = events[type];
                if (evlistener === undefined)
                    return [];

                if (typeof evlistener === 'function')
                    return unwrap ? [evlistener.listener || evlistener] : [evlistener];

                return unwrap ?
                    unwrapListeners(evlistener) : arrayClone(evlistener, evlistener.length);
            }

            EventEmitter.prototype.listeners = function listeners(type) {
                return _listeners(this, type, true);
            };

            EventEmitter.prototype.rawListeners = function rawListeners(type) {
                return _listeners(this, type, false);
            };

            EventEmitter.listenerCount = function (emitter, type) {
                if (typeof emitter.listenerCount === 'function') {
                    return emitter.listenerCount(type);
                } else {
                    return listenerCount.call(emitter, type);
                }
            };

            EventEmitter.prototype.listenerCount = listenerCount;

            function listenerCount(type) {
                var events = this._events;

                if (events !== undefined) {
                    var evlistener = events[type];

                    if (typeof evlistener === 'function') {
                        return 1;
                    } else if (evlistener !== undefined) {
                        return evlistener.length;
                    }
                }

                return 0;
            }

            EventEmitter.prototype.eventNames = function eventNames() {
                return this._eventsCount > 0 ? ReflectOwnKeys(this._events) : [];
            };

            function arrayClone(arr, n) {
                var copy = new Array(n);
                for (var i = 0; i < n; ++i)
                    copy[i] = arr[i];
                return copy;
            }

            function spliceOne(list, index) {
                for (; index + 1 < list.length; index++)
                    list[index] = list[index + 1];
                list.pop();
            }

            function unwrapListeners(arr) {
                var ret = new Array(arr.length);
                for (var i = 0; i < ret.length; ++i) {
                    ret[i] = arr[i].listener || arr[i];
                }
                return ret;
            }

            function once(emitter, name) {
                return new Promise(function (resolve, reject) {
                    function eventListener() {
                        if (errorListener !== undefined) {
                            emitter.removeListener('error', errorListener);
                        }
                        resolve([].slice.call(arguments));
                    };
                    var errorListener;

                    // Adding an error listener is not optional because
                    // if an error is thrown on an event emitter we cannot
                    // guarantee that the actual event we are waiting will
                    // be fired. The result could be a silent way to create
                    // memory or file descriptor leaks, which is something
                    // we should avoid.
                    if (name !== 'error') {
                        errorListener = function errorListener(err) {
                            emitter.removeListener(name, eventListener);
                            reject(err);
                        };

                        emitter.once('error', errorListener);
                    }

                    emitter.once(name, eventListener);
                });
            }

        }, {}],
        85: [function (_dereq_, module, exports) {
            (function (Buffer) {
                (function () {
                    /*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
                    /* eslint-disable no-proto */

                    'use strict'

                    var base64 = _dereq_('base64-js')
                    var ieee754 = _dereq_('ieee754')

                    exports.Buffer = Buffer
                    exports.SlowBuffer = SlowBuffer
                    exports.INSPECT_MAX_BYTES = 50

                    var K_MAX_LENGTH = 0x7fffffff
                    exports.kMaxLength = K_MAX_LENGTH

                    /**
                     * If `Buffer.TYPED_ARRAY_SUPPORT`:
                     *   === true    Use Uint8Array implementation (fastest)
                     *   === false   Print warning and recommend using `buffer` v4.x which has an Object
                     *               implementation (most compatible, even IE6)
                     *
                     * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
                     * Opera 11.6+, iOS 4.2+.
                     *
                     * We report that the browser does not support typed arrays if the are not subclassable
                     * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
                     * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
                     * for __proto__ and has a buggy typed array implementation.
                     */
                    Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport()

                    if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' &&
                        typeof console.error === 'function') {
                        console.error(
                            'This browser lacks typed array (Uint8Array) support which is required by ' +
                            '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
                        )
                    }

                    function typedArraySupport() {
                        // Can typed array instances can be augmented?
                        try {
                            var arr = new Uint8Array(1)
                            arr.__proto__ = {
                                __proto__: Uint8Array.prototype,
                                foo: function () {
                                    return 42
                                }
                            }
                            return arr.foo() === 42
                        } catch (e) {
                            return false
                        }
                    }

                    Object.defineProperty(Buffer.prototype, 'parent', {
                        enumerable: true,
                        get: function () {
                            if (!Buffer.isBuffer(this)) return undefined
                            return this.buffer
                        }
                    })

                    Object.defineProperty(Buffer.prototype, 'offset', {
                        enumerable: true,
                        get: function () {
                            if (!Buffer.isBuffer(this)) return undefined
                            return this.byteOffset
                        }
                    })

                    function createBuffer(length) {
                        if (length > K_MAX_LENGTH) {
                            throw new RangeError('The value "' + length + '" is invalid for option "size"')
                        }
                        // Return an augmented `Uint8Array` instance
                        var buf = new Uint8Array(length)
                        buf.__proto__ = Buffer.prototype
                        return buf
                    }

                    /**
                     * The Buffer constructor returns instances of `Uint8Array` that have their
                     * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
                     * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
                     * and the `Uint8Array` methods. Square bracket notation works as expected -- it
                     * returns a single octet.
                     *
                     * The `Uint8Array` prototype remains unmodified.
                     */

                    function Buffer(arg, encodingOrOffset, length) {
                        // Common case.
                        if (typeof arg === 'number') {
                            if (typeof encodingOrOffset === 'string') {
                                throw new TypeError(
                                    'The "string" argument must be of type string. Received type number'
                                )
                            }
                            return allocUnsafe(arg)
                        }
                        return from(arg, encodingOrOffset, length)
                    }

// Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
                    if (typeof Symbol !== 'undefined' && Symbol.species != null &&
                        Buffer[Symbol.species] === Buffer) {
                        Object.defineProperty(Buffer, Symbol.species, {
                            value: null,
                            configurable: true,
                            enumerable: false,
                            writable: false
                        })
                    }

                    Buffer.poolSize = 8192 // not used by this implementation

                    function from(value, encodingOrOffset, length) {
                        if (typeof value === 'string') {
                            return fromString(value, encodingOrOffset)
                        }

                        if (ArrayBuffer.isView(value)) {
                            return fromArrayLike(value)
                        }

                        if (value == null) {
                            throw TypeError(
                                'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
                                'or Array-like Object. Received type ' + (typeof value)
                            )
                        }

                        if (isInstance(value, ArrayBuffer) ||
                            (value && isInstance(value.buffer, ArrayBuffer))) {
                            return fromArrayBuffer(value, encodingOrOffset, length)
                        }

                        if (typeof value === 'number') {
                            throw new TypeError(
                                'The "value" argument must not be of type number. Received type number'
                            )
                        }

                        var valueOf = value.valueOf && value.valueOf()
                        if (valueOf != null && valueOf !== value) {
                            return Buffer.from(valueOf, encodingOrOffset, length)
                        }

                        var b = fromObject(value)
                        if (b) return b

                        if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null &&
                            typeof value[Symbol.toPrimitive] === 'function') {
                            return Buffer.from(
                                value[Symbol.toPrimitive]('string'), encodingOrOffset, length
                            )
                        }

                        throw new TypeError(
                            'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
                            'or Array-like Object. Received type ' + (typeof value)
                        )
                    }

                    /**
                     * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
                     * if value is a number.
                     * Buffer.from(str[, encoding])
                     * Buffer.from(array)
                     * Buffer.from(buffer)
                     * Buffer.from(arrayBuffer[, byteOffset[, length]])
                     **/
                    Buffer.from = function (value, encodingOrOffset, length) {
                        return from(value, encodingOrOffset, length)
                    }

// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
// https://github.com/feross/buffer/pull/148
                    Buffer.prototype.__proto__ = Uint8Array.prototype
                    Buffer.__proto__ = Uint8Array

                    function assertSize(size) {
                        if (typeof size !== 'number') {
                            throw new TypeError('"size" argument must be of type number')
                        } else if (size < 0) {
                            throw new RangeError('The value "' + size + '" is invalid for option "size"')
                        }
                    }

                    function alloc(size, fill, encoding) {
                        assertSize(size)
                        if (size <= 0) {
                            return createBuffer(size)
                        }
                        if (fill !== undefined) {
                            // Only pay attention to encoding if it's a string. This
                            // prevents accidentally sending in a number that would
                            // be interpretted as a start offset.
                            return typeof encoding === 'string'
                                ? createBuffer(size).fill(fill, encoding)
                                : createBuffer(size).fill(fill)
                        }
                        return createBuffer(size)
                    }

                    /**
                     * Creates a new filled Buffer instance.
                     * alloc(size[, fill[, encoding]])
                     **/
                    Buffer.alloc = function (size, fill, encoding) {
                        return alloc(size, fill, encoding)
                    }

                    function allocUnsafe(size) {
                        assertSize(size)
                        return createBuffer(size < 0 ? 0 : checked(size) | 0)
                    }

                    /**
                     * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
                     * */
                    Buffer.allocUnsafe = function (size) {
                        return allocUnsafe(size)
                    }
                    /**
                     * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
                     */
                    Buffer.allocUnsafeSlow = function (size) {
                        return allocUnsafe(size)
                    }

                    function fromString(string, encoding) {
                        if (typeof encoding !== 'string' || encoding === '') {
                            encoding = 'utf8'
                        }

                        if (!Buffer.isEncoding(encoding)) {
                            throw new TypeError('Unknown encoding: ' + encoding)
                        }

                        var length = byteLength(string, encoding) | 0
                        var buf = createBuffer(length)

                        var actual = buf.write(string, encoding)

                        if (actual !== length) {
                            // Writing a hex string, for example, that contains invalid characters will
                            // cause everything after the first invalid character to be ignored. (e.g.
                            // 'abxxcd' will be treated as 'ab')
                            buf = buf.slice(0, actual)
                        }

                        return buf
                    }

                    function fromArrayLike(array) {
                        var length = array.length < 0 ? 0 : checked(array.length) | 0
                        var buf = createBuffer(length)
                        for (var i = 0; i < length; i += 1) {
                            buf[i] = array[i] & 255
                        }
                        return buf
                    }

                    function fromArrayBuffer(array, byteOffset, length) {
                        if (byteOffset < 0 || array.byteLength < byteOffset) {
                            throw new RangeError('"offset" is outside of buffer bounds')
                        }

                        if (array.byteLength < byteOffset + (length || 0)) {
                            throw new RangeError('"length" is outside of buffer bounds')
                        }

                        var buf
                        if (byteOffset === undefined && length === undefined) {
                            buf = new Uint8Array(array)
                        } else if (length === undefined) {
                            buf = new Uint8Array(array, byteOffset)
                        } else {
                            buf = new Uint8Array(array, byteOffset, length)
                        }

                        // Return an augmented `Uint8Array` instance
                        buf.__proto__ = Buffer.prototype
                        return buf
                    }

                    function fromObject(obj) {
                        if (Buffer.isBuffer(obj)) {
                            var len = checked(obj.length) | 0
                            var buf = createBuffer(len)

                            if (buf.length === 0) {
                                return buf
                            }

                            obj.copy(buf, 0, 0, len)
                            return buf
                        }

                        if (obj.length !== undefined) {
                            if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
                                return createBuffer(0)
                            }
                            return fromArrayLike(obj)
                        }

                        if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
                            return fromArrayLike(obj.data)
                        }
                    }

                    function checked(length) {
                        // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
                        // length is NaN (which is otherwise coerced to zero.)
                        if (length >= K_MAX_LENGTH) {
                            throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                                'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes')
                        }
                        return length | 0
                    }

                    function SlowBuffer(length) {
                        if (+length != length) { // eslint-disable-line eqeqeq
                            length = 0
                        }
                        return Buffer.alloc(+length)
                    }

                    Buffer.isBuffer = function isBuffer(b) {
                        return b != null && b._isBuffer === true &&
                            b !== Buffer.prototype // so Buffer.isBuffer(Buffer.prototype) will be false
                    }

                    Buffer.compare = function compare(a, b) {
                        if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength)
                        if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength)
                        if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
                            throw new TypeError(
                                'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
                            )
                        }

                        if (a === b) return 0

                        var x = a.length
                        var y = b.length

                        for (var i = 0, len = Math.min(x, y); i < len; ++i) {
                            if (a[i] !== b[i]) {
                                x = a[i]
                                y = b[i]
                                break
                            }
                        }

                        if (x < y) return -1
                        if (y < x) return 1
                        return 0
                    }

                    Buffer.isEncoding = function isEncoding(encoding) {
                        switch (String(encoding).toLowerCase()) {
                            case 'hex':
                            case 'utf8':
                            case 'utf-8':
                            case 'ascii':
                            case 'latin1':
                            case 'binary':
                            case 'base64':
                            case 'ucs2':
                            case 'ucs-2':
                            case 'utf16le':
                            case 'utf-16le':
                                return true
                            default:
                                return false
                        }
                    }

                    Buffer.concat = function concat(list, length) {
                        if (!Array.isArray(list)) {
                            throw new TypeError('"list" argument must be an Array of Buffers')
                        }

                        if (list.length === 0) {
                            return Buffer.alloc(0)
                        }

                        var i
                        if (length === undefined) {
                            length = 0
                            for (i = 0; i < list.length; ++i) {
                                length += list[i].length
                            }
                        }

                        var buffer = Buffer.allocUnsafe(length)
                        var pos = 0
                        for (i = 0; i < list.length; ++i) {
                            var buf = list[i]
                            if (isInstance(buf, Uint8Array)) {
                                buf = Buffer.from(buf)
                            }
                            if (!Buffer.isBuffer(buf)) {
                                throw new TypeError('"list" argument must be an Array of Buffers')
                            }
                            buf.copy(buffer, pos)
                            pos += buf.length
                        }
                        return buffer
                    }

                    function byteLength(string, encoding) {
                        if (Buffer.isBuffer(string)) {
                            return string.length
                        }
                        if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
                            return string.byteLength
                        }
                        if (typeof string !== 'string') {
                            throw new TypeError(
                                'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
                                'Received type ' + typeof string
                            )
                        }

                        var len = string.length
                        var mustMatch = (arguments.length > 2 && arguments[2] === true)
                        if (!mustMatch && len === 0) return 0

                        // Use a for loop to avoid recursion
                        var loweredCase = false
                        for (; ;) {
                            switch (encoding) {
                                case 'ascii':
                                case 'latin1':
                                case 'binary':
                                    return len
                                case 'utf8':
                                case 'utf-8':
                                    return utf8ToBytes(string).length
                                case 'ucs2':
                                case 'ucs-2':
                                case 'utf16le':
                                case 'utf-16le':
                                    return len * 2
                                case 'hex':
                                    return len >>> 1
                                case 'base64':
                                    return base64ToBytes(string).length
                                default:
                                    if (loweredCase) {
                                        return mustMatch ? -1 : utf8ToBytes(string).length // assume utf8
                                    }
                                    encoding = ('' + encoding).toLowerCase()
                                    loweredCase = true
                            }
                        }
                    }

                    Buffer.byteLength = byteLength

                    function slowToString(encoding, start, end) {
                        var loweredCase = false

                        // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
                        // property of a typed array.

                        // This behaves neither like String nor Uint8Array in that we set start/end
                        // to their upper/lower bounds if the value passed is out of range.
                        // undefined is handled specially as per ECMA-262 6th Edition,
                        // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
                        if (start === undefined || start < 0) {
                            start = 0
                        }
                        // Return early if start > this.length. Done here to prevent potential uint32
                        // coercion fail below.
                        if (start > this.length) {
                            return ''
                        }

                        if (end === undefined || end > this.length) {
                            end = this.length
                        }

                        if (end <= 0) {
                            return ''
                        }

                        // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
                        end >>>= 0
                        start >>>= 0

                        if (end <= start) {
                            return ''
                        }

                        if (!encoding) encoding = 'utf8'

                        while (true) {
                            switch (encoding) {
                                case 'hex':
                                    return hexSlice(this, start, end)

                                case 'utf8':
                                case 'utf-8':
                                    return utf8Slice(this, start, end)

                                case 'ascii':
                                    return asciiSlice(this, start, end)

                                case 'latin1':
                                case 'binary':
                                    return latin1Slice(this, start, end)

                                case 'base64':
                                    return base64Slice(this, start, end)

                                case 'ucs2':
                                case 'ucs-2':
                                case 'utf16le':
                                case 'utf-16le':
                                    return utf16leSlice(this, start, end)

                                default:
                                    if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
                                    encoding = (encoding + '').toLowerCase()
                                    loweredCase = true
                            }
                        }
                    }

// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
// reliably in a browserify context because there could be multiple different
// copies of the 'buffer' package in use. This method works even for Buffer
// instances that were created from another copy of the `buffer` package.
// See: https://github.com/feross/buffer/issues/154
                    Buffer.prototype._isBuffer = true

                    function swap(b, n, m) {
                        var i = b[n]
                        b[n] = b[m]
                        b[m] = i
                    }

                    Buffer.prototype.swap16 = function swap16() {
                        var len = this.length
                        if (len % 2 !== 0) {
                            throw new RangeError('Buffer size must be a multiple of 16-bits')
                        }
                        for (var i = 0; i < len; i += 2) {
                            swap(this, i, i + 1)
                        }
                        return this
                    }

                    Buffer.prototype.swap32 = function swap32() {
                        var len = this.length
                        if (len % 4 !== 0) {
                            throw new RangeError('Buffer size must be a multiple of 32-bits')
                        }
                        for (var i = 0; i < len; i += 4) {
                            swap(this, i, i + 3)
                            swap(this, i + 1, i + 2)
                        }
                        return this
                    }

                    Buffer.prototype.swap64 = function swap64() {
                        var len = this.length
                        if (len % 8 !== 0) {
                            throw new RangeError('Buffer size must be a multiple of 64-bits')
                        }
                        for (var i = 0; i < len; i += 8) {
                            swap(this, i, i + 7)
                            swap(this, i + 1, i + 6)
                            swap(this, i + 2, i + 5)
                            swap(this, i + 3, i + 4)
                        }
                        return this
                    }

                    Buffer.prototype.toString = function toString() {
                        var length = this.length
                        if (length === 0) return ''
                        if (arguments.length === 0) return utf8Slice(this, 0, length)
                        return slowToString.apply(this, arguments)
                    }

                    Buffer.prototype.toLocaleString = Buffer.prototype.toString

                    Buffer.prototype.equals = function equals(b) {
                        if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
                        if (this === b) return true
                        return Buffer.compare(this, b) === 0
                    }

                    Buffer.prototype.inspect = function inspect() {
                        var str = ''
                        var max = exports.INSPECT_MAX_BYTES
                        str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim()
                        if (this.length > max) str += ' ... '
                        return '<Buffer ' + str + '>'
                    }

                    Buffer.prototype.compare = function compare(target, start, end, thisStart, thisEnd) {
                        if (isInstance(target, Uint8Array)) {
                            target = Buffer.from(target, target.offset, target.byteLength)
                        }
                        if (!Buffer.isBuffer(target)) {
                            throw new TypeError(
                                'The "target" argument must be one of type Buffer or Uint8Array. ' +
                                'Received type ' + (typeof target)
                            )
                        }

                        if (start === undefined) {
                            start = 0
                        }
                        if (end === undefined) {
                            end = target ? target.length : 0
                        }
                        if (thisStart === undefined) {
                            thisStart = 0
                        }
                        if (thisEnd === undefined) {
                            thisEnd = this.length
                        }

                        if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
                            throw new RangeError('out of range index')
                        }

                        if (thisStart >= thisEnd && start >= end) {
                            return 0
                        }
                        if (thisStart >= thisEnd) {
                            return -1
                        }
                        if (start >= end) {
                            return 1
                        }

                        start >>>= 0
                        end >>>= 0
                        thisStart >>>= 0
                        thisEnd >>>= 0

                        if (this === target) return 0

                        var x = thisEnd - thisStart
                        var y = end - start
                        var len = Math.min(x, y)

                        var thisCopy = this.slice(thisStart, thisEnd)
                        var targetCopy = target.slice(start, end)

                        for (var i = 0; i < len; ++i) {
                            if (thisCopy[i] !== targetCopy[i]) {
                                x = thisCopy[i]
                                y = targetCopy[i]
                                break
                            }
                        }

                        if (x < y) return -1
                        if (y < x) return 1
                        return 0
                    }

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
                    function bidirectionalIndexOf(buffer, val, byteOffset, encoding, dir) {
                        // Empty buffer means no match
                        if (buffer.length === 0) return -1

                        // Normalize byteOffset
                        if (typeof byteOffset === 'string') {
                            encoding = byteOffset
                            byteOffset = 0
                        } else if (byteOffset > 0x7fffffff) {
                            byteOffset = 0x7fffffff
                        } else if (byteOffset < -0x80000000) {
                            byteOffset = -0x80000000
                        }
                        byteOffset = +byteOffset // Coerce to Number.
                        if (numberIsNaN(byteOffset)) {
                            // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
                            byteOffset = dir ? 0 : (buffer.length - 1)
                        }

                        // Normalize byteOffset: negative offsets start from the end of the buffer
                        if (byteOffset < 0) byteOffset = buffer.length + byteOffset
                        if (byteOffset >= buffer.length) {
                            if (dir) return -1
                            else byteOffset = buffer.length - 1
                        } else if (byteOffset < 0) {
                            if (dir) byteOffset = 0
                            else return -1
                        }

                        // Normalize val
                        if (typeof val === 'string') {
                            val = Buffer.from(val, encoding)
                        }

                        // Finally, search either indexOf (if dir is true) or lastIndexOf
                        if (Buffer.isBuffer(val)) {
                            // Special case: looking for empty string/buffer always fails
                            if (val.length === 0) {
                                return -1
                            }
                            return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
                        } else if (typeof val === 'number') {
                            val = val & 0xFF // Search for a byte value [0-255]
                            if (typeof Uint8Array.prototype.indexOf === 'function') {
                                if (dir) {
                                    return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
                                } else {
                                    return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
                                }
                            }
                            return arrayIndexOf(buffer, [val], byteOffset, encoding, dir)
                        }

                        throw new TypeError('val must be string, number or Buffer')
                    }

                    function arrayIndexOf(arr, val, byteOffset, encoding, dir) {
                        var indexSize = 1
                        var arrLength = arr.length
                        var valLength = val.length

                        if (encoding !== undefined) {
                            encoding = String(encoding).toLowerCase()
                            if (encoding === 'ucs2' || encoding === 'ucs-2' ||
                                encoding === 'utf16le' || encoding === 'utf-16le') {
                                if (arr.length < 2 || val.length < 2) {
                                    return -1
                                }
                                indexSize = 2
                                arrLength /= 2
                                valLength /= 2
                                byteOffset /= 2
                            }
                        }

                        function read(buf, i) {
                            if (indexSize === 1) {
                                return buf[i]
                            } else {
                                return buf.readUInt16BE(i * indexSize)
                            }
                        }

                        var i
                        if (dir) {
                            var foundIndex = -1
                            for (i = byteOffset; i < arrLength; i++) {
                                if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
                                    if (foundIndex === -1) foundIndex = i
                                    if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
                                } else {
                                    if (foundIndex !== -1) i -= i - foundIndex
                                    foundIndex = -1
                                }
                            }
                        } else {
                            if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
                            for (i = byteOffset; i >= 0; i--) {
                                var found = true
                                for (var j = 0; j < valLength; j++) {
                                    if (read(arr, i + j) !== read(val, j)) {
                                        found = false
                                        break
                                    }
                                }
                                if (found) return i
                            }
                        }

                        return -1
                    }

                    Buffer.prototype.includes = function includes(val, byteOffset, encoding) {
                        return this.indexOf(val, byteOffset, encoding) !== -1
                    }

                    Buffer.prototype.indexOf = function indexOf(val, byteOffset, encoding) {
                        return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
                    }

                    Buffer.prototype.lastIndexOf = function lastIndexOf(val, byteOffset, encoding) {
                        return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
                    }

                    function hexWrite(buf, string, offset, length) {
                        offset = Number(offset) || 0
                        var remaining = buf.length - offset
                        if (!length) {
                            length = remaining
                        } else {
                            length = Number(length)
                            if (length > remaining) {
                                length = remaining
                            }
                        }

                        var strLen = string.length

                        if (length > strLen / 2) {
                            length = strLen / 2
                        }
                        for (var i = 0; i < length; ++i) {
                            var parsed = parseInt(string.substr(i * 2, 2), 16)
                            if (numberIsNaN(parsed)) return i
                            buf[offset + i] = parsed
                        }
                        return i
                    }

                    function utf8Write(buf, string, offset, length) {
                        return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
                    }

                    function asciiWrite(buf, string, offset, length) {
                        return blitBuffer(asciiToBytes(string), buf, offset, length)
                    }

                    function latin1Write(buf, string, offset, length) {
                        return asciiWrite(buf, string, offset, length)
                    }

                    function base64Write(buf, string, offset, length) {
                        return blitBuffer(base64ToBytes(string), buf, offset, length)
                    }

                    function ucs2Write(buf, string, offset, length) {
                        return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
                    }

                    Buffer.prototype.write = function write(string, offset, length, encoding) {
                        // Buffer#write(string)
                        if (offset === undefined) {
                            encoding = 'utf8'
                            length = this.length
                            offset = 0
                            // Buffer#write(string, encoding)
                        } else if (length === undefined && typeof offset === 'string') {
                            encoding = offset
                            length = this.length
                            offset = 0
                            // Buffer#write(string, offset[, length][, encoding])
                        } else if (isFinite(offset)) {
                            offset = offset >>> 0
                            if (isFinite(length)) {
                                length = length >>> 0
                                if (encoding === undefined) encoding = 'utf8'
                            } else {
                                encoding = length
                                length = undefined
                            }
                        } else {
                            throw new Error(
                                'Buffer.write(string, encoding, offset[, length]) is no longer supported'
                            )
                        }

                        var remaining = this.length - offset
                        if (length === undefined || length > remaining) length = remaining

                        if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
                            throw new RangeError('Attempt to write outside buffer bounds')
                        }

                        if (!encoding) encoding = 'utf8'

                        var loweredCase = false
                        for (; ;) {
                            switch (encoding) {
                                case 'hex':
                                    return hexWrite(this, string, offset, length)

                                case 'utf8':
                                case 'utf-8':
                                    return utf8Write(this, string, offset, length)

                                case 'ascii':
                                    return asciiWrite(this, string, offset, length)

                                case 'latin1':
                                case 'binary':
                                    return latin1Write(this, string, offset, length)

                                case 'base64':
                                    // Warning: maxLength not taken into account in base64Write
                                    return base64Write(this, string, offset, length)

                                case 'ucs2':
                                case 'ucs-2':
                                case 'utf16le':
                                case 'utf-16le':
                                    return ucs2Write(this, string, offset, length)

                                default:
                                    if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
                                    encoding = ('' + encoding).toLowerCase()
                                    loweredCase = true
                            }
                        }
                    }

                    Buffer.prototype.toJSON = function toJSON() {
                        return {
                            type: 'Buffer',
                            data: Array.prototype.slice.call(this._arr || this, 0)
                        }
                    }

                    function base64Slice(buf, start, end) {
                        if (start === 0 && end === buf.length) {
                            return base64.fromByteArray(buf)
                        } else {
                            return base64.fromByteArray(buf.slice(start, end))
                        }
                    }

                    function utf8Slice(buf, start, end) {
                        end = Math.min(buf.length, end)
                        var res = []

                        var i = start
                        while (i < end) {
                            var firstByte = buf[i]
                            var codePoint = null
                            var bytesPerSequence = (firstByte > 0xEF) ? 4
                                : (firstByte > 0xDF) ? 3
                                    : (firstByte > 0xBF) ? 2
                                        : 1

                            if (i + bytesPerSequence <= end) {
                                var secondByte, thirdByte, fourthByte,
                                    tempCodePoint

                                switch (bytesPerSequence) {
                                    case 1:
                                        if (firstByte < 0x80) {
                                            codePoint = firstByte
                                        }
                                        break
                                    case 2:
                                        secondByte = buf[i + 1]
                                        if ((secondByte & 0xC0) === 0x80) {
                                            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
                                            if (tempCodePoint > 0x7F) {
                                                codePoint = tempCodePoint
                                            }
                                        }
                                        break
                                    case 3:
                                        secondByte = buf[i + 1]
                                        thirdByte = buf[i + 2]
                                        if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
                                            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
                                            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
                                                codePoint = tempCodePoint
                                            }
                                        }
                                        break
                                    case 4:
                                        secondByte = buf[i + 1]
                                        thirdByte = buf[i + 2]
                                        fourthByte = buf[i + 3]
                                        if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
                                            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
                                            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
                                                codePoint = tempCodePoint
                                            }
                                        }
                                }
                            }

                            if (codePoint === null) {
                                // we did not generate a valid codePoint so insert a
                                // replacement char (U+FFFD) and advance only 1 byte
                                codePoint = 0xFFFD
                                bytesPerSequence = 1
                            } else if (codePoint > 0xFFFF) {
                                // encode to utf16 (surrogate pair dance)
                                codePoint -= 0x10000
                                res.push(codePoint >>> 10 & 0x3FF | 0xD800)
                                codePoint = 0xDC00 | codePoint & 0x3FF
                            }

                            res.push(codePoint)
                            i += bytesPerSequence
                        }

                        return decodeCodePointsArray(res)
                    }

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
                    var MAX_ARGUMENTS_LENGTH = 0x1000

                    function decodeCodePointsArray(codePoints) {
                        var len = codePoints.length
                        if (len <= MAX_ARGUMENTS_LENGTH) {
                            return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
                        }

                        // Decode in chunks to avoid "call stack size exceeded".
                        var res = ''
                        var i = 0
                        while (i < len) {
                            res += String.fromCharCode.apply(
                                String,
                                codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
                            )
                        }
                        return res
                    }

                    function asciiSlice(buf, start, end) {
                        var ret = ''
                        end = Math.min(buf.length, end)

                        for (var i = start; i < end; ++i) {
                            ret += String.fromCharCode(buf[i] & 0x7F)
                        }
                        return ret
                    }

                    function latin1Slice(buf, start, end) {
                        var ret = ''
                        end = Math.min(buf.length, end)

                        for (var i = start; i < end; ++i) {
                            ret += String.fromCharCode(buf[i])
                        }
                        return ret
                    }

                    function hexSlice(buf, start, end) {
                        var len = buf.length

                        if (!start || start < 0) start = 0
                        if (!end || end < 0 || end > len) end = len

                        var out = ''
                        for (var i = start; i < end; ++i) {
                            out += toHex(buf[i])
                        }
                        return out
                    }

                    function utf16leSlice(buf, start, end) {
                        var bytes = buf.slice(start, end)
                        var res = ''
                        for (var i = 0; i < bytes.length; i += 2) {
                            res += String.fromCharCode(bytes[i] + (bytes[i + 1] * 256))
                        }
                        return res
                    }

                    Buffer.prototype.slice = function slice(start, end) {
                        var len = this.length
                        start = ~~start
                        end = end === undefined ? len : ~~end

                        if (start < 0) {
                            start += len
                            if (start < 0) start = 0
                        } else if (start > len) {
                            start = len
                        }

                        if (end < 0) {
                            end += len
                            if (end < 0) end = 0
                        } else if (end > len) {
                            end = len
                        }

                        if (end < start) end = start

                        var newBuf = this.subarray(start, end)
                        // Return an augmented `Uint8Array` instance
                        newBuf.__proto__ = Buffer.prototype
                        return newBuf
                    }

                    /*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
                    function checkOffset(offset, ext, length) {
                        if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
                        if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
                    }

                    Buffer.prototype.readUIntLE = function readUIntLE(offset, byteLength, noAssert) {
                        offset = offset >>> 0
                        byteLength = byteLength >>> 0
                        if (!noAssert) checkOffset(offset, byteLength, this.length)

                        var val = this[offset]
                        var mul = 1
                        var i = 0
                        while (++i < byteLength && (mul *= 0x100)) {
                            val += this[offset + i] * mul
                        }

                        return val
                    }

                    Buffer.prototype.readUIntBE = function readUIntBE(offset, byteLength, noAssert) {
                        offset = offset >>> 0
                        byteLength = byteLength >>> 0
                        if (!noAssert) {
                            checkOffset(offset, byteLength, this.length)
                        }

                        var val = this[offset + --byteLength]
                        var mul = 1
                        while (byteLength > 0 && (mul *= 0x100)) {
                            val += this[offset + --byteLength] * mul
                        }

                        return val
                    }

                    Buffer.prototype.readUInt8 = function readUInt8(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 1, this.length)
                        return this[offset]
                    }

                    Buffer.prototype.readUInt16LE = function readUInt16LE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 2, this.length)
                        return this[offset] | (this[offset + 1] << 8)
                    }

                    Buffer.prototype.readUInt16BE = function readUInt16BE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 2, this.length)
                        return (this[offset] << 8) | this[offset + 1]
                    }

                    Buffer.prototype.readUInt32LE = function readUInt32LE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 4, this.length)

                        return ((this[offset]) |
                                (this[offset + 1] << 8) |
                                (this[offset + 2] << 16)) +
                            (this[offset + 3] * 0x1000000)
                    }

                    Buffer.prototype.readUInt32BE = function readUInt32BE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 4, this.length)

                        return (this[offset] * 0x1000000) +
                            ((this[offset + 1] << 16) |
                                (this[offset + 2] << 8) |
                                this[offset + 3])
                    }

                    Buffer.prototype.readIntLE = function readIntLE(offset, byteLength, noAssert) {
                        offset = offset >>> 0
                        byteLength = byteLength >>> 0
                        if (!noAssert) checkOffset(offset, byteLength, this.length)

                        var val = this[offset]
                        var mul = 1
                        var i = 0
                        while (++i < byteLength && (mul *= 0x100)) {
                            val += this[offset + i] * mul
                        }
                        mul *= 0x80

                        if (val >= mul) val -= Math.pow(2, 8 * byteLength)

                        return val
                    }

                    Buffer.prototype.readIntBE = function readIntBE(offset, byteLength, noAssert) {
                        offset = offset >>> 0
                        byteLength = byteLength >>> 0
                        if (!noAssert) checkOffset(offset, byteLength, this.length)

                        var i = byteLength
                        var mul = 1
                        var val = this[offset + --i]
                        while (i > 0 && (mul *= 0x100)) {
                            val += this[offset + --i] * mul
                        }
                        mul *= 0x80

                        if (val >= mul) val -= Math.pow(2, 8 * byteLength)

                        return val
                    }

                    Buffer.prototype.readInt8 = function readInt8(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 1, this.length)
                        if (!(this[offset] & 0x80)) return (this[offset])
                        return ((0xff - this[offset] + 1) * -1)
                    }

                    Buffer.prototype.readInt16LE = function readInt16LE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 2, this.length)
                        var val = this[offset] | (this[offset + 1] << 8)
                        return (val & 0x8000) ? val | 0xFFFF0000 : val
                    }

                    Buffer.prototype.readInt16BE = function readInt16BE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 2, this.length)
                        var val = this[offset + 1] | (this[offset] << 8)
                        return (val & 0x8000) ? val | 0xFFFF0000 : val
                    }

                    Buffer.prototype.readInt32LE = function readInt32LE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 4, this.length)

                        return (this[offset]) |
                            (this[offset + 1] << 8) |
                            (this[offset + 2] << 16) |
                            (this[offset + 3] << 24)
                    }

                    Buffer.prototype.readInt32BE = function readInt32BE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 4, this.length)

                        return (this[offset] << 24) |
                            (this[offset + 1] << 16) |
                            (this[offset + 2] << 8) |
                            (this[offset + 3])
                    }

                    Buffer.prototype.readFloatLE = function readFloatLE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 4, this.length)
                        return ieee754.read(this, offset, true, 23, 4)
                    }

                    Buffer.prototype.readFloatBE = function readFloatBE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 4, this.length)
                        return ieee754.read(this, offset, false, 23, 4)
                    }

                    Buffer.prototype.readDoubleLE = function readDoubleLE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 8, this.length)
                        return ieee754.read(this, offset, true, 52, 8)
                    }

                    Buffer.prototype.readDoubleBE = function readDoubleBE(offset, noAssert) {
                        offset = offset >>> 0
                        if (!noAssert) checkOffset(offset, 8, this.length)
                        return ieee754.read(this, offset, false, 52, 8)
                    }

                    function checkInt(buf, value, offset, ext, max, min) {
                        if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
                        if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
                        if (offset + ext > buf.length) throw new RangeError('Index out of range')
                    }

                    Buffer.prototype.writeUIntLE = function writeUIntLE(value, offset, byteLength, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        byteLength = byteLength >>> 0
                        if (!noAssert) {
                            var maxBytes = Math.pow(2, 8 * byteLength) - 1
                            checkInt(this, value, offset, byteLength, maxBytes, 0)
                        }

                        var mul = 1
                        var i = 0
                        this[offset] = value & 0xFF
                        while (++i < byteLength && (mul *= 0x100)) {
                            this[offset + i] = (value / mul) & 0xFF
                        }

                        return offset + byteLength
                    }

                    Buffer.prototype.writeUIntBE = function writeUIntBE(value, offset, byteLength, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        byteLength = byteLength >>> 0
                        if (!noAssert) {
                            var maxBytes = Math.pow(2, 8 * byteLength) - 1
                            checkInt(this, value, offset, byteLength, maxBytes, 0)
                        }

                        var i = byteLength - 1
                        var mul = 1
                        this[offset + i] = value & 0xFF
                        while (--i >= 0 && (mul *= 0x100)) {
                            this[offset + i] = (value / mul) & 0xFF
                        }

                        return offset + byteLength
                    }

                    Buffer.prototype.writeUInt8 = function writeUInt8(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
                        this[offset] = (value & 0xff)
                        return offset + 1
                    }

                    Buffer.prototype.writeUInt16LE = function writeUInt16LE(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
                        this[offset] = (value & 0xff)
                        this[offset + 1] = (value >>> 8)
                        return offset + 2
                    }

                    Buffer.prototype.writeUInt16BE = function writeUInt16BE(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
                        this[offset] = (value >>> 8)
                        this[offset + 1] = (value & 0xff)
                        return offset + 2
                    }

                    Buffer.prototype.writeUInt32LE = function writeUInt32LE(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
                        this[offset + 3] = (value >>> 24)
                        this[offset + 2] = (value >>> 16)
                        this[offset + 1] = (value >>> 8)
                        this[offset] = (value & 0xff)
                        return offset + 4
                    }

                    Buffer.prototype.writeUInt32BE = function writeUInt32BE(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
                        this[offset] = (value >>> 24)
                        this[offset + 1] = (value >>> 16)
                        this[offset + 2] = (value >>> 8)
                        this[offset + 3] = (value & 0xff)
                        return offset + 4
                    }

                    Buffer.prototype.writeIntLE = function writeIntLE(value, offset, byteLength, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) {
                            var limit = Math.pow(2, (8 * byteLength) - 1)

                            checkInt(this, value, offset, byteLength, limit - 1, -limit)
                        }

                        var i = 0
                        var mul = 1
                        var sub = 0
                        this[offset] = value & 0xFF
                        while (++i < byteLength && (mul *= 0x100)) {
                            if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
                                sub = 1
                            }
                            this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
                        }

                        return offset + byteLength
                    }

                    Buffer.prototype.writeIntBE = function writeIntBE(value, offset, byteLength, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) {
                            var limit = Math.pow(2, (8 * byteLength) - 1)

                            checkInt(this, value, offset, byteLength, limit - 1, -limit)
                        }

                        var i = byteLength - 1
                        var mul = 1
                        var sub = 0
                        this[offset + i] = value & 0xFF
                        while (--i >= 0 && (mul *= 0x100)) {
                            if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
                                sub = 1
                            }
                            this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
                        }

                        return offset + byteLength
                    }

                    Buffer.prototype.writeInt8 = function writeInt8(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
                        if (value < 0) value = 0xff + value + 1
                        this[offset] = (value & 0xff)
                        return offset + 1
                    }

                    Buffer.prototype.writeInt16LE = function writeInt16LE(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
                        this[offset] = (value & 0xff)
                        this[offset + 1] = (value >>> 8)
                        return offset + 2
                    }

                    Buffer.prototype.writeInt16BE = function writeInt16BE(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
                        this[offset] = (value >>> 8)
                        this[offset + 1] = (value & 0xff)
                        return offset + 2
                    }

                    Buffer.prototype.writeInt32LE = function writeInt32LE(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
                        this[offset] = (value & 0xff)
                        this[offset + 1] = (value >>> 8)
                        this[offset + 2] = (value >>> 16)
                        this[offset + 3] = (value >>> 24)
                        return offset + 4
                    }

                    Buffer.prototype.writeInt32BE = function writeInt32BE(value, offset, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
                        if (value < 0) value = 0xffffffff + value + 1
                        this[offset] = (value >>> 24)
                        this[offset + 1] = (value >>> 16)
                        this[offset + 2] = (value >>> 8)
                        this[offset + 3] = (value & 0xff)
                        return offset + 4
                    }

                    function checkIEEE754(buf, value, offset, ext, max, min) {
                        if (offset + ext > buf.length) throw new RangeError('Index out of range')
                        if (offset < 0) throw new RangeError('Index out of range')
                    }

                    function writeFloat(buf, value, offset, littleEndian, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) {
                            checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
                        }
                        ieee754.write(buf, value, offset, littleEndian, 23, 4)
                        return offset + 4
                    }

                    Buffer.prototype.writeFloatLE = function writeFloatLE(value, offset, noAssert) {
                        return writeFloat(this, value, offset, true, noAssert)
                    }

                    Buffer.prototype.writeFloatBE = function writeFloatBE(value, offset, noAssert) {
                        return writeFloat(this, value, offset, false, noAssert)
                    }

                    function writeDouble(buf, value, offset, littleEndian, noAssert) {
                        value = +value
                        offset = offset >>> 0
                        if (!noAssert) {
                            checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
                        }
                        ieee754.write(buf, value, offset, littleEndian, 52, 8)
                        return offset + 8
                    }

                    Buffer.prototype.writeDoubleLE = function writeDoubleLE(value, offset, noAssert) {
                        return writeDouble(this, value, offset, true, noAssert)
                    }

                    Buffer.prototype.writeDoubleBE = function writeDoubleBE(value, offset, noAssert) {
                        return writeDouble(this, value, offset, false, noAssert)
                    }

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
                    Buffer.prototype.copy = function copy(target, targetStart, start, end) {
                        if (!Buffer.isBuffer(target)) throw new TypeError('argument should be a Buffer')
                        if (!start) start = 0
                        if (!end && end !== 0) end = this.length
                        if (targetStart >= target.length) targetStart = target.length
                        if (!targetStart) targetStart = 0
                        if (end > 0 && end < start) end = start

                        // Copy 0 bytes; we're done
                        if (end === start) return 0
                        if (target.length === 0 || this.length === 0) return 0

                        // Fatal error conditions
                        if (targetStart < 0) {
                            throw new RangeError('targetStart out of bounds')
                        }
                        if (start < 0 || start >= this.length) throw new RangeError('Index out of range')
                        if (end < 0) throw new RangeError('sourceEnd out of bounds')

                        // Are we oob?
                        if (end > this.length) end = this.length
                        if (target.length - targetStart < end - start) {
                            end = target.length - targetStart + start
                        }

                        var len = end - start

                        if (this === target && typeof Uint8Array.prototype.copyWithin === 'function') {
                            // Use built-in when available, missing from IE11
                            this.copyWithin(targetStart, start, end)
                        } else if (this === target && start < targetStart && targetStart < end) {
                            // descending copy from end
                            for (var i = len - 1; i >= 0; --i) {
                                target[i + targetStart] = this[i + start]
                            }
                        } else {
                            Uint8Array.prototype.set.call(
                                target,
                                this.subarray(start, end),
                                targetStart
                            )
                        }

                        return len
                    }

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
                    Buffer.prototype.fill = function fill(val, start, end, encoding) {
                        // Handle string cases:
                        if (typeof val === 'string') {
                            if (typeof start === 'string') {
                                encoding = start
                                start = 0
                                end = this.length
                            } else if (typeof end === 'string') {
                                encoding = end
                                end = this.length
                            }
                            if (encoding !== undefined && typeof encoding !== 'string') {
                                throw new TypeError('encoding must be a string')
                            }
                            if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
                                throw new TypeError('Unknown encoding: ' + encoding)
                            }
                            if (val.length === 1) {
                                var code = val.charCodeAt(0)
                                if ((encoding === 'utf8' && code < 128) ||
                                    encoding === 'latin1') {
                                    // Fast path: If `val` fits into a single byte, use that numeric value.
                                    val = code
                                }
                            }
                        } else if (typeof val === 'number') {
                            val = val & 255
                        }

                        // Invalid ranges are not set to a default, so can range check early.
                        if (start < 0 || this.length < start || this.length < end) {
                            throw new RangeError('Out of range index')
                        }

                        if (end <= start) {
                            return this
                        }

                        start = start >>> 0
                        end = end === undefined ? this.length : end >>> 0

                        if (!val) val = 0

                        var i
                        if (typeof val === 'number') {
                            for (i = start; i < end; ++i) {
                                this[i] = val
                            }
                        } else {
                            var bytes = Buffer.isBuffer(val)
                                ? val
                                : Buffer.from(val, encoding)
                            var len = bytes.length
                            if (len === 0) {
                                throw new TypeError('The value "' + val +
                                    '" is invalid for argument "value"')
                            }
                            for (i = 0; i < end - start; ++i) {
                                this[i + start] = bytes[i % len]
                            }
                        }

                        return this
                    }

// HELPER FUNCTIONS
// ================

                    var INVALID_BASE64_RE = /[^+/0-9A-Za-z-_]/g

                    function base64clean(str) {
                        // Node takes equal signs as end of the Base64 encoding
                        str = str.split('=')[0]
                        // Node strips out invalid characters like \n and \t from the string, base64-js does not
                        str = str.trim().replace(INVALID_BASE64_RE, '')
                        // Node converts strings with length < 2 to ''
                        if (str.length < 2) return ''
                        // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
                        while (str.length % 4 !== 0) {
                            str = str + '='
                        }
                        return str
                    }

                    function toHex(n) {
                        if (n < 16) return '0' + n.toString(16)
                        return n.toString(16)
                    }

                    function utf8ToBytes(string, units) {
                        units = units || Infinity
                        var codePoint
                        var length = string.length
                        var leadSurrogate = null
                        var bytes = []

                        for (var i = 0; i < length; ++i) {
                            codePoint = string.charCodeAt(i)

                            // is surrogate component
                            if (codePoint > 0xD7FF && codePoint < 0xE000) {
                                // last char was a lead
                                if (!leadSurrogate) {
                                    // no lead yet
                                    if (codePoint > 0xDBFF) {
                                        // unexpected trail
                                        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
                                        continue
                                    } else if (i + 1 === length) {
                                        // unpaired lead
                                        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
                                        continue
                                    }

                                    // valid lead
                                    leadSurrogate = codePoint

                                    continue
                                }

                                // 2 leads in a row
                                if (codePoint < 0xDC00) {
                                    if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
                                    leadSurrogate = codePoint
                                    continue
                                }

                                // valid surrogate pair
                                codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
                            } else if (leadSurrogate) {
                                // valid bmp char, but last char was a lead
                                if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
                            }

                            leadSurrogate = null

                            // encode utf8
                            if (codePoint < 0x80) {
                                if ((units -= 1) < 0) break
                                bytes.push(codePoint)
                            } else if (codePoint < 0x800) {
                                if ((units -= 2) < 0) break
                                bytes.push(
                                    codePoint >> 0x6 | 0xC0,
                                    codePoint & 0x3F | 0x80
                                )
                            } else if (codePoint < 0x10000) {
                                if ((units -= 3) < 0) break
                                bytes.push(
                                    codePoint >> 0xC | 0xE0,
                                    codePoint >> 0x6 & 0x3F | 0x80,
                                    codePoint & 0x3F | 0x80
                                )
                            } else if (codePoint < 0x110000) {
                                if ((units -= 4) < 0) break
                                bytes.push(
                                    codePoint >> 0x12 | 0xF0,
                                    codePoint >> 0xC & 0x3F | 0x80,
                                    codePoint >> 0x6 & 0x3F | 0x80,
                                    codePoint & 0x3F | 0x80
                                )
                            } else {
                                throw new Error('Invalid code point')
                            }
                        }

                        return bytes
                    }

                    function asciiToBytes(str) {
                        var byteArray = []
                        for (var i = 0; i < str.length; ++i) {
                            // Node's code seems to be doing this and not & 0x7F..
                            byteArray.push(str.charCodeAt(i) & 0xFF)
                        }
                        return byteArray
                    }

                    function utf16leToBytes(str, units) {
                        var c, hi, lo
                        var byteArray = []
                        for (var i = 0; i < str.length; ++i) {
                            if ((units -= 2) < 0) break

                            c = str.charCodeAt(i)
                            hi = c >> 8
                            lo = c % 256
                            byteArray.push(lo)
                            byteArray.push(hi)
                        }

                        return byteArray
                    }

                    function base64ToBytes(str) {
                        return base64.toByteArray(base64clean(str))
                    }

                    function blitBuffer(src, dst, offset, length) {
                        for (var i = 0; i < length; ++i) {
                            if ((i + offset >= dst.length) || (i >= src.length)) break
                            dst[i + offset] = src[i]
                        }
                        return i
                    }

// ArrayBuffer or Uint8Array objects from other contexts (i.e. iframes) do not pass
// the `instanceof` check but they should be treated as of that type.
// See: https://github.com/feross/buffer/issues/166
                    function isInstance(obj, type) {
                        return obj instanceof type ||
                            (obj != null && obj.constructor != null && obj.constructor.name != null &&
                                obj.constructor.name === type.name)
                    }

                    function numberIsNaN(obj) {
                        // For IE11 support
                        return obj !== obj // eslint-disable-line no-self-compare
                    }

                }).call(this)
            }).call(this, _dereq_("buffer").Buffer)
        }, {"base64-js": 79, "buffer": 85, "ieee754": 230}],
        86: [function (_dereq_, module, exports) {
            module.exports = clamp

            function clamp(value, min, max) {
                return min < max
                    ? (value < min ? min : value > max ? max : value)
                    : (value < max ? max : value > min ? min : value)
            }

        }, {}],
        87: [function (_dereq_, module, exports) {
            /** @module  color-id */

            'use strict'

            var clamp = _dereq_('clamp')

            module.exports = toNumber
            module.exports.to = toNumber
            module.exports.from = fromNumber

            function toNumber(rgba, normalized) {
                if (normalized == null) normalized = true

                var r = rgba[0], g = rgba[1], b = rgba[2], a = rgba[3]

                if (a == null) a = normalized ? 1 : 255

                if (normalized) {
                    r *= 255
                    g *= 255
                    b *= 255
                    a *= 255
                }

                r = clamp(r, 0, 255) & 0xFF
                g = clamp(g, 0, 255) & 0xFF
                b = clamp(b, 0, 255) & 0xFF
                a = clamp(a, 0, 255) & 0xFF

                //hi-order shift converts to -1, so we can't use <<24
                var n = (r * 0x01000000) + (g << 16) + (b << 8) + (a)

                return n
            }

            function fromNumber(n, normalized) {
                n = +n

                var r = n >>> 24
                var g = (n & 0x00ff0000) >>> 16
                var b = (n & 0x0000ff00) >>> 8
                var a = n & 0x000000ff

                if (normalized === false) return [r, g, b, a]

                return [r / 255, g / 255, b / 255, a / 255]
            }

        }, {"clamp": 86}],
        88: [function (_dereq_, module, exports) {
            'use strict'

            module.exports = {
                "aliceblue": [240, 248, 255],
                "antiquewhite": [250, 235, 215],
                "aqua": [0, 255, 255],
                "aquamarine": [127, 255, 212],
                "azure": [240, 255, 255],
                "beige": [245, 245, 220],
                "bisque": [255, 228, 196],
                "black": [0, 0, 0],
                "blanchedalmond": [255, 235, 205],
                "blue": [0, 0, 255],
                "blueviolet": [138, 43, 226],
                "brown": [165, 42, 42],
                "burlywood": [222, 184, 135],
                "cadetblue": [95, 158, 160],
                "chartreuse": [127, 255, 0],
                "chocolate": [210, 105, 30],
                "coral": [255, 127, 80],
                "cornflowerblue": [100, 149, 237],
                "cornsilk": [255, 248, 220],
                "crimson": [220, 20, 60],
                "cyan": [0, 255, 255],
                "darkblue": [0, 0, 139],
                "darkcyan": [0, 139, 139],
                "darkgoldenrod": [184, 134, 11],
                "darkgray": [169, 169, 169],
                "darkgreen": [0, 100, 0],
                "darkgrey": [169, 169, 169],
                "darkkhaki": [189, 183, 107],
                "darkmagenta": [139, 0, 139],
                "darkolivegreen": [85, 107, 47],
                "darkorange": [255, 140, 0],
                "darkorchid": [153, 50, 204],
                "darkred": [139, 0, 0],
                "darksalmon": [233, 150, 122],
                "darkseagreen": [143, 188, 143],
                "darkslateblue": [72, 61, 139],
                "darkslategray": [47, 79, 79],
                "darkslategrey": [47, 79, 79],
                "darkturquoise": [0, 206, 209],
                "darkviolet": [148, 0, 211],
                "deeppink": [255, 20, 147],
                "deepskyblue": [0, 191, 255],
                "dimgray": [105, 105, 105],
                "dimgrey": [105, 105, 105],
                "dodgerblue": [30, 144, 255],
                "firebrick": [178, 34, 34],
                "floralwhite": [255, 250, 240],
                "forestgreen": [34, 139, 34],
                "fuchsia": [255, 0, 255],
                "gainsboro": [220, 220, 220],
                "ghostwhite": [248, 248, 255],
                "gold": [255, 215, 0],
                "goldenrod": [218, 165, 32],
                "gray": [128, 128, 128],
                "green": [0, 128, 0],
                "greenyellow": [173, 255, 47],
                "grey": [128, 128, 128],
                "honeydew": [240, 255, 240],
                "hotpink": [255, 105, 180],
                "indianred": [205, 92, 92],
                "indigo": [75, 0, 130],
                "ivory": [255, 255, 240],
                "khaki": [240, 230, 140],
                "lavender": [230, 230, 250],
                "lavenderblush": [255, 240, 245],
                "lawngreen": [124, 252, 0],
                "lemonchiffon": [255, 250, 205],
                "lightblue": [173, 216, 230],
                "lightcoral": [240, 128, 128],
                "lightcyan": [224, 255, 255],
                "lightgoldenrodyellow": [250, 250, 210],
                "lightgray": [211, 211, 211],
                "lightgreen": [144, 238, 144],
                "lightgrey": [211, 211, 211],
                "lightpink": [255, 182, 193],
                "lightsalmon": [255, 160, 122],
                "lightseagreen": [32, 178, 170],
                "lightskyblue": [135, 206, 250],
                "lightslategray": [119, 136, 153],
                "lightslategrey": [119, 136, 153],
                "lightsteelblue": [176, 196, 222],
                "lightyellow": [255, 255, 224],
                "lime": [0, 255, 0],
                "limegreen": [50, 205, 50],
                "linen": [250, 240, 230],
                "magenta": [255, 0, 255],
                "maroon": [128, 0, 0],
                "mediumaquamarine": [102, 205, 170],
                "mediumblue": [0, 0, 205],
                "mediumorchid": [186, 85, 211],
                "mediumpurple": [147, 112, 219],
                "mediumseagreen": [60, 179, 113],
                "mediumslateblue": [123, 104, 238],
                "mediumspringgreen": [0, 250, 154],
                "mediumturquoise": [72, 209, 204],
                "mediumvioletred": [199, 21, 133],
                "midnightblue": [25, 25, 112],
                "mintcream": [245, 255, 250],
                "mistyrose": [255, 228, 225],
                "moccasin": [255, 228, 181],
                "navajowhite": [255, 222, 173],
                "navy": [0, 0, 128],
                "oldlace": [253, 245, 230],
                "olive": [128, 128, 0],
                "olivedrab": [107, 142, 35],
                "orange": [255, 165, 0],
                "orangered": [255, 69, 0],
                "orchid": [218, 112, 214],
                "palegoldenrod": [238, 232, 170],
                "palegreen": [152, 251, 152],
                "paleturquoise": [175, 238, 238],
                "palevioletred": [219, 112, 147],
                "papayawhip": [255, 239, 213],
                "peachpuff": [255, 218, 185],
                "peru": [205, 133, 63],
                "pink": [255, 192, 203],
                "plum": [221, 160, 221],
                "powderblue": [176, 224, 230],
                "purple": [128, 0, 128],
                "rebeccapurple": [102, 51, 153],
                "red": [255, 0, 0],
                "rosybrown": [188, 143, 143],
                "royalblue": [65, 105, 225],
                "saddlebrown": [139, 69, 19],
                "salmon": [250, 128, 114],
                "sandybrown": [244, 164, 96],
                "seagreen": [46, 139, 87],
                "seashell": [255, 245, 238],
                "sienna": [160, 82, 45],
                "silver": [192, 192, 192],
                "skyblue": [135, 206, 235],
                "slateblue": [106, 90, 205],
                "slategray": [112, 128, 144],
                "slategrey": [112, 128, 144],
                "snow": [255, 250, 250],
                "springgreen": [0, 255, 127],
                "steelblue": [70, 130, 180],
                "tan": [210, 180, 140],
                "teal": [0, 128, 128],
                "thistle": [216, 191, 216],
                "tomato": [255, 99, 71],
                "turquoise": [64, 224, 208],
                "violet": [238, 130, 238],
                "wheat": [245, 222, 179],
                "white": [255, 255, 255],
                "whitesmoke": [245, 245, 245],
                "yellow": [255, 255, 0],
                "yellowgreen": [154, 205, 50]
            };

        }, {}],
        89: [function (_dereq_, module, exports) {
            /** @module  color-normalize */

            'use strict'

            var rgba = _dereq_('color-rgba')
            var clamp = _dereq_('clamp')
            var dtype = _dereq_('dtype')

            module.exports = function normalize(color, type) {
                if (type === 'float' || !type) type = 'array'
                if (type === 'uint') type = 'uint8'
                if (type === 'uint_clamped') type = 'uint8_clamped'
                var Ctor = dtype(type)
                var output = new Ctor(4)

                var normalize = type !== 'uint8' && type !== 'uint8_clamped'

                // attempt to parse non-array arguments
                if (!color.length || typeof color === 'string') {
                    color = rgba(color)
                    color[0] /= 255
                    color[1] /= 255
                    color[2] /= 255
                }

                // 0, 1 are possible contradictory values for Arrays:
                // [1,1,1] input gives [1,1,1] output instead of [1/255,1/255,1/255], which may be collision if input is meant to be uint.
                // converting [1,1,1] to [1/255,1/255,1/255] in case of float input gives larger mistake since [1,1,1] float is frequent edge value, whereas [0,1,1], [1,1,1] etc. uint inputs are relatively rare
                if (isInt(color)) {
                    output[0] = color[0]
                    output[1] = color[1]
                    output[2] = color[2]
                    output[3] = color[3] != null ? color[3] : 255

                    if (normalize) {
                        output[0] /= 255
                        output[1] /= 255
                        output[2] /= 255
                        output[3] /= 255
                    }

                    return output
                }

                if (!normalize) {
                    output[0] = clamp(Math.floor(color[0] * 255), 0, 255)
                    output[1] = clamp(Math.floor(color[1] * 255), 0, 255)
                    output[2] = clamp(Math.floor(color[2] * 255), 0, 255)
                    output[3] = color[3] == null ? 255 : clamp(Math.floor(color[3] * 255), 0, 255)
                } else {
                    output[0] = color[0]
                    output[1] = color[1]
                    output[2] = color[2]
                    output[3] = color[3] != null ? color[3] : 1
                }

                return output
            }

            function isInt(color) {
                if (color instanceof Uint8Array || color instanceof Uint8ClampedArray) return true

                if (Array.isArray(color) &&
                    (color[0] > 1 || color[0] === 0) &&
                    (color[1] > 1 || color[1] === 0) &&
                    (color[2] > 1 || color[2] === 0) &&
                    (!color[3] || color[3] > 1)
                ) return true

                return false
            }

        }, {"clamp": 86, "color-rgba": 91, "dtype": 127}],
        90: [function (_dereq_, module, exports) {
            (function (global) {
                (function () {
                    /**
                     * @module color-parse
                     */

                    'use strict'

                    var names = _dereq_('color-name')
                    var isObject = _dereq_('is-plain-obj')
                    var defined = _dereq_('defined')

                    module.exports = parse

                    /**
                     * Base hues
                     * http://dev.w3.org/csswg/css-color/#typedef-named-hue
                     */
//FIXME: use external hue detector
                    var baseHues = {
                        red: 0,
                        orange: 60,
                        yellow: 120,
                        green: 180,
                        blue: 240,
                        purple: 300
                    }

                    /**
                     * Parse color from the string passed
                     *
                     * @return {Object} A space indicator `space`, an array `values` and `alpha`
                     */
                    function parse(cstr) {
                        var m, parts = [], alpha = 1, space

                        if (typeof cstr === 'string') {
                            //keyword
                            if (names[cstr]) {
                                parts = names[cstr].slice()
                                space = 'rgb'
                            }

                            //reserved words
                            else if (cstr === 'transparent') {
                                alpha = 0
                                space = 'rgb'
                                parts = [0, 0, 0]
                            }

                            //hex
                            else if (/^#[A-Fa-f0-9]+$/.test(cstr)) {
                                var base = cstr.slice(1)
                                var size = base.length
                                var isShort = size <= 4
                                alpha = 1

                                if (isShort) {
                                    parts = [
                                        parseInt(base[0] + base[0], 16),
                                        parseInt(base[1] + base[1], 16),
                                        parseInt(base[2] + base[2], 16)
                                    ]
                                    if (size === 4) {
                                        alpha = parseInt(base[3] + base[3], 16) / 255
                                    }
                                } else {
                                    parts = [
                                        parseInt(base[0] + base[1], 16),
                                        parseInt(base[2] + base[3], 16),
                                        parseInt(base[4] + base[5], 16)
                                    ]
                                    if (size === 8) {
                                        alpha = parseInt(base[6] + base[7], 16) / 255
                                    }
                                }

                                if (!parts[0]) parts[0] = 0
                                if (!parts[1]) parts[1] = 0
                                if (!parts[2]) parts[2] = 0

                                space = 'rgb'
                            }

                            //color space
                            else if (m = /^((?:rgb|hs[lvb]|hwb|cmyk?|xy[zy]|gray|lab|lchu?v?|[ly]uv|lms)a?)\s*\(([^\)]*)\)/.exec(cstr)) {
                                var name = m[1]
                                var isRGB = name === 'rgb'
                                var base = name.replace(/a$/, '')
                                space = base
                                var size = base === 'cmyk' ? 4 : base === 'gray' ? 1 : 3
                                parts = m[2].trim()
                                    .split(/\s*,\s*/)
                                    .map(function (x, i) {
                                        //<percentage>
                                        if (/%$/.test(x)) {
                                            //alpha
                                            if (i === size) return parseFloat(x) / 100
                                            //rgb
                                            if (base === 'rgb') return parseFloat(x) * 255 / 100
                                            return parseFloat(x)
                                        }
                                        //hue
                                        else if (base[i] === 'h') {
                                            //<deg>
                                            if (/deg$/.test(x)) {
                                                return parseFloat(x)
                                            }
                                            //<base-hue>
                                            else if (baseHues[x] !== undefined) {
                                                return baseHues[x]
                                            }
                                        }
                                        return parseFloat(x)
                                    })

                                if (name === base) parts.push(1)
                                alpha = (isRGB) ? 1 : (parts[size] === undefined) ? 1 : parts[size]
                                parts = parts.slice(0, size)
                            }

                            //named channels case
                            else if (cstr.length > 10 && /[0-9](?:\s|\/)/.test(cstr)) {
                                parts = cstr.match(/([0-9]+)/g).map(function (value) {
                                    return parseFloat(value)
                                })

                                space = cstr.match(/([a-z])/ig).join('').toLowerCase()
                            }
                        }

                        //numeric case
                        else if (!isNaN(cstr)) {
                            space = 'rgb'
                            parts = [cstr >>> 16, (cstr & 0x00ff00) >>> 8, cstr & 0x0000ff]
                        }

                        //object case - detects css cases of rgb and hsl
                        else if (isObject(cstr)) {
                            var r = defined(cstr.r, cstr.red, cstr.R, null)

                            if (r !== null) {
                                space = 'rgb'
                                parts = [
                                    r,
                                    defined(cstr.g, cstr.green, cstr.G),
                                    defined(cstr.b, cstr.blue, cstr.B)
                                ]
                            } else {
                                space = 'hsl'
                                parts = [
                                    defined(cstr.h, cstr.hue, cstr.H),
                                    defined(cstr.s, cstr.saturation, cstr.S),
                                    defined(cstr.l, cstr.lightness, cstr.L, cstr.b, cstr.brightness)
                                ]
                            }

                            alpha = defined(cstr.a, cstr.alpha, cstr.opacity, 1)

                            if (cstr.opacity != null) alpha /= 100
                        }

                        //array
                        else if (Array.isArray(cstr) || global.ArrayBuffer && ArrayBuffer.isView && ArrayBuffer.isView(cstr)) {
                            parts = [cstr[0], cstr[1], cstr[2]]
                            space = 'rgb'
                            alpha = cstr.length === 4 ? cstr[3] : 1
                        }

                        return {
                            space: space,
                            values: parts,
                            alpha: alpha
                        }
                    }

                }).call(this)
            }).call(this, typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
        }, {"color-name": 88, "defined": 124, "is-plain-obj": 236}],
        91: [function (_dereq_, module, exports) {
            /** @module  color-rgba */

            'use strict'

            var parse = _dereq_('color-parse')
            var hsl = _dereq_('color-space/hsl')
            var clamp = _dereq_('clamp')

            module.exports = function rgba(color) {
                var values, i, l

                //attempt to parse non-array arguments
                var parsed = parse(color)

                if (!parsed.space) return []

                values = Array(3)
                values[0] = clamp(parsed.values[0], 0, 255)
                values[1] = clamp(parsed.values[1], 0, 255)
                values[2] = clamp(parsed.values[2], 0, 255)

                if (parsed.space[0] === 'h') {
                    values = hsl.rgb(values)
                }

                values.push(clamp(parsed.alpha, 0, 1))

                return values
            }

        }, {"clamp": 86, "color-parse": 90, "color-space/hsl": 92}],
        92: [function (_dereq_, module, exports) {
            /**
             * @module color-space/hsl
             */
            'use strict'

            var rgb = _dereq_('./rgb');

            module.exports = {
                name: 'hsl',
                min: [0, 0, 0],
                max: [360, 100, 100],
                channel: ['hue', 'saturation', 'lightness'],
                alias: ['HSL'],

                rgb: function (hsl) {
                    var h = hsl[0] / 360,
                        s = hsl[1] / 100,
                        l = hsl[2] / 100,
                        t1, t2, t3, rgb, val;

                    if (s === 0) {
                        val = l * 255;
                        return [val, val, val];
                    }

                    if (l < 0.5) {
                        t2 = l * (1 + s);
                    } else {
                        t2 = l + s - l * s;
                    }
                    t1 = 2 * l - t2;

                    rgb = [0, 0, 0];
                    for (var i = 0; i < 3; i++) {
                        t3 = h + 1 / 3 * -(i - 1);
                        if (t3 < 0) {
                            t3++;
                        } else if (t3 > 1) {
                            t3--;
                        }

                        if (6 * t3 < 1) {
                            val = t1 + (t2 - t1) * 6 * t3;
                        } else if (2 * t3 < 1) {
                            val = t2;
                        } else if (3 * t3 < 2) {
                            val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
                        } else {
                            val = t1;
                        }

                        rgb[i] = val * 255;
                    }

                    return rgb;
                }
            };


//extend rgb
            rgb.hsl = function (rgb) {
                var r = rgb[0] / 255,
                    g = rgb[1] / 255,
                    b = rgb[2] / 255,
                    min = Math.min(r, g, b),
                    max = Math.max(r, g, b),
                    delta = max - min,
                    h, s, l;

                if (max === min) {
                    h = 0;
                } else if (r === max) {
                    h = (g - b) / delta;
                } else if (g === max) {
                    h = 2 + (b - r) / delta;
                } else if (b === max) {
                    h = 4 + (r - g) / delta;
                }

                h = Math.min(h * 60, 360);

                if (h < 0) {
                    h += 360;
                }

                l = (min + max) / 2;

                if (max === min) {
                    s = 0;
                } else if (l <= 0.5) {
                    s = delta / (max + min);
                } else {
                    s = delta / (2 - max - min);
                }

                return [h, s * 100, l * 100];
            };

        }, {"./rgb": 93}],
        93: [function (_dereq_, module, exports) {
            /**
             * RGB space.
             *
             * @module  color-space/rgb
             */
            'use strict'

            module.exports = {
                name: 'rgb',
                min: [0, 0, 0],
                max: [255, 255, 255],
                channel: ['red', 'green', 'blue'],
                alias: ['RGB']
            };

        }, {}],
        94: [function (_dereq_, module, exports) {
            module.exports = {
                AFG: 'afghan',
                ALA: '\\b\\wland',
                ALB: 'albania',
                DZA: 'algeria',
                ASM: '^(?=.*americ).*samoa',
                AND: 'andorra',
                AGO: 'angola',
                AIA: 'anguill?a',
                ATA: 'antarctica',
                ATG: 'antigua',
                ARG: 'argentin',
                ARM: 'armenia',
                ABW: '^(?!.*bonaire).*\\baruba',
                AUS: 'australia',
                AUT: '^(?!.*hungary).*austria|\\baustri.*\\bemp',
                AZE: 'azerbaijan',
                BHS: 'bahamas',
                BHR: 'bahrain',
                BGD: 'bangladesh|^(?=.*east).*paki?stan',
                BRB: 'barbados',
                BLR: 'belarus|byelo',
                BEL: '^(?!.*luxem).*belgium',
                BLZ: 'belize|^(?=.*british).*honduras',
                BEN: 'benin|dahome',
                BMU: 'bermuda',
                BTN: 'bhutan',
                BOL: 'bolivia',
                BES: '^(?=.*bonaire).*eustatius|^(?=.*carib).*netherlands|\\bbes.?islands',
                BIH: 'herzegovina|bosnia',
                BWA: 'botswana|bechuana',
                BVT: 'bouvet',
                BRA: 'brazil',
                IOT: 'british.?indian.?ocean',
                BRN: 'brunei',
                BGR: 'bulgaria',
                BFA: 'burkina|\\bfaso|upper.?volta',
                BDI: 'burundi',
                CPV: 'verde',
                KHM: 'cambodia|kampuchea|khmer',
                CMR: 'cameroon',
                CAN: 'canada',
                CYM: 'cayman',
                CAF: '\\bcentral.african.republic',
                TCD: '\\bchad',
                CHL: '\\bchile',
                CHN: '^(?!.*\\bmac)(?!.*\\bhong)(?!.*\\btai)(?!.*\\brep).*china|^(?=.*peo)(?=.*rep).*china',
                CXR: 'christmas',
                CCK: '\\bcocos|keeling',
                COL: 'colombia',
                COM: 'comoro',
                COG: '^(?!.*\\bdem)(?!.*\\bd[\\.]?r)(?!.*kinshasa)(?!.*zaire)(?!.*belg)(?!.*l.opoldville)(?!.*free).*\\bcongo',
                COK: '\\bcook',
                CRI: 'costa.?rica',
                CIV: 'ivoire|ivory',
                HRV: 'croatia',
                CUB: '\\bcuba',
                CUW: '^(?!.*bonaire).*\\bcura(c|Ã§)ao',
                CYP: 'cyprus',
                CSK: 'czechoslovakia',
                CZE: '^(?=.*rep).*czech|czechia|bohemia',
                COD: '\\bdem.*congo|congo.*\\bdem|congo.*\\bd[\\.]?r|\\bd[\\.]?r.*congo|belgian.?congo|congo.?free.?state|kinshasa|zaire|l.opoldville|drc|droc|rdc',
                DNK: 'denmark',
                DJI: 'djibouti',
                DMA: 'dominica(?!n)',
                DOM: 'dominican.rep',
                ECU: 'ecuador',
                EGY: 'egypt',
                SLV: 'el.?salvador',
                GNQ: 'guine.*eq|eq.*guine|^(?=.*span).*guinea',
                ERI: 'eritrea',
                EST: 'estonia',
                ETH: 'ethiopia|abyssinia',
                FLK: 'falkland|malvinas',
                FRO: 'faroe|faeroe',
                FJI: 'fiji',
                FIN: 'finland',
                FRA: '^(?!.*\\bdep)(?!.*martinique).*france|french.?republic|\\bgaul',
                GUF: '^(?=.*french).*guiana',
                PYF: 'french.?polynesia|tahiti',
                ATF: 'french.?southern',
                GAB: 'gabon',
                GMB: 'gambia',
                GEO: '^(?!.*south).*georgia',
                DDR: 'german.?democratic.?republic|democratic.?republic.*germany|east.germany',
                DEU: '^(?!.*east).*germany|^(?=.*\\bfed.*\\brep).*german',
                GHA: 'ghana|gold.?coast',
                GIB: 'gibraltar',
                GRC: 'greece|hellenic|hellas',
                GRL: 'greenland',
                GRD: 'grenada',
                GLP: 'guadeloupe',
                GUM: '\\bguam',
                GTM: 'guatemala',
                GGY: 'guernsey',
                GIN: '^(?!.*eq)(?!.*span)(?!.*bissau)(?!.*portu)(?!.*new).*guinea',
                GNB: 'bissau|^(?=.*portu).*guinea',
                GUY: 'guyana|british.?guiana',
                HTI: 'haiti',
                HMD: 'heard.*mcdonald',
                VAT: 'holy.?see|vatican|papal.?st',
                HND: '^(?!.*brit).*honduras',
                HKG: 'hong.?kong',
                HUN: '^(?!.*austr).*hungary',
                ISL: 'iceland',
                IND: 'india(?!.*ocea)',
                IDN: 'indonesia',
                IRN: '\\biran|persia',
                IRQ: '\\biraq|mesopotamia',
                IRL: '(^ireland)|(^republic.*ireland)',
                IMN: '^(?=.*isle).*\\bman',
                ISR: 'israel',
                ITA: 'italy',
                JAM: 'jamaica',
                JPN: 'japan',
                JEY: 'jersey',
                JOR: 'jordan',
                KAZ: 'kazak',
                KEN: 'kenya|british.?east.?africa|east.?africa.?prot',
                KIR: 'kiribati',
                PRK: '^(?=.*democrat|people|north|d.*p.*.r).*\\bkorea|dprk|korea.*(d.*p.*r)',
                KWT: 'kuwait',
                KGZ: 'kyrgyz|kirghiz',
                LAO: '\\blaos?\\b',
                LVA: 'latvia',
                LBN: 'lebanon',
                LSO: 'lesotho|basuto',
                LBR: 'liberia',
                LBY: 'libya',
                LIE: 'liechtenstein',
                LTU: 'lithuania',
                LUX: '^(?!.*belg).*luxem',
                MAC: 'maca(o|u)',
                MDG: 'madagascar|malagasy',
                MWI: 'malawi|nyasa',
                MYS: 'malaysia',
                MDV: 'maldive',
                MLI: '\\bmali\\b',
                MLT: '\\bmalta',
                MHL: 'marshall',
                MTQ: 'martinique',
                MRT: 'mauritania',
                MUS: 'mauritius',
                MYT: '\\bmayotte',
                MEX: '\\bmexic',
                FSM: 'fed.*micronesia|micronesia.*fed',
                MCO: 'monaco',
                MNG: 'mongolia',
                MNE: '^(?!.*serbia).*montenegro',
                MSR: 'montserrat',
                MAR: 'morocco|\\bmaroc',
                MOZ: 'mozambique',
                MMR: 'myanmar|burma',
                NAM: 'namibia',
                NRU: 'nauru',
                NPL: 'nepal',
                NLD: '^(?!.*\\bant)(?!.*\\bcarib).*netherlands',
                ANT: '^(?=.*\\bant).*(nether|dutch)',
                NCL: 'new.?caledonia',
                NZL: 'new.?zealand',
                NIC: 'nicaragua',
                NER: '\\bniger(?!ia)',
                NGA: 'nigeria',
                NIU: 'niue',
                NFK: 'norfolk',
                MNP: 'mariana',
                NOR: 'norway',
                OMN: '\\boman|trucial',
                PAK: '^(?!.*east).*paki?stan',
                PLW: 'palau',
                PSE: 'palestin|\\bgaza|west.?bank',
                PAN: 'panama',
                PNG: 'papua|new.?guinea',
                PRY: 'paraguay',
                PER: 'peru',
                PHL: 'philippines',
                PCN: 'pitcairn',
                POL: 'poland',
                PRT: 'portugal',
                PRI: 'puerto.?rico',
                QAT: 'qatar',
                KOR: '^(?!.*d.*p.*r)(?!.*democrat)(?!.*people)(?!.*north).*\\bkorea(?!.*d.*p.*r)',
                MDA: 'moldov|b(a|e)ssarabia',
                REU: 'r(e|Ã©)union',
                ROU: 'r(o|u|ou)mania',
                RUS: '\\brussia|soviet.?union|u\\.?s\\.?s\\.?r|socialist.?republics',
                RWA: 'rwanda',
                BLM: 'barth(e|Ã©)lemy',
                SHN: 'helena',
                KNA: 'kitts|\\bnevis',
                LCA: '\\blucia',
                MAF: '^(?=.*collectivity).*martin|^(?=.*france).*martin(?!ique)|^(?=.*french).*martin(?!ique)',
                SPM: 'miquelon',
                VCT: 'vincent',
                WSM: '^(?!.*amer).*samoa',
                SMR: 'san.?marino',
                STP: '\\bs(a|Ã£)o.?tom(e|Ã©)',
                SAU: '\\bsa\\w*.?arabia',
                SEN: 'senegal',
                SRB: '^(?!.*monte).*serbia',
                SYC: 'seychell',
                SLE: 'sierra',
                SGP: 'singapore',
                SXM: '^(?!.*martin)(?!.*saba).*maarten',
                SVK: '^(?!.*cze).*slovak',
                SVN: 'slovenia',
                SLB: 'solomon',
                SOM: 'somali',
                ZAF: 'south.africa|s\\\\..?africa',
                SGS: 'south.?georgia|sandwich',
                SSD: '\\bs\\w*.?sudan',
                ESP: 'spain',
                LKA: 'sri.?lanka|ceylon',
                SDN: '^(?!.*\\bs(?!u)).*sudan',
                SUR: 'surinam|dutch.?guiana',
                SJM: 'svalbard',
                SWZ: 'swaziland',
                SWE: 'sweden',
                CHE: 'switz|swiss',
                SYR: 'syria',
                TWN: 'taiwan|taipei|formosa|^(?!.*peo)(?=.*rep).*china',
                TJK: 'tajik',
                THA: 'thailand|\\bsiam',
                MKD: 'macedonia|fyrom',
                TLS: '^(?=.*leste).*timor|^(?=.*east).*timor',
                TGO: 'togo',
                TKL: 'tokelau',
                TON: 'tonga',
                TTO: 'trinidad|tobago',
                TUN: 'tunisia',
                TUR: 'turkey',
                TKM: 'turkmen',
                TCA: 'turks',
                TUV: 'tuvalu',
                UGA: 'uganda',
                UKR: 'ukrain',
                ARE: 'emirates|^u\\.?a\\.?e\\.?$|united.?arab.?em',
                GBR: 'united.?kingdom|britain|^u\\.?k\\.?$',
                TZA: 'tanzania',
                USA: 'united.?states\\b(?!.*islands)|\\bu\\.?s\\.?a\\.?\\b|^\\s*u\\.?s\\.?\\b(?!.*islands)',
                UMI: 'minor.?outlying.?is',
                URY: 'uruguay',
                UZB: 'uzbek',
                VUT: 'vanuatu|new.?hebrides',
                VEN: 'venezuela',
                VNM: '^(?!.*republic).*viet.?nam|^(?=.*socialist).*viet.?nam',
                VGB: '^(?=.*\\bu\\.?\\s?k).*virgin|^(?=.*brit).*virgin|^(?=.*kingdom).*virgin',
                VIR: '^(?=.*\\bu\\.?\\s?s).*virgin|^(?=.*states).*virgin',
                WLF: 'futuna|wallis',
                ESH: 'western.sahara',
                YEM: '^(?!.*arab)(?!.*north)(?!.*sana)(?!.*peo)(?!.*dem)(?!.*south)(?!.*aden)(?!.*\\bp\\.?d\\.?r).*yemen',
                YMD: '^(?=.*peo).*yemen|^(?!.*rep)(?=.*dem).*yemen|^(?=.*south).*yemen|^(?=.*aden).*yemen|^(?=.*\\bp\\.?d\\.?r).*yemen',
                YUG: 'yugoslavia',
                ZMB: 'zambia|northern.?rhodesia',
                EAZ: 'zanzibar',
                ZWE: 'zimbabwe|^(?!.*northern).*rhodesia'
            }

        }, {}],
        95: [function (_dereq_, module, exports) {
            module.exports = [
                "xx-small",
                "x-small",
                "small",
                "medium",
                "large",
                "x-large",
                "xx-large",
                "larger",
                "smaller"
            ]

        }, {}],
        96: [function (_dereq_, module, exports) {
            module.exports = [
                "normal",
                "condensed",
                "semi-condensed",
                "extra-condensed",
                "ultra-condensed",
                "expanded",
                "semi-expanded",
                "extra-expanded",
                "ultra-expanded"
            ]

        }, {}],
        97: [function (_dereq_, module, exports) {
            module.exports = [
                "normal",
                "italic",
                "oblique"
            ]

        }, {}],
        98: [function (_dereq_, module, exports) {
            module.exports = [
                "normal",
                "bold",
                "bolder",
                "lighter",
                "100",
                "200",
                "300",
                "400",
                "500",
                "600",
                "700",
                "800",
                "900"
            ]

        }, {}],
        99: [function (_dereq_, module, exports) {
            'use strict'

            module.exports = {
                parse: _dereq_('./parse'),
                stringify: _dereq_('./stringify')
            }

        }, {"./parse": 101, "./stringify": 102}],
        100: [function (_dereq_, module, exports) {
            'use strict'

            var sizes = _dereq_('css-font-size-keywords')

            module.exports = {
                isSize: function isSize(value) {
                    return /^[\d\.]/.test(value)
                        || value.indexOf('/') !== -1
                        || sizes.indexOf(value) !== -1
                }
            }

        }, {"css-font-size-keywords": 95}],
        101: [function (_dereq_, module, exports) {
            'use strict'

            var unquote = _dereq_('unquote')
            var globalKeywords = _dereq_('css-global-keywords')
            var systemFontKeywords = _dereq_('css-system-font-keywords')
            var fontWeightKeywords = _dereq_('css-font-weight-keywords')
            var fontStyleKeywords = _dereq_('css-font-style-keywords')
            var fontStretchKeywords = _dereq_('css-font-stretch-keywords')
            var splitBy = _dereq_('string-split-by')
            var isSize = _dereq_('./lib/util').isSize


            module.exports = parseFont


            var cache = parseFont.cache = {}


            function parseFont(value) {
                if (typeof value !== 'string') throw new Error('Font argument must be a string.')

                if (cache[value]) return cache[value]

                if (value === '') {
                    throw new Error('Cannot parse an empty string.')
                }

                if (systemFontKeywords.indexOf(value) !== -1) {
                    return cache[value] = {system: value}
                }

                var font = {
                    style: 'normal',
                    variant: 'normal',
                    weight: 'normal',
                    stretch: 'normal',
                    lineHeight: 'normal',
                    size: '1rem',
                    family: ['serif']
                }

                var tokens = splitBy(value, /\s+/)
                var token

                while (token = tokens.shift()) {
                    if (globalKeywords.indexOf(token) !== -1) {
                        ['style', 'variant', 'weight', 'stretch'].forEach(function (prop) {
                            font[prop] = token
                        })

                        return cache[value] = font
                    }

                    if (fontStyleKeywords.indexOf(token) !== -1) {
                        font.style = token
                        continue
                    }

                    if (token === 'normal' || token === 'small-caps') {
                        font.variant = token
                        continue
                    }

                    if (fontStretchKeywords.indexOf(token) !== -1) {
                        font.stretch = token
                        continue
                    }

                    if (fontWeightKeywords.indexOf(token) !== -1) {
                        font.weight = token
                        continue
                    }


                    if (isSize(token)) {
                        var parts = splitBy(token, '/')
                        font.size = parts[0]
                        if (parts[1] != null) {
                            font.lineHeight = parseLineHeight(parts[1])
                        } else if (tokens[0] === '/') {
                            tokens.shift()
                            font.lineHeight = parseLineHeight(tokens.shift())
                        }

                        if (!tokens.length) {
                            throw new Error('Missing required font-family.')
                        }
                        font.family = splitBy(tokens.join(' '), /\s*,\s*/).map(unquote)

                        return cache[value] = font
                    }

                    throw new Error('Unknown or unsupported font token: ' + token)
                }

                throw new Error('Missing required font-size.')
            }


            function parseLineHeight(value) {
                var parsed = parseFloat(value)
                if (parsed.toString() === value) {
                    return parsed
                }
                return value
            }

        }, {
            "./lib/util": 100,
            "css-font-stretch-keywords": 96,
            "css-font-style-keywords": 97,
            "css-font-weight-keywords": 98,
            "css-global-keywords": 103,
            "css-system-font-keywords": 104,
            "string-split-by": 305,
            "unquote": 328
        }],
        102: [function (_dereq_, module, exports) {
            'use strict'

            var pick = _dereq_('pick-by-alias')
            var isSize = _dereq_('./lib/util').isSize

            var globals = a2o(_dereq_('css-global-keywords'))
            var systems = a2o(_dereq_('css-system-font-keywords'))
            var weights = a2o(_dereq_('css-font-weight-keywords'))
            var styles = a2o(_dereq_('css-font-style-keywords'))
            var stretches = a2o(_dereq_('css-font-stretch-keywords'))

            var variants = {'normal': 1, 'small-caps': 1}
            var fams = {
                'serif': 1,
                'sans-serif': 1,
                'monospace': 1,
                'cursive': 1,
                'fantasy': 1,
                'system-ui': 1
            }

            var defaults = {
                style: 'normal',
                variant: 'normal',
                weight: 'normal',
                stretch: 'normal',
                size: '1rem',
                lineHeight: 'normal',
                family: 'serif'
            }

            module.exports = function stringifyFont(o) {
                o = pick(o, {
                    style: 'style fontstyle fontStyle font-style slope distinction',
                    variant: 'variant font-variant fontVariant fontvariant var capitalization',
                    weight: 'weight w font-weight fontWeight fontweight',
                    stretch: 'stretch font-stretch fontStretch fontstretch width',
                    size: 'size s font-size fontSize fontsize height em emSize',
                    lineHeight: 'lh line-height lineHeight lineheight leading',
                    family: 'font family fontFamily font-family fontfamily type typeface face',
                    system: 'system reserved default global',
                })

                if (o.system) {
                    if (o.system) verify(o.system, systems)
                    return o.system
                }

                verify(o.style, styles)
                verify(o.variant, variants)
                verify(o.weight, weights)
                verify(o.stretch, stretches)

                // default root value is medium, but by default it's inherited
                if (o.size == null) o.size = defaults.size
                if (typeof o.size === 'number') o.size += 'px'

                if (!isSize) throw Error('Bad size value `' + o.size + '`')

                // many user-agents use serif, we don't detect that for consistency
                if (!o.family) o.family = defaults.family
                if (Array.isArray(o.family)) {
                    if (!o.family.length) o.family = [defaults.family]
                    o.family = o.family.map(function (f) {
                        return fams[f] ? f : '"' + f + '"'
                    }).join(', ')
                }

                // [ [ <'font-style'> || <font-variant-css21> || <'font-weight'> || <'font-stretch'> ]? <'font-size'> [ / <'line-height'> ]? <'font-family'> ]
                var result = []

                result.push(o.style)
                if (o.variant !== o.style) result.push(o.variant)

                if (o.weight !== o.variant &&
                    o.weight !== o.style) result.push(o.weight)

                if (o.stretch !== o.weight &&
                    o.stretch !== o.variant &&
                    o.stretch !== o.style) result.push(o.stretch)

                result.push(o.size + (o.lineHeight == null || o.lineHeight === 'normal' || (o.lineHeight + '' === '1') ? '' : ('/' + o.lineHeight)))
                result.push(o.family)

                return result.filter(Boolean).join(' ')
            }

            function verify(value, values) {
                if (value && !values[value] && !globals[value]) throw Error('Unknown keyword `' + value + '`')

                return value
            }


// ['a', 'b'] -> {a: true, b: true}
            function a2o(a) {
                var o = {}
                for (var i = 0; i < a.length; i++) {
                    o[a[i]] = 1
                }
                return o
            }

        }, {
            "./lib/util": 100,
            "css-font-stretch-keywords": 96,
            "css-font-style-keywords": 97,
            "css-font-weight-keywords": 98,
            "css-global-keywords": 103,
            "css-system-font-keywords": 104,
            "pick-by-alias": 253
        }],
        103: [function (_dereq_, module, exports) {
            module.exports = [
                "inherit",
                "initial",
                "unset"
            ]

        }, {}],
        104: [function (_dereq_, module, exports) {
            module.exports = [
                "caption",
                "icon",
                "menu",
                "message-box",
                "small-caption",
                "status-bar"
            ]

        }, {}],
        105: [function (_dereq_, module, exports) {
            "use strict";

            var isValue = _dereq_("type/value/is")
                , ensureValue = _dereq_("type/value/ensure")
                , ensurePlainFunction = _dereq_("type/plain-function/ensure")
                , copy = _dereq_("es5-ext/object/copy")
                , normalizeOptions = _dereq_("es5-ext/object/normalize-options")
                , map = _dereq_("es5-ext/object/map");

            var bind = Function.prototype.bind
                , defineProperty = Object.defineProperty
                , hasOwnProperty = Object.prototype.hasOwnProperty
                , define;

            define = function (name, desc, options) {
                var value = ensureValue(desc) && ensurePlainFunction(desc.value),
                    dgs;
                dgs = copy(desc);
                delete dgs.writable;
                delete dgs.value;
                dgs.get = function () {
                    if (!options.overwriteDefinition && hasOwnProperty.call(this, name)) return value;
                    desc.value = bind.call(value, options.resolveContext ? options.resolveContext(this) : this);
                    defineProperty(this, name, desc);
                    return this[name];
                };
                return dgs;
            };

            module.exports = function (props/*, options*/) {
                var options = normalizeOptions(arguments[1]);
                if (isValue(options.resolveContext)) ensurePlainFunction(options.resolveContext);
                return map(props, function (desc, name) {
                    return define(name, desc, options);
                });
            };

        }, {
            "es5-ext/object/copy": 147,
            "es5-ext/object/map": 155,
            "es5-ext/object/normalize-options": 156,
            "type/plain-function/ensure": 321,
            "type/value/ensure": 325,
            "type/value/is": 326
        }],
        106: [function (_dereq_, module, exports) {
            "use strict";

            var isValue = _dereq_("type/value/is")
                , isPlainFunction = _dereq_("type/plain-function/is")
                , assign = _dereq_("es5-ext/object/assign")
                , normalizeOpts = _dereq_("es5-ext/object/normalize-options")
                , contains = _dereq_("es5-ext/string/#/contains");

            var d = (module.exports = function (dscr, value/*, options*/) {
                var c, e, w, options, desc;
                if (arguments.length < 2 || typeof dscr !== "string") {
                    options = value;
                    value = dscr;
                    dscr = null;
                } else {
                    options = arguments[2];
                }
                if (isValue(dscr)) {
                    c = contains.call(dscr, "c");
                    e = contains.call(dscr, "e");
                    w = contains.call(dscr, "w");
                } else {
                    c = w = true;
                    e = false;
                }

                desc = {
                    value: value,
                    configurable: c,
                    enumerable: e,
                    writable: w
                };
                return !options ? desc : assign(normalizeOpts(options), desc);
            });

            d.gs = function (dscr, get, set/*, options*/) {
                var c, e, options, desc;
                if (typeof dscr !== "string") {
                    options = set;
                    set = get;
                    get = dscr;
                    dscr = null;
                } else {
                    options = arguments[3];
                }
                if (!isValue(get)) {
                    get = undefined;
                } else if (!isPlainFunction(get)) {
                    options = get;
                    get = set = undefined;
                } else if (!isValue(set)) {
                    set = undefined;
                } else if (!isPlainFunction(set)) {
                    options = set;
                    set = undefined;
                }
                if (isValue(dscr)) {
                    c = contains.call(dscr, "c");
                    e = contains.call(dscr, "e");
                } else {
                    c = true;
                    e = false;
                }

                desc = {get: get, set: set, configurable: c, enumerable: e};
                return !options ? desc : assign(normalizeOpts(options), desc);
            };

        }, {
            "es5-ext/object/assign": 144,
            "es5-ext/object/normalize-options": 156,
            "es5-ext/string/#/contains": 163,
            "type/plain-function/is": 322,
            "type/value/is": 326
        }],
        107: [function (_dereq_, module, exports) {
// https://d3js.org/d3-array/ v1.2.4 Copyright 2018 Mike Bostock
            (function (global, factory) {
                typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
                    typeof define === 'function' && define.amd ? define(['exports'], factory) :
                        (factory((global.d3 = global.d3 || {})));
            }(this, (function (exports) {
                'use strict';

                function ascending(a, b) {
                    return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
                }

                function bisector(compare) {
                    if (compare.length === 1) compare = ascendingComparator(compare);
                    return {
                        left: function (a, x, lo, hi) {
                            if (lo == null) lo = 0;
                            if (hi == null) hi = a.length;
                            while (lo < hi) {
                                var mid = lo + hi >>> 1;
                                if (compare(a[mid], x) < 0) lo = mid + 1;
                                else hi = mid;
                            }
                            return lo;
                        },
                        right: function (a, x, lo, hi) {
                            if (lo == null) lo = 0;
                            if (hi == null) hi = a.length;
                            while (lo < hi) {
                                var mid = lo + hi >>> 1;
                                if (compare(a[mid], x) > 0) hi = mid;
                                else lo = mid + 1;
                            }
                            return lo;
                        }
                    };
                }

                function ascendingComparator(f) {
                    return function (d, x) {
                        return ascending(f(d), x);
                    };
                }

                var ascendingBisect = bisector(ascending);
                var bisectRight = ascendingBisect.right;
                var bisectLeft = ascendingBisect.left;

                function pairs(array, f) {
                    if (f == null) f = pair;
                    var i = 0, n = array.length - 1, p = array[0],
                        pairs = new Array(n < 0 ? 0 : n);
                    while (i < n) pairs[i] = f(p, p = array[++i]);
                    return pairs;
                }

                function pair(a, b) {
                    return [a, b];
                }

                function cross(values0, values1, reduce) {
                    var n0 = values0.length,
                        n1 = values1.length,
                        values = new Array(n0 * n1),
                        i0,
                        i1,
                        i,
                        value0;

                    if (reduce == null) reduce = pair;

                    for (i0 = i = 0; i0 < n0; ++i0) {
                        for (value0 = values0[i0], i1 = 0; i1 < n1; ++i1, ++i) {
                            values[i] = reduce(value0, values1[i1]);
                        }
                    }

                    return values;
                }

                function descending(a, b) {
                    return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
                }

                function number(x) {
                    return x === null ? NaN : +x;
                }

                function variance(values, valueof) {
                    var n = values.length,
                        m = 0,
                        i = -1,
                        mean = 0,
                        value,
                        delta,
                        sum = 0;

                    if (valueof == null) {
                        while (++i < n) {
                            if (!isNaN(value = number(values[i]))) {
                                delta = value - mean;
                                mean += delta / ++m;
                                sum += delta * (value - mean);
                            }
                        }
                    } else {
                        while (++i < n) {
                            if (!isNaN(value = number(valueof(values[i], i, values)))) {
                                delta = value - mean;
                                mean += delta / ++m;
                                sum += delta * (value - mean);
                            }
                        }
                    }

                    if (m > 1) return sum / (m - 1);
                }

                function deviation(array, f) {
                    var v = variance(array, f);
                    return v ? Math.sqrt(v) : v;
                }

                function extent(values, valueof) {
                    var n = values.length,
                        i = -1,
                        value,
                        min,
                        max;

                    if (valueof == null) {
                        while (++i < n) { // Find the first comparable value.
                            if ((value = values[i]) != null && value >= value) {
                                min = max = value;
                                while (++i < n) { // Compare the remaining values.
                                    if ((value = values[i]) != null) {
                                        if (min > value) min = value;
                                        if (max < value) max = value;
                                    }
                                }
                            }
                        }
                    } else {
                        while (++i < n) { // Find the first comparable value.
                            if ((value = valueof(values[i], i, values)) != null && value >= value) {
                                min = max = value;
                                while (++i < n) { // Compare the remaining values.
                                    if ((value = valueof(values[i], i, values)) != null) {
                                        if (min > value) min = value;
                                        if (max < value) max = value;
                                    }
                                }
                            }
                        }
                    }

                    return [min, max];
                }

                var array = Array.prototype;

                var slice = array.slice;
                var map = array.map;

                function constant(x) {
                    return function () {
                        return x;
                    };
                }

                function identity(x) {
                    return x;
                }

                function range(start, stop, step) {
                    start = +start, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start, start = 0, 1) : n < 3 ? 1 : +step;

                    var i = -1,
                        n = Math.max(0, Math.ceil((stop - start) / step)) | 0,
                        range = new Array(n);

                    while (++i < n) {
                        range[i] = start + i * step;
                    }

                    return range;
                }

                var e10 = Math.sqrt(50),
                    e5 = Math.sqrt(10),
                    e2 = Math.sqrt(2);

                function ticks(start, stop, count) {
                    var reverse,
                        i = -1,
                        n,
                        ticks,
                        step;

                    stop = +stop, start = +start, count = +count;
                    if (start === stop && count > 0) return [start];
                    if (reverse = stop < start) n = start, start = stop, stop = n;
                    if ((step = tickIncrement(start, stop, count)) === 0 || !isFinite(step)) return [];

                    if (step > 0) {
                        start = Math.ceil(start / step);
                        stop = Math.floor(stop / step);
                        ticks = new Array(n = Math.ceil(stop - start + 1));
                        while (++i < n) ticks[i] = (start + i) * step;
                    } else {
                        start = Math.floor(start * step);
                        stop = Math.ceil(stop * step);
                        ticks = new Array(n = Math.ceil(start - stop + 1));
                        while (++i < n) ticks[i] = (start - i) / step;
                    }

                    if (reverse) ticks.reverse();

                    return ticks;
                }

                function tickIncrement(start, stop, count) {
                    var step = (stop - start) / Math.max(0, count),
                        power = Math.floor(Math.log(step) / Math.LN10),
                        error = step / Math.pow(10, power);
                    return power >= 0
                        ? (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1) * Math.pow(10, power)
                        : -Math.pow(10, -power) / (error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1);
                }

                function tickStep(start, stop, count) {
                    var step0 = Math.abs(stop - start) / Math.max(0, count),
                        step1 = Math.pow(10, Math.floor(Math.log(step0) / Math.LN10)),
                        error = step0 / step1;
                    if (error >= e10) step1 *= 10;
                    else if (error >= e5) step1 *= 5;
                    else if (error >= e2) step1 *= 2;
                    return stop < start ? -step1 : step1;
                }

                function sturges(values) {
                    return Math.ceil(Math.log(values.length) / Math.LN2) + 1;
                }

                function histogram() {
                    var value = identity,
                        domain = extent,
                        threshold = sturges;

                    function histogram(data) {
                        var i,
                            n = data.length,
                            x,
                            values = new Array(n);

                        for (i = 0; i < n; ++i) {
                            values[i] = value(data[i], i, data);
                        }

                        var xz = domain(values),
                            x0 = xz[0],
                            x1 = xz[1],
                            tz = threshold(values, x0, x1);

                        // Convert number of thresholds into uniform thresholds.
                        if (!Array.isArray(tz)) {
                            tz = tickStep(x0, x1, tz);
                            tz = range(Math.ceil(x0 / tz) * tz, x1, tz); // exclusive
                        }

                        // Remove any thresholds outside the domain.
                        var m = tz.length;
                        while (tz[0] <= x0) tz.shift(), --m;
                        while (tz[m - 1] > x1) tz.pop(), --m;

                        var bins = new Array(m + 1),
                            bin;

                        // Initialize bins.
                        for (i = 0; i <= m; ++i) {
                            bin = bins[i] = [];
                            bin.x0 = i > 0 ? tz[i - 1] : x0;
                            bin.x1 = i < m ? tz[i] : x1;
                        }

                        // Assign data to bins by value, ignoring any outside the domain.
                        for (i = 0; i < n; ++i) {
                            x = values[i];
                            if (x0 <= x && x <= x1) {
                                bins[bisectRight(tz, x, 0, m)].push(data[i]);
                            }
                        }

                        return bins;
                    }

                    histogram.value = function (_) {
                        return arguments.length ? (value = typeof _ === "function" ? _ : constant(_), histogram) : value;
                    };

                    histogram.domain = function (_) {
                        return arguments.length ? (domain = typeof _ === "function" ? _ : constant([_[0], _[1]]), histogram) : domain;
                    };

                    histogram.thresholds = function (_) {
                        return arguments.length ? (threshold = typeof _ === "function" ? _ : Array.isArray(_) ? constant(slice.call(_)) : constant(_), histogram) : threshold;
                    };

                    return histogram;
                }

                function quantile(values, p, valueof) {
                    if (valueof == null) valueof = number;
                    if (!(n = values.length)) return;
                    if ((p = +p) <= 0 || n < 2) return +valueof(values[0], 0, values);
                    if (p >= 1) return +valueof(values[n - 1], n - 1, values);
                    var n,
                        i = (n - 1) * p,
                        i0 = Math.floor(i),
                        value0 = +valueof(values[i0], i0, values),
                        value1 = +valueof(values[i0 + 1], i0 + 1, values);
                    return value0 + (value1 - value0) * (i - i0);
                }

                function freedmanDiaconis(values, min, max) {
                    values = map.call(values, number).sort(ascending);
                    return Math.ceil((max - min) / (2 * (quantile(values, 0.75) - quantile(values, 0.25)) * Math.pow(values.length, -1 / 3)));
                }

                function scott(values, min, max) {
                    return Math.ceil((max - min) / (3.5 * deviation(values) * Math.pow(values.length, -1 / 3)));
                }

                function max(values, valueof) {
                    var n = values.length,
                        i = -1,
                        value,
                        max;

                    if (valueof == null) {
                        while (++i < n) { // Find the first comparable value.
                            if ((value = values[i]) != null && value >= value) {
                                max = value;
                                while (++i < n) { // Compare the remaining values.
                                    if ((value = values[i]) != null && value > max) {
                                        max = value;
                                    }
                                }
                            }
                        }
                    } else {
                        while (++i < n) { // Find the first comparable value.
                            if ((value = valueof(values[i], i, values)) != null && value >= value) {
                                max = value;
                                while (++i < n) { // Compare the remaining values.
                                    if ((value = valueof(values[i], i, values)) != null && value > max) {
                                        max = value;
                                    }
                                }
                            }
                        }
                    }

                    return max;
                }

                function mean(values, valueof) {
                    var n = values.length,
                        m = n,
                        i = -1,
                        value,
                        sum = 0;

                    if (valueof == null) {
                        while (++i < n) {
                            if (!isNaN(value = number(values[i]))) sum += value;
                            else --m;
                        }
                    } else {
                        while (++i < n) {
                            if (!isNaN(value = number(valueof(values[i], i, values)))) sum += value;
                            else --m;
                        }
                    }

                    if (m) return sum / m;
                }

                function median(values, valueof) {
                    var n = values.length,
                        i = -1,
                        value,
                        numbers = [];

                    if (valueof == null) {
                        while (++i < n) {
                            if (!isNaN(value = number(values[i]))) {
                                numbers.push(value);
                            }
                        }
                    } else {
                        while (++i < n) {
                            if (!isNaN(value = number(valueof(values[i], i, values)))) {
                                numbers.push(value);
                            }
                        }
                    }

                    return quantile(numbers.sort(ascending), 0.5);
                }

                function merge(arrays) {
                    var n = arrays.length,
                        m,
                        i = -1,
                        j = 0,
                        merged,
                        array;

                    while (++i < n) j += arrays[i].length;
                    merged = new Array(j);

                    while (--n >= 0) {
                        array = arrays[n];
                        m = array.length;
                        while (--m >= 0) {
                            merged[--j] = array[m];
                        }
                    }

                    return merged;
                }

                function min(values, valueof) {
                    var n = values.length,
                        i = -1,
                        value,
                        min;

                    if (valueof == null) {
                        while (++i < n) { // Find the first comparable value.
                            if ((value = values[i]) != null && value >= value) {
                                min = value;
                                while (++i < n) { // Compare the remaining values.
                                    if ((value = values[i]) != null && min > value) {
                                        min = value;
                                    }
                                }
                            }
                        }
                    } else {
                        while (++i < n) { // Find the first comparable value.
                            if ((value = valueof(values[i], i, values)) != null && value >= value) {
                                min = value;
                                while (++i < n) { // Compare the remaining values.
                                    if ((value = valueof(values[i], i, values)) != null && min > value) {
                                        min = value;
                                    }
                                }
                            }
                        }
                    }

                    return min;
                }

                function permute(array, indexes) {
                    var i = indexes.length, permutes = new Array(i);
                    while (i--) permutes[i] = array[indexes[i]];
                    return permutes;
                }

                function scan(values, compare) {
                    if (!(n = values.length)) return;
                    var n,
                        i = 0,
                        j = 0,
                        xi,
                        xj = values[j];

                    if (compare == null) compare = ascending;

                    while (++i < n) {
                        if (compare(xi = values[i], xj) < 0 || compare(xj, xj) !== 0) {
                            xj = xi, j = i;
                        }
                    }

                    if (compare(xj, xj) === 0) return j;
                }

                function shuffle(array, i0, i1) {
                    var m = (i1 == null ? array.length : i1) - (i0 = i0 == null ? 0 : +i0),
                        t,
                        i;

                    while (m) {
                        i = Math.random() * m-- | 0;
                        t = array[m + i0];
                        array[m + i0] = array[i + i0];
                        array[i + i0] = t;
                    }

                    return array;
                }

                function sum(values, valueof) {
                    var n = values.length,
                        i = -1,
                        value,
                        sum = 0;

                    if (valueof == null) {
                        while (++i < n) {
                            if (value = +values[i]) sum += value; // Note: zero and null are equivalent.
                        }
                    } else {
                        while (++i < n) {
                            if (value = +valueof(values[i], i, values)) sum += value;
                        }
                    }

                    return sum;
                }

                function transpose(matrix) {
                    if (!(n = matrix.length)) return [];
                    for (var i = -1, m = min(matrix, length), transpose = new Array(m); ++i < m;) {
                        for (var j = -1, n, row = transpose[i] = new Array(n); ++j < n;) {
                            row[j] = matrix[j][i];
                        }
                    }
                    return transpose;
                }

                function length(d) {
                    return d.length;
                }

                function zip() {
                    return transpose(arguments);
                }

                exports.bisect = bisectRight;
                exports.bisectRight = bisectRight;
                exports.bisectLeft = bisectLeft;
                exports.ascending = ascending;
                exports.bisector = bisector;
                exports.cross = cross;
                exports.descending = descending;
                exports.deviation = deviation;
                exports.extent = extent;
                exports.histogram = histogram;
                exports.thresholdFreedmanDiaconis = freedmanDiaconis;
                exports.thresholdScott = scott;
                exports.thresholdSturges = sturges;
                exports.max = max;
                exports.mean = mean;
                exports.median = median;
                exports.merge = merge;
                exports.min = min;
                exports.pairs = pairs;
                exports.permute = permute;
                exports.quantile = quantile;
                exports.range = range;
                exports.scan = scan;
                exports.shuffle = shuffle;
                exports.sum = sum;
                exports.ticks = ticks;
                exports.tickIncrement = tickIncrement;
                exports.tickStep = tickStep;
                exports.transpose = transpose;
                exports.variance = variance;
                exports.zip = zip;

                Object.defineProperty(exports, '__esModule', {value: true});

            })));

        }, {}],
        108: [function (_dereq_, module, exports) {
// https://d3js.org/d3-collection/ v1.0.7 Copyright 2018 Mike Bostock
            (function (global, factory) {
                typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
                    typeof define === 'function' && define.amd ? define(['exports'], factory) :
                        (factory((global.d3 = global.d3 || {})));
            }(this, (function (exports) {
                'use strict';

                var prefix = "$";

                function Map() {
                }

                Map.prototype = map.prototype = {
                    constructor: Map,
                    has: function (key) {
                        return (prefix + key) in this;
                    },
                    get: function (key) {
                        return this[prefix + key];
                    },
                    set: function (key, value) {
                        this[prefix + key] = value;
                        return this;
                    },
                    remove: function (key) {
                        var property = prefix + key;
                        return property in this && delete this[property];
                    },
                    clear: function () {
                        for (var property in this) if (property[0] === prefix) delete this[property];
                    },
                    keys: function () {
                        var keys = [];
                        for (var property in this) if (property[0] === prefix) keys.push(property.slice(1));
                        return keys;
                    },
                    values: function () {
                        var values = [];
                        for (var property in this) if (property[0] === prefix) values.push(this[property]);
                        return values;
                    },
                    entries: function () {
                        var entries = [];
                        for (var property in this) if (property[0] === prefix) entries.push({
                            key: property.slice(1),
                            value: this[property]
                        });
                        return entries;
                    },
                    size: function () {
                        var size = 0;
                        for (var property in this) if (property[0] === prefix) ++size;
                        return size;
                    },
                    empty: function () {
                        for (var property in this) if (property[0] === prefix) return false;
                        return true;
                    },
                    each: function (f) {
                        for (var property in this) if (property[0] === prefix) f(this[property], property.slice(1), this);
                    }
                };

                function map(object, f) {
                    var map = new Map;

                    // Copy constructor.
                    if (object instanceof Map) object.each(function (value, key) {
                        map.set(key, value);
                    });

                    // Index array by numeric index or specified key function.
                    else if (Array.isArray(object)) {
                        var i = -1,
                            n = object.length,
                            o;

                        if (f == null) while (++i < n) map.set(i, object[i]);
                        else while (++i < n) map.set(f(o = object[i], i, object), o);
                    }

                    // Convert object to map.
                    else if (object) for (var key in object) map.set(key, object[key]);

                    return map;
                }

                function nest() {
                    var keys = [],
                        sortKeys = [],
                        sortValues,
                        rollup,
                        nest;

                    function apply(array, depth, createResult, setResult) {
                        if (depth >= keys.length) {
                            if (sortValues != null) array.sort(sortValues);
                            return rollup != null ? rollup(array) : array;
                        }

                        var i = -1,
                            n = array.length,
                            key = keys[depth++],
                            keyValue,
                            value,
                            valuesByKey = map(),
                            values,
                            result = createResult();

                        while (++i < n) {
                            if (values = valuesByKey.get(keyValue = key(value = array[i]) + "")) {
                                values.push(value);
                            } else {
                                valuesByKey.set(keyValue, [value]);
                            }
                        }

                        valuesByKey.each(function (values, key) {
                            setResult(result, key, apply(values, depth, createResult, setResult));
                        });

                        return result;
                    }

                    function entries(map$$1, depth) {
                        if (++depth > keys.length) return map$$1;
                        var array, sortKey = sortKeys[depth - 1];
                        if (rollup != null && depth >= keys.length) array = map$$1.entries();
                        else array = [], map$$1.each(function (v, k) {
                            array.push({key: k, values: entries(v, depth)});
                        });
                        return sortKey != null ? array.sort(function (a, b) {
                            return sortKey(a.key, b.key);
                        }) : array;
                    }

                    return nest = {
                        object: function (array) {
                            return apply(array, 0, createObject, setObject);
                        },
                        map: function (array) {
                            return apply(array, 0, createMap, setMap);
                        },
                        entries: function (array) {
                            return entries(apply(array, 0, createMap, setMap), 0);
                        },
                        key: function (d) {
                            keys.push(d);
                            return nest;
                        },
                        sortKeys: function (order) {
                            sortKeys[keys.length - 1] = order;
                            return nest;
                        },
                        sortValues: function (order) {
                            sortValues = order;
                            return nest;
                        },
                        rollup: function (f) {
                            rollup = f;
                            return nest;
                        }
                    };
                }

                function createObject() {
                    return {};
                }

                function setObject(object, key, value) {
                    object[key] = value;
                }

                function createMap() {
                    return map();
                }

                function setMap(map$$1, key, value) {
                    map$$1.set(key, value);
                }

                function Set() {
                }

                var proto = map.prototype;

                Set.prototype = set.prototype = {
                    constructor: Set,
                    has: proto.has,
                    add: function (value) {
                        value += "";
                        this[prefix + value] = value;
                        return this;
                    },
                    remove: proto.remove,
                    clear: proto.clear,
                    values: proto.keys,
                    size: proto.size,
                    empty: proto.empty,
                    each: proto.each
                };

                function set(object, f) {
                    var set = new Set;

                    // Copy constructor.
                    if (object instanceof Set) object.each(function (value) {
                        set.add(value);
                    });

                    // Otherwise, assume itâ€™s an array.
                    else if (object) {
                        var i = -1, n = object.length;
                        if (f == null) while (++i < n) set.add(object[i]);
                        else while (++i < n) set.add(f(object[i], i, object));
                    }

                    return set;
                }

                function keys(map) {
                    var keys = [];
                    for (var key in map) keys.push(key);
                    return keys;
                }

                function values(map) {
                    var values = [];
                    for (var key in map) values.push(map[key]);
                    return values;
                }

                function entries(map) {
                    var entries = [];
                    for (var key in map) entries.push({
                        key: key,
                        value: map[key]
                    });
                    return entries;
                }

                exports.nest = nest;
                exports.set = set;
                exports.map = map;
                exports.keys = keys;
                exports.values = values;
                exports.entries = entries;

                Object.defineProperty(exports, '__esModule', {value: true});

            })));

        }, {}],
        109: [function (_dereq_, module, exports) {
// https://d3js.org/d3-color/ v1.4.1 Copyright 2020 Mike Bostock
            (function (global, factory) {
                typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
                    typeof define === 'function' && define.amd ? define(['exports'], factory) :
                        (global = global || self, factory(global.d3 = global.d3 || {}));
            }(this, function (exports) {
                'use strict';

                function define(constructor, factory, prototype) {
                    constructor.prototype = factory.prototype = prototype;
                    prototype.constructor = constructor;
                }

                function extend(parent, definition) {
                    var prototype = Object.create(parent.prototype);
                    for (var key in definition) prototype[key] = definition[key];
                    return prototype;
                }

                function Color() {
                }

                var darker = 0.7;
                var brighter = 1 / darker;

                var reI = "\\s*([+-]?\\d+)\\s*",
                    reN = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)\\s*",
                    reP = "\\s*([+-]?\\d*\\.?\\d+(?:[eE][+-]?\\d+)?)%\\s*",
                    reHex = /^#([0-9a-f]{3,8})$/,
                    reRgbInteger = new RegExp("^rgb\\(" + [reI, reI, reI] + "\\)$"),
                    reRgbPercent = new RegExp("^rgb\\(" + [reP, reP, reP] + "\\)$"),
                    reRgbaInteger = new RegExp("^rgba\\(" + [reI, reI, reI, reN] + "\\)$"),
                    reRgbaPercent = new RegExp("^rgba\\(" + [reP, reP, reP, reN] + "\\)$"),
                    reHslPercent = new RegExp("^hsl\\(" + [reN, reP, reP] + "\\)$"),
                    reHslaPercent = new RegExp("^hsla\\(" + [reN, reP, reP, reN] + "\\)$");

                var named = {
                    aliceblue: 0xf0f8ff,
                    antiquewhite: 0xfaebd7,
                    aqua: 0x00ffff,
                    aquamarine: 0x7fffd4,
                    azure: 0xf0ffff,
                    beige: 0xf5f5dc,
                    bisque: 0xffe4c4,
                    black: 0x000000,
                    blanchedalmond: 0xffebcd,
                    blue: 0x0000ff,
                    blueviolet: 0x8a2be2,
                    brown: 0xa52a2a,
                    burlywood: 0xdeb887,
                    cadetblue: 0x5f9ea0,
                    chartreuse: 0x7fff00,
                    chocolate: 0xd2691e,
                    coral: 0xff7f50,
                    cornflowerblue: 0x6495ed,
                    cornsilk: 0xfff8dc,
                    crimson: 0xdc143c,
                    cyan: 0x00ffff,
                    darkblue: 0x00008b,
                    darkcyan: 0x008b8b,
                    darkgoldenrod: 0xb8860b,
                    darkgray: 0xa9a9a9,
                    darkgreen: 0x006400,
                    darkgrey: 0xa9a9a9,
                    darkkhaki: 0xbdb76b,
                    darkmagenta: 0x8b008b,
                    darkolivegreen: 0x556b2f,
                    darkorange: 0xff8c00,
                    darkorchid: 0x9932cc,
                    darkred: 0x8b0000,
                    darksalmon: 0xe9967a,
                    darkseagreen: 0x8fbc8f,
                    darkslateblue: 0x483d8b,
                    darkslategray: 0x2f4f4f,
                    darkslategrey: 0x2f4f4f,
                    darkturquoise: 0x00ced1,
                    darkviolet: 0x9400d3,
                    deeppink: 0xff1493,
                    deepskyblue: 0x00bfff,
                    dimgray: 0x696969,
                    dimgrey: 0x696969,
                    dodgerblue: 0x1e90ff,
                    firebrick: 0xb22222,
                    floralwhite: 0xfffaf0,
                    forestgreen: 0x228b22,
                    fuchsia: 0xff00ff,
                    gainsboro: 0xdcdcdc,
                    ghostwhite: 0xf8f8ff,
                    gold: 0xffd700,
                    goldenrod: 0xdaa520,
                    gray: 0x808080,
                    green: 0x008000,
                    greenyellow: 0xadff2f,
                    grey: 0x808080,
                    honeydew: 0xf0fff0,
                    hotpink: 0xff69b4,
                    indianred: 0xcd5c5c,
                    indigo: 0x4b0082,
                    ivory: 0xfffff0,
                    khaki: 0xf0e68c,
                    lavender: 0xe6e6fa,
                    lavenderblush: 0xfff0f5,
                    lawngreen: 0x7cfc00,
                    lemonchiffon: 0xfffacd,
                    lightblue: 0xadd8e6,
                    lightcoral: 0xf08080,
                    lightcyan: 0xe0ffff,
                    lightgoldenrodyellow: 0xfafad2,
                    lightgray: 0xd3d3d3,
                    lightgreen: 0x90ee90,
                    lightgrey: 0xd3d3d3,
                    lightpink: 0xffb6c1,
                    lightsalmon: 0xffa07a,
                    lightseagreen: 0x20b2aa,
                    lightskyblue: 0x87cefa,
                    lightslategray: 0x778899,
                    lightslategrey: 0x778899,
                    lightsteelblue: 0xb0c4de,
                    lightyellow: 0xffffe0,
                    lime: 0x00ff00,
                    limegreen: 0x32cd32,
                    linen: 0xfaf0e6,
                    magenta: 0xff00ff,
                    maroon: 0x800000,
                    mediumaquamarine: 0x66cdaa,
                    mediumblue: 0x0000cd,
                    mediumorchid: 0xba55d3,
                    mediumpurple: 0x9370db,
                    mediumseagreen: 0x3cb371,
                    mediumslateblue: 0x7b68ee,
                    mediumspringgreen: 0x00fa9a,
                    mediumturquoise: 0x48d1cc,
                    mediumvioletred: 0xc71585,
                    midnightblue: 0x191970,
                    mintcream: 0xf5fffa,
                    mistyrose: 0xffe4e1,
                    moccasin: 0xffe4b5,
                    navajowhite: 0xffdead,
                    navy: 0x000080,
                    oldlace: 0xfdf5e6,
                    olive: 0x808000,
                    olivedrab: 0x6b8e23,
                    orange: 0xffa500,
                    orangered: 0xff4500,
                    orchid: 0xda70d6,
                    palegoldenrod: 0xeee8aa,
                    palegreen: 0x98fb98,
                    paleturquoise: 0xafeeee,
                    palevioletred: 0xdb7093,
                    papayawhip: 0xffefd5,
                    peachpuff: 0xffdab9,
                    peru: 0xcd853f,
                    pink: 0xffc0cb,
                    plum: 0xdda0dd,
                    powderblue: 0xb0e0e6,
                    purple: 0x800080,
                    rebeccapurple: 0x663399,
                    red: 0xff0000,
                    rosybrown: 0xbc8f8f,
                    royalblue: 0x4169e1,
                    saddlebrown: 0x8b4513,
                    salmon: 0xfa8072,
                    sandybrown: 0xf4a460,
                    seagreen: 0x2e8b57,
                    seashell: 0xfff5ee,
                    sienna: 0xa0522d,
                    silver: 0xc0c0c0,
                    skyblue: 0x87ceeb,
                    slateblue: 0x6a5acd,
                    slategray: 0x708090,
                    slategrey: 0x708090,
                    snow: 0xfffafa,
                    springgreen: 0x00ff7f,
                    steelblue: 0x4682b4,
                    tan: 0xd2b48c,
                    teal: 0x008080,
                    thistle: 0xd8bfd8,
                    tomato: 0xff6347,
                    turquoise: 0x40e0d0,
                    violet: 0xee82ee,
                    wheat: 0xf5deb3,
                    white: 0xffffff,
                    whitesmoke: 0xf5f5f5,
                    yellow: 0xffff00,
                    yellowgreen: 0x9acd32
                };

                define(Color, color, {
                    copy: function (channels) {
                        return Object.assign(new this.constructor, this, channels);
                    },
                    displayable: function () {
                        return this.rgb().displayable();
                    },
                    hex: color_formatHex, // Deprecated! Use color.formatHex.
                    formatHex: color_formatHex,
                    formatHsl: color_formatHsl,
                    formatRgb: color_formatRgb,
                    toString: color_formatRgb
                });

                function color_formatHex() {
                    return this.rgb().formatHex();
                }

                function color_formatHsl() {
                    return hslConvert(this).formatHsl();
                }

                function color_formatRgb() {
                    return this.rgb().formatRgb();
                }

                function color(format) {
                    var m, l;
                    format = (format + "").trim().toLowerCase();
                    return (m = reHex.exec(format)) ? (l = m[1].length, m = parseInt(m[1], 16), l === 6 ? rgbn(m) // #ff0000
                            : l === 3 ? new Rgb((m >> 8 & 0xf) | (m >> 4 & 0xf0), (m >> 4 & 0xf) | (m & 0xf0), ((m & 0xf) << 4) | (m & 0xf), 1) // #f00
                                : l === 8 ? rgba(m >> 24 & 0xff, m >> 16 & 0xff, m >> 8 & 0xff, (m & 0xff) / 0xff) // #ff000000
                                    : l === 4 ? rgba((m >> 12 & 0xf) | (m >> 8 & 0xf0), (m >> 8 & 0xf) | (m >> 4 & 0xf0), (m >> 4 & 0xf) | (m & 0xf0), (((m & 0xf) << 4) | (m & 0xf)) / 0xff) // #f000
                                        : null) // invalid hex
                        : (m = reRgbInteger.exec(format)) ? new Rgb(m[1], m[2], m[3], 1) // rgb(255, 0, 0)
                            : (m = reRgbPercent.exec(format)) ? new Rgb(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, 1) // rgb(100%, 0%, 0%)
                                : (m = reRgbaInteger.exec(format)) ? rgba(m[1], m[2], m[3], m[4]) // rgba(255, 0, 0, 1)
                                    : (m = reRgbaPercent.exec(format)) ? rgba(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, m[4]) // rgb(100%, 0%, 0%, 1)
                                        : (m = reHslPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, 1) // hsl(120, 50%, 50%)
                                            : (m = reHslaPercent.exec(format)) ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) // hsla(120, 50%, 50%, 1)
                                                : named.hasOwnProperty(format) ? rgbn(named[format]) // eslint-disable-line no-prototype-builtins
                                                    : format === "transparent" ? new Rgb(NaN, NaN, NaN, 0)
                                                        : null;
                }

                function rgbn(n) {
                    return new Rgb(n >> 16 & 0xff, n >> 8 & 0xff, n & 0xff, 1);
                }

                function rgba(r, g, b, a) {
                    if (a <= 0) r = g = b = NaN;
                    return new Rgb(r, g, b, a);
                }

                function rgbConvert(o) {
                    if (!(o instanceof Color)) o = color(o);
                    if (!o) return new Rgb;
                    o = o.rgb();
                    return new Rgb(o.r, o.g, o.b, o.opacity);
                }

                function rgb(r, g, b, opacity) {
                    return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
                }

                function Rgb(r, g, b, opacity) {
                    this.r = +r;
                    this.g = +g;
                    this.b = +b;
                    this.opacity = +opacity;
                }

                define(Rgb, rgb, extend(Color, {
                    brighter: function (k) {
                        k = k == null ? brighter : Math.pow(brighter, k);
                        return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
                    },
                    darker: function (k) {
                        k = k == null ? darker : Math.pow(darker, k);
                        return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
                    },
                    rgb: function () {
                        return this;
                    },
                    displayable: function () {
                        return (-0.5 <= this.r && this.r < 255.5)
                            && (-0.5 <= this.g && this.g < 255.5)
                            && (-0.5 <= this.b && this.b < 255.5)
                            && (0 <= this.opacity && this.opacity <= 1);
                    },
                    hex: rgb_formatHex, // Deprecated! Use color.formatHex.
                    formatHex: rgb_formatHex,
                    formatRgb: rgb_formatRgb,
                    toString: rgb_formatRgb
                }));

                function rgb_formatHex() {
                    return "#" + hex(this.r) + hex(this.g) + hex(this.b);
                }

                function rgb_formatRgb() {
                    var a = this.opacity;
                    a = isNaN(a) ? 1 : Math.max(0, Math.min(1, a));
                    return (a === 1 ? "rgb(" : "rgba(")
                        + Math.max(0, Math.min(255, Math.round(this.r) || 0)) + ", "
                        + Math.max(0, Math.min(255, Math.round(this.g) || 0)) + ", "
                        + Math.max(0, Math.min(255, Math.round(this.b) || 0))
                        + (a === 1 ? ")" : ", " + a + ")");
                }

                function hex(value) {
                    value = Math.max(0, Math.min(255, Math.round(value) || 0));
                    return (value < 16 ? "0" : "") + value.toString(16);
                }

                function hsla(h, s, l, a) {
                    if (a <= 0) h = s = l = NaN;
                    else if (l <= 0 || l >= 1) h = s = NaN;
                    else if (s <= 0) h = NaN;
                    return new Hsl(h, s, l, a);
                }

                function hslConvert(o) {
                    if (o instanceof Hsl) return new Hsl(o.h, o.s, o.l, o.opacity);
                    if (!(o instanceof Color)) o = color(o);
                    if (!o) return new Hsl;
                    if (o instanceof Hsl) return o;
                    o = o.rgb();
                    var r = o.r / 255,
                        g = o.g / 255,
                        b = o.b / 255,
                        min = Math.min(r, g, b),
                        max = Math.max(r, g, b),
                        h = NaN,
                        s = max - min,
                        l = (max + min) / 2;
                    if (s) {
                        if (r === max) h = (g - b) / s + (g < b) * 6;
                        else if (g === max) h = (b - r) / s + 2;
                        else h = (r - g) / s + 4;
                        s /= l < 0.5 ? max + min : 2 - max - min;
                        h *= 60;
                    } else {
                        s = l > 0 && l < 1 ? 0 : h;
                    }
                    return new Hsl(h, s, l, o.opacity);
                }

                function hsl(h, s, l, opacity) {
                    return arguments.length === 1 ? hslConvert(h) : new Hsl(h, s, l, opacity == null ? 1 : opacity);
                }

                function Hsl(h, s, l, opacity) {
                    this.h = +h;
                    this.s = +s;
                    this.l = +l;
                    this.opacity = +opacity;
                }

                define(Hsl, hsl, extend(Color, {
                    brighter: function (k) {
                        k = k == null ? brighter : Math.pow(brighter, k);
                        return new Hsl(this.h, this.s, this.l * k, this.opacity);
                    },
                    darker: function (k) {
                        k = k == null ? darker : Math.pow(darker, k);
                        return new Hsl(this.h, this.s, this.l * k, this.opacity);
                    },
                    rgb: function () {
                        var h = this.h % 360 + (this.h < 0) * 360,
                            s = isNaN(h) || isNaN(this.s) ? 0 : this.s,
                            l = this.l,
                            m2 = l + (l < 0.5 ? l : 1 - l) * s,
                            m1 = 2 * l - m2;
                        return new Rgb(
                            hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
                            hsl2rgb(h, m1, m2),
                            hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
                            this.opacity
                        );
                    },
                    displayable: function () {
                        return (0 <= this.s && this.s <= 1 || isNaN(this.s))
                            && (0 <= this.l && this.l <= 1)
                            && (0 <= this.opacity && this.opacity <= 1);
                    },
                    formatHsl: function () {
                        var a = this.opacity;
                        a = isNaN(a) ? 1 : Math.max(0, Math.min(1, a));
                        return (a === 1 ? "hsl(" : "hsla(")
                            + (this.h || 0) + ", "
                            + (this.s || 0) * 100 + "%, "
                            + (this.l || 0) * 100 + "%"
                            + (a === 1 ? ")" : ", " + a + ")");
                    }
                }));

                /* From FvD 13.37, CSS Color Module Level 3 */
                function hsl2rgb(h, m1, m2) {
                    return (h < 60 ? m1 + (m2 - m1) * h / 60
                        : h < 180 ? m2
                            : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60
                                : m1) * 255;
                }

                var deg2rad = Math.PI / 180;
                var rad2deg = 180 / Math.PI;

// https://observablehq.com/@mbostock/lab-and-rgb
                var K = 18,
                    Xn = 0.96422,
                    Yn = 1,
                    Zn = 0.82521,
                    t0 = 4 / 29,
                    t1 = 6 / 29,
                    t2 = 3 * t1 * t1,
                    t3 = t1 * t1 * t1;

                function labConvert(o) {
                    if (o instanceof Lab) return new Lab(o.l, o.a, o.b, o.opacity);
                    if (o instanceof Hcl) return hcl2lab(o);
                    if (!(o instanceof Rgb)) o = rgbConvert(o);
                    var r = rgb2lrgb(o.r),
                        g = rgb2lrgb(o.g),
                        b = rgb2lrgb(o.b),
                        y = xyz2lab((0.2225045 * r + 0.7168786 * g + 0.0606169 * b) / Yn),
                        x, z;
                    if (r === g && g === b) x = z = y; else {
                        x = xyz2lab((0.4360747 * r + 0.3850649 * g + 0.1430804 * b) / Xn);
             