"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connection = exports.ConnectionType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const aws_glue_1 = require("aws-cdk-lib/aws-glue");
/**
 * The type of the glue connection
 *
 * If you need to use a connection type that doesn't exist as a static member, you
 * can instantiate a `ConnectionType` object, e.g: `new ConnectionType('NEW_TYPE')`.
 */
class ConnectionType {
    constructor(name) {
        this.name = name;
    }
    /**
     * The connection type name as expected by Connection resource.
     */
    toString() {
        return this.name;
    }
}
exports.ConnectionType = ConnectionType;
_a = JSII_RTTI_SYMBOL_1;
ConnectionType[_a] = { fqn: "@aws-cdk/aws-glue-alpha.ConnectionType", version: "2.25.0-alpha.0" };
/**
 * Designates a connection to a database through Java Database Connectivity (JDBC).
 */
ConnectionType.JDBC = new ConnectionType('JDBC');
/**
 * Designates a connection to an Apache Kafka streaming platform.
 */
ConnectionType.KAFKA = new ConnectionType('KAFKA');
/**
 * Designates a connection to a MongoDB document database.
 */
ConnectionType.MONGODB = new ConnectionType('MONGODB');
/**
 * Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).
 */
ConnectionType.NETWORK = new ConnectionType('NETWORK');
/**
 * An AWS Glue connection to a data source.
 */
class Connection extends cdk.Resource {
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.connectionName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_glue_alpha_ConnectionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.properties = props.properties || {};
        const physicalConnectionRequirements = props.subnet || props.securityGroups ? {
            availabilityZone: props.subnet ? props.subnet.availabilityZone : undefined,
            subnetId: props.subnet ? props.subnet.subnetId : undefined,
            securityGroupIdList: props.securityGroups ? props.securityGroups.map(sg => sg.securityGroupId) : undefined,
        } : undefined;
        const connectionResource = new aws_glue_1.CfnConnection(this, 'Resource', {
            catalogId: cdk.Stack.of(this).account,
            connectionInput: {
                connectionProperties: cdk.Lazy.any({ produce: () => Object.keys(this.properties).length > 0 ? this.properties : undefined }),
                connectionType: props.type.name,
                description: props.description,
                matchCriteria: props.matchCriteria,
                name: props.connectionName,
                physicalConnectionRequirements,
            },
        });
        const resourceName = this.getResourceNameAttribute(connectionResource.ref);
        this.connectionArn = Connection.buildConnectionArn(this, resourceName);
        this.connectionName = resourceName;
    }
    /**
     * Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionArn arn of external connection.
     */
    static fromConnectionArn(scope, id, connectionArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.connectionName = cdk.Arn.extractResourceName(connectionArn, 'connection');
                this.connectionArn = connectionArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionName name of external connection.
     */
    static fromConnectionName(scope, id, connectionName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.connectionName = connectionName;
                this.connectionArn = Connection.buildConnectionArn(scope, connectionName);
            }
        }
        return new Import(scope, id);
    }
    static buildConnectionArn(scope, connectionName) {
        return cdk.Stack.of(scope).formatArn({
            service: 'glue',
            resource: 'connection',
            resourceName: connectionName,
        });
    }
    /**
     * Add additional connection parameters
     * @param key parameter key
     * @param value parameter value
     */
    addProperty(key, value) {
        this.properties[key] = value;
    }
}
exports.Connection = Connection;
_b = JSII_RTTI_SYMBOL_1;
Connection[_b] = { fqn: "@aws-cdk/aws-glue-alpha.Connection", version: "2.25.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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