import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface K8SNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * When set to true, allows the update of immutable fields by destroying and re-creating the node pool
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#allow_replace K8SNodePool#allow_replace}
    */
    readonly allowReplace?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#annotations K8SNodePool#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * The compute availability zone in which the nodes should exist
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#availability_zone K8SNodePool#availability_zone}
    */
    readonly availabilityZone: string;
    /**
    * CPU cores count
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#cores_count K8SNodePool#cores_count}
    */
    readonly coresCount: number;
    /**
    * CPU Family
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#cpu_family K8SNodePool#cpu_family}
    */
    readonly cpuFamily: string;
    /**
    * The UUID of the VDC
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#datacenter_id K8SNodePool#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Public IP address for the gateway performing source NAT for the node pool's nodes belonging to a private cluster. Required only if the node pool belongs to a private cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#gateway_ip K8SNodePool#gateway_ip}
    */
    readonly gatewayIp?: string;
    /**
    * The UUID of an existing kubernetes cluster
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#k8s_cluster_id K8SNodePool#k8s_cluster_id}
    */
    readonly k8SClusterId: string;
    /**
    * The desired kubernetes version
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#k8s_version K8SNodePool#k8s_version}
    */
    readonly k8SVersion: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#labels K8SNodePool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The desired name for the node pool
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#name K8SNodePool#name}
    */
    readonly name: string;
    /**
    * The number of nodes in this node pool
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#node_count K8SNodePool#node_count}
    */
    readonly nodeCount: number;
    /**
    * A list of fixed IPs. Cannot be set on private clusters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#public_ips K8SNodePool#public_ips}
    */
    readonly publicIps?: string[];
    /**
    * The amount of RAM in MB
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#ram_size K8SNodePool#ram_size}
    */
    readonly ramSize: number;
    /**
    * The total allocated storage capacity of a node in GB
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#storage_size K8SNodePool#storage_size}
    */
    readonly storageSize: number;
    /**
    * Storage type to use
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#storage_type K8SNodePool#storage_type}
    */
    readonly storageType: string;
    /**
    * auto_scaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#auto_scaling K8SNodePool#auto_scaling}
    */
    readonly autoScaling?: K8SNodePoolAutoScaling;
    /**
    * lans block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#lans K8SNodePool#lans}
    */
    readonly lans?: K8SNodePoolLans[] | cdktf.IResolvable;
    /**
    * maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#maintenance_window K8SNodePool#maintenance_window}
    */
    readonly maintenanceWindow?: K8SNodePoolMaintenanceWindow;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#timeouts K8SNodePool#timeouts}
    */
    readonly timeouts?: K8SNodePoolTimeouts;
}
export interface K8SNodePoolAutoScaling {
    /**
    * The maximum number of worker nodes that the node pool can scale to. Should be greater than min_node_count
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#max_node_count K8SNodePool#max_node_count}
    */
    readonly maxNodeCount: number;
    /**
    * The minimum number of worker nodes the node pool can scale down to. Should be less than max_node_count
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#min_node_count K8SNodePool#min_node_count}
    */
    readonly minNodeCount: number;
}
export declare function k8SNodePoolAutoScalingToTerraform(struct?: K8SNodePoolAutoScalingOutputReference | K8SNodePoolAutoScaling): any;
export declare class K8SNodePoolAutoScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): K8SNodePoolAutoScaling | undefined;
    set internalValue(value: K8SNodePoolAutoScaling | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    get minNodeCountInput(): number | undefined;
}
export interface K8SNodePoolLansRoutes {
    /**
    * IPv4 or IPv6 Gateway IP for the route
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#gateway_ip K8SNodePool#gateway_ip}
    */
    readonly gatewayIp: string;
    /**
    * IPv4 or IPv6 CIDR to be routed via the interface
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#network K8SNodePool#network}
    */
    readonly network: string;
}
export declare function k8SNodePoolLansRoutesToTerraform(struct?: K8SNodePoolLansRoutes | cdktf.IResolvable): any;
export interface K8SNodePoolLans {
    /**
    * Indicates if the Kubernetes Node Pool LAN will reserve an IP using DHCP
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#dhcp K8SNodePool#dhcp}
    */
    readonly dhcp?: boolean | cdktf.IResolvable;
    /**
    * The LAN ID of an existing LAN at the related datacenter
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#id K8SNodePool#id}
    */
    readonly id: number;
    /**
    * routes block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#routes K8SNodePool#routes}
    */
    readonly routes?: K8SNodePoolLansRoutes[] | cdktf.IResolvable;
}
export declare function k8SNodePoolLansToTerraform(struct?: K8SNodePoolLans | cdktf.IResolvable): any;
export interface K8SNodePoolMaintenanceWindow {
    /**
    * Day of the week when maintenance is allowed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#day_of_the_week K8SNodePool#day_of_the_week}
    */
    readonly dayOfTheWeek: string;
    /**
    * A clock time in the day when maintenance is allowed
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#time K8SNodePool#time}
    */
    readonly time: string;
}
export declare function k8SNodePoolMaintenanceWindowToTerraform(struct?: K8SNodePoolMaintenanceWindowOutputReference | K8SNodePoolMaintenanceWindow): any;
export declare class K8SNodePoolMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): K8SNodePoolMaintenanceWindow | undefined;
    set internalValue(value: K8SNodePoolMaintenanceWindow | undefined);
    private _dayOfTheWeek?;
    get dayOfTheWeek(): string;
    set dayOfTheWeek(value: string);
    get dayOfTheWeekInput(): string | undefined;
    private _time?;
    get time(): string;
    set time(value: string);
    get timeInput(): string | undefined;
}
export interface K8SNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#create K8SNodePool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#default K8SNodePool#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#delete K8SNodePool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool#update K8SNodePool#update}
    */
    readonly update?: string;
}
export declare function k8SNodePoolTimeoutsToTerraform(struct?: K8SNodePoolTimeoutsOutputReference | K8SNodePoolTimeouts | cdktf.IResolvable): any;
export declare class K8SNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): K8SNodePoolTimeouts | undefined;
    set internalValue(value: K8SNodePoolTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool ionoscloud_k8s_node_pool}
*/
export declare class K8SNodePool extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_k8s_node_pool";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/k8s_node_pool ionoscloud_k8s_node_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options K8SNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: K8SNodePoolConfig);
    private _allowReplace?;
    get allowReplace(): boolean | cdktf.IResolvable;
    set allowReplace(value: boolean | cdktf.IResolvable);
    resetAllowReplace(): void;
    get allowReplaceInput(): boolean | cdktf.IResolvable | undefined;
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _availabilityZone?;
    get availabilityZone(): string;
    set availabilityZone(value: string);
    get availabilityZoneInput(): string | undefined;
    private _coresCount?;
    get coresCount(): number;
    set coresCount(value: number);
    get coresCountInput(): number | undefined;
    private _cpuFamily?;
    get cpuFamily(): string;
    set cpuFamily(value: string);
    get cpuFamilyInput(): string | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    private _gatewayIp?;
    get gatewayIp(): string;
    set gatewayIp(value: string);
    resetGatewayIp(): void;
    get gatewayIpInput(): string | undefined;
    get id(): string;
    private _k8SClusterId?;
    get k8SClusterId(): string;
    set k8SClusterId(value: string);
    get k8SClusterIdInput(): string | undefined;
    private _k8SVersion?;
    get k8SVersion(): string;
    set k8SVersion(value: string);
    get k8SVersionInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _publicIps?;
    get publicIps(): string[];
    set publicIps(value: string[]);
    resetPublicIps(): void;
    get publicIpsInput(): string[] | undefined;
    private _ramSize?;
    get ramSize(): number;
    set ramSize(value: number);
    get ramSizeInput(): number | undefined;
    private _storageSize?;
    get storageSize(): number;
    set storageSize(value: number);
    get storageSizeInput(): number | undefined;
    private _storageType?;
    get storageType(): string;
    set storageType(value: string);
    get storageTypeInput(): string | undefined;
    private _autoScaling;
    get autoScaling(): K8SNodePoolAutoScalingOutputReference;
    putAutoScaling(value: K8SNodePoolAutoScaling): void;
    resetAutoScaling(): void;
    get autoScalingInput(): K8SNodePoolAutoScaling | undefined;
    private _lans?;
    get lans(): K8SNodePoolLans[] | cdktf.IResolvable;
    set lans(value: K8SNodePoolLans[] | cdktf.IResolvable);
    resetLans(): void;
    get lansInput(): cdktf.IResolvable | K8SNodePoolLans[] | undefined;
    private _maintenanceWindow;
    get maintenanceWindow(): K8SNodePoolMaintenanceWindowOutputReference;
    putMaintenanceWindow(value: K8SNodePoolMaintenanceWindow): void;
    resetMaintenanceWindow(): void;
    get maintenanceWindowInput(): K8SNodePoolMaintenanceWindow | undefined;
    private _timeouts;
    get timeouts(): K8SNodePoolTimeoutsOutputReference;
    putTimeouts(value: K8SNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): K8SNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
