# -*- coding: utf-8 -*-

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

from .datacatalog import (
    CreateEntryGroupRequest,
    CreateEntryRequest,
    CreateTagRequest,
    CreateTagTemplateFieldRequest,
    CreateTagTemplateRequest,
    DeleteEntryGroupRequest,
    DeleteEntryRequest,
    DeleteTagRequest,
    DeleteTagTemplateFieldRequest,
    DeleteTagTemplateRequest,
    Entry,
    EntryGroup,
    GetEntryGroupRequest,
    GetEntryRequest,
    GetTagTemplateRequest,
    ListEntriesRequest,
    ListEntriesResponse,
    ListEntryGroupsRequest,
    ListEntryGroupsResponse,
    ListTagsRequest,
    ListTagsResponse,
    LookupEntryRequest,
    RenameTagTemplateFieldRequest,
    SearchCatalogRequest,
    SearchCatalogResponse,
    UpdateEntryGroupRequest,
    UpdateEntryRequest,
    UpdateTagRequest,
    UpdateTagTemplateFieldRequest,
    UpdateTagTemplateRequest,
    EntryType,
)
from .gcs_fileset_spec import (
    GcsFilesetSpec,
    GcsFileSpec,
)
from .schema import (
    ColumnSchema,
    Schema,
)
from .search import (
    SearchCatalogResult,
    SearchResultType,
)
from .table_spec import (
    BigQueryDateShardedSpec,
    BigQueryTableSpec,
    TableSpec,
    ViewSpec,
    TableSourceType,
)
from .tags import (
    FieldType,
    Tag,
    TagField,
    TagTemplate,
    TagTemplateField,
)
from .timestamps import SystemTimestamps

__all__ = (
    "IntegratedSystem",
    "CreateEntryGroupRequest",
    "CreateEntryRequest",
    "CreateTagRequest",
    "CreateTagTemplateFieldRequest",
    "CreateTagTemplateRequest",
    "DeleteEntryGroupRequest",
    "DeleteEntryRequest",
    "DeleteTagRequest",
    "DeleteTagTemplateFieldRequest",
    "DeleteTagTemplateRequest",
    "Entry",
    "EntryGroup",
    "GetEntryGroupRequest",
    "GetEntryRequest",
    "GetTagTemplateRequest",
    "ListEntriesRequest",
    "ListEntriesResponse",
    "ListEntryGroupsRequest",
    "ListEntryGroupsResponse",
    "ListTagsRequest",
    "ListTagsResponse",
    "LookupEntryRequest",
    "RenameTagTemplateFieldRequest",
    "SearchCatalogRequest",
    "SearchCatalogResponse",
    "UpdateEntryGroupRequest",
    "UpdateEntryRequest",
    "UpdateTagRequest",
    "UpdateTagTemplateFieldRequest",
    "UpdateTagTemplateRequest",
    "EntryType",
    "GcsFilesetSpec",
    "GcsFileSpec",
    "ColumnSchema",
    "Schema",
    "SearchCatalogResult",
    "SearchResultType",
    "BigQueryDateShardedSpec",
    "BigQueryTableSpec",
    "TableSpec",
    "ViewSpec",
    "TableSourceType",
    "FieldType",
    "Tag",
    "TagField",
    "TagTemplate",
    "TagTemplateField",
    "SystemTimestamps",
)
